package com.orbisalert.Activity;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.orbisalert.R;
import com.orbisalert.Util.Utility;

public class DeviceInfoScreen extends OrbisActivity implements View.OnClickListener, View.OnTouchListener {

    TextView tv_device_id, tv_iemi, tv_serialno, tv_carrier, tv_model, tv_version;
    ImageView iv_back;
    TelephonyManager tManager;
    RelativeLayout rl_device_info;


    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP_MR1)
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_device_info_screen);
        Utility.status_bar_color_change(this);
        intialize_ID();
        device_ID();

    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP_MR1)
    private void device_ID() {

        try {
            // GET DEVICE ID
            final String deviceId = Settings.Secure.getString(getContentResolver(),
                    Settings.Secure.ANDROID_ID);
            tv_device_id.setText(deviceId);

            // GET IMEI NUMBER
            tManager = (TelephonyManager) getBaseContext()
                    .getSystemService(Context.TELEPHONY_SERVICE);
            String deviceIMEI = tManager.getDeviceId();
            tv_iemi.setText(deviceIMEI);

            //Device modelno
            String reqString = Build.MANUFACTURER
                    + " " + Build.MODEL + " " + Build.VERSION.RELEASE
                    + " " + Build.VERSION_CODES.class.getFields()[android.os.Build.VERSION.SDK_INT].getName();
            tv_model.setText(Build.MODEL);
            //carrier info
            String carrierName = tManager.getNetworkOperatorName();
            tv_carrier.setText(carrierName);
            //version of device
            int version = Build.VERSION.SDK_INT;
            String versionRelease = Build.VERSION.RELEASE;
            tv_version.setText(versionRelease);
            //serial no
            String simSerialNo = tManager.getSimSerialNumber();
            tv_serialno.setText(simSerialNo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void intialize_ID() {
        rl_device_info = (RelativeLayout) findViewById(R.id.rl_device_info);
        rl_device_info.setOnTouchListener(this);
        tv_device_id = (TextView) findViewById(R.id.tv_device_id);
        tv_iemi = (TextView) findViewById(R.id.tv_iemi);
        tv_serialno = (TextView) findViewById(R.id.tv_serialno);
        tv_carrier = (TextView) findViewById(R.id.tv_carrier);
        tv_model = (TextView) findViewById(R.id.tv_model);
        tv_version = (TextView) findViewById(R.id.tv_version);
        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_back:
                Intent intent = new Intent(DeviceInfoScreen.this, TabHostActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();

                break;
            default:
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.
                INPUT_METHOD_SERVICE);
        if (getCurrentFocus() != null) {
            imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
        }


        return true;
    }
}
