package com.orbisalert.net;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;

import com.orbisalert.Activity.GlobalConstants;


/**
 * Created by admin on 9/9/17.
 */

public class UpdateLocationIntentService extends IntentService {

    Context context;
    PowerManager powerManager;
    PowerManager.WakeLock wakeLock;
    final int SDK_INT = Build.VERSION.SDK_INT;
    AlarmManager alarmManager;
    PendingIntent pendingIntent;
    Intent alarm;
    GPSTracker gps;
    SharedPreferences preferences;

    public UpdateLocationIntentService() {
        super("");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        powerManager = (PowerManager) getSystemService(POWER_SERVICE);
        wakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "FCFCFCFC");

        wakeLock.acquire();
        preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        gps = new GPSTracker(UpdateLocationIntentService.this);
        double latitude = gps.getLatitude();
        double longitude = gps.getLongitude();
        SharedPreferences.Editor ed = preferences.edit();
        ed.putString("Triggerfrom", "PUD");
        ed.commit();

        Log.e("START SERVICE", "UpdateLocationIntentServ");

        try {


            if (latitude != 0.0) {

                SharedPreferences.Editor editor = preferences.edit();
                editor.remove("currentLATTITUDE");
                editor.apply();
                editor.putString("currentLATTITUDE", String.valueOf(latitude));
                editor.commit();

            }
            if (longitude != 0.0) {

                SharedPreferences.Editor editor = preferences.edit();
                editor.remove("currentLONGITUDE");
                editor.apply();
                editor.putString("currentLONGITUDE", String.valueOf(longitude));
                editor.commit();
            }

        } catch (Exception e) {
            e.printStackTrace();
        }


        sendDATA(latitude, longitude);

    }

    private void sendDATA(double ll, double lng) {
        try {

            if (ll == 0.0) {
                ll = Double.parseDouble(preferences.getString("currentLATTITUDE", ""));

            } else {

            }

            if (lng == 0.0) {
                lng = Double.parseDouble(preferences.getString("currentLONGITUDE", ""));

            } else {

            }


            TriggerSignal.sendTriggerSignal(UpdateLocationIntentService.this, "", "");
            Update_locationCall.sendUpdateSignal(UpdateLocationIntentService.this, ll, lng);

            Log.e("START SERVICE", String.valueOf(ll));
            Log.e("START SERVICE", String.valueOf(lng));
            // startRepeatingTask();
            Log.e("Update", "Loc Service");

        } catch (Exception e) {
            Log.v("fserviceerror", "erre");
        }

        reSETALARAM();
        wakeLock.release();
    }

    private void reSETALARAM() {
        alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
        alarm = new Intent(this, UpdateLocationIntentService.class);
        pendingIntent = PendingIntent.getService(this, 0, alarm, 0);
        int interval = 1000 * 60 * 15;

        if (SDK_INT < Build.VERSION_CODES.KITKAT) {
            alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
            Log.d("lowerFS", "hahah");
        } else if (Build.VERSION_CODES.KITKAT <= SDK_INT && SDK_INT < Build.VERSION_CODES.M) {
            alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
            Log.d("kitkatFS", "hahah");
        } else if (SDK_INT >= Build.VERSION_CODES.M) {
            alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
            Log.d("marshmallowFS", "hahah");
        }
    }

}