package com.orbisalert.net;

import android.content.Context;

import com.orbisalert.Activity.GlobalConstants;

import com.orbisalert.Model.EsclationBeans;
import com.orbisalert.Model.KillSignalBeans;
import com.orbisalert.Model.LocationUpdateBeans;
import com.orbisalert.Model.LoginBeans;
import com.orbisalert.Model.SettingBeans;
import com.orbisalert.Model.SignalBeans;
import com.orbisalert.Model.TriggerSignalBeans;
import com.orbisalert.Model.VerifyBeans;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;


import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;
import retrofit2.http.Query;


public class WebRequest {
    private static Context mContext;
    private static WebRequest mWebrequest;
    public static APIInterface apiInterface;

    public static WebRequest getSingleton(Context context) {
        if (mWebrequest == null) {
            synchronized ((WebRequest.class)) {
                if (mWebrequest == null) {
                    mWebrequest = new WebRequest(context);
                }
            }
        }
        return mWebrequest;
    }

    public WebRequest(Context context) {
        apiInterface = RestClient.getClient();
        mContext = context;
    }

    private static class RestClient {
        private static APIInterface apiInterface;

        public static APIInterface getClient() {
            if (apiInterface == null) {
                Gson gson = new GsonBuilder()
                        .setLenient()
                        .create();

                OkHttpClient client = new OkHttpClient.Builder().
                        connectTimeout(30, TimeUnit.SECONDS).
                        readTimeout(30, TimeUnit.SECONDS).
                        writeTimeout(30, TimeUnit.SECONDS).
                        build();

                Retrofit retrofit = new Retrofit.Builder()
                        .baseUrl(GlobalConstants.SERVER_URL)
                        .addConverterFactory(ScalarsConverterFactory.create())
                        .client(client)
                        .addConverterFactory(GsonConverterFactory.create(gson))
                        .build();

                apiInterface = retrofit.create(APIInterface.class);
            }
            return apiInterface;
        }
    }

    public interface APIInterface {
        @POST("user/")
        Call<LoginBeans>userLogin(@Query("number") String number);


        @FormUrlEncoded
        @POST("user/verify_otp/?")
        Call<VerifyBeans>verifyOTP(@Field("number") String number, @Field("app_type") String apptype, @Field("device_type") String device_type, @Field("device_id") String device_id, @Field("device_token") String device_token, @Field("otp") String otp);

//        @POST("signals/new_signal/?")
//        Call<SignalBeans>signal(@Query("datetime") String datetime, @Query("imei") String imei, @Query("number") String number, @Query("messageType") String messageType, @Query("lat") String lat, @Query("long") String lng, @Query("posdatatime") String posdatatime, @Query("postype") String postype, @Query("status") String status, @Query("interval") String interval, @Query("speed") String speed);



        @POST("signals/?")
        Call<SignalBeans>signal(@Query("datetime") String datetime, @Query("imei") String imei, @Query("number") String number, @Query("messageType") String messageType, @Query("lat") String lat, @Query("long") String lng, @Query("posdatatime") String posdatatime, @Query("postype") String postype, @Query("status") String status, @Query("interval") String interval, @Query("speed") String speed);

        @FormUrlEncoded
         @POST("user/location_update/?")
       // @POST("user/new_location_update/?")
        Call<LocationUpdateBeans>userLocationUpdate(@Field("ref_id") String ref_id, @Field("lat") String lat, @Field("long") String lng, @Field("datetime") String datetime, @Field("imei") String imei, @Field("number") String number, @Field("messageType") String messageType, @Field("posdatatime") String posdatatime, @Field("postype") String postype, @Field("status") String status, @Field("interval") String interval, @Field("speed") String speed);

        /*Setting*/
        @POST("user/get_setting_lwd/?")
        Call<SettingBeans>setting(@Query("ref") String ref);


        @POST("user/check_signal/?")
        Call<KillSignalBeans>killSignal(@Query("ref") String ref);


        /*Esclation APi Get*/

        @POST("user/profile_download/?")
        Call<EsclationBeans>EsclationDetail(@Query("ref") String ref);

        @FormUrlEncoded
        @POST("signals/check_trigger/?")
       // @POST("signals/new_check_trigger/?")
        Call<TriggerSignalBeans>getSignal(@Field("ref_id") String ref_id, @Field("lat") String lat, @Field("long") String lng, @Field("datetime") String datetime, @Field("imei") String imei, @Field("number") String number, @Field("messageType") String messageType, @Field("posdatatime") String posdatatime, @Field("postype") String postype, @Field("status") String status, @Field("interval") String interval, @Field("speed") String speed, @Field("trigger_from") String trigger_from);

    }
}
