package com.orbisalert.notifications;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.orbisalert.Activity.GlobalConstants;

/**
 * Created by Admin....
 */

public class MyFirebaseInstanceIDService extends FirebaseInstanceIdService {

    private static final String TAG = "MyFirebaseIIDService";
    SharedPreferences preferences;
    SharedPreferences.Editor editor;

    @Override
    public void onTokenRefresh() {

        //Getting registration token
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();

        //Displaying token on logcat
        Log.d(TAG, "Refreshed token: " + refreshedToken);

    }

    private void sendRegistrationToServer(String token) {
        //You can implement this method to store the token on your server
        //Not required for current project
        Log.e("token",""+token);
        preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        editor = preferences.edit();
        editor.putString("FCMTOKEN", token);
        editor.commit();
    }
}
