package com.orbis.Activity;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.orbis.Adapter.RecyclerListAdapter;
import com.orbis.Adapter.SimpleItemTouchHelperCallback;
import com.orbis.Model.EscalationDetail;
import com.orbis.Model.EscalationDetailDataBeans;
import com.orbis.Model.escalation.EscalationMain;
import com.orbis.R;
import com.orbis.Util.Utility;
import com.orbis.interfaces.OnStartDragListener;
import com.orbis.net.WebRequest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class EscalationScreen extends OrbisActivity implements View.OnClickListener, OnStartDragListener {
    TextView contact_name1, contact_name2, contact_name3;
    ImageView iv_back, iv_add;
    EditText contact1, contact2, contact3;
    String name1 = "", phone_number1 = "", name2 = "", phone_number2 = "", name3 = "", phone_number3 = "";
    android.support.v7.widget.RecyclerView recyclerView;
    Button btn_Update;
    public static String dash_Escalation;
    private String indexstatus = "";
    RelativeLayout rl_escalationMain;

    WebRequest mWebrequest;
    Call<EscalationDetail> esclationResponseCall;
    private EscalationDetail esclationResponse;
    private List<EscalationDetailDataBeans> addEscalationDetailList = new ArrayList<EscalationDetailDataBeans>();

    public List<EscalationDetailDataBeans> compareList = new ArrayList<EscalationDetailDataBeans>();
    private ItemTouchHelper mItemTouchHelper;
    RecyclerListAdapter adapter;

    private SharedPreferences preferences;
    static ProgressDialog progressDialog;

    EscalationDetailDataBeans escalationDetailDataBeans;
    OnStartDragListener onStartDragListener;
    View view1;
    String message;
    public String subject = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_esclation_screen);
        Utility.status_bar_color_change(this);
        recyclerView = (RecyclerView) findViewById(R.id.RecyclerView);
        onStartDragListener = this;
        try {
            Intent i = getIntent();
            dash_Escalation = getIntent().getExtras().getString("dashescalation");
            indexstatus = preferences.getString("L_INDEX", "");

        } catch (Exception e) {
            e.printStackTrace();
        }
        //   showFragment(RecyclerListFragment.newInstance(), dash_Escalation);
        intialize_ID();
//        recyclerView.addOnItemTouchListener(
//                new RecyclerItemClickListener(this, recyclerView, new RecyclerItemClickListener.OnItemClickListener() {
//                    @Override
//                    public void onItemClick(View view, final int position) {
//                    ImageView    iv_EditEscalation = (ImageView) view.findViewById(R.id.iv_EditEscalation);
//                    iv_EditEscalation.setOnClickListener(new View.OnClickListener() {
//                        @Override
//                        public void onClick(View view) {
//
//                        }
//                    });
//
//                    }
//
//                    @Override
//                    public void onLongItemClick(View view, int position) {
//                        // do whatever
//                    }
//                })
//        );
        getEscalationDetailData1(EscalationScreen.this);

    }


    private void intialize_ID() {
        rl_escalationMain = (RelativeLayout) findViewById(R.id.rl_escalationMain);
        contact_name1 = (TextView) findViewById(R.id.tv_contact_name);
        contact1 = (EditText) findViewById(R.id.et_contact_name);
        contact_name2 = (TextView) findViewById(R.id.tv_contact_name2);
        contact2 = (EditText) findViewById(R.id.et_contact_name2);
        contact_name3 = (TextView) findViewById(R.id.tv_contact_name3);
        contact3 = (EditText) findViewById(R.id.et_contact_name3);
        iv_add = (ImageView) findViewById(R.id.iv_add);

        try {
            name1 = preferences.getString("name1", "");
            phone_number1 = preferences.getString("phone_number1", "");
            Log.e("********", name1);
            Log.e("********", phone_number1);
            name2 = preferences.getString("name2", "");
            phone_number2 = preferences.getString("phone_number2", "");
            Log.e("********", name2);
            Log.e("********", phone_number2);
            name3 = preferences.getString("name3", "");
            phone_number3 = preferences.getString("phone_number3", "");

            /**
             * Set Server data
             */
            contact_name1.setText(name1);
            contact1.setText(phone_number1);
            contact_name2.setText(name2);
            contact2.setText(phone_number2);
            contact_name3.setText(name3);
            contact3.setText(phone_number3);

        } catch (Exception e) {
            e.printStackTrace();
        }

        iv_back = (ImageView) findViewById(R.id.iv_back);
        iv_back.setOnClickListener(this);
        btn_Update = (Button) findViewById(R.id.btn_Update);
        btn_Update.setOnClickListener(this);
        iv_add.setOnClickListener(this);
    }

    public void delete(int position) {
        subject = "Escalation Contact Deleted";
        WebRequest mWebrequest;
        mWebrequest = WebRequest.getSingleton(EscalationScreen.this);
        JsonArray array = new JsonArray();
        for (int i = 0; i < adapter.detailList.size(); i++) {
            if (i != position) {
                int j = 0;
                j = i;
                JsonObject object = new JsonObject();
                object.addProperty("FULLNAME", adapter.detailList.get(i).getFULLNAME());
                object.addProperty("EMAIL", adapter.detailList.get(i).getEMAIL());
                object.addProperty("MOBILE", adapter.detailList.get(i).getMOBILE());
                object.addProperty("BUSINESSTELEPHONE", adapter.detailList.get(i).getBUSINESSTELEPHONE());
                object.addProperty("HOMETELEPHONE", adapter.detailList.get(i).getHOMETELEPHONE());
                object.addProperty("SITEINDEX", adapter.detailList.get(i).getSITEINDEX());
                object.addProperty("PRIORITY", "" + ++j);
                array.add(object);
            }
        }


// Loop arrayList2 items
        Log.e("object", "" + array.toString());
        Call<EscalationMain> esclationResponseCall = mWebrequest.apiInterface.escalationMail(array.toString(), subject);
        esclationResponseCall.enqueue(new Callback<EscalationMain>() {
            @Override
            public void onResponse(Call<EscalationMain> call, Response<EscalationMain> response) {
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    subject = "";
                    dismissProgressDialog();
                }
            }

            @Override
            public void onFailure(Call<EscalationMain> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
                Log.e("ERROE***", t.getMessage());
            }
        });
    }

    public void edit(int position) {
        Intent intent = new Intent(EscalationScreen.this, EscalationEditActivity.class);
        intent.putExtra("data", adapter.detailList.get(position));
        intent.putExtra("pos", position);
        intent.putExtra("dashescalation", "" + position);
        startActivityForResult(intent, 200);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_add:
                if (addEscalationDetailList.size() > 0) {
                    Intent intent = new Intent(EscalationScreen.this, EscalationEditActivity.class);
                    intent.putExtra("dashescalation", "0");
                    Bundle args = new Bundle();
                    args.putSerializable("ARRAYLIST", (Serializable) adapter.detailList);
                    intent.putExtra("BUNDLE", args);
                    startActivity(intent);
                    finish();
                } else {
                    Utility.alertDialog(EscalationScreen.this, "lindex is empty");
                }
                break;
            case R.id.iv_back:
                onBackPressed();
                break;
            case R.id.btn_Update:
                if (compareList.size() > 0) {
                    showProgressDialog(EscalationScreen.this, "Processing...");
                    Utility.alertDialog(EscalationScreen.this, "Escalation details updated successfully! Escalation Details updates take up to 24 hours to be completed.");
                    updateEscalation();
                } else {
                    Utility.alertDialog(EscalationScreen.this, "lindex is empty");
                }
                break;
            default:
        }
    }

    public void updateEscalation() {

        boolean found = true;

        if (adapter.detailList.size() == compareList.size()) {
            for (int i = 0; i < adapter.detailList.size(); i++) {
                // Loop arrayList1 items
                if (!adapter.detailList.get(i).getPRIORITY().equals(compareList.get(i).getPRIORITY())) {
                    found = false;
                }
            }
            if (!found) {
                if (!subject.equals("Escalation Details Change Request") && !subject.equals("Priority and Escalation Details Change Request")) {
                    subject = "Priority Change Request";
                }
                if (subject.equals("Escalation Details Change Request")) {
                    subject = "Priority and Escalation Details Change Request";
                }
            }
        } else {
            subject = "Escalation change/Delete Request";
        }
        WebRequest mWebrequest;
        mWebrequest = WebRequest.getSingleton(EscalationScreen.this);
        JsonArray array = new JsonArray();
        for (int i = 0; i < adapter.detailList.size(); i++) {
            int j = 0;
            j = i;
            JsonObject object = new JsonObject();
            object.addProperty("FULLNAME", adapter.detailList.get(i).getFULLNAME());
            object.addProperty("EMAIL", adapter.detailList.get(i).getEMAIL());
            object.addProperty("MOBILE", adapter.detailList.get(i).getMOBILE());
            object.addProperty("BUSINESSTELEPHONE", adapter.detailList.get(i).getBUSINESSTELEPHONE());
            object.addProperty("HOMETELEPHONE", adapter.detailList.get(i).getHOMETELEPHONE());
            object.addProperty("SITEINDEX", adapter.detailList.get(i).getSITEINDEX());
            object.addProperty("PRIORITY", "" + ++j);
            array.add(object);
        }
// Loop arrayList2 items
        Log.e("object", "" + array.toString());
        Call<EscalationMain> esclationResponseCall = mWebrequest.apiInterface.escalationMail(array.toString(), subject);
        esclationResponseCall.enqueue(new Callback<EscalationMain>() {
            @Override
            public void onResponse(Call<EscalationMain> call, Response<EscalationMain> response) {
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    subject = "";
                    dismissProgressDialog();
                    getEscalationDetailData12(EscalationScreen.this);
                }
            }

            @Override
            public void onFailure(Call<EscalationMain> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
                Log.e("ERROE***", t.getMessage());
            }
        });

    }

    public void previousActivity() {
        Intent intent = new Intent(EscalationScreen.this, TabHostActivity.class);
        intent.putExtra("tab", 0);
        startActivity(intent);
        finish();
    }


    @Override
    public void onBackPressed() {
        if (dash_Escalation.equalsIgnoreCase("1")) {
            previousActivity();
        } else if (dash_Escalation.equalsIgnoreCase("0")) {
            Intent intent = new Intent(EscalationScreen.this, SettingScreen.class);
            startActivity(intent);
            finish();
        } else {
            previousActivity();
        }

    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void onStartDrag(RecyclerView.ViewHolder viewHolder) {
        mItemTouchHelper.startDrag(viewHolder);
    }

    public void getEscalationDetailData1(Context context) {
        context = context;
        progressDialog = new ProgressDialog(context);
        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        indexstatus = preferences.getString("L_INDEX", "");
        esclationResponseCall = mWebrequest.apiInterface.escalationDetailData(indexstatus);
        getEscalationGetDetailResponse(esclationResponseCall, context);
    }

    //add Lead response
    private void getEscalationGetDetailResponse(Call<EscalationDetail> escalationResp, Context context) {
        showProgressDialog(context, "Processing...");
        escalationResp.enqueue(new Callback<EscalationDetail>() {
            @Override
            public void onResponse(Call<EscalationDetail> call, Response<EscalationDetail> response) {
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    esclationResponse = response.body();
                    String status = response.body().getStatus().toString();
                    message = response.body().getMessage().toString();
                    Log.e("**SERVR*****", response.body().getMessage().toString());
                    if (status.equalsIgnoreCase("1")) {
                        addEscalationDetailList.clear();
                        addEscalationDetailList.addAll(response.body().getData());
                        compareList.clear();
                        compareList.addAll(response.body().getData());

                        for (int i = 0; i < addEscalationDetailList.size(); i++) {
                            Log.e("Email Addresss", addEscalationDetailList.get(i).getEMAIL());
                        }
                        Collections.sort(addEscalationDetailList, new Comparator() {
                            @Override
                            public int compare(Object o1, Object o2) {
                                EscalationDetailDataBeans p1 = (EscalationDetailDataBeans) o1;
                                EscalationDetailDataBeans p2 = (EscalationDetailDataBeans) o2;
                                return p1.getPRIORITY().compareToIgnoreCase(p2.getPRIORITY());
                            }
                        });

                        adapter = new RecyclerListAdapter(EscalationScreen.this, addEscalationDetailList, onStartDragListener, dash_Escalation, EscalationScreen.this);
                        recyclerView.setAdapter(adapter);
                        recyclerView.setLayoutManager(new LinearLayoutManager(EscalationScreen.this));
                        ItemTouchHelper.Callback callback = new SimpleItemTouchHelperCallback(adapter);
                        mItemTouchHelper = new ItemTouchHelper(callback);
                        mItemTouchHelper.attachToRecyclerView(recyclerView);
                        adapter.notifyDataSetChanged();
                    }
                } else {
                    dismissProgressDialog();
                }
            }

            @Override
            public void onFailure(Call<EscalationDetail> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
                Log.e("ERROE***", t.getMessage());
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != 0) {
            if (requestCode == 200) {
                if (!data.hasExtra("edit")) {
                    if (data.hasExtra("change")) {
                        if (data.getExtras().getBoolean("change")) {
                            if (!subject.equals("Escalation Details Change Request") && !subject.equals("Priority and Escalation Details Change Request")) {
                                subject = "Escalation Details Change Request";
                            }
                            if (subject.equals("Priority Change Request")) {
                                subject = "Priority and Escalation Details Change Request";
                            }
                        }
                    }
                    //   dash_Escalation = data.getExtras().getString("dashescalation");
                    EscalationDetailDataBeans escalationDetailDataBeans = (EscalationDetailDataBeans) data.getExtras().get("data");
                    int position = data.getExtras().getInt("pos");
                    adapter.detailList.set(position, escalationDetailDataBeans);
                } else {
                    EscalationDetailDataBeans escalationDetailDataBeans = (EscalationDetailDataBeans) data.getExtras().get("data");
                    adapter.detailList.add(escalationDetailDataBeans);
                    compareList.add(escalationDetailDataBeans);

                }

                adapter.notifyDataSetChanged();
            }
        }
    }


    public void getEscalationDetailData12(Context context) {
        context = context;
        progressDialog = new ProgressDialog(context);
        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        indexstatus = preferences.getString("L_INDEX", "");
        esclationResponseCall = mWebrequest.apiInterface.escalationDetailData(indexstatus);
        getEscalationGetDetailResponse1(esclationResponseCall, context);
    }

    //add Lead response
    private void getEscalationGetDetailResponse1(Call<EscalationDetail> escalationResp, Context context) {
        escalationResp.enqueue(new Callback<EscalationDetail>() {
            @Override
            public void onResponse(Call<EscalationDetail> call, Response<EscalationDetail> response) {
                if (response.isSuccessful()) {
                    esclationResponse = response.body();
                    String status = response.body().getStatus().toString();
                    message = response.body().getMessage().toString();
                    Log.e("**SERVR*****", response.body().getMessage().toString());
                    if (status.equalsIgnoreCase("1")) {
                        addEscalationDetailList.clear();
                        addEscalationDetailList.addAll(response.body().getData());
                        compareList.clear();
                        compareList.addAll(response.body().getData());

                        for (int i = 0; i < addEscalationDetailList.size(); i++) {
                            Log.e("Email Addresss", addEscalationDetailList.get(i).getEMAIL());
                        }
                        Collections.sort(addEscalationDetailList, new Comparator() {
                            @Override
                            public int compare(Object o1, Object o2) {
                                EscalationDetailDataBeans p1 = (EscalationDetailDataBeans) o1;
                                EscalationDetailDataBeans p2 = (EscalationDetailDataBeans) o2;
                                return p1.getPRIORITY().compareToIgnoreCase(p2.getPRIORITY());
                            }
                        });

                        adapter = new RecyclerListAdapter(EscalationScreen.this, addEscalationDetailList, onStartDragListener, dash_Escalation, EscalationScreen.this);
                        recyclerView.setAdapter(adapter);
                        recyclerView.setLayoutManager(new LinearLayoutManager(EscalationScreen.this));
                        ItemTouchHelper.Callback callback = new SimpleItemTouchHelperCallback(adapter);
                        mItemTouchHelper = new ItemTouchHelper(callback);
                        mItemTouchHelper.attachToRecyclerView(recyclerView);
                        adapter.notifyDataSetChanged();
                    }
                } else {

                }
            }

            @Override
            public void onFailure(Call<EscalationDetail> call, Throwable t) {
                t.printStackTrace();
                Log.e("ERROE***", t.getMessage());
            }
        });
    }

}