package com.orbis.Activity;

import android.app.AlarmManager;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.ColorDrawable;
import android.location.LocationManager;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.iid.FirebaseInstanceId;
import com.orbis.Model.LoginASMBeans;
import com.orbis.Model.LoginBeans;
import com.orbis.Model.UserDataBeans;
import com.orbis.Model.VerifyBeans;
import com.orbis.Model.Verify_otp_beans;
import com.orbis.R;
import com.orbis.Util.SOSService;
import com.orbis.Util.ScreenSaverService;
import com.orbis.Util.Utility;
import com.orbis.net.GPSTracker;
import com.orbis.net.KillSignalAPICall;
import com.orbis.net.PwonSignal;
import com.orbis.net.SettingsAPICall;
import com.orbis.net.TriggerSignal;
import com.orbis.net.UpdateLocationIntentService;
import com.orbis.net.Update_locationCall;
import com.orbis.net.WebRequest;
import com.stfalcon.smsverifycatcher.OnSmsCatchListener;
import com.stfalcon.smsverifycatcher.SmsVerifyCatcher;

import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoginScreen extends OrbisActivity implements View.OnClickListener, View.OnTouchListener {
    TextView tv_login;
    WebRequest mWebrequest;
    EditText et_phone;
    Dialog dialog1;
    RelativeLayout rl_phone, rl_login1;
    Button btn_cancel_otp, btn_login_otp;
    EditText et_otp;

    /*WITHOUT ASM SERVICE*/
    Call<LoginBeans> loginResponseCall;
    LoginBeans loginResponse;
    Call<VerifyBeans> otpverify_ResponseCall;
    VerifyBeans verify_otpresponse;


    /*ASM SERVICE*/
    Call<List<LoginASMBeans>> loginResponseCall_ASM;
    List<LoginASMBeans> loginResponse_ASM;
    Call<Verify_otp_beans> otpverify_ResponseCall_ASM;
    Verify_otp_beans verify_otpresponse_ASM;

    ImageView btn_login;
    String get_otp;
    String number, device_id, device_token;
    String device_type = "android";
    TextView resend_otp;
    String first_time = "";
    String ref_id = "", app_type = "HS2", lindex = "";
    String fcmstatus = "", fcmmessage = "";
    Timer timer = new Timer();
    String ref_id1 = "";
    GPSTracker gps;
    public final static int INTERVAL_update = 1000 * 60 * 5; //5 minutes
    AlarmManager alarmManager;
    PendingIntent pendingIntent;
    Calendar calendar;
    Intent alarm;
    final int SDK_INT = Build.VERSION.SDK_INT;
    double latt, lngg;
    String lat, lng;
    private NfcAdapter mNfcAdapter;
    SmsVerifyCatcher smsVerifyCatcher;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login_screen);
        smsVerifyCatcher = new SmsVerifyCatcher(this, new OnSmsCatchListener<String>() {
            @Override
            public void onSmsCatch(String message) {
                et_otp.setText(message);//set code in edit text
                //then you can send verification code to server
            }
        });
      //  smsVerifyCatcher.setFilter("<IM-SMSINF>");
        mWebrequest = WebRequest.getSingleton(LoginScreen.this);
        dialog1 = new Dialog(LoginScreen.this);
        // FirebaseInstanceId.getInstance().getToken();

        fcmstatus = preferences.getString("FCMSignalStatusHS2", "");
        fcmmessage = preferences.getString("FCMSignalmessageHS2", "");
        //changing statusbar color
        Utility.status_bar_color_change(LoginScreen.this);
        try {
            mNfcAdapter = NfcAdapter.getDefaultAdapter(this);
            if (!mNfcAdapter.isEnabled()) {
                checkPermissions();
                Show_NFCALERT();
            }

            gps = new GPSTracker(this);
            LocationManager lm = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
            boolean gps_enabled = false;
            boolean network_enabled = false;

            try {
                gps_enabled = lm.isProviderEnabled(LocationManager.GPS_PROVIDER);
            } catch (Exception ex) {
            }

            try {
                network_enabled = lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            } catch (Exception ex) {
            }

            if (!gps_enabled && !network_enabled) {
                // notify user
                AlertDialog.Builder dialog = new AlertDialog.Builder(LoginScreen.this);
                dialog.setMessage(this.getResources().getString(R.string.gps_network_not_enabled));
                dialog.setPositiveButton(this.getResources().getString(R.string.open_location_settings), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub
                        Intent myIntent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                        startActivity(myIntent);
                        //get gps
                    }
                });
                dialog.setNegativeButton(this.getString(R.string.cccancel), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub

                    }
                });
                dialog.show();
            }


        } catch (Exception e) {
            e.printStackTrace();
        }


        //find view by id
        intialize_ID();

    }
    @Override
    protected void onStart() {
        super.onStart();
        smsVerifyCatcher.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
        smsVerifyCatcher.onStop();
    }

    /**
     * need for Android 6 real time permissions
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        smsVerifyCatcher.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
    private void Show_NFCALERT() {
        try {
            AlertDialog.Builder dialog = new AlertDialog.Builder(LoginScreen.this);
            dialog.setMessage(this.getResources().getString(R.string.nfc_not_enabled));
            dialog.setPositiveButton(this.getResources().getString(R.string.open_nfc_settings), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                    // TODO Auto-generated method stub
                    Intent myIntent = new Intent(Settings.ACTION_NFC_SETTINGS);
                    //startActivity(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS));
                    startActivity(myIntent);
                    //get gps
                }
            });
            dialog.setNegativeButton(this.getString(R.string.cccancel), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                    // TODO Auto-generated method stub

                }
            });
            dialog.show();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void intialize_ID() {
        //Get Device ID
        device_id = Settings.Secure.getString(LoginScreen.this.getContentResolver(), Settings.Secure.ANDROID_ID);
        /* device_token=preferences.getString("refreshedToken", "");*/
        Log.e("8888888", device_id);

        rl_login1 = (RelativeLayout) findViewById(R.id.rl_login1);
        rl_login1.setOnTouchListener(this);
        btn_login = (ImageView) findViewById(R.id.btn_login);
        btn_login.setOnClickListener(this);
        rl_phone = (RelativeLayout) findViewById(R.id.rl_phone);
        rl_phone.getBackground().setAlpha(45);
        et_phone = (EditText) findViewById(R.id.et_phone);
        tv_login = (TextView) findViewById(R.id.tv_login);
        Utility.text_font_helvetica(this, tv_login);
        //new <code></code>
        try {
            gps = new GPSTracker(LoginScreen.this);
            lat = String.valueOf(gps.getLatitude());
            lng = String.valueOf(gps.getLongitude());
            Log.e("Login========", lat);
            Log.e("Login========", lng);

            if (lat.equalsIgnoreCase("0.0")) {

                lat = preferences.getString("currentLATTITUDE", "");
                Log.e("+++++++", lat);

            } else {

            }

            if (lng.equalsIgnoreCase("0.0")) {

                lng = preferences.getString("currentLONGITUDE", "");
                Log.e("+++++++", lng);

            } else {

                Log.e("+++++++", lng);
            }


        } catch (Exception e) {
            e.printStackTrace();

        }

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btn_login:
                Log.e("BTNNNNNNNNNNNNN", "");
                if (isNetworkAvailable()) {
                    try {
                        if (et_phone.getText().toString().equalsIgnoreCase("")) {
                            showToast("Please enter phone number");
                            et_phone.requestFocus();
                        } else {
                            if (fcmstatus.equalsIgnoreCase("0")) {
                                Log.e("ENTER SIGNAL NOT A LLOWED", "===");
                            } else {
                                number = et_phone.getText().toString().trim();
                                SharedPreferences.Editor editor = preferences.edit();
                                editor.putString("NUMBER", number);
                                editor.commit();

                                /*WITHOUT ASM SERVICE*/
                                login(number);

                                /*ASM SERVICE*/
                                // loginASM(number);



                                /*double lattitude = gps.getLatitude();
                                if (gps.getLatitude() == 0.0) {
                                    showAlert();
                                } else {
                                    login(number);
                                }*/


                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    showBuilder(LoginScreen.this, "Network Error", "Please Connect to the Internet");
                }
                break;
            case R.id.btn_cancel_otp:
                showToast("Cancel");
                dialog1.dismiss();
                dialog1 = null;
                break;

            case R.id.btn_login_otp:
                Log.e("=======", "=======");
                if (et_otp.getText().toString().equalsIgnoreCase("")) {
                    showToast("Please Enter OTP");
                } else {
                    if (fcmstatus.equalsIgnoreCase("0")) {
                        Log.e("ENTER SIGNAL NOT ALLOWED", "====");

                    } else {

                        first_time = "First_time";
                        String otp_final = et_otp.getText().toString();
                        device_token = FirebaseInstanceId.getInstance().getToken();
                        Log.e("device_token", "" + device_token);
                        Log.e("device id", device_id);
                        // number, device_type, device_token, device_id, app_type, otp

                        /*WITHOUT ASM SERVICE*/
                        verify_OTP(number, app_type, device_type, device_id, device_token, otp_final);

                        /*ASM SERVICE*/
                        //verify_OTP_ASM(number, app_type, device_type, device_id, device_token, otp_final);
                    }
                }
                break;
            case R.id.resend_otp:
                first_time = "RESEND";
                String resend_number = preferences.getString("NUMBER", "");
                login(resend_number);
                break;
            default:
        }
    }


    private void verify_OTP(String number, String app_type, String device_type, String device_id, String device_token, String verifyotp) {
        showLog(number);

        showLog(get_otp);

        otpverify_ResponseCall = mWebrequest.apiInterface.verifyOTP(number, app_type, device_type, device_id, device_token, verifyotp);

        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("number", number);
        editor.commit();
        showLog(number);
        getVerifyOtpResponse(otpverify_ResponseCall);
    }

    //Verify OTP API Response
    private void getVerifyOtpResponse(final Call<VerifyBeans> otpverifyResp) {
        showProgressDialog(LoginScreen.this, "OTP Verify...");
        otpverifyResp.enqueue(new Callback<VerifyBeans>() {
            @Override
            public void onResponse(Call<VerifyBeans> call, Response<VerifyBeans> response) {

                if (response.isSuccessful()) {
                    verify_otpresponse = response.body();
                    //Log.e("verify respose ", String.valueOf(verify_otpresponse));

                    String status = response.body().getStatus().toString();
                    String message = response.body().getMessage().toString();
                    Log.e("ll", status);

                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        UserDataBeans userdata = verify_otpresponse.getData();
                        String name = userdata.getFullname().toString();
                        ref_id = userdata.getRef().toString();
                        lindex = userdata.getLindex().toString();
                        Log.e("****lindex", lindex);

                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("Name", name);
                        editor.putString("STATUS", status);
                        editor.putString("REF_ID", ref_id);
                        editor.putString("L_INDEX", lindex);
                        editor.putString("Triggerfrom", "PUD");
                        // editor.putString("userImage",userimage);
                        editor.putString("SOSDetection", "Activated");
                        editor.putString("SOSDetected", "1");
                        editor.putString("pressdetectedlevel", "0");
                        editor.commit();

                        gps = new GPSTracker(LoginScreen.this);
                        latt = gps.getLatitude();
                        lngg = gps.getLongitude();

                        Intent intent = new Intent(LoginScreen.this, SOSService.class);
                        startService(intent);
                        Update_locationCall.sendUpdateSignal(LoginScreen.this, latt, lngg);
                        Intent intent_service1 = new Intent(getApplicationContext(), ScreenSaverService.class);
                        startService(intent_service1);

                        //new data
                        calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(System.currentTimeMillis());
                        int interval = 1000 * 60 * 5;

                        alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
                        alarm = new Intent(LoginScreen.this, UpdateLocationIntentService.class);
                        pendingIntent = PendingIntent.getService(LoginScreen.this, 0, alarm, 0);

                        if (SDK_INT < Build.VERSION_CODES.KITKAT) {
                            alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
                            Log.e("lowerMF", "hahah");
                        } else if (Build.VERSION_CODES.KITKAT <= SDK_INT && SDK_INT < Build.VERSION_CODES.M) {
                            alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
                            Log.e("kitkatMF", "hahah");
                        } else if (SDK_INT >= Build.VERSION_CODES.M) {
                            alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
                            Log.e("marshmallowMF", "hahah");
                        }

                        //Setting API Call
                        SettingsAPICall.getSettings(LoginScreen.this);

                        TriggerSignal.sendTriggerSignal(LoginScreen.this, "", "", "");

                        KillSignalAPICall.getKillSignal(LoginScreen.this);

                       /* Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
                        startService(intent_service);*/


                        PwonSignal.sendPWONSignal(LoginScreen.this, "PWON");

                        SharedPreferences.Editor editoree = preferences.edit();

                        editoree.putString("Triggerfrom", "PWON");
                        editoree.commit();


                        TriggerSignal.sendTriggerSignal(LoginScreen.this, "", "", "");

                        move_withDelay();

                        //custom dialog
                    } else {
                        Log.e("In VERify condition", "Failed");
                        Toast.makeText(getApplicationContext(), "Service down ", Toast.LENGTH_LONG).show();

                    }
                }
            }

            @Override
            public void onFailure(Call<VerifyBeans> call, Throwable t) {
                dismissProgressDialog();
                Toast.makeText(getApplicationContext(), "Please Verify OTP", Toast.LENGTH_LONG).show();
                t.printStackTrace();
            }
        });
    }

    private void verify_OTP_ASM(String number, String app_type, String device_type, String device_id, String device_token, String verifyotp) {
        try {
            String deviceid = device_id;
            String verifyotpp = verifyotp;
            Log.e("Call Sucess", "]]]]]]]");
            otpverify_ResponseCall_ASM = mWebrequest.apiInterface.verifyOTPASM(number, app_type, device_type, deviceid, device_token, verifyotp);

        } catch (NumberFormatException e) {
            e.printStackTrace();
        }

        showLog(number);
        showLog(app_type);
        showLog(device_type);
        showLog(device_id);
        showLog(device_token);
        showLog(verifyotp);

        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("number", number);
        editor.commit();
        showLog(number);
        getVerifyOtpResponse_ASM(otpverify_ResponseCall_ASM);
    }

    //Verify OTP API ASM Response
    private void getVerifyOtpResponse_ASM(final Call<Verify_otp_beans> otpverifyResp) {
        showProgressDialog(LoginScreen.this, "OTP Verify...");
        otpverifyResp.enqueue(new Callback<Verify_otp_beans>() {
            @Override
            public void onResponse(Call<Verify_otp_beans> call, Response<Verify_otp_beans> response) {

                if (response.isSuccessful()) {
                    verify_otpresponse_ASM = response.body();
                    Log.e("verify ASM respose ", String.valueOf(verify_otpresponse_ASM));

                    String status = String.valueOf(response.body().getSTATUS());

                    Log.e("ll ASM Verify OTP ", status);

                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In Verify ASM OTP  condition", "Success");
                        // UserDataBeans userdata = verify_otpresponse.getData();
                        String name = response.body().getFULLNAME().toString();
                        ref_id = String.valueOf(response.body().getREF());
                        Log.e("====InVerifyASM OTP  condition", name);
                        Log.e("===In Verify AsMOTP  condition", ref_id);
                        // String userimage=userdata.getUser_image().toString();


                        //showToast(message);

                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("Name", name);
                        editor.putString("STATUS", status);
                        editor.putString("REF_ID", ref_id);
                        editor.putString("Triggerfrom", "PUD");
                        // editor.putString("userImage",userimage);
                        editor.commit();
                        gps = new GPSTracker(LoginScreen.this);
                        latt = gps.getLatitude();
                        lngg = gps.getLongitude();


                        Update_locationCall.sendUpdateSignal(LoginScreen.this, latt, lngg);


                        //new data
                        calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(System.currentTimeMillis());
                        int interval = 1000 * 60 * 15;

                        alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
                        alarm = new Intent(LoginScreen.this, UpdateLocationIntentService.class);
                        pendingIntent = PendingIntent.getService(LoginScreen.this, 0, alarm, 0);

                        if (SDK_INT < Build.VERSION_CODES.KITKAT) {
                            alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);

                        } else if (Build.VERSION_CODES.KITKAT <= SDK_INT && SDK_INT < Build.VERSION_CODES.M) {
                            alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);

                        } else if (SDK_INT >= Build.VERSION_CODES.M) {
                            alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + interval, pendingIntent);
                            Log.e("marshmallowMF", "hahah");
                        }


                        //Setting API Call
                        SettingsAPICall.getSettings(LoginScreen.this);

                        TriggerSignal.sendTriggerSignal(LoginScreen.this, "", "", "");

                        KillSignalAPICall.getKillSignal(LoginScreen.this);

                       /* Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
                        startService(intent_service);*/


                        PwonSignal.sendPWONSignal(LoginScreen.this, "PWON");
                        SharedPreferences.Editor editoree = preferences.edit();

                        editoree.putString("Triggerfrom", "PWON");
                        // editor.putString("userImage",userimage);
                        editoree.commit();


                        TriggerSignal.sendTriggerSignal(LoginScreen.this, "", "", "");


                        move_withDelay();

                        //custom dialog
                    } else if (status.equalsIgnoreCase("0")) {
                        dismissProgressDialog();
                        showToast("Wrong Otp");

                    }
                }
            }

            @Override
            public void onFailure(Call<Verify_otp_beans> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    private void move_withDelay() {
        try {
            timer.schedule(new TimerTask() {
                public void run() {
                    dismissProgressDialog();
                    Log.e("PROGRESSS", ">>>");
                    dialog1.dismiss();

                    Intent intent = new Intent(LoginScreen.this, TabHostActivity.class);
                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                    startActivity(intent);
                    finish();

                }
            }, 8000);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();

    }

    @Override
    protected void onPause() {
        super.onPause();
    /*    if(progressDialog.isShowing()) {
        progressDialog.dismiss();
    }*/
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        switch (v.getId()) {
            case R.id.rl_login1:
                try {
                    Log.e("DIALOG ", "DiSPLAYINGGG");

                    dialog1.setCancelable(false);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
        }
        return true;
    }

    @Override
    protected void onResume() {
        super.onResume();
        checkPermissions();
    }

    private void loginASM(String number) {
        Log.e("++New Response", "============");
        loginResponseCall_ASM = mWebrequest.apiInterface.userLoginASM(number);
        getLoginResponseASM(loginResponseCall_ASM);
    }

    //Login API Response
    private void getLoginResponseASM(final Call<List<LoginASMBeans>> loginResp) {
        showProgressDialog(LoginScreen.this, "Login...");
        loginResp.enqueue(new Callback<List<LoginASMBeans>>() {

            @Override
            public void onResponse(Call<List<LoginASMBeans>> call, Response<List<LoginASMBeans>> response) {


                //showLog(response.body().getMessage().toString());

                Log.e("LOGIN ASM RESPONSE", response.toString());
                dismissProgressDialog();

                if (response.isSuccessful()) {
                    try {
                        loginResponse_ASM = response.body();
                        Log.e("STATUS ASM", loginResponse_ASM.toString());
                        if (loginResponse_ASM != null) {
                            Log.e("Status ASM", loginResponse_ASM.get(0).getStatus().toString());
                            String status = loginResponse_ASM.get(0).getStatus();


                            if (status.equalsIgnoreCase("1")) {
                                Log.e("In condition ASM", "Success");

                                try {
                                    otp_Dialog();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else if (status.equalsIgnoreCase("2")) {
                                Log.e("In condition ASM", "Success");

                                try {
                                    otp_Dialog();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else if (status.equalsIgnoreCase("0")) {
                                Log.e("In condition ASM", "Failed");
                                AlertDialog.Builder builder = new AlertDialog.Builder(LoginScreen.this);
                                builder.setTitle("Error");
                                builder.setMessage("You have entered an unrecognised number, please check and try again. If you are still having problems then please contact Orbis on 0845 345 7800 or email lwpsupport@orbisprotect.com");
                                builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        dialog.dismiss();
                                    }
                                });
                                builder.show();
                            }
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }


            @Override
            public void onFailure(Call<List<LoginASMBeans>> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    private void login(String number) {
        loginResponseCall = mWebrequest.apiInterface.userLogin(number);
        getLoginResponse(loginResponseCall);
    }

    //Login API Response
    private void getLoginResponse(Call<LoginBeans> loginResp) {
        showProgressDialog(LoginScreen.this, "Login...");
        loginResp.enqueue(new Callback<LoginBeans>() {
            @Override
            public void onResponse(Call<LoginBeans> call, Response<LoginBeans> response) {
                //showLog(response.body().getMessage().toString());
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    loginResponse = response.body();
                    String status = response.body().getStatus().toString();
                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition login", "Success");
                        get_otp = response.body().getOtp().toString();
                        String message = response.body().getMessage().toString();
                        Log.e("get_otp>>>>>>>>:-", get_otp);
                        try {
                            Log.e("get_otp>>>>>>>>:-", "DIALOG");
                            if (isNetworkAvailable()) {
                                Log.e("get_otp>>>>>>>>:-", "Network");
                                otp_Dialog();
                            } else {
                                Log.e("get_otp>>>>>>>>:-", "Not Network");
                                Toast.makeText(getApplicationContext(), "Network is not available", Toast.LENGTH_SHORT).show();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Log.e("In Login condition", "Failed");
                        AlertDialog.Builder builder = new AlertDialog.Builder(LoginScreen.this);
                        builder.setTitle("Error");
                        builder.setMessage("You have entered an unrecognised number, please check and try again. If you are still having problems then please contact Orbis on 0845 345 7800 or email lwpsupport@orbisprotect.com");
                        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        });
                        builder.show();
                    }
                }
            }

            @Override
            public void onFailure(Call<LoginBeans> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }


    private void otp_Dialog() {
        if (dialog1 != null) {

            Log.e("Not NULL", "=======");

            dialog1.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
            dialog1.setContentView(R.layout.otp_layout);
            et_otp = (EditText) dialog1.findViewById(R.id.et_otp);
            btn_login_otp = (Button) dialog1.findViewById(R.id.btn_login_otp);
            btn_cancel_otp = (Button) dialog1.findViewById(R.id.btn_cancel_otp);
            resend_otp = (TextView) dialog1.findViewById(R.id.resend_otp);
            resend_otp.setOnClickListener(this);
            // Click cancel to dismiss android custom dialog box
            btn_cancel_otp.setOnClickListener(this);
            btn_login_otp.setOnClickListener(this);

            dialog1.show();

        } else {
            Log.e("NULL", "=======");
            dialog1 = new Dialog(LoginScreen.this);

            dialog1.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
            dialog1.setContentView(R.layout.otp_layout);
            et_otp = (EditText) dialog1.findViewById(R.id.et_otp);
            btn_login_otp = (Button) dialog1.findViewById(R.id.btn_login_otp);
            btn_cancel_otp = (Button) dialog1.findViewById(R.id.btn_cancel_otp);
            resend_otp = (TextView) dialog1.findViewById(R.id.resend_otp);
            resend_otp.setOnClickListener(this);
            // Click cancel to dismiss android custom dialog box
            btn_cancel_otp.setOnClickListener(this);
            btn_login_otp.setOnClickListener(this);

            dialog1.show();
        }


        dialog1.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
        dialog1.setContentView(R.layout.otp_layout);
        et_otp = (EditText) dialog1.findViewById(R.id.et_otp);
        btn_login_otp = (Button) dialog1.findViewById(R.id.btn_login_otp);
        btn_cancel_otp = (Button) dialog1.findViewById(R.id.btn_cancel_otp);
        resend_otp = (TextView) dialog1.findViewById(R.id.resend_otp);
        resend_otp.setOnClickListener(this);
        // Click cancel to dismiss android custom dialog box
        btn_cancel_otp.setOnClickListener(this);
        btn_login_otp.setOnClickListener(this);

        dialog1.show();
    }

    public void showAlert() {


        try {
            gps = new GPSTracker(this);
            LocationManager lm = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
            boolean gps_enabled = false;
            boolean network_enabled = false;

            try {
                gps_enabled = lm.isProviderEnabled(LocationManager.GPS_PROVIDER);
            } catch (Exception ex) {
            }

            try {
                network_enabled = lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            } catch (Exception ex) {
            }

            if (!gps_enabled && !network_enabled) {
                // notify user
                AlertDialog.Builder dialog = new AlertDialog.Builder(LoginScreen.this);
                dialog.setMessage(this.getResources().getString(R.string.gps_network_not_enabled));
                dialog.setPositiveButton(this.getResources().getString(R.string.open_location_settings), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub
                        Intent myIntent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                        startActivity(myIntent);
                        //get gps
                    }
                });
                dialog.setNegativeButton(this.getString(R.string.cccancel), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                        // TODO Auto-generated method stub

                    }
                });
                dialog.show();
            }


        } catch (Exception e) {
            e.printStackTrace();
        }

    }



}