package com.orbis.Activity;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;

import com.orbis.R;
import com.orbis.Util.Utility;
import com.orbis.net.KillSignalAPICall;
import com.orbis.net.OnClearFromRecentService;
import com.orbis.net.SettingsAPICall;
import com.orbis.net.UninstalReceiver;

import java.util.Timer;
import java.util.TimerTask;


public class SplashScren extends OrbisActivity {
    Timer timer = new Timer();
    private String verifystatus = "";
    private String currentTime = "";
    private String confirmstatus = "";
    UninstalReceiver br;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash_scren);



        boolean firstRun = preferences.getBoolean("firstRun", false);
        verifystatus = preferences.getString("STATUS", "");
        confirmstatus=preferences.getString("confirm","");

        Utility.status_bar_color_change(SplashScren.this);

        try {
            currentTime = get_current_time();
            startService(new Intent(getBaseContext(), OnClearFromRecentService.class));
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (firstRun == false)
        //if running for first time splash will load for first time
        {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putBoolean("firstRun", true);
            editor.commit();
            move_NextScreen();
        } else {
            if (verifystatus.equalsIgnoreCase("1")) {
               /* Intent intentservice = new Intent(getApplicationContext(), UpdateLocationService.class);
                startService(intentservice);*/

                //Setting API Call
                SettingsAPICall.getSettings(SplashScren.this);

                //Signal call
                KillSignalAPICall.getKillSignal(SplashScren.this);

               /* Intent intent_service = new Intent(getApplicationContext(), SOSService.class);
                startService(intent_service);*/

                Intent intent = new Intent(SplashScren.this, TabHostActivity.class);
                startActivity(intent);
                finish();

            } else {
                if(confirmstatus.equalsIgnoreCase("1")) {
                    Utility.moveToNextActivity(SplashScren.this, LoginScreen.class);
                    overridePendingTransition(0, 0);
                    finish();
                }
                else{

                  /*  try{
                        Log.e(">>>>>>>>>>>>>>>>>>>>>","????????????");
                        br=new UninstalReceiver();
                        IntentFilter intentFilter = new IntentFilter();
                        intentFilter.addAction(Intent.ACTION_PACKAGE_ADDED);
                        intentFilter.addAction(Intent.ACTION_PACKAGE_INSTALL);
                        intentFilter.addDataScheme("com.orbis");
                        registerReceiver(br, intentFilter);

                    }catch (Exception e){
                        e.printStackTrace();
                    }*/
                    Intent intent=new Intent(getApplicationContext(),WelcomeActivity.class);
                    startActivity(intent);
                    finish();
                }
            }
        }
    }

    private void move_NextScreen() {
        timer.schedule(new TimerTask() {
            public void run() {
                if (verifystatus.equalsIgnoreCase("1")) {
                    Utility.moveToNextActivity(SplashScren.this, TabHostActivity.class);
                } else {
                    Utility.moveToNextActivity(SplashScren.this, WelcomeActivity.class);
                    overridePendingTransition(0, 0);
                    finish();
                }
            }
        }, 3000);
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
      //  unregisterReceiver(br);
    }
}


/* */
