package com.orbis.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.EsclationBeans;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Admin on 30-08-2017.
 */

public class EscalationApiCall {


    private static String refId;
    private static WebRequest mWebrequest;
    private static SharedPreferences preferences;
    static Call<EsclationBeans> esclationResponseCall;
    static EsclationBeans esclationResponse;



    public static void getEscalation(Context context){

        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        refId = preferences.getString("REF_ID", "");
        esclationResponseCall = mWebrequest.apiInterface.EsclationDetail(refId);
        getEscalationResponse(esclationResponseCall);
    }
    //Kill Signal API Response
    private static void getEscalationResponse(Call<EsclationBeans> escaResp)
    {
        escaResp.enqueue(new Callback<EsclationBeans>()
        {
            @Override
            public void onResponse(Call<EsclationBeans> call, Response<EsclationBeans> response) {


                if (response.isSuccessful()) {
                    esclationResponse = response.body();
                    String status = response.body().getStatus().toString();
                    if (status.equalsIgnoreCase("1")){
                        Log.e("In Esc detail condition","Success");

                        String  message = response.body().getMessage().toString();

                        Log.e("Email Addresss",response.body().getData().getEmailaddress());
                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("fullname", response.body().getData().getFullname());
                        editor.putString("number", response.body().getData().getNumber());
                        editor.putString("emailaddress", response.body().getData().getEmailaddress());
                        editor.putString("address", response.body().getData().getAddress());
                        editor.putString("name1", response.body().getData().getName1());
                        editor.putString("phone_number1", response.body().getData().getPhone_number1());
                        editor.putString("name2", response.body().getData().getName2());
                        editor.putString("phone_number2", response.body().getData().getPhone_number2());
                        editor.putString("name3", response.body().getData().getName3());
                        editor.putString("phone_number3", response.body().getData().getPhone_number3());
                        editor.commit();


                    }else
                    {
                        Log.e("In Esca Detail condition","Failed");
                    }
                }
            }
            @Override
            public void onFailure(Call<EsclationBeans> call, Throwable t)
            {
                //dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }
}
