package com.orbis.net;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.EscalationDetail;
import com.orbis.Model.EscalationDetailDataBeans;

import java.util.ArrayList;
import java.util.List;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class EscalationDetailApiCall {
    Context context;
    private static String indexstatus, message;
    private static WebRequest mWebrequest;
    private static SharedPreferences preferences;
    static ProgressDialog progressDialog;

    static Call<EscalationDetail> esclationResponseCall;
    private static EscalationDetail esclationResponse;
    private static List<EscalationDetailDataBeans> addEscalationDetailList = new ArrayList<EscalationDetailDataBeans>();


    public static void getEscalationDetailData(Context context) {
        context = context;
        progressDialog = new ProgressDialog(context);
        mWebrequest = WebRequest.getSingleton(context);
        preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        indexstatus = preferences.getString("L_INDEX", "");
        esclationResponseCall = mWebrequest.apiInterface.escalationDetailData(indexstatus);
        getEscalationGetDetailResponse(esclationResponseCall, context);
    }

    //add Lead response
    private static void getEscalationGetDetailResponse(Call<EscalationDetail> escalationResp, Context context) {
        showProgressDialog(context, "Processing...");
        escalationResp.enqueue(new Callback<EscalationDetail>() {
            @Override
            public void onResponse(Call<EscalationDetail> call, Response<EscalationDetail> response) {
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    esclationResponse = response.body();
                    String status = response.body().getStatus().toString();
                    message = response.body().getMessage().toString();
                    Log.e("**SERVR*****", response.body().getMessage().toString());
                    if (status.equalsIgnoreCase("1")) {
                        addEscalationDetailList.clear();
                        addEscalationDetailList = response.body().getData();

                        for (int i = 0; i < addEscalationDetailList.size(); i++) {
                            Log.e("Email Addresss", addEscalationDetailList.get(i).getEMAIL());
                            SharedPreferences.Editor editor = preferences.edit();
                            editor.putString("fullname", addEscalationDetailList.get(i).getFULLNAME());
                            editor.putString("mobilenumber", addEscalationDetailList.get(i).getMOBILE());
                            editor.putString("email", addEscalationDetailList.get(i).getEMAIL());
                            editor.putString("discription", addEscalationDetailList.get(i).getDESCRIPTION());
                            editor.putString("bussinesstelephone", addEscalationDetailList.get(i).getBUSINESSTELEPHONE());
                            editor.putString("homenumber", addEscalationDetailList.get(i).getHOMETELEPHONE());
                            editor.putString("others", addEscalationDetailList.get(i).getOTHER());
                            editor.putString("pager", addEscalationDetailList.get(i).getPAGER());
                            editor.putString("priority", addEscalationDetailList.get(i).getPRIORITY());
                            editor.commit();
                        }
                    }

                } else {
                    dismissProgressDialog();
                }
            }

            @Override
            public void onFailure(Call<EscalationDetail> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
                Log.e("ERROE***", t.getMessage());
            }
        });


    }

    public static void showProgressDialog(@NonNull Context context, @NonNull String message) {
        progressDialog = ProgressDialog.show(context, "", message);
    }


    /***
     * Dismiss progress bar
     */

    public static void dismissProgressDialog() {
        progressDialog.dismiss();
    }
}

