<?php

Class Users extends CI_Model
{
	public $table = 'user';
	public $commission = 'user_commission';
	public $customers = 'customers';
	public $bankdetail = 'bankdetail';

	public function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql', true);
	}

	function get_canvasser()
	{
		return $this->mysql->select('*')->from($this->table)->order_by('created_at')->get()->result_array();
	}

	function get_user_team($team_id)
	{
		return $this->mysql->select('*')->from($this->table)->where([ 'team_id' => $team_id ])->get()->result_array();
		//echo $this->mysql->last_query();
	}

	function team_via_id($team_id)
	{
		return $this->mysql->select('*')->from($this->table)->where([ 'team_id' => $team_id ])->get()->result_array();
	}

	function check_user_email($email)
	{
		return $this->mysql->select('*')->from($this->table)->where(['email' => $email])->get()->first_row('array');
	}

	function check_user_username($username)
	{
		return $this->mysql->select('*')->from($this->table)->where(['username' => $username])->get()->first_row('array');
	}

	function get_user_detail($user_id)
	{
		return $this->mysql->select('*')->from($this->table)->where([ 'user_id' => $user_id ])->get()->first_row('array');
	}

	function get_user_commission($user_id)
	{
		$query = $this->mysql->select_sum('commission_earned')->from($this->commission)->where([ 'user_id' => $user_id ])->get();
		foreach ($query->result() as $row)
		{
        	return $row->commission_earned;
		}
	}

	function get_customer_name($user_id)
	{
		$query = $this->mysql->select('*')->from($this->customers)->where([ 'customer_id' => $user_id ])->get();
		foreach ($query->result() as $row)
		{
        	return $row->first_name;
		}
	}

	//assign team
	function update_user_team($team_id,$id)
	{
		$data['team_id'] = $team_id;
		$data['update_at'] = date('Y-m-d H:i:s');
		return $this->mysql->where('user_id',$id)->update('user',$data);
	}

	function account_detail($userID)
	{
		return $this->mysql->select('*')->from($this->bankdetail)->where(['user_id'=>$userID])->get()->first_row('array');
	}

	function edit_canvasser($data, $id)
	{
		return $this->mysql->where( 'user_id', $id )->update('user',$data);
	}

	function update_account_detail($data,$id)
	{
		return $this->mysql->where( 'user_id', $id )->update($this->bankdetail,$data);
	}

	function insert_canvassar($data,$bank)
	{
		$this->mysql->insert($this->table,$data);
		$userID = $this->mysql->insert_id();
		if($userID > 0)
	    {
	      // insert user bank detail
	      $bank['user_id'] = $userID;
	      $this->mysql->insert('bankdetail',$bank);

	      //insert user work detail
	      $work['user_id'] = $userID;
	      $this->mysql->insert('work_detail',$work);

	      return '1';
	    }
	}

	function user_delete($user_id)
	{
		return $this->mysql->where('user_id',$user_id)->delete($this->table);
	}

	function street_user_remove($user_id,$street_id)
	{
		$data['update_at'] = date('Y-m-d H:i:s');
		$data['assign'] = '0';
		$data['user_id'] = '0';

		return $this->mysql->where([ 'user_id' => $user_id, 'street_id' => $street_id ])->update('street_sheet',$data);
	}

	function change_teamCanvasser($teamID,$userid)
	{
		$data['team_id'] = $teamID;
		$data['update_at'] = date('Y-m-d H:i:s');
		return $this->mysql->where('user_id',$userid)->update('user',$data);
	}
}
