<?php 

Class Streets extends CI_Model
{
	public $table_street = 'street_sheet';
	public $table_address = 'street_address';

	function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql',true);
	}

	function get_knock_address()
	{
		return $this->mysql->select('*')->from($this->table_address)->where([ 'status <>' => 'n/a' ])->order_by('update_at','desc')->get()->result_array();
	}

	function get_street_by_address($street_id)
	{
		$return = $this->mysql->select('street_name')->from($this->table_street)->where([ 'street_id' => $street_id ])->get();
		foreach( $return->result() as $row  )
		{
			return $row->street_name;
		}
	}

	//get pitch address
	function get_pitch()
	{
		return $this->mysql->select('*')->from($this->table_address)->where([ 'status' => 'P' ])->order_by('update_at','desc')->get()->result_array();
	}
}