<?php
/*
	Controller for Office
*/

Class Office extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('cost_center');
		$this->load->model('contractareas');
		$this->load->model('offices');
		$this->load->library('session');
		if( $this->session->userdata('login_id') !=1 )
		{
			$this->session->set_flashdata('error_msg','Not Login Yet');
			redirect('user/index');
		}
	}

	function index()
	{
	   if(isset($_POST['costcenter']) && !empty($_POST['costcenter']) && isset($_POST['contractarea']) && !empty($_POST['contractarea'])){
		    $this->session->set_userdata('costcenter',$_POST['costcenter']);
			$this->session->set_userdata('contractarea',$_POST['contractarea']);
		    $data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();
			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			$contractarea_detail = [];
			$office_list = $this->offices->filter_office_list($_POST['contractarea']);
			for( $i=0; $i<count($office_list); $i++ )
			{
				$this->offices->contractarea_id = $office_list[$i]['contractarea_id'];
				$contractarea_detail = $this->offices->get_contract();
				$office_list[$i]['contractarea_detail'] = $contractarea_detail;
				for ($m=0; $m <count($contractarea_detail) ; $m++)
				{ 
					$this->offices->costcenterid = $contractarea_detail[$m]['costcenter_id'];
					$office_list[$i]['costcenter_detail'] = $this->offices->get_costcenter();
				}
				$data['detail'] = $office_list;
			}
			//debug($data,1);
			$this->load->view('office/office_list',$data);
		     
	   }else{
		    $this->session->set_userdata('costcenter',"");
			$this->session->set_userdata('contractarea',"");
		    $data['costcenter'] = $this->cost_center->cc_list();
			$data['contract_areas'] = $this->contractareas->get_all();
			$data['contract_costcenter'] = $this->offices->contract_costcenter();
			
			$contractarea_detail = [];

			$office_list = $this->offices->office_list();
			for( $i=0; $i<count($office_list); $i++ )
			{
				$this->offices->contractarea_id = $office_list[$i]['contractarea_id'];
				$contractarea_detail = $this->offices->get_contract();
				$office_list[$i]['contractarea_detail'] = $contractarea_detail;
				for ($m=0; $m <count($contractarea_detail) ; $m++)
				{ 
					$this->offices->costcenterid = $contractarea_detail[$m]['costcenter_id'];
					$office_list[$i]['costcenter_detail'] = $this->offices->get_costcenter();
				}
				$data['detail'] = $office_list;
			}
			//debug($data,1);
			$this->load->view('office/office_list',$data);
	   }
	}
	
	function get_contract_area($costcenterid) {
		$contractarea = $this->offices->contract_area_list($costcenterid);
        echo json_encode($contractarea);		
	}


	function add_Office()
	{
		//debug( $this->input->post() );

		if( $this->input->post('cpassword', true) === $this->input->post('password', true) )
		{
			$this->offices->contractarea_id = $this->input->post('contractarea', true);
			$this->offices->office_name = $this->input->post('office_name', true);
			$this->offices->admin_name = $this->input->post('admin_name', true);
			$this->offices->email_address = $this->input->post('email_address', true);
			$this->offices->contact_number = $this->input->post('contact_number', true);
			$this->offices->password = $this->input->post('password', true);
			$this->offices->password = $this->input->post('cpassword', true);
			echo $add_offices = $this->offices->add_offices();
		}
		else
		{
			echo "Password did not match";
		}

	}

	function change_status()
	{
		$this->offices->office_id = $this->input->post('id',true);
		$this->offices->status = $this->input->post('status', true);
		echo $office_status = $this->offices->office_status();
	}
}