//
//  EscalationDetails.swift
//  Orbis
//
//  Created by KALSI on 7/7/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift
import Alamofire

struct My {
    static var cellSnapshot : UIView? = nil
}
struct Path {
    static var initialIndexPath : NSIndexPath? = nil
}

enum ChangingSubjects : String {
    case priority = "Priority Change Request"
    case details = "Escalation details Change Request"
    case priorityAndDetails = "Priority and Escalation details Change Request"
}

class EscalationDetails: UIViewController ,UITableViewDataSource, UITableViewDelegate{
    
    @IBOutlet weak var update_button: UIButton!
    @IBOutlet weak var loaderView: UIView!
    @IBOutlet weak var numberTableView: UITableView!
    @IBOutlet weak var escalationTableView: UITableView!
    @IBOutlet weak var add_button: UIButton!
    @IBOutlet weak var add_text: UILabel!
    @IBOutlet weak var note_label: UILabel!
    var isIndexAvailable = true
    var userDetailsArray = NSMutableArray()
    var numbers = ["123456789","213456789","321456789","321456789"]
    var names = ["John Doe","Jack Singh","Shaun Wilcock","Ajay Sharma"]
    var tempTxfld = UITextField()
    var UpdateInfo = false
    var currentTag = -1
    var subject_for_changes = ""
    var isDeleting = false
    
    // MARK:-
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        if isCancel{
            self.WebService()

        }
        
        if UpdateInfo {
            if currentTag >= 0 {
                userDetailsArray.replaceObject(at: currentTag, with: t_EscalationDetailsListModel)
                self.escalationTableView.reloadData()
                self.numberTableView.reloadData()
            }
        }
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        
        IQKeyboardManager.shared.enableAutoToolbar = true
        escalationTableView.tableFooterView = UIView()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    override func viewDidLayoutSubviews() {
        self.add_button.frame = CGRect(x: self.add_button.frame.origin.x, y: self.add_button.frame.origin.y, width: self.add_button.frame.size.width, height: self.add_button.frame.size.width)
        self.add_button.layer.cornerRadius = self.add_button.frame.size.width / 2
        self.add_button.layer.masksToBounds = true
    }
    
    // MARK: -
    func WebService() {
        let dict = ["lindex":UserDefaults.standard.object(forKey: "lindex")]
        
        if MyReachability.isConnectedToNetwork() {
            loaderView.isHidden = false
            
            Globals.Services().AlamofirePost("user/get_escalation", parameters: dict as NSDictionary, completion: { (result) in
                
                if result.count > 0 {
                    
                    let modelData = EscalationDetailsModel().setData(result)
                    if modelData.message ==  "Lindex is empty" {
                        self.isIndexAvailable = false
                        Globals().addPrompt(message: modelData.message, view: self) {
                            return
                            
                        }
                    }
                    let back_modelData = EscalationDetailsModel().setData(result)

                    self.userDetailsArray = modelData.detailsArray
                    backUpEsacalationArray = back_modelData.detailsArray
                    self.escalationTableView.reloadData()
                    self.numberTableView.reloadData()
                    self.loaderView.isHidden = true
                    
                    self.escalationTableView.isHidden = false
                    self.numberTableView.isHidden = false
                    self.note_label.isHidden = false
                    self.update_button.isHidden = false
                    
                    self.add_button.isHidden = true
                    self.add_text.isHidden = true
                    
                } else {
                    
                    self.escalationTableView.isHidden = true
                    self.numberTableView.isHidden = true
                    self.note_label.isHidden = true
                    self.update_button.isHidden = true
                    
                    self.add_button.isHidden = false
                    self.add_text.isHidden = false
                    
                    Globals().addPrompt(message: "Server not working", view: self) {
                        self.loaderView.isHidden = true
                    }
                }
                
            })
            
        } else {
            self.escalationTableView.isHidden = true
            self.numberTableView.isHidden = true
            self.note_label.isHidden = true
            self.update_button.isHidden = true
            
            self.add_button.isHidden = false
            self.add_text.isHidden = false

            Globals().addPrompt(message: "Please check your internet connection", view: self) {
                
            }
        }
    }
    
    //MARK:-
    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    func snapshopOfCell(inputView: UIView) -> UIView {
        UIGraphicsBeginImageContextWithOptions(inputView.bounds.size, false, 0.0)
        inputView.layer.render(in: UIGraphicsGetCurrentContext()!)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        let cellSnapshot : UIView = UIImageView(image: image)
        cellSnapshot.layer.masksToBounds = false
        cellSnapshot.layer.cornerRadius = 0.0
        cellSnapshot.layer.shadowOffset = CGSize(width : -5.0, height : 0.0)
        cellSnapshot.layer.shadowRadius = 5.0
        cellSnapshot.layer.shadowOpacity = 0.4
        return cellSnapshot
    }
    
    @IBAction func tableviewLongPress(_ sender: UILongPressGestureRecognizer) {
        let longPress = sender as UILongPressGestureRecognizer
        let state = longPress.state
        let locationInView = longPress.location(in: escalationTableView)
        let indexPath = escalationTableView.indexPathForRow(at: locationInView)
        
        
        switch state {
            
        case .began:
            if indexPath != nil {
                Path.initialIndexPath = indexPath! as NSIndexPath
                let cell = escalationTableView.cellForRow(at: indexPath!) as! CustomEscalationCell?
                My.cellSnapshot  = snapshopOfCell(inputView: cell!)
                My.cellSnapshot?.layer.cornerRadius = 10
                My.cellSnapshot?.layer.masksToBounds = true
                var center = cell?.center
                My.cellSnapshot!.center = center!
                My.cellSnapshot!.alpha = 0.0
                escalationTableView.addSubview(My.cellSnapshot!)
                
                UIView.animate(withDuration: 0.30, animations: { () -> Void in
                    center?.y = locationInView.y
                    My.cellSnapshot!.center = center!
                    My.cellSnapshot!.transform = CGAffineTransform(rotationAngle: -150.9)//CGAffineTransform(scaleX: 0.98, y: 1.05)
                    My.cellSnapshot!.alpha = 0.98
                    cell?.alpha = 0.0
                    
                }, completion: { (finished) -> Void in
                    if finished {
                        cell?.isHidden = true
                    }
                })
                
            }
            
        case .possible:
            break
            
        case .changed:
            var center = My.cellSnapshot!.center
            center.y = locationInView.y
            My.cellSnapshot!.center = center
            
            if ((indexPath != nil) && (indexPath != Path.initialIndexPath as IndexPath?)) {
                swap(&userDetailsArray[indexPath!.row], &userDetailsArray[Path.initialIndexPath!.row])
               
                escalationTableView.moveRow(at: Path.initialIndexPath! as IndexPath, to: indexPath!)
                Path.initialIndexPath = indexPath! as NSIndexPath
            }
            break
            
        case .ended:
            
            My.cellSnapshot?.removeFromSuperview()
                
            for i in 0..<userDetailsArray.count{
                
                let listData = userDetailsArray[i] as! EscalationDetailsListModel
                let dict : NSDictionary = ["FULLNAME":"\(listData.FULLNAME)",
                    "EMAIL" : listData.EMAIL ,
                    "MOBILE" : listData.MOBILE,
                    "BUSINESSTELEPHONE": listData.BUSINESSTELEPHONE,
                    "HOMETELEPHONE" : listData.HOMETELEPHONE,
                    "SITEINDEX" : UserDefaults.standard.object(forKey: "lindex") as! String,
                    "PRIORITY" : "\(i+1)",
                    "CONTACTINDEX" : listData.CONTACTINDEX,
                    "CTYPE" : listData.CTYPE,
                    "DESCRIPTION" : listData.DESCRIPTION,
                    "OTHER" : listData.OTHER,
                    "PAGER" : listData.PAGER,
                    "SITEINDEX" : listData.SITEINDEX

                ]
                
                let detailData = EscalationDetailsListModel().setData(dict, Int(listData.INDEX)! )
                userDetailsArray.replaceObject(at: i, with: detailData)
                
                self.CheckChange_forPriority(value: true)
            }
            
            escalationTableView.reloadData()
            
            break
        case .cancelled:
            break
        case .failed:
            break
        }
    }
    
    
    //MARK:- UITableViewDelegate -
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat{
        return 70
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return userDetailsArray.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if tableView.tag == 101 {
            let cell = tableView.dequeueReusableCell(withIdentifier: "labelCell")!
            tableView.separatorStyle = .none
            cell.selectionStyle = .none
            cell.textLabel?.text = "\(indexPath.row + 1) ∣"//
            cell.textLabel?.textAlignment = .left
            return cell
            
        }else {
            let detailsData = userDetailsArray[indexPath.row] as! EscalationDetailsListModel
            let cell = tableView.dequeueReusableCell(withIdentifier: "customcell")! as! CustomEscalationCell
            tableView.separatorStyle = .none
            cell.selectionStyle = .none
            var FULLNAME =  detailsData.FULLNAME.replacingOccurrences(of: "<strong>", with: "")
            FULLNAME =  FULLNAME.replacingOccurrences(of: "</strong>", with: "")
            var MOBILE =  detailsData.MOBILE.replacingOccurrences(of: "<strong>", with: "")
            MOBILE =  MOBILE.replacingOccurrences(of: "</strong>", with: "")
            cell.Name.text = FULLNAME//detailsData.FULLNAME//names[indexPath.row]
            cell.number.text = MOBILE//detailsData.MOBILE//numbers[indexPath.row]
            
            cell.bgView.layer.cornerRadius = 10
            cell.bgView.layer.masksToBounds = true
            cell.editButton.tag = indexPath.row
            cell.deleteButton.tag = indexPath.row + 1
            cell.deleteButton.addTarget(self, action: #selector(deleteEscalationDetails(sender:)), for: .touchUpInside)
            cell.editButton.addTarget(self, action: #selector(editEscalationDetails(sender:)), for: .touchUpInside)
            
            cell.editButton.imageView?.contentMode = .scaleAspectFit
            cell.editButton.contentMode = .scaleAspectFit
            
            cell.deleteButton.imageView?.contentMode = .scaleAspectFit
            cell.deleteButton.contentMode = .scaleAspectFit
            
            return cell
        }
    }
    
    
    @objc func editEscalationDetails(sender : UIButton)  {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "EditEscalationDetails") as! EditEscalationDetails
        vc.myData = userDetailsArray[sender.tag] as! EscalationDetailsListModel
        vc.allUserData = userDetailsArray
        self.currentTag = sender.tag
        self.UpdateInfo = true
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    
    @objc func deleteEscalationDetails(sender : UIButton)  {
        
        let controller = UIAlertController(title: "Delete Detail", message: "Are you sure?", preferredStyle: .alert)
        
        controller.addAction(UIAlertAction(title: "Delete", style: .destructive, handler: { (ok) in
            self.userDetailsArray.removeObject(at: sender.tag - 1)
            self.dismiss(animated: true, completion: { })
            self.isDeleting = true
            self.UpdateAction(self.update_button)
        }))
        
        controller.addAction(UIAlertAction(title: "Cancel", style: .cancel, handler: { (can) in
            self.dismiss(animated: true, completion: { })
            
        }))
        
        self.present(controller, animated: true) { }
        
    }
    
    @IBAction func UpdateAction(_ sender: UIButton) {
        
        if !isIndexAvailable {
            Globals().addPrompt(message:"Lindex is empty", view: self) {
                return
                
            }
        }
        let dataToUpload = NSMutableArray()
        
        for i in 0..<userDetailsArray.count {
            
            let listData = userDetailsArray[i] as! EscalationDetailsListModel
            
            let dict : NSDictionary = [
                "FULLNAME":"\(listData.FULLNAME)",
                "EMAIL" : listData.EMAIL ,
                "MOBILE" : listData.MOBILE,
                "BUSINESSTELEPHONE": listData.BUSINESSTELEPHONE,
                "HOMETELEPHONE" : listData.HOMETELEPHONE,
                "SITEINDEX" : UserDefaults.standard.object(forKey: "lindex") as! String,
                "PRIORITY" : listData.PRIORITY,
            ]
            
            dataToUpload.add(dict)
            
            for j in 0..<userDetailsArray.count {
                let back_listData = backUpEsacalationArray[j] as! EscalationDetailsListModel
                
                if listData.INDEX == back_listData.INDEX {
                    if back_listData.FULLNAME != listData.FULLNAME || back_listData.EMAIL != listData.EMAIL || back_listData.MOBILE != listData.MOBILE || back_listData.BUSINESSTELEPHONE != listData.BUSINESSTELEPHONE || back_listData.HOMETELEPHONE != listData.HOMETELEPHONE || back_listData.SITEINDEX != listData.SITEINDEX {
                        
                        self.CheckChange_forPriority(value: false)
                    }
                    
                    if back_listData.PRIORITY != listData.PRIORITY {
                        self.CheckChange_forPriority(value: true)
                    }
                }
            }
            
        }
        
        if isDeleting {
            subject_for_changes = "Escalation Contact Deleted"
        }
        
        print(subject_for_changes)

        let dictToUpload = NSMutableDictionary()
        
        if let theJSssONData = try? JSONSerialization.data(withJSONObject: dataToUpload, options: []) {
            let theJdSONText = String(data: theJSssONData, encoding: .ascii)
            dictToUpload.setValue(theJdSONText, forKey: "parameter")
            dictToUpload.setValue(subject_for_changes, forKey: "subject")
        }

            if MyReachability.isConnectedToNetwork() {
                loaderView.isHidden = false
                
                Globals.Services().AlamofirePostString("user/escalation_mail", parameters: dictToUpload) { (result) in
                    
                    if result.count > 0 {
                        self.InfoUpdated(message: "Escalation details updated successfully! Escalation Details updates take up to 24 hours to be completed")
                        self.loaderView.isHidden = true
                        self.subject_for_changes = ""
                    } else {
                        Globals().addPrompt(message: "Server not working", view: self) {
                            self.loaderView.isHidden = true
                        }
                    }
                }
     
            } else {
                Globals().addPrompt(message: "Please check your internet connection", view: self) { }
            }

//        }
        
        isDeleting = false
    }
    
    func CheckChange_forPriority( value : Bool) {
        
        if value {
            if subject_for_changes == "" || subject_for_changes == ChangingSubjects.priority.rawValue {
                subject_for_changes = ChangingSubjects.priority.rawValue
            } else {
                subject_for_changes = ChangingSubjects.priorityAndDetails.rawValue
            }
        } else {
            if subject_for_changes == "" || subject_for_changes == ChangingSubjects.details.rawValue {
                subject_for_changes = ChangingSubjects.details.rawValue
            } else {
                subject_for_changes = ChangingSubjects.priorityAndDetails.rawValue
            }
        }
    }
    
    func InfoUpdated(message : String) {
        let controller = UIAlertController(title: "Orbis", message: message, preferredStyle: .alert)
        controller.addAction(UIAlertAction(title: "OK", style: .default, handler: { (ok) in
            self.dismiss(animated: true, completion: { })
                   self.WebService()
        }))
        self.present(controller, animated: true) { }
    }
    
    @IBAction func AddNewDetailAction(_ sender: UIButton) {
        
        if !isIndexAvailable {
            Globals().addPrompt(message:"Lindex is empty", view: self) {
                return
                
            }
        }
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "EditEscalationDetails") as! EditEscalationDetails
        vc.AddingNew = true
        vc.tempdata = userDetailsArray
        self.currentTag = -1
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
}

