//
//  ProfileInfo.swift
//  Orbis
//
//  Created by KALSI on 7/3/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit

class ProfileInfo: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    
    @IBOutlet weak var picture: UIImageView!
    var picker = UIImagePickerController()
    
    //MARK:-
    override func viewDidLoad() {
        super.viewDidLoad()
        picker.delegate = self
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    override func viewWillLayoutSubviews() {
        picture.frame = CGRect(x: picture.frame.origin.x, y: picture.frame.origin.y, width: picture.frame.size.height, height: picture.frame.size.height)
        picture.layer.cornerRadius = picture.frame.size.height / 2
        picture.layer.masksToBounds = true
    }
    //MARK:-
    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    @IBAction func EditProfileAction(_ sender: Any) {
        
        let controller = UIAlertController(title: "Update picture", message: nil, preferredStyle: .actionSheet)
        controller.addAction(UIAlertAction(title: "Gallery", style: .default, handler: { (UIAlertAction) in
            self.picker.sourceType = .photoLibrary
            self.present(self.picker, animated: true, completion: { })
        }))
        controller.addAction(UIAlertAction(title: "Camera", style: .default, handler: { (UIAlertAction) in
            self.picker.sourceType = .camera
            self.present(self.picker, animated: true, completion: { })
        }))
        controller.addAction(UIAlertAction(title: "Cancel", style: .cancel, handler: { (UIAlertAction) in
                controller.dismiss(animated: true, completion: { })
        }))
        self.present(controller, animated: true, completion: {  })
    }
    
    @IBAction func OtherActions(_ sender: UIButton) {
        var identifier = String()
        switch sender.tag {
        case 0:
            identifier = "Settings"
            break
        case 1:
            UserDefaults.standard.set(false, forKey: "isLogged")
            Globals().killTimers()

            identifier = "Login"
            break
        default:
            break
        }
        let vc = self.storyboard?.instantiateViewController(withIdentifier: identifier)
        self.navigationController?.pushViewController(vc!, animated: true)
    }
    
    //MARK:-
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [String : Any]){
        picture.image = info[UIImagePickerControllerOriginalImage] as? UIImage
        self.picker.dismiss(animated: true, completion: {
        })
    }
    
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController){
        self.picker.dismiss(animated: true, completion: {
            
        })
    }
    
}
