<?php
/**
 * Instructor Feature Showcase
 *
 * @since 3.1.0
 */
if (! class_exists('irInstructorShowcase')) {
    class irInstructorShowcase{
        protected static $instance = null;
        protected $plugin_basename = '';
        public $redirect_url = '';

        public function __construct()
        {
            $this->plugin_basename = basename(INSTRUCTOR_ROLE_ABSPATH).'/instructor.php';
            $this->redirect_url = admin_url('/ir-showcase');

            add_action('init', array($this, 'irAddRewriteRule'));
            add_filter('query_vars', array($this, 'irAddQueryVariables'));
            add_filter('template_include', array($this, 'irDisplayShowcaseTemplate'));
            add_action('activate_'. $this->plugin_basename, array($this, 'irActivationHandle'));
            // add_action('upgrader_process_complete', array($this, 'irUpgradeHandle'), 10, 2);
            add_action('admin_init', array($this, 'irNewFeaturesNotice'));
        }

        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        public function irAddQueryVariables($vars)
        {
            if (false === array_search('ir-template', $vars)) {
                $vars[] = 'ir-template';
            }
            return $vars;
        }

        public function irAddRewriteRule()
        {
            add_rewrite_rule(
                '^wp-admin/ir-showcase/?$',
                'index.php?ir-template=showcase',
                'top'
            );
            flush_rewrite_rules();
        }

        public function irDisplayShowcaseTemplate($template)
        {
            global $wp_query;

            // If not logged in or not admin then return
            if (! is_user_logged_in() || ! current_user_can('manage_options')) {
                return $template;
            }

            if (get_query_var('ir-template')) {
                $template = INSTRUCTOR_ROLE_ABSPATH . 'templates/ir-feature-showcase.template.php';
            }

            return $template;
        }

        public static function irEnqueueShowcaseStyles()
        {
            wp_enqueue_style('ir-google-fonts', 'https://fonts.googleapis.com/css?family=Roboto');
            wp_register_style('ir-showcase-styles', plugins_url('admin/css/ir-showcase-styles.css', __DIR__), array('dashicons', 'ir-google-fonts'));
            wp_print_styles('ir-showcase-styles');
        }

        public static function irEnqueueShowcaseScripts()
        {
            wp_register_script('ir-showcase-script', plugins_url('admin/js/ir-showcase-script.js', __DIR__), array('jquery'));
            wp_print_scripts('ir-showcase-script');
        }

        public static function fetchPageData()
        {
            $page_data = array(
                'logo_url'     =>      plugins_url('admin/images/logo.svg', __DIR__),
                'logo_alt'     =>      __('WisdmLabs', 'instructor-role'),
                'admin_url'    =>      get_admin_url(),
                'img-1'        =>      plugins_url('admin/images/theme.png', __DIR__),
                'img-2'        =>      plugins_url('admin/images/visibility.png', __DIR__),
                'img-3'        =>      plugins_url('admin/images/overview-dashboard.png', __DIR__),
                'img-4'        =>      plugins_url('admin/images/multiple-instructors.png', __DIR__)
            );
            return $page_data;
        }

        public function irActivationHandle()
        {
            if (! get_option('ir-feature-showcase-init')) {
                add_option('ir-feature-showcase-init', 1);
            }
        }

        public function irNewFeaturesNotice()
        {
            // New features activation notice
            if (get_option('ir-feature-showcase-init') && ! get_option('ir-feature-showcase-demo')) {
                delete_option('ir-feature-showcase-init', 1);
                add_option('ir-feature-showcase-demo', 1);
                wp_safe_redirect($this->redirect_url);
            }
        }

        public function irUpgradeHandle($upgrader_object, $options)
        {
            if (! is_admin()) {
                return;
            }

            if ('update' == $options['action'] && 'plugin' == $options['type']) {
                foreach ($options['plugins'] as $pluginName) {
                    if (INSTRUCTOR_ROLE_BASE == $pluginName) {
                        $this->irActivationHandle();
                    }
                }
            }
        }
    }
}
