"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/* global window, exports, define */
!function () {
  'use strict';

  var re = {
    not_string: /[^s]/,
    not_bool: /[^t]/,
    not_type: /[^T]/,
    not_primitive: /[^v]/,
    number: /[diefg]/,
    numeric_arg: /[bcdiefguxX]/,
    json: /[j]/,
    not_json: /[^j]/,
    text: /^[^\x25]+/,
    modulo: /^\x25{2}/,
    placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
    key: /^([a-z_][a-z_\d]*)/i,
    key_access: /^\.([a-z_][a-z_\d]*)/i,
    index_access: /^\[(\d+)\]/,
    sign: /^[+-]/
  };

  function sprintf(key) {
    // `arguments` is not an array, but should be fine for this call
    return sprintf_format(sprintf_parse(key), arguments);
  }

  function vsprintf(fmt, argv) {
    return sprintf.apply(null, [fmt].concat(argv || []));
  }

  function sprintf_format(parse_tree, argv) {
    var cursor = 1,
        tree_length = parse_tree.length,
        arg,
        output = '',
        i,
        k,
        ph,
        pad,
        pad_character,
        pad_length,
        is_positive,
        sign;

    for (i = 0; i < tree_length; i++) {
      if (typeof parse_tree[i] === 'string') {
        output += parse_tree[i];
      } else if (_typeof(parse_tree[i]) === 'object') {
        ph = parse_tree[i]; // convenience purposes only

        if (ph.keys) {
          // keyword argument
          arg = argv[cursor];

          for (k = 0; k < ph.keys.length; k++) {
            if (arg == undefined) {
              throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
            }

            arg = arg[ph.keys[k]];
          }
        } else if (ph.param_no) {
          // positional argument (explicit)
          arg = argv[ph.param_no];
        } else {
          // positional argument (implicit)
          arg = argv[cursor++];
        }

        if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
          arg = arg();
        }

        if (re.numeric_arg.test(ph.type) && typeof arg !== 'number' && isNaN(arg)) {
          throw new TypeError(sprintf('[sprintf] expecting number but found %T', arg));
        }

        if (re.number.test(ph.type)) {
          is_positive = arg >= 0;
        }

        switch (ph.type) {
          case 'b':
            arg = parseInt(arg, 10).toString(2);
            break;

          case 'c':
            arg = String.fromCharCode(parseInt(arg, 10));
            break;

          case 'd':
          case 'i':
            arg = parseInt(arg, 10);
            break;

          case 'j':
            arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
            break;

          case 'e':
            arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
            break;

          case 'f':
            arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
            break;

          case 'g':
            arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
            break;

          case 'o':
            arg = (parseInt(arg, 10) >>> 0).toString(8);
            break;

          case 's':
            arg = String(arg);
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;

          case 't':
            arg = String(!!arg);
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;

          case 'T':
            arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;

          case 'u':
            arg = parseInt(arg, 10) >>> 0;
            break;

          case 'v':
            arg = arg.valueOf();
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;

          case 'x':
            arg = (parseInt(arg, 10) >>> 0).toString(16);
            break;

          case 'X':
            arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
            break;
        }

        if (re.json.test(ph.type)) {
          output += arg;
        } else {
          if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
            sign = is_positive ? '+' : '-';
            arg = arg.toString().replace(re.sign, '');
          } else {
            sign = '';
          }

          pad_character = ph.pad_char ? ph.pad_char === '0' ? '0' : ph.pad_char.charAt(1) : ' ';
          pad_length = ph.width - (sign + arg).length;
          pad = ph.width ? pad_length > 0 ? pad_character.repeat(pad_length) : '' : '';
          output += ph.align ? sign + arg + pad : pad_character === '0' ? sign + pad + arg : pad + sign + arg;
        }
      }
    }

    return output;
  }

  var sprintf_cache = Object.create(null);

  function sprintf_parse(fmt) {
    if (sprintf_cache[fmt]) {
      return sprintf_cache[fmt];
    }

    var _fmt = fmt,
        match,
        parse_tree = [],
        arg_names = 0;

    while (_fmt) {
      if ((match = re.text.exec(_fmt)) !== null) {
        parse_tree.push(match[0]);
      } else if ((match = re.modulo.exec(_fmt)) !== null) {
        parse_tree.push('%');
      } else if ((match = re.placeholder.exec(_fmt)) !== null) {
        if (match[2]) {
          arg_names |= 1;
          var field_list = [],
              replacement_field = match[2],
              field_match = [];

          if ((field_match = re.key.exec(replacement_field)) !== null) {
            field_list.push(field_match[1]);

            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== '') {
              if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
              } else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
              } else {
                throw new SyntaxError('[sprintf] failed to parse named argument key');
              }
            }
          } else {
            throw new SyntaxError('[sprintf] failed to parse named argument key');
          }

          match[2] = field_list;
        } else {
          arg_names |= 2;
        }

        if (arg_names === 3) {
          throw new Error('[sprintf] mixing positional and named placeholders is not (yet) supported');
        }

        parse_tree.push({
          placeholder: match[0],
          param_no: match[1],
          keys: match[2],
          sign: match[3],
          pad_char: match[4],
          align: match[5],
          width: match[6],
          precision: match[7],
          type: match[8]
        });
      } else {
        throw new SyntaxError('[sprintf] unexpected placeholder');
      }

      _fmt = _fmt.substring(match[0].length);
    }

    return sprintf_cache[fmt] = parse_tree;
  }
  /**
   * export to either browser or node.js
   */

  /* eslint-disable quote-props */


  if (typeof exports !== 'undefined') {
    exports['sprintf'] = sprintf;
    exports['vsprintf'] = vsprintf;
  }

  if (typeof window !== 'undefined') {
    window['sprintf'] = sprintf;
    window['vsprintf'] = vsprintf;

    if (typeof define === 'function' && define['amd']) {
      define(function () {
        return {
          'sprintf': sprintf,
          'vsprintf': vsprintf
        };
      });
    }
  }
  /* eslint-enable quote-props */

}(); // eslint-disable-line
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * Find whether a variable is a string
 *
 * @param   {mixed}     variable - The variable being evaluated
 * @return  {boolean}   TRUE if the variable is an string
 */
function isString(string) {
  return typeof string === 'string';
}
/**
 * Find whether a variable is an object
 *
 * @param   {mixed}     variable - The variable being evaluated
 * @return  {boolean}   TRUE if the variable is an object
 */


function isObject(variable) {
  return variable !== null && _typeof(variable) === 'object';
}
/**
 * Remove all spaces from a string
 *
 * @param   {string}    String
 * @return  {string}    String without spaces
 */


function removeSpaces(string) {
  return string.replace(/\s/g, '');
}
/**
 * Check if a value exists in an array
 * If the needle is an array then it will check if all his elements exists in the haystack
 *
 * @param   {mixed}     needle - The searched value. The comparison between values is strict. If the needle is an array then it will check if all his elements exists in the haystack
 * @param   {array}     haystack - An array through which to search.
 *
 * @return  {boolean} TRUE if needle is found in the array or if needle is an array, TRUE if all the elements from the needle are in haystack
 */


function inArray(needle, haystack) {
  var response = false;

  if (Array.isArray(needle)) {
    // Check that all the elements from the array "value" are in the array "array"
    response = arrayDifference(needle, haystack).length == 0;
  } else {
    // Check if one element is in an array
    response = $.inArray(needle, haystack) !== -1;
  }

  return response;
}
/**
 * Determine if a variable is set and is not NULL
 *
 * @param  {mixed}      variable - The variable being evaluated
 * @return {boolean}    TRUE if the variable is defined
 */


function isDefined(variable) {
  // Returns true if the variable is undefined
  return typeof variable !== 'undefined' && variable !== null;
}
/**
 * Determine whether a variable is empty
 *
 * @param   {mixed}     variable - The variable being evaluated
 * @return  {boolean}   TRUE if the variable is empty
 */


function isEmpty(variable) {
  var response = true; // Check if the variable is defined, otherwise is empty

  if (isDefined(variable)) {
    // Check if it's array
    if ($.isArray(variable)) {
      response = variable.length == 0;
    } else if (isObject(variable)) {
      response = $.isEmptyObject(variable);
    } else {
      response = variable == '';
    }
  }

  return response;
}
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*! Select2 4.0.6-rc.1 | https://github.com/select2/select2/blob/master/LICENSE.md */
!function (a) {
  "function" == typeof define && define.amd ? define(["jquery"], a) : "object" == (typeof module === "undefined" ? "undefined" : _typeof(module)) && module.exports ? module.exports = function (b, c) {
    return void 0 === c && (c = "undefined" != typeof window ? require("jquery") : require("jquery")(b)), a(c), c;
  } : a(jQuery);
}(function (a) {
  var b = function () {
    if (a && a.fn && a.fn.select2 && a.fn.select2.amd) var b = a.fn.select2.amd;
    var b;
    return function () {
      if (!b || !b.requirejs) {
        b ? c = b : b = {};
        var a, c, d;
        !function (b) {
          function e(a, b) {
            return v.call(a, b);
          }

          function f(a, b) {
            var c,
                d,
                e,
                f,
                g,
                h,
                i,
                j,
                k,
                l,
                m,
                n,
                o = b && b.split("/"),
                p = t.map,
                q = p && p["*"] || {};

            if (a) {
              for (a = a.split("/"), g = a.length - 1, t.nodeIdCompat && x.test(a[g]) && (a[g] = a[g].replace(x, "")), "." === a[0].charAt(0) && o && (n = o.slice(0, o.length - 1), a = n.concat(a)), k = 0; k < a.length; k++) {
                if ("." === (m = a[k])) a.splice(k, 1), k -= 1;else if (".." === m) {
                  if (0 === k || 1 === k && ".." === a[2] || ".." === a[k - 1]) continue;
                  k > 0 && (a.splice(k - 1, 2), k -= 2);
                }
              }

              a = a.join("/");
            }

            if ((o || q) && p) {
              for (c = a.split("/"), k = c.length; k > 0; k -= 1) {
                if (d = c.slice(0, k).join("/"), o) for (l = o.length; l > 0; l -= 1) {
                  if ((e = p[o.slice(0, l).join("/")]) && (e = e[d])) {
                    f = e, h = k;
                    break;
                  }
                }
                if (f) break;
                !i && q && q[d] && (i = q[d], j = k);
              }

              !f && i && (f = i, h = j), f && (c.splice(0, h, f), a = c.join("/"));
            }

            return a;
          }

          function g(a, c) {
            return function () {
              var d = w.call(arguments, 0);
              return "string" != typeof d[0] && 1 === d.length && d.push(null), _o.apply(b, d.concat([a, c]));
            };
          }

          function h(a) {
            return function (b) {
              return f(b, a);
            };
          }

          function i(a) {
            return function (b) {
              r[a] = b;
            };
          }

          function j(a) {
            if (e(s, a)) {
              var c = s[a];
              delete s[a], u[a] = !0, n.apply(b, c);
            }

            if (!e(r, a) && !e(u, a)) throw new Error("No " + a);
            return r[a];
          }

          function k(a) {
            var b,
                c = a ? a.indexOf("!") : -1;
            return c > -1 && (b = a.substring(0, c), a = a.substring(c + 1, a.length)), [b, a];
          }

          function l(a) {
            return a ? k(a) : [];
          }

          function m(a) {
            return function () {
              return t && t.config && t.config[a] || {};
            };
          }

          var n,
              _o,
              p,
              q,
              r = {},
              s = {},
              t = {},
              u = {},
              v = Object.prototype.hasOwnProperty,
              w = [].slice,
              x = /\.js$/;

          p = function p(a, b) {
            var c,
                d = k(a),
                e = d[0],
                g = b[1];
            return a = d[1], e && (e = f(e, g), c = j(e)), e ? a = c && c.normalize ? c.normalize(a, h(g)) : f(a, g) : (a = f(a, g), d = k(a), e = d[0], a = d[1], e && (c = j(e))), {
              f: e ? e + "!" + a : a,
              n: a,
              pr: e,
              p: c
            };
          }, q = {
            require: function require(a) {
              return g(a);
            },
            exports: function exports(a) {
              var b = r[a];
              return void 0 !== b ? b : r[a] = {};
            },
            module: function module(a) {
              return {
                id: a,
                uri: "",
                exports: r[a],
                config: m(a)
              };
            }
          }, n = function n(a, c, d, f) {
            var h,
                k,
                m,
                n,
                o,
                t,
                v,
                w = [],
                x = _typeof(d);

            if (f = f || a, t = l(f), "undefined" === x || "function" === x) {
              for (c = !c.length && d.length ? ["require", "exports", "module"] : c, o = 0; o < c.length; o += 1) {
                if (n = p(c[o], t), "require" === (k = n.f)) w[o] = q.require(a);else if ("exports" === k) w[o] = q.exports(a), v = !0;else if ("module" === k) h = w[o] = q.module(a);else if (e(r, k) || e(s, k) || e(u, k)) w[o] = j(k);else {
                  if (!n.p) throw new Error(a + " missing " + k);
                  n.p.load(n.n, g(f, !0), i(k), {}), w[o] = r[k];
                }
              }

              m = d ? d.apply(r[a], w) : void 0, a && (h && h.exports !== b && h.exports !== r[a] ? r[a] = h.exports : m === b && v || (r[a] = m));
            } else a && (r[a] = d);
          }, a = c = _o = function o(a, c, d, e, f) {
            if ("string" == typeof a) return q[a] ? q[a](c) : j(p(a, l(c)).f);

            if (!a.splice) {
              if (t = a, t.deps && _o(t.deps, t.callback), !c) return;
              c.splice ? (a = c, c = d, d = null) : a = b;
            }

            return c = c || function () {}, "function" == typeof d && (d = e, e = f), e ? n(b, a, c, d) : setTimeout(function () {
              n(b, a, c, d);
            }, 4), _o;
          }, _o.config = function (a) {
            return _o(a);
          }, a._defined = r, d = function d(a, b, c) {
            if ("string" != typeof a) throw new Error("See almond README: incorrect module build, no module name");
            b.splice || (c = b, b = []), e(r, a) || e(s, a) || (s[a] = [a, b, c]);
          }, d.amd = {
            jQuery: !0
          };
        }(), b.requirejs = a, b.require = c, b.define = d;
      }
    }(), b.define("almond", function () {}), b.define("jquery", [], function () {
      var b = a || $;
      return null == b && console && console.error && console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."), b;
    }), b.define("select2/utils", ["jquery"], function (a) {
      function b(a) {
        var b = a.prototype,
            c = [];

        for (var d in b) {
          "function" == typeof b[d] && "constructor" !== d && c.push(d);
        }

        return c;
      }

      var c = {};
      c.Extend = function (a, b) {
        function c() {
          this.constructor = a;
        }

        var d = {}.hasOwnProperty;

        for (var e in b) {
          d.call(b, e) && (a[e] = b[e]);
        }

        return c.prototype = b.prototype, a.prototype = new c(), a.__super__ = b.prototype, a;
      }, c.Decorate = function (a, c) {
        function d() {
          var b = Array.prototype.unshift,
              d = c.prototype.constructor.length,
              e = a.prototype.constructor;
          d > 0 && (b.call(arguments, a.prototype.constructor), e = c.prototype.constructor), e.apply(this, arguments);
        }

        function e() {
          this.constructor = d;
        }

        var f = b(c),
            g = b(a);
        c.displayName = a.displayName, d.prototype = new e();

        for (var h = 0; h < g.length; h++) {
          var i = g[h];
          d.prototype[i] = a.prototype[i];
        }

        for (var j = function j(a) {
          var b = function b() {};

          (a in d.prototype) && (b = d.prototype[a]);
          var e = c.prototype[a];
          return function () {
            return Array.prototype.unshift.call(arguments, b), e.apply(this, arguments);
          };
        }, k = 0; k < f.length; k++) {
          var l = f[k];
          d.prototype[l] = j(l);
        }

        return d;
      };

      var d = function d() {
        this.listeners = {};
      };

      d.prototype.on = function (a, b) {
        this.listeners = this.listeners || {}, a in this.listeners ? this.listeners[a].push(b) : this.listeners[a] = [b];
      }, d.prototype.trigger = function (a) {
        var b = Array.prototype.slice,
            c = b.call(arguments, 1);
        this.listeners = this.listeners || {}, null == c && (c = []), 0 === c.length && c.push({}), c[0]._type = a, a in this.listeners && this.invoke(this.listeners[a], b.call(arguments, 1)), "*" in this.listeners && this.invoke(this.listeners["*"], arguments);
      }, d.prototype.invoke = function (a, b) {
        for (var c = 0, d = a.length; c < d; c++) {
          a[c].apply(this, b);
        }
      }, c.Observable = d, c.generateChars = function (a) {
        for (var b = "", c = 0; c < a; c++) {
          b += Math.floor(36 * Math.random()).toString(36);
        }

        return b;
      }, c.bind = function (a, b) {
        return function () {
          a.apply(b, arguments);
        };
      }, c._convertData = function (a) {
        for (var b in a) {
          var c = b.split("-"),
              d = a;

          if (1 !== c.length) {
            for (var e = 0; e < c.length; e++) {
              var f = c[e];
              f = f.substring(0, 1).toLowerCase() + f.substring(1), f in d || (d[f] = {}), e == c.length - 1 && (d[f] = a[b]), d = d[f];
            }

            delete a[b];
          }
        }

        return a;
      }, c.hasScroll = function (b, c) {
        var d = a(c),
            e = c.style.overflowX,
            f = c.style.overflowY;
        return (e !== f || "hidden" !== f && "visible" !== f) && ("scroll" === e || "scroll" === f || d.innerHeight() < c.scrollHeight || d.innerWidth() < c.scrollWidth);
      }, c.escapeMarkup = function (a) {
        var b = {
          "\\": "&#92;",
          "&": "&amp;",
          "<": "&lt;",
          ">": "&gt;",
          '"': "&quot;",
          "'": "&#39;",
          "/": "&#47;"
        };
        return "string" != typeof a ? a : String(a).replace(/[&<>"'\/\\]/g, function (a) {
          return b[a];
        });
      }, c.appendMany = function (b, c) {
        if ("1.7" === a.fn.jquery.substr(0, 3)) {
          var d = a();
          a.map(c, function (a) {
            d = d.add(a);
          }), c = d;
        }

        b.append(c);
      }, c.__cache = {};
      var e = 0;
      return c.GetUniqueElementId = function (a) {
        var b = a.getAttribute("data-select2-id");
        return null == b && (a.id ? (b = a.id, a.setAttribute("data-select2-id", b)) : (a.setAttribute("data-select2-id", ++e), b = e.toString())), b;
      }, c.StoreData = function (a, b, d) {
        var e = c.GetUniqueElementId(a);
        c.__cache[e] || (c.__cache[e] = {}), c.__cache[e][b] = d;
      }, c.GetData = function (b, d) {
        var e = c.GetUniqueElementId(b);
        return d ? c.__cache[e] && null != c.__cache[e][d] ? c.__cache[e][d] : a(b).data(d) : c.__cache[e];
      }, c.RemoveData = function (a) {
        var b = c.GetUniqueElementId(a);
        null != c.__cache[b] && delete c.__cache[b];
      }, c;
    }), b.define("select2/results", ["jquery", "./utils"], function (a, b) {
      function c(a, b, d) {
        this.$element = a, this.data = d, this.options = b, c.__super__.constructor.call(this);
      }

      return b.Extend(c, b.Observable), c.prototype.render = function () {
        var b = a('<ul class="select2-results__options" role="tree"></ul>');
        return this.options.get("multiple") && b.attr("aria-multiselectable", "true"), this.$results = b, b;
      }, c.prototype.clear = function () {
        this.$results.empty();
      }, c.prototype.displayMessage = function (b) {
        var c = this.options.get("escapeMarkup");
        this.clear(), this.hideLoading();
        var d = a('<li role="treeitem" aria-live="assertive" class="select2-results__option"></li>'),
            e = this.options.get("translations").get(b.message);
        d.append(c(e(b.args))), d[0].className += " select2-results__message", this.$results.append(d);
      }, c.prototype.hideMessages = function () {
        this.$results.find(".select2-results__message").remove();
      }, c.prototype.append = function (a) {
        this.hideLoading();
        var b = [];
        if (null == a.results || 0 === a.results.length) return void (0 === this.$results.children().length && this.trigger("results:message", {
          message: "noResults"
        }));
        a.results = this.sort(a.results);

        for (var c = 0; c < a.results.length; c++) {
          var d = a.results[c],
              e = this.option(d);
          b.push(e);
        }

        this.$results.append(b);
      }, c.prototype.position = function (a, b) {
        b.find(".select2-results").append(a);
      }, c.prototype.sort = function (a) {
        return this.options.get("sorter")(a);
      }, c.prototype.highlightFirstItem = function () {
        var a = this.$results.find(".select2-results__option[aria-selected]"),
            b = a.filter("[aria-selected=true]");
        b.length > 0 ? b.first().trigger("mouseenter") : a.first().trigger("mouseenter"), this.ensureHighlightVisible();
      }, c.prototype.setClasses = function () {
        var c = this;
        this.data.current(function (d) {
          var e = a.map(d, function (a) {
            return a.id.toString();
          });
          c.$results.find(".select2-results__option[aria-selected]").each(function () {
            var c = a(this),
                d = b.GetData(this, "data"),
                f = "" + d.id;
            null != d.element && d.element.selected || null == d.element && a.inArray(f, e) > -1 ? c.attr("aria-selected", "true") : c.attr("aria-selected", "false");
          });
        });
      }, c.prototype.showLoading = function (a) {
        this.hideLoading();
        var b = this.options.get("translations").get("searching"),
            c = {
          disabled: !0,
          loading: !0,
          text: b(a)
        },
            d = this.option(c);
        d.className += " loading-results", this.$results.prepend(d);
      }, c.prototype.hideLoading = function () {
        this.$results.find(".loading-results").remove();
      }, c.prototype.option = function (c) {
        var d = document.createElement("li");
        d.className = "select2-results__option";
        var e = {
          role: "treeitem",
          "aria-selected": "false"
        };
        c.disabled && (delete e["aria-selected"], e["aria-disabled"] = "true"), null == c.id && delete e["aria-selected"], null != c._resultId && (d.id = c._resultId), c.title && (d.title = c.title), c.children && (e.role = "group", e["aria-label"] = c.text, delete e["aria-selected"]);

        for (var f in e) {
          var g = e[f];
          d.setAttribute(f, g);
        }

        if (c.children) {
          var h = a(d),
              i = document.createElement("strong");
          i.className = "select2-results__group";
          a(i);
          this.template(c, i);

          for (var j = [], k = 0; k < c.children.length; k++) {
            var l = c.children[k],
                m = this.option(l);
            j.push(m);
          }

          var n = a("<ul></ul>", {
            class: "select2-results__options select2-results__options--nested"
          });
          n.append(j), h.append(i), h.append(n);
        } else this.template(c, d);

        return b.StoreData(d, "data", c), d;
      }, c.prototype.bind = function (c, d) {
        var e = this,
            f = c.id + "-results";
        this.$results.attr("id", f), c.on("results:all", function (a) {
          e.clear(), e.append(a.data), c.isOpen() && (e.setClasses(), e.highlightFirstItem());
        }), c.on("results:append", function (a) {
          e.append(a.data), c.isOpen() && e.setClasses();
        }), c.on("query", function (a) {
          e.hideMessages(), e.showLoading(a);
        }), c.on("select", function () {
          c.isOpen() && (e.setClasses(), e.highlightFirstItem());
        }), c.on("unselect", function () {
          c.isOpen() && (e.setClasses(), e.highlightFirstItem());
        }), c.on("open", function () {
          e.$results.attr("aria-expanded", "true"), e.$results.attr("aria-hidden", "false"), e.setClasses(), e.ensureHighlightVisible();
        }), c.on("close", function () {
          e.$results.attr("aria-expanded", "false"), e.$results.attr("aria-hidden", "true"), e.$results.removeAttr("aria-activedescendant");
        }), c.on("results:toggle", function () {
          var a = e.getHighlightedResults();
          0 !== a.length && a.trigger("mouseup");
        }), c.on("results:select", function () {
          var a = e.getHighlightedResults();

          if (0 !== a.length) {
            var c = b.GetData(a[0], "data");
            "true" == a.attr("aria-selected") ? e.trigger("close", {}) : e.trigger("select", {
              data: c
            });
          }
        }), c.on("results:previous", function () {
          var a = e.getHighlightedResults(),
              b = e.$results.find("[aria-selected]"),
              c = b.index(a);

          if (!(c <= 0)) {
            var d = c - 1;
            0 === a.length && (d = 0);
            var f = b.eq(d);
            f.trigger("mouseenter");
            var g = e.$results.offset().top,
                h = f.offset().top,
                i = e.$results.scrollTop() + (h - g);
            0 === d ? e.$results.scrollTop(0) : h - g < 0 && e.$results.scrollTop(i);
          }
        }), c.on("results:next", function () {
          var a = e.getHighlightedResults(),
              b = e.$results.find("[aria-selected]"),
              c = b.index(a),
              d = c + 1;

          if (!(d >= b.length)) {
            var f = b.eq(d);
            f.trigger("mouseenter");
            var g = e.$results.offset().top + e.$results.outerHeight(!1),
                h = f.offset().top + f.outerHeight(!1),
                i = e.$results.scrollTop() + h - g;
            0 === d ? e.$results.scrollTop(0) : h > g && e.$results.scrollTop(i);
          }
        }), c.on("results:focus", function (a) {
          a.element.addClass("select2-results__option--highlighted");
        }), c.on("results:message", function (a) {
          e.displayMessage(a);
        }), a.fn.mousewheel && this.$results.on("mousewheel", function (a) {
          var b = e.$results.scrollTop(),
              c = e.$results.get(0).scrollHeight - b + a.deltaY,
              d = a.deltaY > 0 && b - a.deltaY <= 0,
              f = a.deltaY < 0 && c <= e.$results.height();
          d ? (e.$results.scrollTop(0), a.preventDefault(), a.stopPropagation()) : f && (e.$results.scrollTop(e.$results.get(0).scrollHeight - e.$results.height()), a.preventDefault(), a.stopPropagation());
        }), this.$results.on("mouseup", ".select2-results__option[aria-selected]", function (c) {
          var d = a(this),
              f = b.GetData(this, "data");
          if ("true" === d.attr("aria-selected")) return void (e.options.get("multiple") ? e.trigger("unselect", {
            originalEvent: c,
            data: f
          }) : e.trigger("close", {}));
          e.trigger("select", {
            originalEvent: c,
            data: f
          });
        }), this.$results.on("mouseenter", ".select2-results__option[aria-selected]", function (c) {
          var d = b.GetData(this, "data");
          e.getHighlightedResults().removeClass("select2-results__option--highlighted"), e.trigger("results:focus", {
            data: d,
            element: a(this)
          });
        });
      }, c.prototype.getHighlightedResults = function () {
        return this.$results.find(".select2-results__option--highlighted");
      }, c.prototype.destroy = function () {
        this.$results.remove();
      }, c.prototype.ensureHighlightVisible = function () {
        var a = this.getHighlightedResults();

        if (0 !== a.length) {
          var b = this.$results.find("[aria-selected]"),
              c = b.index(a),
              d = this.$results.offset().top,
              e = a.offset().top,
              f = this.$results.scrollTop() + (e - d),
              g = e - d;
          f -= 2 * a.outerHeight(!1), c <= 2 ? this.$results.scrollTop(0) : (g > this.$results.outerHeight() || g < 0) && this.$results.scrollTop(f);
        }
      }, c.prototype.template = function (b, c) {
        var d = this.options.get("templateResult"),
            e = this.options.get("escapeMarkup"),
            f = d(b, c);
        null == f ? c.style.display = "none" : "string" == typeof f ? c.innerHTML = e(f) : a(c).append(f);
      }, c;
    }), b.define("select2/keys", [], function () {
      return {
        BACKSPACE: 8,
        TAB: 9,
        ENTER: 13,
        SHIFT: 16,
        CTRL: 17,
        ALT: 18,
        ESC: 27,
        SPACE: 32,
        PAGE_UP: 33,
        PAGE_DOWN: 34,
        END: 35,
        HOME: 36,
        LEFT: 37,
        UP: 38,
        RIGHT: 39,
        DOWN: 40,
        DELETE: 46
      };
    }), b.define("select2/selection/base", ["jquery", "../utils", "../keys"], function (a, b, c) {
      function d(a, b) {
        this.$element = a, this.options = b, d.__super__.constructor.call(this);
      }

      return b.Extend(d, b.Observable), d.prototype.render = function () {
        var c = a('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');
        return this._tabindex = 0, null != b.GetData(this.$element[0], "old-tabindex") ? this._tabindex = b.GetData(this.$element[0], "old-tabindex") : null != this.$element.attr("tabindex") && (this._tabindex = this.$element.attr("tabindex")), c.attr("title", this.$element.attr("title")), c.attr("tabindex", this._tabindex), this.$selection = c, c;
      }, d.prototype.bind = function (a, b) {
        var d = this,
            e = (a.id, a.id + "-results");
        this.container = a, this.$selection.on("focus", function (a) {
          d.trigger("focus", a);
        }), this.$selection.on("blur", function (a) {
          d._handleBlur(a);
        }), this.$selection.on("keydown", function (a) {
          d.trigger("keypress", a), a.which === c.SPACE && a.preventDefault();
        }), a.on("results:focus", function (a) {
          d.$selection.attr("aria-activedescendant", a.data._resultId);
        }), a.on("selection:update", function (a) {
          d.update(a.data);
        }), a.on("open", function () {
          d.$selection.attr("aria-expanded", "true"), d.$selection.attr("aria-owns", e), d._attachCloseHandler(a);
        }), a.on("close", function () {
          d.$selection.attr("aria-expanded", "false"), d.$selection.removeAttr("aria-activedescendant"), d.$selection.removeAttr("aria-owns"), d.$selection.focus(), window.setTimeout(function () {
            d.$selection.focus();
          }, 0), d._detachCloseHandler(a);
        }), a.on("enable", function () {
          d.$selection.attr("tabindex", d._tabindex);
        }), a.on("disable", function () {
          d.$selection.attr("tabindex", "-1");
        });
      }, d.prototype._handleBlur = function (b) {
        var c = this;
        window.setTimeout(function () {
          document.activeElement == c.$selection[0] || a.contains(c.$selection[0], document.activeElement) || c.trigger("blur", b);
        }, 1);
      }, d.prototype._attachCloseHandler = function (c) {
        a(document.body).on("mousedown.select2." + c.id, function (c) {
          var d = a(c.target),
              e = d.closest(".select2");
          a(".select2.select2-container--open").each(function () {
            a(this), this != e[0] && b.GetData(this, "element").select2("close");
          });
        });
      }, d.prototype._detachCloseHandler = function (b) {
        a(document.body).off("mousedown.select2." + b.id);
      }, d.prototype.position = function (a, b) {
        b.find(".selection").append(a);
      }, d.prototype.destroy = function () {
        this._detachCloseHandler(this.container);
      }, d.prototype.update = function (a) {
        throw new Error("The `update` method must be defined in child classes.");
      }, d;
    }), b.define("select2/selection/single", ["jquery", "./base", "../utils", "../keys"], function (a, b, c, d) {
      function e() {
        e.__super__.constructor.apply(this, arguments);
      }

      return c.Extend(e, b), e.prototype.render = function () {
        var a = e.__super__.render.call(this);

        return a.addClass("select2-selection--single"), a.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'), a;
      }, e.prototype.bind = function (a, b) {
        var c = this;

        e.__super__.bind.apply(this, arguments);

        var d = a.id + "-container";
        this.$selection.find(".select2-selection__rendered").attr("id", d).attr("role", "textbox").attr("aria-readonly", "true"), this.$selection.attr("aria-labelledby", d), this.$selection.on("mousedown", function (a) {
          1 === a.which && c.trigger("toggle", {
            originalEvent: a
          });
        }), this.$selection.on("focus", function (a) {}), this.$selection.on("blur", function (a) {}), a.on("focus", function (b) {
          a.isOpen() || c.$selection.focus();
        });
      }, e.prototype.clear = function () {
        var a = this.$selection.find(".select2-selection__rendered");
        a.empty(), a.removeAttr("title");
      }, e.prototype.display = function (a, b) {
        var c = this.options.get("templateSelection");
        return this.options.get("escapeMarkup")(c(a, b));
      }, e.prototype.selectionContainer = function () {
        return a("<span></span>");
      }, e.prototype.update = function (a) {
        if (0 === a.length) return void this.clear();
        var b = a[0],
            c = this.$selection.find(".select2-selection__rendered"),
            d = this.display(b, c);
        c.empty().append(d), c.attr("title", b.title || b.text);
      }, e;
    }), b.define("select2/selection/multiple", ["jquery", "./base", "../utils"], function (a, b, c) {
      function d(a, b) {
        d.__super__.constructor.apply(this, arguments);
      }

      return c.Extend(d, b), d.prototype.render = function () {
        var a = d.__super__.render.call(this);

        return a.addClass("select2-selection--multiple"), a.html('<ul class="select2-selection__rendered"></ul>'), a;
      }, d.prototype.bind = function (b, e) {
        var f = this;
        d.__super__.bind.apply(this, arguments), this.$selection.on("click", function (a) {
          f.trigger("toggle", {
            originalEvent: a
          });
        }), this.$selection.on("click", ".select2-selection__choice__remove", function (b) {
          if (!f.options.get("disabled")) {
            var d = a(this),
                e = d.parent(),
                g = c.GetData(e[0], "data");
            f.trigger("unselect", {
              originalEvent: b,
              data: g
            });
          }
        });
      }, d.prototype.clear = function () {
        var a = this.$selection.find(".select2-selection__rendered");
        a.empty(), a.removeAttr("title");
      }, d.prototype.display = function (a, b) {
        var c = this.options.get("templateSelection");
        return this.options.get("escapeMarkup")(c(a, b));
      }, d.prototype.selectionContainer = function () {
        return a('<li class="select2-selection__choice"><span class="select2-selection__choice__remove" role="presentation">&times;</span></li>');
      }, d.prototype.update = function (a) {
        if (this.clear(), 0 !== a.length) {
          for (var b = [], d = 0; d < a.length; d++) {
            var e = a[d],
                f = this.selectionContainer(),
                g = this.display(e, f);
            f.append(g), f.attr("title", e.title || e.text), c.StoreData(f[0], "data", e), b.push(f);
          }

          var h = this.$selection.find(".select2-selection__rendered");
          c.appendMany(h, b);
        }
      }, d;
    }), b.define("select2/selection/placeholder", ["../utils"], function (a) {
      function b(a, b, c) {
        this.placeholder = this.normalizePlaceholder(c.get("placeholder")), a.call(this, b, c);
      }

      return b.prototype.normalizePlaceholder = function (a, b) {
        return "string" == typeof b && (b = {
          id: "",
          text: b
        }), b;
      }, b.prototype.createPlaceholder = function (a, b) {
        var c = this.selectionContainer();
        return c.html(this.display(b)), c.addClass("select2-selection__placeholder").removeClass("select2-selection__choice"), c;
      }, b.prototype.update = function (a, b) {
        var c = 1 == b.length && b[0].id != this.placeholder.id;
        if (b.length > 1 || c) return a.call(this, b);
        this.clear();
        var d = this.createPlaceholder(this.placeholder);
        this.$selection.find(".select2-selection__rendered").append(d);
      }, b;
    }), b.define("select2/selection/allowClear", ["jquery", "../keys", "../utils"], function (a, b, c) {
      function d() {}

      return d.prototype.bind = function (a, b, c) {
        var d = this;
        a.call(this, b, c), null == this.placeholder && this.options.get("debug") && window.console && console.error && console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."), this.$selection.on("mousedown", ".select2-selection__clear", function (a) {
          d._handleClear(a);
        }), b.on("keypress", function (a) {
          d._handleKeyboardClear(a, b);
        });
      }, d.prototype._handleClear = function (a, b) {
        if (!this.options.get("disabled")) {
          var d = this.$selection.find(".select2-selection__clear");

          if (0 !== d.length) {
            b.stopPropagation();
            var e = c.GetData(d[0], "data"),
                f = this.$element.val();
            this.$element.val(this.placeholder.id);
            var g = {
              data: e
            };
            if (this.trigger("clear", g), g.prevented) return void this.$element.val(f);

            for (var h = 0; h < e.length; h++) {
              if (g = {
                data: e[h]
              }, this.trigger("unselect", g), g.prevented) return void this.$element.val(f);
            }

            this.$element.trigger("change"), this.trigger("toggle", {});
          }
        }
      }, d.prototype._handleKeyboardClear = function (a, c, d) {
        d.isOpen() || c.which != b.DELETE && c.which != b.BACKSPACE || this._handleClear(c);
      }, d.prototype.update = function (b, d) {
        if (b.call(this, d), !(this.$selection.find(".select2-selection__placeholder").length > 0 || 0 === d.length)) {
          var e = a('<span class="select2-selection__clear">&times;</span>');
          c.StoreData(e[0], "data", d), this.$selection.find(".select2-selection__rendered").prepend(e);
        }
      }, d;
    }), b.define("select2/selection/search", ["jquery", "../utils", "../keys"], function (a, b, c) {
      function d(a, b, c) {
        a.call(this, b, c);
      }

      return d.prototype.render = function (b) {
        var c = a('<li class="select2-search select2-search--inline"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="textbox" aria-autocomplete="list" /></li>');
        this.$searchContainer = c, this.$search = c.find("input");
        var d = b.call(this);
        return this._transferTabIndex(), d;
      }, d.prototype.bind = function (a, d, e) {
        var f = this;
        a.call(this, d, e), d.on("open", function () {
          f.$search.trigger("focus");
        }), d.on("close", function () {
          f.$search.val(""), f.$search.removeAttr("aria-activedescendant"), f.$search.trigger("focus");
        }), d.on("enable", function () {
          f.$search.prop("disabled", !1), f._transferTabIndex();
        }), d.on("disable", function () {
          f.$search.prop("disabled", !0);
        }), d.on("focus", function (a) {
          f.$search.trigger("focus");
        }), d.on("results:focus", function (a) {
          f.$search.attr("aria-activedescendant", a.id);
        }), this.$selection.on("focusin", ".select2-search--inline", function (a) {
          f.trigger("focus", a);
        }), this.$selection.on("focusout", ".select2-search--inline", function (a) {
          f._handleBlur(a);
        }), this.$selection.on("keydown", ".select2-search--inline", function (a) {
          if (a.stopPropagation(), f.trigger("keypress", a), f._keyUpPrevented = a.isDefaultPrevented(), a.which === c.BACKSPACE && "" === f.$search.val()) {
            var d = f.$searchContainer.prev(".select2-selection__choice");

            if (d.length > 0) {
              var e = b.GetData(d[0], "data");
              f.searchRemoveChoice(e), a.preventDefault();
            }
          }
        });
        var g = document.documentMode,
            h = g && g <= 11;
        this.$selection.on("input.searchcheck", ".select2-search--inline", function (a) {
          if (h) return void f.$selection.off("input.search input.searchcheck");
          f.$selection.off("keyup.search");
        }), this.$selection.on("keyup.search input.search", ".select2-search--inline", function (a) {
          if (h && "input" === a.type) return void f.$selection.off("input.search input.searchcheck");
          var b = a.which;
          b != c.SHIFT && b != c.CTRL && b != c.ALT && b != c.TAB && f.handleSearch(a);
        });
      }, d.prototype._transferTabIndex = function (a) {
        this.$search.attr("tabindex", this.$selection.attr("tabindex")), this.$selection.attr("tabindex", "-1");
      }, d.prototype.createPlaceholder = function (a, b) {
        this.$search.attr("placeholder", b.text);
      }, d.prototype.update = function (a, b) {
        var c = this.$search[0] == document.activeElement;

        if (this.$search.attr("placeholder", ""), a.call(this, b), this.$selection.find(".select2-selection__rendered").append(this.$searchContainer), this.resizeSearch(), c) {
          this.$element.find("[data-select2-tag]").length ? this.$element.focus() : this.$search.focus();
        }
      }, d.prototype.handleSearch = function () {
        if (this.resizeSearch(), !this._keyUpPrevented) {
          var a = this.$search.val();
          this.trigger("query", {
            term: a
          });
        }

        this._keyUpPrevented = !1;
      }, d.prototype.searchRemoveChoice = function (a, b) {
        this.trigger("unselect", {
          data: b
        }), this.$search.val(b.text), this.handleSearch();
      }, d.prototype.resizeSearch = function () {
        this.$search.css("width", "25px");
        var a = "";
        if ("" !== this.$search.attr("placeholder")) a = this.$selection.find(".select2-selection__rendered").innerWidth();else {
          a = .75 * (this.$search.val().length + 1) + "em";
        }
        this.$search.css("width", a);
      }, d;
    }), b.define("select2/selection/eventRelay", ["jquery"], function (a) {
      function b() {}

      return b.prototype.bind = function (b, c, d) {
        var e = this,
            f = ["open", "opening", "close", "closing", "select", "selecting", "unselect", "unselecting", "clear", "clearing"],
            g = ["opening", "closing", "selecting", "unselecting", "clearing"];
        b.call(this, c, d), c.on("*", function (b, c) {
          if (-1 !== a.inArray(b, f)) {
            c = c || {};
            var d = a.Event("select2:" + b, {
              params: c
            });
            e.$element.trigger(d), -1 !== a.inArray(b, g) && (c.prevented = d.isDefaultPrevented());
          }
        });
      }, b;
    }), b.define("select2/translation", ["jquery", "require"], function (a, b) {
      function c(a) {
        this.dict = a || {};
      }

      return c.prototype.all = function () {
        return this.dict;
      }, c.prototype.get = function (a) {
        return this.dict[a];
      }, c.prototype.extend = function (b) {
        this.dict = a.extend({}, b.all(), this.dict);
      }, c._cache = {}, c.loadPath = function (a) {
        if (!(a in c._cache)) {
          var d = b(a);
          c._cache[a] = d;
        }

        return new c(c._cache[a]);
      }, c;
    }), b.define("select2/diacritics", [], function () {
      return {
        "Ⓐ": "A",
        "Ａ": "A",
        "À": "A",
        "Á": "A",
        "Â": "A",
        "Ầ": "A",
        "Ấ": "A",
        "Ẫ": "A",
        "Ẩ": "A",
        "Ã": "A",
        "Ā": "A",
        "Ă": "A",
        "Ằ": "A",
        "Ắ": "A",
        "Ẵ": "A",
        "Ẳ": "A",
        "Ȧ": "A",
        "Ǡ": "A",
        "Ä": "A",
        "Ǟ": "A",
        "Ả": "A",
        "Å": "A",
        "Ǻ": "A",
        "Ǎ": "A",
        "Ȁ": "A",
        "Ȃ": "A",
        "Ạ": "A",
        "Ậ": "A",
        "Ặ": "A",
        "Ḁ": "A",
        "Ą": "A",
        "Ⱥ": "A",
        "Ɐ": "A",
        "Ꜳ": "AA",
        "Æ": "AE",
        "Ǽ": "AE",
        "Ǣ": "AE",
        "Ꜵ": "AO",
        "Ꜷ": "AU",
        "Ꜹ": "AV",
        "Ꜻ": "AV",
        "Ꜽ": "AY",
        "Ⓑ": "B",
        "Ｂ": "B",
        "Ḃ": "B",
        "Ḅ": "B",
        "Ḇ": "B",
        "Ƀ": "B",
        "Ƃ": "B",
        "Ɓ": "B",
        "Ⓒ": "C",
        "Ｃ": "C",
        "Ć": "C",
        "Ĉ": "C",
        "Ċ": "C",
        "Č": "C",
        "Ç": "C",
        "Ḉ": "C",
        "Ƈ": "C",
        "Ȼ": "C",
        "Ꜿ": "C",
        "Ⓓ": "D",
        "Ｄ": "D",
        "Ḋ": "D",
        "Ď": "D",
        "Ḍ": "D",
        "Ḑ": "D",
        "Ḓ": "D",
        "Ḏ": "D",
        "Đ": "D",
        "Ƌ": "D",
        "Ɗ": "D",
        "Ɖ": "D",
        "Ꝺ": "D",
        "Ǳ": "DZ",
        "Ǆ": "DZ",
        "ǲ": "Dz",
        "ǅ": "Dz",
        "Ⓔ": "E",
        "Ｅ": "E",
        "È": "E",
        "É": "E",
        "Ê": "E",
        "Ề": "E",
        "Ế": "E",
        "Ễ": "E",
        "Ể": "E",
        "Ẽ": "E",
        "Ē": "E",
        "Ḕ": "E",
        "Ḗ": "E",
        "Ĕ": "E",
        "Ė": "E",
        "Ë": "E",
        "Ẻ": "E",
        "Ě": "E",
        "Ȅ": "E",
        "Ȇ": "E",
        "Ẹ": "E",
        "Ệ": "E",
        "Ȩ": "E",
        "Ḝ": "E",
        "Ę": "E",
        "Ḙ": "E",
        "Ḛ": "E",
        "Ɛ": "E",
        "Ǝ": "E",
        "Ⓕ": "F",
        "Ｆ": "F",
        "Ḟ": "F",
        "Ƒ": "F",
        "Ꝼ": "F",
        "Ⓖ": "G",
        "Ｇ": "G",
        "Ǵ": "G",
        "Ĝ": "G",
        "Ḡ": "G",
        "Ğ": "G",
        "Ġ": "G",
        "Ǧ": "G",
        "Ģ": "G",
        "Ǥ": "G",
        "Ɠ": "G",
        "Ꞡ": "G",
        "Ᵹ": "G",
        "Ꝿ": "G",
        "Ⓗ": "H",
        "Ｈ": "H",
        "Ĥ": "H",
        "Ḣ": "H",
        "Ḧ": "H",
        "Ȟ": "H",
        "Ḥ": "H",
        "Ḩ": "H",
        "Ḫ": "H",
        "Ħ": "H",
        "Ⱨ": "H",
        "Ⱶ": "H",
        "Ɥ": "H",
        "Ⓘ": "I",
        "Ｉ": "I",
        "Ì": "I",
        "Í": "I",
        "Î": "I",
        "Ĩ": "I",
        "Ī": "I",
        "Ĭ": "I",
        "İ": "I",
        "Ï": "I",
        "Ḯ": "I",
        "Ỉ": "I",
        "Ǐ": "I",
        "Ȉ": "I",
        "Ȋ": "I",
        "Ị": "I",
        "Į": "I",
        "Ḭ": "I",
        "Ɨ": "I",
        "Ⓙ": "J",
        "Ｊ": "J",
        "Ĵ": "J",
        "Ɉ": "J",
        "Ⓚ": "K",
        "Ｋ": "K",
        "Ḱ": "K",
        "Ǩ": "K",
        "Ḳ": "K",
        "Ķ": "K",
        "Ḵ": "K",
        "Ƙ": "K",
        "Ⱪ": "K",
        "Ꝁ": "K",
        "Ꝃ": "K",
        "Ꝅ": "K",
        "Ꞣ": "K",
        "Ⓛ": "L",
        "Ｌ": "L",
        "Ŀ": "L",
        "Ĺ": "L",
        "Ľ": "L",
        "Ḷ": "L",
        "Ḹ": "L",
        "Ļ": "L",
        "Ḽ": "L",
        "Ḻ": "L",
        "Ł": "L",
        "Ƚ": "L",
        "Ɫ": "L",
        "Ⱡ": "L",
        "Ꝉ": "L",
        "Ꝇ": "L",
        "Ꞁ": "L",
        "Ǉ": "LJ",
        "ǈ": "Lj",
        "Ⓜ": "M",
        "Ｍ": "M",
        "Ḿ": "M",
        "Ṁ": "M",
        "Ṃ": "M",
        "Ɱ": "M",
        "Ɯ": "M",
        "Ⓝ": "N",
        "Ｎ": "N",
        "Ǹ": "N",
        "Ń": "N",
        "Ñ": "N",
        "Ṅ": "N",
        "Ň": "N",
        "Ṇ": "N",
        "Ņ": "N",
        "Ṋ": "N",
        "Ṉ": "N",
        "Ƞ": "N",
        "Ɲ": "N",
        "Ꞑ": "N",
        "Ꞥ": "N",
        "Ǌ": "NJ",
        "ǋ": "Nj",
        "Ⓞ": "O",
        "Ｏ": "O",
        "Ò": "O",
        "Ó": "O",
        "Ô": "O",
        "Ồ": "O",
        "Ố": "O",
        "Ỗ": "O",
        "Ổ": "O",
        "Õ": "O",
        "Ṍ": "O",
        "Ȭ": "O",
        "Ṏ": "O",
        "Ō": "O",
        "Ṑ": "O",
        "Ṓ": "O",
        "Ŏ": "O",
        "Ȯ": "O",
        "Ȱ": "O",
        "Ö": "O",
        "Ȫ": "O",
        "Ỏ": "O",
        "Ő": "O",
        "Ǒ": "O",
        "Ȍ": "O",
        "Ȏ": "O",
        "Ơ": "O",
        "Ờ": "O",
        "Ớ": "O",
        "Ỡ": "O",
        "Ở": "O",
        "Ợ": "O",
        "Ọ": "O",
        "Ộ": "O",
        "Ǫ": "O",
        "Ǭ": "O",
        "Ø": "O",
        "Ǿ": "O",
        "Ɔ": "O",
        "Ɵ": "O",
        "Ꝋ": "O",
        "Ꝍ": "O",
        "Ƣ": "OI",
        "Ꝏ": "OO",
        "Ȣ": "OU",
        "Ⓟ": "P",
        "Ｐ": "P",
        "Ṕ": "P",
        "Ṗ": "P",
        "Ƥ": "P",
        "Ᵽ": "P",
        "Ꝑ": "P",
        "Ꝓ": "P",
        "Ꝕ": "P",
        "Ⓠ": "Q",
        "Ｑ": "Q",
        "Ꝗ": "Q",
        "Ꝙ": "Q",
        "Ɋ": "Q",
        "Ⓡ": "R",
        "Ｒ": "R",
        "Ŕ": "R",
        "Ṙ": "R",
        "Ř": "R",
        "Ȑ": "R",
        "Ȓ": "R",
        "Ṛ": "R",
        "Ṝ": "R",
        "Ŗ": "R",
        "Ṟ": "R",
        "Ɍ": "R",
        "Ɽ": "R",
        "Ꝛ": "R",
        "Ꞧ": "R",
        "Ꞃ": "R",
        "Ⓢ": "S",
        "Ｓ": "S",
        "ẞ": "S",
        "Ś": "S",
        "Ṥ": "S",
        "Ŝ": "S",
        "Ṡ": "S",
        "Š": "S",
        "Ṧ": "S",
        "Ṣ": "S",
        "Ṩ": "S",
        "Ș": "S",
        "Ş": "S",
        "Ȿ": "S",
        "Ꞩ": "S",
        "Ꞅ": "S",
        "Ⓣ": "T",
        "Ｔ": "T",
        "Ṫ": "T",
        "Ť": "T",
        "Ṭ": "T",
        "Ț": "T",
        "Ţ": "T",
        "Ṱ": "T",
        "Ṯ": "T",
        "Ŧ": "T",
        "Ƭ": "T",
        "Ʈ": "T",
        "Ⱦ": "T",
        "Ꞇ": "T",
        "Ꜩ": "TZ",
        "Ⓤ": "U",
        "Ｕ": "U",
        "Ù": "U",
        "Ú": "U",
        "Û": "U",
        "Ũ": "U",
        "Ṹ": "U",
        "Ū": "U",
        "Ṻ": "U",
        "Ŭ": "U",
        "Ü": "U",
        "Ǜ": "U",
        "Ǘ": "U",
        "Ǖ": "U",
        "Ǚ": "U",
        "Ủ": "U",
        "Ů": "U",
        "Ű": "U",
        "Ǔ": "U",
        "Ȕ": "U",
        "Ȗ": "U",
        "Ư": "U",
        "Ừ": "U",
        "Ứ": "U",
        "Ữ": "U",
        "Ử": "U",
        "Ự": "U",
        "Ụ": "U",
        "Ṳ": "U",
        "Ų": "U",
        "Ṷ": "U",
        "Ṵ": "U",
        "Ʉ": "U",
        "Ⓥ": "V",
        "Ｖ": "V",
        "Ṽ": "V",
        "Ṿ": "V",
        "Ʋ": "V",
        "Ꝟ": "V",
        "Ʌ": "V",
        "Ꝡ": "VY",
        "Ⓦ": "W",
        "Ｗ": "W",
        "Ẁ": "W",
        "Ẃ": "W",
        "Ŵ": "W",
        "Ẇ": "W",
        "Ẅ": "W",
        "Ẉ": "W",
        "Ⱳ": "W",
        "Ⓧ": "X",
        "Ｘ": "X",
        "Ẋ": "X",
        "Ẍ": "X",
        "Ⓨ": "Y",
        "Ｙ": "Y",
        "Ỳ": "Y",
        "Ý": "Y",
        "Ŷ": "Y",
        "Ỹ": "Y",
        "Ȳ": "Y",
        "Ẏ": "Y",
        "Ÿ": "Y",
        "Ỷ": "Y",
        "Ỵ": "Y",
        "Ƴ": "Y",
        "Ɏ": "Y",
        "Ỿ": "Y",
        "Ⓩ": "Z",
        "Ｚ": "Z",
        "Ź": "Z",
        "Ẑ": "Z",
        "Ż": "Z",
        "Ž": "Z",
        "Ẓ": "Z",
        "Ẕ": "Z",
        "Ƶ": "Z",
        "Ȥ": "Z",
        "Ɀ": "Z",
        "Ⱬ": "Z",
        "Ꝣ": "Z",
        "ⓐ": "a",
        "ａ": "a",
        "ẚ": "a",
        "à": "a",
        "á": "a",
        "â": "a",
        "ầ": "a",
        "ấ": "a",
        "ẫ": "a",
        "ẩ": "a",
        "ã": "a",
        "ā": "a",
        "ă": "a",
        "ằ": "a",
        "ắ": "a",
        "ẵ": "a",
        "ẳ": "a",
        "ȧ": "a",
        "ǡ": "a",
        "ä": "a",
        "ǟ": "a",
        "ả": "a",
        "å": "a",
        "ǻ": "a",
        "ǎ": "a",
        "ȁ": "a",
        "ȃ": "a",
        "ạ": "a",
        "ậ": "a",
        "ặ": "a",
        "ḁ": "a",
        "ą": "a",
        "ⱥ": "a",
        "ɐ": "a",
        "ꜳ": "aa",
        "æ": "ae",
        "ǽ": "ae",
        "ǣ": "ae",
        "ꜵ": "ao",
        "ꜷ": "au",
        "ꜹ": "av",
        "ꜻ": "av",
        "ꜽ": "ay",
        "ⓑ": "b",
        "ｂ": "b",
        "ḃ": "b",
        "ḅ": "b",
        "ḇ": "b",
        "ƀ": "b",
        "ƃ": "b",
        "ɓ": "b",
        "ⓒ": "c",
        "ｃ": "c",
        "ć": "c",
        "ĉ": "c",
        "ċ": "c",
        "č": "c",
        "ç": "c",
        "ḉ": "c",
        "ƈ": "c",
        "ȼ": "c",
        "ꜿ": "c",
        "ↄ": "c",
        "ⓓ": "d",
        "ｄ": "d",
        "ḋ": "d",
        "ď": "d",
        "ḍ": "d",
        "ḑ": "d",
        "ḓ": "d",
        "ḏ": "d",
        "đ": "d",
        "ƌ": "d",
        "ɖ": "d",
        "ɗ": "d",
        "ꝺ": "d",
        "ǳ": "dz",
        "ǆ": "dz",
        "ⓔ": "e",
        "ｅ": "e",
        "è": "e",
        "é": "e",
        "ê": "e",
        "ề": "e",
        "ế": "e",
        "ễ": "e",
        "ể": "e",
        "ẽ": "e",
        "ē": "e",
        "ḕ": "e",
        "ḗ": "e",
        "ĕ": "e",
        "ė": "e",
        "ë": "e",
        "ẻ": "e",
        "ě": "e",
        "ȅ": "e",
        "ȇ": "e",
        "ẹ": "e",
        "ệ": "e",
        "ȩ": "e",
        "ḝ": "e",
        "ę": "e",
        "ḙ": "e",
        "ḛ": "e",
        "ɇ": "e",
        "ɛ": "e",
        "ǝ": "e",
        "ⓕ": "f",
        "ｆ": "f",
        "ḟ": "f",
        "ƒ": "f",
        "ꝼ": "f",
        "ⓖ": "g",
        "ｇ": "g",
        "ǵ": "g",
        "ĝ": "g",
        "ḡ": "g",
        "ğ": "g",
        "ġ": "g",
        "ǧ": "g",
        "ģ": "g",
        "ǥ": "g",
        "ɠ": "g",
        "ꞡ": "g",
        "ᵹ": "g",
        "ꝿ": "g",
        "ⓗ": "h",
        "ｈ": "h",
        "ĥ": "h",
        "ḣ": "h",
        "ḧ": "h",
        "ȟ": "h",
        "ḥ": "h",
        "ḩ": "h",
        "ḫ": "h",
        "ẖ": "h",
        "ħ": "h",
        "ⱨ": "h",
        "ⱶ": "h",
        "ɥ": "h",
        "ƕ": "hv",
        "ⓘ": "i",
        "ｉ": "i",
        "ì": "i",
        "í": "i",
        "î": "i",
        "ĩ": "i",
        "ī": "i",
        "ĭ": "i",
        "ï": "i",
        "ḯ": "i",
        "ỉ": "i",
        "ǐ": "i",
        "ȉ": "i",
        "ȋ": "i",
        "ị": "i",
        "į": "i",
        "ḭ": "i",
        "ɨ": "i",
        "ı": "i",
        "ⓙ": "j",
        "ｊ": "j",
        "ĵ": "j",
        "ǰ": "j",
        "ɉ": "j",
        "ⓚ": "k",
        "ｋ": "k",
        "ḱ": "k",
        "ǩ": "k",
        "ḳ": "k",
        "ķ": "k",
        "ḵ": "k",
        "ƙ": "k",
        "ⱪ": "k",
        "ꝁ": "k",
        "ꝃ": "k",
        "ꝅ": "k",
        "ꞣ": "k",
        "ⓛ": "l",
        "ｌ": "l",
        "ŀ": "l",
        "ĺ": "l",
        "ľ": "l",
        "ḷ": "l",
        "ḹ": "l",
        "ļ": "l",
        "ḽ": "l",
        "ḻ": "l",
        "ſ": "l",
        "ł": "l",
        "ƚ": "l",
        "ɫ": "l",
        "ⱡ": "l",
        "ꝉ": "l",
        "ꞁ": "l",
        "ꝇ": "l",
        "ǉ": "lj",
        "ⓜ": "m",
        "ｍ": "m",
        "ḿ": "m",
        "ṁ": "m",
        "ṃ": "m",
        "ɱ": "m",
        "ɯ": "m",
        "ⓝ": "n",
        "ｎ": "n",
        "ǹ": "n",
        "ń": "n",
        "ñ": "n",
        "ṅ": "n",
        "ň": "n",
        "ṇ": "n",
        "ņ": "n",
        "ṋ": "n",
        "ṉ": "n",
        "ƞ": "n",
        "ɲ": "n",
        "ŉ": "n",
        "ꞑ": "n",
        "ꞥ": "n",
        "ǌ": "nj",
        "ⓞ": "o",
        "ｏ": "o",
        "ò": "o",
        "ó": "o",
        "ô": "o",
        "ồ": "o",
        "ố": "o",
        "ỗ": "o",
        "ổ": "o",
        "õ": "o",
        "ṍ": "o",
        "ȭ": "o",
        "ṏ": "o",
        "ō": "o",
        "ṑ": "o",
        "ṓ": "o",
        "ŏ": "o",
        "ȯ": "o",
        "ȱ": "o",
        "ö": "o",
        "ȫ": "o",
        "ỏ": "o",
        "ő": "o",
        "ǒ": "o",
        "ȍ": "o",
        "ȏ": "o",
        "ơ": "o",
        "ờ": "o",
        "ớ": "o",
        "ỡ": "o",
        "ở": "o",
        "ợ": "o",
        "ọ": "o",
        "ộ": "o",
        "ǫ": "o",
        "ǭ": "o",
        "ø": "o",
        "ǿ": "o",
        "ɔ": "o",
        "ꝋ": "o",
        "ꝍ": "o",
        "ɵ": "o",
        "ƣ": "oi",
        "ȣ": "ou",
        "ꝏ": "oo",
        "ⓟ": "p",
        "ｐ": "p",
        "ṕ": "p",
        "ṗ": "p",
        "ƥ": "p",
        "ᵽ": "p",
        "ꝑ": "p",
        "ꝓ": "p",
        "ꝕ": "p",
        "ⓠ": "q",
        "ｑ": "q",
        "ɋ": "q",
        "ꝗ": "q",
        "ꝙ": "q",
        "ⓡ": "r",
        "ｒ": "r",
        "ŕ": "r",
        "ṙ": "r",
        "ř": "r",
        "ȑ": "r",
        "ȓ": "r",
        "ṛ": "r",
        "ṝ": "r",
        "ŗ": "r",
        "ṟ": "r",
        "ɍ": "r",
        "ɽ": "r",
        "ꝛ": "r",
        "ꞧ": "r",
        "ꞃ": "r",
        "ⓢ": "s",
        "ｓ": "s",
        "ß": "s",
        "ś": "s",
        "ṥ": "s",
        "ŝ": "s",
        "ṡ": "s",
        "š": "s",
        "ṧ": "s",
        "ṣ": "s",
        "ṩ": "s",
        "ș": "s",
        "ş": "s",
        "ȿ": "s",
        "ꞩ": "s",
        "ꞅ": "s",
        "ẛ": "s",
        "ⓣ": "t",
        "ｔ": "t",
        "ṫ": "t",
        "ẗ": "t",
        "ť": "t",
        "ṭ": "t",
        "ț": "t",
        "ţ": "t",
        "ṱ": "t",
        "ṯ": "t",
        "ŧ": "t",
        "ƭ": "t",
        "ʈ": "t",
        "ⱦ": "t",
        "ꞇ": "t",
        "ꜩ": "tz",
        "ⓤ": "u",
        "ｕ": "u",
        "ù": "u",
        "ú": "u",
        "û": "u",
        "ũ": "u",
        "ṹ": "u",
        "ū": "u",
        "ṻ": "u",
        "ŭ": "u",
        "ü": "u",
        "ǜ": "u",
        "ǘ": "u",
        "ǖ": "u",
        "ǚ": "u",
        "ủ": "u",
        "ů": "u",
        "ű": "u",
        "ǔ": "u",
        "ȕ": "u",
        "ȗ": "u",
        "ư": "u",
        "ừ": "u",
        "ứ": "u",
        "ữ": "u",
        "ử": "u",
        "ự": "u",
        "ụ": "u",
        "ṳ": "u",
        "ų": "u",
        "ṷ": "u",
        "ṵ": "u",
        "ʉ": "u",
        "ⓥ": "v",
        "ｖ": "v",
        "ṽ": "v",
        "ṿ": "v",
        "ʋ": "v",
        "ꝟ": "v",
        "ʌ": "v",
        "ꝡ": "vy",
        "ⓦ": "w",
        "ｗ": "w",
        "ẁ": "w",
        "ẃ": "w",
        "ŵ": "w",
        "ẇ": "w",
        "ẅ": "w",
        "ẘ": "w",
        "ẉ": "w",
        "ⱳ": "w",
        "ⓧ": "x",
        "ｘ": "x",
        "ẋ": "x",
        "ẍ": "x",
        "ⓨ": "y",
        "ｙ": "y",
        "ỳ": "y",
        "ý": "y",
        "ŷ": "y",
        "ỹ": "y",
        "ȳ": "y",
        "ẏ": "y",
        "ÿ": "y",
        "ỷ": "y",
        "ẙ": "y",
        "ỵ": "y",
        "ƴ": "y",
        "ɏ": "y",
        "ỿ": "y",
        "ⓩ": "z",
        "ｚ": "z",
        "ź": "z",
        "ẑ": "z",
        "ż": "z",
        "ž": "z",
        "ẓ": "z",
        "ẕ": "z",
        "ƶ": "z",
        "ȥ": "z",
        "ɀ": "z",
        "ⱬ": "z",
        "ꝣ": "z",
        "Ά": "Α",
        "Έ": "Ε",
        "Ή": "Η",
        "Ί": "Ι",
        "Ϊ": "Ι",
        "Ό": "Ο",
        "Ύ": "Υ",
        "Ϋ": "Υ",
        "Ώ": "Ω",
        "ά": "α",
        "έ": "ε",
        "ή": "η",
        "ί": "ι",
        "ϊ": "ι",
        "ΐ": "ι",
        "ό": "ο",
        "ύ": "υ",
        "ϋ": "υ",
        "ΰ": "υ",
        "ω": "ω",
        "ς": "σ"
      };
    }), b.define("select2/data/base", ["../utils"], function (a) {
      function b(a, c) {
        b.__super__.constructor.call(this);
      }

      return a.Extend(b, a.Observable), b.prototype.current = function (a) {
        throw new Error("The `current` method must be defined in child classes.");
      }, b.prototype.query = function (a, b) {
        throw new Error("The `query` method must be defined in child classes.");
      }, b.prototype.bind = function (a, b) {}, b.prototype.destroy = function () {}, b.prototype.generateResultId = function (b, c) {
        var d = b.id + "-result-";
        return d += a.generateChars(4), null != c.id ? d += "-" + c.id.toString() : d += "-" + a.generateChars(4), d;
      }, b;
    }), b.define("select2/data/select", ["./base", "../utils", "jquery"], function (a, b, c) {
      function d(a, b) {
        this.$element = a, this.options = b, d.__super__.constructor.call(this);
      }

      return b.Extend(d, a), d.prototype.current = function (a) {
        var b = [],
            d = this;
        this.$element.find(":selected").each(function () {
          var a = c(this),
              e = d.item(a);
          b.push(e);
        }), a(b);
      }, d.prototype.select = function (a) {
        var b = this;
        if (a.selected = !0, c(a.element).is("option")) return a.element.selected = !0, void this.$element.trigger("change");
        if (this.$element.prop("multiple")) this.current(function (d) {
          var e = [];
          a = [a], a.push.apply(a, d);

          for (var f = 0; f < a.length; f++) {
            var g = a[f].id;
            -1 === c.inArray(g, e) && e.push(g);
          }

          b.$element.val(e), b.$element.trigger("change");
        });else {
          var d = a.id;
          this.$element.val(d), this.$element.trigger("change");
        }
      }, d.prototype.unselect = function (a) {
        var b = this;

        if (this.$element.prop("multiple")) {
          if (a.selected = !1, c(a.element).is("option")) return a.element.selected = !1, void this.$element.trigger("change");
          this.current(function (d) {
            for (var e = [], f = 0; f < d.length; f++) {
              var g = d[f].id;
              g !== a.id && -1 === c.inArray(g, e) && e.push(g);
            }

            b.$element.val(e), b.$element.trigger("change");
          });
        }
      }, d.prototype.bind = function (a, b) {
        var c = this;
        this.container = a, a.on("select", function (a) {
          c.select(a.data);
        }), a.on("unselect", function (a) {
          c.unselect(a.data);
        });
      }, d.prototype.destroy = function () {
        this.$element.find("*").each(function () {
          b.RemoveData(this);
        });
      }, d.prototype.query = function (a, b) {
        var d = [],
            e = this;
        this.$element.children().each(function () {
          var b = c(this);

          if (b.is("option") || b.is("optgroup")) {
            var f = e.item(b),
                g = e.matches(a, f);
            null !== g && d.push(g);
          }
        }), b({
          results: d
        });
      }, d.prototype.addOptions = function (a) {
        b.appendMany(this.$element, a);
      }, d.prototype.option = function (a) {
        var d;
        a.children ? (d = document.createElement("optgroup"), d.label = a.text) : (d = document.createElement("option"), void 0 !== d.textContent ? d.textContent = a.text : d.innerText = a.text), void 0 !== a.id && (d.value = a.id), a.disabled && (d.disabled = !0), a.selected && (d.selected = !0), a.title && (d.title = a.title);

        var e = c(d),
            f = this._normalizeItem(a);

        return f.element = d, b.StoreData(d, "data", f), e;
      }, d.prototype.item = function (a) {
        var d = {};
        if (null != (d = b.GetData(a[0], "data"))) return d;
        if (a.is("option")) d = {
          id: a.val(),
          text: a.text(),
          disabled: a.prop("disabled"),
          selected: a.prop("selected"),
          title: a.prop("title")
        };else if (a.is("optgroup")) {
          d = {
            text: a.prop("label"),
            children: [],
            title: a.prop("title")
          };

          for (var e = a.children("option"), f = [], g = 0; g < e.length; g++) {
            var h = c(e[g]),
                i = this.item(h);
            f.push(i);
          }

          d.children = f;
        }
        return d = this._normalizeItem(d), d.element = a[0], b.StoreData(a[0], "data", d), d;
      }, d.prototype._normalizeItem = function (a) {
        a !== Object(a) && (a = {
          id: a,
          text: a
        }), a = c.extend({}, {
          text: ""
        }, a);
        var b = {
          selected: !1,
          disabled: !1
        };
        return null != a.id && (a.id = a.id.toString()), null != a.text && (a.text = a.text.toString()), null == a._resultId && a.id && null != this.container && (a._resultId = this.generateResultId(this.container, a)), c.extend({}, b, a);
      }, d.prototype.matches = function (a, b) {
        return this.options.get("matcher")(a, b);
      }, d;
    }), b.define("select2/data/array", ["./select", "../utils", "jquery"], function (a, b, c) {
      function d(a, b) {
        var c = b.get("data") || [];
        d.__super__.constructor.call(this, a, b), this.addOptions(this.convertToOptions(c));
      }

      return b.Extend(d, a), d.prototype.select = function (a) {
        var b = this.$element.find("option").filter(function (b, c) {
          return c.value == a.id.toString();
        });
        0 === b.length && (b = this.option(a), this.addOptions(b)), d.__super__.select.call(this, a);
      }, d.prototype.convertToOptions = function (a) {
        function d(a) {
          return function () {
            return c(this).val() == a.id;
          };
        }

        for (var e = this, f = this.$element.find("option"), g = f.map(function () {
          return e.item(c(this)).id;
        }).get(), h = [], i = 0; i < a.length; i++) {
          var j = this._normalizeItem(a[i]);

          if (c.inArray(j.id, g) >= 0) {
            var k = f.filter(d(j)),
                l = this.item(k),
                m = c.extend(!0, {}, j, l),
                n = this.option(m);
            k.replaceWith(n);
          } else {
            var o = this.option(j);

            if (j.children) {
              var p = this.convertToOptions(j.children);
              b.appendMany(o, p);
            }

            h.push(o);
          }
        }

        return h;
      }, d;
    }), b.define("select2/data/ajax", ["./array", "../utils", "jquery"], function (a, b, c) {
      function d(a, b) {
        this.ajaxOptions = this._applyDefaults(b.get("ajax")), null != this.ajaxOptions.processResults && (this.processResults = this.ajaxOptions.processResults), d.__super__.constructor.call(this, a, b);
      }

      return b.Extend(d, a), d.prototype._applyDefaults = function (a) {
        var b = {
          data: function data(a) {
            return c.extend({}, a, {
              q: a.term
            });
          },
          transport: function transport(a, b, d) {
            var e = c.ajax(a);
            return e.then(b), e.fail(d), e;
          }
        };
        return c.extend({}, b, a, !0);
      }, d.prototype.processResults = function (a) {
        return a;
      }, d.prototype.query = function (a, b) {
        function d() {
          var d = f.transport(f, function (d) {
            var f = e.processResults(d, a);
            e.options.get("debug") && window.console && console.error && (f && f.results && c.isArray(f.results) || console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")), b(f);
          }, function () {
            "status" in d && (0 === d.status || "0" === d.status) || e.trigger("results:message", {
              message: "errorLoading"
            });
          });
          e._request = d;
        }

        var e = this;
        null != this._request && (c.isFunction(this._request.abort) && this._request.abort(), this._request = null);
        var f = c.extend({
          type: "GET"
        }, this.ajaxOptions);
        "function" == typeof f.url && (f.url = f.url.call(this.$element, a)), "function" == typeof f.data && (f.data = f.data.call(this.$element, a)), this.ajaxOptions.delay && null != a.term ? (this._queryTimeout && window.clearTimeout(this._queryTimeout), this._queryTimeout = window.setTimeout(d, this.ajaxOptions.delay)) : d();
      }, d;
    }), b.define("select2/data/tags", ["jquery"], function (a) {
      function b(b, c, d) {
        var e = d.get("tags"),
            f = d.get("createTag");
        void 0 !== f && (this.createTag = f);
        var g = d.get("insertTag");
        if (void 0 !== g && (this.insertTag = g), b.call(this, c, d), a.isArray(e)) for (var h = 0; h < e.length; h++) {
          var i = e[h],
              j = this._normalizeItem(i),
              k = this.option(j);

          this.$element.append(k);
        }
      }

      return b.prototype.query = function (a, b, c) {
        function d(a, f) {
          for (var g = a.results, h = 0; h < g.length; h++) {
            var i = g[h],
                j = null != i.children && !d({
              results: i.children
            }, !0);
            if ((i.text || "").toUpperCase() === (b.term || "").toUpperCase() || j) return !f && (a.data = g, void c(a));
          }

          if (f) return !0;
          var k = e.createTag(b);

          if (null != k) {
            var l = e.option(k);
            l.attr("data-select2-tag", !0), e.addOptions([l]), e.insertTag(g, k);
          }

          a.results = g, c(a);
        }

        var e = this;
        if (this._removeOldTags(), null == b.term || null != b.page) return void a.call(this, b, c);
        a.call(this, b, d);
      }, b.prototype.createTag = function (b, c) {
        var d = a.trim(c.term);
        return "" === d ? null : {
          id: d,
          text: d
        };
      }, b.prototype.insertTag = function (a, b, c) {
        b.unshift(c);
      }, b.prototype._removeOldTags = function (b) {
        this._lastTag;
        this.$element.find("option[data-select2-tag]").each(function () {
          this.selected || a(this).remove();
        });
      }, b;
    }), b.define("select2/data/tokenizer", ["jquery"], function (a) {
      function b(a, b, c) {
        var d = c.get("tokenizer");
        void 0 !== d && (this.tokenizer = d), a.call(this, b, c);
      }

      return b.prototype.bind = function (a, b, c) {
        a.call(this, b, c), this.$search = b.dropdown.$search || b.selection.$search || c.find(".select2-search__field");
      }, b.prototype.query = function (b, c, d) {
        function e(b) {
          var c = g._normalizeItem(b);

          if (!g.$element.find("option").filter(function () {
            return a(this).val() === c.id;
          }).length) {
            var d = g.option(c);
            d.attr("data-select2-tag", !0), g._removeOldTags(), g.addOptions([d]);
          }

          f(c);
        }

        function f(a) {
          g.trigger("select", {
            data: a
          });
        }

        var g = this;
        c.term = c.term || "";
        var h = this.tokenizer(c, this.options, e);
        h.term !== c.term && (this.$search.length && (this.$search.val(h.term), this.$search.focus()), c.term = h.term), b.call(this, c, d);
      }, b.prototype.tokenizer = function (b, c, d, e) {
        for (var f = d.get("tokenSeparators") || [], g = c.term, h = 0, i = this.createTag || function (a) {
          return {
            id: a.term,
            text: a.term
          };
        }; h < g.length;) {
          var j = g[h];

          if (-1 !== a.inArray(j, f)) {
            var k = g.substr(0, h),
                l = a.extend({}, c, {
              term: k
            }),
                m = i(l);
            null != m ? (e(m), g = g.substr(h + 1) || "", h = 0) : h++;
          } else h++;
        }

        return {
          term: g
        };
      }, b;
    }), b.define("select2/data/minimumInputLength", [], function () {
      function a(a, b, c) {
        this.minimumInputLength = c.get("minimumInputLength"), a.call(this, b, c);
      }

      return a.prototype.query = function (a, b, c) {
        if (b.term = b.term || "", b.term.length < this.minimumInputLength) return void this.trigger("results:message", {
          message: "inputTooShort",
          args: {
            minimum: this.minimumInputLength,
            input: b.term,
            params: b
          }
        });
        a.call(this, b, c);
      }, a;
    }), b.define("select2/data/maximumInputLength", [], function () {
      function a(a, b, c) {
        this.maximumInputLength = c.get("maximumInputLength"), a.call(this, b, c);
      }

      return a.prototype.query = function (a, b, c) {
        if (b.term = b.term || "", this.maximumInputLength > 0 && b.term.length > this.maximumInputLength) return void this.trigger("results:message", {
          message: "inputTooLong",
          args: {
            maximum: this.maximumInputLength,
            input: b.term,
            params: b
          }
        });
        a.call(this, b, c);
      }, a;
    }), b.define("select2/data/maximumSelectionLength", [], function () {
      function a(a, b, c) {
        this.maximumSelectionLength = c.get("maximumSelectionLength"), a.call(this, b, c);
      }

      return a.prototype.query = function (a, b, c) {
        var d = this;
        this.current(function (e) {
          var f = null != e ? e.length : 0;
          if (d.maximumSelectionLength > 0 && f >= d.maximumSelectionLength) return void d.trigger("results:message", {
            message: "maximumSelected",
            args: {
              maximum: d.maximumSelectionLength
            }
          });
          a.call(d, b, c);
        });
      }, a;
    }), b.define("select2/dropdown", ["jquery", "./utils"], function (a, b) {
      function c(a, b) {
        this.$element = a, this.options = b, c.__super__.constructor.call(this);
      }

      return b.Extend(c, b.Observable), c.prototype.render = function () {
        var b = a('<span class="select2-dropdown"><span class="select2-results"></span></span>');
        return b.attr("dir", this.options.get("dir")), this.$dropdown = b, b;
      }, c.prototype.bind = function () {}, c.prototype.position = function (a, b) {}, c.prototype.destroy = function () {
        this.$dropdown.remove();
      }, c;
    }), b.define("select2/dropdown/search", ["jquery", "../utils"], function (a, b) {
      function c() {}

      return c.prototype.render = function (b) {
        var c = b.call(this),
            d = a('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="textbox" /></span>');
        return this.$searchContainer = d, this.$search = d.find("input"), c.prepend(d), c;
      }, c.prototype.bind = function (b, c, d) {
        var e = this;
        b.call(this, c, d), this.$search.on("keydown", function (a) {
          e.trigger("keypress", a), e._keyUpPrevented = a.isDefaultPrevented();
        }), this.$search.on("input", function (b) {
          a(this).off("keyup");
        }), this.$search.on("keyup input", function (a) {
          e.handleSearch(a);
        }), c.on("open", function () {
          e.$search.attr("tabindex", 0), e.$search.focus(), window.setTimeout(function () {
            e.$search.focus();
          }, 0);
        }), c.on("close", function () {
          e.$search.attr("tabindex", -1), e.$search.val(""), e.$search.blur();
        }), c.on("focus", function () {
          c.isOpen() || e.$search.focus();
        }), c.on("results:all", function (a) {
          if (null == a.query.term || "" === a.query.term) {
            e.showSearch(a) ? e.$searchContainer.removeClass("select2-search--hide") : e.$searchContainer.addClass("select2-search--hide");
          }
        });
      }, c.prototype.handleSearch = function (a) {
        if (!this._keyUpPrevented) {
          var b = this.$search.val();
          this.trigger("query", {
            term: b
          });
        }

        this._keyUpPrevented = !1;
      }, c.prototype.showSearch = function (a, b) {
        return !0;
      }, c;
    }), b.define("select2/dropdown/hidePlaceholder", [], function () {
      function a(a, b, c, d) {
        this.placeholder = this.normalizePlaceholder(c.get("placeholder")), a.call(this, b, c, d);
      }

      return a.prototype.append = function (a, b) {
        b.results = this.removePlaceholder(b.results), a.call(this, b);
      }, a.prototype.normalizePlaceholder = function (a, b) {
        return "string" == typeof b && (b = {
          id: "",
          text: b
        }), b;
      }, a.prototype.removePlaceholder = function (a, b) {
        for (var c = b.slice(0), d = b.length - 1; d >= 0; d--) {
          var e = b[d];
          this.placeholder.id === e.id && c.splice(d, 1);
        }

        return c;
      }, a;
    }), b.define("select2/dropdown/infiniteScroll", ["jquery"], function (a) {
      function b(a, b, c, d) {
        this.lastParams = {}, a.call(this, b, c, d), this.$loadingMore = this.createLoadingMore(), this.loading = !1;
      }

      return b.prototype.append = function (a, b) {
        this.$loadingMore.remove(), this.loading = !1, a.call(this, b), this.showLoadingMore(b) && this.$results.append(this.$loadingMore);
      }, b.prototype.bind = function (b, c, d) {
        var e = this;
        b.call(this, c, d), c.on("query", function (a) {
          e.lastParams = a, e.loading = !0;
        }), c.on("query:append", function (a) {
          e.lastParams = a, e.loading = !0;
        }), this.$results.on("scroll", function () {
          var b = a.contains(document.documentElement, e.$loadingMore[0]);

          if (!e.loading && b) {
            e.$results.offset().top + e.$results.outerHeight(!1) + 50 >= e.$loadingMore.offset().top + e.$loadingMore.outerHeight(!1) && e.loadMore();
          }
        });
      }, b.prototype.loadMore = function () {
        this.loading = !0;
        var b = a.extend({}, {
          page: 1
        }, this.lastParams);
        b.page++, this.trigger("query:append", b);
      }, b.prototype.showLoadingMore = function (a, b) {
        return b.pagination && b.pagination.more;
      }, b.prototype.createLoadingMore = function () {
        var b = a('<li class="select2-results__option select2-results__option--load-more"role="treeitem" aria-disabled="true"></li>'),
            c = this.options.get("translations").get("loadingMore");
        return b.html(c(this.lastParams)), b;
      }, b;
    }), b.define("select2/dropdown/attachBody", ["jquery", "../utils"], function (a, b) {
      function c(b, c, d) {
        this.$dropdownParent = d.get("dropdownParent") || a(document.body), b.call(this, c, d);
      }

      return c.prototype.bind = function (a, b, c) {
        var d = this,
            e = !1;
        a.call(this, b, c), b.on("open", function () {
          d._showDropdown(), d._attachPositioningHandler(b), e || (e = !0, b.on("results:all", function () {
            d._positionDropdown(), d._resizeDropdown();
          }), b.on("results:append", function () {
            d._positionDropdown(), d._resizeDropdown();
          }));
        }), b.on("close", function () {
          d._hideDropdown(), d._detachPositioningHandler(b);
        }), this.$dropdownContainer.on("mousedown", function (a) {
          a.stopPropagation();
        });
      }, c.prototype.destroy = function (a) {
        a.call(this), this.$dropdownContainer.remove();
      }, c.prototype.position = function (a, b, c) {
        b.attr("class", c.attr("class")), b.removeClass("select2"), b.addClass("select2-container--open"), b.css({
          position: "absolute",
          top: -999999
        }), this.$container = c;
      }, c.prototype.render = function (b) {
        var c = a("<span></span>"),
            d = b.call(this);
        return c.append(d), this.$dropdownContainer = c, c;
      }, c.prototype._hideDropdown = function (a) {
        this.$dropdownContainer.detach();
      }, c.prototype._attachPositioningHandler = function (c, d) {
        var e = this,
            f = "scroll.select2." + d.id,
            g = "resize.select2." + d.id,
            h = "orientationchange.select2." + d.id,
            i = this.$container.parents().filter(b.hasScroll);
        i.each(function () {
          b.StoreData(this, "select2-scroll-position", {
            x: a(this).scrollLeft(),
            y: a(this).scrollTop()
          });
        }), i.on(f, function (c) {
          var d = b.GetData(this, "select2-scroll-position");
          a(this).scrollTop(d.y);
        }), a(window).on(f + " " + g + " " + h, function (a) {
          e._positionDropdown(), e._resizeDropdown();
        });
      }, c.prototype._detachPositioningHandler = function (c, d) {
        var e = "scroll.select2." + d.id,
            f = "resize.select2." + d.id,
            g = "orientationchange.select2." + d.id;
        this.$container.parents().filter(b.hasScroll).off(e), a(window).off(e + " " + f + " " + g);
      }, c.prototype._positionDropdown = function () {
        var b = a(window),
            c = this.$dropdown.hasClass("select2-dropdown--above"),
            d = this.$dropdown.hasClass("select2-dropdown--below"),
            e = null,
            f = this.$container.offset();
        f.bottom = f.top + this.$container.outerHeight(!1);
        var g = {
          height: this.$container.outerHeight(!1)
        };
        g.top = f.top, g.bottom = f.top + g.height;
        var h = {
          height: this.$dropdown.outerHeight(!1)
        },
            i = {
          top: b.scrollTop(),
          bottom: b.scrollTop() + b.height()
        },
            j = i.top < f.top - h.height,
            k = i.bottom > f.bottom + h.height,
            l = {
          left: f.left,
          top: g.bottom
        },
            m = this.$dropdownParent;
        "static" === m.css("position") && (m = m.offsetParent());
        var n = m.offset();
        l.top -= n.top, l.left -= n.left, c || d || (e = "below"), k || !j || c ? !j && k && c && (e = "below") : e = "above", ("above" == e || c && "below" !== e) && (l.top = g.top - n.top - h.height), null != e && (this.$dropdown.removeClass("select2-dropdown--below select2-dropdown--above").addClass("select2-dropdown--" + e), this.$container.removeClass("select2-container--below select2-container--above").addClass("select2-container--" + e)), this.$dropdownContainer.css(l);
      }, c.prototype._resizeDropdown = function () {
        var a = {
          width: this.$container.outerWidth(!1) + "px"
        };
        this.options.get("dropdownAutoWidth") && (a.minWidth = a.width, a.position = "relative", a.width = "auto"), this.$dropdown.css(a);
      }, c.prototype._showDropdown = function (a) {
        this.$dropdownContainer.appendTo(this.$dropdownParent), this._positionDropdown(), this._resizeDropdown();
      }, c;
    }), b.define("select2/dropdown/minimumResultsForSearch", [], function () {
      function a(b) {
        for (var c = 0, d = 0; d < b.length; d++) {
          var e = b[d];
          e.children ? c += a(e.children) : c++;
        }

        return c;
      }

      function b(a, b, c, d) {
        this.minimumResultsForSearch = c.get("minimumResultsForSearch"), this.minimumResultsForSearch < 0 && (this.minimumResultsForSearch = 1 / 0), a.call(this, b, c, d);
      }

      return b.prototype.showSearch = function (b, c) {
        return !(a(c.data.results) < this.minimumResultsForSearch) && b.call(this, c);
      }, b;
    }), b.define("select2/dropdown/selectOnClose", ["../utils"], function (a) {
      function b() {}

      return b.prototype.bind = function (a, b, c) {
        var d = this;
        a.call(this, b, c), b.on("close", function (a) {
          d._handleSelectOnClose(a);
        });
      }, b.prototype._handleSelectOnClose = function (b, c) {
        if (c && null != c.originalSelect2Event) {
          var d = c.originalSelect2Event;
          if ("select" === d._type || "unselect" === d._type) return;
        }

        var e = this.getHighlightedResults();

        if (!(e.length < 1)) {
          var f = a.GetData(e[0], "data");
          null != f.element && f.element.selected || null == f.element && f.selected || this.trigger("select", {
            data: f
          });
        }
      }, b;
    }), b.define("select2/dropdown/closeOnSelect", [], function () {
      function a() {}

      return a.prototype.bind = function (a, b, c) {
        var d = this;
        a.call(this, b, c), b.on("select", function (a) {
          d._selectTriggered(a);
        }), b.on("unselect", function (a) {
          d._selectTriggered(a);
        });
      }, a.prototype._selectTriggered = function (a, b) {
        var c = b.originalEvent;
        c && c.ctrlKey || this.trigger("close", {
          originalEvent: c,
          originalSelect2Event: b
        });
      }, a;
    }), b.define("select2/i18n/en", [], function () {
      return {
        errorLoading: function errorLoading() {
          return "The results could not be loaded.";
        },
        inputTooLong: function inputTooLong(a) {
          var b = a.input.length - a.maximum,
              c = "Please delete " + b + " character";
          return 1 != b && (c += "s"), c;
        },
        inputTooShort: function inputTooShort(a) {
          return "Please enter " + (a.minimum - a.input.length) + " or more characters";
        },
        loadingMore: function loadingMore() {
          return "Loading more results…";
        },
        maximumSelected: function maximumSelected(a) {
          var b = "You can only select " + a.maximum + " item";
          return 1 != a.maximum && (b += "s"), b;
        },
        noResults: function noResults() {
          return "No results found";
        },
        searching: function searching() {
          return "Searching…";
        }
      };
    }), b.define("select2/defaults", ["jquery", "require", "./results", "./selection/single", "./selection/multiple", "./selection/placeholder", "./selection/allowClear", "./selection/search", "./selection/eventRelay", "./utils", "./translation", "./diacritics", "./data/select", "./data/array", "./data/ajax", "./data/tags", "./data/tokenizer", "./data/minimumInputLength", "./data/maximumInputLength", "./data/maximumSelectionLength", "./dropdown", "./dropdown/search", "./dropdown/hidePlaceholder", "./dropdown/infiniteScroll", "./dropdown/attachBody", "./dropdown/minimumResultsForSearch", "./dropdown/selectOnClose", "./dropdown/closeOnSelect", "./i18n/en"], function (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, A, B, C) {
      function D() {
        this.reset();
      }

      return D.prototype.apply = function (l) {
        if (l = a.extend(!0, {}, this.defaults, l), null == l.dataAdapter) {
          if (null != l.ajax ? l.dataAdapter = o : null != l.data ? l.dataAdapter = n : l.dataAdapter = m, l.minimumInputLength > 0 && (l.dataAdapter = j.Decorate(l.dataAdapter, r)), l.maximumInputLength > 0 && (l.dataAdapter = j.Decorate(l.dataAdapter, s)), l.maximumSelectionLength > 0 && (l.dataAdapter = j.Decorate(l.dataAdapter, t)), l.tags && (l.dataAdapter = j.Decorate(l.dataAdapter, p)), null == l.tokenSeparators && null == l.tokenizer || (l.dataAdapter = j.Decorate(l.dataAdapter, q)), null != l.query) {
            var C = b(l.amdBase + "compat/query");
            l.dataAdapter = j.Decorate(l.dataAdapter, C);
          }

          if (null != l.initSelection) {
            var D = b(l.amdBase + "compat/initSelection");
            l.dataAdapter = j.Decorate(l.dataAdapter, D);
          }
        }

        if (null == l.resultsAdapter && (l.resultsAdapter = c, null != l.ajax && (l.resultsAdapter = j.Decorate(l.resultsAdapter, x)), null != l.placeholder && (l.resultsAdapter = j.Decorate(l.resultsAdapter, w)), l.selectOnClose && (l.resultsAdapter = j.Decorate(l.resultsAdapter, A))), null == l.dropdownAdapter) {
          if (l.multiple) l.dropdownAdapter = u;else {
            var E = j.Decorate(u, v);
            l.dropdownAdapter = E;
          }

          if (0 !== l.minimumResultsForSearch && (l.dropdownAdapter = j.Decorate(l.dropdownAdapter, z)), l.closeOnSelect && (l.dropdownAdapter = j.Decorate(l.dropdownAdapter, B)), null != l.dropdownCssClass || null != l.dropdownCss || null != l.adaptDropdownCssClass) {
            var F = b(l.amdBase + "compat/dropdownCss");
            l.dropdownAdapter = j.Decorate(l.dropdownAdapter, F);
          }

          l.dropdownAdapter = j.Decorate(l.dropdownAdapter, y);
        }

        if (null == l.selectionAdapter) {
          if (l.multiple ? l.selectionAdapter = e : l.selectionAdapter = d, null != l.placeholder && (l.selectionAdapter = j.Decorate(l.selectionAdapter, f)), l.allowClear && (l.selectionAdapter = j.Decorate(l.selectionAdapter, g)), l.multiple && (l.selectionAdapter = j.Decorate(l.selectionAdapter, h)), null != l.containerCssClass || null != l.containerCss || null != l.adaptContainerCssClass) {
            var G = b(l.amdBase + "compat/containerCss");
            l.selectionAdapter = j.Decorate(l.selectionAdapter, G);
          }

          l.selectionAdapter = j.Decorate(l.selectionAdapter, i);
        }

        if ("string" == typeof l.language) if (l.language.indexOf("-") > 0) {
          var H = l.language.split("-"),
              I = H[0];
          l.language = [l.language, I];
        } else l.language = [l.language];

        if (a.isArray(l.language)) {
          var J = new k();
          l.language.push("en");

          for (var K = l.language, L = 0; L < K.length; L++) {
            var M = K[L],
                N = {};

            try {
              N = k.loadPath(M);
            } catch (a) {
              try {
                M = this.defaults.amdLanguageBase + M, N = k.loadPath(M);
              } catch (a) {
                l.debug && window.console && console.warn && console.warn('Select2: The language file for "' + M + '" could not be automatically loaded. A fallback will be used instead.');
                continue;
              }
            }

            J.extend(N);
          }

          l.translations = J;
        } else {
          var O = k.loadPath(this.defaults.amdLanguageBase + "en"),
              P = new k(l.language);
          P.extend(O), l.translations = P;
        }

        return l;
      }, D.prototype.reset = function () {
        function b(a) {
          function b(a) {
            return l[a] || a;
          }

          return a.replace(/[^\u0000-\u007E]/g, b);
        }

        function c(d, e) {
          if ("" === a.trim(d.term)) return e;

          if (e.children && e.children.length > 0) {
            for (var f = a.extend(!0, {}, e), g = e.children.length - 1; g >= 0; g--) {
              null == c(d, e.children[g]) && f.children.splice(g, 1);
            }

            return f.children.length > 0 ? f : c(d, f);
          }

          var h = b(e.text).toUpperCase(),
              i = b(d.term).toUpperCase();
          return h.indexOf(i) > -1 ? e : null;
        }

        this.defaults = {
          amdBase: "./",
          amdLanguageBase: "./i18n/",
          closeOnSelect: !0,
          debug: !1,
          dropdownAutoWidth: !1,
          escapeMarkup: j.escapeMarkup,
          language: C,
          matcher: c,
          minimumInputLength: 0,
          maximumInputLength: 0,
          maximumSelectionLength: 0,
          minimumResultsForSearch: 0,
          selectOnClose: !1,
          sorter: function sorter(a) {
            return a;
          },
          templateResult: function templateResult(a) {
            return a.text;
          },
          templateSelection: function templateSelection(a) {
            return a.text;
          },
          theme: "default",
          width: "resolve"
        };
      }, D.prototype.set = function (b, c) {
        var d = a.camelCase(b),
            e = {};
        e[d] = c;

        var f = j._convertData(e);

        a.extend(!0, this.defaults, f);
      }, new D();
    }), b.define("select2/options", ["require", "jquery", "./defaults", "./utils"], function (a, b, c, d) {
      function e(b, e) {
        if (this.options = b, null != e && this.fromElement(e), this.options = c.apply(this.options), e && e.is("input")) {
          var f = a(this.get("amdBase") + "compat/inputData");
          this.options.dataAdapter = d.Decorate(this.options.dataAdapter, f);
        }
      }

      return e.prototype.fromElement = function (a) {
        var c = ["select2"];
        null == this.options.multiple && (this.options.multiple = a.prop("multiple")), null == this.options.disabled && (this.options.disabled = a.prop("disabled")), null == this.options.language && (a.prop("lang") ? this.options.language = a.prop("lang").toLowerCase() : a.closest("[lang]").prop("lang") && (this.options.language = a.closest("[lang]").prop("lang"))), null == this.options.dir && (a.prop("dir") ? this.options.dir = a.prop("dir") : a.closest("[dir]").prop("dir") ? this.options.dir = a.closest("[dir]").prop("dir") : this.options.dir = "ltr"), a.prop("disabled", this.options.disabled), a.prop("multiple", this.options.multiple), d.GetData(a[0], "select2Tags") && (this.options.debug && window.console && console.warn && console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'), d.StoreData(a[0], "data", d.GetData(a[0], "select2Tags")), d.StoreData(a[0], "tags", !0)), d.GetData(a[0], "ajaxUrl") && (this.options.debug && window.console && console.warn && console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."), a.attr("ajax--url", d.GetData(a[0], "ajaxUrl")), d.StoreData(a[0], "ajax-Url", d.GetData(a[0], "ajaxUrl")));
        var e = {};
        e = b.fn.jquery && "1." == b.fn.jquery.substr(0, 2) && a[0].dataset ? b.extend(!0, {}, a[0].dataset, d.GetData(a[0])) : d.GetData(a[0]);
        var f = b.extend(!0, {}, e);
        f = d._convertData(f);

        for (var g in f) {
          b.inArray(g, c) > -1 || (b.isPlainObject(this.options[g]) ? b.extend(this.options[g], f[g]) : this.options[g] = f[g]);
        }

        return this;
      }, e.prototype.get = function (a) {
        return this.options[a];
      }, e.prototype.set = function (a, b) {
        this.options[a] = b;
      }, e;
    }), b.define("select2/core", ["jquery", "./options", "./utils", "./keys"], function (a, b, c, d) {
      var e = function e(a, d) {
        null != c.GetData(a[0], "select2") && c.GetData(a[0], "select2").destroy(), this.$element = a, this.id = this._generateId(a), d = d || {}, this.options = new b(d, a), e.__super__.constructor.call(this);
        var f = a.attr("tabindex") || 0;
        c.StoreData(a[0], "old-tabindex", f), a.attr("tabindex", "-1");
        var g = this.options.get("dataAdapter");
        this.dataAdapter = new g(a, this.options);
        var h = this.render();

        this._placeContainer(h);

        var i = this.options.get("selectionAdapter");
        this.selection = new i(a, this.options), this.$selection = this.selection.render(), this.selection.position(this.$selection, h);
        var j = this.options.get("dropdownAdapter");
        this.dropdown = new j(a, this.options), this.$dropdown = this.dropdown.render(), this.dropdown.position(this.$dropdown, h);
        var k = this.options.get("resultsAdapter");
        this.results = new k(a, this.options, this.dataAdapter), this.$results = this.results.render(), this.results.position(this.$results, this.$dropdown);
        var l = this;
        this._bindAdapters(), this._registerDomEvents(), this._registerDataEvents(), this._registerSelectionEvents(), this._registerDropdownEvents(), this._registerResultsEvents(), this._registerEvents(), this.dataAdapter.current(function (a) {
          l.trigger("selection:update", {
            data: a
          });
        }), a.addClass("select2-hidden-accessible"), a.attr("aria-hidden", "true"), this._syncAttributes(), c.StoreData(a[0], "select2", this), a.data("select2", this);
      };

      return c.Extend(e, c.Observable), e.prototype._generateId = function (a) {
        var b = "";
        return b = null != a.attr("id") ? a.attr("id") : null != a.attr("name") ? a.attr("name") + "-" + c.generateChars(2) : c.generateChars(4), b = b.replace(/(:|\.|\[|\]|,)/g, ""), b = "select2-" + b;
      }, e.prototype._placeContainer = function (a) {
        a.insertAfter(this.$element);

        var b = this._resolveWidth(this.$element, this.options.get("width"));

        null != b && a.css("width", b);
      }, e.prototype._resolveWidth = function (a, b) {
        var c = /^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;

        if ("resolve" == b) {
          var d = this._resolveWidth(a, "style");

          return null != d ? d : this._resolveWidth(a, "element");
        }

        if ("element" == b) {
          var e = a.outerWidth(!1);
          return e <= 0 ? "auto" : e + "px";
        }

        if ("style" == b) {
          var f = a.attr("style");
          if ("string" != typeof f) return null;

          for (var g = f.split(";"), h = 0, i = g.length; h < i; h += 1) {
            var j = g[h].replace(/\s/g, ""),
                k = j.match(c);
            if (null !== k && k.length >= 1) return k[1];
          }

          return null;
        }

        return b;
      }, e.prototype._bindAdapters = function () {
        this.dataAdapter.bind(this, this.$container), this.selection.bind(this, this.$container), this.dropdown.bind(this, this.$container), this.results.bind(this, this.$container);
      }, e.prototype._registerDomEvents = function () {
        var b = this;
        this.$element.on("change.select2", function () {
          b.dataAdapter.current(function (a) {
            b.trigger("selection:update", {
              data: a
            });
          });
        }), this.$element.on("focus.select2", function (a) {
          b.trigger("focus", a);
        }), this._syncA = c.bind(this._syncAttributes, this), this._syncS = c.bind(this._syncSubtree, this), this.$element[0].attachEvent && this.$element[0].attachEvent("onpropertychange", this._syncA);
        var d = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver;
        null != d ? (this._observer = new d(function (c) {
          a.each(c, b._syncA), a.each(c, b._syncS);
        }), this._observer.observe(this.$element[0], {
          attributes: !0,
          childList: !0,
          subtree: !1
        })) : this.$element[0].addEventListener && (this.$element[0].addEventListener("DOMAttrModified", b._syncA, !1), this.$element[0].addEventListener("DOMNodeInserted", b._syncS, !1), this.$element[0].addEventListener("DOMNodeRemoved", b._syncS, !1));
      }, e.prototype._registerDataEvents = function () {
        var a = this;
        this.dataAdapter.on("*", function (b, c) {
          a.trigger(b, c);
        });
      }, e.prototype._registerSelectionEvents = function () {
        var b = this,
            c = ["toggle", "focus"];
        this.selection.on("toggle", function () {
          b.toggleDropdown();
        }), this.selection.on("focus", function (a) {
          b.focus(a);
        }), this.selection.on("*", function (d, e) {
          -1 === a.inArray(d, c) && b.trigger(d, e);
        });
      }, e.prototype._registerDropdownEvents = function () {
        var a = this;
        this.dropdown.on("*", function (b, c) {
          a.trigger(b, c);
        });
      }, e.prototype._registerResultsEvents = function () {
        var a = this;
        this.results.on("*", function (b, c) {
          a.trigger(b, c);
        });
      }, e.prototype._registerEvents = function () {
        var a = this;
        this.on("open", function () {
          a.$container.addClass("select2-container--open");
        }), this.on("close", function () {
          a.$container.removeClass("select2-container--open");
        }), this.on("enable", function () {
          a.$container.removeClass("select2-container--disabled");
        }), this.on("disable", function () {
          a.$container.addClass("select2-container--disabled");
        }), this.on("blur", function () {
          a.$container.removeClass("select2-container--focus");
        }), this.on("query", function (b) {
          a.isOpen() || a.trigger("open", {}), this.dataAdapter.query(b, function (c) {
            a.trigger("results:all", {
              data: c,
              query: b
            });
          });
        }), this.on("query:append", function (b) {
          this.dataAdapter.query(b, function (c) {
            a.trigger("results:append", {
              data: c,
              query: b
            });
          });
        }), this.on("keypress", function (b) {
          var c = b.which;
          a.isOpen() ? c === d.ESC || c === d.TAB || c === d.UP && b.altKey ? (a.close(), b.preventDefault()) : c === d.ENTER ? (a.trigger("results:select", {}), b.preventDefault()) : c === d.SPACE && b.ctrlKey ? (a.trigger("results:toggle", {}), b.preventDefault()) : c === d.UP ? (a.trigger("results:previous", {}), b.preventDefault()) : c === d.DOWN && (a.trigger("results:next", {}), b.preventDefault()) : (c === d.ENTER || c === d.SPACE || c === d.DOWN && b.altKey) && (a.open(), b.preventDefault());
        });
      }, e.prototype._syncAttributes = function () {
        this.options.set("disabled", this.$element.prop("disabled")), this.options.get("disabled") ? (this.isOpen() && this.close(), this.trigger("disable", {})) : this.trigger("enable", {});
      }, e.prototype._syncSubtree = function (a, b) {
        var c = !1,
            d = this;

        if (!a || !a.target || "OPTION" === a.target.nodeName || "OPTGROUP" === a.target.nodeName) {
          if (b) {
            if (b.addedNodes && b.addedNodes.length > 0) for (var e = 0; e < b.addedNodes.length; e++) {
              var f = b.addedNodes[e];
              f.selected && (c = !0);
            } else b.removedNodes && b.removedNodes.length > 0 && (c = !0);
          } else c = !0;
          c && this.dataAdapter.current(function (a) {
            d.trigger("selection:update", {
              data: a
            });
          });
        }
      }, e.prototype.trigger = function (a, b) {
        var c = e.__super__.trigger,
            d = {
          open: "opening",
          close: "closing",
          select: "selecting",
          unselect: "unselecting",
          clear: "clearing"
        };

        if (void 0 === b && (b = {}), a in d) {
          var f = d[a],
              g = {
            prevented: !1,
            name: a,
            args: b
          };
          if (c.call(this, f, g), g.prevented) return void (b.prevented = !0);
        }

        c.call(this, a, b);
      }, e.prototype.toggleDropdown = function () {
        this.options.get("disabled") || (this.isOpen() ? this.close() : this.open());
      }, e.prototype.open = function () {
        this.isOpen() || this.trigger("query", {});
      }, e.prototype.close = function () {
        this.isOpen() && this.trigger("close", {});
      }, e.prototype.isOpen = function () {
        return this.$container.hasClass("select2-container--open");
      }, e.prototype.hasFocus = function () {
        return this.$container.hasClass("select2-container--focus");
      }, e.prototype.focus = function (a) {
        this.hasFocus() || (this.$container.addClass("select2-container--focus"), this.trigger("focus", {}));
      }, e.prototype.enable = function (a) {
        this.options.get("debug") && window.console && console.warn && console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.'), null != a && 0 !== a.length || (a = [!0]);
        var b = !a[0];
        this.$element.prop("disabled", b);
      }, e.prototype.data = function () {
        this.options.get("debug") && arguments.length > 0 && window.console && console.warn && console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');
        var a = [];
        return this.dataAdapter.current(function (b) {
          a = b;
        }), a;
      }, e.prototype.val = function (b) {
        if (this.options.get("debug") && window.console && console.warn && console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'), null == b || 0 === b.length) return this.$element.val();
        var c = b[0];
        a.isArray(c) && (c = a.map(c, function (a) {
          return a.toString();
        })), this.$element.val(c).trigger("change");
      }, e.prototype.destroy = function () {
        this.$container.remove(), this.$element[0].detachEvent && this.$element[0].detachEvent("onpropertychange", this._syncA), null != this._observer ? (this._observer.disconnect(), this._observer = null) : this.$element[0].removeEventListener && (this.$element[0].removeEventListener("DOMAttrModified", this._syncA, !1), this.$element[0].removeEventListener("DOMNodeInserted", this._syncS, !1), this.$element[0].removeEventListener("DOMNodeRemoved", this._syncS, !1)), this._syncA = null, this._syncS = null, this.$element.off(".select2"), this.$element.attr("tabindex", c.GetData(this.$element[0], "old-tabindex")), this.$element.removeClass("select2-hidden-accessible"), this.$element.attr("aria-hidden", "false"), c.RemoveData(this.$element[0]), this.$element.removeData("select2"), this.dataAdapter.destroy(), this.selection.destroy(), this.dropdown.destroy(), this.results.destroy(), this.dataAdapter = null, this.selection = null, this.dropdown = null, this.results = null;
      }, e.prototype.render = function () {
        var b = a('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');
        return b.attr("dir", this.options.get("dir")), this.$container = b, this.$container.addClass("select2-container--" + this.options.get("theme")), c.StoreData(b[0], "element", this.$element), b;
      }, e;
    }), b.define("jquery-mousewheel", ["jquery"], function (a) {
      return a;
    }), b.define("jquery.select2", ["jquery", "jquery-mousewheel", "./select2/core", "./select2/defaults", "./select2/utils"], function (a, b, c, d, e) {
      if (null == a.fn.select2) {
        var f = ["open", "close", "destroy"];

        a.fn.select2 = function (b) {
          if ("object" == _typeof(b = b || {})) return this.each(function () {
            var d = a.extend(!0, {}, b);
            new c(a(this), d);
          }), this;

          if ("string" == typeof b) {
            var d,
                g = Array.prototype.slice.call(arguments, 1);
            return this.each(function () {
              var a = e.GetData(this, "select2");
              null == a && window.console && console.error && console.error("The select2('" + b + "') method was called on an element that is not using Select2."), d = a[b].apply(a, g);
            }), a.inArray(b, f) > -1 ? this : d;
          }

          throw new Error("Invalid arguments for Select2: " + b);
        };
      }

      return null == a.fn.select2.defaults && (a.fn.select2.defaults = d), c;
    }), {
      define: b.define,
      require: b.require
    };
  }(),
      c = b.require("jquery.select2");

  return a.fn.select2.amd = b, c;
});
"use strict";

var ls = function ls(string) {
  if (typeof reportingApiSetup.localizedStrings[string] !== 'undefined') {
    return reportingApiSetup.localizedStrings[string];
  } else {
    return string;
  }
};

jQuery(document).ready(function ($) {
  // Setup Page Tab Navigation
  reportingTabs.addTabEvents();
  reportingTabs.addTableEvents();
  reportingTabs.addNavigationEvents(); // Check Query parameters
  // If it is TinCan search, nav goes to Tin Can Tab

  reportingQueryString.init();

  var saveSettings = function saveSettings(event) {
    event.preventDefault(); // Cache inputs

    var tinCanActivation = $('input[type=radio][name=tinCanActivation]');
    var disableMarkComplete = $('input[type=radio][name=disableMarkComplete]');
    var nonceProtection = $('input[type=radio][name=nonceProtection]'); // Disable inputs while storing data

    tinCanActivation.prop('disabled', true);
    disableMarkComplete.prop('disabled', true);
    nonceProtection.prop('disabled', true); // Get settings values

    var tinCanActivationSelected = $('input[type=radio][name=tinCanActivation]:checked');
    var disableMarkCompleteSelected = $('input[type=radio][name=disableMarkComplete]:checked');
    var nonceProtectionSelected = $('input[type=radio][name=nonceProtection]:checked'); // Make Api Calls to save input values

    var toggleTinCan = uoReportingAPI.reportingApiCall('show_tincan', tinCanActivationSelected.val());
    var toggleMarkComplete = uoReportingAPI.reportingApiCall('disable_mark_complete', disableMarkCompleteSelected.val());
    var toggleNonceProtection = uoReportingAPI.reportingApiCall('nonce_protection', nonceProtectionSelected.val());
    toggleTinCan.done(function (response) {
      if ('1' === tinCanActivationSelected.val()) {
        $('li#menuTinCan').show();
        $('a[href="#tin-can"]').show();
      }

      if ('0' === tinCanActivationSelected.val()) {
        $('li#menuTinCan').hide();
        $('a[href="#tin-can"]').hide();
      }

      $('input[type=radio][name=tinCanActivation]').prop('disabled', false);
      $('#save-settings').addClass('reporting-button-green');
    });
    toggleMarkComplete.done(function (response) {
      $('input[type=radio][name=disableMarkComplete]').prop('disabled', false);
      $('#save-settings').addClass('reporting-button-green');
      setTimeout(function () {
        $('#save-settings').removeClass('reporting-button-green');
      }, 2500);
    });
    toggleNonceProtection.done(function (response) {
      $('input[type=radio][name=nonceProtection]').prop('disabled', false);
      $('#save-settings').addClass('reporting-button-green');
      setTimeout(function () {
        $('#save-settings').removeClass('reporting-button-green');
      }, 2500);
    });
    setTimeout(function () {}, 3000);
  };

  var resetTinCanData = function resetTinCanData(event) {
    event.preventDefault();
    var text = ls('Are you sure you want to permanently delete all Tin Can data? This cannot be undone.');
    if (!confirm(text)) return;
    $('#btnResetTinCanData').attr('disabled', 'disabled');
    var callResetTinCanData = uoReportingAPI.reportingApiCall('reset_tincan_data');
    callResetTinCanData.done(function (response) {
      $('#btnResetTinCanData').removeAttr('disabled');
      $('.uo-admin-reporting-tab-single#tin-can .tablenav-pages').html('');
      $('.uo-admin-reporting-tab-single#tin-can .tablenav.bottom').html('');
      $('.uo-admin-reporting-tab-single#tin-can .wp-list-table').remove();
    });
  };

  var resetQuizData = function resetQuizData(event) {
    event.preventDefault();
    var text = ls('Are you sure you want to permanently delete all Quiz data? This cannot be undone.');
    if (!confirm(text)) return;
    $('#btnResetQuizData').attr('disabled', 'disabled');
    var callResetQuizData = uoReportingAPI.reportingApiCall('reset_quiz_data');
    callResetQuizData.done(function (response) {
      $('#btnResetQuizData').removeAttr('disabled');
      $('.uo-admin-reporting-tab-single#xapi-tincan .tablenav-pages').html('');
      $('.uo-admin-reporting-tab-single#xapi-tincan .tablenav.bottom').html('');
      $('.uo-admin-reporting-tab-single#xapi-tincan .wp-list-table').remove();
    });
  };

  var resetBookmarkCanData = function resetBookmarkCanData(event) {
    event.preventDefault();
    var text = ls('Are you sure you want to permanently delete all Bookmark data? This cannot be undone.');
    if (!confirm(text)) return;
    $('#btnResetBookmarkData').attr('disabled', 'disabled');
    var callbtnResetBookmarkData = uoReportingAPI.reportingApiCall('reset_bookmark_data');
    callbtnResetBookmarkData.done(function (response) {
      $('#btnResetTinCanData').removeAttr('disabled');
    });
  };

  var purgeExperienced = function purgeExperienced(event) {
    event.preventDefault();
    var text = ls('Are you sure you want to permanently delete all saved xApi statements with the "Experienced" verb? This cannot be undone.');
    if (!confirm(text)) return;
    $('#btnPurgeExperienced').attr('disabled', 'disabled');
    var callbtnPurgeExperienced = uoReportingAPI.reportingApiCall('purge_experienced');
    callbtnPurgeExperienced.done(function (response) {
      $('#btnPurgeExperienced').removeAttr('disabled');
    });
  };

  var purgeAnswered = function purgeAnswered(event) {
    event.preventDefault();
    var text = ls('Are you sure you want to permanently delete all saved xApi statements with the "Answered" verb? This cannot be undone.');
    if (!confirm(text)) return;
    $('#btnPurgeAnswered').attr('disabled', 'disabled');
    var callbtnPurgeAnswered = uoReportingAPI.reportingApiCall('purge_answered');
    callbtnPurgeAnswered.done(function (response) {
      $('#btnPurgeAnswered').removeAttr('disabled');
    });
  }; // On Click save settings button store user input selections


  $('#save-settings').on('click', saveSettings); // On Click Reset Tin Can Data button

  $('#btnResetTinCanData').on('click', resetTinCanData);
  $('#btnResetQuizData').on('click', resetQuizData);
  $('#btnResetBookmarkData').on('click', resetBookmarkCanData);
  $('#btnPurgeExperienced').on('click', purgeExperienced);
  $('#btnPurgeAnswered').on('click', purgeAnswered);
});
"use strict";function _typeof(obj){if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){_typeof=function _typeof(obj){return typeof obj;};}else{_typeof=function _typeof(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;};}return _typeof(obj);}/*! DataTables 1.10.19
 * ©2008-2018 SpryMedia Ltd - datatables.net/license
 */ /**
 * @summary     DataTables
 * @description Paginate, search and order HTML tables
 * @version     1.10.19
 * @file        jquery.dataTables.js
 * @author      SpryMedia Ltd
 * @contact     www.datatables.net
 * @copyright   Copyright 2008-2018 SpryMedia Ltd.
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */ /*jslint evil: true, undef: true, browser: true */ /*globals $,require,jQuery,define,_selector_run,_selector_opts,_selector_first,_selector_row_indexes,_ext,_Api,_api_register,_api_registerPlural,_re_new_lines,_re_html,_re_formatted_numeric,_re_escape_regex,_empty,_intVal,_numToDecimal,_isNumber,_isHtml,_htmlNumeric,_pluck,_pluck_order,_range,_stripHtml,_unique,_fnBuildAjax,_fnAjaxUpdate,_fnAjaxParameters,_fnAjaxUpdateDraw,_fnAjaxDataSrc,_fnAddColumn,_fnColumnOptions,_fnAdjustColumnSizing,_fnVisibleToColumnIndex,_fnColumnIndexToVisible,_fnVisbleColumns,_fnGetColumns,_fnColumnTypes,_fnApplyColumnDefs,_fnHungarianMap,_fnCamelToHungarian,_fnLanguageCompat,_fnBrowserDetect,_fnAddData,_fnAddTr,_fnNodeToDataIndex,_fnNodeToColumnIndex,_fnGetCellData,_fnSetCellData,_fnSplitObjNotation,_fnGetObjectDataFn,_fnSetObjectDataFn,_fnGetDataMaster,_fnClearTable,_fnDeleteIndex,_fnInvalidate,_fnGetRowElements,_fnCreateTr,_fnBuildHead,_fnDrawHead,_fnDraw,_fnReDraw,_fnAddOptionsHtml,_fnDetectHeader,_fnGetUniqueThs,_fnFeatureHtmlFilter,_fnFilterComplete,_fnFilterCustom,_fnFilterColumn,_fnFilter,_fnFilterCreateSearch,_fnEscapeRegex,_fnFilterData,_fnFeatureHtmlInfo,_fnUpdateInfo,_fnInfoMacros,_fnInitialise,_fnInitComplete,_fnLengthChange,_fnFeatureHtmlLength,_fnFeatureHtmlPaginate,_fnPageChange,_fnFeatureHtmlProcessing,_fnProcessingDisplay,_fnFeatureHtmlTable,_fnScrollDraw,_fnApplyToChildren,_fnCalculateColumnWidths,_fnThrottle,_fnConvertToWidth,_fnGetWidestNode,_fnGetMaxLenString,_fnStringToCss,_fnSortFlatten,_fnSort,_fnSortAria,_fnSortListener,_fnSortAttachListener,_fnSortingClasses,_fnSortData,_fnSaveState,_fnLoadState,_fnSettingsFromNode,_fnLog,_fnMap,_fnBindAction,_fnCallbackReg,_fnCallbackFire,_fnLengthOverflow,_fnRenderer,_fnDataSource,_fnRowAttributes*/(function(factory){"use strict";if(typeof define==='function'&&define.amd){// AMD
define(['jquery'],function($){return factory($,window,document);});}else if((typeof exports==="undefined"?"undefined":_typeof(exports))==='object'){// CommonJS
module.exports=function(root,$){if(!root){// CommonJS environments without a window global must pass a
// root. This will give an error otherwise
root=window;}if(!$){$=typeof window!=='undefined'?// jQuery's factory checks for a global window
require('jquery'):require('jquery')(root);}return factory($,root,root.document);};}else{// Browser
factory(jQuery,window,document);}})(function($,window,document,undefined){"use strict";/**
     * DataTables is a plug-in for the jQuery Javascript library. It is a highly
     * flexible tool, based upon the foundations of progressive enhancement,
     * which will add advanced interaction controls to any HTML table. For a
     * full list of features please refer to
     * [DataTables.net](href="http://datatables.net).
     *
     * Note that the `DataTable` object is not a global variable but is aliased
     * to `jQuery.fn.DataTable` and `jQuery.fn.dataTable` through which it may
     * be  accessed.
     *
     *  @class
     *  @param {object} [init={}] Configuration object for DataTables. Options
     *    are defined by {@link DataTable.defaults}
     *  @requires jQuery 1.7+
     *
     *  @example
     *    // Basic initialisation
     *    $(document).ready( function {
     *      $('#example').dataTable();
     *    } );
     *
     *  @example
     *    // Initialisation with configuration options - in this case, disable
     *    // pagination and sorting.
     *    $(document).ready( function {
     *      $('#example').dataTable( {
     *        "paginate": false,
     *        "sort": false
     *      } );
     *    } );
     */var DataTable=function DataTable(options){/**
         * Perform a jQuery selector action on the table's TR elements (from the tbody) and
         * return the resulting jQuery object.
         *  @param {string|node|jQuery} sSelector jQuery selector or node collection to act on
         *  @param {object} [oOpts] Optional parameters for modifying the rows to be included
         *  @param {string} [oOpts.filter=none] Select TR elements that meet the current filter
         *    criterion ("applied") or all TR elements (i.e. no filter).
         *  @param {string} [oOpts.order=current] Order of the TR elements in the processed array.
         *    Can be either 'current', whereby the current sorting of the table is used, or
         *    'original' whereby the original order the data was read into the table is used.
         *  @param {string} [oOpts.page=all] Limit the selection to the currently displayed page
         *    ("current") or not ("all"). If 'current' is given, then order is assumed to be
         *    'current' and filter is 'applied', regardless of what they might be given as.
         *  @returns {object} jQuery object, filtered by the given selector.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Highlight every second row
         *      oTable.$('tr:odd').css('backgroundColor', 'blue');
         *    } );
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Filter to rows with 'Webkit' in them, add a background colour and then
         *      // remove the filter, thus highlighting the 'Webkit' rows only.
         *      oTable.fnFilter('Webkit');
         *      oTable.$('tr', {"search": "applied"}).css('backgroundColor', 'blue');
         *      oTable.fnFilter('');
         *    } );
         */this.$=function(sSelector,oOpts){return this.api(true).$(sSelector,oOpts);};/**
         * Almost identical to $ in operation, but in this case returns the data for the matched
         * rows - as such, the jQuery selector used should match TR row nodes or TD/TH cell nodes
         * rather than any descendants, so the data can be obtained for the row/cell. If matching
         * rows are found, the data returned is the original data array/object that was used to
         * create the row (or a generated array if from a DOM source).
         *
         * This method is often useful in-combination with $ where both functions are given the
         * same parameters and the array indexes will match identically.
         *  @param {string|node|jQuery} sSelector jQuery selector or node collection to act on
         *  @param {object} [oOpts] Optional parameters for modifying the rows to be included
         *  @param {string} [oOpts.filter=none] Select elements that meet the current filter
         *    criterion ("applied") or all elements (i.e. no filter).
         *  @param {string} [oOpts.order=current] Order of the data in the processed array.
         *    Can be either 'current', whereby the current sorting of the table is used, or
         *    'original' whereby the original order the data was read into the table is used.
         *  @param {string} [oOpts.page=all] Limit the selection to the currently displayed page
         *    ("current") or not ("all"). If 'current' is given, then order is assumed to be
         *    'current' and filter is 'applied', regardless of what they might be given as.
         *  @returns {array} Data for the matched elements. If any elements, as a result of the
         *    selector, were not TR, TD or TH elements in the DataTable, they will have a null
         *    entry in the array.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Get the data from the first row in the table
         *      var data = oTable._('tr:first');
         *
         *      // Do something useful with the data
         *      alert( "First cell is: "+data[0] );
         *    } );
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Filter to 'Webkit' and get all data for
         *      oTable.fnFilter('Webkit');
         *      var data = oTable._('tr', {"search": "applied"});
         *
         *      // Do something with the data
         *      alert( data.length+" rows matched the search" );
         *    } );
         */this._=function(sSelector,oOpts){return this.api(true).rows(sSelector,oOpts).data();};/**
         * Create a DataTables Api instance, with the currently selected tables for
         * the Api's context.
         * @param {boolean} [traditional=false] Set the API instance's context to be
         *   only the table referred to by the `DataTable.ext.iApiIndex` option, as was
         *   used in the API presented by DataTables 1.9- (i.e. the traditional mode),
         *   or if all tables captured in the jQuery object should be used.
         * @return {DataTables.Api}
         */this.api=function(traditional){return traditional?new _Api2(_fnSettingsFromNode(this[_ext.iApiIndex])):new _Api2(this);};/**
         * Add a single new row or multiple rows of data to the table. Please note
         * that this is suitable for client-side processing only - if you are using
         * server-side processing (i.e. "bServerSide": true), then to add data, you
         * must add it to the data source, i.e. the server-side, through an Ajax call.
         *  @param {array|object} data The data to be added to the table. This can be:
         *    <ul>
         *      <li>1D array of data - add a single row with the data provided</li>
         *      <li>2D array of arrays - add multiple rows in a single call</li>
         *      <li>object - data object when using <i>mData</i></li>
         *      <li>array of objects - multiple data objects when using <i>mData</i></li>
         *    </ul>
         *  @param {bool} [redraw=true] redraw the table or not
         *  @returns {array} An array of integers, representing the list of indexes in
         *    <i>aoData</i> ({@link DataTable.models.oSettings}) that have been added to
         *    the table.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    // Global var for counter
         *    var giCount = 2;
         *
         *    $(document).ready(function() {
         *      $('#example').dataTable();
         *    } );
         *
         *    function fnClickAddRow() {
         *      $('#example').dataTable().fnAddData( [
         *        giCount+".1",
         *        giCount+".2",
         *        giCount+".3",
         *        giCount+".4" ]
         *      );
         *
         *      giCount++;
         *    }
         */this.fnAddData=function(data,redraw){var api=this.api(true);/* Check if we want to add multiple rows or not */var rows=$.isArray(data)&&($.isArray(data[0])||$.isPlainObject(data[0]))?api.rows.add(data):api.row.add(data);if(redraw===undefined||redraw){api.draw();}return rows.flatten().toArray();};/**
         * This function will make DataTables recalculate the column sizes, based on the data
         * contained in the table and the sizes applied to the columns (in the DOM, CSS or
         * through the sWidth parameter). This can be useful when the width of the table's
         * parent element changes (for example a window resize).
         *  @param {boolean} [bRedraw=true] Redraw the table or not, you will typically want to
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable( {
         *        "sScrollY": "200px",
         *        "bPaginate": false
         *      } );
         *
         *      $(window).on('resize', function () {
         *        oTable.fnAdjustColumnSizing();
         *      } );
         *    } );
         */this.fnAdjustColumnSizing=function(bRedraw){var api=this.api(true).columns.adjust();var settings=api.settings()[0];var scroll=settings.oScroll;if(bRedraw===undefined||bRedraw){api.draw(false);}else if(scroll.sX!==""||scroll.sY!==""){/* If not redrawing, but scrolling, we want to apply the new column sizes anyway */_fnScrollDraw(settings);}};/**
         * Quickly and simply clear a table
         *  @param {bool} [bRedraw=true] redraw the table or not
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Immediately 'nuke' the current rows (perhaps waiting for an Ajax callback...)
         *      oTable.fnClearTable();
         *    } );
         */this.fnClearTable=function(bRedraw){var api=this.api(true).clear();if(bRedraw===undefined||bRedraw){api.draw();}};/**
         * The exact opposite of 'opening' a row, this function will close any rows which
         * are currently 'open'.
         *  @param {node} nTr the table row to 'close'
         *  @returns {int} 0 on success, or 1 if failed (can't find the row)
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable;
         *
         *      // 'open' an information row when a row is clicked on
         *      $('#example tbody tr').click( function () {
         *        if ( oTable.fnIsOpen(this) ) {
         *          oTable.fnClose( this );
         *        } else {
         *          oTable.fnOpen( this, "Temporary row opened", "info_row" );
         *        }
         *      } );
         *
         *      oTable = $('#example').dataTable();
         *    } );
         */this.fnClose=function(nTr){this.api(true).row(nTr).child.hide();};/**
         * Remove a row for the table
         *  @param {mixed} target The index of the row from aoData to be deleted, or
         *    the TR element you want to delete
         *  @param {function|null} [callBack] Callback function
         *  @param {bool} [redraw=true] Redraw the table or not
         *  @returns {array} The row that was deleted
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Immediately remove the first row
         *      oTable.fnDeleteRow( 0 );
         *    } );
         */this.fnDeleteRow=function(target,callback,redraw){var api=this.api(true);var rows=api.rows(target);var settings=rows.settings()[0];var data=settings.aoData[rows[0][0]];rows.remove();if(callback){callback.call(this,settings,data);}if(redraw===undefined||redraw){api.draw();}return data;};/**
         * Restore the table to it's original state in the DOM by removing all of DataTables
         * enhancements, alterations to the DOM structure of the table and event listeners.
         *  @param {boolean} [remove=false] Completely remove the table from the DOM
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      // This example is fairly pointless in reality, but shows how fnDestroy can be used
         *      var oTable = $('#example').dataTable();
         *      oTable.fnDestroy();
         *    } );
         */this.fnDestroy=function(remove){this.api(true).destroy(remove);};/**
         * Redraw the table
         *  @param {bool} [complete=true] Re-filter and resort (if enabled) the table before the draw.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Re-draw the table - you wouldn't want to do it here, but it's an example :-)
         *      oTable.fnDraw();
         *    } );
         */this.fnDraw=function(complete){// Note that this isn't an exact match to the old call to _fnDraw - it takes
// into account the new data, but can hold position.
this.api(true).draw(complete);};/**
         * Filter the input based on data
         *  @param {string} sInput String to filter the table on
         *  @param {int|null} [iColumn] Column to limit filtering to
         *  @param {bool} [bRegex=false] Treat as regular expression or not
         *  @param {bool} [bSmart=true] Perform smart filtering or not
         *  @param {bool} [bShowGlobal=true] Show the input global filter in it's input box(es)
         *  @param {bool} [bCaseInsensitive=true] Do case-insensitive matching (true) or not (false)
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Sometime later - filter...
         *      oTable.fnFilter( 'test string' );
         *    } );
         */this.fnFilter=function(sInput,iColumn,bRegex,bSmart,bShowGlobal,bCaseInsensitive){var api=this.api(true);if(iColumn===null||iColumn===undefined){api.search(sInput,bRegex,bSmart,bCaseInsensitive);}else{api.column(iColumn).search(sInput,bRegex,bSmart,bCaseInsensitive);}api.draw();};/**
         * Get the data for the whole table, an individual row or an individual cell based on the
         * provided parameters.
         *  @param {int|node} [src] A TR row node, TD/TH cell node or an integer. If given as
         *    a TR node then the data source for the whole row will be returned. If given as a
         *    TD/TH cell node then iCol will be automatically calculated and the data for the
         *    cell returned. If given as an integer, then this is treated as the aoData internal
         *    data index for the row (see fnGetPosition) and the data for that row used.
         *  @param {int} [col] Optional column index that you want the data of.
         *  @returns {array|object|string} If mRow is undefined, then the data for all rows is
         *    returned. If mRow is defined, just data for that row, and is iCol is
         *    defined, only data for the designated cell is returned.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    // Row data
         *    $(document).ready(function() {
         *      oTable = $('#example').dataTable();
         *
         *      oTable.$('tr').click( function () {
         *        var data = oTable.fnGetData( this );
         *        // ... do something with the array / object of data for the row
         *      } );
         *    } );
         *
         *  @example
         *    // Individual cell data
         *    $(document).ready(function() {
         *      oTable = $('#example').dataTable();
         *
         *      oTable.$('td').click( function () {
         *        var sData = oTable.fnGetData( this );
         *        alert( 'The cell clicked on had the value of '+sData );
         *      } );
         *    } );
         */this.fnGetData=function(src,col){var api=this.api(true);if(src!==undefined){var type=src.nodeName?src.nodeName.toLowerCase():'';return col!==undefined||type=='td'||type=='th'?api.cell(src,col).data():api.row(src).data()||null;}return api.data().toArray();};/**
         * Get an array of the TR nodes that are used in the table's body. Note that you will
         * typically want to use the '$' API method in preference to this as it is more
         * flexible.
         *  @param {int} [iRow] Optional row index for the TR element you want
         *  @returns {array|node} If iRow is undefined, returns an array of all TR elements
         *    in the table's body, or iRow is defined, just the TR element requested.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Get the nodes from the table
         *      var nNodes = oTable.fnGetNodes( );
         *    } );
         */this.fnGetNodes=function(iRow){var api=this.api(true);return iRow!==undefined?api.row(iRow).node():api.rows().nodes().flatten().toArray();};/**
         * Get the array indexes of a particular cell from it's DOM element
         * and column index including hidden columns
         *  @param {node} node this can either be a TR, TD or TH in the table's body
         *  @returns {int} If nNode is given as a TR, then a single index is returned, or
         *    if given as a cell, an array of [row index, column index (visible),
         *    column index (all)] is given.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      $('#example tbody td').click( function () {
         *        // Get the position of the current data from the node
         *        var aPos = oTable.fnGetPosition( this );
         *
         *        // Get the data array for this row
         *        var aData = oTable.fnGetData( aPos[0] );
         *
         *        // Update the data array and return the value
         *        aData[ aPos[1] ] = 'clicked';
         *        this.innerHTML = 'clicked';
         *      } );
         *
         *      // Init DataTables
         *      oTable = $('#example').dataTable();
         *    } );
         */this.fnGetPosition=function(node){var api=this.api(true);var nodeName=node.nodeName.toUpperCase();if(nodeName=='TR'){return api.row(node).index();}else if(nodeName=='TD'||nodeName=='TH'){var cell=api.cell(node).index();return[cell.row,cell.columnVisible,cell.column];}return null;};/**
         * Check to see if a row is 'open' or not.
         *  @param {node} nTr the table row to check
         *  @returns {boolean} true if the row is currently open, false otherwise
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable;
         *
         *      // 'open' an information row when a row is clicked on
         *      $('#example tbody tr').click( function () {
         *        if ( oTable.fnIsOpen(this) ) {
         *          oTable.fnClose( this );
         *        } else {
         *          oTable.fnOpen( this, "Temporary row opened", "info_row" );
         *        }
         *      } );
         *
         *      oTable = $('#example').dataTable();
         *    } );
         */this.fnIsOpen=function(nTr){return this.api(true).row(nTr).child.isShown();};/**
         * This function will place a new row directly after a row which is currently
         * on display on the page, with the HTML contents that is passed into the
         * function. This can be used, for example, to ask for confirmation that a
         * particular record should be deleted.
         *  @param {node} nTr The table row to 'open'
         *  @param {string|node|jQuery} mHtml The HTML to put into the row
         *  @param {string} sClass Class to give the new TD cell
         *  @returns {node} The row opened. Note that if the table row passed in as the
         *    first parameter, is not found in the table, this method will silently
         *    return.
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable;
         *
         *      // 'open' an information row when a row is clicked on
         *      $('#example tbody tr').click( function () {
         *        if ( oTable.fnIsOpen(this) ) {
         *          oTable.fnClose( this );
         *        } else {
         *          oTable.fnOpen( this, "Temporary row opened", "info_row" );
         *        }
         *      } );
         *
         *      oTable = $('#example').dataTable();
         *    } );
         */this.fnOpen=function(nTr,mHtml,sClass){return this.api(true).row(nTr).child(mHtml,sClass).show().child()[0];};/**
         * Change the pagination - provides the internal logic for pagination in a simple API
         * function. With this function you can have a DataTables table go to the next,
         * previous, first or last pages.
         *  @param {string|int} mAction Paging action to take: "first", "previous", "next" or "last"
         *    or page number to jump to (integer), note that page 0 is the first page.
         *  @param {bool} [bRedraw=true] Redraw the table or not
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *      oTable.fnPageChange( 'next' );
         *    } );
         */this.fnPageChange=function(mAction,bRedraw){var api=this.api(true).page(mAction);if(bRedraw===undefined||bRedraw){api.draw(false);}};/**
         * Show a particular column
         *  @param {int} iCol The column whose display should be changed
         *  @param {bool} bShow Show (true) or hide (false) the column
         *  @param {bool} [bRedraw=true] Redraw the table or not
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Hide the second column after initialisation
         *      oTable.fnSetColumnVis( 1, false );
         *    } );
         */this.fnSetColumnVis=function(iCol,bShow,bRedraw){var api=this.api(true).column(iCol).visible(bShow);if(bRedraw===undefined||bRedraw){api.columns.adjust().draw();}};/**
         * Get the settings for a particular table for external manipulation
         *  @returns {object} DataTables settings object. See
         *    {@link DataTable.models.oSettings}
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *      var oSettings = oTable.fnSettings();
         *
         *      // Show an example parameter from the settings
         *      alert( oSettings._iDisplayStart );
         *    } );
         */this.fnSettings=function(){return _fnSettingsFromNode(this[_ext.iApiIndex]);};/**
         * Sort the table by a particular column
         *  @param {int} iCol the data index to sort on. Note that this will not match the
         *    'display index' if you have hidden data entries
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Sort immediately with columns 0 and 1
         *      oTable.fnSort( [ [0,'asc'], [1,'asc'] ] );
         *    } );
         */this.fnSort=function(aaSort){this.api(true).order(aaSort).draw();};/**
         * Attach a sort listener to an element for a given column
         *  @param {node} nNode the element to attach the sort listener to
         *  @param {int} iColumn the column that a click on this node will sort on
         *  @param {function} [fnCallback] callback function when sort is run
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *
         *      // Sort on column 1, when 'sorter' is clicked on
         *      oTable.fnSortListener( document.getElementById('sorter'), 1 );
         *    } );
         */this.fnSortListener=function(nNode,iColumn,fnCallback){this.api(true).order.listener(nNode,iColumn,fnCallback);};/**
         * Update a table cell or row - this method will accept either a single value to
         * update the cell with, an array of values with one element for each column or
         * an object in the same format as the original data source. The function is
         * self-referencing in order to make the multi column updates easier.
         *  @param {object|array|string} mData Data to update the cell/row with
         *  @param {node|int} mRow TR element you want to update or the aoData index
         *  @param {int} [iColumn] The column to update, give as null or undefined to
         *    update a whole row.
         *  @param {bool} [bRedraw=true] Redraw the table or not
         *  @param {bool} [bAction=true] Perform pre-draw actions or not
         *  @returns {int} 0 on success, 1 on error
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *      oTable.fnUpdate( 'Example update', 0, 0 ); // Single cell
         *      oTable.fnUpdate( ['a', 'b', 'c', 'd', 'e'], $('tbody tr')[0] ); // Row
         *    } );
         */this.fnUpdate=function(mData,mRow,iColumn,bRedraw,bAction){var api=this.api(true);if(iColumn===undefined||iColumn===null){api.row(mRow).data(mData);}else{api.cell(mRow,iColumn).data(mData);}if(bAction===undefined||bAction){api.columns.adjust();}if(bRedraw===undefined||bRedraw){api.draw();}return 0;};/**
         * Provide a common method for plug-ins to check the version of DataTables being used, in order
         * to ensure compatibility.
         *  @param {string} sVersion Version string to check for, in the format "X.Y.Z". Note that the
         *    formats "X" and "X.Y" are also acceptable.
         *  @returns {boolean} true if this version of DataTables is greater or equal to the required
         *    version, or false if this version of DataTales is not suitable
         *  @method
         *  @dtopt API
         *  @deprecated Since v1.10
         *
         *  @example
         *    $(document).ready(function() {
         *      var oTable = $('#example').dataTable();
         *      alert( oTable.fnVersionCheck( '1.9.0' ) );
         *    } );
         */this.fnVersionCheck=_ext.fnVersionCheck;var _that=this;var emptyInit=options===undefined;var len=this.length;if(emptyInit){options={};}this.oApi=this.internal=_ext.internal;// Extend with old style plug-in API methods
for(var fn in DataTable.ext.internal){if(fn){this[fn]=_fnExternApiFunc(fn);}}this.each(function(){// For each initialisation we want to give it a clean initialisation
// object that can be bashed around
var o={};var oInit=len>1?// optimisation for single table case
_fnExtend(o,options,true):options;/*global oInit,_that,emptyInit*/var i=0,iLen,j,jLen,k,kLen;var sId=this.getAttribute('id');var bInitHandedOff=false;var defaults=DataTable.defaults;var $this=$(this);/* Sanity check */if(this.nodeName.toLowerCase()!='table'){_fnLog(null,0,'Non-table node initialisation ('+this.nodeName+')',2);return;}/* Backwards compatibility for the defaults */_fnCompatOpts(defaults);_fnCompatCols(defaults.column);/* Convert the camel-case defaults to Hungarian */_fnCamelToHungarian(defaults,defaults,true);_fnCamelToHungarian(defaults.column,defaults.column,true);/* Setting up the initialisation object */_fnCamelToHungarian(defaults,$.extend(oInit,$this.data()));/* Check to see if we are re-initialising a table */var allSettings=DataTable.settings;for(i=0,iLen=allSettings.length;i<iLen;i++){var s=allSettings[i];/* Base check on table node */if(s.nTable==this||s.nTHead&&s.nTHead.parentNode==this||s.nTFoot&&s.nTFoot.parentNode==this){var bRetrieve=oInit.bRetrieve!==undefined?oInit.bRetrieve:defaults.bRetrieve;var bDestroy=oInit.bDestroy!==undefined?oInit.bDestroy:defaults.bDestroy;if(emptyInit||bRetrieve){return s.oInstance;}else if(bDestroy){s.oInstance.fnDestroy();break;}else{_fnLog(s,0,'Cannot reinitialise DataTable',3);return;}}/* If the element we are initialising has the same ID as a table which was previously
				 * initialised, but the table nodes don't match (from before) then we destroy the old
				 * instance by simply deleting it. This is under the assumption that the table has been
				 * destroyed by other methods. Anyone using non-id selectors will need to do this manually
				 */if(s.sTableId==this.id){allSettings.splice(i,1);break;}}/* Ensure the table has an ID - required for accessibility */if(sId===null||sId===""){sId="DataTables_Table_"+DataTable.ext._unique++;this.id=sId;}/* Create the settings object for this table and set some of the default parameters */var oSettings=$.extend(true,{},DataTable.models.oSettings,{"sDestroyWidth":$this[0].style.width,"sInstance":sId,"sTableId":sId});oSettings.nTable=this;oSettings.oApi=_that.internal;oSettings.oInit=oInit;allSettings.push(oSettings);// Need to add the instance after the instance after the settings object has been added
// to the settings array, so we can self reference the table instance if more than one
oSettings.oInstance=_that.length===1?_that:$this.dataTable();// Backwards compatibility, before we apply all the defaults
_fnCompatOpts(oInit);_fnLanguageCompat(oInit.oLanguage);// If the length menu is given, but the init display length is not, use the length menu
if(oInit.aLengthMenu&&!oInit.iDisplayLength){oInit.iDisplayLength=$.isArray(oInit.aLengthMenu[0])?oInit.aLengthMenu[0][0]:oInit.aLengthMenu[0];}// Apply the defaults and init options to make a single init object will all
// options defined from defaults and instance options.
oInit=_fnExtend($.extend(true,{},defaults),oInit);// Map the initialisation options onto the settings object
_fnMap(oSettings.oFeatures,oInit,["bPaginate","bLengthChange","bFilter","bSort","bSortMulti","bInfo","bProcessing","bAutoWidth","bSortClasses","bServerSide","bDeferRender"]);_fnMap(oSettings,oInit,["asStripeClasses","ajax","fnServerData","fnFormatNumber","sServerMethod","aaSorting","aaSortingFixed","aLengthMenu","sPaginationType","sAjaxSource","sAjaxDataProp","iStateDuration","sDom","bSortCellsTop","iTabIndex","fnStateLoadCallback","fnStateSaveCallback","renderer","searchDelay","rowId",["iCookieDuration","iStateDuration"],// backwards compat
["oSearch","oPreviousSearch"],["aoSearchCols","aoPreSearchCols"],["iDisplayLength","_iDisplayLength"]]);_fnMap(oSettings.oScroll,oInit,[["sScrollX","sX"],["sScrollXInner","sXInner"],["sScrollY","sY"],["bScrollCollapse","bCollapse"]]);_fnMap(oSettings.oLanguage,oInit,"fnInfoCallback");/* Callback functions which are array driven */_fnCallbackReg(oSettings,'aoDrawCallback',oInit.fnDrawCallback,'user');_fnCallbackReg(oSettings,'aoServerParams',oInit.fnServerParams,'user');_fnCallbackReg(oSettings,'aoStateSaveParams',oInit.fnStateSaveParams,'user');_fnCallbackReg(oSettings,'aoStateLoadParams',oInit.fnStateLoadParams,'user');_fnCallbackReg(oSettings,'aoStateLoaded',oInit.fnStateLoaded,'user');_fnCallbackReg(oSettings,'aoRowCallback',oInit.fnRowCallback,'user');_fnCallbackReg(oSettings,'aoRowCreatedCallback',oInit.fnCreatedRow,'user');_fnCallbackReg(oSettings,'aoHeaderCallback',oInit.fnHeaderCallback,'user');_fnCallbackReg(oSettings,'aoFooterCallback',oInit.fnFooterCallback,'user');_fnCallbackReg(oSettings,'aoInitComplete',oInit.fnInitComplete,'user');_fnCallbackReg(oSettings,'aoPreDrawCallback',oInit.fnPreDrawCallback,'user');oSettings.rowIdFn=_fnGetObjectDataFn(oInit.rowId);/* Browser support detection */_fnBrowserDetect(oSettings);var oClasses=oSettings.oClasses;$.extend(oClasses,DataTable.ext.classes,oInit.oClasses);$this.addClass(oClasses.sTable);if(oSettings.iInitDisplayStart===undefined){/* Display start point, taking into account the save saving */oSettings.iInitDisplayStart=oInit.iDisplayStart;oSettings._iDisplayStart=oInit.iDisplayStart;}if(oInit.iDeferLoading!==null){oSettings.bDeferLoading=true;var tmp=$.isArray(oInit.iDeferLoading);oSettings._iRecordsDisplay=tmp?oInit.iDeferLoading[0]:oInit.iDeferLoading;oSettings._iRecordsTotal=tmp?oInit.iDeferLoading[1]:oInit.iDeferLoading;}/* Language definitions */var oLanguage=oSettings.oLanguage;$.extend(true,oLanguage,oInit.oLanguage);if(oLanguage.sUrl){/* Get the language definitions from a file - because this Ajax call makes the language
				 * get async to the remainder of this function we use bInitHandedOff to indicate that
				 * _fnInitialise will be fired by the returned Ajax handler, rather than the constructor
				 */$.ajax({dataType:'json',url:oLanguage.sUrl,success:function success(json){_fnLanguageCompat(json);_fnCamelToHungarian(defaults.oLanguage,json);$.extend(true,oLanguage,json);_fnInitialise(oSettings);},error:function error(){// Error occurred loading language file, continue on as best we can
_fnInitialise(oSettings);}});bInitHandedOff=true;}/*
			 * Stripes
			 */if(oInit.asStripeClasses===null){oSettings.asStripeClasses=[oClasses.sStripeOdd,oClasses.sStripeEven];}/* Remove row stripe classes if they are already on the table row */var stripeClasses=oSettings.asStripeClasses;var rowOne=$this.children('tbody').find('tr').eq(0);if($.inArray(true,$.map(stripeClasses,function(el,i){return rowOne.hasClass(el);}))!==-1){$('tbody tr',this).removeClass(stripeClasses.join(' '));oSettings.asDestroyStripes=stripeClasses.slice();}/*
			 * Columns
			 * See if we should load columns automatically or use defined ones
			 */var anThs=[];var aoColumnsInit;var nThead=this.getElementsByTagName('thead');if(nThead.length!==0){_fnDetectHeader(oSettings.aoHeader,nThead[0]);anThs=_fnGetUniqueThs(oSettings);}/* If not given a column array, generate one with nulls */if(oInit.aoColumns===null){aoColumnsInit=[];for(i=0,iLen=anThs.length;i<iLen;i++){aoColumnsInit.push(null);}}else{aoColumnsInit=oInit.aoColumns;}/* Add the columns */for(i=0,iLen=aoColumnsInit.length;i<iLen;i++){_fnAddColumn(oSettings,anThs?anThs[i]:null);}/* Apply the column definitions */_fnApplyColumnDefs(oSettings,oInit.aoColumnDefs,aoColumnsInit,function(iCol,oDef){_fnColumnOptions(oSettings,iCol,oDef);});/* HTML5 attribute detection - build an mData object automatically if the
			 * attributes are found
			 */if(rowOne.length){var a=function a(cell,name){return cell.getAttribute('data-'+name)!==null?name:null;};$(rowOne[0]).children('th, td').each(function(i,cell){var col=oSettings.aoColumns[i];if(col.mData===i){var sort=a(cell,'sort')||a(cell,'order');var filter=a(cell,'filter')||a(cell,'search');if(sort!==null||filter!==null){col.mData={_:i+'.display',sort:sort!==null?i+'.@data-'+sort:undefined,type:sort!==null?i+'.@data-'+sort:undefined,filter:filter!==null?i+'.@data-'+filter:undefined};_fnColumnOptions(oSettings,i);}}});}var features=oSettings.oFeatures;var loadedInit=function loadedInit(){/*
				 * Sorting
				 * @todo For modularisation (1.11) this needs to do into a sort start up handler
				 */ // If aaSorting is not defined, then we use the first indicator in asSorting
// in case that has been altered, so the default sort reflects that option
if(oInit.aaSorting===undefined){var sorting=oSettings.aaSorting;for(i=0,iLen=sorting.length;i<iLen;i++){sorting[i][1]=oSettings.aoColumns[i].asSorting[0];}}/* Do a first pass on the sorting classes (allows any size changes to be taken into
				 * account, and also will apply sorting disabled classes if disabled
				 */_fnSortingClasses(oSettings);if(features.bSort){_fnCallbackReg(oSettings,'aoDrawCallback',function(){if(oSettings.bSorted){var aSort=_fnSortFlatten(oSettings);var sortedColumns={};$.each(aSort,function(i,val){sortedColumns[val.src]=val.dir;});_fnCallbackFire(oSettings,null,'order',[oSettings,aSort,sortedColumns]);_fnSortAria(oSettings);}});}_fnCallbackReg(oSettings,'aoDrawCallback',function(){if(oSettings.bSorted||_fnDataSource(oSettings)==='ssp'||features.bDeferRender){_fnSortingClasses(oSettings);}},'sc');/*
				 * Final init
				 * Cache the header, body and footer as required, creating them if needed
				 */ // Work around for Webkit bug 83867 - store the caption-side before removing from doc
var captions=$this.children('caption').each(function(){this._captionSide=$(this).css('caption-side');});var thead=$this.children('thead');if(thead.length===0){thead=$('<thead/>').appendTo($this);}oSettings.nTHead=thead[0];var tbody=$this.children('tbody');if(tbody.length===0){tbody=$('<tbody/>').appendTo($this);}oSettings.nTBody=tbody[0];var tfoot=$this.children('tfoot');if(tfoot.length===0&&captions.length>0&&(oSettings.oScroll.sX!==""||oSettings.oScroll.sY!=="")){// If we are a scrolling table, and no footer has been given, then we need to create
// a tfoot element for the caption element to be appended to
tfoot=$('<tfoot/>').appendTo($this);}if(tfoot.length===0||tfoot.children().length===0){$this.addClass(oClasses.sNoFooter);}else if(tfoot.length>0){oSettings.nTFoot=tfoot[0];_fnDetectHeader(oSettings.aoFooter,oSettings.nTFoot);}/* Check if there is data passing into the constructor */if(oInit.aaData){for(i=0;i<oInit.aaData.length;i++){_fnAddData(oSettings,oInit.aaData[i]);}}else if(oSettings.bDeferLoading||_fnDataSource(oSettings)=='dom'){/* Grab the data from the page - only do this when deferred loading or no Ajax
					 * source since there is no point in reading the DOM data if we are then going
					 * to replace it with Ajax data
					 */_fnAddTr(oSettings,$(oSettings.nTBody).children('tr'));}/* Copy the data index array */oSettings.aiDisplay=oSettings.aiDisplayMaster.slice();/* Initialisation complete - table can be drawn */oSettings.bInitialised=true;/* Check if we need to initialise the table (it might not have been handed off to the
				 * language processor)
				 */if(bInitHandedOff===false){_fnInitialise(oSettings);}};/* Must be done after everything which can be overridden by the state saving! */if(oInit.bStateSave){features.bStateSave=true;_fnCallbackReg(oSettings,'aoDrawCallback',_fnSaveState,'state_save');_fnLoadState(oSettings,oInit,loadedInit);}else{loadedInit();}});_that=null;return this;};/*
	 * It is useful to have variables which are scoped locally so only the
	 * DataTables functions can access them and they don't leak into global space.
	 * At the same time these functions are often useful over multiple files in the
	 * core and API, so we list, or at least document, all variables which are used
	 * by DataTables as private variables here. This also ensures that there is no
	 * clashing of variable names and that they can easily referenced for reuse.
	 */ // Defined else where
//  _selector_run
//  _selector_opts
//  _selector_first
//  _selector_row_indexes
var _ext;// DataTable.ext
var _Api2;// DataTable.Api
var _api_register;// DataTable.Api.register
var _api_registerPlural;// DataTable.Api.registerPlural
var _re_dic={};var _re_new_lines=/[\r\n]/g;var _re_html=/<.*?>/g;// This is not strict ISO8601 - Date.parse() is quite lax, although
// implementations differ between browsers.
var _re_date=/^\d{2,4}[\.\/\-]\d{1,2}[\.\/\-]\d{1,2}([T ]{1}\d{1,2}[:\.]\d{2}([\.:]\d{2})?)?$/;// Escape regular expression special characters
var _re_escape_regex=new RegExp('(\\'+['/','.','*','+','?','|','(',')','[',']','{','}','\\','$','^','-'].join('|\\')+')','g');// http://en.wikipedia.org/wiki/Foreign_exchange_market
// - \u20BD - Russian ruble.
// - \u20a9 - South Korean Won
// - \u20BA - Turkish Lira
// - \u20B9 - Indian Rupee
// - R - Brazil (R$) and South Africa
// - fr - Swiss Franc
// - kr - Swedish krona, Norwegian krone and Danish krone
// - \u2009 is thin space and \u202F is narrow no-break space, both used in many
// - Ƀ - Bitcoin
// - Ξ - Ethereum
//   standards as thousands separators.
var _re_formatted_numeric=/[',$£€¥%\u2009\u202F\u20BD\u20a9\u20BArfkɃΞ]/gi;var _empty=function _empty(d){return!d||d===true||d==='-'?true:false;};var _intVal=function _intVal(s){var integer=parseInt(s,10);return!isNaN(integer)&&isFinite(s)?integer:null;};// Convert from a formatted number with characters other than `.` as the
// decimal place, to a Javascript number
var _numToDecimal=function _numToDecimal(num,decimalPoint){// Cache created regular expressions for speed as this function is called often
if(!_re_dic[decimalPoint]){_re_dic[decimalPoint]=new RegExp(_fnEscapeRegex(decimalPoint),'g');}return typeof num==='string'&&decimalPoint!=='.'?num.replace(/\./g,'').replace(_re_dic[decimalPoint],'.'):num;};var _isNumber=function _isNumber(d,decimalPoint,formatted){var strType=typeof d==='string';// If empty return immediately so there must be a number if it is a
// formatted string (this stops the string "k", or "kr", etc being detected
// as a formatted number for currency
if(_empty(d)){return true;}if(decimalPoint&&strType){d=_numToDecimal(d,decimalPoint);}if(formatted&&strType){d=d.replace(_re_formatted_numeric,'');}return!isNaN(parseFloat(d))&&isFinite(d);};// A string without HTML in it can be considered to be HTML still
var _isHtml=function _isHtml(d){return _empty(d)||typeof d==='string';};var _htmlNumeric=function _htmlNumeric(d,decimalPoint,formatted){if(_empty(d)){return true;}var html=_isHtml(d);return!html?null:_isNumber(_stripHtml(d),decimalPoint,formatted)?true:null;};var _pluck=function _pluck(a,prop,prop2){var out=[];var i=0,ien=a.length;// Could have the test in the loop for slightly smaller code, but speed
// is essential here
if(prop2!==undefined){for(;i<ien;i++){if(a[i]&&a[i][prop]){out.push(a[i][prop][prop2]);}}}else{for(;i<ien;i++){if(a[i]){out.push(a[i][prop]);}}}return out;};// Basically the same as _pluck, but rather than looping over `a` we use `order`
// as the indexes to pick from `a`
var _pluck_order=function _pluck_order(a,order,prop,prop2){var out=[];var i=0,ien=order.length;// Could have the test in the loop for slightly smaller code, but speed
// is essential here
if(prop2!==undefined){for(;i<ien;i++){if(a[order[i]][prop]){out.push(a[order[i]][prop][prop2]);}}}else{for(;i<ien;i++){out.push(a[order[i]][prop]);}}return out;};var _range=function _range(len,start){var out=[];var end;if(start===undefined){start=0;end=len;}else{end=start;start=len;}for(var i=start;i<end;i++){out.push(i);}return out;};var _removeEmpty=function _removeEmpty(a){var out=[];for(var i=0,ien=a.length;i<ien;i++){if(a[i]){// careful - will remove all falsy values!
out.push(a[i]);}}return out;};var _stripHtml=function _stripHtml(d){return d.replace(_re_html,'');};/**
     * Determine if all values in the array are unique. This means we can short
     * cut the _unique method at the cost of a single loop. A sorted array is used
     * to easily check the values.
     *
     * @param  {array} src Source array
     * @return {boolean} true if all unique, false otherwise
     * @ignore
     */var _areAllUnique=function _areAllUnique(src){if(src.length<2){return true;}var sorted=src.slice().sort();var last=sorted[0];for(var i=1,ien=sorted.length;i<ien;i++){if(sorted[i]===last){return false;}last=sorted[i];}return true;};/**
     * Find the unique elements in a source array.
     *
     * @param  {array} src Source array
     * @return {array} Array of unique items
     * @ignore
     */var _unique=function _unique(src){if(_areAllUnique(src)){return src.slice();}// A faster unique method is to use object keys to identify used values,
// but this doesn't work with arrays or objects, which we must also
// consider. See jsperf.com/compare-array-unique-versions/4 for more
// information.
var out=[],val,i,ien=src.length,j,k=0;again:for(i=0;i<ien;i++){val=src[i];for(j=0;j<k;j++){if(out[j]===val){continue again;}}out.push(val);k++;}return out;};/**
     * DataTables utility methods
     *
     * This namespace provides helper methods that DataTables uses internally to
     * create a DataTable, but which are not exclusively used only for DataTables.
     * These methods can be used by extension authors to save the duplication of
     * code.
     *
     *  @namespace
     */DataTable.util={/**
         * Throttle the calls to a function. Arguments and context are maintained
         * for the throttled function.
         *
         * @param {function} fn Function to be called
         * @param {integer} freq Call frequency in mS
         * @return {function} Wrapped function
         */throttle:function throttle(fn,freq){var frequency=freq!==undefined?freq:200,last,timer;return function(){var that=this,now=+new Date(),args=arguments;if(last&&now<last+frequency){clearTimeout(timer);timer=setTimeout(function(){last=undefined;fn.apply(that,args);},frequency);}else{last=now;fn.apply(that,args);}};},/**
         * Escape a string such that it can be used in a regular expression
         *
         *  @param {string} val string to escape
         *  @returns {string} escaped string
         */escapeRegex:function escapeRegex(val){return val.replace(_re_escape_regex,'\\$1');}};/**
     * Create a mapping object that allows camel case parameters to be looked up
     * for their Hungarian counterparts. The mapping is stored in a private
     * parameter called `_hungarianMap` which can be accessed on the source object.
     *  @param {object} o
     *  @memberof DataTable#oApi
     */function _fnHungarianMap(o){var hungarian='a aa ai ao as b fn i m o s ',match,newKey,map={};$.each(o,function(key,val){match=key.match(/^([^A-Z]+?)([A-Z])/);if(match&&hungarian.indexOf(match[1]+' ')!==-1){newKey=key.replace(match[0],match[2].toLowerCase());map[newKey]=key;if(match[1]==='o'){_fnHungarianMap(o[key]);}}});o._hungarianMap=map;}/**
     * Convert from camel case parameters to Hungarian, based on a Hungarian map
     * created by _fnHungarianMap.
     *  @param {object} src The model object which holds all parameters that can be
     *    mapped.
     *  @param {object} user The object to convert from camel case to Hungarian.
     *  @param {boolean} force When set to `true`, properties which already have a
     *    Hungarian value in the `user` object will be overwritten. Otherwise they
     *    won't be.
     *  @memberof DataTable#oApi
     */function _fnCamelToHungarian(src,user,force){if(!src._hungarianMap){_fnHungarianMap(src);}var hungarianKey;$.each(user,function(key,val){hungarianKey=src._hungarianMap[key];if(hungarianKey!==undefined&&(force||user[hungarianKey]===undefined)){// For objects, we need to buzz down into the object to copy parameters
if(hungarianKey.charAt(0)==='o'){// Copy the camelCase options over to the hungarian
if(!user[hungarianKey]){user[hungarianKey]={};}$.extend(true,user[hungarianKey],user[key]);_fnCamelToHungarian(src[hungarianKey],user[hungarianKey],force);}else{user[hungarianKey]=user[key];}}});}/**
     * Language compatibility - when certain options are given, and others aren't, we
     * need to duplicate the values over, in order to provide backwards compatibility
     * with older language files.
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnLanguageCompat(lang){// Note the use of the Hungarian notation for the parameters in this method as
// this is called after the mapping of camelCase to Hungarian
var defaults=DataTable.defaults.oLanguage;// Default mapping
var defaultDecimal=defaults.sDecimal;if(defaultDecimal){_addNumericSort(defaultDecimal);}if(lang){var zeroRecords=lang.sZeroRecords;// Backwards compatibility - if there is no sEmptyTable given, then use the same as
// sZeroRecords - assuming that is given.
if(!lang.sEmptyTable&&zeroRecords&&defaults.sEmptyTable==="No data available in table"){_fnMap(lang,lang,'sZeroRecords','sEmptyTable');}// Likewise with loading records
if(!lang.sLoadingRecords&&zeroRecords&&defaults.sLoadingRecords==="Loading..."){_fnMap(lang,lang,'sZeroRecords','sLoadingRecords');}// Old parameter name of the thousands separator mapped onto the new
if(lang.sInfoThousands){lang.sThousands=lang.sInfoThousands;}var decimal=lang.sDecimal;if(decimal&&defaultDecimal!==decimal){_addNumericSort(decimal);}}}/**
     * Map one parameter onto another
     *  @param {object} o Object to map
     *  @param {*} knew The new parameter name
     *  @param {*} old The old parameter name
     */var _fnCompatMap=function _fnCompatMap(o,knew,old){if(o[knew]!==undefined){o[old]=o[knew];}};/**
     * Provide backwards compatibility for the main DT options. Note that the new
     * options are mapped onto the old parameters, so this is an external interface
     * change only.
     *  @param {object} init Object to map
     */function _fnCompatOpts(init){_fnCompatMap(init,'ordering','bSort');_fnCompatMap(init,'orderMulti','bSortMulti');_fnCompatMap(init,'orderClasses','bSortClasses');_fnCompatMap(init,'orderCellsTop','bSortCellsTop');_fnCompatMap(init,'order','aaSorting');_fnCompatMap(init,'orderFixed','aaSortingFixed');_fnCompatMap(init,'paging','bPaginate');_fnCompatMap(init,'pagingType','sPaginationType');_fnCompatMap(init,'pageLength','iDisplayLength');_fnCompatMap(init,'searching','bFilter');// Boolean initialisation of x-scrolling
if(typeof init.sScrollX==='boolean'){init.sScrollX=init.sScrollX?'100%':'';}if(typeof init.scrollX==='boolean'){init.scrollX=init.scrollX?'100%':'';}// Column search objects are in an array, so it needs to be converted
// element by element
var searchCols=init.aoSearchCols;if(searchCols){for(var i=0,ien=searchCols.length;i<ien;i++){if(searchCols[i]){_fnCamelToHungarian(DataTable.models.oSearch,searchCols[i]);}}}}/**
     * Provide backwards compatibility for column options. Note that the new options
     * are mapped onto the old parameters, so this is an external interface change
     * only.
     *  @param {object} init Object to map
     */function _fnCompatCols(init){_fnCompatMap(init,'orderable','bSortable');_fnCompatMap(init,'orderData','aDataSort');_fnCompatMap(init,'orderSequence','asSorting');_fnCompatMap(init,'orderDataType','sortDataType');// orderData can be given as an integer
var dataSort=init.aDataSort;if(typeof dataSort==='number'&&!$.isArray(dataSort)){init.aDataSort=[dataSort];}}/**
     * Browser feature detection for capabilities, quirks
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnBrowserDetect(settings){// We don't need to do this every time DataTables is constructed, the values
// calculated are specific to the browser and OS configuration which we
// don't expect to change between initialisations
if(!DataTable.__browser){var browser={};DataTable.__browser=browser;// Scrolling feature / quirks detection
var n=$('<div/>').css({position:'fixed',top:0,left:$(window).scrollLeft()*-1,// allow for scrolling
height:1,width:1,overflow:'hidden'}).append($('<div/>').css({position:'absolute',top:1,left:1,width:100,overflow:'scroll'}).append($('<div/>').css({width:'100%',height:10}))).appendTo('body');var outer=n.children();var inner=outer.children();// Numbers below, in order, are:
// inner.offsetWidth, inner.clientWidth, outer.offsetWidth, outer.clientWidth
//
// IE6 XP:                           100 100 100  83
// IE7 Vista:                        100 100 100  83
// IE 8+ Windows:                     83  83 100  83
// Evergreen Windows:                 83  83 100  83
// Evergreen Mac with scrollbars:     85  85 100  85
// Evergreen Mac without scrollbars: 100 100 100 100
// Get scrollbar width
browser.barWidth=outer[0].offsetWidth-outer[0].clientWidth;// IE6/7 will oversize a width 100% element inside a scrolling element, to
// include the width of the scrollbar, while other browsers ensure the inner
// element is contained without forcing scrolling
browser.bScrollOversize=inner[0].offsetWidth===100&&outer[0].clientWidth!==100;// In rtl text layout, some browsers (most, but not all) will place the
// scrollbar on the left, rather than the right.
browser.bScrollbarLeft=Math.round(inner.offset().left)!==1;// IE8- don't provide height and width for getBoundingClientRect
browser.bBounding=n[0].getBoundingClientRect().width?true:false;n.remove();}$.extend(settings.oBrowser,DataTable.__browser);settings.oScroll.iBarWidth=DataTable.__browser.barWidth;}/**
     * Array.prototype reduce[Right] method, used for browsers which don't support
     * JS 1.6. Done this way to reduce code size, since we iterate either way
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnReduce(that,fn,init,start,end,inc){var i=start,value,isSet=false;if(init!==undefined){value=init;isSet=true;}while(i!==end){if(!that.hasOwnProperty(i)){continue;}value=isSet?fn(value,that[i],i,that):that[i];isSet=true;i+=inc;}return value;}/**
     * Add a column to the list used for the table with default values
     *  @param {object} oSettings dataTables settings object
     *  @param {node} nTh The th element for this column
     *  @memberof DataTable#oApi
     */function _fnAddColumn(oSettings,nTh){// Add column to aoColumns array
var oDefaults=DataTable.defaults.column;var iCol=oSettings.aoColumns.length;var oCol=$.extend({},DataTable.models.oColumn,oDefaults,{"nTh":nTh?nTh:document.createElement('th'),"sTitle":oDefaults.sTitle?oDefaults.sTitle:nTh?nTh.innerHTML:'',"aDataSort":oDefaults.aDataSort?oDefaults.aDataSort:[iCol],"mData":oDefaults.mData?oDefaults.mData:iCol,idx:iCol});oSettings.aoColumns.push(oCol);// Add search object for column specific search. Note that the `searchCols[ iCol ]`
// passed into extend can be undefined. This allows the user to give a default
// with only some of the parameters defined, and also not give a default
var searchCols=oSettings.aoPreSearchCols;searchCols[iCol]=$.extend({},DataTable.models.oSearch,searchCols[iCol]);// Use the default column options function to initialise classes etc
_fnColumnOptions(oSettings,iCol,$(nTh).data());}/**
     * Apply options for a column
     *  @param {object} oSettings dataTables settings object
     *  @param {int} iCol column index to consider
     *  @param {object} oOptions object with sType, bVisible and bSearchable etc
     *  @memberof DataTable#oApi
     */function _fnColumnOptions(oSettings,iCol,oOptions){var oCol=oSettings.aoColumns[iCol];var oClasses=oSettings.oClasses;var th=$(oCol.nTh);// Try to get width information from the DOM. We can't get it from CSS
// as we'd need to parse the CSS stylesheet. `width` option can override
if(!oCol.sWidthOrig){// Width attribute
oCol.sWidthOrig=th.attr('width')||null;// Style attribute
var t=(th.attr('style')||'').match(/width:\s*(\d+[pxem%]+)/);if(t){oCol.sWidthOrig=t[1];}}/* User specified column options */if(oOptions!==undefined&&oOptions!==null){// Backwards compatibility
_fnCompatCols(oOptions);// Map camel case parameters to their Hungarian counterparts
_fnCamelToHungarian(DataTable.defaults.column,oOptions);/* Backwards compatibility for mDataProp */if(oOptions.mDataProp!==undefined&&!oOptions.mData){oOptions.mData=oOptions.mDataProp;}if(oOptions.sType){oCol._sManualType=oOptions.sType;}// `class` is a reserved word in Javascript, so we need to provide
// the ability to use a valid name for the camel case input
if(oOptions.className&&!oOptions.sClass){oOptions.sClass=oOptions.className;}if(oOptions.sClass){th.addClass(oOptions.sClass);}$.extend(oCol,oOptions);_fnMap(oCol,oOptions,"sWidth","sWidthOrig");/* iDataSort to be applied (backwards compatibility), but aDataSort will take
			 * priority if defined
			 */if(oOptions.iDataSort!==undefined){oCol.aDataSort=[oOptions.iDataSort];}_fnMap(oCol,oOptions,"aDataSort");}/* Cache the data get and set functions for speed */var mDataSrc=oCol.mData;var mData=_fnGetObjectDataFn(mDataSrc);var mRender=oCol.mRender?_fnGetObjectDataFn(oCol.mRender):null;var attrTest=function attrTest(src){return typeof src==='string'&&src.indexOf('@')!==-1;};oCol._bAttrSrc=$.isPlainObject(mDataSrc)&&(attrTest(mDataSrc.sort)||attrTest(mDataSrc.type)||attrTest(mDataSrc.filter));oCol._setter=null;oCol.fnGetData=function(rowData,type,meta){var innerData=mData(rowData,type,undefined,meta);return mRender&&type?mRender(innerData,type,rowData,meta):innerData;};oCol.fnSetData=function(rowData,val,meta){return _fnSetObjectDataFn(mDataSrc)(rowData,val,meta);};// Indicate if DataTables should read DOM data as an object or array
// Used in _fnGetRowElements
if(typeof mDataSrc!=='number'){oSettings._rowReadObject=true;}/* Feature sorting overrides column specific when off */if(!oSettings.oFeatures.bSort){oCol.bSortable=false;th.addClass(oClasses.sSortableNone);// Have to add class here as order event isn't called
}/* Check that the class assignment is correct for sorting */var bAsc=$.inArray('asc',oCol.asSorting)!==-1;var bDesc=$.inArray('desc',oCol.asSorting)!==-1;if(!oCol.bSortable||!bAsc&&!bDesc){oCol.sSortingClass=oClasses.sSortableNone;oCol.sSortingClassJUI="";}else if(bAsc&&!bDesc){oCol.sSortingClass=oClasses.sSortableAsc;oCol.sSortingClassJUI=oClasses.sSortJUIAscAllowed;}else if(!bAsc&&bDesc){oCol.sSortingClass=oClasses.sSortableDesc;oCol.sSortingClassJUI=oClasses.sSortJUIDescAllowed;}else{oCol.sSortingClass=oClasses.sSortable;oCol.sSortingClassJUI=oClasses.sSortJUI;}}/**
     * Adjust the table column widths for new data. Note: you would probably want to
     * do a redraw after calling this function!
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnAdjustColumnSizing(settings){/* Not interested in doing column width calculation if auto-width is disabled */if(settings.oFeatures.bAutoWidth!==false){var columns=settings.aoColumns;_fnCalculateColumnWidths(settings);for(var i=0,iLen=columns.length;i<iLen;i++){columns[i].nTh.style.width=columns[i].sWidth;}}var scroll=settings.oScroll;if(scroll.sY!==''||scroll.sX!==''){_fnScrollDraw(settings);}_fnCallbackFire(settings,null,'column-sizing',[settings]);}/**
     * Covert the index of a visible column to the index in the data array (take account
     * of hidden columns)
     *  @param {object} oSettings dataTables settings object
     *  @param {int} iMatch Visible column index to lookup
     *  @returns {int} i the data index
     *  @memberof DataTable#oApi
     */function _fnVisibleToColumnIndex(oSettings,iMatch){var aiVis=_fnGetColumns(oSettings,'bVisible');return typeof aiVis[iMatch]==='number'?aiVis[iMatch]:null;}/**
     * Covert the index of an index in the data array and convert it to the visible
     *   column index (take account of hidden columns)
     *  @param {int} iMatch Column index to lookup
     *  @param {object} oSettings dataTables settings object
     *  @returns {int} i the data index
     *  @memberof DataTable#oApi
     */function _fnColumnIndexToVisible(oSettings,iMatch){var aiVis=_fnGetColumns(oSettings,'bVisible');var iPos=$.inArray(iMatch,aiVis);return iPos!==-1?iPos:null;}/**
     * Get the number of visible columns
     *  @param {object} oSettings dataTables settings object
     *  @returns {int} i the number of visible columns
     *  @memberof DataTable#oApi
     */function _fnVisbleColumns(oSettings){var vis=0;// No reduce in IE8, use a loop for now
$.each(oSettings.aoColumns,function(i,col){if(col.bVisible&&$(col.nTh).css('display')!=='none'){vis++;}});return vis;}/**
     * Get an array of column indexes that match a given property
     *  @param {object} oSettings dataTables settings object
     *  @param {string} sParam Parameter in aoColumns to look for - typically
     *    bVisible or bSearchable
     *  @returns {array} Array of indexes with matched properties
     *  @memberof DataTable#oApi
     */function _fnGetColumns(oSettings,sParam){var a=[];$.map(oSettings.aoColumns,function(val,i){if(val[sParam]){a.push(i);}});return a;}/**
     * Calculate the 'type' of a column
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnColumnTypes(settings){var columns=settings.aoColumns;var data=settings.aoData;var types=DataTable.ext.type.detect;var i,ien,j,jen,k,ken;var col,cell,detectedType,cache;// For each column, spin over the
for(i=0,ien=columns.length;i<ien;i++){col=columns[i];cache=[];if(!col.sType&&col._sManualType){col.sType=col._sManualType;}else if(!col.sType){for(j=0,jen=types.length;j<jen;j++){for(k=0,ken=data.length;k<ken;k++){// Use a cache array so we only need to get the type data
// from the formatter once (when using multiple detectors)
if(cache[k]===undefined){cache[k]=_fnGetCellData(settings,k,i,'type');}detectedType=types[j](cache[k],settings);// If null, then this type can't apply to this column, so
// rather than testing all cells, break out. There is an
// exception for the last type which is `html`. We need to
// scan all rows since it is possible to mix string and HTML
// types
if(!detectedType&&j!==types.length-1){break;}// Only a single match is needed for html type since it is
// bottom of the pile and very similar to string
if(detectedType==='html'){break;}}// Type is valid for all data points in the column - use this
// type
if(detectedType){col.sType=detectedType;break;}}// Fall back - if no type was detected, always use string
if(!col.sType){col.sType='string';}}}}/**
     * Take the column definitions and static columns arrays and calculate how
     * they relate to column indexes. The callback function will then apply the
     * definition found for a column to a suitable configuration object.
     *  @param {object} oSettings dataTables settings object
     *  @param {array} aoColDefs The aoColumnDefs array that is to be applied
     *  @param {array} aoCols The aoColumns array that defines columns individually
     *  @param {function} fn Callback function - takes two parameters, the calculated
     *    column index and the definition for that column.
     *  @memberof DataTable#oApi
     */function _fnApplyColumnDefs(oSettings,aoColDefs,aoCols,fn){var i,iLen,j,jLen,k,kLen,def;var columns=oSettings.aoColumns;// Column definitions with aTargets
if(aoColDefs){/* Loop over the definitions array - loop in reverse so first instance has priority */for(i=aoColDefs.length-1;i>=0;i--){def=aoColDefs[i];/* Each definition can target multiple columns, as it is an array */var aTargets=def.targets!==undefined?def.targets:def.aTargets;if(!$.isArray(aTargets)){aTargets=[aTargets];}for(j=0,jLen=aTargets.length;j<jLen;j++){if(typeof aTargets[j]==='number'&&aTargets[j]>=0){/* Add columns that we don't yet know about */while(columns.length<=aTargets[j]){_fnAddColumn(oSettings);}/* Integer, basic index */fn(aTargets[j],def);}else if(typeof aTargets[j]==='number'&&aTargets[j]<0){/* Negative integer, right to left column counting */fn(columns.length+aTargets[j],def);}else if(typeof aTargets[j]==='string'){/* Class name matching on TH element */for(k=0,kLen=columns.length;k<kLen;k++){if(aTargets[j]=="_all"||$(columns[k].nTh).hasClass(aTargets[j])){fn(k,def);}}}}}}// Statically defined columns array
if(aoCols){for(i=0,iLen=aoCols.length;i<iLen;i++){fn(i,aoCols[i]);}}}/**
     * Add a data array to the table, creating DOM node etc. This is the parallel to
     * _fnGatherData, but for adding rows from a Javascript source, rather than a
     * DOM source.
     *  @param {object} oSettings dataTables settings object
     *  @param {array} aData data array to be added
     *  @param {node} [nTr] TR element to add to the table - optional. If not given,
     *    DataTables will create a row automatically
     *  @param {array} [anTds] Array of TD|TH elements for the row - must be given
     *    if nTr is.
     *  @returns {int} >=0 if successful (index of new aoData entry), -1 if failed
     *  @memberof DataTable#oApi
     */function _fnAddData(oSettings,aDataIn,nTr,anTds){/* Create the object for storing information about this new row */var iRow=oSettings.aoData.length;var oData=$.extend(true,{},DataTable.models.oRow,{src:nTr?'dom':'data',idx:iRow});oData._aData=aDataIn;oSettings.aoData.push(oData);/* Create the cells */var nTd,sThisType;var columns=oSettings.aoColumns;// Invalidate the column types as the new data needs to be revalidated
for(var i=0,iLen=columns.length;i<iLen;i++){columns[i].sType=null;}/* Add to the display array */oSettings.aiDisplayMaster.push(iRow);var id=oSettings.rowIdFn(aDataIn);if(id!==undefined){oSettings.aIds[id]=oData;}/* Create the DOM information, or register it if already present */if(nTr||!oSettings.oFeatures.bDeferRender){_fnCreateTr(oSettings,iRow,nTr,anTds);}return iRow;}/**
     * Add one or more TR elements to the table. Generally we'd expect to
     * use this for reading data from a DOM sourced table, but it could be
     * used for an TR element. Note that if a TR is given, it is used (i.e.
     * it is not cloned).
     *  @param {object} settings dataTables settings object
     *  @param {array|node|jQuery} trs The TR element(s) to add to the table
     *  @returns {array} Array of indexes for the added rows
     *  @memberof DataTable#oApi
     */function _fnAddTr(settings,trs){var row;// Allow an individual node to be passed in
if(!(trs instanceof $)){trs=$(trs);}return trs.map(function(i,el){row=_fnGetRowElements(settings,el);return _fnAddData(settings,row.data,el,row.cells);});}/**
     * Take a TR element and convert it to an index in aoData
     *  @param {object} oSettings dataTables settings object
     *  @param {node} n the TR element to find
     *  @returns {int} index if the node is found, null if not
     *  @memberof DataTable#oApi
     */function _fnNodeToDataIndex(oSettings,n){return n._DT_RowIndex!==undefined?n._DT_RowIndex:null;}/**
     * Take a TD element and convert it into a column data index (not the visible index)
     *  @param {object} oSettings dataTables settings object
     *  @param {int} iRow The row number the TD/TH can be found in
     *  @param {node} n The TD/TH element to find
     *  @returns {int} index if the node is found, -1 if not
     *  @memberof DataTable#oApi
     */function _fnNodeToColumnIndex(oSettings,iRow,n){return $.inArray(n,oSettings.aoData[iRow].anCells);}/**
     * Get the data for a given cell from the internal cache, taking into account data mapping
     *  @param {object} settings dataTables settings object
     *  @param {int} rowIdx aoData row id
     *  @param {int} colIdx Column index
     *  @param {string} type data get type ('display', 'type' 'filter' 'sort')
     *  @returns {*} Cell data
     *  @memberof DataTable#oApi
     */function _fnGetCellData(settings,rowIdx,colIdx,type){var draw=settings.iDraw;var col=settings.aoColumns[colIdx];var rowData=settings.aoData[rowIdx]._aData;var defaultContent=col.sDefaultContent;var cellData=col.fnGetData(rowData,type,{settings:settings,row:rowIdx,col:colIdx});if(cellData===undefined){if(settings.iDrawError!=draw&&defaultContent===null){_fnLog(settings,0,"Requested unknown parameter "+(typeof col.mData=='function'?'{function}':"'"+col.mData+"'")+" for row "+rowIdx+", column "+colIdx,4);settings.iDrawError=draw;}return defaultContent;}// When the data source is null and a specific data type is requested (i.e.
// not the original data), we can use default column data
if((cellData===rowData||cellData===null)&&defaultContent!==null&&type!==undefined){cellData=defaultContent;}else if(typeof cellData==='function'){// If the data source is a function, then we run it and use the return,
// executing in the scope of the data object (for instances)
return cellData.call(rowData);}if(cellData===null&&type=='display'){return'';}return cellData;}/**
     * Set the value for a specific cell, into the internal data cache
     *  @param {object} settings dataTables settings object
     *  @param {int} rowIdx aoData row id
     *  @param {int} colIdx Column index
     *  @param {*} val Value to set
     *  @memberof DataTable#oApi
     */function _fnSetCellData(settings,rowIdx,colIdx,val){var col=settings.aoColumns[colIdx];var rowData=settings.aoData[rowIdx]._aData;col.fnSetData(rowData,val,{settings:settings,row:rowIdx,col:colIdx});}// Private variable that is used to match action syntax in the data property object
var __reArray=/\[.*?\]$/;var __reFn=/\(\)$/;/**
     * Split string on periods, taking into account escaped periods
     * @param  {string} str String to split
     * @return {array} Split string
     */function _fnSplitObjNotation(str){return $.map(str.match(/(\\.|[^\.])+/g)||[''],function(s){return s.replace(/\\\./g,'.');});}/**
     * Return a function that can be used to get data from a source object, taking
     * into account the ability to use nested objects as a source
     *  @param {string|int|function} mSource The data source for the object
     *  @returns {function} Data get function
     *  @memberof DataTable#oApi
     */function _fnGetObjectDataFn(mSource){if($.isPlainObject(mSource)){/* Build an object of get functions, and wrap them in a single call */var o={};$.each(mSource,function(key,val){if(val){o[key]=_fnGetObjectDataFn(val);}});return function(data,type,row,meta){var t=o[type]||o._;return t!==undefined?t(data,type,row,meta):data;};}else if(mSource===null){/* Give an empty string for rendering / sorting etc */return function(data){// type, row and meta also passed, but not used
return data;};}else if(typeof mSource==='function'){return function(data,type,row,meta){return mSource(data,type,row,meta);};}else if(typeof mSource==='string'&&(mSource.indexOf('.')!==-1||mSource.indexOf('[')!==-1||mSource.indexOf('(')!==-1)){/* If there is a . in the source string then the data source is in a
			 * nested object so we loop over the data for each level to get the next
			 * level down. On each loop we test for undefined, and if found immediately
			 * return. This allows entire objects to be missing and sDefaultContent to
			 * be used if defined, rather than throwing an error
			 */var fetchData=function fetchData(data,type,src){var arrayNotation,funcNotation,out,innerSrc;if(src!==""){var a=_fnSplitObjNotation(src);for(var i=0,iLen=a.length;i<iLen;i++){// Check if we are dealing with special notation
arrayNotation=a[i].match(__reArray);funcNotation=a[i].match(__reFn);if(arrayNotation){// Array notation
a[i]=a[i].replace(__reArray,'');// Condition allows simply [] to be passed in
if(a[i]!==""){data=data[a[i]];}out=[];// Get the remainder of the nested object to get
a.splice(0,i+1);innerSrc=a.join('.');// Traverse each entry in the array getting the properties requested
if($.isArray(data)){for(var j=0,jLen=data.length;j<jLen;j++){out.push(fetchData(data[j],type,innerSrc));}}// If a string is given in between the array notation indicators, that
// is used to join the strings together, otherwise an array is returned
var join=arrayNotation[0].substring(1,arrayNotation[0].length-1);data=join===""?out:out.join(join);// The inner call to fetchData has already traversed through the remainder
// of the source requested, so we exit from the loop
break;}else if(funcNotation){// Function call
a[i]=a[i].replace(__reFn,'');data=data[a[i]]();continue;}if(data===null||data[a[i]]===undefined){return undefined;}data=data[a[i]];}}return data;};return function(data,type){// row and meta also passed, but not used
return fetchData(data,type,mSource);};}else{/* Array or flat object mapping */return function(data,type){// row and meta also passed, but not used
return data[mSource];};}}/**
     * Return a function that can be used to set data from a source object, taking
     * into account the ability to use nested objects as a source
     *  @param {string|int|function} mSource The data source for the object
     *  @returns {function} Data set function
     *  @memberof DataTable#oApi
     */function _fnSetObjectDataFn(mSource){if($.isPlainObject(mSource)){/* Unlike get, only the underscore (global) option is used for for
			 * setting data since we don't know the type here. This is why an object
			 * option is not documented for `mData` (which is read/write), but it is
			 * for `mRender` which is read only.
			 */return _fnSetObjectDataFn(mSource._);}else if(mSource===null){/* Nothing to do when the data source is null */return function(){};}else if(typeof mSource==='function'){return function(data,val,meta){mSource(data,'set',val,meta);};}else if(typeof mSource==='string'&&(mSource.indexOf('.')!==-1||mSource.indexOf('[')!==-1||mSource.indexOf('(')!==-1)){/* Like the get, we need to get data from a nested object */var setData=function setData(data,val,src){var a=_fnSplitObjNotation(src),b;var aLast=a[a.length-1];var arrayNotation,funcNotation,o,innerSrc;for(var i=0,iLen=a.length-1;i<iLen;i++){// Check if we are dealing with an array notation request
arrayNotation=a[i].match(__reArray);funcNotation=a[i].match(__reFn);if(arrayNotation){a[i]=a[i].replace(__reArray,'');data[a[i]]=[];// Get the remainder of the nested object to set so we can recurse
b=a.slice();b.splice(0,i+1);innerSrc=b.join('.');// Traverse each entry in the array setting the properties requested
if($.isArray(val)){for(var j=0,jLen=val.length;j<jLen;j++){o={};setData(o,val[j],innerSrc);data[a[i]].push(o);}}else{// We've been asked to save data to an array, but it
// isn't array data to be saved. Best that can be done
// is to just save the value.
data[a[i]]=val;}// The inner call to setData has already traversed through the remainder
// of the source and has set the data, thus we can exit here
return;}else if(funcNotation){// Function call
a[i]=a[i].replace(__reFn,'');data=data[a[i]](val);}// If the nested object doesn't currently exist - since we are
// trying to set the value - create it
if(data[a[i]]===null||data[a[i]]===undefined){data[a[i]]={};}data=data[a[i]];}// Last item in the input - i.e, the actual set
if(aLast.match(__reFn)){// Function call
data=data[aLast.replace(__reFn,'')](val);}else{// If array notation is used, we just want to strip it and use the property name
// and assign the value. If it isn't used, then we get the result we want anyway
data[aLast.replace(__reArray,'')]=val;}};return function(data,val){// meta is also passed in, but not used
return setData(data,val,mSource);};}else{/* Array or flat object mapping */return function(data,val){// meta is also passed in, but not used
data[mSource]=val;};}}/**
     * Return an array with the full table data
     *  @param {object} oSettings dataTables settings object
     *  @returns array {array} aData Master data array
     *  @memberof DataTable#oApi
     */function _fnGetDataMaster(settings){return _pluck(settings.aoData,'_aData');}/**
     * Nuke the table
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnClearTable(settings){settings.aoData.length=0;settings.aiDisplayMaster.length=0;settings.aiDisplay.length=0;settings.aIds={};}/**
     * Take an array of integers (index array) and remove a target integer (value - not
     * the key!)
     *  @param {array} a Index array to target
     *  @param {int} iTarget value to find
     *  @memberof DataTable#oApi
     */function _fnDeleteIndex(a,iTarget,splice){var iTargetIndex=-1;for(var i=0,iLen=a.length;i<iLen;i++){if(a[i]==iTarget){iTargetIndex=i;}else if(a[i]>iTarget){a[i]--;}}if(iTargetIndex!=-1&&splice===undefined){a.splice(iTargetIndex,1);}}/**
     * Mark cached data as invalid such that a re-read of the data will occur when
     * the cached data is next requested. Also update from the data source object.
     *
     * @param {object} settings DataTables settings object
     * @param {int}    rowIdx   Row index to invalidate
     * @param {string} [src]    Source to invalidate from: undefined, 'auto', 'dom'
     *     or 'data'
     * @param {int}    [colIdx] Column index to invalidate. If undefined the whole
     *     row will be invalidated
     * @memberof DataTable#oApi
     *
     * @todo For the modularisation of v1.11 this will need to become a callback, so
     *   the sort and filter methods can subscribe to it. That will required
     *   initialisation options for sorting, which is why it is not already baked in
     */function _fnInvalidate(settings,rowIdx,src,colIdx){var row=settings.aoData[rowIdx];var i,ien;var cellWrite=function cellWrite(cell,col){// This is very frustrating, but in IE if you just write directly
// to innerHTML, and elements that are overwritten are GC'ed,
// even if there is a reference to them elsewhere
while(cell.childNodes.length){cell.removeChild(cell.firstChild);}cell.innerHTML=_fnGetCellData(settings,rowIdx,col,'display');};// Are we reading last data from DOM or the data object?
if(src==='dom'||(!src||src==='auto')&&row.src==='dom'){// Read the data from the DOM
row._aData=_fnGetRowElements(settings,row,colIdx,colIdx===undefined?undefined:row._aData).data;}else{// Reading from data object, update the DOM
var cells=row.anCells;if(cells){if(colIdx!==undefined){cellWrite(cells[colIdx],colIdx);}else{for(i=0,ien=cells.length;i<ien;i++){cellWrite(cells[i],i);}}}}// For both row and cell invalidation, the cached data for sorting and
// filtering is nulled out
row._aSortData=null;row._aFilterData=null;// Invalidate the type for a specific column (if given) or all columns since
// the data might have changed
var cols=settings.aoColumns;if(colIdx!==undefined){cols[colIdx].sType=null;}else{for(i=0,ien=cols.length;i<ien;i++){cols[i].sType=null;}// Update DataTables special `DT_*` attributes for the row
_fnRowAttributes(settings,row);}}/**
     * Build a data source object from an HTML row, reading the contents of the
     * cells that are in the row.
     *
     * @param {object} settings DataTables settings object
     * @param {node|object} TR element from which to read data or existing row
     *   object from which to re-read the data from the cells
     * @param {int} [colIdx] Optional column index
     * @param {array|object} [d] Data source object. If `colIdx` is given then this
     *   parameter should also be given and will be used to write the data into.
     *   Only the column in question will be written
     * @returns {object} Object with two parameters: `data` the data read, in
     *   document order, and `cells` and array of nodes (they can be useful to the
     *   caller, so rather than needing a second traversal to get them, just return
     *   them from here).
     * @memberof DataTable#oApi
     */function _fnGetRowElements(settings,row,colIdx,d){var tds=[],td=row.firstChild,name,col,o,i=0,contents,columns=settings.aoColumns,objectRead=settings._rowReadObject;// Allow the data object to be passed in, or construct
d=d!==undefined?d:objectRead?{}:[];var attr=function attr(str,td){if(typeof str==='string'){var idx=str.indexOf('@');if(idx!==-1){var attr=str.substring(idx+1);var setter=_fnSetObjectDataFn(str);setter(d,td.getAttribute(attr));}}};// Read data from a cell and store into the data object
var cellProcess=function cellProcess(cell){if(colIdx===undefined||colIdx===i){col=columns[i];contents=$.trim(cell.innerHTML);if(col&&col._bAttrSrc){var setter=_fnSetObjectDataFn(col.mData._);setter(d,contents);attr(col.mData.sort,cell);attr(col.mData.type,cell);attr(col.mData.filter,cell);}else{// Depending on the `data` option for the columns the data can
// be read to either an object or an array.
if(objectRead){if(!col._setter){// Cache the setter function
col._setter=_fnSetObjectDataFn(col.mData);}col._setter(d,contents);}else{d[i]=contents;}}}i++;};if(td){// `tr` element was passed in
while(td){name=td.nodeName.toUpperCase();if(name=="TD"||name=="TH"){cellProcess(td);tds.push(td);}td=td.nextSibling;}}else{// Existing row object passed in
tds=row.anCells;for(var j=0,jen=tds.length;j<jen;j++){cellProcess(tds[j]);}}// Read the ID from the DOM if present
var rowNode=row.firstChild?row:row.nTr;if(rowNode){var id=rowNode.getAttribute('id');if(id){_fnSetObjectDataFn(settings.rowId)(d,id);}}return{data:d,cells:tds};}/**
     * Create a new TR element (and it's TD children) for a row
     *  @param {object} oSettings dataTables settings object
     *  @param {int} iRow Row to consider
     *  @param {node} [nTrIn] TR element to add to the table - optional. If not given,
     *    DataTables will create a row automatically
     *  @param {array} [anTds] Array of TD|TH elements for the row - must be given
     *    if nTr is.
     *  @memberof DataTable#oApi
     */function _fnCreateTr(oSettings,iRow,nTrIn,anTds){var row=oSettings.aoData[iRow],rowData=row._aData,cells=[],nTr,nTd,oCol,i,iLen;if(row.nTr===null){nTr=nTrIn||document.createElement('tr');row.nTr=nTr;row.anCells=cells;/* Use a private property on the node to allow reserve mapping from the node
			 * to the aoData array for fast look up
			 */nTr._DT_RowIndex=iRow;/* Special parameters can be given by the data source to be used on the row */_fnRowAttributes(oSettings,row);/* Process each column */for(i=0,iLen=oSettings.aoColumns.length;i<iLen;i++){oCol=oSettings.aoColumns[i];nTd=nTrIn?anTds[i]:document.createElement(oCol.sCellType);nTd._DT_CellIndex={row:iRow,column:i};cells.push(nTd);// Need to create the HTML if new, or if a rendering function is defined
if((!nTrIn||oCol.mRender||oCol.mData!==i)&&(!$.isPlainObject(oCol.mData)||oCol.mData._!==i+'.display')){nTd.innerHTML=_fnGetCellData(oSettings,iRow,i,'display');}/* Add user defined class */if(oCol.sClass){nTd.className+=' '+oCol.sClass;}// Visibility - add or remove as required
if(oCol.bVisible&&!nTrIn){nTr.appendChild(nTd);}else if(!oCol.bVisible&&nTrIn){nTd.parentNode.removeChild(nTd);}if(oCol.fnCreatedCell){oCol.fnCreatedCell.call(oSettings.oInstance,nTd,_fnGetCellData(oSettings,iRow,i),rowData,iRow,i);}}_fnCallbackFire(oSettings,'aoRowCreatedCallback',null,[nTr,rowData,iRow,cells]);}// Remove once webkit bug 131819 and Chromium bug 365619 have been resolved
// and deployed
row.nTr.setAttribute('role','row');}/**
     * Add attributes to a row based on the special `DT_*` parameters in a data
     * source object.
     *  @param {object} settings DataTables settings object
     *  @param {object} DataTables row object for the row to be modified
     *  @memberof DataTable#oApi
     */function _fnRowAttributes(settings,row){var tr=row.nTr;var data=row._aData;if(tr){var id=settings.rowIdFn(data);if(id){tr.id=id;}if(data.DT_RowClass){// Remove any classes added by DT_RowClass before
var a=data.DT_RowClass.split(' ');row.__rowc=row.__rowc?_unique(row.__rowc.concat(a)):a;$(tr).removeClass(row.__rowc.join(' ')).addClass(data.DT_RowClass);}if(data.DT_RowAttr){$(tr).attr(data.DT_RowAttr);}if(data.DT_RowData){$(tr).data(data.DT_RowData);}}}/**
     * Create the HTML header for the table
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnBuildHead(oSettings){var i,ien,cell,row,column;var thead=oSettings.nTHead;var tfoot=oSettings.nTFoot;var createHeader=$('th, td',thead).length===0;var classes=oSettings.oClasses;var columns=oSettings.aoColumns;if(createHeader){row=$('<tr/>').appendTo(thead);}for(i=0,ien=columns.length;i<ien;i++){column=columns[i];cell=$(column.nTh).addClass(column.sClass);if(createHeader){cell.appendTo(row);}// 1.11 move into sorting
if(oSettings.oFeatures.bSort){cell.addClass(column.sSortingClass);if(column.bSortable!==false){cell.attr('tabindex',oSettings.iTabIndex).attr('aria-controls',oSettings.sTableId);_fnSortAttachListener(oSettings,column.nTh,i);}}if(column.sTitle!=cell[0].innerHTML){cell.html(column.sTitle);}_fnRenderer(oSettings,'header')(oSettings,cell,column,classes);}if(createHeader){_fnDetectHeader(oSettings.aoHeader,thead);}/* ARIA role for the rows */$(thead).find('>tr').attr('role','row');/* Deal with the footer - add classes if required */$(thead).find('>tr>th, >tr>td').addClass(classes.sHeaderTH);$(tfoot).find('>tr>th, >tr>td').addClass(classes.sFooterTH);// Cache the footer cells. Note that we only take the cells from the first
// row in the footer. If there is more than one row the user wants to
// interact with, they need to use the table().foot() method. Note also this
// allows cells to be used for multiple columns using colspan
if(tfoot!==null){var cells=oSettings.aoFooter[0];for(i=0,ien=cells.length;i<ien;i++){column=columns[i];column.nTf=cells[i].cell;if(column.sClass){$(column.nTf).addClass(column.sClass);}}}}/**
     * Draw the header (or footer) element based on the column visibility states. The
     * methodology here is to use the layout array from _fnDetectHeader, modified for
     * the instantaneous column visibility, to construct the new layout. The grid is
     * traversed over cell at a time in a rows x columns grid fashion, although each
     * cell insert can cover multiple elements in the grid - which is tracks using the
     * aApplied array. Cell inserts in the grid will only occur where there isn't
     * already a cell in that position.
     *  @param {object} oSettings dataTables settings object
     *  @param array {objects} aoSource Layout array from _fnDetectHeader
     *  @param {boolean} [bIncludeHidden=false] If true then include the hidden columns in the calc,
     *  @memberof DataTable#oApi
     */function _fnDrawHead(oSettings,aoSource,bIncludeHidden){var i,iLen,j,jLen,k,kLen,n,nLocalTr;var aoLocal=[];var aApplied=[];var iColumns=oSettings.aoColumns.length;var iRowspan,iColspan;if(!aoSource){return;}if(bIncludeHidden===undefined){bIncludeHidden=false;}/* Make a copy of the master layout array, but without the visible columns in it */for(i=0,iLen=aoSource.length;i<iLen;i++){aoLocal[i]=aoSource[i].slice();aoLocal[i].nTr=aoSource[i].nTr;/* Remove any columns which are currently hidden */for(j=iColumns-1;j>=0;j--){if(!oSettings.aoColumns[j].bVisible&&!bIncludeHidden){aoLocal[i].splice(j,1);}}/* Prep the applied array - it needs an element for each row */aApplied.push([]);}for(i=0,iLen=aoLocal.length;i<iLen;i++){nLocalTr=aoLocal[i].nTr;/* All cells are going to be replaced, so empty out the row */if(nLocalTr){while(n=nLocalTr.firstChild){nLocalTr.removeChild(n);}}for(j=0,jLen=aoLocal[i].length;j<jLen;j++){iRowspan=1;iColspan=1;/* Check to see if there is already a cell (row/colspan) covering our target
				 * insert point. If there is, then there is nothing to do.
				 */if(aApplied[i][j]===undefined){nLocalTr.appendChild(aoLocal[i][j].cell);aApplied[i][j]=1;/* Expand the cell to cover as many rows as needed */while(aoLocal[i+iRowspan]!==undefined&&aoLocal[i][j].cell==aoLocal[i+iRowspan][j].cell){aApplied[i+iRowspan][j]=1;iRowspan++;}/* Expand the cell to cover as many columns as needed */while(aoLocal[i][j+iColspan]!==undefined&&aoLocal[i][j].cell==aoLocal[i][j+iColspan].cell){/* Must update the applied array over the rows for the columns */for(k=0;k<iRowspan;k++){aApplied[i+k][j+iColspan]=1;}iColspan++;}/* Do the actual expansion in the DOM */$(aoLocal[i][j].cell).attr('rowspan',iRowspan).attr('colspan',iColspan);}}}}/**
     * Insert the required TR nodes into the table for display
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnDraw(oSettings){/* Provide a pre-callback function which can be used to cancel the draw is false is returned */var aPreDraw=_fnCallbackFire(oSettings,'aoPreDrawCallback','preDraw',[oSettings]);if($.inArray(false,aPreDraw)!==-1){_fnProcessingDisplay(oSettings,false);return;}var i,iLen,n;var anRows=[];var iRowCount=0;var asStripeClasses=oSettings.asStripeClasses;var iStripes=asStripeClasses.length;var iOpenRows=oSettings.aoOpenRows.length;var oLang=oSettings.oLanguage;var iInitDisplayStart=oSettings.iInitDisplayStart;var bServerSide=_fnDataSource(oSettings)=='ssp';var aiDisplay=oSettings.aiDisplay;oSettings.bDrawing=true;/* Check and see if we have an initial draw position from state saving */if(iInitDisplayStart!==undefined&&iInitDisplayStart!==-1){oSettings._iDisplayStart=bServerSide?iInitDisplayStart:iInitDisplayStart>=oSettings.fnRecordsDisplay()?0:iInitDisplayStart;oSettings.iInitDisplayStart=-1;}var iDisplayStart=oSettings._iDisplayStart;var iDisplayEnd=oSettings.fnDisplayEnd();/* Server-side processing draw intercept */if(oSettings.bDeferLoading){oSettings.bDeferLoading=false;oSettings.iDraw++;_fnProcessingDisplay(oSettings,false);}else if(!bServerSide){oSettings.iDraw++;}else if(!oSettings.bDestroying&&!_fnAjaxUpdate(oSettings)){return;}if(aiDisplay.length!==0){var iStart=bServerSide?0:iDisplayStart;var iEnd=bServerSide?oSettings.aoData.length:iDisplayEnd;for(var j=iStart;j<iEnd;j++){var iDataIndex=aiDisplay[j];var aoData=oSettings.aoData[iDataIndex];if(aoData.nTr===null){_fnCreateTr(oSettings,iDataIndex);}var nRow=aoData.nTr;/* Remove the old striping classes and then add the new one */if(iStripes!==0){var sStripe=asStripeClasses[iRowCount%iStripes];if(aoData._sRowStripe!=sStripe){$(nRow).removeClass(aoData._sRowStripe).addClass(sStripe);aoData._sRowStripe=sStripe;}}// Row callback functions - might want to manipulate the row
// iRowCount and j are not currently documented. Are they at all
// useful?
_fnCallbackFire(oSettings,'aoRowCallback',null,[nRow,aoData._aData,iRowCount,j,iDataIndex]);anRows.push(nRow);iRowCount++;}}else{/* Table is empty - create a row with an empty message in it */var sZero=oLang.sZeroRecords;if(oSettings.iDraw==1&&_fnDataSource(oSettings)=='ajax'){sZero=oLang.sLoadingRecords;}else if(oLang.sEmptyTable&&oSettings.fnRecordsTotal()===0){sZero=oLang.sEmptyTable;}anRows[0]=$('<tr/>',{'class':iStripes?asStripeClasses[0]:''}).append($('<td />',{'valign':'top','colSpan':_fnVisbleColumns(oSettings),'class':oSettings.oClasses.sRowEmpty}).html(sZero))[0];}/* Header and footer callbacks */_fnCallbackFire(oSettings,'aoHeaderCallback','header',[$(oSettings.nTHead).children('tr')[0],_fnGetDataMaster(oSettings),iDisplayStart,iDisplayEnd,aiDisplay]);_fnCallbackFire(oSettings,'aoFooterCallback','footer',[$(oSettings.nTFoot).children('tr')[0],_fnGetDataMaster(oSettings),iDisplayStart,iDisplayEnd,aiDisplay]);var body=$(oSettings.nTBody);body.children().detach();body.append($(anRows));/* Call all required callback functions for the end of a draw */_fnCallbackFire(oSettings,'aoDrawCallback','draw',[oSettings]);/* Draw is complete, sorting and filtering must be as well */oSettings.bSorted=false;oSettings.bFiltered=false;oSettings.bDrawing=false;}/**
     * Redraw the table - taking account of the various features which are enabled
     *  @param {object} oSettings dataTables settings object
     *  @param {boolean} [holdPosition] Keep the current paging position. By default
     *    the paging is reset to the first page
     *  @memberof DataTable#oApi
     */function _fnReDraw(settings,holdPosition){var features=settings.oFeatures,sort=features.bSort,filter=features.bFilter;if(sort){_fnSort(settings);}if(filter){_fnFilterComplete(settings,settings.oPreviousSearch);}else{// No filtering, so we want to just use the display master
settings.aiDisplay=settings.aiDisplayMaster.slice();}if(holdPosition!==true){settings._iDisplayStart=0;}// Let any modules know about the draw hold position state (used by
// scrolling internally)
settings._drawHold=holdPosition;_fnDraw(settings);settings._drawHold=false;}/**
     * Add the options to the page HTML for the table
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnAddOptionsHtml(oSettings){var classes=oSettings.oClasses;var table=$(oSettings.nTable);var holding=$('<div/>').insertBefore(table);// Holding element for speed
var features=oSettings.oFeatures;// All DataTables are wrapped in a div
var insert=$('<div/>',{id:oSettings.sTableId+'_wrapper','class':classes.sWrapper+(oSettings.nTFoot?'':' '+classes.sNoFooter)});oSettings.nHolding=holding[0];oSettings.nTableWrapper=insert[0];oSettings.nTableReinsertBefore=oSettings.nTable.nextSibling;/* Loop over the user set positioning and place the elements as needed */var aDom=oSettings.sDom.split('');var featureNode,cOption,nNewNode,cNext,sAttr,j;for(var i=0;i<aDom.length;i++){featureNode=null;cOption=aDom[i];if(cOption=='<'){/* New container div */nNewNode=$('<div/>')[0];/* Check to see if we should append an id and/or a class name to the container */cNext=aDom[i+1];if(cNext=="'"||cNext=='"'){sAttr="";j=2;while(aDom[i+j]!=cNext){sAttr+=aDom[i+j];j++;}/* Replace jQuery UI constants @todo depreciated */if(sAttr=="H"){sAttr=classes.sJUIHeader;}else if(sAttr=="F"){sAttr=classes.sJUIFooter;}/* The attribute can be in the format of "#id.class", "#id" or "class" This logic
					 * breaks the string into parts and applies them as needed
					 */if(sAttr.indexOf('.')!=-1){var aSplit=sAttr.split('.');nNewNode.id=aSplit[0].substr(1,aSplit[0].length-1);nNewNode.className=aSplit[1];}else if(sAttr.charAt(0)=="#"){nNewNode.id=sAttr.substr(1,sAttr.length-1);}else{nNewNode.className=sAttr;}i+=j;/* Move along the position array */}insert.append(nNewNode);insert=$(nNewNode);}else if(cOption=='>'){/* End container div */insert=insert.parent();}// @todo Move options into their own plugins?
else if(cOption=='l'&&features.bPaginate&&features.bLengthChange){/* Length */featureNode=_fnFeatureHtmlLength(oSettings);}else if(cOption=='f'&&features.bFilter){/* Filter */featureNode=_fnFeatureHtmlFilter(oSettings);}else if(cOption=='r'&&features.bProcessing){/* pRocessing */featureNode=_fnFeatureHtmlProcessing(oSettings);}else if(cOption=='t'){/* Table */featureNode=_fnFeatureHtmlTable(oSettings);}else if(cOption=='i'&&features.bInfo){/* Info */featureNode=_fnFeatureHtmlInfo(oSettings);}else if(cOption=='p'&&features.bPaginate){/* Pagination */featureNode=_fnFeatureHtmlPaginate(oSettings);}else if(DataTable.ext.feature.length!==0){/* Plug-in features */var aoFeatures=DataTable.ext.feature;for(var k=0,kLen=aoFeatures.length;k<kLen;k++){if(cOption==aoFeatures[k].cFeature){featureNode=aoFeatures[k].fnInit(oSettings);break;}}}/* Add to the 2D features array */if(featureNode){var aanFeatures=oSettings.aanFeatures;if(!aanFeatures[cOption]){aanFeatures[cOption]=[];}aanFeatures[cOption].push(featureNode);insert.append(featureNode);}}/* Built our DOM structure - replace the holding div with what we want */holding.replaceWith(insert);oSettings.nHolding=null;}/**
     * Use the DOM source to create up an array of header cells. The idea here is to
     * create a layout grid (array) of rows x columns, which contains a reference
     * to the cell that that point in the grid (regardless of col/rowspan), such that
     * any column / row could be removed and the new grid constructed
     *  @param array {object} aLayout Array to store the calculated layout in
     *  @param {node} nThead The header/footer element for the table
     *  @memberof DataTable#oApi
     */function _fnDetectHeader(aLayout,nThead){var nTrs=$(nThead).children('tr');var nTr,nCell;var i,k,l,iLen,jLen,iColShifted,iColumn,iColspan,iRowspan;var bUnique;var fnShiftCol=function fnShiftCol(a,i,j){var k=a[i];while(k[j]){j++;}return j;};aLayout.splice(0,aLayout.length);/* We know how many rows there are in the layout - so prep it */for(i=0,iLen=nTrs.length;i<iLen;i++){aLayout.push([]);}/* Calculate a layout array */for(i=0,iLen=nTrs.length;i<iLen;i++){nTr=nTrs[i];iColumn=0;/* For every cell in the row... */nCell=nTr.firstChild;while(nCell){if(nCell.nodeName.toUpperCase()=="TD"||nCell.nodeName.toUpperCase()=="TH"){/* Get the col and rowspan attributes from the DOM and sanitise them */iColspan=nCell.getAttribute('colspan')*1;iRowspan=nCell.getAttribute('rowspan')*1;iColspan=!iColspan||iColspan===0||iColspan===1?1:iColspan;iRowspan=!iRowspan||iRowspan===0||iRowspan===1?1:iRowspan;/* There might be colspan cells already in this row, so shift our target
					 * accordingly
					 */iColShifted=fnShiftCol(aLayout,i,iColumn);/* Cache calculation for unique columns */bUnique=iColspan===1?true:false;/* If there is col / rowspan, copy the information into the layout grid */for(l=0;l<iColspan;l++){for(k=0;k<iRowspan;k++){aLayout[i+k][iColShifted+l]={"cell":nCell,"unique":bUnique};aLayout[i+k].nTr=nTr;}}}nCell=nCell.nextSibling;}}}/**
     * Get an array of unique th elements, one for each column
     *  @param {object} oSettings dataTables settings object
     *  @param {node} nHeader automatically detect the layout from this node - optional
     *  @param {array} aLayout thead/tfoot layout from _fnDetectHeader - optional
     *  @returns array {node} aReturn list of unique th's
     *  @memberof DataTable#oApi
     */function _fnGetUniqueThs(oSettings,nHeader,aLayout){var aReturn=[];if(!aLayout){aLayout=oSettings.aoHeader;if(nHeader){aLayout=[];_fnDetectHeader(aLayout,nHeader);}}for(var i=0,iLen=aLayout.length;i<iLen;i++){for(var j=0,jLen=aLayout[i].length;j<jLen;j++){if(aLayout[i][j].unique&&(!aReturn[j]||!oSettings.bSortCellsTop)){aReturn[j]=aLayout[i][j].cell;}}}return aReturn;}/**
     * Create an Ajax call based on the table's settings, taking into account that
     * parameters can have multiple forms, and backwards compatibility.
     *
     * @param {object} oSettings dataTables settings object
     * @param {array} data Data to send to the server, required by
     *     DataTables - may be augmented by developer callbacks
     * @param {function} fn Callback function to run when data is obtained
     */function _fnBuildAjax(oSettings,data,fn){// Compatibility with 1.9-, allow fnServerData and event to manipulate
_fnCallbackFire(oSettings,'aoServerParams','serverParams',[data]);// Convert to object based for 1.10+ if using the old array scheme which can
// come from server-side processing or serverParams
if(data&&$.isArray(data)){var tmp={};var rbracket=/(.*?)\[\]$/;$.each(data,function(key,val){var match=val.name.match(rbracket);if(match){// Support for arrays
var name=match[0];if(!tmp[name]){tmp[name]=[];}tmp[name].push(val.value);}else{tmp[val.name]=val.value;}});data=tmp;}var ajaxData;var ajax=oSettings.ajax;var instance=oSettings.oInstance;var callback=function callback(json){_fnCallbackFire(oSettings,null,'xhr',[oSettings,json,oSettings.jqXHR]);fn(json);};if($.isPlainObject(ajax)&&ajax.data){ajaxData=ajax.data;var newData=typeof ajaxData==='function'?ajaxData(data,oSettings):// fn can manipulate data or return
ajaxData;// an object object or array to merge
// If the function returned something, use that alone
data=typeof ajaxData==='function'&&newData?newData:$.extend(true,data,newData);// Remove the data property as we've resolved it already and don't want
// jQuery to do it again (it is restored at the end of the function)
delete ajax.data;}var baseAjax={"data":data,"success":function success(json){var error=json.error||json.sError;if(error){_fnLog(oSettings,0,error);}oSettings.json=json;callback(json);},"dataType":"json","cache":false,"type":oSettings.sServerMethod,"error":function error(xhr,_error,thrown){var ret=_fnCallbackFire(oSettings,null,'xhr',[oSettings,null,oSettings.jqXHR]);if($.inArray(true,ret)===-1){if(_error=="parsererror"){_fnLog(oSettings,0,'Invalid JSON response',1);}else if(xhr.readyState===4){_fnLog(oSettings,0,'Ajax error',7);}}_fnProcessingDisplay(oSettings,false);}};// Store the data submitted for the API
oSettings.oAjaxData=data;// Allow plug-ins and external processes to modify the data
_fnCallbackFire(oSettings,null,'preXhr',[oSettings,data]);if(oSettings.fnServerData){// DataTables 1.9- compatibility
oSettings.fnServerData.call(instance,oSettings.sAjaxSource,$.map(data,function(val,key){// Need to convert back to 1.9 trad format
return{name:key,value:val};}),callback,oSettings);}else if(oSettings.sAjaxSource||typeof ajax==='string'){// DataTables 1.9- compatibility
oSettings.jqXHR=$.ajax($.extend(baseAjax,{url:ajax||oSettings.sAjaxSource}));}else if(typeof ajax==='function'){// Is a function - let the caller define what needs to be done
oSettings.jqXHR=ajax.call(instance,data,callback,oSettings);}else{// Object to extend the base settings
oSettings.jqXHR=$.ajax($.extend(baseAjax,ajax));// Restore for next time around
ajax.data=ajaxData;}}/**
     * Update the table using an Ajax call
     *  @param {object} settings dataTables settings object
     *  @returns {boolean} Block the table drawing or not
     *  @memberof DataTable#oApi
     */function _fnAjaxUpdate(settings){if(settings.bAjaxDataGet){settings.iDraw++;_fnProcessingDisplay(settings,true);_fnBuildAjax(settings,_fnAjaxParameters(settings),function(json){_fnAjaxUpdateDraw(settings,json);});return false;}return true;}/**
     * Build up the parameters in an object needed for a server-side processing
     * request. Note that this is basically done twice, is different ways - a modern
     * method which is used by default in DataTables 1.10 which uses objects and
     * arrays, or the 1.9- method with is name / value pairs. 1.9 method is used if
     * the sAjaxSource option is used in the initialisation, or the legacyAjax
     * option is set.
     *  @param {object} oSettings dataTables settings object
     *  @returns {bool} block the table drawing or not
     *  @memberof DataTable#oApi
     */function _fnAjaxParameters(settings){var columns=settings.aoColumns,columnCount=columns.length,features=settings.oFeatures,preSearch=settings.oPreviousSearch,preColSearch=settings.aoPreSearchCols,i,data=[],dataProp,column,columnSearch,sort=_fnSortFlatten(settings),displayStart=settings._iDisplayStart,displayLength=features.bPaginate!==false?settings._iDisplayLength:-1;var param=function param(name,value){data.push({'name':name,'value':value});};// DataTables 1.9- compatible method
param('sEcho',settings.iDraw);param('iColumns',columnCount);param('sColumns',_pluck(columns,'sName').join(','));param('iDisplayStart',displayStart);param('iDisplayLength',displayLength);// DataTables 1.10+ method
var d={draw:settings.iDraw,columns:[],order:[],start:displayStart,length:displayLength,search:{value:preSearch.sSearch,regex:preSearch.bRegex}};for(i=0;i<columnCount;i++){column=columns[i];columnSearch=preColSearch[i];dataProp=typeof column.mData=="function"?'function':column.mData;d.columns.push({data:dataProp,name:column.sName,searchable:column.bSearchable,orderable:column.bSortable,search:{value:columnSearch.sSearch,regex:columnSearch.bRegex}});param("mDataProp_"+i,dataProp);if(features.bFilter){param('sSearch_'+i,columnSearch.sSearch);param('bRegex_'+i,columnSearch.bRegex);param('bSearchable_'+i,column.bSearchable);}if(features.bSort){param('bSortable_'+i,column.bSortable);}}if(features.bFilter){param('sSearch',preSearch.sSearch);param('bRegex',preSearch.bRegex);}if(features.bSort){$.each(sort,function(i,val){d.order.push({column:val.col,dir:val.dir});param('iSortCol_'+i,val.col);param('sSortDir_'+i,val.dir);});param('iSortingCols',sort.length);}// If the legacy.ajax parameter is null, then we automatically decide which
// form to use, based on sAjaxSource
var legacy=DataTable.ext.legacy.ajax;if(legacy===null){return settings.sAjaxSource?data:d;}// Otherwise, if legacy has been specified then we use that to decide on the
// form
return legacy?data:d;}/**
     * Data the data from the server (nuking the old) and redraw the table
     *  @param {object} oSettings dataTables settings object
     *  @param {object} json json data return from the server.
     *  @param {string} json.sEcho Tracking flag for DataTables to match requests
     *  @param {int} json.iTotalRecords Number of records in the data set, not accounting for filtering
     *  @param {int} json.iTotalDisplayRecords Number of records in the data set, accounting for filtering
     *  @param {array} json.aaData The data to display on this page
     *  @param {string} [json.sColumns] Column ordering (sName, comma separated)
     *  @memberof DataTable#oApi
     */function _fnAjaxUpdateDraw(settings,json){// v1.10 uses camelCase variables, while 1.9 uses Hungarian notation.
// Support both
var compat=function compat(old,modern){return json[old]!==undefined?json[old]:json[modern];};var data=_fnAjaxDataSrc(settings,json);var draw=compat('sEcho','draw');var recordsTotal=compat('iTotalRecords','recordsTotal');var recordsFiltered=compat('iTotalDisplayRecords','recordsFiltered');if(draw){// Protect against out of sequence returns
if(draw*1<settings.iDraw){return;}settings.iDraw=draw*1;}_fnClearTable(settings);settings._iRecordsTotal=parseInt(recordsTotal,10);settings._iRecordsDisplay=parseInt(recordsFiltered,10);for(var i=0,ien=data.length;i<ien;i++){_fnAddData(settings,data[i]);}settings.aiDisplay=settings.aiDisplayMaster.slice();settings.bAjaxDataGet=false;_fnDraw(settings);if(!settings._bInitComplete){_fnInitComplete(settings,json);}settings.bAjaxDataGet=true;_fnProcessingDisplay(settings,false);}/**
     * Get the data from the JSON data source to use for drawing a table. Using
     * `_fnGetObjectDataFn` allows the data to be sourced from a property of the
     * source object, or from a processing function.
     *  @param {object} oSettings dataTables settings object
     *  @param  {object} json Data source object / array from the server
     *  @return {array} Array of data to use
     */function _fnAjaxDataSrc(oSettings,json){var dataSrc=$.isPlainObject(oSettings.ajax)&&oSettings.ajax.dataSrc!==undefined?oSettings.ajax.dataSrc:oSettings.sAjaxDataProp;// Compatibility with 1.9-.
// Compatibility with 1.9-. In order to read from aaData, check if the
// default has been changed, if not, check for aaData
if(dataSrc==='data'){return json.aaData||json[dataSrc];}return dataSrc!==""?_fnGetObjectDataFn(dataSrc)(json):json;}/**
     * Generate the node required for filtering text
     *  @returns {node} Filter control element
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnFeatureHtmlFilter(settings){var classes=settings.oClasses;var tableId=settings.sTableId;var language=settings.oLanguage;var previousSearch=settings.oPreviousSearch;var features=settings.aanFeatures;var input='<input type="search" class="'+classes.sFilterInput+'"/>';var str=language.sSearch;str=str.match(/_INPUT_/)?str.replace('_INPUT_',input):str+input;var filter=$('<div/>',{'id':!features.f?tableId+'_filter':null,'class':classes.sFilter}).append($('<label/>').append(str));var searchFn=function searchFn(){/* Update all other filter input elements for the new display */var n=features.f;var val=!this.value?"":this.value;// mental IE8 fix :-(
/* Now do the filter */if(val!=previousSearch.sSearch){_fnFilterComplete(settings,{"sSearch":val,"bRegex":previousSearch.bRegex,"bSmart":previousSearch.bSmart,"bCaseInsensitive":previousSearch.bCaseInsensitive});// Need to redraw, without resorting
settings._iDisplayStart=0;_fnDraw(settings);}};var searchDelay=settings.searchDelay!==null?settings.searchDelay:_fnDataSource(settings)==='ssp'?400:0;var jqFilter=$('input',filter).val(previousSearch.sSearch).attr('placeholder',language.sSearchPlaceholder).on('keyup.DT search.DT input.DT paste.DT cut.DT',searchDelay?_fnThrottle(searchFn,searchDelay):searchFn).on('keypress.DT',function(e){/* Prevent form submission */if(e.keyCode==13){return false;}}).attr('aria-controls',tableId);// Update the input elements whenever the table is filtered
$(settings.nTable).on('search.dt.DT',function(ev,s){if(settings===s){// IE9 throws an 'unknown error' if document.activeElement is used
// inside an iframe or frame...
try{if(jqFilter[0]!==document.activeElement){jqFilter.val(previousSearch.sSearch);}}catch(e){}}});return filter[0];}/**
     * Filter the table using both the global filter and column based filtering
     *  @param {object} oSettings dataTables settings object
     *  @param {object} oSearch search information
     *  @param {int} [iForce] force a research of the master array (1) or not (undefined or 0)
     *  @memberof DataTable#oApi
     */function _fnFilterComplete(oSettings,oInput,iForce){var oPrevSearch=oSettings.oPreviousSearch;var aoPrevSearch=oSettings.aoPreSearchCols;var fnSaveFilter=function fnSaveFilter(oFilter){/* Save the filtering values */oPrevSearch.sSearch=oFilter.sSearch;oPrevSearch.bRegex=oFilter.bRegex;oPrevSearch.bSmart=oFilter.bSmart;oPrevSearch.bCaseInsensitive=oFilter.bCaseInsensitive;};var fnRegex=function fnRegex(o){// Backwards compatibility with the bEscapeRegex option
return o.bEscapeRegex!==undefined?!o.bEscapeRegex:o.bRegex;};// Resolve any column types that are unknown due to addition or invalidation
// @todo As per sort - can this be moved into an event handler?
_fnColumnTypes(oSettings);/* In server-side processing all filtering is done by the server, so no point hanging around here */if(_fnDataSource(oSettings)!='ssp'){/* Global filter */_fnFilter(oSettings,oInput.sSearch,iForce,fnRegex(oInput),oInput.bSmart,oInput.bCaseInsensitive);fnSaveFilter(oInput);/* Now do the individual column filter */for(var i=0;i<aoPrevSearch.length;i++){_fnFilterColumn(oSettings,aoPrevSearch[i].sSearch,i,fnRegex(aoPrevSearch[i]),aoPrevSearch[i].bSmart,aoPrevSearch[i].bCaseInsensitive);}/* Custom filtering */_fnFilterCustom(oSettings);}else{fnSaveFilter(oInput);}/* Tell the draw function we have been filtering */oSettings.bFiltered=true;_fnCallbackFire(oSettings,null,'search',[oSettings]);}/**
     * Apply custom filtering functions
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnFilterCustom(settings){var filters=DataTable.ext.search;var displayRows=settings.aiDisplay;var row,rowIdx;for(var i=0,ien=filters.length;i<ien;i++){var rows=[];// Loop over each row and see if it should be included
for(var j=0,jen=displayRows.length;j<jen;j++){rowIdx=displayRows[j];row=settings.aoData[rowIdx];if(filters[i](settings,row._aFilterData,rowIdx,row._aData,j)){rows.push(rowIdx);}}// So the array reference doesn't break set the results into the
// existing array
displayRows.length=0;$.merge(displayRows,rows);}}/**
     * Filter the table on a per-column basis
     *  @param {object} oSettings dataTables settings object
     *  @param {string} sInput string to filter on
     *  @param {int} iColumn column to filter
     *  @param {bool} bRegex treat search string as a regular expression or not
     *  @param {bool} bSmart use smart filtering or not
     *  @param {bool} bCaseInsensitive Do case insenstive matching or not
     *  @memberof DataTable#oApi
     */function _fnFilterColumn(settings,searchStr,colIdx,regex,smart,caseInsensitive){if(searchStr===''){return;}var data;var out=[];var display=settings.aiDisplay;var rpSearch=_fnFilterCreateSearch(searchStr,regex,smart,caseInsensitive);for(var i=0;i<display.length;i++){data=settings.aoData[display[i]]._aFilterData[colIdx];if(rpSearch.test(data)){out.push(display[i]);}}settings.aiDisplay=out;}/**
     * Filter the data table based on user input and draw the table
     *  @param {object} settings dataTables settings object
     *  @param {string} input string to filter on
     *  @param {int} force optional - force a research of the master array (1) or not (undefined or 0)
     *  @param {bool} regex treat as a regular expression or not
     *  @param {bool} smart perform smart filtering or not
     *  @param {bool} caseInsensitive Do case insenstive matching or not
     *  @memberof DataTable#oApi
     */function _fnFilter(settings,input,force,regex,smart,caseInsensitive){var rpSearch=_fnFilterCreateSearch(input,regex,smart,caseInsensitive);var prevSearch=settings.oPreviousSearch.sSearch;var displayMaster=settings.aiDisplayMaster;var display,invalidated,i;var filtered=[];// Need to take account of custom filtering functions - always filter
if(DataTable.ext.search.length!==0){force=true;}// Check if any of the rows were invalidated
invalidated=_fnFilterData(settings);// If the input is blank - we just want the full data set
if(input.length<=0){settings.aiDisplay=displayMaster.slice();}else{// New search - start from the master array
if(invalidated||force||prevSearch.length>input.length||input.indexOf(prevSearch)!==0||settings.bSorted// On resort, the display master needs to be
// re-filtered since indexes will have changed
){settings.aiDisplay=displayMaster.slice();}// Search the display array
display=settings.aiDisplay;for(i=0;i<display.length;i++){if(rpSearch.test(settings.aoData[display[i]]._sFilterRow)){filtered.push(display[i]);}}settings.aiDisplay=filtered;}}/**
     * Build a regular expression object suitable for searching a table
     *  @param {string} sSearch string to search for
     *  @param {bool} bRegex treat as a regular expression or not
     *  @param {bool} bSmart perform smart filtering or not
     *  @param {bool} bCaseInsensitive Do case insensitive matching or not
     *  @returns {RegExp} constructed object
     *  @memberof DataTable#oApi
     */function _fnFilterCreateSearch(search,regex,smart,caseInsensitive){search=regex?search:_fnEscapeRegex(search);if(smart){/* For smart filtering we want to allow the search to work regardless of
			 * word order. We also want double quoted text to be preserved, so word
			 * order is important - a la google. So this is what we want to
			 * generate:
			 *
			 * ^(?=.*?\bone\b)(?=.*?\btwo three\b)(?=.*?\bfour\b).*$
			 */var a=$.map(search.match(/"[^"]+"|[^ ]+/g)||[''],function(word){if(word.charAt(0)==='"'){var m=word.match(/^"(.*)"$/);word=m?m[1]:word;}return word.replace('"','');});search='^(?=.*?'+a.join(')(?=.*?')+').*$';}return new RegExp(search,caseInsensitive?'i':'');}/**
     * Escape a string such that it can be used in a regular expression
     *  @param {string} sVal string to escape
     *  @returns {string} escaped string
     *  @memberof DataTable#oApi
     */var _fnEscapeRegex=DataTable.util.escapeRegex;var __filter_div=$('<div>')[0];var __filter_div_textContent=__filter_div.textContent!==undefined;// Update the filtering data for each row if needed (by invalidation or first run)
function _fnFilterData(settings){var columns=settings.aoColumns;var column;var i,j,ien,jen,filterData,cellData,row;var fomatters=DataTable.ext.type.search;var wasInvalidated=false;for(i=0,ien=settings.aoData.length;i<ien;i++){row=settings.aoData[i];if(!row._aFilterData){filterData=[];for(j=0,jen=columns.length;j<jen;j++){column=columns[j];if(column.bSearchable){cellData=_fnGetCellData(settings,i,j,'filter');if(fomatters[column.sType]){cellData=fomatters[column.sType](cellData);}// Search in DataTables 1.10 is string based. In 1.11 this
// should be altered to also allow strict type checking.
if(cellData===null){cellData='';}if(typeof cellData!=='string'&&cellData.toString){cellData=cellData.toString();}}else{cellData='';}// If it looks like there is an HTML entity in the string,
// attempt to decode it so sorting works as expected. Note that
// we could use a single line of jQuery to do this, but the DOM
// method used here is much faster http://jsperf.com/html-decode
if(cellData.indexOf&&cellData.indexOf('&')!==-1){__filter_div.innerHTML=cellData;cellData=__filter_div_textContent?__filter_div.textContent:__filter_div.innerText;}if(cellData.replace){cellData=cellData.replace(/[\r\n]/g,'');}filterData.push(cellData);}row._aFilterData=filterData;row._sFilterRow=filterData.join('  ');wasInvalidated=true;}}return wasInvalidated;}/**
     * Convert from the internal Hungarian notation to camelCase for external
     * interaction
     *  @param {object} obj Object to convert
     *  @returns {object} Inverted object
     *  @memberof DataTable#oApi
     */function _fnSearchToCamel(obj){return{search:obj.sSearch,smart:obj.bSmart,regex:obj.bRegex,caseInsensitive:obj.bCaseInsensitive};}/**
     * Convert from camelCase notation to the internal Hungarian. We could use the
     * Hungarian convert function here, but this is cleaner
     *  @param {object} obj Object to convert
     *  @returns {object} Inverted object
     *  @memberof DataTable#oApi
     */function _fnSearchToHung(obj){return{sSearch:obj.search,bSmart:obj.smart,bRegex:obj.regex,bCaseInsensitive:obj.caseInsensitive};}/**
     * Generate the node required for the info display
     *  @param {object} oSettings dataTables settings object
     *  @returns {node} Information element
     *  @memberof DataTable#oApi
     */function _fnFeatureHtmlInfo(settings){var tid=settings.sTableId,nodes=settings.aanFeatures.i,n=$('<div/>',{'class':settings.oClasses.sInfo,'id':!nodes?tid+'_info':null});if(!nodes){// Update display on each draw
settings.aoDrawCallback.push({"fn":_fnUpdateInfo,"sName":"information"});n.attr('role','status').attr('aria-live','polite');// Table is described by our info div
$(settings.nTable).attr('aria-describedby',tid+'_info');}return n[0];}/**
     * Update the information elements in the display
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnUpdateInfo(settings){/* Show information about the table */var nodes=settings.aanFeatures.i;if(nodes.length===0){return;}var lang=settings.oLanguage,start=settings._iDisplayStart+1,end=settings.fnDisplayEnd(),max=settings.fnRecordsTotal(),total=settings.fnRecordsDisplay(),out=total?lang.sInfo:lang.sInfoEmpty;if(total!==max){/* Record set after filtering */out+=' '+lang.sInfoFiltered;}// Convert the macros
out+=lang.sInfoPostFix;out=_fnInfoMacros(settings,out);var callback=lang.fnInfoCallback;if(callback!==null){out=callback.call(settings.oInstance,settings,start,end,max,total,out);}$(nodes).html(out);}function _fnInfoMacros(settings,str){// When infinite scrolling, we are always starting at 1. _iDisplayStart is used only
// internally
var formatter=settings.fnFormatNumber,start=settings._iDisplayStart+1,len=settings._iDisplayLength,vis=settings.fnRecordsDisplay(),all=len===-1;return str.replace(/_START_/g,formatter.call(settings,start)).replace(/_END_/g,formatter.call(settings,settings.fnDisplayEnd())).replace(/_MAX_/g,formatter.call(settings,settings.fnRecordsTotal())).replace(/_TOTAL_/g,formatter.call(settings,vis)).replace(/_PAGE_/g,formatter.call(settings,all?1:Math.ceil(start/len))).replace(/_PAGES_/g,formatter.call(settings,all?1:Math.ceil(vis/len)));}/**
     * Draw the table for the first time, adding all required features
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnInitialise(settings){var i,iLen,iAjaxStart=settings.iInitDisplayStart;var columns=settings.aoColumns,column;var features=settings.oFeatures;var deferLoading=settings.bDeferLoading;// value modified by the draw
/* Ensure that the table data is fully initialised */if(!settings.bInitialised){setTimeout(function(){_fnInitialise(settings);},200);return;}/* Show the display HTML options */_fnAddOptionsHtml(settings);/* Build and draw the header / footer for the table */_fnBuildHead(settings);_fnDrawHead(settings,settings.aoHeader);_fnDrawHead(settings,settings.aoFooter);/* Okay to show that something is going on now */_fnProcessingDisplay(settings,true);/* Calculate sizes for columns */if(features.bAutoWidth){_fnCalculateColumnWidths(settings);}for(i=0,iLen=columns.length;i<iLen;i++){column=columns[i];if(column.sWidth){column.nTh.style.width=_fnStringToCss(column.sWidth);}}_fnCallbackFire(settings,null,'preInit',[settings]);// If there is default sorting required - let's do it. The sort function
// will do the drawing for us. Otherwise we draw the table regardless of the
// Ajax source - this allows the table to look initialised for Ajax sourcing
// data (show 'loading' message possibly)
_fnReDraw(settings);// Server-side processing init complete is done by _fnAjaxUpdateDraw
var dataSrc=_fnDataSource(settings);if(dataSrc!='ssp'||deferLoading){// if there is an ajax source load the data
if(dataSrc=='ajax'){_fnBuildAjax(settings,[],function(json){var aData=_fnAjaxDataSrc(settings,json);// Got the data - add it to the table
for(i=0;i<aData.length;i++){_fnAddData(settings,aData[i]);}// Reset the init display for cookie saving. We've already done
// a filter, and therefore cleared it before. So we need to make
// it appear 'fresh'
settings.iInitDisplayStart=iAjaxStart;_fnReDraw(settings);_fnProcessingDisplay(settings,false);_fnInitComplete(settings,json);},settings);}else{_fnProcessingDisplay(settings,false);_fnInitComplete(settings);}}}/**
     * Draw the table for the first time, adding all required features
     *  @param {object} oSettings dataTables settings object
     *  @param {object} [json] JSON from the server that completed the table, if using Ajax source
     *    with client-side processing (optional)
     *  @memberof DataTable#oApi
     */function _fnInitComplete(settings,json){settings._bInitComplete=true;// When data was added after the initialisation (data or Ajax) we need to
// calculate the column sizing
if(json||settings.oInit.aaData){_fnAdjustColumnSizing(settings);}_fnCallbackFire(settings,null,'plugin-init',[settings,json]);_fnCallbackFire(settings,'aoInitComplete','init',[settings,json]);}function _fnLengthChange(settings,val){var len=parseInt(val,10);settings._iDisplayLength=len;_fnLengthOverflow(settings);// Fire length change event
_fnCallbackFire(settings,null,'length',[settings,len]);}/**
     * Generate the node required for user display length changing
     *  @param {object} settings dataTables settings object
     *  @returns {node} Display length feature node
     *  @memberof DataTable#oApi
     */function _fnFeatureHtmlLength(settings){var classes=settings.oClasses,tableId=settings.sTableId,menu=settings.aLengthMenu,d2=$.isArray(menu[0]),lengths=d2?menu[0]:menu,language=d2?menu[1]:menu;var select=$('<select/>',{'name':tableId+'_length','aria-controls':tableId,'class':classes.sLengthSelect});for(var i=0,ien=lengths.length;i<ien;i++){select[0][i]=new Option(typeof language[i]==='number'?settings.fnFormatNumber(language[i]):language[i],lengths[i]);}var div=$('<div><label/></div>').addClass(classes.sLength);if(!settings.aanFeatures.l){div[0].id=tableId+'_length';}div.children().append(settings.oLanguage.sLengthMenu.replace('_MENU_',select[0].outerHTML));// Can't use `select` variable as user might provide their own and the
// reference is broken by the use of outerHTML
$('select',div).val(settings._iDisplayLength).on('change.DT',function(e){_fnLengthChange(settings,$(this).val());_fnDraw(settings);});// Update node value whenever anything changes the table's length
$(settings.nTable).on('length.dt.DT',function(e,s,len){if(settings===s){$('select',div).val(len);}});return div[0];}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Note that most of the paging logic is done in
	 * DataTable.ext.pager
	 */ /**
     * Generate the node required for default pagination
     *  @param {object} oSettings dataTables settings object
     *  @returns {node} Pagination feature node
     *  @memberof DataTable#oApi
     */function _fnFeatureHtmlPaginate(settings){var type=settings.sPaginationType,plugin=DataTable.ext.pager[type],modern=typeof plugin==='function',redraw=function redraw(settings){_fnDraw(settings);},node=$('<div/>').addClass(settings.oClasses.sPaging+type)[0],features=settings.aanFeatures;if(!modern){plugin.fnInit(settings,node,redraw);}/* Add a draw callback for the pagination on first instance, to update the paging display */if(!features.p){node.id=settings.sTableId+'_paginate';settings.aoDrawCallback.push({"fn":function fn(settings){if(modern){var start=settings._iDisplayStart,len=settings._iDisplayLength,visRecords=settings.fnRecordsDisplay(),all=len===-1,page=all?0:Math.ceil(start/len),pages=all?1:Math.ceil(visRecords/len),buttons=plugin(page,pages),i,ien;for(i=0,ien=features.p.length;i<ien;i++){_fnRenderer(settings,'pageButton')(settings,features.p[i],i,buttons,page,pages);}}else{plugin.fnUpdate(settings,redraw);}},"sName":"pagination"});}return node;}/**
     * Alter the display settings to change the page
     *  @param {object} settings DataTables settings object
     *  @param {string|int} action Paging action to take: "first", "previous",
     *    "next" or "last" or page number to jump to (integer)
     *  @param [bool] redraw Automatically draw the update or not
     *  @returns {bool} true page has changed, false - no change
     *  @memberof DataTable#oApi
     */function _fnPageChange(settings,action,redraw){var start=settings._iDisplayStart,len=settings._iDisplayLength,records=settings.fnRecordsDisplay();if(records===0||len===-1){start=0;}else if(typeof action==="number"){start=action*len;if(start>records){start=0;}}else if(action=="first"){start=0;}else if(action=="previous"){start=len>=0?start-len:0;if(start<0){start=0;}}else if(action=="next"){if(start+len<records){start+=len;}}else if(action=="last"){start=Math.floor((records-1)/len)*len;}else{_fnLog(settings,0,"Unknown paging action: "+action,5);}var changed=settings._iDisplayStart!==start;settings._iDisplayStart=start;if(changed){_fnCallbackFire(settings,null,'page',[settings]);if(redraw){_fnDraw(settings);}}return changed;}/**
     * Generate the node required for the processing node
     *  @param {object} settings dataTables settings object
     *  @returns {node} Processing element
     *  @memberof DataTable#oApi
     */function _fnFeatureHtmlProcessing(settings){return $('<div/>',{'id':!settings.aanFeatures.r?settings.sTableId+'_processing':null,'class':settings.oClasses.sProcessing}).html(settings.oLanguage.sProcessing).insertBefore(settings.nTable)[0];}/**
     * Display or hide the processing indicator
     *  @param {object} settings dataTables settings object
     *  @param {bool} show Show the processing indicator (true) or not (false)
     *  @memberof DataTable#oApi
     */function _fnProcessingDisplay(settings,show){if(settings.oFeatures.bProcessing){$(settings.aanFeatures.r).css('display',show?'block':'none');}_fnCallbackFire(settings,null,'processing',[settings,show]);}/**
     * Add any control elements for the table - specifically scrolling
     *  @param {object} settings dataTables settings object
     *  @returns {node} Node to add to the DOM
     *  @memberof DataTable#oApi
     */function _fnFeatureHtmlTable(settings){var table=$(settings.nTable);// Add the ARIA grid role to the table
table.attr('role','grid');// Scrolling from here on in
var scroll=settings.oScroll;if(scroll.sX===''&&scroll.sY===''){return settings.nTable;}var scrollX=scroll.sX;var scrollY=scroll.sY;var classes=settings.oClasses;var caption=table.children('caption');var captionSide=caption.length?caption[0]._captionSide:null;var headerClone=$(table[0].cloneNode(false));var footerClone=$(table[0].cloneNode(false));var footer=table.children('tfoot');var _div='<div/>';var size=function size(s){return!s?null:_fnStringToCss(s);};if(!footer.length){footer=null;}/*
		 * The HTML structure that we want to generate in this function is:
		 *  div - scroller
		 *    div - scroll head
		 *      div - scroll head inner
		 *        table - scroll head table
		 *          thead - thead
		 *    div - scroll body
		 *      table - table (master table)
		 *        thead - thead clone for sizing
		 *        tbody - tbody
		 *    div - scroll foot
		 *      div - scroll foot inner
		 *        table - scroll foot table
		 *          tfoot - tfoot
		 */var scroller=$(_div,{'class':classes.sScrollWrapper}).append($(_div,{'class':classes.sScrollHead}).css({overflow:'hidden',position:'relative',border:0,width:scrollX?size(scrollX):'100%'}).append($(_div,{'class':classes.sScrollHeadInner}).css({'box-sizing':'content-box',width:scroll.sXInner||'100%'}).append(headerClone.removeAttr('id').css('margin-left',0).append(captionSide==='top'?caption:null).append(table.children('thead'))))).append($(_div,{'class':classes.sScrollBody}).css({position:'relative',overflow:'auto',width:size(scrollX)}).append(table));if(footer){scroller.append($(_div,{'class':classes.sScrollFoot}).css({overflow:'hidden',border:0,width:scrollX?size(scrollX):'100%'}).append($(_div,{'class':classes.sScrollFootInner}).append(footerClone.removeAttr('id').css('margin-left',0).append(captionSide==='bottom'?caption:null).append(table.children('tfoot')))));}var children=scroller.children();var scrollHead=children[0];var scrollBody=children[1];var scrollFoot=footer?children[2]:null;// When the body is scrolled, then we also want to scroll the headers
if(scrollX){$(scrollBody).on('scroll.DT',function(e){var scrollLeft=this.scrollLeft;scrollHead.scrollLeft=scrollLeft;if(footer){scrollFoot.scrollLeft=scrollLeft;}});}$(scrollBody).css(scrollY&&scroll.bCollapse?'max-height':'height',scrollY);settings.nScrollHead=scrollHead;settings.nScrollBody=scrollBody;settings.nScrollFoot=scrollFoot;// On redraw - align columns
settings.aoDrawCallback.push({"fn":_fnScrollDraw,"sName":"scrolling"});return scroller[0];}/**
     * Update the header, footer and body tables for resizing - i.e. column
     * alignment.
     *
     * Welcome to the most horrible function DataTables. The process that this
     * function follows is basically:
     *   1. Re-create the table inside the scrolling div
     *   2. Take live measurements from the DOM
     *   3. Apply the measurements to align the columns
     *   4. Clean up
     *
     *  @param {object} settings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnScrollDraw(settings){// Given that this is such a monster function, a lot of variables are use
// to try and keep the minimised size as small as possible
var scroll=settings.oScroll,scrollX=scroll.sX,scrollXInner=scroll.sXInner,scrollY=scroll.sY,barWidth=scroll.iBarWidth,divHeader=$(settings.nScrollHead),divHeaderStyle=divHeader[0].style,divHeaderInner=divHeader.children('div'),divHeaderInnerStyle=divHeaderInner[0].style,divHeaderTable=divHeaderInner.children('table'),divBodyEl=settings.nScrollBody,divBody=$(divBodyEl),divBodyStyle=divBodyEl.style,divFooter=$(settings.nScrollFoot),divFooterInner=divFooter.children('div'),divFooterTable=divFooterInner.children('table'),header=$(settings.nTHead),table=$(settings.nTable),tableEl=table[0],tableStyle=tableEl.style,footer=settings.nTFoot?$(settings.nTFoot):null,browser=settings.oBrowser,ie67=browser.bScrollOversize,dtHeaderCells=_pluck(settings.aoColumns,'nTh'),headerTrgEls,footerTrgEls,headerSrcEls,footerSrcEls,headerCopy,footerCopy,headerWidths=[],footerWidths=[],headerContent=[],footerContent=[],idx,correction,sanityWidth,zeroOut=function zeroOut(nSizer){var style=nSizer.style;style.paddingTop="0";style.paddingBottom="0";style.borderTopWidth="0";style.borderBottomWidth="0";style.height=0;};// If the scrollbar visibility has changed from the last draw, we need to
// adjust the column sizes as the table width will have changed to account
// for the scrollbar
var scrollBarVis=divBodyEl.scrollHeight>divBodyEl.clientHeight;if(settings.scrollBarVis!==scrollBarVis&&settings.scrollBarVis!==undefined){settings.scrollBarVis=scrollBarVis;_fnAdjustColumnSizing(settings);return;// adjust column sizing will call this function again
}else{settings.scrollBarVis=scrollBarVis;}/*
		 * 1. Re-create the table inside the scrolling div
		 */ // Remove the old minimised thead and tfoot elements in the inner table
table.children('thead, tfoot').remove();if(footer){footerCopy=footer.clone().prependTo(table);footerTrgEls=footer.find('tr');// the original tfoot is in its own table and must be sized
footerSrcEls=footerCopy.find('tr');}// Clone the current header and footer elements and then place it into the inner table
headerCopy=header.clone().prependTo(table);headerTrgEls=header.find('tr');// original header is in its own table
headerSrcEls=headerCopy.find('tr');headerCopy.find('th, td').removeAttr('tabindex');/*
		 * 2. Take live measurements from the DOM - do not alter the DOM itself!
		 */ // Remove old sizing and apply the calculated column widths
// Get the unique column headers in the newly created (cloned) header. We want to apply the
// calculated sizes to this header
if(!scrollX){divBodyStyle.width='100%';divHeader[0].style.width='100%';}$.each(_fnGetUniqueThs(settings,headerCopy),function(i,el){idx=_fnVisibleToColumnIndex(settings,i);el.style.width=settings.aoColumns[idx].sWidth;});if(footer){_fnApplyToChildren(function(n){n.style.width="";},footerSrcEls);}// Size the table as a whole
sanityWidth=table.outerWidth();if(scrollX===""){// No x scrolling
tableStyle.width="100%";// IE7 will make the width of the table when 100% include the scrollbar
// - which is shouldn't. When there is a scrollbar we need to take this
// into account.
if(ie67&&(table.find('tbody').height()>divBodyEl.offsetHeight||divBody.css('overflow-y')=="scroll")){tableStyle.width=_fnStringToCss(table.outerWidth()-barWidth);}// Recalculate the sanity width
sanityWidth=table.outerWidth();}else if(scrollXInner!==""){// legacy x scroll inner has been given - use it
tableStyle.width=_fnStringToCss(scrollXInner);// Recalculate the sanity width
sanityWidth=table.outerWidth();}// Hidden header should have zero height, so remove padding and borders. Then
// set the width based on the real headers
// Apply all styles in one pass
_fnApplyToChildren(zeroOut,headerSrcEls);// Read all widths in next pass
_fnApplyToChildren(function(nSizer){headerContent.push(nSizer.innerHTML);headerWidths.push(_fnStringToCss($(nSizer).css('width')));},headerSrcEls);// Apply all widths in final pass
_fnApplyToChildren(function(nToSize,i){// Only apply widths to the DataTables detected header cells - this
// prevents complex headers from having contradictory sizes applied
if($.inArray(nToSize,dtHeaderCells)!==-1){nToSize.style.width=headerWidths[i];}},headerTrgEls);$(headerSrcEls).height(0);/* Same again with the footer if we have one */if(footer){_fnApplyToChildren(zeroOut,footerSrcEls);_fnApplyToChildren(function(nSizer){footerContent.push(nSizer.innerHTML);footerWidths.push(_fnStringToCss($(nSizer).css('width')));},footerSrcEls);_fnApplyToChildren(function(nToSize,i){nToSize.style.width=footerWidths[i];},footerTrgEls);$(footerSrcEls).height(0);}/*
		 * 3. Apply the measurements
		 */ // "Hide" the header and footer that we used for the sizing. We need to keep
// the content of the cell so that the width applied to the header and body
// both match, but we want to hide it completely. We want to also fix their
// width to what they currently are
_fnApplyToChildren(function(nSizer,i){nSizer.innerHTML='<div class="dataTables_sizing">'+headerContent[i]+'</div>';nSizer.childNodes[0].style.height="0";nSizer.childNodes[0].style.overflow="hidden";nSizer.style.width=headerWidths[i];},headerSrcEls);if(footer){_fnApplyToChildren(function(nSizer,i){nSizer.innerHTML='<div class="dataTables_sizing">'+footerContent[i]+'</div>';nSizer.childNodes[0].style.height="0";nSizer.childNodes[0].style.overflow="hidden";nSizer.style.width=footerWidths[i];},footerSrcEls);}// Sanity check that the table is of a sensible width. If not then we are going to get
// misalignment - try to prevent this by not allowing the table to shrink below its min width
if(table.outerWidth()<sanityWidth){// The min width depends upon if we have a vertical scrollbar visible or not */
correction=divBodyEl.scrollHeight>divBodyEl.offsetHeight||divBody.css('overflow-y')=="scroll"?sanityWidth+barWidth:sanityWidth;// IE6/7 are a law unto themselves...
if(ie67&&(divBodyEl.scrollHeight>divBodyEl.offsetHeight||divBody.css('overflow-y')=="scroll")){tableStyle.width=_fnStringToCss(correction-barWidth);}// And give the user a warning that we've stopped the table getting too small
if(scrollX===""||scrollXInner!==""){_fnLog(settings,1,'Possible column misalignment',6);}}else{correction='100%';}// Apply to the container elements
divBodyStyle.width=_fnStringToCss(correction);divHeaderStyle.width=_fnStringToCss(correction);if(footer){settings.nScrollFoot.style.width=_fnStringToCss(correction);}/*
		 * 4. Clean up
		 */if(!scrollY){/* IE7< puts a vertical scrollbar in place (when it shouldn't be) due to subtracting
			 * the scrollbar height from the visible display, rather than adding it on. We need to
			 * set the height in order to sort this. Don't want to do it in any other browsers.
			 */if(ie67){divBodyStyle.height=_fnStringToCss(tableEl.offsetHeight+barWidth);}}/* Finally set the width's of the header and footer tables */var iOuterWidth=table.outerWidth();divHeaderTable[0].style.width=_fnStringToCss(iOuterWidth);divHeaderInnerStyle.width=_fnStringToCss(iOuterWidth);// Figure out if there are scrollbar present - if so then we need a the header and footer to
// provide a bit more space to allow "overflow" scrolling (i.e. past the scrollbar)
var bScrolling=table.height()>divBodyEl.clientHeight||divBody.css('overflow-y')=="scroll";var padding='padding'+(browser.bScrollbarLeft?'Left':'Right');divHeaderInnerStyle[padding]=bScrolling?barWidth+"px":"0px";if(footer){divFooterTable[0].style.width=_fnStringToCss(iOuterWidth);divFooterInner[0].style.width=_fnStringToCss(iOuterWidth);divFooterInner[0].style[padding]=bScrolling?barWidth+"px":"0px";}// Correct DOM ordering for colgroup - comes before the thead
table.children('colgroup').insertBefore(table.children('thead'));/* Adjust the position of the header in case we loose the y-scrollbar */divBody.scroll();// If sorting or filtering has occurred, jump the scrolling back to the top
// only if we aren't holding the position
if((settings.bSorted||settings.bFiltered)&&!settings._drawHold){divBodyEl.scrollTop=0;}}/**
     * Apply a given function to the display child nodes of an element array (typically
     * TD children of TR rows
     *  @param {function} fn Method to apply to the objects
     *  @param array {nodes} an1 List of elements to look through for display children
     *  @param array {nodes} an2 Another list (identical structure to the first) - optional
     *  @memberof DataTable#oApi
     */function _fnApplyToChildren(fn,an1,an2){var index=0,i=0,iLen=an1.length;var nNode1,nNode2;while(i<iLen){nNode1=an1[i].firstChild;nNode2=an2?an2[i].firstChild:null;while(nNode1){if(nNode1.nodeType===1){if(an2){fn(nNode1,nNode2,index);}else{fn(nNode1,index);}index++;}nNode1=nNode1.nextSibling;nNode2=an2?nNode2.nextSibling:null;}i++;}}var __re_html_remove=/<.*?>/g;/**
     * Calculate the width of columns for the table
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnCalculateColumnWidths(oSettings){var table=oSettings.nTable,columns=oSettings.aoColumns,scroll=oSettings.oScroll,scrollY=scroll.sY,scrollX=scroll.sX,scrollXInner=scroll.sXInner,columnCount=columns.length,visibleColumns=_fnGetColumns(oSettings,'bVisible'),headerCells=$('th',oSettings.nTHead),tableWidthAttr=table.getAttribute('width'),// from DOM element
tableContainer=table.parentNode,userInputs=false,i,column,columnIdx,width,outerWidth,browser=oSettings.oBrowser,ie67=browser.bScrollOversize;var styleWidth=table.style.width;if(styleWidth&&styleWidth.indexOf('%')!==-1){tableWidthAttr=styleWidth;}/* Convert any user input sizes into pixel sizes */for(i=0;i<visibleColumns.length;i++){column=columns[visibleColumns[i]];if(column.sWidth!==null){column.sWidth=_fnConvertToWidth(column.sWidthOrig,tableContainer);userInputs=true;}}/* If the number of columns in the DOM equals the number that we have to
		 * process in DataTables, then we can use the offsets that are created by
		 * the web- browser. No custom sizes can be set in order for this to happen,
		 * nor scrolling used
		 */if(ie67||!userInputs&&!scrollX&&!scrollY&&columnCount==_fnVisbleColumns(oSettings)&&columnCount==headerCells.length){for(i=0;i<columnCount;i++){var colIdx=_fnVisibleToColumnIndex(oSettings,i);if(colIdx!==null){columns[colIdx].sWidth=_fnStringToCss(headerCells.eq(i).width());}}}else{// Otherwise construct a single row, worst case, table with the widest
// node in the data, assign any user defined widths, then insert it into
// the DOM and allow the browser to do all the hard work of calculating
// table widths
var tmpTable=$(table).clone()// don't use cloneNode - IE8 will remove events on the main table
.css('visibility','hidden').removeAttr('id');// Clean up the table body
tmpTable.find('tbody tr').remove();var tr=$('<tr/>').appendTo(tmpTable.find('tbody'));// Clone the table header and footer - we can't use the header / footer
// from the cloned table, since if scrolling is active, the table's
// real header and footer are contained in different table tags
tmpTable.find('thead, tfoot').remove();tmpTable.append($(oSettings.nTHead).clone()).append($(oSettings.nTFoot).clone());// Remove any assigned widths from the footer (from scrolling)
tmpTable.find('tfoot th, tfoot td').css('width','');// Apply custom sizing to the cloned header
headerCells=_fnGetUniqueThs(oSettings,tmpTable.find('thead')[0]);for(i=0;i<visibleColumns.length;i++){column=columns[visibleColumns[i]];headerCells[i].style.width=column.sWidthOrig!==null&&column.sWidthOrig!==''?_fnStringToCss(column.sWidthOrig):'';// For scrollX we need to force the column width otherwise the
// browser will collapse it. If this width is smaller than the
// width the column requires, then it will have no effect
if(column.sWidthOrig&&scrollX){$(headerCells[i]).append($('<div/>').css({width:column.sWidthOrig,margin:0,padding:0,border:0,height:1}));}}// Find the widest cell for each column and put it into the table
if(oSettings.aoData.length){for(i=0;i<visibleColumns.length;i++){columnIdx=visibleColumns[i];column=columns[columnIdx];$(_fnGetWidestNode(oSettings,columnIdx)).clone(false).append(column.sContentPadding).appendTo(tr);}}// Tidy the temporary table - remove name attributes so there aren't
// duplicated in the dom (radio elements for example)
$('[name]',tmpTable).removeAttr('name');// Table has been built, attach to the document so we can work with it.
// A holding element is used, positioned at the top of the container
// with minimal height, so it has no effect on if the container scrolls
// or not. Otherwise it might trigger scrolling when it actually isn't
// needed
var holder=$('<div/>').css(scrollX||scrollY?{position:'absolute',top:0,left:0,height:1,right:0,overflow:'hidden'}:{}).append(tmpTable).appendTo(tableContainer);// When scrolling (X or Y) we want to set the width of the table as
// appropriate. However, when not scrolling leave the table width as it
// is. This results in slightly different, but I think correct behaviour
if(scrollX&&scrollXInner){tmpTable.width(scrollXInner);}else if(scrollX){tmpTable.css('width','auto');tmpTable.removeAttr('width');// If there is no width attribute or style, then allow the table to
// collapse
if(tmpTable.width()<tableContainer.clientWidth&&tableWidthAttr){tmpTable.width(tableContainer.clientWidth);}}else if(scrollY){tmpTable.width(tableContainer.clientWidth);}else if(tableWidthAttr){tmpTable.width(tableWidthAttr);}// Get the width of each column in the constructed table - we need to
// know the inner width (so it can be assigned to the other table's
// cells) and the outer width so we can calculate the full width of the
// table. This is safe since DataTables requires a unique cell for each
// column, but if ever a header can span multiple columns, this will
// need to be modified.
var total=0;for(i=0;i<visibleColumns.length;i++){var cell=$(headerCells[i]);var border=cell.outerWidth()-cell.width();// Use getBounding... where possible (not IE8-) because it can give
// sub-pixel accuracy, which we then want to round up!
var bounding=browser.bBounding?Math.ceil(headerCells[i].getBoundingClientRect().width):cell.outerWidth();// Total is tracked to remove any sub-pixel errors as the outerWidth
// of the table might not equal the total given here (IE!).
total+=bounding;// Width for each column to use
columns[visibleColumns[i]].sWidth=_fnStringToCss(bounding-border);}table.style.width=_fnStringToCss(total);// Finished with the table - ditch it
holder.remove();}// If there is a width attr, we want to attach an event listener which
// allows the table sizing to automatically adjust when the window is
// resized. Use the width attr rather than CSS, since we can't know if the
// CSS is a relative value or absolute - DOM read is always px.
if(tableWidthAttr){table.style.width=_fnStringToCss(tableWidthAttr);}if((tableWidthAttr||scrollX)&&!oSettings._reszEvt){var bindResize=function bindResize(){$(window).on('resize.DT-'+oSettings.sInstance,_fnThrottle(function(){_fnAdjustColumnSizing(oSettings);}));};// IE6/7 will crash if we bind a resize event handler on page load.
// To be removed in 1.11 which drops IE6/7 support
if(ie67){setTimeout(bindResize,1000);}else{bindResize();}oSettings._reszEvt=true;}}/**
     * Throttle the calls to a function. Arguments and context are maintained for
     * the throttled function
     *  @param {function} fn Function to be called
     *  @param {int} [freq=200] call frequency in mS
     *  @returns {function} wrapped function
     *  @memberof DataTable#oApi
     */var _fnThrottle=DataTable.util.throttle;/**
     * Convert a CSS unit width to pixels (e.g. 2em)
     *  @param {string} width width to be converted
     *  @param {node} parent parent to get the with for (required for relative widths) - optional
     *  @returns {int} width in pixels
     *  @memberof DataTable#oApi
     */function _fnConvertToWidth(width,parent){if(!width){return 0;}var n=$('<div/>').css('width',_fnStringToCss(width)).appendTo(parent||document.body);var val=n[0].offsetWidth;n.remove();return val;}/**
     * Get the widest node
     *  @param {object} settings dataTables settings object
     *  @param {int} colIdx column of interest
     *  @returns {node} widest table node
     *  @memberof DataTable#oApi
     */function _fnGetWidestNode(settings,colIdx){var idx=_fnGetMaxLenString(settings,colIdx);if(idx<0){return null;}var data=settings.aoData[idx];return!data.nTr?// Might not have been created when deferred rendering
$('<td/>').html(_fnGetCellData(settings,idx,colIdx,'display'))[0]:data.anCells[colIdx];}/**
     * Get the maximum strlen for each data column
     *  @param {object} settings dataTables settings object
     *  @param {int} colIdx column of interest
     *  @returns {string} max string length for each column
     *  @memberof DataTable#oApi
     */function _fnGetMaxLenString(settings,colIdx){var s,max=-1,maxIdx=-1;for(var i=0,ien=settings.aoData.length;i<ien;i++){s=_fnGetCellData(settings,i,colIdx,'display')+'';s=s.replace(__re_html_remove,'');s=s.replace(/&nbsp;/g,' ');if(s.length>max){max=s.length;maxIdx=i;}}return maxIdx;}/**
     * Append a CSS unit (only if required) to a string
     *  @param {string} value to css-ify
     *  @returns {string} value with css unit
     *  @memberof DataTable#oApi
     */function _fnStringToCss(s){if(s===null){return'0px';}if(typeof s=='number'){return s<0?'0px':s+'px';}// Check it has a unit character already
return s.match(/\d$/)?s+'px':s;}function _fnSortFlatten(settings){var i,iLen,k,kLen,aSort=[],aiOrig=[],aoColumns=settings.aoColumns,aDataSort,iCol,sType,srcCol,fixed=settings.aaSortingFixed,fixedObj=$.isPlainObject(fixed),nestedSort=[],add=function add(a){if(a.length&&!$.isArray(a[0])){// 1D array
nestedSort.push(a);}else{// 2D array
$.merge(nestedSort,a);}};// Build the sort array, with pre-fix and post-fix options if they have been
// specified
if($.isArray(fixed)){add(fixed);}if(fixedObj&&fixed.pre){add(fixed.pre);}add(settings.aaSorting);if(fixedObj&&fixed.post){add(fixed.post);}for(i=0;i<nestedSort.length;i++){srcCol=nestedSort[i][0];aDataSort=aoColumns[srcCol].aDataSort;for(k=0,kLen=aDataSort.length;k<kLen;k++){iCol=aDataSort[k];sType=aoColumns[iCol].sType||'string';if(nestedSort[i]._idx===undefined){nestedSort[i]._idx=$.inArray(nestedSort[i][1],aoColumns[iCol].asSorting);}aSort.push({src:srcCol,col:iCol,dir:nestedSort[i][1],index:nestedSort[i]._idx,type:sType,formatter:DataTable.ext.type.order[sType+"-pre"]});}}return aSort;}/**
     * Change the order of the table
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     *  @todo This really needs split up!
     */function _fnSort(oSettings){var i,ien,iLen,j,jLen,k,kLen,sDataType,nTh,aiOrig=[],oExtSort=DataTable.ext.type.order,aoData=oSettings.aoData,aoColumns=oSettings.aoColumns,aDataSort,data,iCol,sType,oSort,formatters=0,sortCol,displayMaster=oSettings.aiDisplayMaster,aSort;// Resolve any column types that are unknown due to addition or invalidation
// @todo Can this be moved into a 'data-ready' handler which is called when
//   data is going to be used in the table?
_fnColumnTypes(oSettings);aSort=_fnSortFlatten(oSettings);for(i=0,ien=aSort.length;i<ien;i++){sortCol=aSort[i];// Track if we can use the fast sort algorithm
if(sortCol.formatter){formatters++;}// Load the data needed for the sort, for each cell
_fnSortData(oSettings,sortCol.col);}/* No sorting required if server-side or no sorting array */if(_fnDataSource(oSettings)!='ssp'&&aSort.length!==0){// Create a value - key array of the current row positions such that we can use their
// current position during the sort, if values match, in order to perform stable sorting
for(i=0,iLen=displayMaster.length;i<iLen;i++){aiOrig[displayMaster[i]]=i;}/* Do the sort - here we want multi-column sorting based on a given data source (column)
			 * and sorting function (from oSort) in a certain direction. It's reasonably complex to
			 * follow on it's own, but this is what we want (example two column sorting):
			 *  fnLocalSorting = function(a,b){
			 *    var iTest;
			 *    iTest = oSort['string-asc']('data11', 'data12');
			 *      if (iTest !== 0)
			 *        return iTest;
			 *    iTest = oSort['numeric-desc']('data21', 'data22');
			 *    if (iTest !== 0)
			 *      return iTest;
			 *    return oSort['numeric-asc']( aiOrig[a], aiOrig[b] );
			 *  }
			 * Basically we have a test for each sorting column, if the data in that column is equal,
			 * test the next column. If all columns match, then we use a numeric sort on the row
			 * positions in the original data array to provide a stable sort.
			 *
			 * Note - I know it seems excessive to have two sorting methods, but the first is around
			 * 15% faster, so the second is only maintained for backwards compatibility with sorting
			 * methods which do not have a pre-sort formatting function.
			 */if(formatters===aSort.length){// All sort types have formatting functions
displayMaster.sort(function(a,b){var x,y,k,test,sort,len=aSort.length,dataA=aoData[a]._aSortData,dataB=aoData[b]._aSortData;for(k=0;k<len;k++){sort=aSort[k];x=dataA[sort.col];y=dataB[sort.col];test=x<y?-1:x>y?1:0;if(test!==0){return sort.dir==='asc'?test:-test;}}x=aiOrig[a];y=aiOrig[b];return x<y?-1:x>y?1:0;});}else{// Depreciated - remove in 1.11 (providing a plug-in option)
// Not all sort types have formatting methods, so we have to call their sorting
// methods.
displayMaster.sort(function(a,b){var x,y,k,l,test,sort,fn,len=aSort.length,dataA=aoData[a]._aSortData,dataB=aoData[b]._aSortData;for(k=0;k<len;k++){sort=aSort[k];x=dataA[sort.col];y=dataB[sort.col];fn=oExtSort[sort.type+"-"+sort.dir]||oExtSort["string-"+sort.dir];test=fn(x,y);if(test!==0){return test;}}x=aiOrig[a];y=aiOrig[b];return x<y?-1:x>y?1:0;});}}/* Tell the draw function that we have sorted the data */oSettings.bSorted=true;}function _fnSortAria(settings){var label;var nextSort;var columns=settings.aoColumns;var aSort=_fnSortFlatten(settings);var oAria=settings.oLanguage.oAria;// ARIA attributes - need to loop all columns, to update all (removing old
// attributes as needed)
for(var i=0,iLen=columns.length;i<iLen;i++){var col=columns[i];var asSorting=col.asSorting;var sTitle=col.sTitle.replace(/<.*?>/g,"");var th=col.nTh;// IE7 is throwing an error when setting these properties with jQuery's
// attr() and removeAttr() methods...
th.removeAttribute('aria-sort');/* In ARIA only the first sorting column can be marked as sorting - no multi-sort option */if(col.bSortable){if(aSort.length>0&&aSort[0].col==i){th.setAttribute('aria-sort',aSort[0].dir=="asc"?"ascending":"descending");nextSort=asSorting[aSort[0].index+1]||asSorting[0];}else{nextSort=asSorting[0];}label=sTitle+(nextSort==="asc"?oAria.sSortAscending:oAria.sSortDescending);}else{label=sTitle;}th.setAttribute('aria-label',label);}}/**
     * Function to run on user sort request
     *  @param {object} settings dataTables settings object
     *  @param {node} attachTo node to attach the handler to
     *  @param {int} colIdx column sorting index
     *  @param {boolean} [append=false] Append the requested sort to the existing
     *    sort if true (i.e. multi-column sort)
     *  @param {function} [callback] callback function
     *  @memberof DataTable#oApi
     */function _fnSortListener(settings,colIdx,append,callback){var col=settings.aoColumns[colIdx];var sorting=settings.aaSorting;var asSorting=col.asSorting;var nextSortIdx;var next=function next(a,overflow){var idx=a._idx;if(idx===undefined){idx=$.inArray(a[1],asSorting);}return idx+1<asSorting.length?idx+1:overflow?null:0;};// Convert to 2D array if needed
if(typeof sorting[0]==='number'){sorting=settings.aaSorting=[sorting];}// If appending the sort then we are multi-column sorting
if(append&&settings.oFeatures.bSortMulti){// Are we already doing some kind of sort on this column?
var sortIdx=$.inArray(colIdx,_pluck(sorting,'0'));if(sortIdx!==-1){// Yes, modify the sort
nextSortIdx=next(sorting[sortIdx],true);if(nextSortIdx===null&&sorting.length===1){nextSortIdx=0;// can't remove sorting completely
}if(nextSortIdx===null){sorting.splice(sortIdx,1);}else{sorting[sortIdx][1]=asSorting[nextSortIdx];sorting[sortIdx]._idx=nextSortIdx;}}else{// No sort on this column yet
sorting.push([colIdx,asSorting[0],0]);sorting[sorting.length-1]._idx=0;}}else if(sorting.length&&sorting[0][0]==colIdx){// Single column - already sorting on this column, modify the sort
nextSortIdx=next(sorting[0]);sorting.length=1;sorting[0][1]=asSorting[nextSortIdx];sorting[0]._idx=nextSortIdx;}else{// Single column - sort only on this column
sorting.length=0;sorting.push([colIdx,asSorting[0]]);sorting[0]._idx=0;}// Run the sort by calling a full redraw
_fnReDraw(settings);// callback used for async user interaction
if(typeof callback=='function'){callback(settings);}}/**
     * Attach a sort handler (click) to a node
     *  @param {object} settings dataTables settings object
     *  @param {node} attachTo node to attach the handler to
     *  @param {int} colIdx column sorting index
     *  @param {function} [callback] callback function
     *  @memberof DataTable#oApi
     */function _fnSortAttachListener(settings,attachTo,colIdx,callback){var col=settings.aoColumns[colIdx];_fnBindAction(attachTo,{},function(e){/* If the column is not sortable - don't to anything */if(col.bSortable===false){return;}// If processing is enabled use a timeout to allow the processing
// display to be shown - otherwise to it synchronously
if(settings.oFeatures.bProcessing){_fnProcessingDisplay(settings,true);setTimeout(function(){_fnSortListener(settings,colIdx,e.shiftKey,callback);// In server-side processing, the draw callback will remove the
// processing display
if(_fnDataSource(settings)!=='ssp'){_fnProcessingDisplay(settings,false);}},0);}else{_fnSortListener(settings,colIdx,e.shiftKey,callback);}});}/**
     * Set the sorting classes on table's body, Note: it is safe to call this function
     * when bSort and bSortClasses are false
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnSortingClasses(settings){var oldSort=settings.aLastSort;var sortClass=settings.oClasses.sSortColumn;var sort=_fnSortFlatten(settings);var features=settings.oFeatures;var i,ien,colIdx;if(features.bSort&&features.bSortClasses){// Remove old sorting classes
for(i=0,ien=oldSort.length;i<ien;i++){colIdx=oldSort[i].src;// Remove column sorting
$(_pluck(settings.aoData,'anCells',colIdx)).removeClass(sortClass+(i<2?i+1:3));}// Add new column sorting
for(i=0,ien=sort.length;i<ien;i++){colIdx=sort[i].src;$(_pluck(settings.aoData,'anCells',colIdx)).addClass(sortClass+(i<2?i+1:3));}}settings.aLastSort=sort;}// Get the data to sort a column, be it from cache, fresh (populating the
// cache), or from a sort formatter
function _fnSortData(settings,idx){// Custom sorting function - provided by the sort data type
var column=settings.aoColumns[idx];var customSort=DataTable.ext.order[column.sSortDataType];var customData;if(customSort){customData=customSort.call(settings.oInstance,settings,idx,_fnColumnIndexToVisible(settings,idx));}// Use / populate cache
var row,cellData;var formatter=DataTable.ext.type.order[column.sType+"-pre"];for(var i=0,ien=settings.aoData.length;i<ien;i++){row=settings.aoData[i];if(!row._aSortData){row._aSortData=[];}if(!row._aSortData[idx]||customSort){cellData=customSort?customData[i]:// If there was a custom sort function, use data from there
_fnGetCellData(settings,i,idx,'sort');row._aSortData[idx]=formatter?formatter(cellData):cellData;}}}/**
     * Save the state of a table
     *  @param {object} oSettings dataTables settings object
     *  @memberof DataTable#oApi
     */function _fnSaveState(settings){if(!settings.oFeatures.bStateSave||settings.bDestroying){return;}/* Store the interesting variables */var state={time:+new Date(),start:settings._iDisplayStart,length:settings._iDisplayLength,order:$.extend(true,[],settings.aaSorting),search:_fnSearchToCamel(settings.oPreviousSearch),columns:$.map(settings.aoColumns,function(col,i){return{visible:col.bVisible,search:_fnSearchToCamel(settings.aoPreSearchCols[i])};})};_fnCallbackFire(settings,"aoStateSaveParams",'stateSaveParams',[settings,state]);settings.oSavedState=state;settings.fnStateSaveCallback.call(settings.oInstance,settings,state);}/**
     * Attempt to load a saved table state
     *  @param {object} oSettings dataTables settings object
     *  @param {object} oInit DataTables init object so we can override settings
     *  @param {function} callback Callback to execute when the state has been loaded
     *  @memberof DataTable#oApi
     */function _fnLoadState(settings,oInit,callback){var i,ien;var columns=settings.aoColumns;var loaded=function loaded(s){if(!s||!s.time){callback();return;}// Allow custom and plug-in manipulation functions to alter the saved data set and
// cancelling of loading by returning false
var abStateLoad=_fnCallbackFire(settings,'aoStateLoadParams','stateLoadParams',[settings,s]);if($.inArray(false,abStateLoad)!==-1){callback();return;}// Reject old data
var duration=settings.iStateDuration;if(duration>0&&s.time<+new Date()-duration*1000){callback();return;}// Number of columns have changed - all bets are off, no restore of settings
if(s.columns&&columns.length!==s.columns.length){callback();return;}// Store the saved state so it might be accessed at any time
settings.oLoadedState=$.extend(true,{},s);// Restore key features - todo - for 1.11 this needs to be done by
// subscribed events
if(s.start!==undefined){settings._iDisplayStart=s.start;settings.iInitDisplayStart=s.start;}if(s.length!==undefined){settings._iDisplayLength=s.length;}// Order
if(s.order!==undefined){settings.aaSorting=[];$.each(s.order,function(i,col){settings.aaSorting.push(col[0]>=columns.length?[0,col[1]]:col);});}// Search
if(s.search!==undefined){$.extend(settings.oPreviousSearch,_fnSearchToHung(s.search));}// Columns
//
if(s.columns){for(i=0,ien=s.columns.length;i<ien;i++){var col=s.columns[i];// Visibility
if(col.visible!==undefined){columns[i].bVisible=col.visible;}// Search
if(col.search!==undefined){$.extend(settings.aoPreSearchCols[i],_fnSearchToHung(col.search));}}}_fnCallbackFire(settings,'aoStateLoaded','stateLoaded',[settings,s]);callback();};if(!settings.oFeatures.bStateSave){callback();return;}var state=settings.fnStateLoadCallback.call(settings.oInstance,settings,loaded);if(state!==undefined){loaded(state);}// otherwise, wait for the loaded callback to be executed
}/**
     * Return the settings object for a particular table
     *  @param {node} table table we are using as a dataTable
     *  @returns {object} Settings object - or null if not found
     *  @memberof DataTable#oApi
     */function _fnSettingsFromNode(table){var settings=DataTable.settings;var idx=$.inArray(table,_pluck(settings,'nTable'));return idx!==-1?settings[idx]:null;}/**
     * Log an error message
     *  @param {object} settings dataTables settings object
     *  @param {int} level log error messages, or display them to the user
     *  @param {string} msg error message
     *  @param {int} tn Technical note id to get more information about the error.
     *  @memberof DataTable#oApi
     */function _fnLog(settings,level,msg,tn){msg='DataTables warning: '+(settings?'table id='+settings.sTableId+' - ':'')+msg;if(tn){msg+='. For more information about this error, please see '+'http://datatables.net/tn/'+tn;}if(!level){// Backwards compatibility pre 1.10
var ext=DataTable.ext;var type=ext.sErrMode||ext.errMode;if(settings){_fnCallbackFire(settings,null,'error',[settings,tn,msg]);}if(type=='alert'){alert(msg);}else if(type=='throw'){throw new Error(msg);}else if(typeof type=='function'){type(settings,tn,msg);}}else if(window.console&&console.log){console.log(msg);}}/**
     * See if a property is defined on one object, if so assign it to the other object
     *  @param {object} ret target object
     *  @param {object} src source object
     *  @param {string} name property
     *  @param {string} [mappedName] name to map too - optional, name used if not given
     *  @memberof DataTable#oApi
     */function _fnMap(ret,src,name,mappedName){if($.isArray(name)){$.each(name,function(i,val){if($.isArray(val)){_fnMap(ret,src,val[0],val[1]);}else{_fnMap(ret,src,val);}});return;}if(mappedName===undefined){mappedName=name;}if(src[name]!==undefined){ret[mappedName]=src[name];}}/**
     * Extend objects - very similar to jQuery.extend, but deep copy objects, and
     * shallow copy arrays. The reason we need to do this, is that we don't want to
     * deep copy array init values (such as aaSorting) since the dev wouldn't be
     * able to override them, but we do want to deep copy arrays.
     *  @param {object} out Object to extend
     *  @param {object} extender Object from which the properties will be applied to
     *      out
     *  @param {boolean} breakRefs If true, then arrays will be sliced to take an
     *      independent copy with the exception of the `data` or `aaData` parameters
     *      if they are present. This is so you can pass in a collection to
     *      DataTables and have that used as your data source without breaking the
     *      references
     *  @returns {object} out Reference, just for convenience - out === the return.
     *  @memberof DataTable#oApi
     *  @todo This doesn't take account of arrays inside the deep copied objects.
     */function _fnExtend(out,extender,breakRefs){var val;for(var prop in extender){if(extender.hasOwnProperty(prop)){val=extender[prop];if($.isPlainObject(val)){if(!$.isPlainObject(out[prop])){out[prop]={};}$.extend(true,out[prop],val);}else if(breakRefs&&prop!=='data'&&prop!=='aaData'&&$.isArray(val)){out[prop]=val.slice();}else{out[prop]=val;}}}return out;}/**
     * Bind an event handers to allow a click or return key to activate the callback.
     * This is good for accessibility since a return on the keyboard will have the
     * same effect as a click, if the element has focus.
     *  @param {element} n Element to bind the action to
     *  @param {object} oData Data object to pass to the triggered function
     *  @param {function} fn Callback function for when the event is triggered
     *  @memberof DataTable#oApi
     */function _fnBindAction(n,oData,fn){$(n).on('click.DT',oData,function(e){$(n).blur();// Remove focus outline for mouse users
fn(e);}).on('keypress.DT',oData,function(e){if(e.which===13){e.preventDefault();fn(e);}}).on('selectstart.DT',function(){/* Take the brutal approach to cancelling text selection */return false;});}/**
     * Register a callback function. Easily allows a callback function to be added to
     * an array store of callback functions that can then all be called together.
     *  @param {object} oSettings dataTables settings object
     *  @param {string} sStore Name of the array storage for the callbacks in oSettings
     *  @param {function} fn Function to be called back
     *  @param {string} sName Identifying name for the callback (i.e. a label)
     *  @memberof DataTable#oApi
     */function _fnCallbackReg(oSettings,sStore,fn,sName){if(fn){oSettings[sStore].push({"fn":fn,"sName":sName});}}/**
     * Fire callback functions and trigger events. Note that the loop over the
     * callback array store is done backwards! Further note that you do not want to
     * fire off triggers in time sensitive applications (for example cell creation)
     * as its slow.
     *  @param {object} settings dataTables settings object
     *  @param {string} callbackArr Name of the array storage for the callbacks in
     *      oSettings
     *  @param {string} eventName Name of the jQuery custom event to trigger. If
     *      null no trigger is fired
     *  @param {array} args Array of arguments to pass to the callback function /
     *      trigger
     *  @memberof DataTable#oApi
     */function _fnCallbackFire(settings,callbackArr,eventName,args){var ret=[];if(callbackArr){ret=$.map(settings[callbackArr].slice().reverse(),function(val,i){return val.fn.apply(settings.oInstance,args);});}if(eventName!==null){var e=$.Event(eventName+'.dt');$(settings.nTable).trigger(e,args);ret.push(e.result);}return ret;}function _fnLengthOverflow(settings){var start=settings._iDisplayStart,end=settings.fnDisplayEnd(),len=settings._iDisplayLength;/* If we have space to show extra rows (backing up from the end point - then do so */if(start>=end){start=end-len;}// Keep the start record on the current page
start-=start%len;if(len===-1||start<0){start=0;}settings._iDisplayStart=start;}function _fnRenderer(settings,type){var renderer=settings.renderer;var host=DataTable.ext.renderer[type];if($.isPlainObject(renderer)&&renderer[type]){// Specific renderer for this type. If available use it, otherwise use
// the default.
return host[renderer[type]]||host._;}else if(typeof renderer==='string'){// Common renderer - if there is one available for this type use it,
// otherwise use the default
return host[renderer]||host._;}// Use the default
return host._;}/**
     * Detect the data source being used for the table. Used to simplify the code
     * a little (ajax) and to make it compress a little smaller.
     *
     *  @param {object} settings dataTables settings object
     *  @returns {string} Data source
     *  @memberof DataTable#oApi
     */function _fnDataSource(settings){if(settings.oFeatures.bServerSide){return'ssp';}else if(settings.ajax||settings.sAjaxSource){return'ajax';}return'dom';}/**
     * Computed structure of the DataTables API, defined by the options passed to
     * `DataTable.Api.register()` when building the API.
     *
     * The structure is built in order to speed creation and extension of the Api
     * objects since the extensions are effectively pre-parsed.
     *
     * The array is an array of objects with the following structure, where this
     * base array represents the Api prototype base:
     *
     *     [
     *       {
     *         name:      'data'                -- string   - Property name
     *         val:       function () {},       -- function - Api method (or undefined if just an object
     *         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
     *         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
     *       },
     *       {
     *         name:     'row'
     *         val:       {},
     *         methodExt: [ ... ],
     *         propExt:   [
     *           {
     *             name:      'data'
     *             val:       function () {},
     *             methodExt: [ ... ],
     *             propExt:   [ ... ]
     *           },
     *           ...
     *         ]
     *       }
     *     ]
     *
     * @type {Array}
     * @ignore
     */var __apiStruct=[];/**
     * `Array.prototype` reference.
     *
     * @type object
     * @ignore
     */var __arrayProto=Array.prototype;/**
     * Abstraction for `context` parameter of the `Api` constructor to allow it to
     * take several different forms for ease of use.
     *
     * Each of the input parameter types will be converted to a DataTables settings
     * object where possible.
     *
     * @param  {string|node|jQuery|object} mixed DataTable identifier. Can be one
     *   of:
     *
     *   * `string` - jQuery selector. Any DataTables' matching the given selector
     *     with be found and used.
     *   * `node` - `TABLE` node which has already been formed into a DataTable.
     *   * `jQuery` - A jQuery object of `TABLE` nodes.
     *   * `object` - DataTables settings object
     *   * `DataTables.Api` - API instance
     * @return {array|null} Matching DataTables settings objects. `null` or
     *   `undefined` is returned if no matching DataTable is found.
     * @ignore
     */var _toSettings=function _toSettings(mixed){var idx,jq;var settings=DataTable.settings;var tables=$.map(settings,function(el,i){return el.nTable;});if(!mixed){return[];}else if(mixed.nTable&&mixed.oApi){// DataTables settings object
return[mixed];}else if(mixed.nodeName&&mixed.nodeName.toLowerCase()==='table'){// Table node
idx=$.inArray(mixed,tables);return idx!==-1?[settings[idx]]:null;}else if(mixed&&typeof mixed.settings==='function'){return mixed.settings().toArray();}else if(typeof mixed==='string'){// jQuery selector
jq=$(mixed);}else if(mixed instanceof $){// jQuery object (also DataTables instance)
jq=mixed;}if(jq){return jq.map(function(i){idx=$.inArray(this,tables);return idx!==-1?settings[idx]:null;}).toArray();}};/**
     * DataTables API class - used to control and interface with  one or more
     * DataTables enhanced tables.
     *
     * The API class is heavily based on jQuery, presenting a chainable interface
     * that you can use to interact with tables. Each instance of the API class has
     * a "context" - i.e. the tables that it will operate on. This could be a single
     * table, all tables on a page or a sub-set thereof.
     *
     * Additionally the API is designed to allow you to easily work with the data in
     * the tables, retrieving and manipulating it as required. This is done by
     * presenting the API class as an array like interface. The contents of the
     * array depend upon the actions requested by each method (for example
     * `rows().nodes()` will return an array of nodes, while `rows().data()` will
     * return an array of objects or arrays depending upon your table's
     * configuration). The API object has a number of array like methods (`push`,
     * `pop`, `reverse` etc) as well as additional helper methods (`each`, `pluck`,
     * `unique` etc) to assist your working with the data held in a table.
     *
     * Most methods (those which return an Api instance) are chainable, which means
     * the return from a method call also has all of the methods available that the
     * top level object had. For example, these two calls are equivalent:
     *
     *     // Not chained
     *     api.row.add( {...} );
     *     api.draw();
     *
     *     // Chained
     *     api.row.add( {...} ).draw();
     *
     * @class DataTable.Api
     * @param {array|object|string|jQuery} context DataTable identifier. This is
     *   used to define which DataTables enhanced tables this API will operate on.
     *   Can be one of:
     *
     *   * `string` - jQuery selector. Any DataTables' matching the given selector
     *     with be found and used.
     *   * `node` - `TABLE` node which has already been formed into a DataTable.
     *   * `jQuery` - A jQuery object of `TABLE` nodes.
     *   * `object` - DataTables settings object
     * @param {array} [data] Data to initialise the Api instance with.
     *
     * @example
     *   // Direct initialisation during DataTables construction
     *   var api = $('#example').DataTable();
     *
     * @example
     *   // Initialisation using a DataTables jQuery object
     *   var api = $('#example').dataTable().api();
     *
     * @example
     *   // Initialisation as a constructor
     *   var api = new $.fn.DataTable.Api( 'table.dataTable' );
     */_Api2=function _Api(context,data){if(!(this instanceof _Api2)){return new _Api2(context,data);}var settings=[];var ctxSettings=function ctxSettings(o){var a=_toSettings(o);if(a){settings=settings.concat(a);}};if($.isArray(context)){for(var i=0,ien=context.length;i<ien;i++){ctxSettings(context[i]);}}else{ctxSettings(context);}// Remove duplicates
this.context=_unique(settings);// Initial data
if(data){$.merge(this,data);}// selector
this.selector={rows:null,cols:null,opts:null};_Api2.extend(this,this,__apiStruct);};DataTable.Api=_Api2;// Don't destroy the existing prototype, just extend it. Required for jQuery 2's
// isPlainObject.
$.extend(_Api2.prototype,{any:function any(){return this.count()!==0;},concat:__arrayProto.concat,context:[],// array of table settings objects
count:function count(){return this.flatten().length;},each:function each(fn){for(var i=0,ien=this.length;i<ien;i++){fn.call(this,this[i],i,this);}return this;},eq:function eq(idx){var ctx=this.context;return ctx.length>idx?new _Api2(ctx[idx],this[idx]):null;},filter:function filter(fn){var a=[];if(__arrayProto.filter){a=__arrayProto.filter.call(this,fn,this);}else{// Compatibility for browsers without EMCA-252-5 (JS 1.6)
for(var i=0,ien=this.length;i<ien;i++){if(fn.call(this,this[i],i,this)){a.push(this[i]);}}}return new _Api2(this.context,a);},flatten:function flatten(){var a=[];return new _Api2(this.context,a.concat.apply(a,this.toArray()));},join:__arrayProto.join,indexOf:__arrayProto.indexOf||function(obj,start){for(var i=start||0,ien=this.length;i<ien;i++){if(this[i]===obj){return i;}}return-1;},iterator:function iterator(flatten,type,fn,alwaysNew){var a=[],ret,i,ien,j,jen,context=this.context,rows,items,item,selector=this.selector;// Argument shifting
if(typeof flatten==='string'){alwaysNew=fn;fn=type;type=flatten;flatten=false;}for(i=0,ien=context.length;i<ien;i++){var apiInst=new _Api2(context[i]);if(type==='table'){ret=fn.call(apiInst,context[i],i);if(ret!==undefined){a.push(ret);}}else if(type==='columns'||type==='rows'){// this has same length as context - one entry for each table
ret=fn.call(apiInst,context[i],this[i],i);if(ret!==undefined){a.push(ret);}}else if(type==='column'||type==='column-rows'||type==='row'||type==='cell'){// columns and rows share the same structure.
// 'this' is an array of column indexes for each context
items=this[i];if(type==='column-rows'){rows=_selector_row_indexes(context[i],selector.opts);}for(j=0,jen=items.length;j<jen;j++){item=items[j];if(type==='cell'){ret=fn.call(apiInst,context[i],item.row,item.column,i,j);}else{ret=fn.call(apiInst,context[i],item,i,j,rows);}if(ret!==undefined){a.push(ret);}}}}if(a.length||alwaysNew){var api=new _Api2(context,flatten?a.concat.apply([],a):a);var apiSelector=api.selector;apiSelector.rows=selector.rows;apiSelector.cols=selector.cols;apiSelector.opts=selector.opts;return api;}return this;},lastIndexOf:__arrayProto.lastIndexOf||function(obj,start){// Bit cheeky...
return this.indexOf.apply(this.toArray.reverse(),arguments);},length:0,map:function map(fn){var a=[];if(__arrayProto.map){a=__arrayProto.map.call(this,fn,this);}else{// Compatibility for browsers without EMCA-252-5 (JS 1.6)
for(var i=0,ien=this.length;i<ien;i++){a.push(fn.call(this,this[i],i));}}return new _Api2(this.context,a);},pluck:function pluck(prop){return this.map(function(el){return el[prop];});},pop:__arrayProto.pop,push:__arrayProto.push,// Does not return an API instance
reduce:__arrayProto.reduce||function(fn,init){return _fnReduce(this,fn,init,0,this.length,1);},reduceRight:__arrayProto.reduceRight||function(fn,init){return _fnReduce(this,fn,init,this.length-1,-1,-1);},reverse:__arrayProto.reverse,// Object with rows, columns and opts
selector:null,shift:__arrayProto.shift,slice:function slice(){return new _Api2(this.context,this);},sort:__arrayProto.sort,// ? name - order?
splice:__arrayProto.splice,toArray:function toArray(){return __arrayProto.slice.call(this);},to$:function to$(){return $(this);},toJQuery:function toJQuery(){return $(this);},unique:function unique(){return new _Api2(this.context,_unique(this));},unshift:__arrayProto.unshift});_Api2.extend=function(scope,obj,ext){// Only extend API instances and static properties of the API
if(!ext.length||!obj||!(obj instanceof _Api2)&&!obj.__dt_wrapper){return;}var i,ien,j,jen,struct,inner,methodScoping=function methodScoping(scope,fn,struc){return function(){var ret=fn.apply(scope,arguments);// Method extension
_Api2.extend(ret,ret,struc.methodExt);return ret;};};for(i=0,ien=ext.length;i<ien;i++){struct=ext[i];// Value
obj[struct.name]=typeof struct.val==='function'?methodScoping(scope,struct.val,struct):$.isPlainObject(struct.val)?{}:struct.val;obj[struct.name].__dt_wrapper=true;// Property extension
_Api2.extend(scope,obj[struct.name],struct.propExt);}};// @todo - Is there need for an augment function?
// _Api.augment = function ( inst, name )
// {
// 	// Find src object in the structure from the name
// 	var parts = name.split('.');
// 	_Api.extend( inst, obj );
// };
//     [
//       {
//         name:      'data'                -- string   - Property name
//         val:       function () {},       -- function - Api method (or undefined if just an object
//         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
//         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
//       },
//       {
//         name:     'row'
//         val:       {},
//         methodExt: [ ... ],
//         propExt:   [
//           {
//             name:      'data'
//             val:       function () {},
//             methodExt: [ ... ],
//             propExt:   [ ... ]
//           },
//           ...
//         ]
//       }
//     ]
_Api2.register=_api_register=function _api_register(name,val){if($.isArray(name)){for(var j=0,jen=name.length;j<jen;j++){_Api2.register(name[j],val);}return;}var i,ien,heir=name.split('.'),struct=__apiStruct,key,method;var find=function find(src,name){for(var i=0,ien=src.length;i<ien;i++){if(src[i].name===name){return src[i];}}return null;};for(i=0,ien=heir.length;i<ien;i++){method=heir[i].indexOf('()')!==-1;key=method?heir[i].replace('()',''):heir[i];var src=find(struct,key);if(!src){src={name:key,val:{},methodExt:[],propExt:[]};struct.push(src);}if(i===ien-1){src.val=val;}else{struct=method?src.methodExt:src.propExt;}}};_Api2.registerPlural=_api_registerPlural=function _api_registerPlural(pluralName,singularName,val){_Api2.register(pluralName,val);_Api2.register(singularName,function(){var ret=val.apply(this,arguments);if(ret===this){// Returned item is the API instance that was passed in, return it
return this;}else if(ret instanceof _Api2){// New API instance returned, want the value from the first item
// in the returned array for the singular result.
return ret.length?$.isArray(ret[0])?new _Api2(ret.context,ret[0]):// Array results are 'enhanced'
ret[0]:undefined;}// Non-API return - just fire it back
return ret;});};/**
     * Selector for HTML tables. Apply the given selector to the give array of
     * DataTables settings objects.
     *
     * @param {string|integer} [selector] jQuery selector string or integer
     * @param  {array} Array of DataTables settings objects to be filtered
     * @return {array}
     * @ignore
     */var __table_selector=function __table_selector(selector,a){// Integer is used to pick out a table by index
if(typeof selector==='number'){return[a[selector]];}// Perform a jQuery selector on the table nodes
var nodes=$.map(a,function(el,i){return el.nTable;});return $(nodes).filter(selector).map(function(i){// Need to translate back from the table node to the settings
var idx=$.inArray(this,nodes);return a[idx];}).toArray();};/**
     * Context selector for the API's context (i.e. the tables the API instance
     * refers to.
     *
     * @name    DataTable.Api#tables
     * @param {string|integer} [selector] Selector to pick which tables the iterator
     *   should operate on. If not given, all tables in the current context are
     *   used. This can be given as a jQuery selector (for example `':gt(0)'`) to
     *   select multiple tables or as an integer to select a single table.
     * @returns {DataTable.Api} Returns a new API instance if a selector is given.
     */_api_register('tables()',function(selector){// A new instance is created if there was a selector specified
return selector?new _Api2(__table_selector(selector,this.context)):this;});_api_register('table()',function(selector){var tables=this.tables(selector);var ctx=tables.context;// Truncate to the first matched table
return ctx.length?new _Api2(ctx[0]):tables;});_api_registerPlural('tables().nodes()','table().node()',function(){return this.iterator('table',function(ctx){return ctx.nTable;},1);});_api_registerPlural('tables().body()','table().body()',function(){return this.iterator('table',function(ctx){return ctx.nTBody;},1);});_api_registerPlural('tables().header()','table().header()',function(){return this.iterator('table',function(ctx){return ctx.nTHead;},1);});_api_registerPlural('tables().footer()','table().footer()',function(){return this.iterator('table',function(ctx){return ctx.nTFoot;},1);});_api_registerPlural('tables().containers()','table().container()',function(){return this.iterator('table',function(ctx){return ctx.nTableWrapper;},1);});/**
     * Redraw the tables in the current context.
     */_api_register('draw()',function(paging){return this.iterator('table',function(settings){if(paging==='page'){_fnDraw(settings);}else{if(typeof paging==='string'){paging=paging==='full-hold'?false:true;}_fnReDraw(settings,paging===false);}});});/**
     * Get the current page index.
     *
     * @return {integer} Current page index (zero based)
     */ /**
     * Set the current page.
     *
     * Note that if you attempt to show a page which does not exist, DataTables will
     * not throw an error, but rather reset the paging.
     *
     * @param {integer|string} action The paging action to take. This can be one of:
     *  * `integer` - The page index to jump to
     *  * `string` - An action to take:
     *    * `first` - Jump to first page.
     *    * `next` - Jump to the next page
     *    * `previous` - Jump to previous page
     *    * `last` - Jump to the last page.
     * @returns {DataTables.Api} this
     */_api_register('page()',function(action){if(action===undefined){return this.page.info().page;// not an expensive call
}// else, have an action to take on all tables
return this.iterator('table',function(settings){_fnPageChange(settings,action);});});/**
     * Paging information for the first table in the current context.
     *
     * If you require paging information for another table, use the `table()` method
     * with a suitable selector.
     *
     * @return {object} Object with the following properties set:
     *  * `page` - Current page index (zero based - i.e. the first page is `0`)
     *  * `pages` - Total number of pages
     *  * `start` - Display index for the first record shown on the current page
     *  * `end` - Display index for the last record shown on the current page
     *  * `length` - Display length (number of records). Note that generally `start
     *    + length = end`, but this is not always true, for example if there are
     *    only 2 records to show on the final page, with a length of 10.
     *  * `recordsTotal` - Full data set length
     *  * `recordsDisplay` - Data set length once the current filtering criterion
     *    are applied.
     */_api_register('page.info()',function(action){if(this.context.length===0){return undefined;}var settings=this.context[0],start=settings._iDisplayStart,len=settings.oFeatures.bPaginate?settings._iDisplayLength:-1,visRecords=settings.fnRecordsDisplay(),all=len===-1;return{"page":all?0:Math.floor(start/len),"pages":all?1:Math.ceil(visRecords/len),"start":start,"end":settings.fnDisplayEnd(),"length":len,"recordsTotal":settings.fnRecordsTotal(),"recordsDisplay":visRecords,"serverSide":_fnDataSource(settings)==='ssp'};});/**
     * Get the current page length.
     *
     * @return {integer} Current page length. Note `-1` indicates that all records
     *   are to be shown.
     */ /**
     * Set the current page length.
     *
     * @param {integer} Page length to set. Use `-1` to show all records.
     * @returns {DataTables.Api} this
     */_api_register('page.len()',function(len){// Note that we can't call this function 'length()' because `length`
// is a Javascript property of functions which defines how many arguments
// the function expects.
if(len===undefined){return this.context.length!==0?this.context[0]._iDisplayLength:undefined;}// else, set the page length
return this.iterator('table',function(settings){_fnLengthChange(settings,len);});});var __reload=function __reload(settings,holdPosition,callback){// Use the draw event to trigger a callback
if(callback){var api=new _Api2(settings);api.one('draw',function(){callback(api.ajax.json());});}if(_fnDataSource(settings)=='ssp'){_fnReDraw(settings,holdPosition);}else{_fnProcessingDisplay(settings,true);// Cancel an existing request
var xhr=settings.jqXHR;if(xhr&&xhr.readyState!==4){xhr.abort();}// Trigger xhr
_fnBuildAjax(settings,[],function(json){_fnClearTable(settings);var data=_fnAjaxDataSrc(settings,json);for(var i=0,ien=data.length;i<ien;i++){_fnAddData(settings,data[i]);}_fnReDraw(settings,holdPosition);_fnProcessingDisplay(settings,false);});}};/**
     * Get the JSON response from the last Ajax request that DataTables made to the
     * server. Note that this returns the JSON from the first table in the current
     * context.
     *
     * @return {object} JSON received from the server.
     */_api_register('ajax.json()',function(){var ctx=this.context;if(ctx.length>0){return ctx[0].json;}// else return undefined;
});/**
     * Get the data submitted in the last Ajax request
     */_api_register('ajax.params()',function(){var ctx=this.context;if(ctx.length>0){return ctx[0].oAjaxData;}// else return undefined;
});/**
     * Reload tables from the Ajax data source. Note that this function will
     * automatically re-draw the table when the remote data has been loaded.
     *
     * @param {boolean} [reset=true] Reset (default) or hold the current paging
     *   position. A full re-sort and re-filter is performed when this method is
     *   called, which is why the pagination reset is the default action.
     * @returns {DataTables.Api} this
     */_api_register('ajax.reload()',function(callback,resetPaging){return this.iterator('table',function(settings){__reload(settings,resetPaging===false,callback);});});/**
     * Get the current Ajax URL. Note that this returns the URL from the first
     * table in the current context.
     *
     * @return {string} Current Ajax source URL
     */ /**
     * Set the Ajax URL. Note that this will set the URL for all tables in the
     * current context.
     *
     * @param {string} url URL to set.
     * @returns {DataTables.Api} this
     */_api_register('ajax.url()',function(url){var ctx=this.context;if(url===undefined){// get
if(ctx.length===0){return undefined;}ctx=ctx[0];return ctx.ajax?$.isPlainObject(ctx.ajax)?ctx.ajax.url:ctx.ajax:ctx.sAjaxSource;}// set
return this.iterator('table',function(settings){if($.isPlainObject(settings.ajax)){settings.ajax.url=url;}else{settings.ajax=url;}// No need to consider sAjaxSource here since DataTables gives priority
// to `ajax` over `sAjaxSource`. So setting `ajax` here, renders any
// value of `sAjaxSource` redundant.
});});/**
     * Load data from the newly set Ajax URL. Note that this method is only
     * available when `ajax.url()` is used to set a URL. Additionally, this method
     * has the same effect as calling `ajax.reload()` but is provided for
     * convenience when setting a new URL. Like `ajax.reload()` it will
     * automatically redraw the table once the remote data has been loaded.
     *
     * @returns {DataTables.Api} this
     */_api_register('ajax.url().load()',function(callback,resetPaging){// Same as a reload, but makes sense to present it for easy access after a
// url change
return this.iterator('table',function(ctx){__reload(ctx,resetPaging===false,callback);});});var _selector_run=function _selector_run(type,selector,selectFn,settings,opts){var out=[],res,a,i,ien,j,jen,selectorType=_typeof(selector);// Can't just check for isArray here, as an API or jQuery instance might be
// given with their array like look
if(!selector||selectorType==='string'||selectorType==='function'||selector.length===undefined){selector=[selector];}for(i=0,ien=selector.length;i<ien;i++){// Only split on simple strings - complex expressions will be jQuery selectors
a=selector[i]&&selector[i].split&&!selector[i].match(/[\[\(:]/)?selector[i].split(','):[selector[i]];for(j=0,jen=a.length;j<jen;j++){res=selectFn(typeof a[j]==='string'?$.trim(a[j]):a[j]);if(res&&res.length){out=out.concat(res);}}}// selector extensions
var ext=_ext.selector[type];if(ext.length){for(i=0,ien=ext.length;i<ien;i++){out=ext[i](settings,opts,out);}}return _unique(out);};var _selector_opts=function _selector_opts(opts){if(!opts){opts={};}// Backwards compatibility for 1.9- which used the terminology filter rather
// than search
if(opts.filter&&opts.search===undefined){opts.search=opts.filter;}return $.extend({search:'none',order:'current',page:'all'},opts);};var _selector_first=function _selector_first(inst){// Reduce the API instance to the first item found
for(var i=0,ien=inst.length;i<ien;i++){if(inst[i].length>0){// Assign the first element to the first item in the instance
// and truncate the instance and context
inst[0]=inst[i];inst[0].length=1;inst.length=1;inst.context=[inst.context[i]];return inst;}}// Not found - return an empty instance
inst.length=0;return inst;};var _selector_row_indexes=function _selector_row_indexes(settings,opts){var i,ien,tmp,a=[],displayFiltered=settings.aiDisplay,displayMaster=settings.aiDisplayMaster;var search=opts.search,// none, applied, removed
order=opts.order,// applied, current, index (original - compatibility with 1.9)
page=opts.page;// all, current
if(_fnDataSource(settings)=='ssp'){// In server-side processing mode, most options are irrelevant since
// rows not shown don't exist and the index order is the applied order
// Removed is a special case - for consistency just return an empty
// array
return search==='removed'?[]:_range(0,displayMaster.length);}else if(page=='current'){// Current page implies that order=current and fitler=applied, since it is
// fairly senseless otherwise, regardless of what order and search actually
// are
for(i=settings._iDisplayStart,ien=settings.fnDisplayEnd();i<ien;i++){a.push(displayFiltered[i]);}}else if(order=='current'||order=='applied'){if(search=='none'){a=displayMaster.slice();}else if(search=='applied'){a=displayFiltered.slice();}else if(search=='removed'){// O(n+m) solution by creating a hash map
var displayFilteredMap={};for(var i=0,ien=displayFiltered.length;i<ien;i++){displayFilteredMap[displayFiltered[i]]=null;}a=$.map(displayMaster,function(el){return!displayFilteredMap.hasOwnProperty(el)?el:null;});}}else if(order=='index'||order=='original'){for(i=0,ien=settings.aoData.length;i<ien;i++){if(search=='none'){a.push(i);}else{// applied | removed
tmp=$.inArray(i,displayFiltered);if(tmp===-1&&search=='removed'||tmp>=0&&search=='applied'){a.push(i);}}}}return a;};/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Rows
	 *
	 * {}          - no selector - use all available rows
	 * {integer}   - row aoData index
	 * {node}      - TR node
	 * {string}    - jQuery selector to apply to the TR elements
	 * {array}     - jQuery array of nodes, or simply an array of TR nodes
	 *
	 */var __row_selector=function __row_selector(settings,selector,opts){var rows;var run=function run(sel){var selInt=_intVal(sel);var i,ien;var aoData=settings.aoData;// Short cut - selector is a number and no options provided (default is
// all records, so no need to check if the index is in there, since it
// must be - dev error if the index doesn't exist).
if(selInt!==null&&!opts){return[selInt];}if(!rows){rows=_selector_row_indexes(settings,opts);}if(selInt!==null&&$.inArray(selInt,rows)!==-1){// Selector - integer
return[selInt];}else if(sel===null||sel===undefined||sel===''){// Selector - none
return rows;}// Selector - function
if(typeof sel==='function'){return $.map(rows,function(idx){var row=aoData[idx];return sel(idx,row._aData,row.nTr)?idx:null;});}// Selector - node
if(sel.nodeName){var rowIdx=sel._DT_RowIndex;// Property added by DT for fast lookup
var cellIdx=sel._DT_CellIndex;if(rowIdx!==undefined){// Make sure that the row is actually still present in the table
return aoData[rowIdx]&&aoData[rowIdx].nTr===sel?[rowIdx]:[];}else if(cellIdx){return aoData[cellIdx.row]&&aoData[cellIdx.row].nTr===sel?[cellIdx.row]:[];}else{var host=$(sel).closest('*[data-dt-row]');return host.length?[host.data('dt-row')]:[];}}// ID selector. Want to always be able to select rows by id, regardless
// of if the tr element has been created or not, so can't rely upon
// jQuery here - hence a custom implementation. This does not match
// Sizzle's fast selector or HTML4 - in HTML5 the ID can be anything,
// but to select it using a CSS selector engine (like Sizzle or
// querySelect) it would need to need to be escaped for some characters.
// DataTables simplifies this for row selectors since you can select
// only a row. A # indicates an id any anything that follows is the id -
// unescaped.
if(typeof sel==='string'&&sel.charAt(0)==='#'){// get row index from id
var rowObj=settings.aIds[sel.replace(/^#/,'')];if(rowObj!==undefined){return[rowObj.idx];}// need to fall through to jQuery in case there is DOM id that
// matches
}// Get nodes in the order from the `rows` array with null values removed
var nodes=_removeEmpty(_pluck_order(settings.aoData,rows,'nTr'));// Selector - jQuery selector string, array of nodes or jQuery object/
// As jQuery's .filter() allows jQuery objects to be passed in filter,
// it also allows arrays, so this will cope with all three options
return $(nodes).filter(sel).map(function(){return this._DT_RowIndex;}).toArray();};return _selector_run('row',selector,run,settings,opts);};_api_register('rows()',function(selector,opts){// argument shifting
if(selector===undefined){selector='';}else if($.isPlainObject(selector)){opts=selector;selector='';}opts=_selector_opts(opts);var inst=this.iterator('table',function(settings){return __row_selector(settings,selector,opts);},1);// Want argument shifting here and in __row_selector?
inst.selector.rows=selector;inst.selector.opts=opts;return inst;});_api_register('rows().nodes()',function(){return this.iterator('row',function(settings,row){return settings.aoData[row].nTr||undefined;},1);});_api_register('rows().data()',function(){return this.iterator(true,'rows',function(settings,rows){return _pluck_order(settings.aoData,rows,'_aData');},1);});_api_registerPlural('rows().cache()','row().cache()',function(type){return this.iterator('row',function(settings,row){var r=settings.aoData[row];return type==='search'?r._aFilterData:r._aSortData;},1);});_api_registerPlural('rows().invalidate()','row().invalidate()',function(src){return this.iterator('row',function(settings,row){_fnInvalidate(settings,row,src);});});_api_registerPlural('rows().indexes()','row().index()',function(){return this.iterator('row',function(settings,row){return row;},1);});_api_registerPlural('rows().ids()','row().id()',function(hash){var a=[];var context=this.context;// `iterator` will drop undefined values, but in this case we want them
for(var i=0,ien=context.length;i<ien;i++){for(var j=0,jen=this[i].length;j<jen;j++){var id=context[i].rowIdFn(context[i].aoData[this[i][j]]._aData);a.push((hash===true?'#':'')+id);}}return new _Api2(context,a);});_api_registerPlural('rows().remove()','row().remove()',function(){var that=this;this.iterator('row',function(settings,row,thatIdx){var data=settings.aoData;var rowData=data[row];var i,ien,j,jen;var loopRow,loopCells;data.splice(row,1);// Update the cached indexes
for(i=0,ien=data.length;i<ien;i++){loopRow=data[i];loopCells=loopRow.anCells;// Rows
if(loopRow.nTr!==null){loopRow.nTr._DT_RowIndex=i;}// Cells
if(loopCells!==null){for(j=0,jen=loopCells.length;j<jen;j++){loopCells[j]._DT_CellIndex.row=i;}}}// Delete from the display arrays
_fnDeleteIndex(settings.aiDisplayMaster,row);_fnDeleteIndex(settings.aiDisplay,row);_fnDeleteIndex(that[thatIdx],row,false);// maintain local indexes
// For server-side processing tables - subtract the deleted row from the count
if(settings._iRecordsDisplay>0){settings._iRecordsDisplay--;}// Check for an 'overflow' they case for displaying the table
_fnLengthOverflow(settings);// Remove the row's ID reference if there is one
var id=settings.rowIdFn(rowData._aData);if(id!==undefined){delete settings.aIds[id];}});this.iterator('table',function(settings){for(var i=0,ien=settings.aoData.length;i<ien;i++){settings.aoData[i].idx=i;}});return this;});_api_register('rows.add()',function(rows){var newRows=this.iterator('table',function(settings){var row,i,ien;var out=[];for(i=0,ien=rows.length;i<ien;i++){row=rows[i];if(row.nodeName&&row.nodeName.toUpperCase()==='TR'){out.push(_fnAddTr(settings,row)[0]);}else{out.push(_fnAddData(settings,row));}}return out;},1);// Return an Api.rows() extended instance, so rows().nodes() etc can be used
var modRows=this.rows(-1);modRows.pop();$.merge(modRows,newRows);return modRows;});/**
     *
     */_api_register('row()',function(selector,opts){return _selector_first(this.rows(selector,opts));});_api_register('row().data()',function(data){var ctx=this.context;if(data===undefined){// Get
return ctx.length&&this.length?ctx[0].aoData[this[0]]._aData:undefined;}// Set
var row=ctx[0].aoData[this[0]];row._aData=data;// If the DOM has an id, and the data source is an array
if($.isArray(data)&&row.nTr.id){_fnSetObjectDataFn(ctx[0].rowId)(data,row.nTr.id);}// Automatically invalidate
_fnInvalidate(ctx[0],this[0],'data');return this;});_api_register('row().node()',function(){var ctx=this.context;return ctx.length&&this.length?ctx[0].aoData[this[0]].nTr||null:null;});_api_register('row.add()',function(row){// Allow a jQuery object to be passed in - only a single row is added from
// it though - the first element in the set
if(row instanceof $&&row.length){row=row[0];}var rows=this.iterator('table',function(settings){if(row.nodeName&&row.nodeName.toUpperCase()==='TR'){return _fnAddTr(settings,row)[0];}return _fnAddData(settings,row);});// Return an Api.rows() extended instance, with the newly added row selected
return this.row(rows[0]);});var __details_add=function __details_add(ctx,row,data,klass){// Convert to array of TR elements
var rows=[];var addRow=function addRow(r,k){// Recursion to allow for arrays of jQuery objects
if($.isArray(r)||r instanceof $){for(var i=0,ien=r.length;i<ien;i++){addRow(r[i],k);}return;}// If we get a TR element, then just add it directly - up to the dev
// to add the correct number of columns etc
if(r.nodeName&&r.nodeName.toLowerCase()==='tr'){rows.push(r);}else{// Otherwise create a row with a wrapper
var created=$('<tr><td/></tr>').addClass(k);$('td',created).addClass(k).html(r)[0].colSpan=_fnVisbleColumns(ctx);rows.push(created[0]);}};addRow(data,klass);if(row._details){row._details.detach();}row._details=$(rows);// If the children were already shown, that state should be retained
if(row._detailsShow){row._details.insertAfter(row.nTr);}};var __details_remove=function __details_remove(api,idx){var ctx=api.context;if(ctx.length){var row=ctx[0].aoData[idx!==undefined?idx:api[0]];if(row&&row._details){row._details.remove();row._detailsShow=undefined;row._details=undefined;}}};var __details_display=function __details_display(api,show){var ctx=api.context;if(ctx.length&&api.length){var row=ctx[0].aoData[api[0]];if(row._details){row._detailsShow=show;if(show){row._details.insertAfter(row.nTr);}else{row._details.detach();}__details_events(ctx[0]);}}};var __details_events=function __details_events(settings){var api=new _Api2(settings);var namespace='.dt.DT_details';var drawEvent='draw'+namespace;var colvisEvent='column-visibility'+namespace;var destroyEvent='destroy'+namespace;var data=settings.aoData;api.off(drawEvent+' '+colvisEvent+' '+destroyEvent);if(_pluck(data,'_details').length>0){// On each draw, insert the required elements into the document
api.on(drawEvent,function(e,ctx){if(settings!==ctx){return;}api.rows({page:'current'}).eq(0).each(function(idx){// Internal data grab
var row=data[idx];if(row._detailsShow){row._details.insertAfter(row.nTr);}});});// Column visibility change - update the colspan
api.on(colvisEvent,function(e,ctx,idx,vis){if(settings!==ctx){return;}// Update the colspan for the details rows (note, only if it already has
// a colspan)
var row,visible=_fnVisbleColumns(ctx);for(var i=0,ien=data.length;i<ien;i++){row=data[i];if(row._details){row._details.children('td[colspan]').attr('colspan',visible);}}});// Table destroyed - nuke any child rows
api.on(destroyEvent,function(e,ctx){if(settings!==ctx){return;}for(var i=0,ien=data.length;i<ien;i++){if(data[i]._details){__details_remove(api,i);}}});}};// Strings for the method names to help minification
var _emp='';var _child_obj=_emp+'row().child';var _child_mth=_child_obj+'()';// data can be:
//  tr
//  string
//  jQuery or array of any of the above
_api_register(_child_mth,function(data,klass){var ctx=this.context;if(data===undefined){// get
return ctx.length&&this.length?ctx[0].aoData[this[0]]._details:undefined;}else if(data===true){// show
this.child.show();}else if(data===false){// remove
__details_remove(this);}else if(ctx.length&&this.length){// set
__details_add(ctx[0],ctx[0].aoData[this[0]],data,klass);}return this;});_api_register([_child_obj+'.show()',_child_mth+'.show()'// only when `child()` was called with parameters (without
],function(show){// it returns an object and this method is not executed)
__details_display(this,true);return this;});_api_register([_child_obj+'.hide()',_child_mth+'.hide()'// only when `child()` was called with parameters (without
],function(){// it returns an object and this method is not executed)
__details_display(this,false);return this;});_api_register([_child_obj+'.remove()',_child_mth+'.remove()'// only when `child()` was called with parameters (without
],function(){// it returns an object and this method is not executed)
__details_remove(this);return this;});_api_register(_child_obj+'.isShown()',function(){var ctx=this.context;if(ctx.length&&this.length){// _detailsShown as false or undefined will fall through to return false
return ctx[0].aoData[this[0]]._detailsShow||false;}return false;});/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Columns
	 *
	 * {integer}           - column index (>=0 count from left, <0 count from right)
	 * "{integer}:visIdx"  - visible column index (i.e. translate to column index)  (>=0 count from left, <0 count from right)
	 * "{integer}:visible" - alias for {integer}:visIdx  (>=0 count from left, <0 count from right)
	 * "{string}:name"     - column name
	 * "{string}"          - jQuery selector on column header nodes
	 *
	 */ // can be an array of these items, comma separated list, or an array of comma
// separated lists
var __re_column_selector=/^([^:]+):(name|visIdx|visible)$/;// r1 and r2 are redundant - but it means that the parameters match for the
// iterator callback in columns().data()
var __columnData=function __columnData(settings,column,r1,r2,rows){var a=[];for(var row=0,ien=rows.length;row<ien;row++){a.push(_fnGetCellData(settings,rows[row],column));}return a;};var __column_selector=function __column_selector(settings,selector,opts){var columns=settings.aoColumns,names=_pluck(columns,'sName'),nodes=_pluck(columns,'nTh');var run=function run(s){var selInt=_intVal(s);// Selector - all
if(s===''){return _range(columns.length);}// Selector - index
if(selInt!==null){return[selInt>=0?selInt:// Count from left
columns.length+selInt// Count from right (+ because its a negative value)
];}// Selector = function
if(typeof s==='function'){var rows=_selector_row_indexes(settings,opts);return $.map(columns,function(col,idx){return s(idx,__columnData(settings,idx,0,0,rows),nodes[idx])?idx:null;});}// jQuery or string selector
var match=typeof s==='string'?s.match(__re_column_selector):'';if(match){switch(match[2]){case'visIdx':case'visible':var idx=parseInt(match[1],10);// Visible index given, convert to column index
if(idx<0){// Counting from the right
var visColumns=$.map(columns,function(col,i){return col.bVisible?i:null;});return[visColumns[visColumns.length+idx]];}// Counting from the left
return[_fnVisibleToColumnIndex(settings,idx)];case'name':// match by name. `names` is column index complete and in order
return $.map(names,function(name,i){return name===match[1]?i:null;});default:return[];}}// Cell in the table body
if(s.nodeName&&s._DT_CellIndex){return[s._DT_CellIndex.column];}// jQuery selector on the TH elements for the columns
var jqResult=$(nodes).filter(s).map(function(){return $.inArray(this,nodes);// `nodes` is column index complete and in order
}).toArray();if(jqResult.length||!s.nodeName){return jqResult;}// Otherwise a node which might have a `dt-column` data attribute, or be
// a child or such an element
var host=$(s).closest('*[data-dt-column]');return host.length?[host.data('dt-column')]:[];};return _selector_run('column',selector,run,settings,opts);};var __setColumnVis=function __setColumnVis(settings,column,vis){var cols=settings.aoColumns,col=cols[column],data=settings.aoData,row,cells,i,ien,tr;// Get
if(vis===undefined){return col.bVisible;}// Set
// No change
if(col.bVisible===vis){return;}if(vis){// Insert column
// Need to decide if we should use appendChild or insertBefore
var insertBefore=$.inArray(true,_pluck(cols,'bVisible'),column+1);for(i=0,ien=data.length;i<ien;i++){tr=data[i].nTr;cells=data[i].anCells;if(tr){// insertBefore can act like appendChild if 2nd arg is null
tr.insertBefore(cells[column],cells[insertBefore]||null);}}}else{// Remove column
$(_pluck(settings.aoData,'anCells',column)).detach();}// Common actions
col.bVisible=vis;_fnDrawHead(settings,settings.aoHeader);_fnDrawHead(settings,settings.aoFooter);// Update colspan for no records display. Child rows and extensions will use their own
// listeners to do this - only need to update the empty table item here
if(!settings.aiDisplay.length){$(settings.nTBody).find('td[colspan]').attr('colspan',_fnVisbleColumns(settings));}_fnSaveState(settings);};_api_register('columns()',function(selector,opts){// argument shifting
if(selector===undefined){selector='';}else if($.isPlainObject(selector)){opts=selector;selector='';}opts=_selector_opts(opts);var inst=this.iterator('table',function(settings){return __column_selector(settings,selector,opts);},1);// Want argument shifting here and in _row_selector?
inst.selector.cols=selector;inst.selector.opts=opts;return inst;});_api_registerPlural('columns().header()','column().header()',function(selector,opts){return this.iterator('column',function(settings,column){return settings.aoColumns[column].nTh;},1);});_api_registerPlural('columns().footer()','column().footer()',function(selector,opts){return this.iterator('column',function(settings,column){return settings.aoColumns[column].nTf;},1);});_api_registerPlural('columns().data()','column().data()',function(){return this.iterator('column-rows',__columnData,1);});_api_registerPlural('columns().dataSrc()','column().dataSrc()',function(){return this.iterator('column',function(settings,column){return settings.aoColumns[column].mData;},1);});_api_registerPlural('columns().cache()','column().cache()',function(type){return this.iterator('column-rows',function(settings,column,i,j,rows){return _pluck_order(settings.aoData,rows,type==='search'?'_aFilterData':'_aSortData',column);},1);});_api_registerPlural('columns().nodes()','column().nodes()',function(){return this.iterator('column-rows',function(settings,column,i,j,rows){return _pluck_order(settings.aoData,rows,'anCells',column);},1);});_api_registerPlural('columns().visible()','column().visible()',function(vis,calc){var ret=this.iterator('column',function(settings,column){if(vis===undefined){return settings.aoColumns[column].bVisible;}// else
__setColumnVis(settings,column,vis);});// Group the column visibility changes
if(vis!==undefined){// Second loop once the first is done for events
this.iterator('column',function(settings,column){_fnCallbackFire(settings,null,'column-visibility',[settings,column,vis,calc]);});if(calc===undefined||calc){this.columns.adjust();}}return ret;});_api_registerPlural('columns().indexes()','column().index()',function(type){return this.iterator('column',function(settings,column){return type==='visible'?_fnColumnIndexToVisible(settings,column):column;},1);});_api_register('columns.adjust()',function(){return this.iterator('table',function(settings){_fnAdjustColumnSizing(settings);},1);});_api_register('column.index()',function(type,idx){if(this.context.length!==0){var ctx=this.context[0];if(type==='fromVisible'||type==='toData'){return _fnVisibleToColumnIndex(ctx,idx);}else if(type==='fromData'||type==='toVisible'){return _fnColumnIndexToVisible(ctx,idx);}}});_api_register('column()',function(selector,opts){return _selector_first(this.columns(selector,opts));});var __cell_selector=function __cell_selector(settings,selector,opts){var data=settings.aoData;var rows=_selector_row_indexes(settings,opts);var cells=_removeEmpty(_pluck_order(data,rows,'anCells'));var allCells=$([].concat.apply([],cells));var row;var columns=settings.aoColumns.length;var a,i,ien,j,o,host;var run=function run(s){var fnSelector=typeof s==='function';if(s===null||s===undefined||fnSelector){// All cells and function selectors
a=[];for(i=0,ien=rows.length;i<ien;i++){row=rows[i];for(j=0;j<columns;j++){o={row:row,column:j};if(fnSelector){// Selector - function
host=data[row];if(s(o,_fnGetCellData(settings,row,j),host.anCells?host.anCells[j]:null)){a.push(o);}}else{// Selector - all
a.push(o);}}}return a;}// Selector - index
if($.isPlainObject(s)){// Valid cell index and its in the array of selectable rows
return s.column!==undefined&&s.row!==undefined&&$.inArray(s.row,rows)!==-1?[s]:[];}// Selector - jQuery filtered cells
var jqResult=allCells.filter(s).map(function(i,el){return{// use a new object, in case someone changes the values
row:el._DT_CellIndex.row,column:el._DT_CellIndex.column};}).toArray();if(jqResult.length||!s.nodeName){return jqResult;}// Otherwise the selector is a node, and there is one last option - the
// element might be a child of an element which has dt-row and dt-column
// data attributes
host=$(s).closest('*[data-dt-row]');return host.length?[{row:host.data('dt-row'),column:host.data('dt-column')}]:[];};return _selector_run('cell',selector,run,settings,opts);};_api_register('cells()',function(rowSelector,columnSelector,opts){// Argument shifting
if($.isPlainObject(rowSelector)){// Indexes
if(rowSelector.row===undefined){// Selector options in first parameter
opts=rowSelector;rowSelector=null;}else{// Cell index objects in first parameter
opts=columnSelector;columnSelector=null;}}if($.isPlainObject(columnSelector)){opts=columnSelector;columnSelector=null;}// Cell selector
if(columnSelector===null||columnSelector===undefined){return this.iterator('table',function(settings){return __cell_selector(settings,rowSelector,_selector_opts(opts));});}// Row + column selector
var columns=this.columns(columnSelector);var rows=this.rows(rowSelector);var a,i,ien,j,jen;this.iterator('table',function(settings,idx){a=[];for(i=0,ien=rows[idx].length;i<ien;i++){for(j=0,jen=columns[idx].length;j<jen;j++){a.push({row:rows[idx][i],column:columns[idx][j]});}}},1);// Now pass through the cell selector for options
var cells=this.cells(a,opts);$.extend(cells.selector,{cols:columnSelector,rows:rowSelector,opts:opts});return cells;});_api_registerPlural('cells().nodes()','cell().node()',function(){return this.iterator('cell',function(settings,row,column){var data=settings.aoData[row];return data&&data.anCells?data.anCells[column]:undefined;},1);});_api_register('cells().data()',function(){return this.iterator('cell',function(settings,row,column){return _fnGetCellData(settings,row,column);},1);});_api_registerPlural('cells().cache()','cell().cache()',function(type){type=type==='search'?'_aFilterData':'_aSortData';return this.iterator('cell',function(settings,row,column){return settings.aoData[row][type][column];},1);});_api_registerPlural('cells().render()','cell().render()',function(type){return this.iterator('cell',function(settings,row,column){return _fnGetCellData(settings,row,column,type);},1);});_api_registerPlural('cells().indexes()','cell().index()',function(){return this.iterator('cell',function(settings,row,column){return{row:row,column:column,columnVisible:_fnColumnIndexToVisible(settings,column)};},1);});_api_registerPlural('cells().invalidate()','cell().invalidate()',function(src){return this.iterator('cell',function(settings,row,column){_fnInvalidate(settings,row,src,column);});});_api_register('cell()',function(rowSelector,columnSelector,opts){return _selector_first(this.cells(rowSelector,columnSelector,opts));});_api_register('cell().data()',function(data){var ctx=this.context;var cell=this[0];if(data===undefined){// Get
return ctx.length&&cell.length?_fnGetCellData(ctx[0],cell[0].row,cell[0].column):undefined;}// Set
_fnSetCellData(ctx[0],cell[0].row,cell[0].column,data);_fnInvalidate(ctx[0],cell[0].row,'data',cell[0].column);return this;});/**
     * Get current ordering (sorting) that has been applied to the table.
     *
     * @returns {array} 2D array containing the sorting information for the first
     *   table in the current context. Each element in the parent array represents
     *   a column being sorted upon (i.e. multi-sorting with two columns would have
     *   2 inner arrays). The inner arrays may have 2 or 3 elements. The first is
     *   the column index that the sorting condition applies to, the second is the
     *   direction of the sort (`desc` or `asc`) and, optionally, the third is the
     *   index of the sorting order from the `column.sorting` initialisation array.
     */ /**
     * Set the ordering for the table.
     *
     * @param {integer} order Column index to sort upon.
     * @param {string} direction Direction of the sort to be applied (`asc` or `desc`)
     * @returns {DataTables.Api} this
     */ /**
     * Set the ordering for the table.
     *
     * @param {array} order 1D array of sorting information to be applied.
     * @param {array} [...] Optional additional sorting conditions
     * @returns {DataTables.Api} this
     */ /**
     * Set the ordering for the table.
     *
     * @param {array} order 2D array of sorting information to be applied.
     * @returns {DataTables.Api} this
     */_api_register('order()',function(order,dir){var ctx=this.context;if(order===undefined){// get
return ctx.length!==0?ctx[0].aaSorting:undefined;}// set
if(typeof order==='number'){// Simple column / direction passed in
order=[[order,dir]];}else if(order.length&&!$.isArray(order[0])){// Arguments passed in (list of 1D arrays)
order=Array.prototype.slice.call(arguments);}// otherwise a 2D array was passed in
return this.iterator('table',function(settings){settings.aaSorting=order.slice();});});/**
     * Attach a sort listener to an element for a given column
     *
     * @param {node|jQuery|string} node Identifier for the element(s) to attach the
     *   listener to. This can take the form of a single DOM node, a jQuery
     *   collection of nodes or a jQuery selector which will identify the node(s).
     * @param {integer} column the column that a click on this node will sort on
     * @param {function} [callback] callback function when sort is run
     * @returns {DataTables.Api} this
     */_api_register('order.listener()',function(node,column,callback){return this.iterator('table',function(settings){_fnSortAttachListener(settings,node,column,callback);});});_api_register('order.fixed()',function(set){if(!set){var ctx=this.context;var fixed=ctx.length?ctx[0].aaSortingFixed:undefined;return $.isArray(fixed)?{pre:fixed}:fixed;}return this.iterator('table',function(settings){settings.aaSortingFixed=$.extend(true,{},set);});});// Order by the selected column(s)
_api_register(['columns().order()','column().order()'],function(dir){var that=this;return this.iterator('table',function(settings,i){var sort=[];$.each(that[i],function(j,col){sort.push([col,dir]);});settings.aaSorting=sort;});});_api_register('search()',function(input,regex,smart,caseInsen){var ctx=this.context;if(input===undefined){// get
return ctx.length!==0?ctx[0].oPreviousSearch.sSearch:undefined;}// set
return this.iterator('table',function(settings){if(!settings.oFeatures.bFilter){return;}_fnFilterComplete(settings,$.extend({},settings.oPreviousSearch,{"sSearch":input+"","bRegex":regex===null?false:regex,"bSmart":smart===null?true:smart,"bCaseInsensitive":caseInsen===null?true:caseInsen}),1);});});_api_registerPlural('columns().search()','column().search()',function(input,regex,smart,caseInsen){return this.iterator('column',function(settings,column){var preSearch=settings.aoPreSearchCols;if(input===undefined){// get
return preSearch[column].sSearch;}// set
if(!settings.oFeatures.bFilter){return;}$.extend(preSearch[column],{"sSearch":input+"","bRegex":regex===null?false:regex,"bSmart":smart===null?true:smart,"bCaseInsensitive":caseInsen===null?true:caseInsen});_fnFilterComplete(settings,settings.oPreviousSearch,1);});});/*
	 * State API methods
	 */_api_register('state()',function(){return this.context.length?this.context[0].oSavedState:null;});_api_register('state.clear()',function(){return this.iterator('table',function(settings){// Save an empty object
settings.fnStateSaveCallback.call(settings.oInstance,settings,{});});});_api_register('state.loaded()',function(){return this.context.length?this.context[0].oLoadedState:null;});_api_register('state.save()',function(){return this.iterator('table',function(settings){_fnSaveState(settings);});});/**
     * Provide a common method for plug-ins to check the version of DataTables being
     * used, in order to ensure compatibility.
     *
     *  @param {string} version Version string to check for, in the format "X.Y.Z".
     *    Note that the formats "X" and "X.Y" are also acceptable.
     *  @returns {boolean} true if this version of DataTables is greater or equal to
     *    the required version, or false if this version of DataTales is not
     *    suitable
     *  @static
     *  @dtopt API-Static
     *
     *  @example
     *    alert( $.fn.dataTable.versionCheck( '1.9.0' ) );
     */DataTable.versionCheck=DataTable.fnVersionCheck=function(version){var aThis=DataTable.version.split('.');var aThat=version.split('.');var iThis,iThat;for(var i=0,iLen=aThat.length;i<iLen;i++){iThis=parseInt(aThis[i],10)||0;iThat=parseInt(aThat[i],10)||0;// Parts are the same, keep comparing
if(iThis===iThat){continue;}// Parts are different, return immediately
return iThis>iThat;}return true;};/**
     * Check if a `<table>` node is a DataTable table already or not.
     *
     *  @param {node|jquery|string} table Table node, jQuery object or jQuery
     *      selector for the table to test. Note that if more than more than one
     *      table is passed on, only the first will be checked
     *  @returns {boolean} true the table given is a DataTable, or false otherwise
     *  @static
     *  @dtopt API-Static
     *
     *  @example
     *    if ( ! $.fn.DataTable.isDataTable( '#example' ) ) {
     *      $('#example').dataTable();
     *    }
     */DataTable.isDataTable=DataTable.fnIsDataTable=function(table){var t=$(table).get(0);var is=false;if(table instanceof DataTable.Api){return true;}$.each(DataTable.settings,function(i,o){var head=o.nScrollHead?$('table',o.nScrollHead)[0]:null;var foot=o.nScrollFoot?$('table',o.nScrollFoot)[0]:null;if(o.nTable===t||head===t||foot===t){is=true;}});return is;};/**
     * Get all DataTable tables that have been initialised - optionally you can
     * select to get only currently visible tables.
     *
     *  @param {boolean} [visible=false] Flag to indicate if you want all (default)
     *    or visible tables only.
     *  @returns {array} Array of `table` nodes (not DataTable instances) which are
     *    DataTables
     *  @static
     *  @dtopt API-Static
     *
     *  @example
     *    $.each( $.fn.dataTable.tables(true), function () {
     *      $(table).DataTable().columns.adjust();
     *    } );
     */DataTable.tables=DataTable.fnTables=function(visible){var api=false;if($.isPlainObject(visible)){api=visible.api;visible=visible.visible;}var a=$.map(DataTable.settings,function(o){if(!visible||visible&&$(o.nTable).is(':visible')){return o.nTable;}});return api?new _Api2(a):a;};/**
     * Convert from camel case parameters to Hungarian notation. This is made public
     * for the extensions to provide the same ability as DataTables core to accept
     * either the 1.9 style Hungarian notation, or the 1.10+ style camelCase
     * parameters.
     *
     *  @param {object} src The model object which holds all parameters that can be
     *    mapped.
     *  @param {object} user The object to convert from camel case to Hungarian.
     *  @param {boolean} force When set to `true`, properties which already have a
     *    Hungarian value in the `user` object will be overwritten. Otherwise they
     *    won't be.
     */DataTable.camelToHungarian=_fnCamelToHungarian;/**
     *
     */_api_register('$()',function(selector,opts){var rows=this.rows(opts).nodes(),// Get all rows
jqRows=$(rows);return $([].concat(jqRows.filter(selector).toArray(),jqRows.find(selector).toArray()));});// jQuery functions to operate on the tables
$.each(['on','one','off'],function(i,key){_api_register(key+'()',function()/* event, handler */{var args=Array.prototype.slice.call(arguments);// Add the `dt` namespace automatically if it isn't already present
args[0]=$.map(args[0].split(/\s/),function(e){return!e.match(/\.dt\b/)?e+'.dt':e;}).join(' ');var inst=$(this.tables().nodes());inst[key].apply(inst,args);return this;});});_api_register('clear()',function(){return this.iterator('table',function(settings){_fnClearTable(settings);});});_api_register('settings()',function(){return new _Api2(this.context,this.context);});_api_register('init()',function(){var ctx=this.context;return ctx.length?ctx[0].oInit:null;});_api_register('data()',function(){return this.iterator('table',function(settings){return _pluck(settings.aoData,'_aData');}).flatten();});_api_register('destroy()',function(remove){remove=remove||false;return this.iterator('table',function(settings){var orig=settings.nTableWrapper.parentNode;var classes=settings.oClasses;var table=settings.nTable;var tbody=settings.nTBody;var thead=settings.nTHead;var tfoot=settings.nTFoot;var jqTable=$(table);var jqTbody=$(tbody);var jqWrapper=$(settings.nTableWrapper);var rows=$.map(settings.aoData,function(r){return r.nTr;});var i,ien;// Flag to note that the table is currently being destroyed - no action
// should be taken
settings.bDestroying=true;// Fire off the destroy callbacks for plug-ins etc
_fnCallbackFire(settings,"aoDestroyCallback","destroy",[settings]);// If not being removed from the document, make all columns visible
if(!remove){new _Api2(settings).columns().visible(true);}// Blitz all `DT` namespaced events (these are internal events, the
// lowercase, `dt` events are user subscribed and they are responsible
// for removing them
jqWrapper.off('.DT').find(':not(tbody *)').off('.DT');$(window).off('.DT-'+settings.sInstance);// When scrolling we had to break the table up - restore it
if(table!=thead.parentNode){jqTable.children('thead').detach();jqTable.append(thead);}if(tfoot&&table!=tfoot.parentNode){jqTable.children('tfoot').detach();jqTable.append(tfoot);}settings.aaSorting=[];settings.aaSortingFixed=[];_fnSortingClasses(settings);$(rows).removeClass(settings.asStripeClasses.join(' '));$('th, td',thead).removeClass(classes.sSortable+' '+classes.sSortableAsc+' '+classes.sSortableDesc+' '+classes.sSortableNone);// Add the TR elements back into the table in their original order
jqTbody.children().detach();jqTbody.append(rows);// Remove the DataTables generated nodes, events and classes
var removedMethod=remove?'remove':'detach';jqTable[removedMethod]();jqWrapper[removedMethod]();// If we need to reattach the table to the document
if(!remove&&orig){// insertBefore acts like appendChild if !arg[1]
orig.insertBefore(table,settings.nTableReinsertBefore);// Restore the width of the original table - was read from the style property,
// so we can restore directly to that
jqTable.css('width',settings.sDestroyWidth).removeClass(classes.sTable);// If the were originally stripe classes - then we add them back here.
// Note this is not fool proof (for example if not all rows had stripe
// classes - but it's a good effort without getting carried away
ien=settings.asDestroyStripes.length;if(ien){jqTbody.children().each(function(i){$(this).addClass(settings.asDestroyStripes[i%ien]);});}}/* Remove the settings object from the settings array */var idx=$.inArray(settings,DataTable.settings);if(idx!==-1){DataTable.settings.splice(idx,1);}});});// Add the `every()` method for rows, columns and cells in a compact form
$.each(['column','row','cell'],function(i,type){_api_register(type+'s().every()',function(fn){var opts=this.selector.opts;var api=this;return this.iterator(type,function(settings,arg1,arg2,arg3,arg4){// Rows and columns:
//  arg1 - index
//  arg2 - table counter
//  arg3 - loop counter
//  arg4 - undefined
// Cells:
//  arg1 - row index
//  arg2 - column index
//  arg3 - table counter
//  arg4 - loop counter
fn.call(api[type](arg1,type==='cell'?arg2:opts,type==='cell'?opts:undefined),arg1,arg2,arg3,arg4);});});});// i18n method for extensions to be able to use the language object from the
// DataTable
_api_register('i18n()',function(token,def,plural){var ctx=this.context[0];var resolved=_fnGetObjectDataFn(token)(ctx.oLanguage);if(resolved===undefined){resolved=def;}if(plural!==undefined&&$.isPlainObject(resolved)){resolved=resolved[plural]!==undefined?resolved[plural]:resolved._;}return resolved.replace('%d',plural);// nb: plural might be undefined,
});/**
     * Version string for plug-ins to check compatibility. Allowed format is
     * `a.b.c-d` where: a:int, b:int, c:int, d:string(dev|beta|alpha). `d` is used
     * only for non-release builds. See http://semver.org/ for more information.
     *  @member
     *  @type string
     *  @default Version number
     */DataTable.version="1.10.19";/**
     * Private data store, containing all of the settings objects that are
     * created for the tables on a given page.
     *
     * Note that the `DataTable.settings` object is aliased to
     * `jQuery.fn.dataTableExt` through which it may be accessed and
     * manipulated, or `jQuery.fn.dataTable.settings`.
     *  @member
     *  @type array
     *  @default []
     *  @private
     */DataTable.settings=[];/**
     * Object models container, for the various models that DataTables has
     * available to it. These models define the objects that are used to hold
     * the active state and configuration of the table.
     *  @namespace
     */DataTable.models={};/**
     * Template object for the way in which DataTables holds information about
     * search information for the global filter and individual column filters.
     *  @namespace
     */DataTable.models.oSearch={/**
         * Flag to indicate if the filtering should be case insensitive or not
         *  @type boolean
         *  @default true
         */"bCaseInsensitive":true,/**
         * Applied search term
         *  @type string
         *  @default <i>Empty string</i>
         */"sSearch":"",/**
         * Flag to indicate if the search term should be interpreted as a
         * regular expression (true) or not (false) and therefore and special
         * regex characters escaped.
         *  @type boolean
         *  @default false
         */"bRegex":false,/**
         * Flag to indicate if DataTables is to use its smart filtering or not.
         *  @type boolean
         *  @default true
         */"bSmart":true};/**
     * Template object for the way in which DataTables holds information about
     * each individual row. This is the object format used for the settings
     * aoData array.
     *  @namespace
     */DataTable.models.oRow={/**
         * TR element for the row
         *  @type node
         *  @default null
         */"nTr":null,/**
         * Array of TD elements for each row. This is null until the row has been
         * created.
         *  @type array nodes
         *  @default []
         */"anCells":null,/**
         * Data object from the original data source for the row. This is either
         * an array if using the traditional form of DataTables, or an object if
         * using mData options. The exact type will depend on the passed in
         * data from the data source, or will be an array if using DOM a data
         * source.
         *  @type array|object
         *  @default []
         */"_aData":[],/**
         * Sorting data cache - this array is ostensibly the same length as the
         * number of columns (although each index is generated only as it is
         * needed), and holds the data that is used for sorting each column in the
         * row. We do this cache generation at the start of the sort in order that
         * the formatting of the sort data need be done only once for each cell
         * per sort. This array should not be read from or written to by anything
         * other than the master sorting methods.
         *  @type array
         *  @default null
         *  @private
         */"_aSortData":null,/**
         * Per cell filtering data cache. As per the sort data cache, used to
         * increase the performance of the filtering in DataTables
         *  @type array
         *  @default null
         *  @private
         */"_aFilterData":null,/**
         * Filtering data cache. This is the same as the cell filtering cache, but
         * in this case a string rather than an array. This is easily computed with
         * a join on `_aFilterData`, but is provided as a cache so the join isn't
         * needed on every search (memory traded for performance)
         *  @type array
         *  @default null
         *  @private
         */"_sFilterRow":null,/**
         * Cache of the class name that DataTables has applied to the row, so we
         * can quickly look at this variable rather than needing to do a DOM check
         * on className for the nTr property.
         *  @type string
         *  @default <i>Empty string</i>
         *  @private
         */"_sRowStripe":"",/**
         * Denote if the original data source was from the DOM, or the data source
         * object. This is used for invalidating data, so DataTables can
         * automatically read data from the original source, unless uninstructed
         * otherwise.
         *  @type string
         *  @default null
         *  @private
         */"src":null,/**
         * Index in the aoData array. This saves an indexOf lookup when we have the
         * object, but want to know the index
         *  @type integer
         *  @default -1
         *  @private
         */"idx":-1};/**
     * Template object for the column information object in DataTables. This object
     * is held in the settings aoColumns array and contains all the information that
     * DataTables needs about each individual column.
     *
     * Note that this object is related to {@link DataTable.defaults.column}
     * but this one is the internal data store for DataTables's cache of columns.
     * It should NOT be manipulated outside of DataTables. Any configuration should
     * be done through the initialisation options.
     *  @namespace
     */DataTable.models.oColumn={/**
         * Column index. This could be worked out on-the-fly with $.inArray, but it
         * is faster to just hold it as a variable
         *  @type integer
         *  @default null
         */"idx":null,/**
         * A list of the columns that sorting should occur on when this column
         * is sorted. That this property is an array allows multi-column sorting
         * to be defined for a column (for example first name / last name columns
         * would benefit from this). The values are integers pointing to the
         * columns to be sorted on (typically it will be a single integer pointing
         * at itself, but that doesn't need to be the case).
         *  @type array
         */"aDataSort":null,/**
         * Define the sorting directions that are applied to the column, in sequence
         * as the column is repeatedly sorted upon - i.e. the first value is used
         * as the sorting direction when the column if first sorted (clicked on).
         * Sort it again (click again) and it will move on to the next index.
         * Repeat until loop.
         *  @type array
         */"asSorting":null,/**
         * Flag to indicate if the column is searchable, and thus should be included
         * in the filtering or not.
         *  @type boolean
         */"bSearchable":null,/**
         * Flag to indicate if the column is sortable or not.
         *  @type boolean
         */"bSortable":null,/**
         * Flag to indicate if the column is currently visible in the table or not
         *  @type boolean
         */"bVisible":null,/**
         * Store for manual type assignment using the `column.type` option. This
         * is held in store so we can manipulate the column's `sType` property.
         *  @type string
         *  @default null
         *  @private
         */"_sManualType":null,/**
         * Flag to indicate if HTML5 data attributes should be used as the data
         * source for filtering or sorting. True is either are.
         *  @type boolean
         *  @default false
         *  @private
         */"_bAttrSrc":false,/**
         * Developer definable function that is called whenever a cell is created (Ajax source,
         * etc) or processed for input (DOM source). This can be used as a compliment to mRender
         * allowing you to modify the DOM element (add background colour for example) when the
         * element is available.
         *  @type function
         *  @param {element} nTd The TD node that has been created
         *  @param {*} sData The Data for the cell
         *  @param {array|object} oData The data for the whole row
         *  @param {int} iRow The row index for the aoData data store
         *  @default null
         */"fnCreatedCell":null,/**
         * Function to get data from a cell in a column. You should <b>never</b>
         * access data directly through _aData internally in DataTables - always use
         * the method attached to this property. It allows mData to function as
         * required. This function is automatically assigned by the column
         * initialisation method
         *  @type function
         *  @param {array|object} oData The data array/object for the array
         *    (i.e. aoData[]._aData)
         *  @param {string} sSpecific The specific data type you want to get -
         *    'display', 'type' 'filter' 'sort'
         *  @returns {*} The data for the cell from the given row's data
         *  @default null
         */"fnGetData":null,/**
         * Function to set data for a cell in the column. You should <b>never</b>
         * set the data directly to _aData internally in DataTables - always use
         * this method. It allows mData to function as required. This function
         * is automatically assigned by the column initialisation method
         *  @type function
         *  @param {array|object} oData The data array/object for the array
         *    (i.e. aoData[]._aData)
         *  @param {*} sValue Value to set
         *  @default null
         */"fnSetData":null,/**
         * Property to read the value for the cells in the column from the data
         * source array / object. If null, then the default content is used, if a
         * function is given then the return from the function is used.
         *  @type function|int|string|null
         *  @default null
         */"mData":null,/**
         * Partner property to mData which is used (only when defined) to get
         * the data - i.e. it is basically the same as mData, but without the
         * 'set' option, and also the data fed to it is the result from mData.
         * This is the rendering method to match the data method of mData.
         *  @type function|int|string|null
         *  @default null
         */"mRender":null,/**
         * Unique header TH/TD element for this column - this is what the sorting
         * listener is attached to (if sorting is enabled.)
         *  @type node
         *  @default null
         */"nTh":null,/**
         * Unique footer TH/TD element for this column (if there is one). Not used
         * in DataTables as such, but can be used for plug-ins to reference the
         * footer for each column.
         *  @type node
         *  @default null
         */"nTf":null,/**
         * The class to apply to all TD elements in the table's TBODY for the column
         *  @type string
         *  @default null
         */"sClass":null,/**
         * When DataTables calculates the column widths to assign to each column,
         * it finds the longest string in each column and then constructs a
         * temporary table and reads the widths from that. The problem with this
         * is that "mmm" is much wider then "iiii", but the latter is a longer
         * string - thus the calculation can go wrong (doing it properly and putting
         * it into an DOM object and measuring that is horribly(!) slow). Thus as
         * a "work around" we provide this option. It will append its value to the
         * text that is found to be the longest string for the column - i.e. padding.
         *  @type string
         */"sContentPadding":null,/**
         * Allows a default value to be given for a column's data, and will be used
         * whenever a null data source is encountered (this can be because mData
         * is set to null, or because the data source itself is null).
         *  @type string
         *  @default null
         */"sDefaultContent":null,/**
         * Name for the column, allowing reference to the column by name as well as
         * by index (needs a lookup to work by name).
         *  @type string
         */"sName":null,/**
         * Custom sorting data type - defines which of the available plug-ins in
         * afnSortData the custom sorting will use - if any is defined.
         *  @type string
         *  @default std
         */"sSortDataType":'std',/**
         * Class to be applied to the header element when sorting on this column
         *  @type string
         *  @default null
         */"sSortingClass":null,/**
         * Class to be applied to the header element when sorting on this column -
         * when jQuery UI theming is used.
         *  @type string
         *  @default null
         */"sSortingClassJUI":null,/**
         * Title of the column - what is seen in the TH element (nTh).
         *  @type string
         */"sTitle":null,/**
         * Column sorting and filtering type
         *  @type string
         *  @default null
         */"sType":null,/**
         * Width of the column
         *  @type string
         *  @default null
         */"sWidth":null,/**
         * Width of the column when it was first "encountered"
         *  @type string
         *  @default null
         */"sWidthOrig":null};/*
	 * Developer note: The properties of the object below are given in Hungarian
	 * notation, that was used as the interface for DataTables prior to v1.10, however
	 * from v1.10 onwards the primary interface is camel case. In order to avoid
	 * breaking backwards compatibility utterly with this change, the Hungarian
	 * version is still, internally the primary interface, but is is not documented
	 * - hence the @name tags in each doc comment. This allows a Javascript function
	 * to create a map from Hungarian notation to camel case (going the other direction
	 * would require each property to be listed, which would at around 3K to the size
	 * of DataTables, while this method is about a 0.5K hit.
	 *
	 * Ultimately this does pave the way for Hungarian notation to be dropped
	 * completely, but that is a massive amount of work and will break current
	 * installs (therefore is on-hold until v2).
	 */ /**
     * Initialisation options that can be given to DataTables at initialisation
     * time.
     *  @namespace
     */DataTable.defaults={/**
         * An array of data to use for the table, passed in at initialisation which
         * will be used in preference to any data which is already in the DOM. This is
         * particularly useful for constructing tables purely in Javascript, for
         * example with a custom Ajax call.
         *  @type array
         *  @default null
         *
         *  @dtopt Option
         *  @name DataTable.defaults.data
         *
         *  @example
         *    // Using a 2D array data source
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "data": [
         *          ['Trident', 'Internet Explorer 4.0', 'Win 95+', 4, 'X'],
         *          ['Trident', 'Internet Explorer 5.0', 'Win 95+', 5, 'C'],
         *        ],
         *        "columns": [
         *          { "title": "Engine" },
         *          { "title": "Browser" },
         *          { "title": "Platform" },
         *          { "title": "Version" },
         *          { "title": "Grade" }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using an array of objects as a data source (`data`)
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "data": [
         *          {
         *            "engine":   "Trident",
         *            "browser":  "Internet Explorer 4.0",
         *            "platform": "Win 95+",
         *            "version":  4,
         *            "grade":    "X"
         *          },
         *          {
         *            "engine":   "Trident",
         *            "browser":  "Internet Explorer 5.0",
         *            "platform": "Win 95+",
         *            "version":  5,
         *            "grade":    "C"
         *          }
         *        ],
         *        "columns": [
         *          { "title": "Engine",   "data": "engine" },
         *          { "title": "Browser",  "data": "browser" },
         *          { "title": "Platform", "data": "platform" },
         *          { "title": "Version",  "data": "version" },
         *          { "title": "Grade",    "data": "grade" }
         *        ]
         *      } );
         *    } );
         */"aaData":null,/**
         * If ordering is enabled, then DataTables will perform a first pass sort on
         * initialisation. You can define which column(s) the sort is performed
         * upon, and the sorting direction, with this variable. The `sorting` array
         * should contain an array for each column to be sorted initially containing
         * the column's index and a direction string ('asc' or 'desc').
         *  @type array
         *  @default [[0,'asc']]
         *
         *  @dtopt Option
         *  @name DataTable.defaults.order
         *
         *  @example
         *    // Sort by 3rd column first, and then 4th column
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "order": [[2,'asc'], [3,'desc']]
         *      } );
         *    } );
         *
         *    // No initial sorting
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "order": []
         *      } );
         *    } );
         */"aaSorting":[[0,'asc']],/**
         * This parameter is basically identical to the `sorting` parameter, but
         * cannot be overridden by user interaction with the table. What this means
         * is that you could have a column (visible or hidden) which the sorting
         * will always be forced on first - any sorting after that (from the user)
         * will then be performed as required. This can be useful for grouping rows
         * together.
         *  @type array
         *  @default null
         *
         *  @dtopt Option
         *  @name DataTable.defaults.orderFixed
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "orderFixed": [[0,'asc']]
         *      } );
         *    } )
         */"aaSortingFixed":[],/**
         * DataTables can be instructed to load data to display in the table from a
         * Ajax source. This option defines how that Ajax call is made and where to.
         *
         * The `ajax` property has three different modes of operation, depending on
         * how it is defined. These are:
         *
         * * `string` - Set the URL from where the data should be loaded from.
         * * `object` - Define properties for `jQuery.ajax`.
         * * `function` - Custom data get function
         *
         * `string`
         * --------
         *
         * As a string, the `ajax` property simply defines the URL from which
         * DataTables will load data.
         *
         * `object`
         * --------
         *
         * As an object, the parameters in the object are passed to
         * [jQuery.ajax](http://api.jquery.com/jQuery.ajax/) allowing fine control
         * of the Ajax request. DataTables has a number of default parameters which
         * you can override using this option. Please refer to the jQuery
         * documentation for a full description of the options available, although
         * the following parameters provide additional options in DataTables or
         * require special consideration:
         *
         * * `data` - As with jQuery, `data` can be provided as an object, but it
         *   can also be used as a function to manipulate the data DataTables sends
         *   to the server. The function takes a single parameter, an object of
         *   parameters with the values that DataTables has readied for sending. An
         *   object may be returned which will be merged into the DataTables
         *   defaults, or you can add the items to the object that was passed in and
         *   not return anything from the function. This supersedes `fnServerParams`
         *   from DataTables 1.9-.
         *
         * * `dataSrc` - By default DataTables will look for the property `data` (or
         *   `aaData` for compatibility with DataTables 1.9-) when obtaining data
         *   from an Ajax source or for server-side processing - this parameter
         *   allows that property to be changed. You can use Javascript dotted
         *   object notation to get a data source for multiple levels of nesting, or
         *   it my be used as a function. As a function it takes a single parameter,
         *   the JSON returned from the server, which can be manipulated as
         *   required, with the returned value being that used by DataTables as the
         *   data source for the table. This supersedes `sAjaxDataProp` from
         *   DataTables 1.9-.
         *
         * * `success` - Should not be overridden it is used internally in
         *   DataTables. To manipulate / transform the data returned by the server
         *   use `ajax.dataSrc`, or use `ajax` as a function (see below).
         *
         * `function`
         * ----------
         *
         * As a function, making the Ajax call is left up to yourself allowing
         * complete control of the Ajax request. Indeed, if desired, a method other
         * than Ajax could be used to obtain the required data, such as Web storage
         * or an AIR database.
         *
         * The function is given four parameters and no return is required. The
         * parameters are:
         *
         * 1. _object_ - Data to send to the server
         * 2. _function_ - Callback function that must be executed when the required
         *    data has been obtained. That data should be passed into the callback
         *    as the only parameter
         * 3. _object_ - DataTables settings object for the table
         *
         * Note that this supersedes `fnServerData` from DataTables 1.9-.
         *
         *  @type string|object|function
         *  @default null
         *
         *  @dtopt Option
         *  @name DataTable.defaults.ajax
         *  @since 1.10.0
         *
         * @example
         *   // Get JSON data from a file via Ajax.
         *   // Note DataTables expects data in the form `{ data: [ ...data... ] }` by default).
         *   $('#example').dataTable( {
         *     "ajax": "data.json"
         *   } );
         *
         * @example
         *   // Get JSON data from a file via Ajax, using `dataSrc` to change
         *   // `data` to `tableData` (i.e. `{ tableData: [ ...data... ] }`)
         *   $('#example').dataTable( {
         *     "ajax": {
         *       "url": "data.json",
         *       "dataSrc": "tableData"
         *     }
         *   } );
         *
         * @example
         *   // Get JSON data from a file via Ajax, using `dataSrc` to read data
         *   // from a plain array rather than an array in an object
         *   $('#example').dataTable( {
         *     "ajax": {
         *       "url": "data.json",
         *       "dataSrc": ""
         *     }
         *   } );
         *
         * @example
         *   // Manipulate the data returned from the server - add a link to data
         *   // (note this can, should, be done using `render` for the column - this
         *   // is just a simple example of how the data can be manipulated).
         *   $('#example').dataTable( {
         *     "ajax": {
         *       "url": "data.json",
         *       "dataSrc": function ( json ) {
         *         for ( var i=0, ien=json.length ; i<ien ; i++ ) {
         *           json[i][0] = '<a href="/message/'+json[i][0]+'>View message</a>';
         *         }
         *         return json;
         *       }
         *     }
         *   } );
         *
         * @example
         *   // Add data to the request
         *   $('#example').dataTable( {
         *     "ajax": {
         *       "url": "data.json",
         *       "data": function ( d ) {
         *         return {
         *           "extra_search": $('#extra').val()
         *         };
         *       }
         *     }
         *   } );
         *
         * @example
         *   // Send request as POST
         *   $('#example').dataTable( {
         *     "ajax": {
         *       "url": "data.json",
         *       "type": "POST"
         *     }
         *   } );
         *
         * @example
         *   // Get the data from localStorage (could interface with a form for
         *   // adding, editing and removing rows).
         *   $('#example').dataTable( {
         *     "ajax": function (data, callback, settings) {
         *       callback(
         *         JSON.parse( localStorage.getItem('dataTablesData') )
         *       );
         *     }
         *   } );
         */"ajax":null,/**
         * This parameter allows you to readily specify the entries in the length drop
         * down menu that DataTables shows when pagination is enabled. It can be
         * either a 1D array of options which will be used for both the displayed
         * option and the value, or a 2D array which will use the array in the first
         * position as the value, and the array in the second position as the
         * displayed options (useful for language strings such as 'All').
         *
         * Note that the `pageLength` property will be automatically set to the
         * first value given in this array, unless `pageLength` is also provided.
         *  @type array
         *  @default [ 10, 25, 50, 100 ]
         *
         *  @dtopt Option
         *  @name DataTable.defaults.lengthMenu
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]]
         *      } );
         *    } );
         */"aLengthMenu":[10,25,50,100],/**
         * The `columns` option in the initialisation parameter allows you to define
         * details about the way individual columns behave. For a full list of
         * column options that can be set, please see
         * {@link DataTable.defaults.column}. Note that if you use `columns` to
         * define your columns, you must have an entry in the array for every single
         * column that you have in your table (these can be null if you don't which
         * to specify any options).
         *  @member
         *
         *  @name DataTable.defaults.column
         */"aoColumns":null,/**
         * Very similar to `columns`, `columnDefs` allows you to target a specific
         * column, multiple columns, or all columns, using the `targets` property of
         * each object in the array. This allows great flexibility when creating
         * tables, as the `columnDefs` arrays can be of any length, targeting the
         * columns you specifically want. `columnDefs` may use any of the column
         * options available: {@link DataTable.defaults.column}, but it _must_
         * have `targets` defined in each object in the array. Values in the `targets`
         * array may be:
         *   <ul>
         *     <li>a string - class name will be matched on the TH for the column</li>
         *     <li>0 or a positive integer - column index counting from the left</li>
         *     <li>a negative integer - column index counting from the right</li>
         *     <li>the string "_all" - all columns (i.e. assign a default)</li>
         *   </ul>
         *  @member
         *
         *  @name DataTable.defaults.columnDefs
         */"aoColumnDefs":null,/**
         * Basically the same as `search`, this parameter defines the individual column
         * filtering state at initialisation time. The array must be of the same size
         * as the number of columns, and each element be an object with the parameters
         * `search` and `escapeRegex` (the latter is optional). 'null' is also
         * accepted and the default will be used.
         *  @type array
         *  @default []
         *
         *  @dtopt Option
         *  @name DataTable.defaults.searchCols
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "searchCols": [
         *          null,
         *          { "search": "My filter" },
         *          null,
         *          { "search": "^[0-9]", "escapeRegex": false }
         *        ]
         *      } );
         *    } )
         */"aoSearchCols":[],/**
         * An array of CSS classes that should be applied to displayed rows. This
         * array may be of any length, and DataTables will apply each class
         * sequentially, looping when required.
         *  @type array
         *  @default null <i>Will take the values determined by the `oClasses.stripe*`
         *    options</i>
         *
         *  @dtopt Option
         *  @name DataTable.defaults.stripeClasses
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stripeClasses": [ 'strip1', 'strip2', 'strip3' ]
         *      } );
         *    } )
         */"asStripeClasses":null,/**
         * Enable or disable automatic column width calculation. This can be disabled
         * as an optimisation (it takes some time to calculate the widths) if the
         * tables widths are passed in using `columns`.
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.autoWidth
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "autoWidth": false
         *      } );
         *    } );
         */"bAutoWidth":true,/**
         * Deferred rendering can provide DataTables with a huge speed boost when you
         * are using an Ajax or JS data source for the table. This option, when set to
         * true, will cause DataTables to defer the creation of the table elements for
         * each row until they are needed for a draw - saving a significant amount of
         * time.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Features
         *  @name DataTable.defaults.deferRender
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "ajax": "sources/arrays.txt",
         *        "deferRender": true
         *      } );
         *    } );
         */"bDeferRender":false,/**
         * Replace a DataTable which matches the given selector and replace it with
         * one which has the properties of the new initialisation object passed. If no
         * table matches the selector, then the new DataTable will be constructed as
         * per normal.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Options
         *  @name DataTable.defaults.destroy
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "srollY": "200px",
         *        "paginate": false
         *      } );
         *
         *      // Some time later....
         *      $('#example').dataTable( {
         *        "filter": false,
         *        "destroy": true
         *      } );
         *    } );
         */"bDestroy":false,/**
         * Enable or disable filtering of data. Filtering in DataTables is "smart" in
         * that it allows the end user to input multiple words (space separated) and
         * will match a row containing those words, even if not in the order that was
         * specified (this allow matching across multiple columns). Note that if you
         * wish to use filtering in DataTables this must remain 'true' - to remove the
         * default filtering input box and retain filtering abilities, please use
         * {@link DataTable.defaults.dom}.
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.searching
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "searching": false
         *      } );
         *    } );
         */"bFilter":true,/**
         * Enable or disable the table information display. This shows information
         * about the data that is currently visible on the page, including information
         * about filtered data if that action is being performed.
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.info
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "info": false
         *      } );
         *    } );
         */"bInfo":true,/**
         * Allows the end user to select the size of a formatted page from a select
         * menu (sizes are 10, 25, 50 and 100). Requires pagination (`paginate`).
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.lengthChange
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "lengthChange": false
         *      } );
         *    } );
         */"bLengthChange":true,/**
         * Enable or disable pagination.
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.paging
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "paging": false
         *      } );
         *    } );
         */"bPaginate":true,/**
         * Enable or disable the display of a 'processing' indicator when the table is
         * being processed (e.g. a sort). This is particularly useful for tables with
         * large amounts of data where it can take a noticeable amount of time to sort
         * the entries.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Features
         *  @name DataTable.defaults.processing
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "processing": true
         *      } );
         *    } );
         */"bProcessing":false,/**
         * Retrieve the DataTables object for the given selector. Note that if the
         * table has already been initialised, this parameter will cause DataTables
         * to simply return the object that has already been set up - it will not take
         * account of any changes you might have made to the initialisation object
         * passed to DataTables (setting this parameter to true is an acknowledgement
         * that you understand this). `destroy` can be used to reinitialise a table if
         * you need.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Options
         *  @name DataTable.defaults.retrieve
         *
         *  @example
         *    $(document).ready( function() {
         *      initTable();
         *      tableActions();
         *    } );
         *
         *    function initTable ()
         *    {
         *      return $('#example').dataTable( {
         *        "scrollY": "200px",
         *        "paginate": false,
         *        "retrieve": true
         *      } );
         *    }
         *
         *    function tableActions ()
         *    {
         *      var table = initTable();
         *      // perform API operations with oTable
         *    }
         */"bRetrieve":false,/**
         * When vertical (y) scrolling is enabled, DataTables will force the height of
         * the table's viewport to the given height at all times (useful for layout).
         * However, this can look odd when filtering data down to a small data set,
         * and the footer is left "floating" further down. This parameter (when
         * enabled) will cause DataTables to collapse the table's viewport down when
         * the result set will fit within the given Y height.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Options
         *  @name DataTable.defaults.scrollCollapse
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "scrollY": "200",
         *        "scrollCollapse": true
         *      } );
         *    } );
         */"bScrollCollapse":false,/**
         * Configure DataTables to use server-side processing. Note that the
         * `ajax` parameter must also be given in order to give DataTables a
         * source to obtain the required data for each draw.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Features
         *  @dtopt Server-side
         *  @name DataTable.defaults.serverSide
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "serverSide": true,
         *        "ajax": "xhr.php"
         *      } );
         *    } );
         */"bServerSide":false,/**
         * Enable or disable sorting of columns. Sorting of individual columns can be
         * disabled by the `sortable` option for each column.
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.ordering
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "ordering": false
         *      } );
         *    } );
         */"bSort":true,/**
         * Enable or display DataTables' ability to sort multiple columns at the
         * same time (activated by shift-click by the user).
         *  @type boolean
         *  @default true
         *
         *  @dtopt Options
         *  @name DataTable.defaults.orderMulti
         *
         *  @example
         *    // Disable multiple column sorting ability
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "orderMulti": false
         *      } );
         *    } );
         */"bSortMulti":true,/**
         * Allows control over whether DataTables should use the top (true) unique
         * cell that is found for a single column, or the bottom (false - default).
         * This is useful when using complex headers.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Options
         *  @name DataTable.defaults.orderCellsTop
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "orderCellsTop": true
         *      } );
         *    } );
         */"bSortCellsTop":false,/**
         * Enable or disable the addition of the classes `sorting\_1`, `sorting\_2` and
         * `sorting\_3` to the columns which are currently being sorted on. This is
         * presented as a feature switch as it can increase processing time (while
         * classes are removed and added) so for large data sets you might want to
         * turn this off.
         *  @type boolean
         *  @default true
         *
         *  @dtopt Features
         *  @name DataTable.defaults.orderClasses
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "orderClasses": false
         *      } );
         *    } );
         */"bSortClasses":true,/**
         * Enable or disable state saving. When enabled HTML5 `localStorage` will be
         * used to save table display information such as pagination information,
         * display length, filtering and sorting. As such when the end user reloads
         * the page the display display will match what thy had previously set up.
         *
         * Due to the use of `localStorage` the default state saving is not supported
         * in IE6 or 7. If state saving is required in those browsers, use
         * `stateSaveCallback` to provide a storage solution such as cookies.
         *  @type boolean
         *  @default false
         *
         *  @dtopt Features
         *  @name DataTable.defaults.stateSave
         *
         *  @example
         *    $(document).ready( function () {
         *      $('#example').dataTable( {
         *        "stateSave": true
         *      } );
         *    } );
         */"bStateSave":false,/**
         * This function is called when a TR element is created (and all TD child
         * elements have been inserted), or registered if using a DOM source, allowing
         * manipulation of the TR element (adding classes etc).
         *  @type function
         *  @param {node} row "TR" element for the current row
         *  @param {array} data Raw data array for this row
         *  @param {int} dataIndex The index of this row in the internal aoData array
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.createdRow
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "createdRow": function( row, data, dataIndex ) {
         *          // Bold the grade for all 'A' grade browsers
         *          if ( data[4] == "A" )
         *          {
         *            $('td:eq(4)', row).html( '<b>A</b>' );
         *          }
         *        }
         *      } );
         *    } );
         */"fnCreatedRow":null,/**
         * This function is called on every 'draw' event, and allows you to
         * dynamically modify any aspect you want about the created DOM.
         *  @type function
         *  @param {object} settings DataTables settings object
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.drawCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "drawCallback": function( settings ) {
         *          alert( 'DataTables has redrawn the table' );
         *        }
         *      } );
         *    } );
         */"fnDrawCallback":null,/**
         * Identical to fnHeaderCallback() but for the table footer this function
         * allows you to modify the table footer on every 'draw' event.
         *  @type function
         *  @param {node} foot "TR" element for the footer
         *  @param {array} data Full table data (as derived from the original HTML)
         *  @param {int} start Index for the current display starting point in the
         *    display array
         *  @param {int} end Index for the current display ending point in the
         *    display array
         *  @param {array int} display Index array to translate the visual position
         *    to the full data array
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.footerCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "footerCallback": function( tfoot, data, start, end, display ) {
         *          tfoot.getElementsByTagName('th')[0].innerHTML = "Starting index is "+start;
         *        }
         *      } );
         *    } )
         */"fnFooterCallback":null,/**
         * When rendering large numbers in the information element for the table
         * (i.e. "Showing 1 to 10 of 57 entries") DataTables will render large numbers
         * to have a comma separator for the 'thousands' units (e.g. 1 million is
         * rendered as "1,000,000") to help readability for the end user. This
         * function will override the default method DataTables uses.
         *  @type function
         *  @member
         *  @param {int} toFormat number to be formatted
         *  @returns {string} formatted string for DataTables to show the number
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.formatNumber
         *
         *  @example
         *    // Format a number using a single quote for the separator (note that
         *    // this can also be done with the language.thousands option)
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "formatNumber": function ( toFormat ) {
         *          return toFormat.toString().replace(
         *            /\B(?=(\d{3})+(?!\d))/g, "'"
         *          );
         *        };
         *      } );
         *    } );
         */"fnFormatNumber":function fnFormatNumber(toFormat){return toFormat.toString().replace(/\B(?=(\d{3})+(?!\d))/g,this.oLanguage.sThousands);},/**
         * This function is called on every 'draw' event, and allows you to
         * dynamically modify the header row. This can be used to calculate and
         * display useful information about the table.
         *  @type function
         *  @param {node} head "TR" element for the header
         *  @param {array} data Full table data (as derived from the original HTML)
         *  @param {int} start Index for the current display starting point in the
         *    display array
         *  @param {int} end Index for the current display ending point in the
         *    display array
         *  @param {array int} display Index array to translate the visual position
         *    to the full data array
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.headerCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "fheaderCallback": function( head, data, start, end, display ) {
         *          head.getElementsByTagName('th')[0].innerHTML = "Displaying "+(end-start)+" records";
         *        }
         *      } );
         *    } )
         */"fnHeaderCallback":null,/**
         * The information element can be used to convey information about the current
         * state of the table. Although the internationalisation options presented by
         * DataTables are quite capable of dealing with most customisations, there may
         * be times where you wish to customise the string further. This callback
         * allows you to do exactly that.
         *  @type function
         *  @param {object} oSettings DataTables settings object
         *  @param {int} start Starting position in data for the draw
         *  @param {int} end End position in data for the draw
         *  @param {int} max Total number of rows in the table (regardless of
         *    filtering)
         *  @param {int} total Total number of rows in the data set, after filtering
         *  @param {string} pre The string that DataTables has formatted using it's
         *    own rules
         *  @returns {string} The string to be displayed in the information element.
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.infoCallback
         *
         *  @example
         *    $('#example').dataTable( {
         *      "infoCallback": function( settings, start, end, max, total, pre ) {
         *        return start +" to "+ end;
         *      }
         *    } );
         */"fnInfoCallback":null,/**
         * Called when the table has been initialised. Normally DataTables will
         * initialise sequentially and there will be no need for this function,
         * however, this does not hold true when using external language information
         * since that is obtained using an async XHR call.
         *  @type function
         *  @param {object} settings DataTables settings object
         *  @param {object} json The JSON object request from the server - only
         *    present if client-side Ajax sourced data is used
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.initComplete
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "initComplete": function(settings, json) {
         *          alert( 'DataTables has finished its initialisation.' );
         *        }
         *      } );
         *    } )
         */"fnInitComplete":null,/**
         * Called at the very start of each table draw and can be used to cancel the
         * draw by returning false, any other return (including undefined) results in
         * the full draw occurring).
         *  @type function
         *  @param {object} settings DataTables settings object
         *  @returns {boolean} False will cancel the draw, anything else (including no
         *    return) will allow it to complete.
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.preDrawCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "preDrawCallback": function( settings ) {
         *          if ( $('#test').val() == 1 ) {
         *            return false;
         *          }
         *        }
         *      } );
         *    } );
         */"fnPreDrawCallback":null,/**
         * This function allows you to 'post process' each row after it have been
         * generated for each table draw, but before it is rendered on screen. This
         * function might be used for setting the row class name etc.
         *  @type function
         *  @param {node} row "TR" element for the current row
         *  @param {array} data Raw data array for this row
         *  @param {int} displayIndex The display index for the current table draw
         *  @param {int} displayIndexFull The index of the data in the full list of
         *    rows (after filtering)
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.rowCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "rowCallback": function( row, data, displayIndex, displayIndexFull ) {
         *          // Bold the grade for all 'A' grade browsers
         *          if ( data[4] == "A" ) {
         *            $('td:eq(4)', row).html( '<b>A</b>' );
         *          }
         *        }
         *      } );
         *    } );
         */"fnRowCallback":null,/**
         * __Deprecated__ The functionality provided by this parameter has now been
         * superseded by that provided through `ajax`, which should be used instead.
         *
         * This parameter allows you to override the default function which obtains
         * the data from the server so something more suitable for your application.
         * For example you could use POST data, or pull information from a Gears or
         * AIR database.
         *  @type function
         *  @member
         *  @param {string} source HTTP source to obtain the data from (`ajax`)
         *  @param {array} data A key/value pair object containing the data to send
         *    to the server
         *  @param {function} callback to be called on completion of the data get
         *    process that will draw the data on the page.
         *  @param {object} settings DataTables settings object
         *
         *  @dtopt Callbacks
         *  @dtopt Server-side
         *  @name DataTable.defaults.serverData
         *
         *  @deprecated 1.10. Please use `ajax` for this functionality now.
         */"fnServerData":null,/**
         * __Deprecated__ The functionality provided by this parameter has now been
         * superseded by that provided through `ajax`, which should be used instead.
         *
         *  It is often useful to send extra data to the server when making an Ajax
         * request - for example custom filtering information, and this callback
         * function makes it trivial to send extra information to the server. The
         * passed in parameter is the data set that has been constructed by
         * DataTables, and you can add to this or modify it as you require.
         *  @type function
         *  @param {array} data Data array (array of objects which are name/value
         *    pairs) that has been constructed by DataTables and will be sent to the
         *    server. In the case of Ajax sourced data with server-side processing
         *    this will be an empty array, for server-side processing there will be a
         *    significant number of parameters!
         *  @returns {undefined} Ensure that you modify the data array passed in,
         *    as this is passed by reference.
         *
         *  @dtopt Callbacks
         *  @dtopt Server-side
         *  @name DataTable.defaults.serverParams
         *
         *  @deprecated 1.10. Please use `ajax` for this functionality now.
         */"fnServerParams":null,/**
         * Load the table state. With this function you can define from where, and how, the
         * state of a table is loaded. By default DataTables will load from `localStorage`
         * but you might wish to use a server-side database or cookies.
         *  @type function
         *  @member
         *  @param {object} settings DataTables settings object
         *  @param {object} callback Callback that can be executed when done. It
         *    should be passed the loaded state object.
         *  @return {object} The DataTables state object to be loaded
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.stateLoadCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateSave": true,
         *        "stateLoadCallback": function (settings, callback) {
         *          $.ajax( {
         *            "url": "/state_load",
         *            "dataType": "json",
         *            "success": function (json) {
         *              callback( json );
         *            }
         *          } );
         *        }
         *      } );
         *    } );
         */"fnStateLoadCallback":function fnStateLoadCallback(settings){try{return JSON.parse((settings.iStateDuration===-1?sessionStorage:localStorage).getItem('DataTables_'+settings.sInstance+'_'+location.pathname));}catch(e){}},/**
         * Callback which allows modification of the saved state prior to loading that state.
         * This callback is called when the table is loading state from the stored data, but
         * prior to the settings object being modified by the saved state. Note that for
         * plug-in authors, you should use the `stateLoadParams` event to load parameters for
         * a plug-in.
         *  @type function
         *  @param {object} settings DataTables settings object
         *  @param {object} data The state object that is to be loaded
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.stateLoadParams
         *
         *  @example
         *    // Remove a saved filter, so filtering is never loaded
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateSave": true,
         *        "stateLoadParams": function (settings, data) {
         *          data.oSearch.sSearch = "";
         *        }
         *      } );
         *    } );
         *
         *  @example
         *    // Disallow state loading by returning false
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateSave": true,
         *        "stateLoadParams": function (settings, data) {
         *          return false;
         *        }
         *      } );
         *    } );
         */"fnStateLoadParams":null,/**
         * Callback that is called when the state has been loaded from the state saving method
         * and the DataTables settings object has been modified as a result of the loaded state.
         *  @type function
         *  @param {object} settings DataTables settings object
         *  @param {object} data The state object that was loaded
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.stateLoaded
         *
         *  @example
         *    // Show an alert with the filtering value that was saved
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateSave": true,
         *        "stateLoaded": function (settings, data) {
         *          alert( 'Saved filter was: '+data.oSearch.sSearch );
         *        }
         *      } );
         *    } );
         */"fnStateLoaded":null,/**
         * Save the table state. This function allows you to define where and how the state
         * information for the table is stored By default DataTables will use `localStorage`
         * but you might wish to use a server-side database or cookies.
         *  @type function
         *  @member
         *  @param {object} settings DataTables settings object
         *  @param {object} data The state object to be saved
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.stateSaveCallback
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateSave": true,
         *        "stateSaveCallback": function (settings, data) {
         *          // Send an Ajax request to the server with the state object
         *          $.ajax( {
         *            "url": "/state_save",
         *            "data": data,
         *            "dataType": "json",
         *            "method": "POST"
         *            "success": function () {}
         *          } );
         *        }
         *      } );
         *    } );
         */"fnStateSaveCallback":function fnStateSaveCallback(settings,data){try{(settings.iStateDuration===-1?sessionStorage:localStorage).setItem('DataTables_'+settings.sInstance+'_'+location.pathname,JSON.stringify(data));}catch(e){}},/**
         * Callback which allows modification of the state to be saved. Called when the table
         * has changed state a new state save is required. This method allows modification of
         * the state saving object prior to actually doing the save, including addition or
         * other state properties or modification. Note that for plug-in authors, you should
         * use the `stateSaveParams` event to save parameters for a plug-in.
         *  @type function
         *  @param {object} settings DataTables settings object
         *  @param {object} data The state object to be saved
         *
         *  @dtopt Callbacks
         *  @name DataTable.defaults.stateSaveParams
         *
         *  @example
         *    // Remove a saved filter, so filtering is never saved
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateSave": true,
         *        "stateSaveParams": function (settings, data) {
         *          data.oSearch.sSearch = "";
         *        }
         *      } );
         *    } );
         */"fnStateSaveParams":null,/**
         * Duration for which the saved state information is considered valid. After this period
         * has elapsed the state will be returned to the default.
         * Value is given in seconds.
         *  @type int
         *  @default 7200 <i>(2 hours)</i>
         *
         *  @dtopt Options
         *  @name DataTable.defaults.stateDuration
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "stateDuration": 60*60*24; // 1 day
         *      } );
         *    } )
         */"iStateDuration":7200,/**
         * When enabled DataTables will not make a request to the server for the first
         * page draw - rather it will use the data already on the page (no sorting etc
         * will be applied to it), thus saving on an XHR at load time. `deferLoading`
         * is used to indicate that deferred loading is required, but it is also used
         * to tell DataTables how many records there are in the full table (allowing
         * the information element and pagination to be displayed correctly). In the case
         * where a filtering is applied to the table on initial load, this can be
         * indicated by giving the parameter as an array, where the first element is
         * the number of records available after filtering and the second element is the
         * number of records without filtering (allowing the table information element
         * to be shown correctly).
         *  @type int | array
         *  @default null
         *
         *  @dtopt Options
         *  @name DataTable.defaults.deferLoading
         *
         *  @example
         *    // 57 records available in the table, no filtering applied
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "serverSide": true,
         *        "ajax": "scripts/server_processing.php",
         *        "deferLoading": 57
         *      } );
         *    } );
         *
         *  @example
         *    // 57 records after filtering, 100 without filtering (an initial filter applied)
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "serverSide": true,
         *        "ajax": "scripts/server_processing.php",
         *        "deferLoading": [ 57, 100 ],
         *        "search": {
         *          "search": "my_filter"
         *        }
         *      } );
         *    } );
         */"iDeferLoading":null,/**
         * Number of rows to display on a single page when using pagination. If
         * feature enabled (`lengthChange`) then the end user will be able to override
         * this to a custom setting using a pop-up menu.
         *  @type int
         *  @default 10
         *
         *  @dtopt Options
         *  @name DataTable.defaults.pageLength
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "pageLength": 50
         *      } );
         *    } )
         */"iDisplayLength":10,/**
         * Define the starting point for data display when using DataTables with
         * pagination. Note that this parameter is the number of records, rather than
         * the page number, so if you have 10 records per page and want to start on
         * the third page, it should be "20".
         *  @type int
         *  @default 0
         *
         *  @dtopt Options
         *  @name DataTable.defaults.displayStart
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "displayStart": 20
         *      } );
         *    } )
         */"iDisplayStart":0,/**
         * By default DataTables allows keyboard navigation of the table (sorting, paging,
         * and filtering) by adding a `tabindex` attribute to the required elements. This
         * allows you to tab through the controls and press the enter key to activate them.
         * The tabindex is default 0, meaning that the tab follows the flow of the document.
         * You can overrule this using this parameter if you wish. Use a value of -1 to
         * disable built-in keyboard navigation.
         *  @type int
         *  @default 0
         *
         *  @dtopt Options
         *  @name DataTable.defaults.tabIndex
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "tabIndex": 1
         *      } );
         *    } );
         */"iTabIndex":0,/**
         * Classes that DataTables assigns to the various components and features
         * that it adds to the HTML table. This allows classes to be configured
         * during initialisation in addition to through the static
         * {@link DataTable.ext.oStdClasses} object).
         *  @namespace
         *  @name DataTable.defaults.classes
         */"oClasses":{},/**
         * All strings that DataTables uses in the user interface that it creates
         * are defined in this object, allowing you to modified them individually or
         * completely replace them all as required.
         *  @namespace
         *  @name DataTable.defaults.language
         */"oLanguage":{/**
             * Strings that are used for WAI-ARIA labels and controls only (these are not
             * actually visible on the page, but will be read by screenreaders, and thus
             * must be internationalised as well).
             *  @namespace
             *  @name DataTable.defaults.language.aria
             */"oAria":{/**
                 * ARIA label that is added to the table headers when the column may be
                 * sorted ascending by activing the column (click or return when focused).
                 * Note that the column header is prefixed to this string.
                 *  @type string
                 *  @default : activate to sort column ascending
                 *
                 *  @dtopt Language
                 *  @name DataTable.defaults.language.aria.sortAscending
                 *
                 *  @example
                 *    $(document).ready( function() {
                 *      $('#example').dataTable( {
                 *        "language": {
                 *          "aria": {
                 *            "sortAscending": " - click/return to sort ascending"
                 *          }
                 *        }
                 *      } );
                 *    } );
                 */"sSortAscending":": activate to sort column ascending",/**
                 * ARIA label that is added to the table headers when the column may be
                 * sorted descending by activing the column (click or return when focused).
                 * Note that the column header is prefixed to this string.
                 *  @type string
                 *  @default : activate to sort column ascending
                 *
                 *  @dtopt Language
                 *  @name DataTable.defaults.language.aria.sortDescending
                 *
                 *  @example
                 *    $(document).ready( function() {
                 *      $('#example').dataTable( {
                 *        "language": {
                 *          "aria": {
                 *            "sortDescending": " - click/return to sort descending"
                 *          }
                 *        }
                 *      } );
                 *    } );
                 */"sSortDescending":": activate to sort column descending"},/**
             * Pagination string used by DataTables for the built-in pagination
             * control types.
             *  @namespace
             *  @name DataTable.defaults.language.paginate
             */"oPaginate":{/**
                 * Text to use when using the 'full_numbers' type of pagination for the
                 * button to take the user to the first page.
                 *  @type string
                 *  @default First
                 *
                 *  @dtopt Language
                 *  @name DataTable.defaults.language.paginate.first
                 *
                 *  @example
                 *    $(document).ready( function() {
                 *      $('#example').dataTable( {
                 *        "language": {
                 *          "paginate": {
                 *            "first": "First page"
                 *          }
                 *        }
                 *      } );
                 *    } );
                 */"sFirst":"First",/**
                 * Text to use when using the 'full_numbers' type of pagination for the
                 * button to take the user to the last page.
                 *  @type string
                 *  @default Last
                 *
                 *  @dtopt Language
                 *  @name DataTable.defaults.language.paginate.last
                 *
                 *  @example
                 *    $(document).ready( function() {
                 *      $('#example').dataTable( {
                 *        "language": {
                 *          "paginate": {
                 *            "last": "Last page"
                 *          }
                 *        }
                 *      } );
                 *    } );
                 */"sLast":"Last",/**
                 * Text to use for the 'next' pagination button (to take the user to the
                 * next page).
                 *  @type string
                 *  @default Next
                 *
                 *  @dtopt Language
                 *  @name DataTable.defaults.language.paginate.next
                 *
                 *  @example
                 *    $(document).ready( function() {
                 *      $('#example').dataTable( {
                 *        "language": {
                 *          "paginate": {
                 *            "next": "Next page"
                 *          }
                 *        }
                 *      } );
                 *    } );
                 */"sNext":"Next",/**
                 * Text to use for the 'previous' pagination button (to take the user to
                 * the previous page).
                 *  @type string
                 *  @default Previous
                 *
                 *  @dtopt Language
                 *  @name DataTable.defaults.language.paginate.previous
                 *
                 *  @example
                 *    $(document).ready( function() {
                 *      $('#example').dataTable( {
                 *        "language": {
                 *          "paginate": {
                 *            "previous": "Previous page"
                 *          }
                 *        }
                 *      } );
                 *    } );
                 */"sPrevious":"Previous"},/**
             * This string is shown in preference to `zeroRecords` when the table is
             * empty of data (regardless of filtering). Note that this is an optional
             * parameter - if it is not given, the value of `zeroRecords` will be used
             * instead (either the default or given value).
             *  @type string
             *  @default No data available in table
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.emptyTable
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "emptyTable": "No data available in table"
             *        }
             *      } );
             *    } );
             */"sEmptyTable":"No data available in table",/**
             * This string gives information to the end user about the information
             * that is current on display on the page. The following tokens can be
             * used in the string and will be dynamically replaced as the table
             * display updates. This tokens can be placed anywhere in the string, or
             * removed as needed by the language requires:
             *
             * * `\_START\_` - Display index of the first record on the current page
             * * `\_END\_` - Display index of the last record on the current page
             * * `\_TOTAL\_` - Number of records in the table after filtering
             * * `\_MAX\_` - Number of records in the table without filtering
             * * `\_PAGE\_` - Current page number
             * * `\_PAGES\_` - Total number of pages of data in the table
             *
             *  @type string
             *  @default Showing _START_ to _END_ of _TOTAL_ entries
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.info
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "info": "Showing page _PAGE_ of _PAGES_"
             *        }
             *      } );
             *    } );
             */"sInfo":"Showing _START_ to _END_ of _TOTAL_ entries",/**
             * Display information string for when the table is empty. Typically the
             * format of this string should match `info`.
             *  @type string
             *  @default Showing 0 to 0 of 0 entries
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.infoEmpty
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "infoEmpty": "No entries to show"
             *        }
             *      } );
             *    } );
             */"sInfoEmpty":"Showing 0 to 0 of 0 entries",/**
             * When a user filters the information in a table, this string is appended
             * to the information (`info`) to give an idea of how strong the filtering
             * is. The variable _MAX_ is dynamically updated.
             *  @type string
             *  @default (filtered from _MAX_ total entries)
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.infoFiltered
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "infoFiltered": " - filtering from _MAX_ records"
             *        }
             *      } );
             *    } );
             */"sInfoFiltered":"(filtered from _MAX_ total entries)",/**
             * If can be useful to append extra information to the info string at times,
             * and this variable does exactly that. This information will be appended to
             * the `info` (`infoEmpty` and `infoFiltered` in whatever combination they are
             * being used) at all times.
             *  @type string
             *  @default <i>Empty string</i>
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.infoPostFix
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "infoPostFix": "All records shown are derived from real information."
             *        }
             *      } );
             *    } );
             */"sInfoPostFix":"",/**
             * This decimal place operator is a little different from the other
             * language options since DataTables doesn't output floating point
             * numbers, so it won't ever use this for display of a number. Rather,
             * what this parameter does is modify the sort methods of the table so
             * that numbers which are in a format which has a character other than
             * a period (`.`) as a decimal place will be sorted numerically.
             *
             * Note that numbers with different decimal places cannot be shown in
             * the same table and still be sortable, the table must be consistent.
             * However, multiple different tables on the page can use different
             * decimal place characters.
             *  @type string
             *  @default
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.decimal
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "decimal": ","
             *          "thousands": "."
             *        }
             *      } );
             *    } );
             */"sDecimal":"",/**
             * DataTables has a build in number formatter (`formatNumber`) which is
             * used to format large numbers that are used in the table information.
             * By default a comma is used, but this can be trivially changed to any
             * character you wish with this parameter.
             *  @type string
             *  @default ,
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.thousands
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "thousands": "'"
             *        }
             *      } );
             *    } );
             */"sThousands":",",/**
             * Detail the action that will be taken when the drop down menu for the
             * pagination length option is changed. The '_MENU_' variable is replaced
             * with a default select list of 10, 25, 50 and 100, and can be replaced
             * with a custom select box if required.
             *  @type string
             *  @default Show _MENU_ entries
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.lengthMenu
             *
             *  @example
             *    // Language change only
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "lengthMenu": "Display _MENU_ records"
             *        }
             *      } );
             *    } );
             *
             *  @example
             *    // Language and options change
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "lengthMenu": 'Display <select>'+
             *            '<option value="10">10</option>'+
             *            '<option value="20">20</option>'+
             *            '<option value="30">30</option>'+
             *            '<option value="40">40</option>'+
             *            '<option value="50">50</option>'+
             *            '<option value="-1">All</option>'+
             *            '</select> records'
             *        }
             *      } );
             *    } );
             */"sLengthMenu":"Show _MENU_ entries",/**
             * When using Ajax sourced data and during the first draw when DataTables is
             * gathering the data, this message is shown in an empty row in the table to
             * indicate to the end user the the data is being loaded. Note that this
             * parameter is not used when loading data by server-side processing, just
             * Ajax sourced data with client-side processing.
             *  @type string
             *  @default Loading...
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.loadingRecords
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "loadingRecords": "Please wait - loading..."
             *        }
             *      } );
             *    } );
             */"sLoadingRecords":"Loading...",/**
             * Text which is displayed when the table is processing a user action
             * (usually a sort command or similar).
             *  @type string
             *  @default Processing...
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.processing
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "processing": "DataTables is currently busy"
             *        }
             *      } );
             *    } );
             */"sProcessing":"Processing...",/**
             * Details the actions that will be taken when the user types into the
             * filtering input text box. The variable "_INPUT_", if used in the string,
             * is replaced with the HTML text box for the filtering input allowing
             * control over where it appears in the string. If "_INPUT_" is not given
             * then the input box is appended to the string automatically.
             *  @type string
             *  @default Search:
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.search
             *
             *  @example
             *    // Input text box will be appended at the end automatically
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "search": "Filter records:"
             *        }
             *      } );
             *    } );
             *
             *  @example
             *    // Specify where the filter should appear
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "search": "Apply filter _INPUT_ to table"
             *        }
             *      } );
             *    } );
             */"sSearch":"Search:",/**
             * Assign a `placeholder` attribute to the search `input` element
             *  @type string
             *  @default
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.searchPlaceholder
             */"sSearchPlaceholder":"",/**
             * All of the language information can be stored in a file on the
             * server-side, which DataTables will look up if this parameter is passed.
             * It must store the URL of the language file, which is in a JSON format,
             * and the object has the same properties as the oLanguage object in the
             * initialiser object (i.e. the above parameters). Please refer to one of
             * the example language files to see how this works in action.
             *  @type string
             *  @default <i>Empty string - i.e. disabled</i>
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.url
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "url": "http://www.sprymedia.co.uk/dataTables/lang.txt"
             *        }
             *      } );
             *    } );
             */"sUrl":"",/**
             * Text shown inside the table records when the is no information to be
             * displayed after filtering. `emptyTable` is shown when there is simply no
             * information in the table at all (regardless of filtering).
             *  @type string
             *  @default No matching records found
             *
             *  @dtopt Language
             *  @name DataTable.defaults.language.zeroRecords
             *
             *  @example
             *    $(document).ready( function() {
             *      $('#example').dataTable( {
             *        "language": {
             *          "zeroRecords": "No records to display"
             *        }
             *      } );
             *    } );
             */"sZeroRecords":"No matching records found"},/**
         * This parameter allows you to have define the global filtering state at
         * initialisation time. As an object the `search` parameter must be
         * defined, but all other parameters are optional. When `regex` is true,
         * the search string will be treated as a regular expression, when false
         * (default) it will be treated as a straight string. When `smart`
         * DataTables will use it's smart filtering methods (to word match at
         * any point in the data), when false this will not be done.
         *  @namespace
         *  @extends DataTable.models.oSearch
         *
         *  @dtopt Options
         *  @name DataTable.defaults.search
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "search": {"search": "Initial search"}
         *      } );
         *    } )
         */"oSearch":$.extend({},DataTable.models.oSearch),/**
         * __Deprecated__ The functionality provided by this parameter has now been
         * superseded by that provided through `ajax`, which should be used instead.
         *
         * By default DataTables will look for the property `data` (or `aaData` for
         * compatibility with DataTables 1.9-) when obtaining data from an Ajax
         * source or for server-side processing - this parameter allows that
         * property to be changed. You can use Javascript dotted object notation to
         * get a data source for multiple levels of nesting.
         *  @type string
         *  @default data
         *
         *  @dtopt Options
         *  @dtopt Server-side
         *  @name DataTable.defaults.ajaxDataProp
         *
         *  @deprecated 1.10. Please use `ajax` for this functionality now.
         */"sAjaxDataProp":"data",/**
         * __Deprecated__ The functionality provided by this parameter has now been
         * superseded by that provided through `ajax`, which should be used instead.
         *
         * You can instruct DataTables to load data from an external
         * source using this parameter (use aData if you want to pass data in you
         * already have). Simply provide a url a JSON object can be obtained from.
         *  @type string
         *  @default null
         *
         *  @dtopt Options
         *  @dtopt Server-side
         *  @name DataTable.defaults.ajaxSource
         *
         *  @deprecated 1.10. Please use `ajax` for this functionality now.
         */"sAjaxSource":null,/**
         * This initialisation variable allows you to specify exactly where in the
         * DOM you want DataTables to inject the various controls it adds to the page
         * (for example you might want the pagination controls at the top of the
         * table). DIV elements (with or without a custom class) can also be added to
         * aid styling. The follow syntax is used:
         *   <ul>
         *     <li>The following options are allowed:
         *       <ul>
         *         <li>'l' - Length changing</li>
         *         <li>'f' - Filtering input</li>
         *         <li>'t' - The table!</li>
         *         <li>'i' - Information</li>
         *         <li>'p' - Pagination</li>
         *         <li>'r' - pRocessing</li>
         *       </ul>
         *     </li>
         *     <li>The following constants are allowed:
         *       <ul>
         *         <li>'H' - jQueryUI theme "header" classes ('fg-toolbar ui-widget-header ui-corner-tl ui-corner-tr ui-helper-clearfix')</li>
         *         <li>'F' - jQueryUI theme "footer" classes ('fg-toolbar ui-widget-header ui-corner-bl ui-corner-br ui-helper-clearfix')</li>
         *       </ul>
         *     </li>
         *     <li>The following syntax is expected:
         *       <ul>
         *         <li>'&lt;' and '&gt;' - div elements</li>
         *         <li>'&lt;"class" and '&gt;' - div with a class</li>
         *         <li>'&lt;"#id" and '&gt;' - div with an ID</li>
         *       </ul>
         *     </li>
         *     <li>Examples:
         *       <ul>
         *         <li>'&lt;"wrapper"flipt&gt;'</li>
         *         <li>'&lt;lf&lt;t&gt;ip&gt;'</li>
         *       </ul>
         *     </li>
         *   </ul>
         *  @type string
         *  @default lfrtip <i>(when `jQueryUI` is false)</i> <b>or</b>
         *    <"H"lfr>t<"F"ip> <i>(when `jQueryUI` is true)</i>
         *
         *  @dtopt Options
         *  @name DataTable.defaults.dom
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "dom": '&lt;"top"i&gt;rt&lt;"bottom"flp&gt;&lt;"clear"&gt;'
         *      } );
         *    } );
         */"sDom":"lfrtip",/**
         * Search delay option. This will throttle full table searches that use the
         * DataTables provided search input element (it does not effect calls to
         * `dt-api search()`, providing a delay before the search is made.
         *  @type integer
         *  @default 0
         *
         *  @dtopt Options
         *  @name DataTable.defaults.searchDelay
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "searchDelay": 200
         *      } );
         *    } )
         */"searchDelay":null,/**
         * DataTables features six different built-in options for the buttons to
         * display for pagination control:
         *
         * * `numbers` - Page number buttons only
         * * `simple` - 'Previous' and 'Next' buttons only
         * * 'simple_numbers` - 'Previous' and 'Next' buttons, plus page numbers
         * * `full` - 'First', 'Previous', 'Next' and 'Last' buttons
         * * `full_numbers` - 'First', 'Previous', 'Next' and 'Last' buttons, plus page numbers
         * * `first_last_numbers` - 'First' and 'Last' buttons, plus page numbers
         *
         * Further methods can be added using {@link DataTable.ext.oPagination}.
         *  @type string
         *  @default simple_numbers
         *
         *  @dtopt Options
         *  @name DataTable.defaults.pagingType
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "pagingType": "full_numbers"
         *      } );
         *    } )
         */"sPaginationType":"simple_numbers",/**
         * Enable horizontal scrolling. When a table is too wide to fit into a
         * certain layout, or you have a large number of columns in the table, you
         * can enable x-scrolling to show the table in a viewport, which can be
         * scrolled. This property can be `true` which will allow the table to
         * scroll horizontally when needed, or any CSS unit, or a number (in which
         * case it will be treated as a pixel measurement). Setting as simply `true`
         * is recommended.
         *  @type boolean|string
         *  @default <i>blank string - i.e. disabled</i>
         *
         *  @dtopt Features
         *  @name DataTable.defaults.scrollX
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "scrollX": true,
         *        "scrollCollapse": true
         *      } );
         *    } );
         */"sScrollX":"",/**
         * This property can be used to force a DataTable to use more width than it
         * might otherwise do when x-scrolling is enabled. For example if you have a
         * table which requires to be well spaced, this parameter is useful for
         * "over-sizing" the table, and thus forcing scrolling. This property can by
         * any CSS unit, or a number (in which case it will be treated as a pixel
         * measurement).
         *  @type string
         *  @default <i>blank string - i.e. disabled</i>
         *
         *  @dtopt Options
         *  @name DataTable.defaults.scrollXInner
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "scrollX": "100%",
         *        "scrollXInner": "110%"
         *      } );
         *    } );
         */"sScrollXInner":"",/**
         * Enable vertical scrolling. Vertical scrolling will constrain the DataTable
         * to the given height, and enable scrolling for any data which overflows the
         * current viewport. This can be used as an alternative to paging to display
         * a lot of data in a small area (although paging and scrolling can both be
         * enabled at the same time). This property can be any CSS unit, or a number
         * (in which case it will be treated as a pixel measurement).
         *  @type string
         *  @default <i>blank string - i.e. disabled</i>
         *
         *  @dtopt Features
         *  @name DataTable.defaults.scrollY
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "scrollY": "200px",
         *        "paginate": false
         *      } );
         *    } );
         */"sScrollY":"",/**
         * __Deprecated__ The functionality provided by this parameter has now been
         * superseded by that provided through `ajax`, which should be used instead.
         *
         * Set the HTTP method that is used to make the Ajax call for server-side
         * processing or Ajax sourced data.
         *  @type string
         *  @default GET
         *
         *  @dtopt Options
         *  @dtopt Server-side
         *  @name DataTable.defaults.serverMethod
         *
         *  @deprecated 1.10. Please use `ajax` for this functionality now.
         */"sServerMethod":"GET",/**
         * DataTables makes use of renderers when displaying HTML elements for
         * a table. These renderers can be added or modified by plug-ins to
         * generate suitable mark-up for a site. For example the Bootstrap
         * integration plug-in for DataTables uses a paging button renderer to
         * display pagination buttons in the mark-up required by Bootstrap.
         *
         * For further information about the renderers available see
         * DataTable.ext.renderer
         *  @type string|object
         *  @default null
         *
         *  @name DataTable.defaults.renderer
         *
         */"renderer":null,/**
         * Set the data property name that DataTables should use to get a row's id
         * to set as the `id` property in the node.
         *  @type string
         *  @default DT_RowId
         *
         *  @name DataTable.defaults.rowId
         */"rowId":"DT_RowId"};_fnHungarianMap(DataTable.defaults);/*
	 * Developer note - See note in model.defaults.js about the use of Hungarian
	 * notation and camel case.
	 */ /**
     * Column options that can be given to DataTables at initialisation time.
     *  @namespace
     */DataTable.defaults.column={/**
         * Define which column(s) an order will occur on for this column. This
         * allows a column's ordering to take multiple columns into account when
         * doing a sort or use the data from a different column. For example first
         * name / last name columns make sense to do a multi-column sort over the
         * two columns.
         *  @type array|int
         *  @default null <i>Takes the value of the column index automatically</i>
         *
         *  @name DataTable.defaults.column.orderData
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "orderData": [ 0, 1 ], "targets": [ 0 ] },
         *          { "orderData": [ 1, 0 ], "targets": [ 1 ] },
         *          { "orderData": 2, "targets": [ 2 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "orderData": [ 0, 1 ] },
         *          { "orderData": [ 1, 0 ] },
         *          { "orderData": 2 },
         *          null,
         *          null
         *        ]
         *      } );
         *    } );
         */"aDataSort":null,"iDataSort":-1,/**
         * You can control the default ordering direction, and even alter the
         * behaviour of the sort handler (i.e. only allow ascending ordering etc)
         * using this parameter.
         *  @type array
         *  @default [ 'asc', 'desc' ]
         *
         *  @name DataTable.defaults.column.orderSequence
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "orderSequence": [ "asc" ], "targets": [ 1 ] },
         *          { "orderSequence": [ "desc", "asc", "asc" ], "targets": [ 2 ] },
         *          { "orderSequence": [ "desc" ], "targets": [ 3 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          null,
         *          { "orderSequence": [ "asc" ] },
         *          { "orderSequence": [ "desc", "asc", "asc" ] },
         *          { "orderSequence": [ "desc" ] },
         *          null
         *        ]
         *      } );
         *    } );
         */"asSorting":['asc','desc'],/**
         * Enable or disable filtering on the data in this column.
         *  @type boolean
         *  @default true
         *
         *  @name DataTable.defaults.column.searchable
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "searchable": false, "targets": [ 0 ] }
         *        ] } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "searchable": false },
         *          null,
         *          null,
         *          null,
         *          null
         *        ] } );
         *    } );
         */"bSearchable":true,/**
         * Enable or disable ordering on this column.
         *  @type boolean
         *  @default true
         *
         *  @name DataTable.defaults.column.orderable
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "orderable": false, "targets": [ 0 ] }
         *        ] } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "orderable": false },
         *          null,
         *          null,
         *          null,
         *          null
         *        ] } );
         *    } );
         */"bSortable":true,/**
         * Enable or disable the display of this column.
         *  @type boolean
         *  @default true
         *
         *  @name DataTable.defaults.column.visible
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "visible": false, "targets": [ 0 ] }
         *        ] } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "visible": false },
         *          null,
         *          null,
         *          null,
         *          null
         *        ] } );
         *    } );
         */"bVisible":true,/**
         * Developer definable function that is called whenever a cell is created (Ajax source,
         * etc) or processed for input (DOM source). This can be used as a compliment to mRender
         * allowing you to modify the DOM element (add background colour for example) when the
         * element is available.
         *  @type function
         *  @param {element} td The TD node that has been created
         *  @param {*} cellData The Data for the cell
         *  @param {array|object} rowData The data for the whole row
         *  @param {int} row The row index for the aoData data store
         *  @param {int} col The column index for aoColumns
         *
         *  @name DataTable.defaults.column.createdCell
         *  @dtopt Columns
         *
         *  @example
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [3],
         *          "createdCell": function (td, cellData, rowData, row, col) {
         *            if ( cellData == "1.7" ) {
         *              $(td).css('color', 'blue')
         *            }
         *          }
         *        } ]
         *      });
         *    } );
         */"fnCreatedCell":null,/**
         * This parameter has been replaced by `data` in DataTables to ensure naming
         * consistency. `dataProp` can still be used, as there is backwards
         * compatibility in DataTables for this option, but it is strongly
         * recommended that you use `data` in preference to `dataProp`.
         *  @name DataTable.defaults.column.dataProp
         */ /**
         * This property can be used to read data from any data source property,
         * including deeply nested objects / properties. `data` can be given in a
         * number of different ways which effect its behaviour:
         *
         * * `integer` - treated as an array index for the data source. This is the
         *   default that DataTables uses (incrementally increased for each column).
         * * `string` - read an object property from the data source. There are
         *   three 'special' options that can be used in the string to alter how
         *   DataTables reads the data from the source object:
         *    * `.` - Dotted Javascript notation. Just as you use a `.` in
         *      Javascript to read from nested objects, so to can the options
         *      specified in `data`. For example: `browser.version` or
         *      `browser.name`. If your object parameter name contains a period, use
         *      `\\` to escape it - i.e. `first\\.name`.
         *    * `[]` - Array notation. DataTables can automatically combine data
         *      from and array source, joining the data with the characters provided
         *      between the two brackets. For example: `name[, ]` would provide a
         *      comma-space separated list from the source array. If no characters
         *      are provided between the brackets, the original array source is
         *      returned.
         *    * `()` - Function notation. Adding `()` to the end of a parameter will
         *      execute a function of the name given. For example: `browser()` for a
         *      simple function on the data source, `browser.version()` for a
         *      function in a nested property or even `browser().version` to get an
         *      object property if the function called returns an object. Note that
         *      function notation is recommended for use in `render` rather than
         *      `data` as it is much simpler to use as a renderer.
         * * `null` - use the original data source for the row rather than plucking
         *   data directly from it. This action has effects on two other
         *   initialisation options:
         *    * `defaultContent` - When null is given as the `data` option and
         *      `defaultContent` is specified for the column, the value defined by
         *      `defaultContent` will be used for the cell.
         *    * `render` - When null is used for the `data` option and the `render`
         *      option is specified for the column, the whole data source for the
         *      row is used for the renderer.
         * * `function` - the function given will be executed whenever DataTables
         *   needs to set or get the data for a cell in the column. The function
         *   takes three parameters:
         *    * Parameters:
         *      * `{array|object}` The data source for the row
         *      * `{string}` The type call data requested - this will be 'set' when
         *        setting data or 'filter', 'display', 'type', 'sort' or undefined
         *        when gathering data. Note that when `undefined` is given for the
         *        type DataTables expects to get the raw data for the object back<
         *      * `{*}` Data to set when the second parameter is 'set'.
         *    * Return:
         *      * The return value from the function is not required when 'set' is
         *        the type of call, but otherwise the return is what will be used
         *        for the data requested.
         *
         * Note that `data` is a getter and setter option. If you just require
         * formatting of data for output, you will likely want to use `render` which
         * is simply a getter and thus simpler to use.
         *
         * Note that prior to DataTables 1.9.2 `data` was called `mDataProp`. The
         * name change reflects the flexibility of this property and is consistent
         * with the naming of mRender. If 'mDataProp' is given, then it will still
         * be used by DataTables, as it automatically maps the old name to the new
         * if required.
         *
         *  @type string|int|function|null
         *  @default null <i>Use automatically calculated column index</i>
         *
         *  @name DataTable.defaults.column.data
         *  @dtopt Columns
         *
         *  @example
         *    // Read table data from objects
         *    // JSON structure for each row:
         *    //   {
         *    //      "engine": {value},
         *    //      "browser": {value},
         *    //      "platform": {value},
         *    //      "version": {value},
         *    //      "grade": {value}
         *    //   }
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "ajaxSource": "sources/objects.txt",
         *        "columns": [
         *          { "data": "engine" },
         *          { "data": "browser" },
         *          { "data": "platform" },
         *          { "data": "version" },
         *          { "data": "grade" }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Read information from deeply nested objects
         *    // JSON structure for each row:
         *    //   {
         *    //      "engine": {value},
         *    //      "browser": {value},
         *    //      "platform": {
         *    //         "inner": {value}
         *    //      },
         *    //      "details": [
         *    //         {value}, {value}
         *    //      ]
         *    //   }
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "ajaxSource": "sources/deep.txt",
         *        "columns": [
         *          { "data": "engine" },
         *          { "data": "browser" },
         *          { "data": "platform.inner" },
         *          { "data": "details.0" },
         *          { "data": "details.1" }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `data` as a function to provide different information for
         *    // sorting, filtering and display. In this case, currency (price)
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "data": function ( source, type, val ) {
         *            if (type === 'set') {
         *              source.price = val;
         *              // Store the computed dislay and filter values for efficiency
         *              source.price_display = val=="" ? "" : "$"+numberFormat(val);
         *              source.price_filter  = val=="" ? "" : "$"+numberFormat(val)+" "+val;
         *              return;
         *            }
         *            else if (type === 'display') {
         *              return source.price_display;
         *            }
         *            else if (type === 'filter') {
         *              return source.price_filter;
         *            }
         *            // 'sort', 'type' and undefined all just use the integer
         *            return source.price;
         *          }
         *        } ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using default content
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "data": null,
         *          "defaultContent": "Click to edit"
         *        } ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using array notation - outputting a list from an array
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "data": "name[, ]"
         *        } ]
         *      } );
         *    } );
         *
         */"mData":null,/**
         * This property is the rendering partner to `data` and it is suggested that
         * when you want to manipulate data for display (including filtering,
         * sorting etc) without altering the underlying data for the table, use this
         * property. `render` can be considered to be the the read only companion to
         * `data` which is read / write (then as such more complex). Like `data`
         * this option can be given in a number of different ways to effect its
         * behaviour:
         *
         * * `integer` - treated as an array index for the data source. This is the
         *   default that DataTables uses (incrementally increased for each column).
         * * `string` - read an object property from the data source. There are
         *   three 'special' options that can be used in the string to alter how
         *   DataTables reads the data from the source object:
         *    * `.` - Dotted Javascript notation. Just as you use a `.` in
         *      Javascript to read from nested objects, so to can the options
         *      specified in `data`. For example: `browser.version` or
         *      `browser.name`. If your object parameter name contains a period, use
         *      `\\` to escape it - i.e. `first\\.name`.
         *    * `[]` - Array notation. DataTables can automatically combine data
         *      from and array source, joining the data with the characters provided
         *      between the two brackets. For example: `name[, ]` would provide a
         *      comma-space separated list from the source array. If no characters
         *      are provided between the brackets, the original array source is
         *      returned.
         *    * `()` - Function notation. Adding `()` to the end of a parameter will
         *      execute a function of the name given. For example: `browser()` for a
         *      simple function on the data source, `browser.version()` for a
         *      function in a nested property or even `browser().version` to get an
         *      object property if the function called returns an object.
         * * `object` - use different data for the different data types requested by
         *   DataTables ('filter', 'display', 'type' or 'sort'). The property names
         *   of the object is the data type the property refers to and the value can
         *   defined using an integer, string or function using the same rules as
         *   `render` normally does. Note that an `_` option _must_ be specified.
         *   This is the default value to use if you haven't specified a value for
         *   the data type requested by DataTables.
         * * `function` - the function given will be executed whenever DataTables
         *   needs to set or get the data for a cell in the column. The function
         *   takes three parameters:
         *    * Parameters:
         *      * {array|object} The data source for the row (based on `data`)
         *      * {string} The type call data requested - this will be 'filter',
         *        'display', 'type' or 'sort'.
         *      * {array|object} The full data source for the row (not based on
         *        `data`)
         *    * Return:
         *      * The return value from the function is what will be used for the
         *        data requested.
         *
         *  @type string|int|function|object|null
         *  @default null Use the data source value.
         *
         *  @name DataTable.defaults.column.render
         *  @dtopt Columns
         *
         *  @example
         *    // Create a comma separated list from an array of objects
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "ajaxSource": "sources/deep.txt",
         *        "columns": [
         *          { "data": "engine" },
         *          { "data": "browser" },
         *          {
         *            "data": "platform",
         *            "render": "[, ].name"
         *          }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Execute a function to obtain data
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "data": null, // Use the full data source object for the renderer's source
         *          "render": "browserName()"
         *        } ]
         *      } );
         *    } );
         *
         *  @example
         *    // As an object, extracting different data for the different types
         *    // This would be used with a data source such as:
         *    //   { "phone": 5552368, "phone_filter": "5552368 555-2368", "phone_display": "555-2368" }
         *    // Here the `phone` integer is used for sorting and type detection, while `phone_filter`
         *    // (which has both forms) is used for filtering for if a user inputs either format, while
         *    // the formatted phone number is the one that is shown in the table.
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "data": null, // Use the full data source object for the renderer's source
         *          "render": {
         *            "_": "phone",
         *            "filter": "phone_filter",
         *            "display": "phone_display"
         *          }
         *        } ]
         *      } );
         *    } );
         *
         *  @example
         *    // Use as a function to create a link from the data source
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "data": "download_link",
         *          "render": function ( data, type, full ) {
         *            return '<a href="'+data+'">Download</a>';
         *          }
         *        } ]
         *      } );
         *    } );
         */"mRender":null,/**
         * Change the cell type created for the column - either TD cells or TH cells. This
         * can be useful as TH cells have semantic meaning in the table body, allowing them
         * to act as a header for a row (you may wish to add scope='row' to the TH elements).
         *  @type string
         *  @default td
         *
         *  @name DataTable.defaults.column.cellType
         *  @dtopt Columns
         *
         *  @example
         *    // Make the first column use TH cells
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [ {
         *          "targets": [ 0 ],
         *          "cellType": "th"
         *        } ]
         *      } );
         *    } );
         */"sCellType":"td",/**
         * Class to give to each cell in this column.
         *  @type string
         *  @default <i>Empty string</i>
         *
         *  @name DataTable.defaults.column.class
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "class": "my_class", "targets": [ 0 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "class": "my_class" },
         *          null,
         *          null,
         *          null,
         *          null
         *        ]
         *      } );
         *    } );
         */"sClass":"",/**
         * When DataTables calculates the column widths to assign to each column,
         * it finds the longest string in each column and then constructs a
         * temporary table and reads the widths from that. The problem with this
         * is that "mmm" is much wider then "iiii", but the latter is a longer
         * string - thus the calculation can go wrong (doing it properly and putting
         * it into an DOM object and measuring that is horribly(!) slow). Thus as
         * a "work around" we provide this option. It will append its value to the
         * text that is found to be the longest string for the column - i.e. padding.
         * Generally you shouldn't need this!
         *  @type string
         *  @default <i>Empty string<i>
         *
         *  @name DataTable.defaults.column.contentPadding
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          null,
         *          null,
         *          null,
         *          {
         *            "contentPadding": "mmm"
         *          }
         *        ]
         *      } );
         *    } );
         */"sContentPadding":"",/**
         * Allows a default value to be given for a column's data, and will be used
         * whenever a null data source is encountered (this can be because `data`
         * is set to null, or because the data source itself is null).
         *  @type string
         *  @default null
         *
         *  @name DataTable.defaults.column.defaultContent
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          {
         *            "data": null,
         *            "defaultContent": "Edit",
         *            "targets": [ -1 ]
         *          }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          null,
         *          null,
         *          null,
         *          {
         *            "data": null,
         *            "defaultContent": "Edit"
         *          }
         *        ]
         *      } );
         *    } );
         */"sDefaultContent":null,/**
         * This parameter is only used in DataTables' server-side processing. It can
         * be exceptionally useful to know what columns are being displayed on the
         * client side, and to map these to database fields. When defined, the names
         * also allow DataTables to reorder information from the server if it comes
         * back in an unexpected order (i.e. if you switch your columns around on the
         * client-side, your server-side code does not also need updating).
         *  @type string
         *  @default <i>Empty string</i>
         *
         *  @name DataTable.defaults.column.name
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "name": "engine", "targets": [ 0 ] },
         *          { "name": "browser", "targets": [ 1 ] },
         *          { "name": "platform", "targets": [ 2 ] },
         *          { "name": "version", "targets": [ 3 ] },
         *          { "name": "grade", "targets": [ 4 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "name": "engine" },
         *          { "name": "browser" },
         *          { "name": "platform" },
         *          { "name": "version" },
         *          { "name": "grade" }
         *        ]
         *      } );
         *    } );
         */"sName":"",/**
         * Defines a data source type for the ordering which can be used to read
         * real-time information from the table (updating the internally cached
         * version) prior to ordering. This allows ordering to occur on user
         * editable elements such as form inputs.
         *  @type string
         *  @default std
         *
         *  @name DataTable.defaults.column.orderDataType
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "orderDataType": "dom-text", "targets": [ 2, 3 ] },
         *          { "type": "numeric", "targets": [ 3 ] },
         *          { "orderDataType": "dom-select", "targets": [ 4 ] },
         *          { "orderDataType": "dom-checkbox", "targets": [ 5 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          null,
         *          null,
         *          { "orderDataType": "dom-text" },
         *          { "orderDataType": "dom-text", "type": "numeric" },
         *          { "orderDataType": "dom-select" },
         *          { "orderDataType": "dom-checkbox" }
         *        ]
         *      } );
         *    } );
         */"sSortDataType":"std",/**
         * The title of this column.
         *  @type string
         *  @default null <i>Derived from the 'TH' value for this column in the
         *    original HTML table.</i>
         *
         *  @name DataTable.defaults.column.title
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "title": "My column title", "targets": [ 0 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "title": "My column title" },
         *          null,
         *          null,
         *          null,
         *          null
         *        ]
         *      } );
         *    } );
         */"sTitle":null,/**
         * The type allows you to specify how the data for this column will be
         * ordered. Four types (string, numeric, date and html (which will strip
         * HTML tags before ordering)) are currently available. Note that only date
         * formats understood by Javascript's Date() object will be accepted as type
         * date. For example: "Mar 26, 2008 5:03 PM". May take the values: 'string',
         * 'numeric', 'date' or 'html' (by default). Further types can be adding
         * through plug-ins.
         *  @type string
         *  @default null <i>Auto-detected from raw data</i>
         *
         *  @name DataTable.defaults.column.type
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "type": "html", "targets": [ 0 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "type": "html" },
         *          null,
         *          null,
         *          null,
         *          null
         *        ]
         *      } );
         *    } );
         */"sType":null,/**
         * Defining the width of the column, this parameter may take any CSS value
         * (3em, 20px etc). DataTables applies 'smart' widths to columns which have not
         * been given a specific width through this interface ensuring that the table
         * remains readable.
         *  @type string
         *  @default null <i>Automatic</i>
         *
         *  @name DataTable.defaults.column.width
         *  @dtopt Columns
         *
         *  @example
         *    // Using `columnDefs`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columnDefs": [
         *          { "width": "20%", "targets": [ 0 ] }
         *        ]
         *      } );
         *    } );
         *
         *  @example
         *    // Using `columns`
         *    $(document).ready( function() {
         *      $('#example').dataTable( {
         *        "columns": [
         *          { "width": "20%" },
         *          null,
         *          null,
         *          null,
         *          null
         *        ]
         *      } );
         *    } );
         */"sWidth":null};_fnHungarianMap(DataTable.defaults.column);/**
     * DataTables settings object - this holds all the information needed for a
     * given table, including configuration, data and current application of the
     * table options. DataTables does not have a single instance for each DataTable
     * with the settings attached to that instance, but rather instances of the
     * DataTable "class" are created on-the-fly as needed (typically by a
     * $().dataTable() call) and the settings object is then applied to that
     * instance.
     *
     * Note that this object is related to {@link DataTable.defaults} but this
     * one is the internal data store for DataTables's cache of columns. It should
     * NOT be manipulated outside of DataTables. Any configuration should be done
     * through the initialisation options.
     *  @namespace
     *  @todo Really should attach the settings object to individual instances so we
     *    don't need to create new instances on each $().dataTable() call (if the
     *    table already exists). It would also save passing oSettings around and
     *    into every single function. However, this is a very significant
     *    architecture change for DataTables and will almost certainly break
     *    backwards compatibility with older installations. This is something that
     *    will be done in 2.0.
     */DataTable.models.oSettings={/**
         * Primary features of DataTables and their enablement state.
         *  @namespace
         */"oFeatures":{/**
             * Flag to say if DataTables should automatically try to calculate the
             * optimum table and columns widths (true) or not (false).
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bAutoWidth":null,/**
             * Delay the creation of TR and TD elements until they are actually
             * needed by a driven page draw. This can give a significant speed
             * increase for Ajax source and Javascript source data, but makes no
             * difference at all fro DOM and server-side processing tables.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bDeferRender":null,/**
             * Enable filtering on the table or not. Note that if this is disabled
             * then there is no filtering at all on the table, including fnFilter.
             * To just remove the filtering input use sDom and remove the 'f' option.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bFilter":null,/**
             * Table information element (the 'Showing x of y records' div) enable
             * flag.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bInfo":null,/**
             * Present a user control allowing the end user to change the page size
             * when pagination is enabled.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bLengthChange":null,/**
             * Pagination enabled or not. Note that if this is disabled then length
             * changing must also be disabled.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bPaginate":null,/**
             * Processing indicator enable flag whenever DataTables is enacting a
             * user request - typically an Ajax request for server-side processing.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bProcessing":null,/**
             * Server-side processing enabled flag - when enabled DataTables will
             * get all data from the server for every draw - there is no filtering,
             * sorting or paging done on the client-side.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bServerSide":null,/**
             * Sorting enablement flag.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bSort":null,/**
             * Multi-column sorting
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bSortMulti":null,/**
             * Apply a class to the columns which are being sorted to provide a
             * visual highlight or not. This can slow things down when enabled since
             * there is a lot of DOM interaction.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bSortClasses":null,/**
             * State saving enablement flag.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bStateSave":null},/**
         * Scrolling settings for a table.
         *  @namespace
         */"oScroll":{/**
             * When the table is shorter in height than sScrollY, collapse the
             * table container down to the height of the table (when true).
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type boolean
             */"bCollapse":null,/**
             * Width of the scrollbar for the web-browser's platform. Calculated
             * during table initialisation.
             *  @type int
             *  @default 0
             */"iBarWidth":0,/**
             * Viewport width for horizontal scrolling. Horizontal scrolling is
             * disabled if an empty string.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type string
             */"sX":null,/**
             * Width to expand the table to when using x-scrolling. Typically you
             * should not need to use this.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type string
             *  @deprecated
             */"sXInner":null,/**
             * Viewport height for vertical scrolling. Vertical scrolling is disabled
             * if an empty string.
             * Note that this parameter will be set by the initialisation routine. To
             * set a default use {@link DataTable.defaults}.
             *  @type string
             */"sY":null},/**
         * Language information for the table.
         *  @namespace
         *  @extends DataTable.defaults.oLanguage
         */"oLanguage":{/**
             * Information callback function. See
             * {@link DataTable.defaults.fnInfoCallback}
             *  @type function
             *  @default null
             */"fnInfoCallback":null},/**
         * Browser support parameters
         *  @namespace
         */"oBrowser":{/**
             * Indicate if the browser incorrectly calculates width:100% inside a
             * scrolling element (IE6/7)
             *  @type boolean
             *  @default false
             */"bScrollOversize":false,/**
             * Determine if the vertical scrollbar is on the right or left of the
             * scrolling container - needed for rtl language layout, although not
             * all browsers move the scrollbar (Safari).
             *  @type boolean
             *  @default false
             */"bScrollbarLeft":false,/**
             * Flag for if `getBoundingClientRect` is fully supported or not
             *  @type boolean
             *  @default false
             */"bBounding":false,/**
             * Browser scrollbar width
             *  @type integer
             *  @default 0
             */"barWidth":0},"ajax":null,/**
         * Array referencing the nodes which are used for the features. The
         * parameters of this object match what is allowed by sDom - i.e.
         *   <ul>
         *     <li>'l' - Length changing</li>
         *     <li>'f' - Filtering input</li>
         *     <li>'t' - The table!</li>
         *     <li>'i' - Information</li>
         *     <li>'p' - Pagination</li>
         *     <li>'r' - pRocessing</li>
         *   </ul>
         *  @type array
         *  @default []
         */"aanFeatures":[],/**
         * Store data information - see {@link DataTable.models.oRow} for detailed
         * information.
         *  @type array
         *  @default []
         */"aoData":[],/**
         * Array of indexes which are in the current display (after filtering etc)
         *  @type array
         *  @default []
         */"aiDisplay":[],/**
         * Array of indexes for display - no filtering
         *  @type array
         *  @default []
         */"aiDisplayMaster":[],/**
         * Map of row ids to data indexes
         *  @type object
         *  @default {}
         */"aIds":{},/**
         * Store information about each column that is in use
         *  @type array
         *  @default []
         */"aoColumns":[],/**
         * Store information about the table's header
         *  @type array
         *  @default []
         */"aoHeader":[],/**
         * Store information about the table's footer
         *  @type array
         *  @default []
         */"aoFooter":[],/**
         * Store the applied global search information in case we want to force a
         * research or compare the old search to a new one.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @namespace
         *  @extends DataTable.models.oSearch
         */"oPreviousSearch":{},/**
         * Store the applied search for each column - see
         * {@link DataTable.models.oSearch} for the format that is used for the
         * filtering information for each column.
         *  @type array
         *  @default []
         */"aoPreSearchCols":[],/**
         * Sorting that is applied to the table. Note that the inner arrays are
         * used in the following manner:
         * <ul>
         *   <li>Index 0 - column number</li>
         *   <li>Index 1 - current sorting direction</li>
         * </ul>
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type array
         *  @todo These inner arrays should really be objects
         */"aaSorting":null,/**
         * Sorting that is always applied to the table (i.e. prefixed in front of
         * aaSorting).
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type array
         *  @default []
         */"aaSortingFixed":[],/**
         * Classes to use for the striping of a table.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type array
         *  @default []
         */"asStripeClasses":null,/**
         * If restoring a table - we should restore its striping classes as well
         *  @type array
         *  @default []
         */"asDestroyStripes":[],/**
         * If restoring a table - we should restore its width
         *  @type int
         *  @default 0
         */"sDestroyWidth":0,/**
         * Callback functions array for every time a row is inserted (i.e. on a draw).
         *  @type array
         *  @default []
         */"aoRowCallback":[],/**
         * Callback functions for the header on each draw.
         *  @type array
         *  @default []
         */"aoHeaderCallback":[],/**
         * Callback function for the footer on each draw.
         *  @type array
         *  @default []
         */"aoFooterCallback":[],/**
         * Array of callback functions for draw callback functions
         *  @type array
         *  @default []
         */"aoDrawCallback":[],/**
         * Array of callback functions for row created function
         *  @type array
         *  @default []
         */"aoRowCreatedCallback":[],/**
         * Callback functions for just before the table is redrawn. A return of
         * false will be used to cancel the draw.
         *  @type array
         *  @default []
         */"aoPreDrawCallback":[],/**
         * Callback functions for when the table has been initialised.
         *  @type array
         *  @default []
         */"aoInitComplete":[],/**
         * Callbacks for modifying the settings to be stored for state saving, prior to
         * saving state.
         *  @type array
         *  @default []
         */"aoStateSaveParams":[],/**
         * Callbacks for modifying the settings that have been stored for state saving
         * prior to using the stored values to restore the state.
         *  @type array
         *  @default []
         */"aoStateLoadParams":[],/**
         * Callbacks for operating on the settings object once the saved state has been
         * loaded
         *  @type array
         *  @default []
         */"aoStateLoaded":[],/**
         * Cache the table ID for quick access
         *  @type string
         *  @default <i>Empty string</i>
         */"sTableId":"",/**
         * The TABLE node for the main table
         *  @type node
         *  @default null
         */"nTable":null,/**
         * Permanent ref to the thead element
         *  @type node
         *  @default null
         */"nTHead":null,/**
         * Permanent ref to the tfoot element - if it exists
         *  @type node
         *  @default null
         */"nTFoot":null,/**
         * Permanent ref to the tbody element
         *  @type node
         *  @default null
         */"nTBody":null,/**
         * Cache the wrapper node (contains all DataTables controlled elements)
         *  @type node
         *  @default null
         */"nTableWrapper":null,/**
         * Indicate if when using server-side processing the loading of data
         * should be deferred until the second draw.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type boolean
         *  @default false
         */"bDeferLoading":false,/**
         * Indicate if all required information has been read in
         *  @type boolean
         *  @default false
         */"bInitialised":false,/**
         * Information about open rows. Each object in the array has the parameters
         * 'nTr' and 'nParent'
         *  @type array
         *  @default []
         */"aoOpenRows":[],/**
         * Dictate the positioning of DataTables' control elements - see
         * {@link DataTable.model.oInit.sDom}.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type string
         *  @default null
         */"sDom":null,/**
         * Search delay (in mS)
         *  @type integer
         *  @default null
         */"searchDelay":null,/**
         * Which type of pagination should be used.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type string
         *  @default two_button
         */"sPaginationType":"two_button",/**
         * The state duration (for `stateSave`) in seconds.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type int
         *  @default 0
         */"iStateDuration":0,/**
         * Array of callback functions for state saving. Each array element is an
         * object with the following parameters:
         *   <ul>
         *     <li>function:fn - function to call. Takes two parameters, oSettings
         *       and the JSON string to save that has been thus far created. Returns
         *       a JSON string to be inserted into a json object
         *       (i.e. '"param": [ 0, 1, 2]')</li>
         *     <li>string:sName - name of callback</li>
         *   </ul>
         *  @type array
         *  @default []
         */"aoStateSave":[],/**
         * Array of callback functions for state loading. Each array element is an
         * object with the following parameters:
         *   <ul>
         *     <li>function:fn - function to call. Takes two parameters, oSettings
         *       and the object stored. May return false to cancel state loading</li>
         *     <li>string:sName - name of callback</li>
         *   </ul>
         *  @type array
         *  @default []
         */"aoStateLoad":[],/**
         * State that was saved. Useful for back reference
         *  @type object
         *  @default null
         */"oSavedState":null,/**
         * State that was loaded. Useful for back reference
         *  @type object
         *  @default null
         */"oLoadedState":null,/**
         * Source url for AJAX data for the table.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type string
         *  @default null
         */"sAjaxSource":null,/**
         * Property from a given object from which to read the table data from. This
         * can be an empty string (when not server-side processing), in which case
         * it is  assumed an an array is given directly.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type string
         */"sAjaxDataProp":null,/**
         * Note if draw should be blocked while getting data
         *  @type boolean
         *  @default true
         */"bAjaxDataGet":true,/**
         * The last jQuery XHR object that was used for server-side data gathering.
         * This can be used for working with the XHR information in one of the
         * callbacks
         *  @type object
         *  @default null
         */"jqXHR":null,/**
         * JSON returned from the server in the last Ajax request
         *  @type object
         *  @default undefined
         */"json":undefined,/**
         * Data submitted as part of the last Ajax request
         *  @type object
         *  @default undefined
         */"oAjaxData":undefined,/**
         * Function to get the server-side data.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type function
         */"fnServerData":null,/**
         * Functions which are called prior to sending an Ajax request so extra
         * parameters can easily be sent to the server
         *  @type array
         *  @default []
         */"aoServerParams":[],/**
         * Send the XHR HTTP method - GET or POST (could be PUT or DELETE if
         * required).
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type string
         */"sServerMethod":null,/**
         * Format numbers for display.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type function
         */"fnFormatNumber":null,/**
         * List of options that can be used for the user selectable length menu.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type array
         *  @default []
         */"aLengthMenu":null,/**
         * Counter for the draws that the table does. Also used as a tracker for
         * server-side processing
         *  @type int
         *  @default 0
         */"iDraw":0,/**
         * Indicate if a redraw is being done - useful for Ajax
         *  @type boolean
         *  @default false
         */"bDrawing":false,/**
         * Draw index (iDraw) of the last error when parsing the returned data
         *  @type int
         *  @default -1
         */"iDrawError":-1,/**
         * Paging display length
         *  @type int
         *  @default 10
         */"_iDisplayLength":10,/**
         * Paging start point - aiDisplay index
         *  @type int
         *  @default 0
         */"_iDisplayStart":0,/**
         * Server-side processing - number of records in the result set
         * (i.e. before filtering), Use fnRecordsTotal rather than
         * this property to get the value of the number of records, regardless of
         * the server-side processing setting.
         *  @type int
         *  @default 0
         *  @private
         */"_iRecordsTotal":0,/**
         * Server-side processing - number of records in the current display set
         * (i.e. after filtering). Use fnRecordsDisplay rather than
         * this property to get the value of the number of records, regardless of
         * the server-side processing setting.
         *  @type boolean
         *  @default 0
         *  @private
         */"_iRecordsDisplay":0,/**
         * The classes to use for the table
         *  @type object
         *  @default {}
         */"oClasses":{},/**
         * Flag attached to the settings object so you can check in the draw
         * callback if filtering has been done in the draw. Deprecated in favour of
         * events.
         *  @type boolean
         *  @default false
         *  @deprecated
         */"bFiltered":false,/**
         * Flag attached to the settings object so you can check in the draw
         * callback if sorting has been done in the draw. Deprecated in favour of
         * events.
         *  @type boolean
         *  @default false
         *  @deprecated
         */"bSorted":false,/**
         * Indicate that if multiple rows are in the header and there is more than
         * one unique cell per column, if the top one (true) or bottom one (false)
         * should be used for sorting / title by DataTables.
         * Note that this parameter will be set by the initialisation routine. To
         * set a default use {@link DataTable.defaults}.
         *  @type boolean
         */"bSortCellsTop":null,/**
         * Initialisation object that is used for the table
         *  @type object
         *  @default null
         */"oInit":null,/**
         * Destroy callback functions - for plug-ins to attach themselves to the
         * destroy so they can clean up markup and events.
         *  @type array
         *  @default []
         */"aoDestroyCallback":[],/**
         * Get the number of records in the current record set, before filtering
         *  @type function
         */"fnRecordsTotal":function fnRecordsTotal(){return _fnDataSource(this)=='ssp'?this._iRecordsTotal*1:this.aiDisplayMaster.length;},/**
         * Get the number of records in the current record set, after filtering
         *  @type function
         */"fnRecordsDisplay":function fnRecordsDisplay(){return _fnDataSource(this)=='ssp'?this._iRecordsDisplay*1:this.aiDisplay.length;},/**
         * Get the display end point - aiDisplay index
         *  @type function
         */"fnDisplayEnd":function fnDisplayEnd(){var len=this._iDisplayLength,start=this._iDisplayStart,calc=start+len,records=this.aiDisplay.length,features=this.oFeatures,paginate=features.bPaginate;if(features.bServerSide){return paginate===false||len===-1?start+records:Math.min(start+len,this._iRecordsDisplay);}else{return!paginate||calc>records||len===-1?records:calc;}},/**
         * The DataTables object for this table
         *  @type object
         *  @default null
         */"oInstance":null,/**
         * Unique identifier for each instance of the DataTables object. If there
         * is an ID on the table node, then it takes that value, otherwise an
         * incrementing internal counter is used.
         *  @type string
         *  @default null
         */"sInstance":null,/**
         * tabindex attribute value that is added to DataTables control elements, allowing
         * keyboard navigation of the table and its controls.
         */"iTabIndex":0,/**
         * DIV container for the footer scrolling table if scrolling
         */"nScrollHead":null,/**
         * DIV container for the footer scrolling table if scrolling
         */"nScrollFoot":null,/**
         * Last applied sort
         *  @type array
         *  @default []
         */"aLastSort":[],/**
         * Stored plug-in instances
         *  @type object
         *  @default {}
         */"oPlugins":{},/**
         * Function used to get a row's id from the row's data
         *  @type function
         *  @default null
         */"rowIdFn":null,/**
         * Data location where to store a row's id
         *  @type string
         *  @default null
         */"rowId":null};/**
     * Extension object for DataTables that is used to provide all extension
     * options.
     *
     * Note that the `DataTable.ext` object is available through
     * `jQuery.fn.dataTable.ext` where it may be accessed and manipulated. It is
     * also aliased to `jQuery.fn.dataTableExt` for historic reasons.
     *  @namespace
     *  @extends DataTable.models.ext
     */ /**
     * DataTables extensions
     *
     * This namespace acts as a collection area for plug-ins that can be used to
     * extend DataTables capabilities. Indeed many of the build in methods
     * use this method to provide their own capabilities (sorting methods for
     * example).
     *
     * Note that this namespace is aliased to `jQuery.fn.dataTableExt` for legacy
     * reasons
     *
     *  @namespace
     */DataTable.ext=_ext={/**
         * Buttons. For use with the Buttons extension for DataTables. This is
         * defined here so other extensions can define buttons regardless of load
         * order. It is _not_ used by DataTables core.
         *
         *  @type object
         *  @default {}
         */buttons:{},/**
         * Element class names
         *
         *  @type object
         *  @default {}
         */classes:{},/**
         * DataTables build type (expanded by the download builder)
         *
         *  @type string
         */builder:"-source-",/**
         * Error reporting.
         *
         * How should DataTables report an error. Can take the value 'alert',
         * 'throw', 'none' or a function.
         *
         *  @type string|function
         *  @default alert
         */errMode:"alert",/**
         * Feature plug-ins.
         *
         * This is an array of objects which describe the feature plug-ins that are
         * available to DataTables. These feature plug-ins are then available for
         * use through the `dom` initialisation option.
         *
         * Each feature plug-in is described by an object which must have the
         * following properties:
         *
         * * `fnInit` - function that is used to initialise the plug-in,
         * * `cFeature` - a character so the feature can be enabled by the `dom`
         *   instillation option. This is case sensitive.
         *
         * The `fnInit` function has the following input parameters:
         *
         * 1. `{object}` DataTables settings object: see
         *    {@link DataTable.models.oSettings}
         *
         * And the following return is expected:
         *
         * * {node|null} The element which contains your feature. Note that the
         *   return may also be void if your plug-in does not require to inject any
         *   DOM elements into DataTables control (`dom`) - for example this might
         *   be useful when developing a plug-in which allows table control via
         *   keyboard entry
         *
         *  @type array
         *
         *  @example
         *    $.fn.dataTable.ext.features.push( {
         *      "fnInit": function( oSettings ) {
         *        return new TableTools( { "oDTSettings": oSettings } );
         *      },
         *      "cFeature": "T"
         *    } );
         */feature:[],/**
         * Row searching.
         *
         * This method of searching is complimentary to the default type based
         * searching, and a lot more comprehensive as it allows you complete control
         * over the searching logic. Each element in this array is a function
         * (parameters described below) that is called for every row in the table,
         * and your logic decides if it should be included in the searching data set
         * or not.
         *
         * Searching functions have the following input parameters:
         *
         * 1. `{object}` DataTables settings object: see
         *    {@link DataTable.models.oSettings}
         * 2. `{array|object}` Data for the row to be processed (same as the
         *    original format that was passed in as the data source, or an array
         *    from a DOM data source
         * 3. `{int}` Row index ({@link DataTable.models.oSettings.aoData}), which
         *    can be useful to retrieve the `TR` element if you need DOM interaction.
         *
         * And the following return is expected:
         *
         * * {boolean} Include the row in the searched result set (true) or not
         *   (false)
         *
         * Note that as with the main search ability in DataTables, technically this
         * is "filtering", since it is subtractive. However, for consistency in
         * naming we call it searching here.
         *
         *  @type array
         *  @default []
         *
         *  @example
         *    // The following example shows custom search being applied to the
         *    // fourth column (i.e. the data[3] index) based on two input values
         *    // from the end-user, matching the data in a certain range.
         *    $.fn.dataTable.ext.search.push(
         *      function( settings, data, dataIndex ) {
         *        var min = document.getElementById('min').value * 1;
         *        var max = document.getElementById('max').value * 1;
         *        var version = data[3] == "-" ? 0 : data[3]*1;
         *
         *        if ( min == "" && max == "" ) {
         *          return true;
         *        }
         *        else if ( min == "" && version < max ) {
         *          return true;
         *        }
         *        else if ( min < version && "" == max ) {
         *          return true;
         *        }
         *        else if ( min < version && version < max ) {
         *          return true;
         *        }
         *        return false;
         *      }
         *    );
         */search:[],/**
         * Selector extensions
         *
         * The `selector` option can be used to extend the options available for the
         * selector modifier options (`selector-modifier` object data type) that
         * each of the three built in selector types offer (row, column and cell +
         * their plural counterparts). For example the Select extension uses this
         * mechanism to provide an option to select only rows, columns and cells
         * that have been marked as selected by the end user (`{selected: true}`),
         * which can be used in conjunction with the existing built in selector
         * options.
         *
         * Each property is an array to which functions can be pushed. The functions
         * take three attributes:
         *
         * * Settings object for the host table
         * * Options object (`selector-modifier` object type)
         * * Array of selected item indexes
         *
         * The return is an array of the resulting item indexes after the custom
         * selector has been applied.
         *
         *  @type object
         */selector:{cell:[],column:[],row:[]},/**
         * Internal functions, exposed for used in plug-ins.
         *
         * Please note that you should not need to use the internal methods for
         * anything other than a plug-in (and even then, try to avoid if possible).
         * The internal function may change between releases.
         *
         *  @type object
         *  @default {}
         */internal:{},/**
         * Legacy configuration options. Enable and disable legacy options that
         * are available in DataTables.
         *
         *  @type object
         */legacy:{/**
             * Enable / disable DataTables 1.9 compatible server-side processing
             * requests
             *
             *  @type boolean
             *  @default null
             */ajax:null},/**
         * Pagination plug-in methods.
         *
         * Each entry in this object is a function and defines which buttons should
         * be shown by the pagination rendering method that is used for the table:
         * {@link DataTable.ext.renderer.pageButton}. The renderer addresses how the
         * buttons are displayed in the document, while the functions here tell it
         * what buttons to display. This is done by returning an array of button
         * descriptions (what each button will do).
         *
         * Pagination types (the four built in options and any additional plug-in
         * options defined here) can be used through the `paginationType`
         * initialisation parameter.
         *
         * The functions defined take two parameters:
         *
         * 1. `{int} page` The current page index
         * 2. `{int} pages` The number of pages in the table
         *
         * Each function is expected to return an array where each element of the
         * array can be one of:
         *
         * * `first` - Jump to first page when activated
         * * `last` - Jump to last page when activated
         * * `previous` - Show previous page when activated
         * * `next` - Show next page when activated
         * * `{int}` - Show page of the index given
         * * `{array}` - A nested array containing the above elements to add a
         *   containing 'DIV' element (might be useful for styling).
         *
         * Note that DataTables v1.9- used this object slightly differently whereby
         * an object with two functions would be defined for each plug-in. That
         * ability is still supported by DataTables 1.10+ to provide backwards
         * compatibility, but this option of use is now decremented and no longer
         * documented in DataTables 1.10+.
         *
         *  @type object
         *  @default {}
         *
         *  @example
         *    // Show previous, next and current page buttons only
         *    $.fn.dataTableExt.oPagination.current = function ( page, pages ) {
         *      return [ 'previous', page, 'next' ];
         *    };
         */pager:{},renderer:{pageButton:{},header:{}},/**
         * Ordering plug-ins - custom data source
         *
         * The extension options for ordering of data available here is complimentary
         * to the default type based ordering that DataTables typically uses. It
         * allows much greater control over the the data that is being used to
         * order a column, but is necessarily therefore more complex.
         *
         * This type of ordering is useful if you want to do ordering based on data
         * live from the DOM (for example the contents of an 'input' element) rather
         * than just the static string that DataTables knows of.
         *
         * The way these plug-ins work is that you create an array of the values you
         * wish to be ordering for the column in question and then return that
         * array. The data in the array much be in the index order of the rows in
         * the table (not the currently ordering order!). Which order data gathering
         * function is run here depends on the `dt-init columns.orderDataType`
         * parameter that is used for the column (if any).
         *
         * The functions defined take two parameters:
         *
         * 1. `{object}` DataTables settings object: see
         *    {@link DataTable.models.oSettings}
         * 2. `{int}` Target column index
         *
         * Each function is expected to return an array:
         *
         * * `{array}` Data for the column to be ordering upon
         *
         *  @type array
         *
         *  @example
         *    // Ordering using `input` node values
         *    $.fn.dataTable.ext.order['dom-text'] = function  ( settings, col )
         *    {
         *      return this.api().column( col, {order:'index'} ).nodes().map( function ( td, i ) {
         *        return $('input', td).val();
         *      } );
         *    }
         */order:{},/**
         * Type based plug-ins.
         *
         * Each column in DataTables has a type assigned to it, either by automatic
         * detection or by direct assignment using the `type` option for the column.
         * The type of a column will effect how it is ordering and search (plug-ins
         * can also make use of the column type if required).
         *
         * @namespace
         */type:{/**
             * Type detection functions.
             *
             * The functions defined in this object are used to automatically detect
             * a column's type, making initialisation of DataTables super easy, even
             * when complex data is in the table.
             *
             * The functions defined take two parameters:
             *
             *  1. `{*}` Data from the column cell to be analysed
             *  2. `{settings}` DataTables settings object. This can be used to
             *     perform context specific type detection - for example detection
             *     based on language settings such as using a comma for a decimal
             *     place. Generally speaking the options from the settings will not
             *     be required
             *
             * Each function is expected to return:
             *
             * * `{string|null}` Data type detected, or null if unknown (and thus
             *   pass it on to the other type detection functions.
             *
             *  @type array
             *
             *  @example
             *    // Currency type detection plug-in:
             *    $.fn.dataTable.ext.type.detect.push(
             *      function ( data, settings ) {
             *        // Check the numeric part
             *        if ( ! data.substring(1).match(/[0-9]/) ) {
             *          return null;
             *        }
             *
             *        // Check prefixed by currency
             *        if ( data.charAt(0) == '$' || data.charAt(0) == '&pound;' ) {
             *          return 'currency';
             *        }
             *        return null;
             *      }
             *    );
             */detect:[],/**
             * Type based search formatting.
             *
             * The type based searching functions can be used to pre-format the
             * data to be search on. For example, it can be used to strip HTML
             * tags or to de-format telephone numbers for numeric only searching.
             *
             * Note that is a search is not defined for a column of a given type,
             * no search formatting will be performed.
             *
             * Pre-processing of searching data plug-ins - When you assign the sType
             * for a column (or have it automatically detected for you by DataTables
             * or a type detection plug-in), you will typically be using this for
             * custom sorting, but it can also be used to provide custom searching
             * by allowing you to pre-processing the data and returning the data in
             * the format that should be searched upon. This is done by adding
             * functions this object with a parameter name which matches the sType
             * for that target column. This is the corollary of <i>afnSortData</i>
             * for searching data.
             *
             * The functions defined take a single parameter:
             *
             *  1. `{*}` Data from the column cell to be prepared for searching
             *
             * Each function is expected to return:
             *
             * * `{string|null}` Formatted string that will be used for the searching.
             *
             *  @type object
             *  @default {}
             *
             *  @example
             *    $.fn.dataTable.ext.type.search['title-numeric'] = function ( d ) {
             *      return d.replace(/\n/g," ").replace( /<.*?>/g, "" );
             *    }
             */search:{},/**
             * Type based ordering.
             *
             * The column type tells DataTables what ordering to apply to the table
             * when a column is sorted upon. The order for each type that is defined,
             * is defined by the functions available in this object.
             *
             * Each ordering option can be described by three properties added to
             * this object:
             *
             * * `{type}-pre` - Pre-formatting function
             * * `{type}-asc` - Ascending order function
             * * `{type}-desc` - Descending order function
             *
             * All three can be used together, only `{type}-pre` or only
             * `{type}-asc` and `{type}-desc` together. It is generally recommended
             * that only `{type}-pre` is used, as this provides the optimal
             * implementation in terms of speed, although the others are provided
             * for compatibility with existing Javascript sort functions.
             *
             * `{type}-pre`: Functions defined take a single parameter:
             *
             *  1. `{*}` Data from the column cell to be prepared for ordering
             *
             * And return:
             *
             * * `{*}` Data to be sorted upon
             *
             * `{type}-asc` and `{type}-desc`: Functions are typical Javascript sort
             * functions, taking two parameters:
             *
             *  1. `{*}` Data to compare to the second parameter
             *  2. `{*}` Data to compare to the first parameter
             *
             * And returning:
             *
             * * `{*}` Ordering match: <0 if first parameter should be sorted lower
             *   than the second parameter, ===0 if the two parameters are equal and
             *   >0 if the first parameter should be sorted height than the second
             *   parameter.
             *
             *  @type object
             *  @default {}
             *
             *  @example
             *    // Numeric ordering of formatted numbers with a pre-formatter
             *    $.extend( $.fn.dataTable.ext.type.order, {
             *      "string-pre": function(x) {
             *        a = (a === "-" || a === "") ? 0 : a.replace( /[^\d\-\.]/g, "" );
             *        return parseFloat( a );
             *      }
             *    } );
             *
             *  @example
             *    // Case-sensitive string ordering, with no pre-formatting method
             *    $.extend( $.fn.dataTable.ext.order, {
             *      "string-case-asc": function(x,y) {
             *        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
             *      },
             *      "string-case-desc": function(x,y) {
             *        return ((x < y) ? 1 : ((x > y) ? -1 : 0));
             *      }
             *    } );
             */order:{}},/**
         * Unique DataTables instance counter
         *
         * @type int
         * @private
         */_unique:0,//
// Depreciated
// The following properties are retained for backwards compatiblity only.
// The should not be used in new projects and will be removed in a future
// version
//
/**
         * Version check function.
         *  @type function
         *  @depreciated Since 1.10
         */fnVersionCheck:DataTable.fnVersionCheck,/**
         * Index for what 'this' index API functions should use
         *  @type int
         *  @deprecated Since v1.10
         */iApiIndex:0,/**
         * jQuery UI class container
         *  @type object
         *  @deprecated Since v1.10
         */oJUIClasses:{},/**
         * Software version
         *  @type string
         *  @deprecated Since v1.10
         */sVersion:DataTable.version};//
// Backwards compatibility. Alias to pre 1.10 Hungarian notation counter parts
//
$.extend(_ext,{afnFiltering:_ext.search,aTypes:_ext.type.detect,ofnSearch:_ext.type.search,oSort:_ext.type.order,afnSortData:_ext.order,aoFeatures:_ext.feature,oApi:_ext.internal,oStdClasses:_ext.classes,oPagination:_ext.pager});$.extend(DataTable.ext.classes,{"sTable":"dataTable","sNoFooter":"no-footer",/* Paging buttons */"sPageButton":"paginate_button","sPageButtonActive":"current","sPageButtonDisabled":"disabled",/* Striping classes */"sStripeOdd":"odd","sStripeEven":"even",/* Empty row */"sRowEmpty":"dataTables_empty",/* Features */"sWrapper":"dataTables_wrapper","sFilter":"dataTables_filter","sInfo":"dataTables_info","sPaging":"dataTables_paginate paging_",/* Note that the type is postfixed */"sLength":"dataTables_length","sProcessing":"dataTables_processing",/* Sorting */"sSortAsc":"sorting_asc","sSortDesc":"sorting_desc","sSortable":"sorting",/* Sortable in both directions */"sSortableAsc":"sorting_asc_disabled","sSortableDesc":"sorting_desc_disabled","sSortableNone":"sorting_disabled","sSortColumn":"sorting_",/* Note that an int is postfixed for the sorting order */ /* Filtering */"sFilterInput":"",/* Page length */"sLengthSelect":"",/* Scrolling */"sScrollWrapper":"dataTables_scroll","sScrollHead":"dataTables_scrollHead","sScrollHeadInner":"dataTables_scrollHeadInner","sScrollBody":"dataTables_scrollBody","sScrollFoot":"dataTables_scrollFoot","sScrollFootInner":"dataTables_scrollFootInner",/* Misc */"sHeaderTH":"","sFooterTH":"",// Deprecated
"sSortJUIAsc":"","sSortJUIDesc":"","sSortJUI":"","sSortJUIAscAllowed":"","sSortJUIDescAllowed":"","sSortJUIWrapper":"","sSortIcon":"","sJUIHeader":"","sJUIFooter":""});var extPagination=DataTable.ext.pager;function _numbers(page,pages){var numbers=[],buttons=extPagination.numbers_length,half=Math.floor(buttons/2),i=1;if(pages<=buttons){numbers=_range(0,pages);}else if(page<=half){numbers=_range(0,buttons-2);numbers.push('ellipsis');numbers.push(pages-1);}else if(page>=pages-1-half){numbers=_range(pages-(buttons-2),pages);numbers.splice(0,0,'ellipsis');// no unshift in ie6
numbers.splice(0,0,0);}else{numbers=_range(page-half+2,page+half-1);numbers.push('ellipsis');numbers.push(pages-1);numbers.splice(0,0,'ellipsis');numbers.splice(0,0,0);}numbers.DT_el='span';return numbers;}$.extend(extPagination,{simple:function simple(page,pages){return['previous','next'];},full:function full(page,pages){return['first','previous','next','last'];},numbers:function numbers(page,pages){return[_numbers(page,pages)];},simple_numbers:function simple_numbers(page,pages){return['previous',_numbers(page,pages),'next'];},full_numbers:function full_numbers(page,pages){return['first','previous',_numbers(page,pages),'next','last'];},first_last_numbers:function first_last_numbers(page,pages){return['first',_numbers(page,pages),'last'];},// For testing and plug-ins to use
_numbers:_numbers,// Number of number buttons (including ellipsis) to show. _Must be odd!_
numbers_length:7});$.extend(true,DataTable.ext.renderer,{pageButton:{_:function _(settings,host,idx,buttons,page,pages){var classes=settings.oClasses;var lang=settings.oLanguage.oPaginate;var aria=settings.oLanguage.oAria.paginate||{};var btnDisplay,btnClass,counter=0;var attach=function attach(container,buttons){var i,ien,node,button;var clickHandler=function clickHandler(e){_fnPageChange(settings,e.data.action,true);};for(i=0,ien=buttons.length;i<ien;i++){button=buttons[i];if($.isArray(button)){var inner=$('<'+(button.DT_el||'div')+'/>').appendTo(container);attach(inner,button);}else{btnDisplay=null;btnClass='';switch(button){case'ellipsis':container.append('<span class="ellipsis">&#x2026;</span>');break;case'first':btnDisplay=lang.sFirst;btnClass=button+(page>0?'':' '+classes.sPageButtonDisabled);break;case'previous':btnDisplay=lang.sPrevious;btnClass=button+(page>0?'':' '+classes.sPageButtonDisabled);break;case'next':btnDisplay=lang.sNext;btnClass=button+(page<pages-1?'':' '+classes.sPageButtonDisabled);break;case'last':btnDisplay=lang.sLast;btnClass=button+(page<pages-1?'':' '+classes.sPageButtonDisabled);break;default:btnDisplay=button+1;btnClass=page===button?classes.sPageButtonActive:'';break;}if(btnDisplay!==null){node=$('<a>',{'class':classes.sPageButton+' '+btnClass,'aria-controls':settings.sTableId,'aria-label':aria[button],'data-dt-idx':counter,'tabindex':settings.iTabIndex,'id':idx===0&&typeof button==='string'?settings.sTableId+'_'+button:null}).html(btnDisplay).appendTo(container);_fnBindAction(node,{action:button},clickHandler);counter++;}}}};// IE9 throws an 'unknown error' if document.activeElement is used
// inside an iframe or frame. Try / catch the error. Not good for
// accessibility, but neither are frames.
var activeEl;try{// Because this approach is destroying and recreating the paging
// elements, focus is lost on the select button which is bad for
// accessibility. So we want to restore focus once the draw has
// completed
activeEl=$(host).find(document.activeElement).data('dt-idx');}catch(e){}attach($(host).empty(),buttons);if(activeEl!==undefined){$(host).find('[data-dt-idx='+activeEl+']').focus();}}}});// Built in type detection. See model.ext.aTypes for information about
// what is required from this methods.
$.extend(DataTable.ext.type.detect,[// Plain numbers - first since V8 detects some plain numbers as dates
// e.g. Date.parse('55') (but not all, e.g. Date.parse('22')...).
function(d,settings){var decimal=settings.oLanguage.sDecimal;return _isNumber(d,decimal)?'num'+decimal:null;},// Dates (only those recognised by the browser's Date.parse)
function(d,settings){// V8 tries _very_ hard to make a string passed into `Date.parse()`
// valid, so we need to use a regex to restrict date formats. Use a
// plug-in for anything other than ISO8601 style strings
if(d&&!(d instanceof Date)&&!_re_date.test(d)){return null;}var parsed=Date.parse(d);return parsed!==null&&!isNaN(parsed)||_empty(d)?'date':null;},// Formatted numbers
function(d,settings){var decimal=settings.oLanguage.sDecimal;return _isNumber(d,decimal,true)?'num-fmt'+decimal:null;},// HTML numeric
function(d,settings){var decimal=settings.oLanguage.sDecimal;return _htmlNumeric(d,decimal)?'html-num'+decimal:null;},// HTML numeric, formatted
function(d,settings){var decimal=settings.oLanguage.sDecimal;return _htmlNumeric(d,decimal,true)?'html-num-fmt'+decimal:null;},// HTML (this is strict checking - there must be html)
function(d,settings){return _empty(d)||typeof d==='string'&&d.indexOf('<')!==-1?'html':null;}]);// Filter formatting functions. See model.ext.ofnSearch for information about
// what is required from these methods.
//
// Note that additional search methods are added for the html numbers and
// html formatted numbers by `_addNumericSort()` when we know what the decimal
// place is
$.extend(DataTable.ext.type.search,{html:function html(data){return _empty(data)?data:typeof data==='string'?data.replace(_re_new_lines," ").replace(_re_html,""):'';},string:function string(data){return _empty(data)?data:typeof data==='string'?data.replace(_re_new_lines," "):data;}});var __numericReplace=function __numericReplace(d,decimalPlace,re1,re2){if(d!==0&&(!d||d==='-')){return-Infinity;}// If a decimal place other than `.` is used, it needs to be given to the
// function so we can detect it and replace with a `.` which is the only
// decimal place Javascript recognises - it is not locale aware.
if(decimalPlace){d=_numToDecimal(d,decimalPlace);}if(d.replace){if(re1){d=d.replace(re1,'');}if(re2){d=d.replace(re2,'');}}return d*1;};// Add the numeric 'deformatting' functions for sorting and search. This is done
// in a function to provide an easy ability for the language options to add
// additional methods if a non-period decimal place is used.
function _addNumericSort(decimalPlace){$.each({// Plain numbers
"num":function num(d){return __numericReplace(d,decimalPlace);},// Formatted numbers
"num-fmt":function numFmt(d){return __numericReplace(d,decimalPlace,_re_formatted_numeric);},// HTML numeric
"html-num":function htmlNum(d){return __numericReplace(d,decimalPlace,_re_html);},// HTML numeric, formatted
"html-num-fmt":function htmlNumFmt(d){return __numericReplace(d,decimalPlace,_re_html,_re_formatted_numeric);}},function(key,fn){// Add the ordering method
_ext.type.order[key+decimalPlace+'-pre']=fn;// For HTML types add a search formatter that will strip the HTML
if(key.match(/^html\-/)){_ext.type.search[key+decimalPlace]=_ext.type.search.html;}});}// Default sort methods
$.extend(_ext.type.order,{// Dates
"date-pre":function datePre(d){var ts=Date.parse(d);return isNaN(ts)?-Infinity:ts;},// html
"html-pre":function htmlPre(a){return _empty(a)?'':a.replace?a.replace(/<.*?>/g,"").toLowerCase():a+'';},// string
"string-pre":function stringPre(a){// This is a little complex, but faster than always calling toString,
// http://jsperf.com/tostring-v-check
return _empty(a)?'':typeof a==='string'?a.toLowerCase():!a.toString?'':a.toString();},// string-asc and -desc are retained only for compatibility with the old
// sort methods
"string-asc":function stringAsc(x,y){return x<y?-1:x>y?1:0;},"string-desc":function stringDesc(x,y){return x<y?1:x>y?-1:0;}});// Numeric sorting types - order doesn't matter here
_addNumericSort('');$.extend(true,DataTable.ext.renderer,{header:{_:function _(settings,cell,column,classes){// No additional mark-up required
// Attach a sort listener to update on sort - note that using the
// `DT` namespace will allow the event to be removed automatically
// on destroy, while the `dt` namespaced event is the one we are
// listening for
$(settings.nTable).on('order.dt.DT',function(e,ctx,sorting,columns){if(settings!==ctx){// need to check this this is the host
return;// table, not a nested one
}var colIdx=column.idx;cell.removeClass(column.sSortingClass+' '+classes.sSortAsc+' '+classes.sSortDesc).addClass(columns[colIdx]=='asc'?classes.sSortAsc:columns[colIdx]=='desc'?classes.sSortDesc:column.sSortingClass);});},jqueryui:function jqueryui(settings,cell,column,classes){$('<div/>').addClass(classes.sSortJUIWrapper).append(cell.contents()).append($('<span/>').addClass(classes.sSortIcon+' '+column.sSortingClassJUI)).appendTo(cell);// Attach a sort listener to update on sort
$(settings.nTable).on('order.dt.DT',function(e,ctx,sorting,columns){if(settings!==ctx){return;}var colIdx=column.idx;cell.removeClass(classes.sSortAsc+" "+classes.sSortDesc).addClass(columns[colIdx]=='asc'?classes.sSortAsc:columns[colIdx]=='desc'?classes.sSortDesc:column.sSortingClass);cell.find('span.'+classes.sSortIcon).removeClass(classes.sSortJUIAsc+" "+classes.sSortJUIDesc+" "+classes.sSortJUI+" "+classes.sSortJUIAscAllowed+" "+classes.sSortJUIDescAllowed).addClass(columns[colIdx]=='asc'?classes.sSortJUIAsc:columns[colIdx]=='desc'?classes.sSortJUIDesc:column.sSortingClassJUI);});}}});/*
	 * Public helper functions. These aren't used internally by DataTables, or
	 * called by any of the options passed into DataTables, but they can be used
	 * externally by developers working with DataTables. They are helper functions
	 * to make working with DataTables a little bit easier.
	 */var __htmlEscapeEntities=function __htmlEscapeEntities(d){return typeof d==='string'?d.replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;'):d;};/**
     * Helpers for `columns.render`.
     *
     * The options defined here can be used with the `columns.render` initialisation
     * option to provide a display renderer. The following functions are defined:
     *
     * * `number` - Will format numeric data (defined by `columns.data`) for
     *   display, retaining the original unformatted data for sorting and filtering.
     *   It takes 5 parameters:
     *   * `string` - Thousands grouping separator
     *   * `string` - Decimal point indicator
     *   * `integer` - Number of decimal points to show
     *   * `string` (optional) - Prefix.
     *   * `string` (optional) - Postfix (/suffix).
     * * `text` - Escape HTML to help prevent XSS attacks. It has no optional
     *   parameters.
     *
     * @example
     *   // Column definition using the number renderer
     *   {
     *     data: "salary",
     *     render: $.fn.dataTable.render.number( '\'', '.', 0, '$' )
     *   }
     *
     * @namespace
     */DataTable.render={number:function number(thousands,decimal,precision,prefix,postfix){return{display:function display(d){if(typeof d!=='number'&&typeof d!=='string'){return d;}var negative=d<0?'-':'';var flo=parseFloat(d);// If NaN then there isn't much formatting that we can do - just
// return immediately, escaping any HTML (this was supposed to
// be a number after all)
if(isNaN(flo)){return __htmlEscapeEntities(d);}flo=flo.toFixed(precision);d=Math.abs(flo);var intPart=parseInt(d,10);var floatPart=precision?decimal+(d-intPart).toFixed(precision).substring(2):'';return negative+(prefix||'')+intPart.toString().replace(/\B(?=(\d{3})+(?!\d))/g,thousands)+floatPart+(postfix||'');}};},text:function text(){return{display:__htmlEscapeEntities,filter:__htmlEscapeEntities};}};/*
	 * This is really a good bit rubbish this method of exposing the internal methods
	 * publicly... - To be fixed in 2.0 using methods on the prototype
	 */ /**
     * Create a wrapper function for exporting an internal functions to an external API.
     *  @param {string} fn API function name
     *  @returns {function} wrapped function
     *  @memberof DataTable#internal
     */function _fnExternApiFunc(fn){return function(){var args=[_fnSettingsFromNode(this[DataTable.ext.iApiIndex])].concat(Array.prototype.slice.call(arguments));return DataTable.ext.internal[fn].apply(this,args);};}/**
     * Reference to internal functions for use by plug-in developers. Note that
     * these methods are references to internal functions and are considered to be
     * private. If you use these methods, be aware that they are liable to change
     * between versions.
     *  @namespace
     */$.extend(DataTable.ext.internal,{_fnExternApiFunc:_fnExternApiFunc,_fnBuildAjax:_fnBuildAjax,_fnAjaxUpdate:_fnAjaxUpdate,_fnAjaxParameters:_fnAjaxParameters,_fnAjaxUpdateDraw:_fnAjaxUpdateDraw,_fnAjaxDataSrc:_fnAjaxDataSrc,_fnAddColumn:_fnAddColumn,_fnColumnOptions:_fnColumnOptions,_fnAdjustColumnSizing:_fnAdjustColumnSizing,_fnVisibleToColumnIndex:_fnVisibleToColumnIndex,_fnColumnIndexToVisible:_fnColumnIndexToVisible,_fnVisbleColumns:_fnVisbleColumns,_fnGetColumns:_fnGetColumns,_fnColumnTypes:_fnColumnTypes,_fnApplyColumnDefs:_fnApplyColumnDefs,_fnHungarianMap:_fnHungarianMap,_fnCamelToHungarian:_fnCamelToHungarian,_fnLanguageCompat:_fnLanguageCompat,_fnBrowserDetect:_fnBrowserDetect,_fnAddData:_fnAddData,_fnAddTr:_fnAddTr,_fnNodeToDataIndex:_fnNodeToDataIndex,_fnNodeToColumnIndex:_fnNodeToColumnIndex,_fnGetCellData:_fnGetCellData,_fnSetCellData:_fnSetCellData,_fnSplitObjNotation:_fnSplitObjNotation,_fnGetObjectDataFn:_fnGetObjectDataFn,_fnSetObjectDataFn:_fnSetObjectDataFn,_fnGetDataMaster:_fnGetDataMaster,_fnClearTable:_fnClearTable,_fnDeleteIndex:_fnDeleteIndex,_fnInvalidate:_fnInvalidate,_fnGetRowElements:_fnGetRowElements,_fnCreateTr:_fnCreateTr,_fnBuildHead:_fnBuildHead,_fnDrawHead:_fnDrawHead,_fnDraw:_fnDraw,_fnReDraw:_fnReDraw,_fnAddOptionsHtml:_fnAddOptionsHtml,_fnDetectHeader:_fnDetectHeader,_fnGetUniqueThs:_fnGetUniqueThs,_fnFeatureHtmlFilter:_fnFeatureHtmlFilter,_fnFilterComplete:_fnFilterComplete,_fnFilterCustom:_fnFilterCustom,_fnFilterColumn:_fnFilterColumn,_fnFilter:_fnFilter,_fnFilterCreateSearch:_fnFilterCreateSearch,_fnEscapeRegex:_fnEscapeRegex,_fnFilterData:_fnFilterData,_fnFeatureHtmlInfo:_fnFeatureHtmlInfo,_fnUpdateInfo:_fnUpdateInfo,_fnInfoMacros:_fnInfoMacros,_fnInitialise:_fnInitialise,_fnInitComplete:_fnInitComplete,_fnLengthChange:_fnLengthChange,_fnFeatureHtmlLength:_fnFeatureHtmlLength,_fnFeatureHtmlPaginate:_fnFeatureHtmlPaginate,_fnPageChange:_fnPageChange,_fnFeatureHtmlProcessing:_fnFeatureHtmlProcessing,_fnProcessingDisplay:_fnProcessingDisplay,_fnFeatureHtmlTable:_fnFeatureHtmlTable,_fnScrollDraw:_fnScrollDraw,_fnApplyToChildren:_fnApplyToChildren,_fnCalculateColumnWidths:_fnCalculateColumnWidths,_fnThrottle:_fnThrottle,_fnConvertToWidth:_fnConvertToWidth,_fnGetWidestNode:_fnGetWidestNode,_fnGetMaxLenString:_fnGetMaxLenString,_fnStringToCss:_fnStringToCss,_fnSortFlatten:_fnSortFlatten,_fnSort:_fnSort,_fnSortAria:_fnSortAria,_fnSortListener:_fnSortListener,_fnSortAttachListener:_fnSortAttachListener,_fnSortingClasses:_fnSortingClasses,_fnSortData:_fnSortData,_fnSaveState:_fnSaveState,_fnLoadState:_fnLoadState,_fnSettingsFromNode:_fnSettingsFromNode,_fnLog:_fnLog,_fnMap:_fnMap,_fnBindAction:_fnBindAction,_fnCallbackReg:_fnCallbackReg,_fnCallbackFire:_fnCallbackFire,_fnLengthOverflow:_fnLengthOverflow,_fnRenderer:_fnRenderer,_fnDataSource:_fnDataSource,_fnRowAttributes:_fnRowAttributes,_fnExtend:_fnExtend,_fnCalculateEnd:function _fnCalculateEnd(){}// Used by a lot of plug-ins, but redundant
// in 1.10, so this dead-end function is
// added to prevent errors
});// jQuery access
$.fn.dataTable=DataTable;// Provide access to the host jQuery object (circular reference)
DataTable.$=$;// Legacy aliases
$.fn.dataTableSettings=DataTable.settings;$.fn.dataTableExt=DataTable.ext;// With a capital `D` we return a DataTables API instance rather than a
// jQuery object
$.fn.DataTable=function(opts){return $(this).dataTable(opts).api();};// All properties that are available to $.fn.dataTable should also be
// available on $.fn.DataTable
$.each(DataTable,function(prop,val){$.fn.DataTable[prop]=val;});// Information about events fired by DataTables - for documentation.
/**
     * Draw event, fired whenever the table is redrawn on the page, at the same
     * point as fnDrawCallback. This may be useful for binding events or
     * performing calculations when the table is altered at all.
     *  @name DataTable#draw.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     */ /**
     * Search event, fired when the searching applied to the table (using the
     * built-in global search, or column filters) is altered.
     *  @name DataTable#search.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     */ /**
     * Page change event, fired when the paging of the table is altered.
     *  @name DataTable#page.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     */ /**
     * Order event, fired when the ordering applied to the table is altered.
     *  @name DataTable#order.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     */ /**
     * DataTables initialisation complete event, fired when the table is fully
     * drawn, including Ajax data loaded, if Ajax data is required.
     *  @name DataTable#init.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} oSettings DataTables settings object
     *  @param {object} json The JSON object request from the server - only
     *    present if client-side Ajax sourced data is used</li></ol>
     */ /**
     * State save event, fired when the table has changed state a new state save
     * is required. This event allows modification of the state saving object
     * prior to actually doing the save, including addition or other state
     * properties (for plug-ins) or modification of a DataTables core property.
     *  @name DataTable#stateSaveParams.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} oSettings DataTables settings object
     *  @param {object} json The state information to be saved
     */ /**
     * State load event, fired when the table is loading state from the stored
     * data, but prior to the settings object being modified by the saved state
     * - allowing modification of the saved state is required or loading of
     * state for a plug-in.
     *  @name DataTable#stateLoadParams.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} oSettings DataTables settings object
     *  @param {object} json The saved state information
     */ /**
     * State loaded event, fired when state has been loaded from stored data and
     * the settings object has been modified by the loaded data.
     *  @name DataTable#stateLoaded.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} oSettings DataTables settings object
     *  @param {object} json The saved state information
     */ /**
     * Processing event, fired when DataTables is doing some kind of processing
     * (be it, order, searcg or anything else). It can be used to indicate to
     * the end user that there is something happening, or that something has
     * finished.
     *  @name DataTable#processing.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} oSettings DataTables settings object
     *  @param {boolean} bShow Flag for if DataTables is doing processing or not
     */ /**
     * Ajax (XHR) event, fired whenever an Ajax request is completed from a
     * request to made to the server for new data. This event is called before
     * DataTables processed the returned data, so it can also be used to pre-
     * process the data returned from the server, if needed.
     *
     * Note that this trigger is called in `fnServerData`, if you override
     * `fnServerData` and which to use this event, you need to trigger it in you
     * success function.
     *  @name DataTable#xhr.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     *  @param {object} json JSON returned from the server
     *
     *  @example
     *     // Use a custom property returned from the server in another DOM element
     *     $('#table').dataTable().on('xhr.dt', function (e, settings, json) {
     *       $('#status').html( json.status );
     *     } );
     *
     *  @example
     *     // Pre-process the data returned from the server
     *     $('#table').dataTable().on('xhr.dt', function (e, settings, json) {
     *       for ( var i=0, ien=json.aaData.length ; i<ien ; i++ ) {
     *         json.aaData[i].sum = json.aaData[i].one + json.aaData[i].two;
     *       }
     *       // Note no return - manipulate the data directly in the JSON object.
     *     } );
     */ /**
     * Destroy event, fired when the DataTable is destroyed by calling fnDestroy
     * or passing the bDestroy:true parameter in the initialisation object. This
     * can be used to remove bound events, added DOM nodes, etc.
     *  @name DataTable#destroy.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     */ /**
     * Page length change event, fired when number of records to show on each
     * page (the length) is changed.
     *  @name DataTable#length.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     *  @param {integer} len New length
     */ /**
     * Column sizing has changed.
     *  @name DataTable#column-sizing.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     */ /**
     * Column visibility has changed.
     *  @name DataTable#column-visibility.dt
     *  @event
     *  @param {event} e jQuery event object
     *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
     *  @param {int} column Column index
     *  @param {bool} vis `false` if column now hidden, or `true` if visible
     */return $.fn.dataTable;});
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*! Buttons for DataTables 1.5.6
 * ©2016-2019 SpryMedia Ltd - datatables.net/license
 */
(function (factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD
    define(['jquery', 'datatables.net'], function ($) {
      return factory($, window, document);
    });
  } else if ((typeof exports === "undefined" ? "undefined" : _typeof(exports)) === 'object') {
    // CommonJS
    module.exports = function (root, $) {
      if (!root) {
        root = window;
      }

      if (!$ || !$.fn.dataTable) {
        $ = require('datatables.net')(root, $).$;
      }

      return factory($, root, root.document);
    };
  } else {
    // Browser
    factory(jQuery, window, document);
  }
})(function ($, window, document, undefined) {
  'use strict';

  var DataTable = $.fn.dataTable; // Used for namespacing events added to the document by each instance, so they
  // can be removed on destroy

  var _instCounter = 0; // Button namespacing counter for namespacing events on individual buttons

  var _buttonCounter = 0;
  var _dtButtons = DataTable.ext.buttons;
  /**
   * [Buttons description]
   * @param {[type]}
   * @param {[type]}
   */

  var Buttons = function Buttons(dt, config) {
    // If not created with a `new` keyword then we return a wrapper function that
    // will take the settings object for a DT. This allows easy use of new instances
    // with the `layout` option - e.g. `topLeft: $.fn.dataTable.Buttons( ... )`.
    if (!(this instanceof Buttons)) {
      return function (settings) {
        return new Buttons(settings, dt).container();
      };
    } // If there is no config set it to an empty object


    if (typeof config === 'undefined') {
      config = {};
    } // Allow a boolean true for defaults


    if (config === true) {
      config = {};
    } // For easy configuration of buttons an array can be given


    if ($.isArray(config)) {
      config = {
        buttons: config
      };
    }

    this.c = $.extend(true, {}, Buttons.defaults, config); // Don't want a deep copy for the buttons

    if (config.buttons) {
      this.c.buttons = config.buttons;
    }

    this.s = {
      dt: new DataTable.Api(dt),
      buttons: [],
      listenKeys: '',
      namespace: 'dtb' + _instCounter++
    };
    this.dom = {
      container: $('<' + this.c.dom.container.tag + '/>').addClass(this.c.dom.container.className)
    };

    this._constructor();
  };

  $.extend(Buttons.prototype, {
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     * Public methods
     */

    /**
     * Get the action of a button
     * @param  {int|string} Button index
     * @return {function}
     */

    /**
    * Set the action of a button
    * @param  {node} node Button element
    * @param  {function} action Function to set
    * @return {Buttons} Self for chaining
    */
    action: function action(node, _action) {
      var button = this._nodeToButton(node);

      if (_action === undefined) {
        return button.conf.action;
      }

      button.conf.action = _action;
      return this;
    },

    /**
     * Add an active class to the button to make to look active or get current
     * active state.
     * @param  {node} node Button element
     * @param  {boolean} [flag] Enable / disable flag
     * @return {Buttons} Self for chaining or boolean for getter
     */
    active: function active(node, flag) {
      var button = this._nodeToButton(node);

      var klass = this.c.dom.button.active;
      var jqNode = $(button.node);

      if (flag === undefined) {
        return jqNode.hasClass(klass);
      }

      jqNode.toggleClass(klass, flag === undefined ? true : flag);
      return this;
    },

    /**
     * Add a new button
     * @param {object} config Button configuration object, base string name or function
     * @param {int|string} [idx] Button index for where to insert the button
     * @return {Buttons} Self for chaining
     */
    add: function add(config, idx) {
      var buttons = this.s.buttons;

      if (typeof idx === 'string') {
        var split = idx.split('-');
        var base = this.s;

        for (var i = 0, ien = split.length - 1; i < ien; i++) {
          base = base.buttons[split[i] * 1];
        }

        buttons = base.buttons;
        idx = split[split.length - 1] * 1;
      }

      this._expandButton(buttons, config, false, idx);

      this._draw();

      return this;
    },

    /**
     * Get the container node for the buttons
     * @return {jQuery} Buttons node
     */
    container: function container() {
      return this.dom.container;
    },

    /**
     * Disable a button
     * @param  {node} node Button node
     * @return {Buttons} Self for chaining
     */
    disable: function disable(node) {
      var button = this._nodeToButton(node);

      $(button.node).addClass(this.c.dom.button.disabled);
      return this;
    },

    /**
     * Destroy the instance, cleaning up event handlers and removing DOM
     * elements
     * @return {Buttons} Self for chaining
     */
    destroy: function destroy() {
      // Key event listener
      $('body').off('keyup.' + this.s.namespace); // Individual button destroy (so they can remove their own events if
      // needed). Take a copy as the array is modified by `remove`

      var buttons = this.s.buttons.slice();
      var i, ien;

      for (i = 0, ien = buttons.length; i < ien; i++) {
        this.remove(buttons[i].node);
      } // Container


      this.dom.container.remove(); // Remove from the settings object collection

      var buttonInsts = this.s.dt.settings()[0];

      for (i = 0, ien = buttonInsts.length; i < ien; i++) {
        if (buttonInsts.inst === this) {
          buttonInsts.splice(i, 1);
          break;
        }
      }

      return this;
    },

    /**
     * Enable / disable a button
     * @param  {node} node Button node
     * @param  {boolean} [flag=true] Enable / disable flag
     * @return {Buttons} Self for chaining
     */
    enable: function enable(node, flag) {
      if (flag === false) {
        return this.disable(node);
      }

      var button = this._nodeToButton(node);

      $(button.node).removeClass(this.c.dom.button.disabled);
      return this;
    },

    /**
     * Get the instance name for the button set selector
     * @return {string} Instance name
     */
    name: function name() {
      return this.c.name;
    },

    /**
     * Get a button's node of the buttons container if no button is given
     * @param  {node} [node] Button node
     * @return {jQuery} Button element, or container
     */
    node: function node(_node) {
      if (!_node) {
        return this.dom.container;
      }

      var button = this._nodeToButton(_node);

      return $(button.node);
    },

    /**
     * Set / get a processing class on the selected button
     * @param  {boolean} flag true to add, false to remove, undefined to get
     * @return {boolean|Buttons} Getter value or this if a setter.
     */
    processing: function processing(node, flag) {
      var button = this._nodeToButton(node);

      if (flag === undefined) {
        return $(button.node).hasClass('processing');
      }

      $(button.node).toggleClass('processing', flag);
      return this;
    },

    /**
     * Remove a button.
     * @param  {node} node Button node
     * @return {Buttons} Self for chaining
     */
    remove: function remove(node) {
      var button = this._nodeToButton(node);

      var host = this._nodeToHost(node);

      var dt = this.s.dt; // Remove any child buttons first

      if (button.buttons.length) {
        for (var i = button.buttons.length - 1; i >= 0; i--) {
          this.remove(button.buttons[i].node);
        }
      } // Allow the button to remove event handlers, etc


      if (button.conf.destroy) {
        button.conf.destroy.call(dt.button(node), dt, $(node), button.conf);
      }

      this._removeKey(button.conf);

      $(button.node).remove();
      var idx = $.inArray(button, host);
      host.splice(idx, 1);
      return this;
    },

    /**
     * Get the text for a button
     * @param  {int|string} node Button index
     * @return {string} Button text
     */

    /**
    * Set the text for a button
    * @param  {int|string|function} node Button index
    * @param  {string} label Text
    * @return {Buttons} Self for chaining
    */
    text: function text(node, label) {
      var button = this._nodeToButton(node);

      var buttonLiner = this.c.dom.collection.buttonLiner;
      var linerTag = button.inCollection && buttonLiner && buttonLiner.tag ? buttonLiner.tag : this.c.dom.buttonLiner.tag;
      var dt = this.s.dt;
      var jqNode = $(button.node);

      var text = function text(opt) {
        return typeof opt === 'function' ? opt(dt, jqNode, button.conf) : opt;
      };

      if (label === undefined) {
        return text(button.conf.text);
      }

      button.conf.text = label;

      if (linerTag) {
        jqNode.children(linerTag).html(text(label));
      } else {
        jqNode.html(text(label));
      }

      return this;
    },

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     * Constructor
     */

    /**
     * Buttons constructor
     * @private
     */
    _constructor: function _constructor() {
      var that = this;
      var dt = this.s.dt;
      var dtSettings = dt.settings()[0];
      var buttons = this.c.buttons;

      if (!dtSettings._buttons) {
        dtSettings._buttons = [];
      }

      dtSettings._buttons.push({
        inst: this,
        name: this.c.name
      });

      for (var i = 0, ien = buttons.length; i < ien; i++) {
        this.add(buttons[i]);
      }

      dt.on('destroy', function (e, settings) {
        if (settings === dtSettings) {
          that.destroy();
        }
      }); // Global key event binding to listen for button keys

      $('body').on('keyup.' + this.s.namespace, function (e) {
        if (!document.activeElement || document.activeElement === document.body) {
          // SUse a string of characters for fast lookup of if we need to
          // handle this
          var character = String.fromCharCode(e.keyCode).toLowerCase();

          if (that.s.listenKeys.toLowerCase().indexOf(character) !== -1) {
            that._keypress(character, e);
          }
        }
      });
    },

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     * Private methods
     */

    /**
     * Add a new button to the key press listener
     * @param {object} conf Resolved button configuration object
     * @private
     */
    _addKey: function _addKey(conf) {
      if (conf.key) {
        this.s.listenKeys += $.isPlainObject(conf.key) ? conf.key.key : conf.key;
      }
    },

    /**
     * Insert the buttons into the container. Call without parameters!
     * @param  {node} [container] Recursive only - Insert point
     * @param  {array} [buttons] Recursive only - Buttons array
     * @private
     */
    _draw: function _draw(container, buttons) {
      if (!container) {
        container = this.dom.container;
        buttons = this.s.buttons;
      }

      container.children().detach();

      for (var i = 0, ien = buttons.length; i < ien; i++) {
        container.append(buttons[i].inserter);
        container.append(' ');

        if (buttons[i].buttons && buttons[i].buttons.length) {
          this._draw(buttons[i].collection, buttons[i].buttons);
        }
      }
    },

    /**
     * Create buttons from an array of buttons
     * @param  {array} attachTo Buttons array to attach to
     * @param  {object} button Button definition
     * @param  {boolean} inCollection true if the button is in a collection
     * @private
     */
    _expandButton: function _expandButton(attachTo, button, inCollection, attachPoint) {
      var dt = this.s.dt;
      var buttonCounter = 0;
      var buttons = !$.isArray(button) ? [button] : button;

      for (var i = 0, ien = buttons.length; i < ien; i++) {
        var conf = this._resolveExtends(buttons[i]);

        if (!conf) {
          continue;
        } // If the configuration is an array, then expand the buttons at this
        // point


        if ($.isArray(conf)) {
          this._expandButton(attachTo, conf, inCollection, attachPoint);

          continue;
        }

        var built = this._buildButton(conf, inCollection);

        if (!built) {
          continue;
        }

        if (attachPoint !== undefined) {
          attachTo.splice(attachPoint, 0, built);
          attachPoint++;
        } else {
          attachTo.push(built);
        }

        if (built.conf.buttons) {
          var collectionDom = this.c.dom.collection;
          built.collection = $('<' + collectionDom.tag + '/>').addClass(collectionDom.className).attr('role', 'menu');
          built.conf._collection = built.collection;

          this._expandButton(built.buttons, built.conf.buttons, true, attachPoint);
        } // init call is made here, rather than buildButton as it needs to
        // be selectable, and for that it needs to be in the buttons array


        if (conf.init) {
          conf.init.call(dt.button(built.node), dt, $(built.node), conf);
        }

        buttonCounter++;
      }
    },

    /**
     * Create an individual button
     * @param  {object} config            Resolved button configuration
     * @param  {boolean} inCollection `true` if a collection button
     * @return {jQuery} Created button node (jQuery)
     * @private
     */
    _buildButton: function _buildButton(config, inCollection) {
      var buttonDom = this.c.dom.button;
      var linerDom = this.c.dom.buttonLiner;
      var collectionDom = this.c.dom.collection;
      var dt = this.s.dt;

      var text = function text(opt) {
        return typeof opt === 'function' ? opt(dt, button, config) : opt;
      };

      if (inCollection && collectionDom.button) {
        buttonDom = collectionDom.button;
      }

      if (inCollection && collectionDom.buttonLiner) {
        linerDom = collectionDom.buttonLiner;
      } // Make sure that the button is available based on whatever requirements
      // it has. For example, Flash buttons require Flash


      if (config.available && !config.available(dt, config)) {
        return false;
      }

      var action = function action(e, dt, button, config) {
        config.action.call(dt.button(button), e, dt, button, config);
        $(dt.table().node()).triggerHandler('buttons-action.dt', [dt.button(button), dt, button, config]);
      };

      var tag = config.tag || buttonDom.tag;
      var clickBlurs = config.clickBlurs === undefined ? true : config.clickBlurs;
      var button = $('<' + tag + '/>').addClass(buttonDom.className).attr('tabindex', this.s.dt.settings()[0].iTabIndex).attr('aria-controls', this.s.dt.table().node().id).on('click.dtb', function (e) {
        e.preventDefault();

        if (!button.hasClass(buttonDom.disabled) && config.action) {
          action(e, dt, button, config);
        }

        if (clickBlurs) {
          button.blur();
        }
      }).on('keyup.dtb', function (e) {
        if (e.keyCode === 13) {
          if (!button.hasClass(buttonDom.disabled) && config.action) {
            action(e, dt, button, config);
          }
        }
      }); // Make `a` tags act like a link

      if (tag.toLowerCase() === 'a') {
        button.attr('href', '#');
      } // Button tags should have `type=button` so they don't have any default behaviour


      if (tag.toLowerCase() === 'button') {
        button.attr('type', 'button');
      }

      if (linerDom.tag) {
        var liner = $('<' + linerDom.tag + '/>').html(text(config.text)).addClass(linerDom.className);

        if (linerDom.tag.toLowerCase() === 'a') {
          liner.attr('href', '#');
        }

        button.append(liner);
      } else {
        button.html(text(config.text));
      }

      if (config.enabled === false) {
        button.addClass(buttonDom.disabled);
      }

      if (config.className) {
        button.addClass(config.className);
      }

      if (config.titleAttr) {
        button.attr('title', text(config.titleAttr));
      }

      if (config.attr) {
        button.attr(config.attr);
      }

      if (!config.namespace) {
        config.namespace = '.dt-button-' + _buttonCounter++;
      }

      var buttonContainer = this.c.dom.buttonContainer;
      var inserter;

      if (buttonContainer && buttonContainer.tag) {
        inserter = $('<' + buttonContainer.tag + '/>').addClass(buttonContainer.className).append(button);
      } else {
        inserter = button;
      }

      this._addKey(config); // Style integration callback for DOM manipulation
      // Note that this is _not_ documented. It is currently
      // for style integration only


      if (this.c.buttonCreated) {
        inserter = this.c.buttonCreated(config, inserter);
      }

      return {
        conf: config,
        node: button.get(0),
        inserter: inserter,
        buttons: [],
        inCollection: inCollection,
        collection: null
      };
    },

    /**
     * Get the button object from a node (recursive)
     * @param  {node} node Button node
     * @param  {array} [buttons] Button array, uses base if not defined
     * @return {object} Button object
     * @private
     */
    _nodeToButton: function _nodeToButton(node, buttons) {
      if (!buttons) {
        buttons = this.s.buttons;
      }

      for (var i = 0, ien = buttons.length; i < ien; i++) {
        if (buttons[i].node === node) {
          return buttons[i];
        }

        if (buttons[i].buttons.length) {
          var ret = this._nodeToButton(node, buttons[i].buttons);

          if (ret) {
            return ret;
          }
        }
      }
    },

    /**
     * Get container array for a button from a button node (recursive)
     * @param  {node} node Button node
     * @param  {array} [buttons] Button array, uses base if not defined
     * @return {array} Button's host array
     * @private
     */
    _nodeToHost: function _nodeToHost(node, buttons) {
      if (!buttons) {
        buttons = this.s.buttons;
      }

      for (var i = 0, ien = buttons.length; i < ien; i++) {
        if (buttons[i].node === node) {
          return buttons;
        }

        if (buttons[i].buttons.length) {
          var ret = this._nodeToHost(node, buttons[i].buttons);

          if (ret) {
            return ret;
          }
        }
      }
    },

    /**
     * Handle a key press - determine if any button's key configured matches
     * what was typed and trigger the action if so.
     * @param  {string} character The character pressed
     * @param  {object} e Key event that triggered this call
     * @private
     */
    _keypress: function _keypress(character, e) {
      // Check if this button press already activated on another instance of Buttons
      if (e._buttonsHandled) {
        return;
      }

      var run = function run(conf, node) {
        if (!conf.key) {
          return;
        }

        if (conf.key === character) {
          e._buttonsHandled = true;
          $(node).click();
        } else if ($.isPlainObject(conf.key)) {
          if (conf.key.key !== character) {
            return;
          }

          if (conf.key.shiftKey && !e.shiftKey) {
            return;
          }

          if (conf.key.altKey && !e.altKey) {
            return;
          }

          if (conf.key.ctrlKey && !e.ctrlKey) {
            return;
          }

          if (conf.key.metaKey && !e.metaKey) {
            return;
          } // Made it this far - it is good


          e._buttonsHandled = true;
          $(node).click();
        }
      };

      var recurse = function recurse(a) {
        for (var i = 0, ien = a.length; i < ien; i++) {
          run(a[i].conf, a[i].node);

          if (a[i].buttons.length) {
            recurse(a[i].buttons);
          }
        }
      };

      recurse(this.s.buttons);
    },

    /**
     * Remove a key from the key listener for this instance (to be used when a
     * button is removed)
     * @param  {object} conf Button configuration
     * @private
     */
    _removeKey: function _removeKey(conf) {
      if (conf.key) {
        var character = $.isPlainObject(conf.key) ? conf.key.key : conf.key; // Remove only one character, as multiple buttons could have the
        // same listening key

        var a = this.s.listenKeys.split('');
        var idx = $.inArray(character, a);
        a.splice(idx, 1);
        this.s.listenKeys = a.join('');
      }
    },

    /**
     * Resolve a button configuration
     * @param  {string|function|object} conf Button config to resolve
     * @return {object} Button configuration
     * @private
     */
    _resolveExtends: function _resolveExtends(conf) {
      var dt = this.s.dt;
      var i, ien;

      var toConfObject = function toConfObject(base) {
        var loop = 0; // Loop until we have resolved to a button configuration, or an
        // array of button configurations (which will be iterated
        // separately)

        while (!$.isPlainObject(base) && !$.isArray(base)) {
          if (base === undefined) {
            return;
          }

          if (typeof base === 'function') {
            base = base(dt, conf);

            if (!base) {
              return false;
            }
          } else if (typeof base === 'string') {
            if (!_dtButtons[base]) {
              throw 'Unknown button type: ' + base;
            }

            base = _dtButtons[base];
          }

          loop++;

          if (loop > 30) {
            // Protect against misconfiguration killing the browser
            throw 'Buttons: Too many iterations';
          }
        }

        return $.isArray(base) ? base : $.extend({}, base);
      };

      conf = toConfObject(conf);

      while (conf && conf.extend) {
        // Use `toConfObject` in case the button definition being extended
        // is itself a string or a function
        if (!_dtButtons[conf.extend]) {
          throw 'Cannot extend unknown button type: ' + conf.extend;
        }

        var objArray = toConfObject(_dtButtons[conf.extend]);

        if ($.isArray(objArray)) {
          return objArray;
        } else if (!objArray) {
          // This is a little brutal as it might be possible to have a
          // valid button without the extend, but if there is no extend
          // then the host button would be acting in an undefined state
          return false;
        } // Stash the current class name


        var originalClassName = objArray.className;
        conf = $.extend({}, objArray, conf); // The extend will have overwritten the original class name if the
        // `conf` object also assigned a class, but we want to concatenate
        // them so they are list that is combined from all extended buttons

        if (originalClassName && conf.className !== originalClassName) {
          conf.className = originalClassName + ' ' + conf.className;
        } // Buttons to be added to a collection  -gives the ability to define
        // if buttons should be added to the start or end of a collection


        var postfixButtons = conf.postfixButtons;

        if (postfixButtons) {
          if (!conf.buttons) {
            conf.buttons = [];
          }

          for (i = 0, ien = postfixButtons.length; i < ien; i++) {
            conf.buttons.push(postfixButtons[i]);
          }

          conf.postfixButtons = null;
        }

        var prefixButtons = conf.prefixButtons;

        if (prefixButtons) {
          if (!conf.buttons) {
            conf.buttons = [];
          }

          for (i = 0, ien = prefixButtons.length; i < ien; i++) {
            conf.buttons.splice(i, 0, prefixButtons[i]);
          }

          conf.prefixButtons = null;
        } // Although we want the `conf` object to overwrite almost all of
        // the properties of the object being extended, the `extend`
        // property should come from the object being extended


        conf.extend = objArray.extend;
      }

      return conf;
    }
  });
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Statics
   */

  /**
   * Show / hide a background layer behind a collection
   * @param  {boolean} Flag to indicate if the background should be shown or
   *   hidden
   * @param  {string} Class to assign to the background
   * @static
   */

  Buttons.background = function (show, className, fade, insertPoint) {
    if (fade === undefined) {
      fade = 400;
    }

    if (!insertPoint) {
      insertPoint = document.body;
    }

    if (show) {
      $('<div/>').addClass(className).css('display', 'none').insertAfter(insertPoint).stop().fadeIn(fade);
    } else {
      $('div.' + className).stop().fadeOut(fade, function () {
        $(this).removeClass(className).remove();
      });
    }
  };
  /**
   * Instance selector - select Buttons instances based on an instance selector
   * value from the buttons assigned to a DataTable. This is only useful if
   * multiple instances are attached to a DataTable.
   * @param  {string|int|array} Instance selector - see `instance-selector`
   *   documentation on the DataTables site
   * @param  {array} Button instance array that was attached to the DataTables
   *   settings object
   * @return {array} Buttons instances
   * @static
   */


  Buttons.instanceSelector = function (group, buttons) {
    if (!group) {
      return $.map(buttons, function (v) {
        return v.inst;
      });
    }

    var ret = [];
    var names = $.map(buttons, function (v) {
      return v.name;
    }); // Flatten the group selector into an array of single options

    var process = function process(input) {
      if ($.isArray(input)) {
        for (var i = 0, ien = input.length; i < ien; i++) {
          process(input[i]);
        }

        return;
      }

      if (typeof input === 'string') {
        if (input.indexOf(',') !== -1) {
          // String selector, list of names
          process(input.split(','));
        } else {
          // String selector individual name
          var idx = $.inArray($.trim(input), names);

          if (idx !== -1) {
            ret.push(buttons[idx].inst);
          }
        }
      } else if (typeof input === 'number') {
        // Index selector
        ret.push(buttons[input].inst);
      }
    };

    process(group);
    return ret;
  };
  /**
   * Button selector - select one or more buttons from a selector input so some
   * operation can be performed on them.
   * @param  {array} Button instances array that the selector should operate on
   * @param  {string|int|node|jQuery|array} Button selector - see
   *   `button-selector` documentation on the DataTables site
   * @return {array} Array of objects containing `inst` and `idx` properties of
   *   the selected buttons so you know which instance each button belongs to.
   * @static
   */


  Buttons.buttonSelector = function (insts, selector) {
    var ret = [];

    var nodeBuilder = function nodeBuilder(a, buttons, baseIdx) {
      var button;
      var idx;

      for (var i = 0, ien = buttons.length; i < ien; i++) {
        button = buttons[i];

        if (button) {
          idx = baseIdx !== undefined ? baseIdx + i : i + '';
          a.push({
            node: button.node,
            name: button.conf.name,
            idx: idx
          });

          if (button.buttons) {
            nodeBuilder(a, button.buttons, idx + '-');
          }
        }
      }
    };

    var run = function run(selector, inst) {
      var i, ien;
      var buttons = [];
      nodeBuilder(buttons, inst.s.buttons);
      var nodes = $.map(buttons, function (v) {
        return v.node;
      });

      if ($.isArray(selector) || selector instanceof $) {
        for (i = 0, ien = selector.length; i < ien; i++) {
          run(selector[i], inst);
        }

        return;
      }

      if (selector === null || selector === undefined || selector === '*') {
        // Select all
        for (i = 0, ien = buttons.length; i < ien; i++) {
          ret.push({
            inst: inst,
            node: buttons[i].node
          });
        }
      } else if (typeof selector === 'number') {
        // Main button index selector
        ret.push({
          inst: inst,
          node: inst.s.buttons[selector].node
        });
      } else if (typeof selector === 'string') {
        if (selector.indexOf(',') !== -1) {
          // Split
          var a = selector.split(',');

          for (i = 0, ien = a.length; i < ien; i++) {
            run($.trim(a[i]), inst);
          }
        } else if (selector.match(/^\d+(\-\d+)*$/)) {
          // Sub-button index selector
          var indexes = $.map(buttons, function (v) {
            return v.idx;
          });
          ret.push({
            inst: inst,
            node: buttons[$.inArray(selector, indexes)].node
          });
        } else if (selector.indexOf(':name') !== -1) {
          // Button name selector
          var name = selector.replace(':name', '');

          for (i = 0, ien = buttons.length; i < ien; i++) {
            if (buttons[i].name === name) {
              ret.push({
                inst: inst,
                node: buttons[i].node
              });
            }
          }
        } else {
          // jQuery selector on the nodes
          $(nodes).filter(selector).each(function () {
            ret.push({
              inst: inst,
              node: this
            });
          });
        }
      } else if (_typeof(selector) === 'object' && selector.nodeName) {
        // Node selector
        var idx = $.inArray(selector, nodes);

        if (idx !== -1) {
          ret.push({
            inst: inst,
            node: nodes[idx]
          });
        }
      }
    };

    for (var i = 0, ien = insts.length; i < ien; i++) {
      var inst = insts[i];
      run(selector, inst);
    }

    return ret;
  };
  /**
   * Buttons defaults. For full documentation, please refer to the docs/option
   * directory or the DataTables site.
   * @type {Object}
   * @static
   */


  Buttons.defaults = {
    buttons: ['copy', 'excel', 'csv', 'pdf', 'print'],
    name: 'main',
    tabIndex: 0,
    dom: {
      container: {
        tag: 'div',
        className: 'dt-buttons'
      },
      collection: {
        tag: 'div',
        className: 'dt-button-collection'
      },
      button: {
        // Flash buttons will not work with `<button>` in IE - it has to be `<a>`
        tag: 'ActiveXObject' in window ? 'a' : 'button',
        className: 'dt-button',
        active: 'active',
        disabled: 'disabled'
      },
      buttonLiner: {
        tag: 'span',
        className: ''
      }
    }
  };
  /**
   * Version information
   * @type {string}
   * @static
   */

  Buttons.version = '1.5.6';
  $.extend(_dtButtons, {
    collection: {
      text: function text(dt) {
        return dt.i18n('buttons.collection', 'Collection');
      },
      className: 'buttons-collection',
      init: function init(dt, button, config) {
        button.attr('aria-expanded', false);
      },
      action: function action(e, dt, button, config) {
        var close = function close() {
          dt.buttons('[aria-haspopup="true"][aria-expanded="true"]').nodes().each(function () {
            var collection = $(this).siblings('.dt-button-collection');

            if (collection.length) {
              collection.stop().fadeOut(config.fade, function () {
                collection.detach();
              });
            }

            $(this).attr('aria-expanded', 'false');
          });
          $('div.dt-button-background').off('click.dtb-collection');
          Buttons.background(false, config.backgroundClassName, config.fade, insertPoint);
          $('body').off('.dtb-collection');
          dt.off('buttons-action.b-internal');
        };

        var wasExpanded = button.attr('aria-expanded') === 'true';
        close();

        if (!wasExpanded) {
          var host = button;
          var collectionParent = $(button).parents('div.dt-button-collection');
          var hostPosition = host.position();
          var tableContainer = $(dt.table().container());
          var multiLevel = false;
          var insertPoint = host;
          button.attr('aria-expanded', 'true'); // Remove any old collection

          if (collectionParent.length) {
            multiLevel = $('.dt-button-collection').position();
            insertPoint = collectionParent;
            $('body').trigger('click.dtb-collection');
          }

          if (insertPoint.parents('body')[0] !== document.body) {
            insertPoint = document.body.lastChild;
          }

          config._collection.find('.dt-button-collection-title').remove();

          config._collection.prepend('<div class="dt-button-collection-title">' + config.collectionTitle + '</div>');

          config._collection.addClass(config.collectionLayout).css('display', 'none').insertAfter(insertPoint).stop().fadeIn(config.fade);

          var position = config._collection.css('position');

          if (multiLevel && position === 'absolute') {
            config._collection.css({
              top: multiLevel.top,
              left: multiLevel.left
            });
          } else if (position === 'absolute') {
            config._collection.css({
              top: hostPosition.top + host.outerHeight(),
              left: hostPosition.left
            }); // calculate overflow when positioned beneath


            var tableBottom = tableContainer.offset().top + tableContainer.height();

            var listBottom = hostPosition.top + host.outerHeight() + config._collection.outerHeight();

            var bottomOverflow = listBottom - tableBottom; // calculate overflow when positioned above

            var listTop = hostPosition.top - config._collection.outerHeight();

            var tableTop = tableContainer.offset().top;
            var topOverflow = tableTop - listTop; // if bottom overflow is larger, move to the top because it fits better, or if dropup is requested

            if (bottomOverflow > topOverflow || config.dropup) {
              config._collection.css('top', hostPosition.top - config._collection.outerHeight() - 5);
            } // Right alignment is enabled on a class, e.g. bootstrap:
            // $.fn.dataTable.Buttons.defaults.dom.collection.className += " dropdown-menu-right";


            if (config._collection.hasClass(config.rightAlignClassName)) {
              config._collection.css('left', hostPosition.left + host.outerWidth() - config._collection.outerWidth());
            } // Right alignment in table container


            var listRight = hostPosition.left + config._collection.outerWidth();

            var tableRight = tableContainer.offset().left + tableContainer.width();

            if (listRight > tableRight) {
              config._collection.css('left', hostPosition.left - (listRight - tableRight));
            } // Right alignment to window


            var listOffsetRight = host.offset().left + config._collection.outerWidth();

            if (listOffsetRight > $(window).width()) {
              config._collection.css('left', hostPosition.left - (listOffsetRight - $(window).width()));
            }
          } else {
            // Fix position - centre on screen
            var top = config._collection.height() / 2;

            if (top > $(window).height() / 2) {
              top = $(window).height() / 2;
            }

            config._collection.css('marginTop', top * -1);
          }

          if (config.background) {
            Buttons.background(true, config.backgroundClassName, config.fade, insertPoint);
          } // Need to break the 'thread' for the collection button being
          // activated by a click - it would also trigger this event


          setTimeout(function () {
            // This is bonkers, but if we don't have a click listener on the
            // background element, iOS Safari will ignore the body click
            // listener below. An empty function here is all that is
            // required to make it work...
            $('div.dt-button-background').on('click.dtb-collection', function () {});
            $('body').on('click.dtb-collection', function (e) {
              // andSelf is deprecated in jQ1.8, but we want 1.7 compat
              var back = $.fn.addBack ? 'addBack' : 'andSelf';

              if (!$(e.target).parents()[back]().filter(config._collection).length) {
                close();
              }
            }).on('keyup.dtb-collection', function (e) {
              if (e.keyCode === 27) {
                close();
              }
            });

            if (config.autoClose) {
              dt.on('buttons-action.b-internal', function () {
                close();
              });
            }
          }, 10);
        }
      },
      background: true,
      collectionLayout: '',
      collectionTitle: '',
      backgroundClassName: 'dt-button-background',
      rightAlignClassName: 'dt-button-right',
      autoClose: false,
      fade: 400,
      attr: {
        'aria-haspopup': true
      }
    },
    copy: function copy(dt, conf) {
      if (_dtButtons.copyHtml5) {
        return 'copyHtml5';
      }

      if (_dtButtons.copyFlash && _dtButtons.copyFlash.available(dt, conf)) {
        return 'copyFlash';
      }
    },
    csv: function csv(dt, conf) {
      // Common option that will use the HTML5 or Flash export buttons
      if (_dtButtons.csvHtml5 && _dtButtons.csvHtml5.available(dt, conf)) {
        return 'csvHtml5';
      }

      if (_dtButtons.csvFlash && _dtButtons.csvFlash.available(dt, conf)) {
        return 'csvFlash';
      }
    },
    excel: function excel(dt, conf) {
      // Common option that will use the HTML5 or Flash export buttons
      if (_dtButtons.excelHtml5 && _dtButtons.excelHtml5.available(dt, conf)) {
        return 'excelHtml5';
      }

      if (_dtButtons.excelFlash && _dtButtons.excelFlash.available(dt, conf)) {
        return 'excelFlash';
      }
    },
    pdf: function pdf(dt, conf) {
      // Common option that will use the HTML5 or Flash export buttons
      if (_dtButtons.pdfHtml5 && _dtButtons.pdfHtml5.available(dt, conf)) {
        return 'pdfHtml5';
      }

      if (_dtButtons.pdfFlash && _dtButtons.pdfFlash.available(dt, conf)) {
        return 'pdfFlash';
      }
    },
    pageLength: function pageLength(dt) {
      var lengthMenu = dt.settings()[0].aLengthMenu;
      var vals = $.isArray(lengthMenu[0]) ? lengthMenu[0] : lengthMenu;
      var lang = $.isArray(lengthMenu[0]) ? lengthMenu[1] : lengthMenu;

      var text = function text(dt) {
        return dt.i18n('buttons.pageLength', {
          "-1": 'Show all rows',
          _: 'Show %d rows'
        }, dt.page.len());
      };

      return {
        extend: 'collection',
        text: text,
        className: 'buttons-page-length',
        autoClose: true,
        buttons: $.map(vals, function (val, i) {
          return {
            text: lang[i],
            className: 'button-page-length',
            action: function action(e, dt) {
              dt.page.len(val).draw();
            },
            init: function init(dt, node, conf) {
              var that = this;

              var fn = function fn() {
                that.active(dt.page.len() === val);
              };

              dt.on('length.dt' + conf.namespace, fn);
              fn();
            },
            destroy: function destroy(dt, node, conf) {
              dt.off('length.dt' + conf.namespace);
            }
          };
        }),
        init: function init(dt, node, conf) {
          var that = this;
          dt.on('length.dt' + conf.namespace, function () {
            that.text(conf.text);
          });
        },
        destroy: function destroy(dt, node, conf) {
          dt.off('length.dt' + conf.namespace);
        }
      };
    }
  });
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * DataTables API
   *
   * For complete documentation, please refer to the docs/api directory or the
   * DataTables site
   */
  // Buttons group and individual button selector

  DataTable.Api.register('buttons()', function (group, selector) {
    // Argument shifting
    if (selector === undefined) {
      selector = group;
      group = undefined;
    }

    this.selector.buttonGroup = group;
    var res = this.iterator(true, 'table', function (ctx) {
      if (ctx._buttons) {
        return Buttons.buttonSelector(Buttons.instanceSelector(group, ctx._buttons), selector);
      }
    }, true);
    res._groupSelector = group;
    return res;
  }); // Individual button selector

  DataTable.Api.register('button()', function (group, selector) {
    // just run buttons() and truncate
    var buttons = this.buttons(group, selector);

    if (buttons.length > 1) {
      buttons.splice(1, buttons.length);
    }

    return buttons;
  }); // Active buttons

  DataTable.Api.registerPlural('buttons().active()', 'button().active()', function (flag) {
    if (flag === undefined) {
      return this.map(function (set) {
        return set.inst.active(set.node);
      });
    }

    return this.each(function (set) {
      set.inst.active(set.node, flag);
    });
  }); // Get / set button action

  DataTable.Api.registerPlural('buttons().action()', 'button().action()', function (action) {
    if (action === undefined) {
      return this.map(function (set) {
        return set.inst.action(set.node);
      });
    }

    return this.each(function (set) {
      set.inst.action(set.node, action);
    });
  }); // Enable / disable buttons

  DataTable.Api.register(['buttons().enable()', 'button().enable()'], function (flag) {
    return this.each(function (set) {
      set.inst.enable(set.node, flag);
    });
  }); // Disable buttons

  DataTable.Api.register(['buttons().disable()', 'button().disable()'], function () {
    return this.each(function (set) {
      set.inst.disable(set.node);
    });
  }); // Get button nodes

  DataTable.Api.registerPlural('buttons().nodes()', 'button().node()', function () {
    var jq = $(); // jQuery will automatically reduce duplicates to a single entry

    $(this.each(function (set) {
      jq = jq.add(set.inst.node(set.node));
    }));
    return jq;
  }); // Get / set button processing state

  DataTable.Api.registerPlural('buttons().processing()', 'button().processing()', function (flag) {
    if (flag === undefined) {
      return this.map(function (set) {
        return set.inst.processing(set.node);
      });
    }

    return this.each(function (set) {
      set.inst.processing(set.node, flag);
    });
  }); // Get / set button text (i.e. the button labels)

  DataTable.Api.registerPlural('buttons().text()', 'button().text()', function (label) {
    if (label === undefined) {
      return this.map(function (set) {
        return set.inst.text(set.node);
      });
    }

    return this.each(function (set) {
      set.inst.text(set.node, label);
    });
  }); // Trigger a button's action

  DataTable.Api.registerPlural('buttons().trigger()', 'button().trigger()', function () {
    return this.each(function (set) {
      set.inst.node(set.node).trigger('click');
    });
  }); // Get the container elements

  DataTable.Api.registerPlural('buttons().containers()', 'buttons().container()', function () {
    var jq = $();
    var groupSelector = this._groupSelector; // We need to use the group selector directly, since if there are no buttons
    // the result set will be empty

    this.iterator(true, 'table', function (ctx) {
      if (ctx._buttons) {
        var insts = Buttons.instanceSelector(groupSelector, ctx._buttons);

        for (var i = 0, ien = insts.length; i < ien; i++) {
          jq = jq.add(insts[i].container());
        }
      }
    });
    return jq;
  }); // Add a new button

  DataTable.Api.register('button().add()', function (idx, conf) {
    var ctx = this.context; // Don't use `this` as it could be empty - select the instances directly

    if (ctx.length) {
      var inst = Buttons.instanceSelector(this._groupSelector, ctx[0]._buttons);

      if (inst.length) {
        inst[0].add(conf, idx);
      }
    }

    return this.button(this._groupSelector, idx);
  }); // Destroy the button sets selected

  DataTable.Api.register('buttons().destroy()', function () {
    this.pluck('inst').unique().each(function (inst) {
      inst.destroy();
    });
    return this;
  }); // Remove a button

  DataTable.Api.registerPlural('buttons().remove()', 'buttons().remove()', function () {
    this.each(function (set) {
      set.inst.remove(set.node);
    });
    return this;
  }); // Information box that can be used by buttons

  var _infoTimer;

  DataTable.Api.register('buttons.info()', function (title, message, time) {
    var that = this;

    if (title === false) {
      $('#datatables_buttons_info').fadeOut(function () {
        $(this).remove();
      });
      clearTimeout(_infoTimer);
      _infoTimer = null;
      return this;
    }

    if (_infoTimer) {
      clearTimeout(_infoTimer);
    }

    if ($('#datatables_buttons_info').length) {
      $('#datatables_buttons_info').remove();
    }

    title = title ? '<h2>' + title + '</h2>' : '';
    $('<div id="datatables_buttons_info" class="dt-button-info"/>').html(title).append($('<div/>')[typeof message === 'string' ? 'html' : 'append'](message)).css('display', 'none').appendTo('body').fadeIn();

    if (time !== undefined && time !== 0) {
      _infoTimer = setTimeout(function () {
        that.buttons.info(false);
      }, time);
    }

    return this;
  }); // Get data from the table for export - this is common to a number of plug-in
  // buttons so it is included in the Buttons core library

  DataTable.Api.register('buttons.exportData()', function (options) {
    if (this.context.length) {
      return _exportData(new DataTable.Api(this.context[0]), options);
    }
  }); // Get information about the export that is common to many of the export data
  // types (DRY)

  DataTable.Api.register('buttons.exportInfo()', function (conf) {
    if (!conf) {
      conf = {};
    }

    return {
      filename: _filename(conf),
      title: _title(conf),
      messageTop: _message(this, conf.message || conf.messageTop, 'top'),
      messageBottom: _message(this, conf.messageBottom, 'bottom')
    };
  });
  /**
   * Get the file name for an exported file.
   *
   * @param {object}	config Button configuration
   * @param {boolean} incExtension Include the file name extension
   */

  var _filename = function _filename(config) {
    // Backwards compatibility
    var filename = config.filename === '*' && config.title !== '*' && config.title !== undefined && config.title !== null && config.title !== '' ? config.title : config.filename;

    if (typeof filename === 'function') {
      filename = filename();
    }

    if (filename === undefined || filename === null) {
      return null;
    }

    if (filename.indexOf('*') !== -1) {
      filename = $.trim(filename.replace('*', $('head > title').text()));
    } // Strip characters which the OS will object to


    filename = filename.replace(/[^a-zA-Z0-9_\u00A1-\uFFFF\.,\-_ !\(\)]/g, "");

    var extension = _stringOrFunction(config.extension);

    if (!extension) {
      extension = '';
    }

    return filename + extension;
  };
  /**
   * Simply utility method to allow parameters to be given as a function
   *
   * @param {undefined|string|function} option Option
   * @return {null|string} Resolved value
   */


  var _stringOrFunction = function _stringOrFunction(option) {
    if (option === null || option === undefined) {
      return null;
    } else if (typeof option === 'function') {
      return option();
    }

    return option;
  };
  /**
   * Get the title for an exported file.
   *
   * @param {object} config	Button configuration
   */


  var _title = function _title(config) {
    var title = _stringOrFunction(config.title);

    return title === null ? null : title.indexOf('*') !== -1 ? title.replace('*', $('head > title').text() || 'Exported data') : title;
  };

  var _message = function _message(dt, option, position) {
    var message = _stringOrFunction(option);

    if (message === null) {
      return null;
    }

    var caption = $('caption', dt.table().container()).eq(0);

    if (message === '*') {
      var side = caption.css('caption-side');

      if (side !== position) {
        return null;
      }

      return caption.length ? caption.text() : '';
    }

    return message;
  };

  var _exportTextarea = $('<textarea/>')[0];

  var _exportData = function _exportData(dt, inOpts) {
    var config = $.extend(true, {}, {
      rows: null,
      columns: '',
      modifier: {
        search: 'applied',
        order: 'applied'
      },
      orthogonal: 'display',
      stripHtml: true,
      stripNewlines: true,
      decodeEntities: true,
      trim: true,
      format: {
        header: function header(d) {
          return strip(d);
        },
        footer: function footer(d) {
          return strip(d);
        },
        body: function body(d) {
          return strip(d);
        }
      },
      customizeData: null
    }, inOpts);

    var strip = function strip(str) {
      if (typeof str !== 'string') {
        return str;
      } // Always remove script tags


      str = str.replace(/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi, ''); // Always remove comments

      str = str.replace(/<!\-\-.*?\-\->/g, '');

      if (config.stripHtml) {
        str = str.replace(/<[^>]*>/g, '');
      }

      if (config.trim) {
        str = str.replace(/^\s+|\s+$/g, '');
      }

      if (config.stripNewlines) {
        str = str.replace(/\n/g, ' ');
      }

      if (config.decodeEntities) {
        _exportTextarea.innerHTML = str;
        str = _exportTextarea.value;
      }

      return str;
    };

    var header = dt.columns(config.columns).indexes().map(function (idx) {
      var el = dt.column(idx).header();
      return config.format.header(el.innerHTML, idx, el);
    }).toArray();
    var footer = dt.table().footer() ? dt.columns(config.columns).indexes().map(function (idx) {
      var el = dt.column(idx).footer();
      return config.format.footer(el ? el.innerHTML : '', idx, el);
    }).toArray() : null; // If Select is available on this table, and any rows are selected, limit the export
    // to the selected rows. If no rows are selected, all rows will be exported. Specify
    // a `selected` modifier to control directly.

    var modifier = $.extend({}, config.modifier);

    if (dt.select && typeof dt.select.info === 'function' && modifier.selected === undefined) {
      if (dt.rows(config.rows, $.extend({
        selected: true
      }, modifier)).any()) {
        $.extend(modifier, {
          selected: true
        });
      }
    }

    var rowIndexes = dt.rows(config.rows, modifier).indexes().toArray();
    var selectedCells = dt.cells(rowIndexes, config.columns);
    var cells = selectedCells.render(config.orthogonal).toArray();
    var cellNodes = selectedCells.nodes().toArray();
    var columns = header.length;
    var rows = columns > 0 ? cells.length / columns : 0;
    var body = [];
    var cellCounter = 0;

    for (var i = 0, ien = rows; i < ien; i++) {
      var row = [columns];

      for (var j = 0; j < columns; j++) {
        row[j] = config.format.body(cells[cellCounter], i, j, cellNodes[cellCounter]);
        cellCounter++;
      }

      body[i] = row;
    }

    var data = {
      header: header,
      footer: footer,
      body: body
    };

    if (config.customizeData) {
      config.customizeData(data);
    }

    return data;
  };
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * DataTables interface
   */
  // Attach to DataTables objects for global access


  $.fn.dataTable.Buttons = Buttons;
  $.fn.DataTable.Buttons = Buttons; // DataTables creation - check if the buttons have been defined for this table,
  // they will have been if the `B` option was used in `dom`, otherwise we should
  // create the buttons instance here so they can be inserted into the document
  // using the API. Listen for `init` for compatibility with pre 1.10.10, but to
  // be removed in future.

  $(document).on('init.dt plugin-init.dt', function (e, settings) {
    if (e.namespace !== 'dt') {
      return;
    }

    var opts = settings.oInit.buttons || DataTable.defaults.buttons;

    if (opts && !settings._buttons) {
      new Buttons(settings, opts).container();
    }
  });

  function _init(settings) {
    var api = new DataTable.Api(settings);
    var opts = api.init().buttons || DataTable.defaults.buttons;
    return new Buttons(api, opts).container();
  } // DataTables `dom` feature option


  DataTable.ext.feature.push({
    fnInit: _init,
    cFeature: "B"
  }); // DataTables 2 layout feature

  if (DataTable.ext.features) {
    DataTable.ext.features.register('buttons', _init);
  }

  return Buttons;
});
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*!
 * Flash export buttons for Buttons and DataTables.
 * 2015-2017 SpryMedia Ltd - datatables.net/license
 *
 * ZeroClipbaord - MIT license
 * Copyright (c) 2012 Joseph Huckaby
 */
(function (factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD
    define(['jquery', 'datatables.net', 'datatables.net-buttons'], function ($) {
      return factory($, window, document);
    });
  } else if ((typeof exports === "undefined" ? "undefined" : _typeof(exports)) === 'object') {
    // CommonJS
    module.exports = function (root, $) {
      if (!root) {
        root = window;
      }

      if (!$ || !$.fn.dataTable) {
        $ = require('datatables.net')(root, $).$;
      }

      if (!$.fn.dataTable.Buttons) {
        require('datatables.net-buttons')(root, $);
      }

      return factory($, root, root.document);
    };
  } else {
    // Browser
    factory(jQuery, window, document);
  }
})(function ($, window, document, undefined) {
  'use strict';

  var DataTable = $.fn.dataTable;
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * ZeroClipboard dependency
   */

  /*
   * ZeroClipboard 1.0.4 with modifications
   * Author: Joseph Huckaby
   * License: MIT
   *
   * Copyright (c) 2012 Joseph Huckaby
   */

  var ZeroClipboard_TableTools = {
    version: "1.0.4-TableTools2",
    clients: {},
    // registered upload clients on page, indexed by id
    moviePath: '',
    // URL to movie
    nextId: 1,
    // ID of next movie
    $: function $(thingy) {
      // simple DOM lookup utility function
      if (typeof thingy == 'string') {
        thingy = document.getElementById(thingy);
      }

      if (!thingy.addClass) {
        // extend element with a few useful methods
        thingy.hide = function () {
          this.style.display = 'none';
        };

        thingy.show = function () {
          this.style.display = '';
        };

        thingy.addClass = function (name) {
          this.removeClass(name);
          this.className += ' ' + name;
        };

        thingy.removeClass = function (name) {
          this.className = this.className.replace(new RegExp("\\s*" + name + "\\s*"), " ").replace(/^\s+/, '').replace(/\s+$/, '');
        };

        thingy.hasClass = function (name) {
          return !!this.className.match(new RegExp("\\s*" + name + "\\s*"));
        };
      }

      return thingy;
    },
    setMoviePath: function setMoviePath(path) {
      // set path to ZeroClipboard.swf
      this.moviePath = path;
    },
    dispatch: function dispatch(id, eventName, args) {
      // receive event from flash movie, send to client
      var client = this.clients[id];

      if (client) {
        client.receiveEvent(eventName, args);
      }
    },
    log: function log(str) {
      console.log('Flash: ' + str);
    },
    register: function register(id, client) {
      // register new client to receive events
      this.clients[id] = client;
    },
    getDOMObjectPosition: function getDOMObjectPosition(obj) {
      // get absolute coordinates for dom element
      var info = {
        left: 0,
        top: 0,
        width: obj.width ? obj.width : obj.offsetWidth,
        height: obj.height ? obj.height : obj.offsetHeight
      };

      if (obj.style.width !== "") {
        info.width = obj.style.width.replace("px", "");
      }

      if (obj.style.height !== "") {
        info.height = obj.style.height.replace("px", "");
      }

      while (obj) {
        info.left += obj.offsetLeft;
        info.top += obj.offsetTop;
        obj = obj.offsetParent;
      }

      return info;
    },
    Client: function Client(elem) {
      // constructor for new simple upload client
      this.handlers = {}; // unique ID

      this.id = ZeroClipboard_TableTools.nextId++;
      this.movieId = 'ZeroClipboard_TableToolsMovie_' + this.id; // register client with singleton to receive flash events

      ZeroClipboard_TableTools.register(this.id, this); // create movie

      if (elem) {
        this.glue(elem);
      }
    }
  };
  ZeroClipboard_TableTools.Client.prototype = {
    id: 0,
    // unique ID for us
    ready: false,
    // whether movie is ready to receive events or not
    movie: null,
    // reference to movie object
    clipText: '',
    // text to copy to clipboard
    fileName: '',
    // default file save name
    action: 'copy',
    // action to perform
    handCursorEnabled: true,
    // whether to show hand cursor, or default pointer cursor
    cssEffects: true,
    // enable CSS mouse effects on dom container
    handlers: null,
    // user event handlers
    sized: false,
    sheetName: '',
    // default sheet name for excel export
    glue: function glue(elem, title) {
      // glue to DOM element
      // elem can be ID or actual DOM element object
      this.domElement = ZeroClipboard_TableTools.$(elem); // float just above object, or zIndex 99 if dom element isn't set

      var zIndex = 99;

      if (this.domElement.style.zIndex) {
        zIndex = parseInt(this.domElement.style.zIndex, 10) + 1;
      } // find X/Y position of domElement


      var box = ZeroClipboard_TableTools.getDOMObjectPosition(this.domElement); // create floating DIV above element

      this.div = document.createElement('div');
      var style = this.div.style;
      style.position = 'absolute';
      style.left = '0px';
      style.top = '0px';
      style.width = box.width + 'px';
      style.height = box.height + 'px';
      style.zIndex = zIndex;

      if (typeof title != "undefined" && title !== "") {
        this.div.title = title;
      }

      if (box.width !== 0 && box.height !== 0) {
        this.sized = true;
      } // style.backgroundColor = '#f00'; // debug


      if (this.domElement) {
        this.domElement.appendChild(this.div);
        this.div.innerHTML = this.getHTML(box.width, box.height).replace(/&/g, '&amp;');
      }
    },
    positionElement: function positionElement() {
      var box = ZeroClipboard_TableTools.getDOMObjectPosition(this.domElement);
      var style = this.div.style;
      style.position = 'absolute'; //style.left = (this.domElement.offsetLeft)+'px';
      //style.top = this.domElement.offsetTop+'px';

      style.width = box.width + 'px';
      style.height = box.height + 'px';

      if (box.width !== 0 && box.height !== 0) {
        this.sized = true;
      } else {
        return;
      }

      var flash = this.div.childNodes[0];
      flash.width = box.width;
      flash.height = box.height;
    },
    getHTML: function getHTML(width, height) {
      // return HTML for movie
      var html = '';
      var flashvars = 'id=' + this.id + '&width=' + width + '&height=' + height;

      if (navigator.userAgent.match(/MSIE/)) {
        // IE gets an OBJECT tag
        var protocol = location.href.match(/^https/i) ? 'https://' : 'http://';
        html += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="' + protocol + 'download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" width="' + width + '" height="' + height + '" id="' + this.movieId + '" align="middle"><param name="allowScriptAccess" value="always" /><param name="allowFullScreen" value="false" /><param name="movie" value="' + ZeroClipboard_TableTools.moviePath + '" /><param name="loop" value="false" /><param name="menu" value="false" /><param name="quality" value="best" /><param name="bgcolor" value="#ffffff" /><param name="flashvars" value="' + flashvars + '"/><param name="wmode" value="transparent"/></object>';
      } else {
        // all other browsers get an EMBED tag
        html += '<embed id="' + this.movieId + '" src="' + ZeroClipboard_TableTools.moviePath + '" loop="false" menu="false" quality="best" bgcolor="#ffffff" width="' + width + '" height="' + height + '" name="' + this.movieId + '" align="middle" allowScriptAccess="always" allowFullScreen="false" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" flashvars="' + flashvars + '" wmode="transparent" />';
      }

      return html;
    },
    hide: function hide() {
      // temporarily hide floater offscreen
      if (this.div) {
        this.div.style.left = '-2000px';
      }
    },
    show: function show() {
      // show ourselves after a call to hide()
      this.reposition();
    },
    destroy: function destroy() {
      // destroy control and floater
      var that = this;

      if (this.domElement && this.div) {
        $(this.div).remove();
        this.domElement = null;
        this.div = null;
        $.each(ZeroClipboard_TableTools.clients, function (id, client) {
          if (client === that) {
            delete ZeroClipboard_TableTools.clients[id];
          }
        });
      }
    },
    reposition: function reposition(elem) {
      // reposition our floating div, optionally to new container
      // warning: container CANNOT change size, only position
      if (elem) {
        this.domElement = ZeroClipboard_TableTools.$(elem);

        if (!this.domElement) {
          this.hide();
        }
      }

      if (this.domElement && this.div) {
        var box = ZeroClipboard_TableTools.getDOMObjectPosition(this.domElement);
        var style = this.div.style;
        style.left = '' + box.left + 'px';
        style.top = '' + box.top + 'px';
      }
    },
    clearText: function clearText() {
      // clear the text to be copy / saved
      this.clipText = '';

      if (this.ready) {
        this.movie.clearText();
      }
    },
    appendText: function appendText(newText) {
      // append text to that which is to be copied / saved
      this.clipText += newText;

      if (this.ready) {
        this.movie.appendText(newText);
      }
    },
    setText: function setText(newText) {
      // set text to be copied to be copied / saved
      this.clipText = newText;

      if (this.ready) {
        this.movie.setText(newText);
      }
    },
    setFileName: function setFileName(newText) {
      // set the file name
      this.fileName = newText;

      if (this.ready) {
        this.movie.setFileName(newText);
      }
    },
    setSheetData: function setSheetData(data) {
      // set the xlsx sheet data
      if (this.ready) {
        this.movie.setSheetData(JSON.stringify(data));
      }
    },
    setAction: function setAction(newText) {
      // set action (save or copy)
      this.action = newText;

      if (this.ready) {
        this.movie.setAction(newText);
      }
    },
    addEventListener: function addEventListener(eventName, func) {
      // add user event listener for event
      // event types: load, queueStart, fileStart, fileComplete, queueComplete, progress, error, cancel
      eventName = eventName.toString().toLowerCase().replace(/^on/, '');

      if (!this.handlers[eventName]) {
        this.handlers[eventName] = [];
      }

      this.handlers[eventName].push(func);
    },
    setHandCursor: function setHandCursor(enabled) {
      // enable hand cursor (true), or default arrow cursor (false)
      this.handCursorEnabled = enabled;

      if (this.ready) {
        this.movie.setHandCursor(enabled);
      }
    },
    setCSSEffects: function setCSSEffects(enabled) {
      // enable or disable CSS effects on DOM container
      this.cssEffects = !!enabled;
    },
    receiveEvent: function receiveEvent(eventName, args) {
      var self; // receive event from flash

      eventName = eventName.toString().toLowerCase().replace(/^on/, ''); // special behavior for certain events

      switch (eventName) {
        case 'load':
          // movie claims it is ready, but in IE this isn't always the case...
          // bug fix: Cannot extend EMBED DOM elements in Firefox, must use traditional function
          this.movie = document.getElementById(this.movieId);

          if (!this.movie) {
            self = this;
            setTimeout(function () {
              self.receiveEvent('load', null);
            }, 1);
            return;
          } // firefox on pc needs a "kick" in order to set these in certain cases


          if (!this.ready && navigator.userAgent.match(/Firefox/) && navigator.userAgent.match(/Windows/)) {
            self = this;
            setTimeout(function () {
              self.receiveEvent('load', null);
            }, 100);
            this.ready = true;
            return;
          }

          this.ready = true;
          this.movie.clearText();
          this.movie.appendText(this.clipText);
          this.movie.setFileName(this.fileName);
          this.movie.setAction(this.action);
          this.movie.setHandCursor(this.handCursorEnabled);
          break;

        case 'mouseover':
          if (this.domElement && this.cssEffects) {
            //this.domElement.addClass('hover');
            if (this.recoverActive) {
              this.domElement.addClass('active');
            }
          }

          break;

        case 'mouseout':
          if (this.domElement && this.cssEffects) {
            this.recoverActive = false;

            if (this.domElement.hasClass('active')) {
              this.domElement.removeClass('active');
              this.recoverActive = true;
            } //this.domElement.removeClass('hover');

          }

          break;

        case 'mousedown':
          if (this.domElement && this.cssEffects) {
            this.domElement.addClass('active');
          }

          break;

        case 'mouseup':
          if (this.domElement && this.cssEffects) {
            this.domElement.removeClass('active');
            this.recoverActive = false;
          }

          break;
      } // switch eventName


      if (this.handlers[eventName]) {
        for (var idx = 0, len = this.handlers[eventName].length; idx < len; idx++) {
          var func = this.handlers[eventName][idx];

          if (typeof func == 'function') {
            // actual function reference
            func(this, args);
          } else if (_typeof(func) == 'object' && func.length == 2) {
            // PHP style object + method, i.e. [myObject, 'myMethod']
            func[0][func[1]](this, args);
          } else if (typeof func == 'string') {
            // name of function
            window[func](this, args);
          }
        } // foreach event handler defined

      } // user defined handler for event

    }
  };

  ZeroClipboard_TableTools.hasFlash = function () {
    try {
      var fo = new ActiveXObject('ShockwaveFlash.ShockwaveFlash');

      if (fo) {
        return true;
      }
    } catch (e) {
      if (navigator.mimeTypes && navigator.mimeTypes['application/x-shockwave-flash'] !== undefined && navigator.mimeTypes['application/x-shockwave-flash'].enabledPlugin) {
        return true;
      }
    }

    return false;
  }; // For the Flash binding to work, ZeroClipboard_TableTools must be on the global
  // object list


  window.ZeroClipboard_TableTools = ZeroClipboard_TableTools;
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Local (private) functions
   */

  /**
   * If a Buttons instance is initlaised before it is placed into the DOM, Flash
   * won't be able to bind to it, so we need to wait until it is available, this
   * method abstracts that out.
   *
   * @param {ZeroClipboard} flash ZeroClipboard instance
   * @param {jQuery} node  Button
   */

  var _glue = function _glue(flash, node) {
    var id = node.attr('id');

    if (node.parents('html').length) {
      flash.glue(node[0], '');
    } else {
      setTimeout(function () {
        _glue(flash, node);
      }, 500);
    }
  };
  /**
   * Get the sheet name for Excel exports.
   *
   * @param {object}  config       Button configuration
   */


  var _sheetname = function _sheetname(config) {
    var sheetName = 'Sheet1';

    if (config.sheetName) {
      sheetName = config.sheetName.replace(/[\[\]\*\/\\\?\:]/g, '');
    }

    return sheetName;
  };
  /**
   * Set the flash text. This has to be broken up into chunks as the Javascript /
   * Flash bridge has a size limit. There is no indication in the Flash
   * documentation what this is, and it probably depends upon the browser.
   * Experimentation shows that the point is around 50k when data starts to get
   * lost, so an 8K limit used here is safe.
   *
   * @param {ZeroClipboard} flash ZeroClipboard instance
   * @param {string}        data  Data to send to Flash
   */


  var _setText = function _setText(flash, data) {
    var parts = data.match(/[\s\S]{1,8192}/g) || [];
    flash.clearText();

    for (var i = 0, len = parts.length; i < len; i++) {
      flash.appendText(parts[i]);
    }
  };
  /**
   * Get the newline character(s)
   *
   * @param {object}  config Button configuration
   * @return {string}        Newline character
   */


  var _newLine = function _newLine(config) {
    return config.newline ? config.newline : navigator.userAgent.match(/Windows/) ? '\r\n' : '\n';
  };
  /**
   * Combine the data from the `buttons.exportData` method into a string that
   * will be used in the export file.
   *
   * @param  {DataTable.Api} dt     DataTables API instance
   * @param  {object}        config Button configuration
   * @return {object}               The data to export
   */


  var _exportData = function _exportData(dt, config) {
    var newLine = _newLine(config);

    var data = dt.buttons.exportData(config.exportOptions);
    var boundary = config.fieldBoundary;
    var separator = config.fieldSeparator;
    var reBoundary = new RegExp(boundary, 'g');
    var escapeChar = config.escapeChar !== undefined ? config.escapeChar : '\\';

    var join = function join(a) {
      var s = ''; // If there is a field boundary, then we might need to escape it in
      // the source data

      for (var i = 0, ien = a.length; i < ien; i++) {
        if (i > 0) {
          s += separator;
        }

        s += boundary ? boundary + ('' + a[i]).replace(reBoundary, escapeChar + boundary) + boundary : a[i];
      }

      return s;
    };

    var header = config.header ? join(data.header) + newLine : '';
    var footer = config.footer && data.footer ? newLine + join(data.footer) : '';
    var body = [];

    for (var i = 0, ien = data.body.length; i < ien; i++) {
      body.push(join(data.body[i]));
    }

    return {
      str: header + body.join(newLine) + footer,
      rows: body.length
    };
  }; // Basic initialisation for the buttons is common between them


  var flashButton = {
    available: function available() {
      return ZeroClipboard_TableTools.hasFlash();
    },
    init: function init(dt, button, config) {
      // Insert the Flash movie
      ZeroClipboard_TableTools.moviePath = DataTable.Buttons.swfPath;
      var flash = new ZeroClipboard_TableTools.Client();
      flash.setHandCursor(true);
      flash.addEventListener('mouseDown', function (client) {
        config._fromFlash = true;
        dt.button(button[0]).trigger();
        config._fromFlash = false;
      });

      _glue(flash, button);

      config._flash = flash;
    },
    destroy: function destroy(dt, button, config) {
      config._flash.destroy();
    },
    fieldSeparator: ',',
    fieldBoundary: '"',
    exportOptions: {},
    title: '*',
    messageTop: '*',
    messageBottom: '*',
    filename: '*',
    extension: '.csv',
    header: true,
    footer: false
  };
  /**
   * Convert from numeric position to letter for column names in Excel
   * @param  {int} n Column number
   * @return {string} Column letter(s) name
   */

  function createCellPos(n) {
    var ordA = 'A'.charCodeAt(0);
    var ordZ = 'Z'.charCodeAt(0);
    var len = ordZ - ordA + 1;
    var s = "";

    while (n >= 0) {
      s = String.fromCharCode(n % len + ordA) + s;
      n = Math.floor(n / len) - 1;
    }

    return s;
  }
  /**
   * Create an XML node and add any children, attributes, etc without needing to
   * be verbose in the DOM.
   *
   * @param  {object} doc      XML document
   * @param  {string} nodeName Node name
   * @param  {object} opts     Options - can be `attr` (attributes), `children`
   *   (child nodes) and `text` (text content)
   * @return {node}            Created node
   */


  function _createNode(doc, nodeName, opts) {
    var tempNode = doc.createElement(nodeName);

    if (opts) {
      if (opts.attr) {
        $(tempNode).attr(opts.attr);
      }

      if (opts.children) {
        $.each(opts.children, function (key, value) {
          tempNode.appendChild(value);
        });
      }

      if (opts.text !== null && opts.text !== undefined) {
        tempNode.appendChild(doc.createTextNode(opts.text));
      }
    }

    return tempNode;
  }
  /**
   * Get the width for an Excel column based on the contents of that column
   * @param  {object} data Data for export
   * @param  {int}    col  Column index
   * @return {int}         Column width
   */


  function _excelColWidth(data, col) {
    var max = data.header[col].length;
    var len, lineSplit, str;

    if (data.footer && data.footer[col].length > max) {
      max = data.footer[col].length;
    }

    for (var i = 0, ien = data.body.length; i < ien; i++) {
      var point = data.body[i][col];
      str = point !== null && point !== undefined ? point.toString() : ''; // If there is a newline character, workout the width of the column
      // based on the longest line in the string

      if (str.indexOf('\n') !== -1) {
        lineSplit = str.split('\n');
        lineSplit.sort(function (a, b) {
          return b.length - a.length;
        });
        len = lineSplit[0].length;
      } else {
        len = str.length;
      }

      if (len > max) {
        max = len;
      } // Max width rather than having potentially massive column widths


      if (max > 40) {
        return 52; // 40 * 1.3
      }
    }

    max *= 1.3; // And a min width

    return max > 6 ? max : 6;
  }

  var _serialiser = "";

  if (typeof window.XMLSerializer === 'undefined') {
    _serialiser = new function () {
      this.serializeToString = function (input) {
        return input.xml;
      };
    }();
  } else {
    _serialiser = new XMLSerializer();
  }

  var _ieExcel;
  /**
   * Convert XML documents in an object to strings
   * @param  {object} obj XLSX document object
   */


  function _xlsxToStrings(obj) {
    if (_ieExcel === undefined) {
      // Detect if we are dealing with IE's _awful_ serialiser by seeing if it
      // drop attributes
      _ieExcel = _serialiser.serializeToString($.parseXML(excelStrings['xl/worksheets/sheet1.xml'])).indexOf('xmlns:r') === -1;
    }

    $.each(obj, function (name, val) {
      if ($.isPlainObject(val)) {
        _xlsxToStrings(val);
      } else {
        if (_ieExcel) {
          // IE's XML serialiser will drop some name space attributes from
          // from the root node, so we need to save them. Do this by
          // replacing the namespace nodes with a regular attribute that
          // we convert back when serialised. Edge does not have this
          // issue
          var worksheet = val.childNodes[0];
          var i, ien;
          var attrs = [];

          for (i = worksheet.attributes.length - 1; i >= 0; i--) {
            var attrName = worksheet.attributes[i].nodeName;
            var attrValue = worksheet.attributes[i].nodeValue;

            if (attrName.indexOf(':') !== -1) {
              attrs.push({
                name: attrName,
                value: attrValue
              });
              worksheet.removeAttribute(attrName);
            }
          }

          for (i = 0, ien = attrs.length; i < ien; i++) {
            var attr = val.createAttribute(attrs[i].name.replace(':', '_dt_b_namespace_token_'));
            attr.value = attrs[i].value;
            worksheet.setAttributeNode(attr);
          }
        }

        var str = _serialiser.serializeToString(val); // Fix IE's XML


        if (_ieExcel) {
          // IE doesn't include the XML declaration
          if (str.indexOf('<?xml') === -1) {
            str = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + str;
          } // Return namespace attributes to being as such


          str = str.replace(/_dt_b_namespace_token_/g, ':');
        } // Safari, IE and Edge will put empty name space attributes onto
        // various elements making them useless. This strips them out


        str = str.replace(/<([^<>]*?) xmlns=""([^<>]*?)>/g, '<$1 $2>');
        obj[name] = str;
      }
    });
  } // Excel - Pre-defined strings to build a basic XLSX file


  var excelStrings = {
    "_rels/.rels": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' + '<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/>' + '</Relationships>',
    "xl/_rels/workbook.xml.rels": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' + '<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>' + '<Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/>' + '</Relationships>',
    "[Content_Types].xml": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">' + '<Default Extension="xml" ContentType="application/xml" />' + '<Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" />' + '<Default Extension="jpeg" ContentType="image/jpeg" />' + '<Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" />' + '<Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />' + '<Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" />' + '</Types>',
    "xl/workbook.xml": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">' + '<fileVersion appName="xl" lastEdited="5" lowestEdited="5" rupBuild="24816"/>' + '<workbookPr showInkAnnotation="0" autoCompressPictures="0"/>' + '<bookViews>' + '<workbookView xWindow="0" yWindow="0" windowWidth="25600" windowHeight="19020" tabRatio="500"/>' + '</bookViews>' + '<sheets>' + '<sheet name="" sheetId="1" r:id="rId1"/>' + '</sheets>' + '</workbook>',
    "xl/worksheets/sheet1.xml": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' + '<sheetData/>' + '<mergeCells count="0"/>' + '</worksheet>',
    "xl/styles.xml": '<?xml version="1.0" encoding="UTF-8"?>' + '<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' + '<numFmts count="6">' + '<numFmt numFmtId="164" formatCode="#,##0.00_-\ [$$-45C]"/>' + '<numFmt numFmtId="165" formatCode="&quot;£&quot;#,##0.00"/>' + '<numFmt numFmtId="166" formatCode="[$€-2]\ #,##0.00"/>' + '<numFmt numFmtId="167" formatCode="0.0%"/>' + '<numFmt numFmtId="168" formatCode="#,##0;(#,##0)"/>' + '<numFmt numFmtId="169" formatCode="#,##0.00;(#,##0.00)"/>' + '</numFmts>' + '<fonts count="5" x14ac:knownFonts="1">' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<color rgb="FFFFFFFF" />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<b />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<i />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<u />' + '</font>' + '</fonts>' + '<fills count="6">' + '<fill>' + '<patternFill patternType="none" />' + '</fill>' + '<fill>' + // Excel appears to use this as a dotted background regardless of values but
    '<patternFill patternType="none" />' + // to be valid to the schema, use a patternFill
    '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="FFD9D9D9" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="FFD99795" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="ffc6efce" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="ffc6cfef" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '</fills>' + '<borders count="2">' + '<border>' + '<left />' + '<right />' + '<top />' + '<bottom />' + '<diagonal />' + '</border>' + '<border diagonalUp="false" diagonalDown="false">' + '<left style="thin">' + '<color auto="1" />' + '</left>' + '<right style="thin">' + '<color auto="1" />' + '</right>' + '<top style="thin">' + '<color auto="1" />' + '</top>' + '<bottom style="thin">' + '<color auto="1" />' + '</bottom>' + '<diagonal />' + '</border>' + '</borders>' + '<cellStyleXfs count="1">' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" />' + '</cellStyleXfs>' + '<cellXfs count="61">' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="left"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="center"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="right"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="fill"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment textRotation="90"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment wrapText="1"/>' + '</xf>' + '<xf numFmtId="9"   fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="164" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="165" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="166" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="167" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="168" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="169" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="3" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '<xf numFmtId="4" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' + '</cellXfs>' + '<cellStyles count="1">' + '<cellStyle name="Normal" xfId="0" builtinId="0" />' + '</cellStyles>' + '<dxfs count="0" />' + '<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4" />' + '</styleSheet>'
  }; // Note we could use 3 `for` loops for the styles, but when gzipped there is
  // virtually no difference in size, since the above can be easily compressed
  // Pattern matching for special number formats. Perhaps this should be exposed
  // via an API in future?

  var _excelSpecials = [{
    match: /^\-?\d+\.\d%$/,
    style: 60,
    fmt: function fmt(d) {
      return d / 100;
    }
  }, // Precent with d.p.
  {
    match: /^\-?\d+\.?\d*%$/,
    style: 56,
    fmt: function fmt(d) {
      return d / 100;
    }
  }, // Percent
  {
    match: /^\-?\$[\d,]+.?\d*$/,
    style: 57
  }, // Dollars
  {
    match: /^\-?£[\d,]+.?\d*$/,
    style: 58
  }, // Pounds
  {
    match: /^\-?€[\d,]+.?\d*$/,
    style: 59
  }, // Euros
  {
    match: /^\([\d,]+\)$/,
    style: 61,
    fmt: function fmt(d) {
      return -1 * d.replace(/[\(\)]/g, '');
    }
  }, // Negative numbers indicated by brackets
  {
    match: /^\([\d,]+\.\d{2}\)$/,
    style: 62,
    fmt: function fmt(d) {
      return -1 * d.replace(/[\(\)]/g, '');
    }
  }, // Negative numbers indicated by brackets - 2d.p.
  {
    match: /^[\d,]+$/,
    style: 63
  }, // Numbers with thousand separators
  {
    match: /^[\d,]+\.\d{2}$/,
    style: 64 // Numbers with 2d.p. and thousands separators

  }];
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * DataTables options and methods
   */
  // Set the default SWF path

  DataTable.Buttons.swfPath = '//cdn.datatables.net/buttons/' + DataTable.Buttons.version + '/swf/flashExport.swf'; // Method to allow Flash buttons to be resized when made visible - as they are
  // of zero height and width if initialised hidden

  DataTable.Api.register('buttons.resize()', function () {
    $.each(ZeroClipboard_TableTools.clients, function (i, client) {
      if (client.domElement !== undefined && client.domElement.parentNode) {
        client.positionElement();
      }
    });
  });
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Button definitions
   */
  // Copy to clipboard

  DataTable.ext.buttons.copyFlash = $.extend({}, flashButton, {
    className: 'buttons-copy buttons-flash',
    text: function text(dt) {
      return dt.i18n('buttons.copy', 'Copy');
    },
    action: function action(e, dt, button, config) {
      // Check that the trigger did actually occur due to a Flash activation
      if (!config._fromFlash) {
        return;
      }

      this.processing(true);
      var flash = config._flash;

      var exportData = _exportData(dt, config);

      var info = dt.buttons.exportInfo(config);

      var newline = _newLine(config);

      var output = exportData.str;

      if (info.title) {
        output = info.title + newline + newline + output;
      }

      if (info.messageTop) {
        output = info.messageTop + newline + newline + output;
      }

      if (info.messageBottom) {
        output = output + newline + newline + info.messageBottom;
      }

      if (config.customize) {
        output = config.customize(output, config, dt);
      }

      flash.setAction('copy');

      _setText(flash, output);

      this.processing(false);
      dt.buttons.info(dt.i18n('buttons.copyTitle', 'Copy to clipboard'), dt.i18n('buttons.copySuccess', {
        _: 'Copied %d rows to clipboard',
        1: 'Copied 1 row to clipboard'
      }, data.rows), 3000);
    },
    fieldSeparator: '\t',
    fieldBoundary: ''
  }); // CSV save file

  DataTable.ext.buttons.csvFlash = $.extend({}, flashButton, {
    className: 'buttons-csv buttons-flash',
    text: function text(dt) {
      return dt.i18n('buttons.csv', 'CSV');
    },
    action: function action(e, dt, button, config) {
      // Set the text
      var flash = config._flash;

      var data = _exportData(dt, config);

      var info = dt.buttons.exportInfo(config);
      var output = config.customize ? config.customize(data.str, config, dt) : data.str;
      flash.setAction('csv');
      flash.setFileName(info.filename);

      _setText(flash, output);
    },
    escapeChar: '"'
  }); // Excel save file - this is really a CSV file using UTF-8 that Excel can read

  DataTable.ext.buttons.excelFlash = $.extend({}, flashButton, {
    className: 'buttons-excel buttons-flash',
    text: function text(dt) {
      return dt.i18n('buttons.excel', 'Excel');
    },
    action: function action(e, dt, button, config) {
      this.processing(true);
      var flash = config._flash;
      var rowPos = 0;
      var rels = $.parseXML(excelStrings['xl/worksheets/sheet1.xml']); //Parses xml

      var relsGet = rels.getElementsByTagName("sheetData")[0];
      var xlsx = {
        _rels: {
          ".rels": $.parseXML(excelStrings['_rels/.rels'])
        },
        xl: {
          _rels: {
            "workbook.xml.rels": $.parseXML(excelStrings['xl/_rels/workbook.xml.rels'])
          },
          "workbook.xml": $.parseXML(excelStrings['xl/workbook.xml']),
          "styles.xml": $.parseXML(excelStrings['xl/styles.xml']),
          "worksheets": {
            "sheet1.xml": rels
          }
        },
        "[Content_Types].xml": $.parseXML(excelStrings['[Content_Types].xml'])
      };
      var data = dt.buttons.exportData(config.exportOptions);
      var currentRow, rowNode;

      var addRow = function addRow(row) {
        currentRow = rowPos + 1;
        rowNode = _createNode(rels, "row", {
          attr: {
            r: currentRow
          }
        });

        for (var i = 0, ien = row.length; i < ien; i++) {
          // Concat both the Cell Columns as a letter and the Row of the cell.
          var cellId = createCellPos(i) + '' + currentRow;
          var cell = null; // For null, undefined of blank cell, continue so it doesn't create the _createNode

          if (row[i] === null || row[i] === undefined || row[i] === '') {
            if (config.createEmptyCells === true) {
              row[i] = '';
            } else {
              continue;
            }
          }

          row[i] = $.trim(row[i]); // Special number formatting options

          for (var j = 0, jen = _excelSpecials.length; j < jen; j++) {
            var special = _excelSpecials[j]; // TODO Need to provide the ability for the specials to say
            // if they are returning a string, since at the moment it is
            // assumed to be a number

            if (row[i].match && !row[i].match(/^0\d+/) && row[i].match(special.match)) {
              var val = row[i].replace(/[^\d\.\-]/g, '');

              if (special.fmt) {
                val = special.fmt(val);
              }

              cell = _createNode(rels, 'c', {
                attr: {
                  r: cellId,
                  s: special.style
                },
                children: [_createNode(rels, 'v', {
                  text: val
                })]
              });
              break;
            }
          }

          if (!cell) {
            if (typeof row[i] === 'number' || row[i].match && row[i].match(/^-?\d+(\.\d+)?$/) && !row[i].match(/^0\d+/)) {
              // Detect numbers - don't match numbers with leading zeros
              // or a negative anywhere but the start
              cell = _createNode(rels, 'c', {
                attr: {
                  t: 'n',
                  r: cellId
                },
                children: [_createNode(rels, 'v', {
                  text: row[i]
                })]
              });
            } else {
              // String output - replace non standard characters for text output
              var text = !row[i].replace ? row[i] : row[i].replace(/[\x00-\x09\x0B\x0C\x0E-\x1F\x7F-\x9F]/g, '');
              cell = _createNode(rels, 'c', {
                attr: {
                  t: 'inlineStr',
                  r: cellId
                },
                children: {
                  row: _createNode(rels, 'is', {
                    children: {
                      row: _createNode(rels, 't', {
                        text: text
                      })
                    }
                  })
                }
              });
            }
          }

          rowNode.appendChild(cell);
        }

        relsGet.appendChild(rowNode);
        rowPos++;
      };

      $('sheets sheet', xlsx.xl['workbook.xml']).attr('name', _sheetname(config));

      if (config.customizeData) {
        config.customizeData(data);
      }

      var mergeCells = function mergeCells(row, colspan) {
        var mergeCells = $('mergeCells', rels);
        mergeCells[0].appendChild(_createNode(rels, 'mergeCell', {
          attr: {
            ref: 'A' + row + ':' + createCellPos(colspan) + row
          }
        }));
        mergeCells.attr('count', mergeCells.attr('count') + 1);
        $('row:eq(' + (row - 1) + ') c', rels).attr('s', '51'); // centre
      }; // Title and top messages


      var exportInfo = dt.buttons.exportInfo(config);

      if (exportInfo.title) {
        addRow([exportInfo.title], rowPos);
        mergeCells(rowPos, data.header.length - 1);
      }

      if (exportInfo.messageTop) {
        addRow([exportInfo.messageTop], rowPos);
        mergeCells(rowPos, data.header.length - 1);
      } // Table itself


      if (config.header) {
        addRow(data.header, rowPos);
        $('row:last c', rels).attr('s', '2'); // bold
      }

      for (var n = 0, ie = data.body.length; n < ie; n++) {
        addRow(data.body[n], rowPos);
      }

      if (config.footer && data.footer) {
        addRow(data.footer, rowPos);
        $('row:last c', rels).attr('s', '2'); // bold
      } // Below the table


      if (exportInfo.messageBottom) {
        addRow([exportInfo.messageBottom], rowPos);
        mergeCells(rowPos, data.header.length - 1);
      } // Set column widths


      var cols = _createNode(rels, 'cols');

      $('worksheet', rels).prepend(cols);

      for (var i = 0, ien = data.header.length; i < ien; i++) {
        cols.appendChild(_createNode(rels, 'col', {
          attr: {
            min: i + 1,
            max: i + 1,
            width: _excelColWidth(data, i),
            customWidth: 1
          }
        }));
      } // Let the developer customise the document if they want to


      if (config.customize) {
        config.customize(xlsx, config, dt);
      }

      _xlsxToStrings(xlsx);

      flash.setAction('excel');
      flash.setFileName(exportInfo.filename);
      flash.setSheetData(xlsx);

      _setText(flash, '');

      this.processing(false);
    },
    extension: '.xlsx',
    createEmptyCells: false
  }); // PDF export

  DataTable.ext.buttons.pdfFlash = $.extend({}, flashButton, {
    className: 'buttons-pdf buttons-flash',
    text: function text(dt) {
      return dt.i18n('buttons.pdf', 'PDF');
    },
    action: function action(e, dt, button, config) {
      this.processing(true); // Set the text

      var flash = config._flash;
      var data = dt.buttons.exportData(config.exportOptions);
      var info = dt.buttons.exportInfo(config);
      var totalWidth = dt.table().node().offsetWidth; // Calculate the column width ratios for layout of the table in the PDF

      var ratios = dt.columns(config.columns).indexes().map(function (idx) {
        return dt.column(idx).header().offsetWidth / totalWidth;
      });
      flash.setAction('pdf');
      flash.setFileName(info.filename);

      _setText(flash, JSON.stringify({
        title: info.title || '',
        messageTop: info.messageTop || '',
        messageBottom: info.messageBottom || '',
        colWidth: ratios.toArray(),
        orientation: config.orientation,
        size: config.pageSize,
        header: config.header ? data.header : null,
        footer: config.footer ? data.footer : null,
        body: data.body
      }));

      this.processing(false);
    },
    extension: '.pdf',
    orientation: 'portrait',
    pageSize: 'A4',
    newline: '\n'
  });
  return DataTable.Buttons;
});
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*!
 * HTML5 export buttons for Buttons and DataTables.
 * 2016 SpryMedia Ltd - datatables.net/license
 *
 * FileSaver.js (1.1.20160328) - MIT license
 * Copyright © 2016 Eli Grey - http://eligrey.com
 */
(function (factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD
    define(['jquery', 'datatables.net', 'datatables.net-buttons'], function ($) {
      return factory($, window, document);
    });
  } else if ((typeof exports === "undefined" ? "undefined" : _typeof(exports)) === 'object') {
    // CommonJS
    module.exports = function (root, $, jszip, pdfmake) {
      if (!root) {
        root = window;
      }

      if (!$ || !$.fn.dataTable) {
        $ = require('datatables.net')(root, $).$;
      }

      if (!$.fn.dataTable.Buttons) {
        require('datatables.net-buttons')(root, $);
      }

      return factory($, root, root.document, jszip, pdfmake);
    };
  } else {
    // Browser
    factory(jQuery, window, document);
  }
})(function ($, window, document, jszip, pdfmake, undefined) {
  'use strict';

  var DataTable = $.fn.dataTable; // Allow the constructor to pass in JSZip and PDFMake from external requires.
  // Otherwise, use globally defined variables, if they are available.

  function _jsZip() {
    return jszip || window.JSZip;
  }

  function _pdfMake() {
    return pdfmake || window.pdfMake;
  }
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * FileSaver.js dependency
   */

  /*jslint bitwise: true, indent: 4, laxbreak: true, laxcomma: true, smarttabs: true, plusplus: true */


  var _saveAs = function (view) {
    "use strict"; // IE <10 is explicitly unsupported

    if (typeof navigator !== "undefined" && /MSIE [1-9]\./.test(navigator.userAgent)) {
      return;
    }

    var doc = view.document // only get URL when necessary in case Blob.js hasn't overridden it yet
    ,
        get_URL = function get_URL() {
      return view.URL || view.webkitURL || view;
    },
        save_link = doc.createElementNS("http://www.w3.org/1999/xhtml", "a"),
        can_use_save_link = "download" in save_link,
        click = function click(node) {
      var event = new MouseEvent("click");
      node.dispatchEvent(event);
    },
        is_safari = /Version\/[\d\.]+.*Safari/.test(navigator.userAgent),
        webkit_req_fs = view.webkitRequestFileSystem,
        req_fs = view.requestFileSystem || webkit_req_fs || view.mozRequestFileSystem,
        throw_outside = function throw_outside(ex) {
      (view.setImmediate || view.setTimeout)(function () {
        throw ex;
      }, 0);
    },
        force_saveable_type = "application/octet-stream",
        fs_min_size = 0 // the Blob API is fundamentally broken as there is no "downloadfinished" event to subscribe to
    ,
        arbitrary_revoke_timeout = 1000 * 40 // in ms
    ,
        revoke = function revoke(file) {
      var revoker = function revoker() {
        if (typeof file === "string") {
          // file is an object URL
          get_URL().revokeObjectURL(file);
        } else {
          // file is a File
          file.remove();
        }
      };
      /* // Take note W3C:
      var
        uri = typeof file === "string" ? file : file.toURL()
      , revoker = function(evt) {
      	// idealy DownloadFinishedEvent.data would be the URL requested
      	if (evt.data === uri) {
      		if (typeof file === "string") { // file is an object URL
      			get_URL().revokeObjectURL(file);
      		} else { // file is a File
      			file.remove();
      		}
      	}
      }
      ;
      view.addEventListener("downloadfinished", revoker);
      */


      setTimeout(revoker, arbitrary_revoke_timeout);
    },
        dispatch = function dispatch(filesaver, event_types, event) {
      event_types = [].concat(event_types);
      var i = event_types.length;

      while (i--) {
        var listener = filesaver["on" + event_types[i]];

        if (typeof listener === "function") {
          try {
            listener.call(filesaver, event || filesaver);
          } catch (ex) {
            throw_outside(ex);
          }
        }
      }
    },
        auto_bom = function auto_bom(blob) {
      // prepend BOM for UTF-8 XML and text/* types (including HTML)
      if (/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(blob.type)) {
        return new Blob(["\uFEFF", blob], {
          type: blob.type
        });
      }

      return blob;
    },
        FileSaver = function FileSaver(blob, name, no_auto_bom) {
      if (!no_auto_bom) {
        blob = auto_bom(blob);
      } // First try a.download, then web filesystem, then object URLs


      var filesaver = this,
          type = blob.type,
          blob_changed = false,
          object_url,
          target_view,
          dispatch_all = function dispatch_all() {
        dispatch(filesaver, "writestart progress write writeend".split(" "));
      } // on any filesys errors revert to saving with object URLs
      ,
          fs_error = function fs_error() {
        if (target_view && is_safari && typeof FileReader !== "undefined") {
          // Safari doesn't allow downloading of blob urls
          var reader = new FileReader();

          reader.onloadend = function () {
            var base64Data = reader.result;
            target_view.location.href = "data:attachment/file" + base64Data.slice(base64Data.search(/[,;]/));
            filesaver.readyState = filesaver.DONE;
            dispatch_all();
          };

          reader.readAsDataURL(blob);
          filesaver.readyState = filesaver.INIT;
          return;
        } // don't create more object URLs than needed


        if (blob_changed || !object_url) {
          object_url = get_URL().createObjectURL(blob);
        }

        if (target_view) {
          target_view.location.href = object_url;
        } else {
          var new_tab = view.open(object_url, "_blank");

          if (new_tab === undefined && is_safari) {
            //Apple do not allow window.open, see http://bit.ly/1kZffRI
            view.location.href = object_url;
          }
        }

        filesaver.readyState = filesaver.DONE;
        dispatch_all();
        revoke(object_url);
      },
          abortable = function abortable(func) {
        return function () {
          if (filesaver.readyState !== filesaver.DONE) {
            return func.apply(this, arguments);
          }
        };
      },
          create_if_not_found = {
        create: true,
        exclusive: false
      },
          slice;

      filesaver.readyState = filesaver.INIT;

      if (!name) {
        name = "download";
      }

      if (can_use_save_link) {
        object_url = get_URL().createObjectURL(blob);
        setTimeout(function () {
          save_link.href = object_url;
          save_link.download = name;
          click(save_link);
          dispatch_all();
          revoke(object_url);
          filesaver.readyState = filesaver.DONE;
        });
        return;
      } // Object and web filesystem URLs have a problem saving in Google Chrome when
      // viewed in a tab, so I force save with application/octet-stream
      // http://code.google.com/p/chromium/issues/detail?id=91158
      // Update: Google errantly closed 91158, I submitted it again:
      // https://code.google.com/p/chromium/issues/detail?id=389642


      if (view.chrome && type && type !== force_saveable_type) {
        slice = blob.slice || blob.webkitSlice;
        blob = slice.call(blob, 0, blob.size, force_saveable_type);
        blob_changed = true;
      } // Since I can't be sure that the guessed media type will trigger a download
      // in WebKit, I append .download to the filename.
      // https://bugs.webkit.org/show_bug.cgi?id=65440


      if (webkit_req_fs && name !== "download") {
        name += ".download";
      }

      if (type === force_saveable_type || webkit_req_fs) {
        target_view = view;
      }

      if (!req_fs) {
        fs_error();
        return;
      }

      fs_min_size += blob.size;
      req_fs(view.TEMPORARY, fs_min_size, abortable(function (fs) {
        fs.root.getDirectory("saved", create_if_not_found, abortable(function (dir) {
          var save = function save() {
            dir.getFile(name, create_if_not_found, abortable(function (file) {
              file.createWriter(abortable(function (writer) {
                writer.onwriteend = function (event) {
                  target_view.location.href = file.toURL();
                  filesaver.readyState = filesaver.DONE;
                  dispatch(filesaver, "writeend", event);
                  revoke(file);
                };

                writer.onerror = function () {
                  var error = writer.error;

                  if (error.code !== error.ABORT_ERR) {
                    fs_error();
                  }
                };

                "writestart progress write abort".split(" ").forEach(function (event) {
                  writer["on" + event] = filesaver["on" + event];
                });
                writer.write(blob);

                filesaver.abort = function () {
                  writer.abort();
                  filesaver.readyState = filesaver.DONE;
                };

                filesaver.readyState = filesaver.WRITING;
              }), fs_error);
            }), fs_error);
          };

          dir.getFile(name, {
            create: false
          }, abortable(function (file) {
            // delete file if it already exists
            file.remove();
            save();
          }), abortable(function (ex) {
            if (ex.code === ex.NOT_FOUND_ERR) {
              save();
            } else {
              fs_error();
            }
          }));
        }), fs_error);
      }), fs_error);
    },
        FS_proto = FileSaver.prototype,
        saveAs = function saveAs(blob, name, no_auto_bom) {
      return new FileSaver(blob, name, no_auto_bom);
    }; // IE 10+ (native saveAs)


    if (typeof navigator !== "undefined" && navigator.msSaveOrOpenBlob) {
      return function (blob, name, no_auto_bom) {
        if (!no_auto_bom) {
          blob = auto_bom(blob);
        }

        return navigator.msSaveOrOpenBlob(blob, name || "download");
      };
    }

    FS_proto.abort = function () {
      var filesaver = this;
      filesaver.readyState = filesaver.DONE;
      dispatch(filesaver, "abort");
    };

    FS_proto.readyState = FS_proto.INIT = 0;
    FS_proto.WRITING = 1;
    FS_proto.DONE = 2;
    FS_proto.error = FS_proto.onwritestart = FS_proto.onprogress = FS_proto.onwrite = FS_proto.onabort = FS_proto.onerror = FS_proto.onwriteend = null;
    return saveAs;
  }(typeof self !== "undefined" && self || typeof window !== "undefined" && window || this.content); // Expose file saver on the DataTables API. Can't attach to `DataTables.Buttons`
  // since this file can be loaded before Button's core!


  DataTable.fileSave = _saveAs;
  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Local (private) functions
   */

  /**
   * Get the file name for an exported file.
   *
   * @param {object}	config Button configuration
   * @param {boolean} incExtension Include the file name extension
   */

  var _filename = function _filename(config, incExtension) {
    // Backwards compatibility
    var filename = config.filename === '*' && config.title !== '*' && config.title !== undefined ? config.title : config.filename;

    if (typeof filename === 'function') {
      filename = filename();
    }

    if (filename.indexOf('*') !== -1) {
      filename = $.trim(filename.replace('*', $('title').text()));
    } // Strip characters which the OS will object to


    filename = filename.replace(/[^a-zA-Z0-9_\u00A1-\uFFFF\.,\-_ !\(\)]/g, "");
    return incExtension === undefined || incExtension === true ? filename + config.extension : filename;
  };
  /**
   * Get the sheet name for Excel exports.
   *
   * @param {object}	config Button configuration
   */


  var _sheetname = function _sheetname(config) {
    var sheetName = 'Sheet1';

    if (config.sheetName) {
      sheetName = config.sheetName.replace(/[\[\]\*\/\\\?\:]/g, '');
    }

    return sheetName;
  };
  /**
   * Get the title for an exported file.
   *
   * @param {object} config	Button configuration
   */


  var _title = function _title(config) {
    var title = config.title;

    if (typeof title === 'function') {
      title = title();
    }

    return title.indexOf('*') !== -1 ? title.replace('*', $('title').text() || 'Exported data') : title;
  };
  /**
   * Get the newline character(s)
   *
   * @param {object}	config Button configuration
   * @return {string}				Newline character
   */


  var _newLine = function _newLine(config) {
    return config.newline ? config.newline : navigator.userAgent.match(/Windows/) ? '\r\n' : '\n';
  };
  /**
   * Combine the data from the `buttons.exportData` method into a string that
   * will be used in the export file.
   *
   * @param	{DataTable.Api} dt		 DataTables API instance
   * @param	{object}				config Button configuration
   * @return {object}							 The data to export
   */


  var _exportData = function _exportData(dt, config) {
    var newLine = _newLine(config);

    var data = dt.buttons.exportData(config.exportOptions);
    var boundary = config.fieldBoundary;
    var separator = config.fieldSeparator;
    var reBoundary = new RegExp(boundary, 'g');
    var escapeChar = config.escapeChar !== undefined ? config.escapeChar : '\\';

    var join = function join(a) {
      var s = ''; // If there is a field boundary, then we might need to escape it in
      // the source data

      for (var i = 0, ien = a.length; i < ien; i++) {
        if (i > 0) {
          s += separator;
        }

        s += boundary ? boundary + ('' + a[i]).replace(reBoundary, escapeChar + boundary) + boundary : a[i];
      }

      return s;
    };

    var header = config.header ? join(data.header) + newLine : '';
    var footer = config.footer && data.footer ? newLine + join(data.footer) : '';
    var body = [];

    for (var i = 0, ien = data.body.length; i < ien; i++) {
      body.push(join(data.body[i]));
    }

    return {
      str: header + body.join(newLine) + footer,
      rows: body.length
    };
  };
  /**
   * Safari's data: support for creating and downloading files is really poor, so
   * various options need to be disabled in it. See
   * https://bugs.webkit.org/show_bug.cgi?id=102914
   *
   * @return {Boolean} `true` if Safari
   */


  var _isSafari = function _isSafari() {
    return navigator.userAgent.indexOf('Safari') !== -1 && navigator.userAgent.indexOf('Chrome') === -1 && navigator.userAgent.indexOf('Opera') === -1;
  };
  /**
   * Convert from numeric position to letter for column names in Excel
   * @param  {int} n Column number
   * @return {string} Column letter(s) name
   */


  function createCellPos(n) {
    var ordA = 'A'.charCodeAt(0);
    var ordZ = 'Z'.charCodeAt(0);
    var len = ordZ - ordA + 1;
    var s = "";

    while (n >= 0) {
      s = String.fromCharCode(n % len + ordA) + s;
      n = Math.floor(n / len) - 1;
    }

    return s;
  }

  try {
    var _serialiser = new XMLSerializer();

    var _ieExcel;
  } catch (t) {}
  /**
   * Recursively add XML files from an object's structure to a ZIP file. This
   * allows the XSLX file to be easily defined with an object's structure matching
   * the files structure.
   *
   * @param {JSZip} zip ZIP package
   * @param {object} obj Object to add (recursive)
   */


  function _addToZip(zip, obj) {
    if (_ieExcel === undefined) {
      // Detect if we are dealing with IE's _awful_ serialiser by seeing if it
      // drop attributes
      _ieExcel = _serialiser.serializeToString($.parseXML(excelStrings['xl/worksheets/sheet1.xml'])).indexOf('xmlns:r') === -1;
    }

    $.each(obj, function (name, val) {
      if ($.isPlainObject(val)) {
        var newDir = zip.folder(name);

        _addToZip(newDir, val);
      } else {
        if (_ieExcel) {
          // IE's XML serialiser will drop some name space attributes from
          // from the root node, so we need to save them. Do this by
          // replacing the namespace nodes with a regular attribute that
          // we convert back when serialised. Edge does not have this
          // issue
          var worksheet = val.childNodes[0];
          var i, ien;
          var attrs = [];

          for (i = worksheet.attributes.length - 1; i >= 0; i--) {
            var attrName = worksheet.attributes[i].nodeName;
            var attrValue = worksheet.attributes[i].nodeValue;

            if (attrName.indexOf(':') !== -1) {
              attrs.push({
                name: attrName,
                value: attrValue
              });
              worksheet.removeAttribute(attrName);
            }
          }

          for (i = 0, ien = attrs.length; i < ien; i++) {
            var attr = val.createAttribute(attrs[i].name.replace(':', '_dt_b_namespace_token_'));
            attr.value = attrs[i].value;
            worksheet.setAttributeNode(attr);
          }
        }

        var str = _serialiser.serializeToString(val); // Fix IE's XML


        if (_ieExcel) {
          // IE doesn't include the XML declaration
          if (str.indexOf('<?xml') === -1) {
            str = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + str;
          } // Return namespace attributes to being as such


          str = str.replace(/_dt_b_namespace_token_/g, ':');
        } // Both IE and Edge will put empty name space attributes onto the
        // rows and columns making them useless


        str = str.replace(/<row xmlns="" /g, '<row ').replace(/<cols xmlns="">/g, '<cols>');
        zip.file(name, str);
      }
    });
  }
  /**
   * Create an XML node and add any children, attributes, etc without needing to
   * be verbose in the DOM.
   *
   * @param  {object} doc      XML document
   * @param  {string} nodeName Node name
   * @param  {object} opts     Options - can be `attr` (attributes), `children`
   *   (child nodes) and `text` (text content)
   * @return {node}            Created node
   */


  function _createNode(doc, nodeName, opts) {
    var tempNode = doc.createElement(nodeName);

    if (opts) {
      if (opts.attr) {
        $(tempNode).attr(opts.attr);
      }

      if (opts.children) {
        $.each(opts.children, function (key, value) {
          tempNode.appendChild(value);
        });
      }

      if (opts.text) {
        tempNode.appendChild(doc.createTextNode(opts.text));
      }
    }

    return tempNode;
  }
  /**
   * Get the width for an Excel column based on the contents of that column
   * @param  {object} data Data for export
   * @param  {int}    col  Column index
   * @return {int}         Column width
   */


  function _excelColWidth(data, col) {
    var max = data.header[col].length;
    var len;

    if (data.footer && data.footer[col].length > max) {
      max = data.footer[col].length;
    }

    for (var i = 0, ien = data.body.length; i < ien; i++) {
      len = data.body[i][col].toString().length;

      if (len > max) {
        max = len;
      } // Max width rather than having potentially massive column widths


      if (max > 40) {
        break;
      }
    } // And a min width


    return max > 5 ? max : 5;
  } // Excel - Pre-defined strings to build a basic XLSX file


  var excelStrings = {
    "_rels/.rels": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' + '<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/>' + '</Relationships>',
    "xl/_rels/workbook.xml.rels": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' + '<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>' + '<Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/>' + '</Relationships>',
    "[Content_Types].xml": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">' + '<Default Extension="xml" ContentType="application/xml" />' + '<Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" />' + '<Default Extension="jpeg" ContentType="image/jpeg" />' + '<Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" />' + '<Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />' + '<Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" />' + '</Types>',
    "xl/workbook.xml": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">' + '<fileVersion appName="xl" lastEdited="5" lowestEdited="5" rupBuild="24816"/>' + '<workbookPr showInkAnnotation="0" autoCompressPictures="0"/>' + '<bookViews>' + '<workbookView xWindow="0" yWindow="0" windowWidth="25600" windowHeight="19020" tabRatio="500"/>' + '</bookViews>' + '<sheets>' + '<sheet name="" sheetId="1" r:id="rId1"/>' + '</sheets>' + '</workbook>',
    "xl/worksheets/sheet1.xml": '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + '<worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' + '<sheetData/>' + '</worksheet>',
    "xl/styles.xml": '<?xml version="1.0" encoding="UTF-8"?>' + '<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' + '<fonts count="5" x14ac:knownFonts="1">' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<color rgb="FFFFFFFF" />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<b />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<i />' + '</font>' + '<font>' + '<sz val="11" />' + '<name val="Calibri" />' + '<u />' + '</font>' + '</fonts>' + '<fills count="6">' + '<fill>' + '<patternFill patternType="none" />' + '</fill>' + '<fill/>' + // Excel appears to use this as a dotted background regardless of values
    '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="FFD9D9D9" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="FFD99795" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="ffc6efce" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '<fill>' + '<patternFill patternType="solid">' + '<fgColor rgb="ffc6cfef" />' + '<bgColor indexed="64" />' + '</patternFill>' + '</fill>' + '</fills>' + '<borders count="2">' + '<border>' + '<left />' + '<right />' + '<top />' + '<bottom />' + '<diagonal />' + '</border>' + '<border diagonalUp="false" diagonalDown="false">' + '<left style="thin">' + '<color auto="1" />' + '</left>' + '<right style="thin">' + '<color auto="1" />' + '</right>' + '<top style="thin">' + '<color auto="1" />' + '</top>' + '<bottom style="thin">' + '<color auto="1" />' + '</bottom>' + '<diagonal />' + '</border>' + '</borders>' + '<cellStyleXfs count="1">' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" />' + '</cellStyleXfs>' + '<cellXfs count="56">' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="1" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="2" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="3" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="4" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="left"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="center"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="right"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment horizontal="fill"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment textRotation="90"/>' + '</xf>' + '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' + '<alignment wrapText="1"/>' + '</xf>' + '</cellXfs>' + '<cellStyles count="1">' + '<cellStyle name="Normal" xfId="0" builtinId="0" />' + '</cellStyles>' + '<dxfs count="0" />' + '<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4" />' + '</styleSheet>'
  }; // Note we could use 3 `for` loops for the styles, but when gzipped there is
  // virtually no difference in size, since the above can be easily compressed

  /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Buttons
   */
  //
  // Copy to clipboard
  //

  DataTable.ext.buttons.copyHtml5 = {
    className: 'buttons-copy buttons-html5',
    text: function text(dt) {
      return dt.i18n('buttons.copy', 'Copy');
    },
    action: function action(e, dt, button, config) {
      var exportData = _exportData(dt, config);

      var output = exportData.str;
      var hiddenDiv = $('<div/>').css({
        height: 1,
        width: 1,
        overflow: 'hidden',
        position: 'fixed',
        top: 0,
        left: 0
      });

      if (config.customize) {
        output = config.customize(output, config);
      }

      var textarea = $('<textarea readonly/>').val(output).appendTo(hiddenDiv); // For browsers that support the copy execCommand, try to use it

      if (document.queryCommandSupported('copy')) {
        hiddenDiv.appendTo(dt.table().container());
        textarea[0].focus();
        textarea[0].select();

        try {
          var successful = document.execCommand('copy');
          hiddenDiv.remove();

          if (successful) {
            dt.buttons.info(dt.i18n('buttons.copyTitle', 'Copy to clipboard'), dt.i18n('buttons.copySuccess', {
              1: 'Copied one row to clipboard',
              _: 'Copied %d rows to clipboard'
            }, exportData.rows), 2000);
            return;
          }
        } catch (t) {}
      } // Otherwise we show the text box and instruct the user to use it


      var message = $('<span>' + dt.i18n('buttons.copyKeys', "Press <i>ctrl</i> or <i>\u2318</i> + <i>C</i> to copy the table data<br>to your system clipboard.<br><br>" + 'To cancel, click this message or press escape.') + '</span>').append(hiddenDiv);
      dt.buttons.info(dt.i18n('buttons.copyTitle', 'Copy to clipboard'), message, 0); // Select the text so when the user activates their system clipboard
      // it will copy that text

      textarea[0].focus();
      textarea[0].select(); // Event to hide the message when the user is done

      var container = $(message).closest('.dt-button-info');

      var close = function close() {
        container.off('click.buttons-copy');
        $(document).off('.buttons-copy');
        dt.buttons.info(false);
      };

      container.on('click.buttons-copy', close);
      $(document).on('keydown.buttons-copy', function (e) {
        if (e.keyCode === 27) {
          // esc
          close();
        }
      }).on('copy.buttons-copy cut.buttons-copy', function () {
        close();
      });
    },
    exportOptions: {},
    fieldSeparator: '\t',
    fieldBoundary: '',
    header: true,
    footer: false
  }; //
  // CSV export
  //

  DataTable.ext.buttons.csvHtml5 = {
    bom: false,
    className: 'buttons-csv buttons-html5',
    available: function available() {
      return window.FileReader !== undefined && window.Blob;
    },
    text: function text(dt) {
      return dt.i18n('buttons.csv', 'CSV');
    },
    action: function action(e, dt, button, config) {
      // Set the text
      var output = _exportData(dt, config).str;

      var charset = config.charset;

      if (config.customize) {
        output = config.customize(output, config);
      }

      if (charset !== false) {
        if (!charset) {
          charset = document.characterSet || document.charset;
        }

        if (charset) {
          charset = ';charset=' + charset;
        }
      } else {
        charset = '';
      }

      if (config.bom) {
        output = "\uFEFF" + output;
      }

      _saveAs(new Blob([output], {
        type: 'text/csv' + charset
      }), _filename(config), true);
    },
    filename: '*',
    extension: '.csv',
    exportOptions: {},
    fieldSeparator: ',',
    fieldBoundary: '"',
    escapeChar: '"',
    charset: null,
    header: true,
    footer: false
  }; //
  // Excel (xlsx) export
  //

  DataTable.ext.buttons.excelHtml5 = {
    className: 'buttons-excel buttons-html5',
    available: function available() {
      return window.FileReader !== undefined && _jsZip() !== undefined && !_isSafari() && _serialiser;
    },
    text: function text(dt) {
      return dt.i18n('buttons.excel', 'Excel');
    },
    action: function action(e, dt, button, config) {
      var rowPos = 0;

      var getXml = function getXml(type) {
        var str = excelStrings[type]; //str = str.replace( /xmlns:/g, 'xmlns_' ).replace( /mc:/g, 'mc_' );

        return $.parseXML(str);
      };

      var rels = getXml('xl/worksheets/sheet1.xml');
      var relsGet = rels.getElementsByTagName("sheetData")[0];
      var xlsx = {
        _rels: {
          ".rels": getXml('_rels/.rels')
        },
        xl: {
          _rels: {
            "workbook.xml.rels": getXml('xl/_rels/workbook.xml.rels')
          },
          "workbook.xml": getXml('xl/workbook.xml'),
          "styles.xml": getXml('xl/styles.xml'),
          "worksheets": {
            "sheet1.xml": rels
          }
        },
        "[Content_Types].xml": getXml('[Content_Types].xml')
      };
      var data = dt.buttons.exportData(config.exportOptions);
      var currentRow, rowNode;

      var addRow = function addRow(row) {
        currentRow = rowPos + 1;
        rowNode = _createNode(rels, "row", {
          attr: {
            r: currentRow
          }
        });

        for (var i = 0, ien = row.length; i < ien; i++) {
          // Concat both the Cell Columns as a letter and the Row of the cell.
          var cellId = createCellPos(i) + '' + currentRow;
          var cell;

          if (row[i] === null || row[i] === undefined) {
            row[i] = '';
          } // Detect numbers - don't match numbers with leading zeros or a negative
          // anywhere but the start


          if (typeof row[i] === 'number' || row[i].match && $.trim(row[i]).match(/^-?\d+(\.\d+)?$/) && !$.trim(row[i]).match(/^0\d+/)) {
            cell = _createNode(rels, 'c', {
              attr: {
                t: 'n',
                r: cellId
              },
              children: [_createNode(rels, 'v', {
                text: row[i]
              })]
            });
          } else {
            // Replace non standard characters for text output
            var text = !row[i].replace ? row[i] : row[i].replace(/[\x00-\x09\x0B\x0C\x0E-\x1F\x7F-\x9F]/g, '');
            cell = _createNode(rels, 'c', {
              attr: {
                t: 'inlineStr',
                r: cellId
              },
              children: {
                row: _createNode(rels, 'is', {
                  children: {
                    row: _createNode(rels, 't', {
                      text: text
                    })
                  }
                })
              }
            });
          }

          rowNode.appendChild(cell);
        }

        relsGet.appendChild(rowNode);
        rowPos++;
      };

      $('sheets sheet', xlsx.xl['workbook.xml']).attr('name', _sheetname(config));

      if (config.customizeData) {
        config.customizeData(data);
      }

      if (config.header) {
        addRow(data.header, rowPos);
        $('row c', rels).attr('s', '2'); // bold
      }

      for (var n = 0, ie = data.body.length; n < ie; n++) {
        addRow(data.body[n], rowPos);
      }

      if (config.footer && data.footer) {
        addRow(data.footer, rowPos);
        $('row:last c', rels).attr('s', '2'); // bold
      } // Set column widths


      var cols = _createNode(rels, 'cols');

      $('worksheet', rels).prepend(cols);

      for (var i = 0, ien = data.header.length; i < ien; i++) {
        cols.appendChild(_createNode(rels, 'col', {
          attr: {
            min: i + 1,
            max: i + 1,
            width: _excelColWidth(data, i),
            customWidth: 1
          }
        }));
      } // Let the developer customise the document if they want to


      if (config.customize) {
        config.customize(xlsx);
      }

      var jszip = _jsZip();

      var zip = new jszip();
      var zipConfig = {
        type: 'blob',
        mimeType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
      };

      _addToZip(zip, xlsx);

      if (zip.generateAsync) {
        // JSZip 3+
        zip.generateAsync(zipConfig).then(function (blob) {
          _saveAs(blob, _filename(config));
        });
      } else {
        // JSZip 2.5
        _saveAs(zip.generate(zipConfig), _filename(config));
      }
    },
    filename: '*',
    extension: '.xlsx',
    exportOptions: {},
    header: true,
    footer: false
  }; //
  // PDF export - using pdfMake - http://pdfmake.org
  //

  DataTable.ext.buttons.pdfHtml5 = {
    className: 'buttons-pdf buttons-html5',
    available: function available() {
      return window.FileReader !== undefined && _pdfMake();
    },
    text: function text(dt) {
      return dt.i18n('buttons.pdf', 'PDF');
    },
    action: function action(e, dt, button, config) {
      var newLine = _newLine(config);

      var data = dt.buttons.exportData(config.exportOptions);
      var rows = [];

      if (config.header) {
        rows.push($.map(data.header, function (d) {
          return {
            text: typeof d === 'string' ? d : d + '',
            style: 'tableHeader'
          };
        }));
      }

      for (var i = 0, ien = data.body.length; i < ien; i++) {
        rows.push($.map(data.body[i], function (d) {
          return {
            text: typeof d === 'string' ? d : d + '',
            style: i % 2 ? 'tableBodyEven' : 'tableBodyOdd'
          };
        }));
      }

      if (config.footer && data.footer) {
        rows.push($.map(data.footer, function (d) {
          return {
            text: typeof d === 'string' ? d : d + '',
            style: 'tableFooter'
          };
        }));
      }

      var doc = {
        pageSize: config.pageSize,
        pageOrientation: config.orientation,
        content: [{
          table: {
            headerRows: 1,
            body: rows
          },
          layout: 'noBorders'
        }],
        styles: {
          tableHeader: {
            bold: true,
            fontSize: 11,
            color: 'white',
            fillColor: '#2d4154',
            alignment: 'center'
          },
          tableBodyEven: {},
          tableBodyOdd: {
            fillColor: '#f3f3f3'
          },
          tableFooter: {
            bold: true,
            fontSize: 11,
            color: 'white',
            fillColor: '#2d4154'
          },
          title: {
            alignment: 'center',
            fontSize: 15
          },
          message: {}
        },
        defaultStyle: {
          fontSize: 10
        }
      };

      if (config.message) {
        doc.content.unshift({
          text: typeof config.message == 'function' ? config.message(dt, button, config) : config.message,
          style: 'message',
          margin: [0, 0, 0, 12]
        });
      }

      if (config.title) {
        doc.content.unshift({
          text: _title(config, false),
          style: 'title',
          margin: [0, 0, 0, 12]
        });
      }

      if (config.customize) {
        config.customize(doc, config);
      }

      var pdf = _pdfMake().createPdf(doc);

      if (config.download === 'open' && !_isSafari()) {
        pdf.open();
      } else {
        pdf.getBuffer(function (buffer) {
          var blob = new Blob([buffer], {
            type: 'application/pdf'
          });

          _saveAs(blob, _filename(config));
        });
      }
    },
    title: '*',
    filename: '*',
    extension: '.pdf',
    exportOptions: {},
    orientation: 'portrait',
    pageSize: 'A4',
    header: true,
    footer: false,
    message: null,
    customize: null,
    download: 'download'
  };
  return DataTable.Buttons;
});
"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*!

JSZip v3.1.3 - A Javascript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/master/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/master/LICENSE
*/
(function (f) {
  if ((typeof exports === "undefined" ? "undefined" : _typeof(exports)) === "object" && typeof module !== "undefined") {
    module.exports = f();
  } else if (typeof define === "function" && define.amd) {
    define([], f);
  } else {
    var g;

    if (typeof window !== "undefined") {
      g = window;
    } else if (typeof global !== "undefined") {
      g = global;
    } else if (typeof self !== "undefined") {
      g = self;
    } else {
      g = this;
    }

    g.JSZip = f();
  }
})(function () {
  var define, module, exports;
  return function e(t, n, r) {
    function s(o, u) {
      if (!n[o]) {
        if (!t[o]) {
          var a = typeof require == "function" && require;
          if (!u && a) return a(o, !0);
          if (i) return i(o, !0);
          var f = new Error("Cannot find module '" + o + "'");
          throw f.code = "MODULE_NOT_FOUND", f;
        }

        var l = n[o] = {
          exports: {}
        };
        t[o][0].call(l.exports, function (e) {
          var n = t[o][1][e];
          return s(n ? n : e);
        }, l, l.exports, e, t, n, r);
      }

      return n[o].exports;
    }

    var i = typeof require == "function" && require;

    for (var o = 0; o < r.length; o++) {
      s(r[o]);
    }

    return s;
  }({
    1: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');

      var support = require('./support'); // private property


      var _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="; // public method for encoding

      exports.encode = function (input) {
        var output = [];
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0,
            len = input.length,
            remainingBytes = len;
        var isArray = utils.getTypeOf(input) !== "string";

        while (i < input.length) {
          remainingBytes = len - i;

          if (!isArray) {
            chr1 = input.charCodeAt(i++);
            chr2 = i < len ? input.charCodeAt(i++) : 0;
            chr3 = i < len ? input.charCodeAt(i++) : 0;
          } else {
            chr1 = input[i++];
            chr2 = i < len ? input[i++] : 0;
            chr3 = i < len ? input[i++] : 0;
          }

          enc1 = chr1 >> 2;
          enc2 = (chr1 & 3) << 4 | chr2 >> 4;
          enc3 = remainingBytes > 1 ? (chr2 & 15) << 2 | chr3 >> 6 : 64;
          enc4 = remainingBytes > 2 ? chr3 & 63 : 64;
          output.push(_keyStr.charAt(enc1) + _keyStr.charAt(enc2) + _keyStr.charAt(enc3) + _keyStr.charAt(enc4));
        }

        return output.join("");
      }; // public method for decoding


      exports.decode = function (input) {
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0,
            resultIndex = 0;
        var dataUrlPrefix = "data:";

        if (input.substr(0, dataUrlPrefix.length) === dataUrlPrefix) {
          // This is a common error: people give a data url
          // (data:image/png;base64,iVBOR...) with a {base64: true} and
          // wonders why things don't work.
          // We can detect that the string input looks like a data url but we
          // *can't* be sure it is one: removing everything up to the comma would
          // be too dangerous.
          throw new Error("Invalid base64 input, it looks like a data url.");
        }

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
        var totalLength = input.length * 3 / 4;

        if (input.charAt(input.length - 1) === _keyStr.charAt(64)) {
          totalLength--;
        }

        if (input.charAt(input.length - 2) === _keyStr.charAt(64)) {
          totalLength--;
        }

        if (totalLength % 1 !== 0) {
          // totalLength is not an integer, the length does not match a valid
          // base64 content. That can happen if:
          // - the input is not a base64 content
          // - the input is *almost* a base64 content, with a extra chars at the
          //   beginning or at the end
          // - the input uses a base64 variant (base64url for example)
          throw new Error("Invalid base64 input, bad content length.");
        }

        var output;

        if (support.uint8array) {
          output = new Uint8Array(totalLength | 0);
        } else {
          output = new Array(totalLength | 0);
        }

        while (i < input.length) {
          enc1 = _keyStr.indexOf(input.charAt(i++));
          enc2 = _keyStr.indexOf(input.charAt(i++));
          enc3 = _keyStr.indexOf(input.charAt(i++));
          enc4 = _keyStr.indexOf(input.charAt(i++));
          chr1 = enc1 << 2 | enc2 >> 4;
          chr2 = (enc2 & 15) << 4 | enc3 >> 2;
          chr3 = (enc3 & 3) << 6 | enc4;
          output[resultIndex++] = chr1;

          if (enc3 !== 64) {
            output[resultIndex++] = chr2;
          }

          if (enc4 !== 64) {
            output[resultIndex++] = chr3;
          }
        }

        return output;
      };
    }, {
      "./support": 30,
      "./utils": 32
    }],
    2: [function (require, module, exports) {
      'use strict';

      var external = require("./external");

      var DataWorker = require('./stream/DataWorker');

      var DataLengthProbe = require('./stream/DataLengthProbe');

      var Crc32Probe = require('./stream/Crc32Probe');

      var DataLengthProbe = require('./stream/DataLengthProbe');
      /**
       * Represent a compressed object, with everything needed to decompress it.
       * @constructor
       * @param {number} compressedSize the size of the data compressed.
       * @param {number} uncompressedSize the size of the data after decompression.
       * @param {number} crc32 the crc32 of the decompressed file.
       * @param {object} compression the type of compression, see lib/compressions.js.
       * @param {String|ArrayBuffer|Uint8Array|Buffer} data the compressed data.
       */


      function CompressedObject(compressedSize, uncompressedSize, crc32, compression, data) {
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.crc32 = crc32;
        this.compression = compression;
        this.compressedContent = data;
      }

      CompressedObject.prototype = {
        /**
         * Create a worker to get the uncompressed content.
         * @return {GenericWorker} the worker.
         */
        getContentWorker: function getContentWorker() {
          var worker = new DataWorker(external.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new DataLengthProbe("data_length"));
          var that = this;
          worker.on("end", function () {
            if (this.streamInfo['data_length'] !== that.uncompressedSize) {
              throw new Error("Bug : uncompressed data size mismatch");
            }
          });
          return worker;
        },

        /**
         * Create a worker to get the compressed content.
         * @return {GenericWorker} the worker.
         */
        getCompressedWorker: function getCompressedWorker() {
          return new DataWorker(external.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize", this.compressedSize).withStreamInfo("uncompressedSize", this.uncompressedSize).withStreamInfo("crc32", this.crc32).withStreamInfo("compression", this.compression);
        }
      };
      /**
       * Chain the given worker with other workers to compress the content with the
       * given compresion.
       * @param {GenericWorker} uncompressedWorker the worker to pipe.
       * @param {Object} compression the compression object.
       * @param {Object} compressionOptions the options to use when compressing.
       * @return {GenericWorker} the new worker compressing the content.
       */

      CompressedObject.createWorkerFrom = function (uncompressedWorker, compression, compressionOptions) {
        return uncompressedWorker.pipe(new Crc32Probe()).pipe(new DataLengthProbe("uncompressedSize")).pipe(compression.compressWorker(compressionOptions)).pipe(new DataLengthProbe("compressedSize")).withStreamInfo("compression", compression);
      };

      module.exports = CompressedObject;
    }, {
      "./external": 6,
      "./stream/Crc32Probe": 25,
      "./stream/DataLengthProbe": 26,
      "./stream/DataWorker": 27
    }],
    3: [function (require, module, exports) {
      'use strict';

      var GenericWorker = require("./stream/GenericWorker");

      exports.STORE = {
        magic: "\x00\x00",
        compressWorker: function compressWorker(compressionOptions) {
          return new GenericWorker("STORE compression");
        },
        uncompressWorker: function uncompressWorker() {
          return new GenericWorker("STORE decompression");
        }
      };
      exports.DEFLATE = require('./flate');
    }, {
      "./flate": 7,
      "./stream/GenericWorker": 28
    }],
    4: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');
      /**
       * The following functions come from pako, from pako/lib/zlib/crc32.js
       * released under the MIT license, see pako https://github.com/nodeca/pako/
       */
      // Use ordinary array, since untyped makes no boost here


      function makeTable() {
        var c,
            table = [];

        for (var n = 0; n < 256; n++) {
          c = n;

          for (var k = 0; k < 8; k++) {
            c = c & 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
          }

          table[n] = c;
        }

        return table;
      } // Create table on load. Just 255 signed longs. Not a problem.


      var crcTable = makeTable();

      function crc32(crc, buf, len, pos) {
        var t = crcTable,
            end = pos + len;
        crc = crc ^ -1;

        for (var i = pos; i < end; i++) {
          crc = crc >>> 8 ^ t[(crc ^ buf[i]) & 0xFF];
        }

        return crc ^ -1; // >>> 0;
      } // That's all for the pako functions.

      /**
       * Compute the crc32 of a string.
       * This is almost the same as the function crc32, but for strings. Using the
       * same function for the two use cases leads to horrible performances.
       * @param {Number} crc the starting value of the crc.
       * @param {String} str the string to use.
       * @param {Number} len the length of the string.
       * @param {Number} pos the starting position for the crc32 computation.
       * @return {Number} the computed crc32.
       */


      function crc32str(crc, str, len, pos) {
        var t = crcTable,
            end = pos + len;
        crc = crc ^ -1;

        for (var i = pos; i < end; i++) {
          crc = crc >>> 8 ^ t[(crc ^ str.charCodeAt(i)) & 0xFF];
        }

        return crc ^ -1; // >>> 0;
      }

      module.exports = function crc32wrapper(input, crc) {
        if (typeof input === "undefined" || !input.length) {
          return 0;
        }

        var isArray = utils.getTypeOf(input) !== "string";

        if (isArray) {
          return crc32(crc | 0, input, input.length, 0);
        } else {
          return crc32str(crc | 0, input, input.length, 0);
        }
      }; // vim: set shiftwidth=4 softtabstop=4:

    }, {
      "./utils": 32
    }],
    5: [function (require, module, exports) {
      'use strict';

      exports.base64 = false;
      exports.binary = false;
      exports.dir = false;
      exports.createFolders = true;
      exports.date = null;
      exports.compression = null;
      exports.compressionOptions = null;
      exports.comment = null;
      exports.unixPermissions = null;
      exports.dosPermissions = null;
    }, {}],
    6: [function (require, module, exports) {
      /* global Promise */
      'use strict'; // load the global object first:
      // - it should be better integrated in the system (unhandledRejection in node)
      // - the environment may have a custom Promise implementation (see zone.js)

      var ES6Promise = null;

      if (typeof Promise !== "undefined") {
        ES6Promise = Promise;
      } else {
        ES6Promise = require("lie");
      }
      /**
       * Let the user use/change some implementations.
       */


      module.exports = {
        Promise: ES6Promise
      };
    }, {
      "lie": 58
    }],
    7: [function (require, module, exports) {
      'use strict';

      var USE_TYPEDARRAY = typeof Uint8Array !== 'undefined' && typeof Uint16Array !== 'undefined' && typeof Uint32Array !== 'undefined';

      var pako = require("pako");

      var utils = require("./utils");

      var GenericWorker = require("./stream/GenericWorker");

      var ARRAY_TYPE = USE_TYPEDARRAY ? "uint8array" : "array";
      exports.magic = "\x08\x00";
      /**
       * Create a worker that uses pako to inflate/deflate.
       * @constructor
       * @param {String} action the name of the pako function to call : either "Deflate" or "Inflate".
       * @param {Object} options the options to use when (de)compressing.
       */

      function FlateWorker(action, options) {
        GenericWorker.call(this, "FlateWorker/" + action);
        this._pako = new pako[action]({
          raw: true,
          level: options.level || -1 // default compression

        }); // the `meta` object from the last chunk received
        // this allow this worker to pass around metadata

        this.meta = {};
        var self = this;

        this._pako.onData = function (data) {
          self.push({
            data: data,
            meta: self.meta
          });
        };
      }

      utils.inherits(FlateWorker, GenericWorker);
      /**
       * @see GenericWorker.processChunk
       */

      FlateWorker.prototype.processChunk = function (chunk) {
        this.meta = chunk.meta;

        this._pako.push(utils.transformTo(ARRAY_TYPE, chunk.data), false);
      };
      /**
       * @see GenericWorker.flush
       */


      FlateWorker.prototype.flush = function () {
        GenericWorker.prototype.flush.call(this);

        this._pako.push([], true);
      };
      /**
       * @see GenericWorker.cleanUp
       */


      FlateWorker.prototype.cleanUp = function () {
        GenericWorker.prototype.cleanUp.call(this);
        this._pako = null;
      };

      exports.compressWorker = function (compressionOptions) {
        return new FlateWorker("Deflate", compressionOptions);
      };

      exports.uncompressWorker = function () {
        return new FlateWorker("Inflate", {});
      };
    }, {
      "./stream/GenericWorker": 28,
      "./utils": 32,
      "pako": 59
    }],
    8: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');

      var GenericWorker = require('../stream/GenericWorker');

      var utf8 = require('../utf8');

      var crc32 = require('../crc32');

      var signature = require('../signature');
      /**
       * Transform an integer into a string in hexadecimal.
       * @private
       * @param {number} dec the number to convert.
       * @param {number} bytes the number of bytes to generate.
       * @returns {string} the result.
       */


      var decToHex = function decToHex(dec, bytes) {
        var hex = "",
            i;

        for (i = 0; i < bytes; i++) {
          hex += String.fromCharCode(dec & 0xff);
          dec = dec >>> 8;
        }

        return hex;
      };
      /**
       * Generate the UNIX part of the external file attributes.
       * @param {Object} unixPermissions the unix permissions or null.
       * @param {Boolean} isDir true if the entry is a directory, false otherwise.
       * @return {Number} a 32 bit integer.
       *
       * adapted from http://unix.stackexchange.com/questions/14705/the-zip-formats-external-file-attribute :
       *
       * TTTTsstrwxrwxrwx0000000000ADVSHR
       * ^^^^____________________________ file type, see zipinfo.c (UNX_*)
       *     ^^^_________________________ setuid, setgid, sticky
       *        ^^^^^^^^^________________ permissions
       *                 ^^^^^^^^^^______ not used ?
       *                           ^^^^^^ DOS attribute bits : Archive, Directory, Volume label, System file, Hidden, Read only
       */


      var generateUnixExternalFileAttr = function generateUnixExternalFileAttr(unixPermissions, isDir) {
        var result = unixPermissions;

        if (!unixPermissions) {
          // I can't use octal values in strict mode, hence the hexa.
          //  040775 => 0x41fd
          // 0100664 => 0x81b4
          result = isDir ? 0x41fd : 0x81b4;
        }

        return (result & 0xFFFF) << 16;
      };
      /**
       * Generate the DOS part of the external file attributes.
       * @param {Object} dosPermissions the dos permissions or null.
       * @param {Boolean} isDir true if the entry is a directory, false otherwise.
       * @return {Number} a 32 bit integer.
       *
       * Bit 0     Read-Only
       * Bit 1     Hidden
       * Bit 2     System
       * Bit 3     Volume Label
       * Bit 4     Directory
       * Bit 5     Archive
       */


      var generateDosExternalFileAttr = function generateDosExternalFileAttr(dosPermissions, isDir) {
        // the dir flag is already set for compatibility
        return (dosPermissions || 0) & 0x3F;
      };
      /**
       * Generate the various parts used in the construction of the final zip file.
       * @param {Object} streamInfo the hash with informations about the compressed file.
       * @param {Boolean} streamedContent is the content streamed ?
       * @param {Boolean} streamingEnded is the stream finished ?
       * @param {number} offset the current offset from the start of the zip file.
       * @param {String} platform let's pretend we are this platform (change platform dependents fields)
       * @param {Function} encodeFileName the function to encode the file name / comment.
       * @return {Object} the zip parts.
       */


      var generateZipParts = function generateZipParts(streamInfo, streamedContent, streamingEnded, offset, platform, encodeFileName) {
        var file = streamInfo['file'],
            compression = streamInfo['compression'],
            useCustomEncoding = encodeFileName !== utf8.utf8encode,
            encodedFileName = utils.transformTo("string", encodeFileName(file.name)),
            utfEncodedFileName = utils.transformTo("string", utf8.utf8encode(file.name)),
            comment = file.comment,
            encodedComment = utils.transformTo("string", encodeFileName(comment)),
            utfEncodedComment = utils.transformTo("string", utf8.utf8encode(comment)),
            useUTF8ForFileName = utfEncodedFileName.length !== file.name.length,
            useUTF8ForComment = utfEncodedComment.length !== comment.length,
            dosTime,
            dosDate,
            extraFields = "",
            unicodePathExtraField = "",
            unicodeCommentExtraField = "",
            dir = file.dir,
            date = file.date;
        var dataInfo = {
          crc32: 0,
          compressedSize: 0,
          uncompressedSize: 0
        }; // if the content is streamed, the sizes/crc32 are only available AFTER
        // the end of the stream.

        if (!streamedContent || streamingEnded) {
          dataInfo.crc32 = streamInfo['crc32'];
          dataInfo.compressedSize = streamInfo['compressedSize'];
          dataInfo.uncompressedSize = streamInfo['uncompressedSize'];
        }

        var bitflag = 0;

        if (streamedContent) {
          // Bit 3: the sizes/crc32 are set to zero in the local header.
          // The correct values are put in the data descriptor immediately
          // following the compressed data.
          bitflag |= 0x0008;
        }

        if (!useCustomEncoding && (useUTF8ForFileName || useUTF8ForComment)) {
          // Bit 11: Language encoding flag (EFS).
          bitflag |= 0x0800;
        }

        var extFileAttr = 0;
        var versionMadeBy = 0;

        if (dir) {
          // dos or unix, we set the dos dir flag
          extFileAttr |= 0x00010;
        }

        if (platform === "UNIX") {
          versionMadeBy = 0x031E; // UNIX, version 3.0

          extFileAttr |= generateUnixExternalFileAttr(file.unixPermissions, dir);
        } else {
          // DOS or other, fallback to DOS
          versionMadeBy = 0x0014; // DOS, version 2.0

          extFileAttr |= generateDosExternalFileAttr(file.dosPermissions, dir);
        } // date
        // @see http://www.delorie.com/djgpp/doc/rbinter/it/52/13.html
        // @see http://www.delorie.com/djgpp/doc/rbinter/it/65/16.html
        // @see http://www.delorie.com/djgpp/doc/rbinter/it/66/16.html


        dosTime = date.getUTCHours();
        dosTime = dosTime << 6;
        dosTime = dosTime | date.getUTCMinutes();
        dosTime = dosTime << 5;
        dosTime = dosTime | date.getUTCSeconds() / 2;
        dosDate = date.getUTCFullYear() - 1980;
        dosDate = dosDate << 4;
        dosDate = dosDate | date.getUTCMonth() + 1;
        dosDate = dosDate << 5;
        dosDate = dosDate | date.getUTCDate();

        if (useUTF8ForFileName) {
          // set the unicode path extra field. unzip needs at least one extra
          // field to correctly handle unicode path, so using the path is as good
          // as any other information. This could improve the situation with
          // other archive managers too.
          // This field is usually used without the utf8 flag, with a non
          // unicode path in the header (winrar, winzip). This helps (a bit)
          // with the messy Windows' default compressed folders feature but
          // breaks on p7zip which doesn't seek the unicode path extra field.
          // So for now, UTF-8 everywhere !
          unicodePathExtraField = // Version
          decToHex(1, 1) + // NameCRC32
          decToHex(crc32(encodedFileName), 4) + // UnicodeName
          utfEncodedFileName;
          extraFields += // Info-ZIP Unicode Path Extra Field
          "\x75\x70" + // size
          decToHex(unicodePathExtraField.length, 2) + // content
          unicodePathExtraField;
        }

        if (useUTF8ForComment) {
          unicodeCommentExtraField = // Version
          decToHex(1, 1) + // CommentCRC32
          decToHex(crc32(encodedComment), 4) + // UnicodeName
          utfEncodedComment;
          extraFields += // Info-ZIP Unicode Path Extra Field
          "\x75\x63" + // size
          decToHex(unicodeCommentExtraField.length, 2) + // content
          unicodeCommentExtraField;
        }

        var header = ""; // version needed to extract

        header += "\x0A\x00"; // general purpose bit flag

        header += decToHex(bitflag, 2); // compression method

        header += compression.magic; // last mod file time

        header += decToHex(dosTime, 2); // last mod file date

        header += decToHex(dosDate, 2); // crc-32

        header += decToHex(dataInfo.crc32, 4); // compressed size

        header += decToHex(dataInfo.compressedSize, 4); // uncompressed size

        header += decToHex(dataInfo.uncompressedSize, 4); // file name length

        header += decToHex(encodedFileName.length, 2); // extra field length

        header += decToHex(extraFields.length, 2);
        var fileRecord = signature.LOCAL_FILE_HEADER + header + encodedFileName + extraFields;
        var dirRecord = signature.CENTRAL_FILE_HEADER + // version made by (00: DOS)
        decToHex(versionMadeBy, 2) + // file header (common to file and central directory)
        header + // file comment length
        decToHex(encodedComment.length, 2) + // disk number start
        "\x00\x00" + // internal file attributes TODO
        "\x00\x00" + // external file attributes
        decToHex(extFileAttr, 4) + // relative offset of local header
        decToHex(offset, 4) + // file name
        encodedFileName + // extra field
        extraFields + // file comment
        encodedComment;
        return {
          fileRecord: fileRecord,
          dirRecord: dirRecord
        };
      };
      /**
       * Generate the EOCD record.
       * @param {Number} entriesCount the number of entries in the zip file.
       * @param {Number} centralDirLength the length (in bytes) of the central dir.
       * @param {Number} localDirLength the length (in bytes) of the local dir.
       * @param {String} comment the zip file comment as a binary string.
       * @param {Function} encodeFileName the function to encode the comment.
       * @return {String} the EOCD record.
       */


      var generateCentralDirectoryEnd = function generateCentralDirectoryEnd(entriesCount, centralDirLength, localDirLength, comment, encodeFileName) {
        var dirEnd = "";
        var encodedComment = utils.transformTo("string", encodeFileName(comment)); // end of central dir signature

        dirEnd = signature.CENTRAL_DIRECTORY_END + // number of this disk
        "\x00\x00" + // number of the disk with the start of the central directory
        "\x00\x00" + // total number of entries in the central directory on this disk
        decToHex(entriesCount, 2) + // total number of entries in the central directory
        decToHex(entriesCount, 2) + // size of the central directory   4 bytes
        decToHex(centralDirLength, 4) + // offset of start of central directory with respect to the starting disk number
        decToHex(localDirLength, 4) + // .ZIP file comment length
        decToHex(encodedComment.length, 2) + // .ZIP file comment
        encodedComment;
        return dirEnd;
      };
      /**
       * Generate data descriptors for a file entry.
       * @param {Object} streamInfo the hash generated by a worker, containing informations
       * on the file entry.
       * @return {String} the data descriptors.
       */


      var generateDataDescriptors = function generateDataDescriptors(streamInfo) {
        var descriptor = "";
        descriptor = signature.DATA_DESCRIPTOR + // crc-32                          4 bytes
        decToHex(streamInfo['crc32'], 4) + // compressed size                 4 bytes
        decToHex(streamInfo['compressedSize'], 4) + // uncompressed size               4 bytes
        decToHex(streamInfo['uncompressedSize'], 4);
        return descriptor;
      };
      /**
       * A worker to concatenate other workers to create a zip file.
       * @param {Boolean} streamFiles `true` to stream the content of the files,
       * `false` to accumulate it.
       * @param {String} comment the comment to use.
       * @param {String} platform the platform to use, "UNIX" or "DOS".
       * @param {Function} encodeFileName the function to encode file names and comments.
       */


      function ZipFileWorker(streamFiles, comment, platform, encodeFileName) {
        GenericWorker.call(this, "ZipFileWorker"); // The number of bytes written so far. This doesn't count accumulated chunks.

        this.bytesWritten = 0; // The comment of the zip file

        this.zipComment = comment; // The platform "generating" the zip file.

        this.zipPlatform = platform; // the function to encode file names and comments.

        this.encodeFileName = encodeFileName; // Should we stream the content of the files ?

        this.streamFiles = streamFiles; // If `streamFiles` is false, we will need to accumulate the content of the
        // files to calculate sizes / crc32 (and write them *before* the content).
        // This boolean indicates if we are accumulating chunks (it will change a lot
        // during the lifetime of this worker).

        this.accumulate = false; // The buffer receiving chunks when accumulating content.

        this.contentBuffer = []; // The list of generated directory records.

        this.dirRecords = []; // The offset (in bytes) from the beginning of the zip file for the current source.

        this.currentSourceOffset = 0; // The total number of entries in this zip file.

        this.entriesCount = 0; // the name of the file currently being added, null when handling the end of the zip file.
        // Used for the emited metadata.

        this.currentFile = null;
        this._sources = [];
      }

      utils.inherits(ZipFileWorker, GenericWorker);
      /**
       * @see GenericWorker.push
       */

      ZipFileWorker.prototype.push = function (chunk) {
        var currentFilePercent = chunk.meta.percent || 0;
        var entriesCount = this.entriesCount;
        var remainingFiles = this._sources.length;

        if (this.accumulate) {
          this.contentBuffer.push(chunk);
        } else {
          this.bytesWritten += chunk.data.length;
          GenericWorker.prototype.push.call(this, {
            data: chunk.data,
            meta: {
              currentFile: this.currentFile,
              percent: entriesCount ? (currentFilePercent + 100 * (entriesCount - remainingFiles - 1)) / entriesCount : 100
            }
          });
        }
      };
      /**
       * The worker started a new source (an other worker).
       * @param {Object} streamInfo the streamInfo object from the new source.
       */


      ZipFileWorker.prototype.openedSource = function (streamInfo) {
        this.currentSourceOffset = this.bytesWritten;
        this.currentFile = streamInfo['file'].name;
        var streamedContent = this.streamFiles && !streamInfo['file'].dir; // don't stream folders (because they don't have any content)

        if (streamedContent) {
          var record = generateZipParts(streamInfo, streamedContent, false, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
          this.push({
            data: record.fileRecord,
            meta: {
              percent: 0
            }
          });
        } else {
          // we need to wait for the whole file before pushing anything
          this.accumulate = true;
        }
      };
      /**
       * The worker finished a source (an other worker).
       * @param {Object} streamInfo the streamInfo object from the finished source.
       */


      ZipFileWorker.prototype.closedSource = function (streamInfo) {
        this.accumulate = false;
        var streamedContent = this.streamFiles && !streamInfo['file'].dir;
        var record = generateZipParts(streamInfo, streamedContent, true, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
        this.dirRecords.push(record.dirRecord);

        if (streamedContent) {
          // after the streamed file, we put data descriptors
          this.push({
            data: generateDataDescriptors(streamInfo),
            meta: {
              percent: 100
            }
          });
        } else {
          // the content wasn't streamed, we need to push everything now
          // first the file record, then the content
          this.push({
            data: record.fileRecord,
            meta: {
              percent: 0
            }
          });

          while (this.contentBuffer.length) {
            this.push(this.contentBuffer.shift());
          }
        }

        this.currentFile = null;
      };
      /**
       * @see GenericWorker.flush
       */


      ZipFileWorker.prototype.flush = function () {
        var localDirLength = this.bytesWritten;

        for (var i = 0; i < this.dirRecords.length; i++) {
          this.push({
            data: this.dirRecords[i],
            meta: {
              percent: 100
            }
          });
        }

        var centralDirLength = this.bytesWritten - localDirLength;
        var dirEnd = generateCentralDirectoryEnd(this.dirRecords.length, centralDirLength, localDirLength, this.zipComment, this.encodeFileName);
        this.push({
          data: dirEnd,
          meta: {
            percent: 100
          }
        });
      };
      /**
       * Prepare the next source to be read.
       */


      ZipFileWorker.prototype.prepareNextSource = function () {
        this.previous = this._sources.shift();
        this.openedSource(this.previous.streamInfo);

        if (this.isPaused) {
          this.previous.pause();
        } else {
          this.previous.resume();
        }
      };
      /**
       * @see GenericWorker.registerPrevious
       */


      ZipFileWorker.prototype.registerPrevious = function (previous) {
        this._sources.push(previous);

        var self = this;
        previous.on('data', function (chunk) {
          self.processChunk(chunk);
        });
        previous.on('end', function () {
          self.closedSource(self.previous.streamInfo);

          if (self._sources.length) {
            self.prepareNextSource();
          } else {
            self.end();
          }
        });
        previous.on('error', function (e) {
          self.error(e);
        });
        return this;
      };
      /**
       * @see GenericWorker.resume
       */


      ZipFileWorker.prototype.resume = function () {
        if (!GenericWorker.prototype.resume.call(this)) {
          return false;
        }

        if (!this.previous && this._sources.length) {
          this.prepareNextSource();
          return true;
        }

        if (!this.previous && !this._sources.length && !this.generatedError) {
          this.end();
          return true;
        }
      };
      /**
       * @see GenericWorker.error
       */


      ZipFileWorker.prototype.error = function (e) {
        var sources = this._sources;

        if (!GenericWorker.prototype.error.call(this, e)) {
          return false;
        }

        for (var i = 0; i < sources.length; i++) {
          try {
            sources[i].error(e);
          } catch (e) {// the `error` exploded, nothing to do
          }
        }

        return true;
      };
      /**
       * @see GenericWorker.lock
       */


      ZipFileWorker.prototype.lock = function () {
        GenericWorker.prototype.lock.call(this);
        var sources = this._sources;

        for (var i = 0; i < sources.length; i++) {
          sources[i].lock();
        }
      };

      module.exports = ZipFileWorker;
    }, {
      "../crc32": 4,
      "../signature": 23,
      "../stream/GenericWorker": 28,
      "../utf8": 31,
      "../utils": 32
    }],
    9: [function (require, module, exports) {
      'use strict';

      var compressions = require('../compressions');

      var ZipFileWorker = require('./ZipFileWorker');
      /**
       * Find the compression to use.
       * @param {String} fileCompression the compression defined at the file level, if any.
       * @param {String} zipCompression the compression defined at the load() level.
       * @return {Object} the compression object to use.
       */


      var getCompression = function getCompression(fileCompression, zipCompression) {
        var compressionName = fileCompression || zipCompression;
        var compression = compressions[compressionName];

        if (!compression) {
          throw new Error(compressionName + " is not a valid compression method !");
        }

        return compression;
      };
      /**
       * Create a worker to generate a zip file.
       * @param {JSZip} zip the JSZip instance at the right root level.
       * @param {Object} options to generate the zip file.
       * @param {String} comment the comment to use.
       */


      exports.generateWorker = function (zip, options, comment) {
        var zipFileWorker = new ZipFileWorker(options.streamFiles, comment, options.platform, options.encodeFileName);
        var entriesCount = 0;

        try {
          zip.forEach(function (relativePath, file) {
            entriesCount++;
            var compression = getCompression(file.options.compression, options.compression);
            var compressionOptions = file.options.compressionOptions || options.compressionOptions || {};
            var dir = file.dir,
                date = file.date;

            file._compressWorker(compression, compressionOptions).withStreamInfo("file", {
              name: relativePath,
              dir: dir,
              date: date,
              comment: file.comment || "",
              unixPermissions: file.unixPermissions,
              dosPermissions: file.dosPermissions
            }).pipe(zipFileWorker);
          });
          zipFileWorker.entriesCount = entriesCount;
        } catch (e) {
          zipFileWorker.error(e);
        }

        return zipFileWorker;
      };
    }, {
      "../compressions": 3,
      "./ZipFileWorker": 8
    }],
    10: [function (require, module, exports) {
      'use strict';
      /**
       * Representation a of zip file in js
       * @constructor
       */

      function JSZip() {
        // if this constructor is used without `new`, it adds `new` before itself:
        if (!(this instanceof JSZip)) {
          return new JSZip();
        }

        if (arguments.length) {
          throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
        } // object containing the files :
        // {
        //   "folder/" : {...},
        //   "folder/data.txt" : {...}
        // }


        this.files = {};
        this.comment = null; // Where we are in the hierarchy

        this.root = "";

        this.clone = function () {
          var newObj = new JSZip();

          for (var i in this) {
            if (typeof this[i] !== "function") {
              newObj[i] = this[i];
            }
          }

          return newObj;
        };
      }

      JSZip.prototype = require('./object');
      JSZip.prototype.loadAsync = require('./load');
      JSZip.support = require('./support');
      JSZip.defaults = require('./defaults'); // TODO find a better way to handle this version,
      // a require('package.json').version doesn't work with webpack, see #327

      JSZip.version = "3.1.3";

      JSZip.loadAsync = function (content, options) {
        return new JSZip().loadAsync(content, options);
      };

      JSZip.external = require("./external");
      module.exports = JSZip;
    }, {
      "./defaults": 5,
      "./external": 6,
      "./load": 11,
      "./object": 15,
      "./support": 30
    }],
    11: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');

      var external = require("./external");

      var utf8 = require('./utf8');

      var utils = require('./utils');

      var ZipEntries = require('./zipEntries');

      var Crc32Probe = require('./stream/Crc32Probe');

      var nodejsUtils = require("./nodejsUtils");
      /**
       * Check the CRC32 of an entry.
       * @param {ZipEntry} zipEntry the zip entry to check.
       * @return {Promise} the result.
       */


      function checkEntryCRC32(zipEntry) {
        return new external.Promise(function (resolve, reject) {
          var worker = zipEntry.decompressed.getContentWorker().pipe(new Crc32Probe());
          worker.on("error", function (e) {
            reject(e);
          }).on("end", function () {
            if (worker.streamInfo.crc32 !== zipEntry.decompressed.crc32) {
              reject(new Error("Corrupted zip : CRC32 mismatch"));
            } else {
              resolve();
            }
          }).resume();
        });
      }

      module.exports = function (data, options) {
        var zip = this;
        options = utils.extend(options || {}, {
          base64: false,
          checkCRC32: false,
          optimizedBinaryString: false,
          createFolders: false,
          decodeFileName: utf8.utf8decode
        });

        if (nodejsUtils.isNode && nodejsUtils.isStream(data)) {
          return external.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file."));
        }

        return utils.prepareContent("the loaded zip file", data, true, options.optimizedBinaryString, options.base64).then(function (data) {
          var zipEntries = new ZipEntries(options);
          zipEntries.load(data);
          return zipEntries;
        }).then(function checkCRC32(zipEntries) {
          var promises = [external.Promise.resolve(zipEntries)];
          var files = zipEntries.files;

          if (options.checkCRC32) {
            for (var i = 0; i < files.length; i++) {
              promises.push(checkEntryCRC32(files[i]));
            }
          }

          return external.Promise.all(promises);
        }).then(function addFiles(results) {
          var zipEntries = results.shift();
          var files = zipEntries.files;

          for (var i = 0; i < files.length; i++) {
            var input = files[i];
            zip.file(input.fileNameStr, input.decompressed, {
              binary: true,
              optimizedBinaryString: true,
              date: input.date,
              dir: input.dir,
              comment: input.fileCommentStr.length ? input.fileCommentStr : null,
              unixPermissions: input.unixPermissions,
              dosPermissions: input.dosPermissions,
              createFolders: options.createFolders
            });
          }

          if (zipEntries.zipComment.length) {
            zip.comment = zipEntries.zipComment;
          }

          return zip;
        });
      };
    }, {
      "./external": 6,
      "./nodejsUtils": 14,
      "./stream/Crc32Probe": 25,
      "./utf8": 31,
      "./utils": 32,
      "./zipEntries": 33
    }],
    12: [function (require, module, exports) {
      "use strict";

      var utils = require('../utils');

      var GenericWorker = require('../stream/GenericWorker');
      /**
       * A worker that use a nodejs stream as source.
       * @constructor
       * @param {String} filename the name of the file entry for this stream.
       * @param {Readable} stream the nodejs stream.
       */


      function NodejsStreamInputAdapter(filename, stream) {
        GenericWorker.call(this, "Nodejs stream input adapter for " + filename);
        this._upstreamEnded = false;

        this._bindStream(stream);
      }

      utils.inherits(NodejsStreamInputAdapter, GenericWorker);
      /**
       * Prepare the stream and bind the callbacks on it.
       * Do this ASAP on node 0.10 ! A lazy binding doesn't always work.
       * @param {Stream} stream the nodejs stream to use.
       */

      NodejsStreamInputAdapter.prototype._bindStream = function (stream) {
        var self = this;
        this._stream = stream;
        stream.pause();
        stream.on("data", function (chunk) {
          self.push({
            data: chunk,
            meta: {
              percent: 0
            }
          });
        }).on("error", function (e) {
          if (self.isPaused) {
            this.generatedError = e;
          } else {
            self.error(e);
          }
        }).on("end", function () {
          if (self.isPaused) {
            self._upstreamEnded = true;
          } else {
            self.end();
          }
        });
      };

      NodejsStreamInputAdapter.prototype.pause = function () {
        if (!GenericWorker.prototype.pause.call(this)) {
          return false;
        }

        this._stream.pause();

        return true;
      };

      NodejsStreamInputAdapter.prototype.resume = function () {
        if (!GenericWorker.prototype.resume.call(this)) {
          return false;
        }

        if (this._upstreamEnded) {
          this.end();
        } else {
          this._stream.resume();
        }

        return true;
      };

      module.exports = NodejsStreamInputAdapter;
    }, {
      "../stream/GenericWorker": 28,
      "../utils": 32
    }],
    13: [function (require, module, exports) {
      'use strict';

      var Readable = require('readable-stream').Readable;

      var util = require('util');

      util.inherits(NodejsStreamOutputAdapter, Readable);
      /**
       * A nodejs stream using a worker as source.
       * @see the SourceWrapper in http://nodejs.org/api/stream.html
       * @constructor
       * @param {StreamHelper} helper the helper wrapping the worker
       * @param {Object} options the nodejs stream options
       * @param {Function} updateCb the update callback.
       */

      function NodejsStreamOutputAdapter(helper, options, updateCb) {
        Readable.call(this, options);
        this._helper = helper;
        var self = this;
        helper.on("data", function (data, meta) {
          if (!self.push(data)) {
            self._helper.pause();
          }

          if (updateCb) {
            updateCb(meta);
          }
        }).on("error", function (e) {
          self.emit('error', e);
        }).on("end", function () {
          self.push(null);
        });
      }

      NodejsStreamOutputAdapter.prototype._read = function () {
        this._helper.resume();
      };

      module.exports = NodejsStreamOutputAdapter;
    }, {
      "readable-stream": 16,
      "util": undefined
    }],
    14: [function (require, module, exports) {
      'use strict';

      module.exports = {
        /**
         * True if this is running in Nodejs, will be undefined in a browser.
         * In a browser, browserify won't include this file and the whole module
         * will be resolved an empty object.
         */
        isNode: typeof Buffer !== "undefined",

        /**
         * Create a new nodejs Buffer.
         * @param {Object} data the data to pass to the constructor.
         * @param {String} encoding the encoding to use.
         * @return {Buffer} a new Buffer.
         */
        newBuffer: function newBuffer(data, encoding) {
          return new Buffer(data, encoding);
        },

        /**
         * Find out if an object is a Buffer.
         * @param {Object} b the object to test.
         * @return {Boolean} true if the object is a Buffer, false otherwise.
         */
        isBuffer: function isBuffer(b) {
          return Buffer.isBuffer(b);
        },
        isStream: function isStream(obj) {
          return obj && typeof obj.on === "function" && typeof obj.pause === "function" && typeof obj.resume === "function";
        }
      };
    }, {}],
    15: [function (require, module, exports) {
      'use strict';

      var utf8 = require('./utf8');

      var utils = require('./utils');

      var GenericWorker = require('./stream/GenericWorker');

      var StreamHelper = require('./stream/StreamHelper');

      var defaults = require('./defaults');

      var CompressedObject = require('./compressedObject');

      var ZipObject = require('./zipObject');

      var generate = require("./generate");

      var nodejsUtils = require("./nodejsUtils");

      var NodejsStreamInputAdapter = require("./nodejs/NodejsStreamInputAdapter");
      /**
       * Add a file in the current folder.
       * @private
       * @param {string} name the name of the file
       * @param {String|ArrayBuffer|Uint8Array|Buffer} data the data of the file
       * @param {Object} originalOptions the options of the file
       * @return {Object} the new file.
       */


      var fileAdd = function fileAdd(name, data, originalOptions) {
        // be sure sub folders exist
        var dataType = utils.getTypeOf(data),
            parent;
        /*
        * Correct options.
        */

        var o = utils.extend(originalOptions || {}, defaults);
        o.date = o.date || new Date();

        if (o.compression !== null) {
          o.compression = o.compression.toUpperCase();
        }

        if (typeof o.unixPermissions === "string") {
          o.unixPermissions = parseInt(o.unixPermissions, 8);
        } // UNX_IFDIR  0040000 see zipinfo.c


        if (o.unixPermissions && o.unixPermissions & 0x4000) {
          o.dir = true;
        } // Bit 4    Directory


        if (o.dosPermissions && o.dosPermissions & 0x0010) {
          o.dir = true;
        }

        if (o.dir) {
          name = forceTrailingSlash(name);
        }

        if (o.createFolders && (parent = parentFolder(name))) {
          folderAdd.call(this, parent, true);
        }

        var isUnicodeString = dataType === "string" && o.binary === false && o.base64 === false;

        if (!originalOptions || typeof originalOptions.binary === "undefined") {
          o.binary = !isUnicodeString;
        }

        var isCompressedEmpty = data instanceof CompressedObject && data.uncompressedSize === 0;

        if (isCompressedEmpty || o.dir || !data || data.length === 0) {
          o.base64 = false;
          o.binary = true;
          data = "";
          o.compression = "STORE";
          dataType = "string";
        }
        /*
        * Convert content to fit.
        */


        var zipObjectContent = null;

        if (data instanceof CompressedObject || data instanceof GenericWorker) {
          zipObjectContent = data;
        } else if (nodejsUtils.isNode && nodejsUtils.isStream(data)) {
          zipObjectContent = new NodejsStreamInputAdapter(name, data);
        } else {
          zipObjectContent = utils.prepareContent(name, data, o.binary, o.optimizedBinaryString, o.base64);
        }

        var object = new ZipObject(name, zipObjectContent, o);
        this.files[name] = object;
        /*
        TODO: we can't throw an exception because we have async promises
        (we can have a promise of a Date() for example) but returning a
        promise is useless because file(name, data) returns the JSZip
        object for chaining. Should we break that to allow the user
        to catch the error ?
        return external.Promise.resolve(zipObjectContent)
        .then(function () {
        return object;
        });
        */
      };
      /**
       * Find the parent folder of the path.
       * @private
       * @param {string} path the path to use
       * @return {string} the parent folder, or ""
       */


      var parentFolder = function parentFolder(path) {
        if (path.slice(-1) === '/') {
          path = path.substring(0, path.length - 1);
        }

        var lastSlash = path.lastIndexOf('/');
        return lastSlash > 0 ? path.substring(0, lastSlash) : "";
      };
      /**
       * Returns the path with a slash at the end.
       * @private
       * @param {String} path the path to check.
       * @return {String} the path with a trailing slash.
       */


      var forceTrailingSlash = function forceTrailingSlash(path) {
        // Check the name ends with a /
        if (path.slice(-1) !== "/") {
          path += "/"; // IE doesn't like substr(-1)
        }

        return path;
      };
      /**
       * Add a (sub) folder in the current folder.
       * @private
       * @param {string} name the folder's name
       * @param {boolean=} [createFolders] If true, automatically create sub
       *  folders. Defaults to false.
       * @return {Object} the new folder.
       */


      var folderAdd = function folderAdd(name, createFolders) {
        createFolders = typeof createFolders !== 'undefined' ? createFolders : defaults.createFolders;
        name = forceTrailingSlash(name); // Does this folder already exist?

        if (!this.files[name]) {
          fileAdd.call(this, name, null, {
            dir: true,
            createFolders: createFolders
          });
        }

        return this.files[name];
      };
      /**
       * Cross-window, cross-Node-context regular expression detection
       * @param  {Object}  object Anything
       * @return {Boolean}        true if the object is a regular expression,
       * false otherwise
       */


      function isRegExp(object) {
        return Object.prototype.toString.call(object) === "[object RegExp]";
      } // return the actual prototype of JSZip


      var out = {
        /**
         * @see loadAsync
         */
        load: function load() {
          throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
        },

        /**
         * Call a callback function for each entry at this folder level.
         * @param {Function} cb the callback function:
         * function (relativePath, file) {...}
         * It takes 2 arguments : the relative path and the file.
         */
        forEach: function forEach(cb) {
          var filename, relativePath, file;

          for (filename in this.files) {
            if (!this.files.hasOwnProperty(filename)) {
              continue;
            }

            file = this.files[filename];
            relativePath = filename.slice(this.root.length, filename.length);

            if (relativePath && filename.slice(0, this.root.length) === this.root) {
              // the file is in the current root
              cb(relativePath, file); // TODO reverse the parameters ? need to be clean AND consistent with the filter search fn...
            }
          }
        },

        /**
         * Filter nested files/folders with the specified function.
         * @param {Function} search the predicate to use :
         * function (relativePath, file) {...}
         * It takes 2 arguments : the relative path and the file.
         * @return {Array} An array of matching elements.
         */
        filter: function filter(search) {
          var result = [];
          this.forEach(function (relativePath, entry) {
            if (search(relativePath, entry)) {
              // the file matches the function
              result.push(entry);
            }
          });
          return result;
        },

        /**
         * Add a file to the zip file, or search a file.
         * @param   {string|RegExp} name The name of the file to add (if data is defined),
         * the name of the file to find (if no data) or a regex to match files.
         * @param   {String|ArrayBuffer|Uint8Array|Buffer} data  The file data, either raw or base64 encoded
         * @param   {Object} o     File options
         * @return  {JSZip|Object|Array} this JSZip object (when adding a file),
         * a file (when searching by string) or an array of files (when searching by regex).
         */
        file: function file(name, data, o) {
          if (arguments.length === 1) {
            if (isRegExp(name)) {
              var regexp = name;
              return this.filter(function (relativePath, file) {
                return !file.dir && regexp.test(relativePath);
              });
            } else {
              // text
              var obj = this.files[this.root + name];

              if (obj && !obj.dir) {
                return obj;
              } else {
                return null;
              }
            }
          } else {
            // more than one argument : we have data !
            name = this.root + name;
            fileAdd.call(this, name, data, o);
          }

          return this;
        },

        /**
         * Add a directory to the zip file, or search.
         * @param   {String|RegExp} arg The name of the directory to add, or a regex to search folders.
         * @return  {JSZip} an object with the new directory as the root, or an array containing matching folders.
         */
        folder: function folder(arg) {
          if (!arg) {
            return this;
          }

          if (isRegExp(arg)) {
            return this.filter(function (relativePath, file) {
              return file.dir && arg.test(relativePath);
            });
          } // else, name is a new folder


          var name = this.root + arg;
          var newFolder = folderAdd.call(this, name); // Allow chaining by returning a new object with this folder as the root

          var ret = this.clone();
          ret.root = newFolder.name;
          return ret;
        },

        /**
         * Delete a file, or a directory and all sub-files, from the zip
         * @param {string} name the name of the file to delete
         * @return {JSZip} this JSZip object
         */
        remove: function remove(name) {
          name = this.root + name;
          var file = this.files[name];

          if (!file) {
            // Look for any folders
            if (name.slice(-1) !== "/") {
              name += "/";
            }

            file = this.files[name];
          }

          if (file && !file.dir) {
            // file
            delete this.files[name];
          } else {
            // maybe a folder, delete recursively
            var kids = this.filter(function (relativePath, file) {
              return file.name.slice(0, name.length) === name;
            });

            for (var i = 0; i < kids.length; i++) {
              delete this.files[kids[i].name];
            }
          }

          return this;
        },

        /**
         * Generate the complete zip file
         * @param {Object} options the options to generate the zip file :
         * - compression, "STORE" by default.
         * - type, "base64" by default. Values are : string, base64, uint8array, arraybuffer, blob.
         * @return {String|Uint8Array|ArrayBuffer|Buffer|Blob} the zip file
         */
        generate: function generate(options) {
          throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
        },

        /**
         * Generate the complete zip file as an internal stream.
         * @param {Object} options the options to generate the zip file :
         * - compression, "STORE" by default.
         * - type, "base64" by default. Values are : string, base64, uint8array, arraybuffer, blob.
         * @return {StreamHelper} the streamed zip file.
         */
        generateInternalStream: function generateInternalStream(options) {
          var worker,
              opts = {};

          try {
            opts = utils.extend(options || {}, {
              streamFiles: false,
              compression: "STORE",
              compressionOptions: null,
              type: "",
              platform: "DOS",
              comment: null,
              mimeType: 'application/zip',
              encodeFileName: utf8.utf8encode
            });
            opts.type = opts.type.toLowerCase();
            opts.compression = opts.compression.toUpperCase(); // "binarystring" is prefered but the internals use "string".

            if (opts.type === "binarystring") {
              opts.type = "string";
            }

            if (!opts.type) {
              throw new Error("No output type specified.");
            }

            utils.checkSupport(opts.type); // accept nodejs `process.platform`

            if (opts.platform === 'darwin' || opts.platform === 'freebsd' || opts.platform === 'linux' || opts.platform === 'sunos') {
              opts.platform = "UNIX";
            }

            if (opts.platform === 'win32') {
              opts.platform = "DOS";
            }

            var comment = opts.comment || this.comment || "";
            worker = generate.generateWorker(this, opts, comment);
          } catch (e) {
            worker = new GenericWorker("error");
            worker.error(e);
          }

          return new StreamHelper(worker, opts.type || "string", opts.mimeType);
        },

        /**
         * Generate the complete zip file asynchronously.
         * @see generateInternalStream
         */
        generateAsync: function generateAsync(options, onUpdate) {
          return this.generateInternalStream(options).accumulate(onUpdate);
        },

        /**
         * Generate the complete zip file asynchronously.
         * @see generateInternalStream
         */
        generateNodeStream: function generateNodeStream(options, onUpdate) {
          options = options || {};

          if (!options.type) {
            options.type = "nodebuffer";
          }

          return this.generateInternalStream(options).toNodejsStream(onUpdate);
        }
      };
      module.exports = out;
    }, {
      "./compressedObject": 2,
      "./defaults": 5,
      "./generate": 9,
      "./nodejs/NodejsStreamInputAdapter": 12,
      "./nodejsUtils": 14,
      "./stream/GenericWorker": 28,
      "./stream/StreamHelper": 29,
      "./utf8": 31,
      "./utils": 32,
      "./zipObject": 35
    }],
    16: [function (require, module, exports) {
      /*
      * This file is used by module bundlers (browserify/webpack/etc) when
      * including a stream implementation. We use "readable-stream" to get a
      * consistent behavior between nodejs versions but bundlers often have a shim
      * for "stream". Using this shim greatly improve the compatibility and greatly
      * reduce the final size of the bundle (only one stream implementation, not
      * two).
      */
      module.exports = require("stream");
    }, {
      "stream": undefined
    }],
    17: [function (require, module, exports) {
      'use strict';

      var DataReader = require('./DataReader');

      var utils = require('../utils');

      function ArrayReader(data) {
        DataReader.call(this, data);

        for (var i = 0; i < this.data.length; i++) {
          data[i] = data[i] & 0xFF;
        }
      }

      utils.inherits(ArrayReader, DataReader);
      /**
       * @see DataReader.byteAt
       */

      ArrayReader.prototype.byteAt = function (i) {
        return this.data[this.zero + i];
      };
      /**
       * @see DataReader.lastIndexOfSignature
       */


      ArrayReader.prototype.lastIndexOfSignature = function (sig) {
        var sig0 = sig.charCodeAt(0),
            sig1 = sig.charCodeAt(1),
            sig2 = sig.charCodeAt(2),
            sig3 = sig.charCodeAt(3);

        for (var i = this.length - 4; i >= 0; --i) {
          if (this.data[i] === sig0 && this.data[i + 1] === sig1 && this.data[i + 2] === sig2 && this.data[i + 3] === sig3) {
            return i - this.zero;
          }
        }

        return -1;
      };
      /**
       * @see DataReader.readAndCheckSignature
       */


      ArrayReader.prototype.readAndCheckSignature = function (sig) {
        var sig0 = sig.charCodeAt(0),
            sig1 = sig.charCodeAt(1),
            sig2 = sig.charCodeAt(2),
            sig3 = sig.charCodeAt(3),
            data = this.readData(4);
        return sig0 === data[0] && sig1 === data[1] && sig2 === data[2] && sig3 === data[3];
      };
      /**
       * @see DataReader.readData
       */


      ArrayReader.prototype.readData = function (size) {
        this.checkOffset(size);

        if (size === 0) {
          return [];
        }

        var result = this.data.slice(this.zero + this.index, this.zero + this.index + size);
        this.index += size;
        return result;
      };

      module.exports = ArrayReader;
    }, {
      "../utils": 32,
      "./DataReader": 18
    }],
    18: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');

      function DataReader(data) {
        this.data = data; // type : see implementation

        this.length = data.length;
        this.index = 0;
        this.zero = 0;
      }

      DataReader.prototype = {
        /**
         * Check that the offset will not go too far.
         * @param {string} offset the additional offset to check.
         * @throws {Error} an Error if the offset is out of bounds.
         */
        checkOffset: function checkOffset(offset) {
          this.checkIndex(this.index + offset);
        },

        /**
         * Check that the specifed index will not be too far.
         * @param {string} newIndex the index to check.
         * @throws {Error} an Error if the index is out of bounds.
         */
        checkIndex: function checkIndex(newIndex) {
          if (this.length < this.zero + newIndex || newIndex < 0) {
            throw new Error("End of data reached (data length = " + this.length + ", asked index = " + newIndex + "). Corrupted zip ?");
          }
        },

        /**
         * Change the index.
         * @param {number} newIndex The new index.
         * @throws {Error} if the new index is out of the data.
         */
        setIndex: function setIndex(newIndex) {
          this.checkIndex(newIndex);
          this.index = newIndex;
        },

        /**
         * Skip the next n bytes.
         * @param {number} n the number of bytes to skip.
         * @throws {Error} if the new index is out of the data.
         */
        skip: function skip(n) {
          this.setIndex(this.index + n);
        },

        /**
         * Get the byte at the specified index.
         * @param {number} i the index to use.
         * @return {number} a byte.
         */
        byteAt: function byteAt(i) {// see implementations
        },

        /**
         * Get the next number with a given byte size.
         * @param {number} size the number of bytes to read.
         * @return {number} the corresponding number.
         */
        readInt: function readInt(size) {
          var result = 0,
              i;
          this.checkOffset(size);

          for (i = this.index + size - 1; i >= this.index; i--) {
            result = (result << 8) + this.byteAt(i);
          }

          this.index += size;
          return result;
        },

        /**
         * Get the next string with a given byte size.
         * @param {number} size the number of bytes to read.
         * @return {string} the corresponding string.
         */
        readString: function readString(size) {
          return utils.transformTo("string", this.readData(size));
        },

        /**
         * Get raw data without conversion, <size> bytes.
         * @param {number} size the number of bytes to read.
         * @return {Object} the raw data, implementation specific.
         */
        readData: function readData(size) {// see implementations
        },

        /**
         * Find the last occurence of a zip signature (4 bytes).
         * @param {string} sig the signature to find.
         * @return {number} the index of the last occurence, -1 if not found.
         */
        lastIndexOfSignature: function lastIndexOfSignature(sig) {// see implementations
        },

        /**
         * Read the signature (4 bytes) at the current position and compare it with sig.
         * @param {string} sig the expected signature
         * @return {boolean} true if the signature matches, false otherwise.
         */
        readAndCheckSignature: function readAndCheckSignature(sig) {// see implementations
        },

        /**
         * Get the next date.
         * @return {Date} the date.
         */
        readDate: function readDate() {
          var dostime = this.readInt(4);
          return new Date(Date.UTC((dostime >> 25 & 0x7f) + 1980, // year
          (dostime >> 21 & 0x0f) - 1, // month
          dostime >> 16 & 0x1f, // day
          dostime >> 11 & 0x1f, // hour
          dostime >> 5 & 0x3f, // minute
          (dostime & 0x1f) << 1)); // second
        }
      };
      module.exports = DataReader;
    }, {
      "../utils": 32
    }],
    19: [function (require, module, exports) {
      'use strict';

      var Uint8ArrayReader = require('./Uint8ArrayReader');

      var utils = require('../utils');

      function NodeBufferReader(data) {
        Uint8ArrayReader.call(this, data);
      }

      utils.inherits(NodeBufferReader, Uint8ArrayReader);
      /**
       * @see DataReader.readData
       */

      NodeBufferReader.prototype.readData = function (size) {
        this.checkOffset(size);
        var result = this.data.slice(this.zero + this.index, this.zero + this.index + size);
        this.index += size;
        return result;
      };

      module.exports = NodeBufferReader;
    }, {
      "../utils": 32,
      "./Uint8ArrayReader": 21
    }],
    20: [function (require, module, exports) {
      'use strict';

      var DataReader = require('./DataReader');

      var utils = require('../utils');

      function StringReader(data) {
        DataReader.call(this, data);
      }

      utils.inherits(StringReader, DataReader);
      /**
       * @see DataReader.byteAt
       */

      StringReader.prototype.byteAt = function (i) {
        return this.data.charCodeAt(this.zero + i);
      };
      /**
       * @see DataReader.lastIndexOfSignature
       */


      StringReader.prototype.lastIndexOfSignature = function (sig) {
        return this.data.lastIndexOf(sig) - this.zero;
      };
      /**
       * @see DataReader.readAndCheckSignature
       */


      StringReader.prototype.readAndCheckSignature = function (sig) {
        var data = this.readData(4);
        return sig === data;
      };
      /**
       * @see DataReader.readData
       */


      StringReader.prototype.readData = function (size) {
        this.checkOffset(size); // this will work because the constructor applied the "& 0xff" mask.

        var result = this.data.slice(this.zero + this.index, this.zero + this.index + size);
        this.index += size;
        return result;
      };

      module.exports = StringReader;
    }, {
      "../utils": 32,
      "./DataReader": 18
    }],
    21: [function (require, module, exports) {
      'use strict';

      var ArrayReader = require('./ArrayReader');

      var utils = require('../utils');

      function Uint8ArrayReader(data) {
        ArrayReader.call(this, data);
      }

      utils.inherits(Uint8ArrayReader, ArrayReader);
      /**
       * @see DataReader.readData
       */

      Uint8ArrayReader.prototype.readData = function (size) {
        this.checkOffset(size);

        if (size === 0) {
          // in IE10, when using subarray(idx, idx), we get the array [0x00] instead of [].
          return new Uint8Array(0);
        }

        var result = this.data.subarray(this.zero + this.index, this.zero + this.index + size);
        this.index += size;
        return result;
      };

      module.exports = Uint8ArrayReader;
    }, {
      "../utils": 32,
      "./ArrayReader": 17
    }],
    22: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');

      var support = require('../support');

      var ArrayReader = require('./ArrayReader');

      var StringReader = require('./StringReader');

      var NodeBufferReader = require('./NodeBufferReader');

      var Uint8ArrayReader = require('./Uint8ArrayReader');
      /**
       * Create a reader adapted to the data.
       * @param {String|ArrayBuffer|Uint8Array|Buffer} data the data to read.
       * @return {DataReader} the data reader.
       */


      module.exports = function (data) {
        var type = utils.getTypeOf(data);
        utils.checkSupport(type);

        if (type === "string" && !support.uint8array) {
          return new StringReader(data);
        }

        if (type === "nodebuffer") {
          return new NodeBufferReader(data);
        }

        if (support.uint8array) {
          return new Uint8ArrayReader(utils.transformTo("uint8array", data));
        }

        return new ArrayReader(utils.transformTo("array", data));
      }; // vim: set shiftwidth=4 softtabstop=4:

    }, {
      "../support": 30,
      "../utils": 32,
      "./ArrayReader": 17,
      "./NodeBufferReader": 19,
      "./StringReader": 20,
      "./Uint8ArrayReader": 21
    }],
    23: [function (require, module, exports) {
      'use strict';

      exports.LOCAL_FILE_HEADER = "PK\x03\x04";
      exports.CENTRAL_FILE_HEADER = "PK\x01\x02";
      exports.CENTRAL_DIRECTORY_END = "PK\x05\x06";
      exports.ZIP64_CENTRAL_DIRECTORY_LOCATOR = "PK\x06\x07";
      exports.ZIP64_CENTRAL_DIRECTORY_END = "PK\x06\x06";
      exports.DATA_DESCRIPTOR = "PK\x07\x08";
    }, {}],
    24: [function (require, module, exports) {
      'use strict';

      var GenericWorker = require('./GenericWorker');

      var utils = require('../utils');
      /**
       * A worker which convert chunks to a specified type.
       * @constructor
       * @param {String} destType the destination type.
       */


      function ConvertWorker(destType) {
        GenericWorker.call(this, "ConvertWorker to " + destType);
        this.destType = destType;
      }

      utils.inherits(ConvertWorker, GenericWorker);
      /**
       * @see GenericWorker.processChunk
       */

      ConvertWorker.prototype.processChunk = function (chunk) {
        this.push({
          data: utils.transformTo(this.destType, chunk.data),
          meta: chunk.meta
        });
      };

      module.exports = ConvertWorker;
    }, {
      "../utils": 32,
      "./GenericWorker": 28
    }],
    25: [function (require, module, exports) {
      'use strict';

      var GenericWorker = require('./GenericWorker');

      var crc32 = require('../crc32');

      var utils = require('../utils');
      /**
       * A worker which calculate the crc32 of the data flowing through.
       * @constructor
       */


      function Crc32Probe() {
        GenericWorker.call(this, "Crc32Probe");
        this.withStreamInfo("crc32", 0);
      }

      utils.inherits(Crc32Probe, GenericWorker);
      /**
       * @see GenericWorker.processChunk
       */

      Crc32Probe.prototype.processChunk = function (chunk) {
        this.streamInfo.crc32 = crc32(chunk.data, this.streamInfo.crc32 || 0);
        this.push(chunk);
      };

      module.exports = Crc32Probe;
    }, {
      "../crc32": 4,
      "../utils": 32,
      "./GenericWorker": 28
    }],
    26: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');

      var GenericWorker = require('./GenericWorker');
      /**
       * A worker which calculate the total length of the data flowing through.
       * @constructor
       * @param {String} propName the name used to expose the length
       */


      function DataLengthProbe(propName) {
        GenericWorker.call(this, "DataLengthProbe for " + propName);
        this.propName = propName;
        this.withStreamInfo(propName, 0);
      }

      utils.inherits(DataLengthProbe, GenericWorker);
      /**
       * @see GenericWorker.processChunk
       */

      DataLengthProbe.prototype.processChunk = function (chunk) {
        if (chunk) {
          var length = this.streamInfo[this.propName] || 0;
          this.streamInfo[this.propName] = length + chunk.data.length;
        }

        GenericWorker.prototype.processChunk.call(this, chunk);
      };

      module.exports = DataLengthProbe;
    }, {
      "../utils": 32,
      "./GenericWorker": 28
    }],
    27: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');

      var GenericWorker = require('./GenericWorker'); // the size of the generated chunks
      // TODO expose this as a public variable


      var DEFAULT_BLOCK_SIZE = 16 * 1024;
      /**
       * A worker that reads a content and emits chunks.
       * @constructor
       * @param {Promise} dataP the promise of the data to split
       */

      function DataWorker(dataP) {
        GenericWorker.call(this, "DataWorker");
        var self = this;
        this.dataIsReady = false;
        this.index = 0;
        this.max = 0;
        this.data = null;
        this.type = "";
        this._tickScheduled = false;
        dataP.then(function (data) {
          self.dataIsReady = true;
          self.data = data;
          self.max = data && data.length || 0;
          self.type = utils.getTypeOf(data);

          if (!self.isPaused) {
            self._tickAndRepeat();
          }
        }, function (e) {
          self.error(e);
        });
      }

      utils.inherits(DataWorker, GenericWorker);
      /**
       * @see GenericWorker.cleanUp
       */

      DataWorker.prototype.cleanUp = function () {
        GenericWorker.prototype.cleanUp.call(this);
        this.data = null;
      };
      /**
       * @see GenericWorker.resume
       */


      DataWorker.prototype.resume = function () {
        if (!GenericWorker.prototype.resume.call(this)) {
          return false;
        }

        if (!this._tickScheduled && this.dataIsReady) {
          this._tickScheduled = true;
          utils.delay(this._tickAndRepeat, [], this);
        }

        return true;
      };
      /**
       * Trigger a tick a schedule an other call to this function.
       */


      DataWorker.prototype._tickAndRepeat = function () {
        this._tickScheduled = false;

        if (this.isPaused || this.isFinished) {
          return;
        }

        this._tick();

        if (!this.isFinished) {
          utils.delay(this._tickAndRepeat, [], this);
          this._tickScheduled = true;
        }
      };
      /**
       * Read and push a chunk.
       */


      DataWorker.prototype._tick = function () {
        if (this.isPaused || this.isFinished) {
          return false;
        }

        var size = DEFAULT_BLOCK_SIZE;
        var data = null,
            nextIndex = Math.min(this.max, this.index + size);

        if (this.index >= this.max) {
          // EOF
          return this.end();
        } else {
          switch (this.type) {
            case "string":
              data = this.data.substring(this.index, nextIndex);
              break;

            case "uint8array":
              data = this.data.subarray(this.index, nextIndex);
              break;

            case "array":
            case "nodebuffer":
              data = this.data.slice(this.index, nextIndex);
              break;
          }

          this.index = nextIndex;
          return this.push({
            data: data,
            meta: {
              percent: this.max ? this.index / this.max * 100 : 0
            }
          });
        }
      };

      module.exports = DataWorker;
    }, {
      "../utils": 32,
      "./GenericWorker": 28
    }],
    28: [function (require, module, exports) {
      'use strict';
      /**
       * A worker that does nothing but passing chunks to the next one. This is like
       * a nodejs stream but with some differences. On the good side :
       * - it works on IE 6-9 without any issue / polyfill
       * - it weights less than the full dependencies bundled with browserify
       * - it forwards errors (no need to declare an error handler EVERYWHERE)
       *
       * A chunk is an object with 2 attributes : `meta` and `data`. The former is an
       * object containing anything (`percent` for example), see each worker for more
       * details. The latter is the real data (String, Uint8Array, etc).
       *
       * @constructor
       * @param {String} name the name of the stream (mainly used for debugging purposes)
       */

      function GenericWorker(name) {
        // the name of the worker
        this.name = name || "default"; // an object containing metadata about the workers chain

        this.streamInfo = {}; // an error which happened when the worker was paused

        this.generatedError = null; // an object containing metadata to be merged by this worker into the general metadata

        this.extraStreamInfo = {}; // true if the stream is paused (and should not do anything), false otherwise

        this.isPaused = true; // true if the stream is finished (and should not do anything), false otherwise

        this.isFinished = false; // true if the stream is locked to prevent further structure updates (pipe), false otherwise

        this.isLocked = false; // the event listeners

        this._listeners = {
          'data': [],
          'end': [],
          'error': []
        }; // the previous worker, if any

        this.previous = null;
      }

      GenericWorker.prototype = {
        /**
         * Push a chunk to the next workers.
         * @param {Object} chunk the chunk to push
         */
        push: function push(chunk) {
          this.emit("data", chunk);
        },

        /**
         * End the stream.
         * @return {Boolean} true if this call ended the worker, false otherwise.
         */
        end: function end() {
          if (this.isFinished) {
            return false;
          }

          this.flush();

          try {
            this.emit("end");
            this.cleanUp();
            this.isFinished = true;
          } catch (e) {
            this.emit("error", e);
          }

          return true;
        },

        /**
         * End the stream with an error.
         * @param {Error} e the error which caused the premature end.
         * @return {Boolean} true if this call ended the worker with an error, false otherwise.
         */
        error: function error(e) {
          if (this.isFinished) {
            return false;
          }

          if (this.isPaused) {
            this.generatedError = e;
          } else {
            this.isFinished = true;
            this.emit("error", e); // in the workers chain exploded in the middle of the chain,
            // the error event will go downward but we also need to notify
            // workers upward that there has been an error.

            if (this.previous) {
              this.previous.error(e);
            }

            this.cleanUp();
          }

          return true;
        },

        /**
         * Add a callback on an event.
         * @param {String} name the name of the event (data, end, error)
         * @param {Function} listener the function to call when the event is triggered
         * @return {GenericWorker} the current object for chainability
         */
        on: function on(name, listener) {
          this._listeners[name].push(listener);

          return this;
        },

        /**
         * Clean any references when a worker is ending.
         */
        cleanUp: function cleanUp() {
          this.streamInfo = this.generatedError = this.extraStreamInfo = null;
          this._listeners = [];
        },

        /**
         * Trigger an event. This will call registered callback with the provided arg.
         * @param {String} name the name of the event (data, end, error)
         * @param {Object} arg the argument to call the callback with.
         */
        emit: function emit(name, arg) {
          if (this._listeners[name]) {
            for (var i = 0; i < this._listeners[name].length; i++) {
              this._listeners[name][i].call(this, arg);
            }
          }
        },

        /**
         * Chain a worker with an other.
         * @param {Worker} next the worker receiving events from the current one.
         * @return {worker} the next worker for chainability
         */
        pipe: function pipe(next) {
          return next.registerPrevious(this);
        },

        /**
         * Same as `pipe` in the other direction.
         * Using an API with `pipe(next)` is very easy.
         * Implementing the API with the point of view of the next one registering
         * a source is easier, see the ZipFileWorker.
         * @param {Worker} previous the previous worker, sending events to this one
         * @return {Worker} the current worker for chainability
         */
        registerPrevious: function registerPrevious(previous) {
          if (this.isLocked) {
            throw new Error("The stream '" + this + "' has already been used.");
          } // sharing the streamInfo...


          this.streamInfo = previous.streamInfo; // ... and adding our own bits

          this.mergeStreamInfo();
          this.previous = previous;
          var self = this;
          previous.on('data', function (chunk) {
            self.processChunk(chunk);
          });
          previous.on('end', function () {
            self.end();
          });
          previous.on('error', function (e) {
            self.error(e);
          });
          return this;
        },

        /**
         * Pause the stream so it doesn't send events anymore.
         * @return {Boolean} true if this call paused the worker, false otherwise.
         */
        pause: function pause() {
          if (this.isPaused || this.isFinished) {
            return false;
          }

          this.isPaused = true;

          if (this.previous) {
            this.previous.pause();
          }

          return true;
        },

        /**
         * Resume a paused stream.
         * @return {Boolean} true if this call resumed the worker, false otherwise.
         */
        resume: function resume() {
          if (!this.isPaused || this.isFinished) {
            return false;
          }

          this.isPaused = false; // if true, the worker tried to resume but failed

          var withError = false;

          if (this.generatedError) {
            this.error(this.generatedError);
            withError = true;
          }

          if (this.previous) {
            this.previous.resume();
          }

          return !withError;
        },

        /**
         * Flush any remaining bytes as the stream is ending.
         */
        flush: function flush() {},

        /**
         * Process a chunk. This is usually the method overridden.
         * @param {Object} chunk the chunk to process.
         */
        processChunk: function processChunk(chunk) {
          this.push(chunk);
        },

        /**
         * Add a key/value to be added in the workers chain streamInfo once activated.
         * @param {String} key the key to use
         * @param {Object} value the associated value
         * @return {Worker} the current worker for chainability
         */
        withStreamInfo: function withStreamInfo(key, value) {
          this.extraStreamInfo[key] = value;
          this.mergeStreamInfo();
          return this;
        },

        /**
         * Merge this worker's streamInfo into the chain's streamInfo.
         */
        mergeStreamInfo: function mergeStreamInfo() {
          for (var key in this.extraStreamInfo) {
            if (!this.extraStreamInfo.hasOwnProperty(key)) {
              continue;
            }

            this.streamInfo[key] = this.extraStreamInfo[key];
          }
        },

        /**
         * Lock the stream to prevent further updates on the workers chain.
         * After calling this method, all calls to pipe will fail.
         */
        lock: function lock() {
          if (this.isLocked) {
            throw new Error("The stream '" + this + "' has already been used.");
          }

          this.isLocked = true;

          if (this.previous) {
            this.previous.lock();
          }
        },

        /**
         *
         * Pretty print the workers chain.
         */
        toString: function toString() {
          var me = "Worker " + this.name;

          if (this.previous) {
            return this.previous + " -> " + me;
          } else {
            return me;
          }
        }
      };
      module.exports = GenericWorker;
    }, {}],
    29: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');

      var ConvertWorker = require('./ConvertWorker');

      var GenericWorker = require('./GenericWorker');

      var base64 = require('../base64');

      var support = require("../support");

      var external = require("../external");

      var NodejsStreamOutputAdapter = null;

      if (support.nodestream) {
        try {
          NodejsStreamOutputAdapter = require('../nodejs/NodejsStreamOutputAdapter');
        } catch (e) {}
      }
      /**
       * Apply the final transformation of the data. If the user wants a Blob for
       * example, it's easier to work with an U8intArray and finally do the
       * ArrayBuffer/Blob conversion.
       * @param {String} resultType the name of the final type
       * @param {String} chunkType the type of the data in the given array.
       * @param {Array} dataArray the array containing the data chunks to concatenate
       * @param {String|Uint8Array|Buffer} content the content to transform
       * @param {String} mimeType the mime type of the content, if applicable.
       * @return {String|Uint8Array|ArrayBuffer|Buffer|Blob} the content in the right format.
       */


      function transformZipOutput(resultType, chunkType, dataArray, mimeType) {
        var content = null;

        switch (resultType) {
          case "blob":
            return utils.newBlob(dataArray, mimeType);

          case "base64":
            content = concat(chunkType, dataArray);
            return base64.encode(content);

          default:
            content = concat(chunkType, dataArray);
            return utils.transformTo(resultType, content);
        }
      }
      /**
       * Concatenate an array of data of the given type.
       * @param {String} type the type of the data in the given array.
       * @param {Array} dataArray the array containing the data chunks to concatenate
       * @return {String|Uint8Array|Buffer} the concatenated data
       * @throws Error if the asked type is unsupported
       */


      function concat(type, dataArray) {
        var i,
            index = 0,
            res = null,
            totalLength = 0;

        for (i = 0; i < dataArray.length; i++) {
          totalLength += dataArray[i].length;
        }

        switch (type) {
          case "string":
            return dataArray.join("");

          case "array":
            return Array.prototype.concat.apply([], dataArray);

          case "uint8array":
            res = new Uint8Array(totalLength);

            for (i = 0; i < dataArray.length; i++) {
              res.set(dataArray[i], index);
              index += dataArray[i].length;
            }

            return res;

          case "nodebuffer":
            return Buffer.concat(dataArray);

          default:
            throw new Error("concat : unsupported type '" + type + "'");
        }
      }
      /**
       * Listen a StreamHelper, accumulate its content and concatenate it into a
       * complete block.
       * @param {StreamHelper} helper the helper to use.
       * @param {Function} updateCallback a callback called on each update. Called
       * with one arg :
       * - the metadata linked to the update received.
       * @return Promise the promise for the accumulation.
       */


      function _accumulate(helper, updateCallback) {
        return new external.Promise(function (resolve, reject) {
          var dataArray = [];
          var chunkType = helper._internalType,
              resultType = helper._outputType,
              mimeType = helper._mimeType;
          helper.on('data', function (data, meta) {
            dataArray.push(data);

            if (updateCallback) {
              updateCallback(meta);
            }
          }).on('error', function (err) {
            dataArray = [];
            reject(err);
          }).on('end', function () {
            try {
              var result = transformZipOutput(resultType, chunkType, dataArray, mimeType);
              resolve(result);
            } catch (e) {
              reject(e);
            }

            dataArray = [];
          }).resume();
        });
      }
      /**
       * An helper to easily use workers outside of JSZip.
       * @constructor
       * @param {Worker} worker the worker to wrap
       * @param {String} outputType the type of data expected by the use
       * @param {String} mimeType the mime type of the content, if applicable.
       */


      function StreamHelper(worker, outputType, mimeType) {
        var internalType = outputType;

        switch (outputType) {
          case "blob":
            internalType = "arraybuffer";
            break;

          case "arraybuffer":
            internalType = "uint8array";
            break;

          case "base64":
            internalType = "string";
            break;
        }

        try {
          // the type used internally
          this._internalType = internalType; // the type used to output results

          this._outputType = outputType; // the mime type

          this._mimeType = mimeType;
          utils.checkSupport(internalType);
          this._worker = worker.pipe(new ConvertWorker(internalType)); // the last workers can be rewired without issues but we need to
          // prevent any updates on previous workers.

          worker.lock();
        } catch (e) {
          this._worker = new GenericWorker("error");

          this._worker.error(e);
        }
      }

      StreamHelper.prototype = {
        /**
         * Listen a StreamHelper, accumulate its content and concatenate it into a
         * complete block.
         * @param {Function} updateCb the update callback.
         * @return Promise the promise for the accumulation.
         */
        accumulate: function accumulate(updateCb) {
          return _accumulate(this, updateCb);
        },

        /**
         * Add a listener on an event triggered on a stream.
         * @param {String} evt the name of the event
         * @param {Function} fn the listener
         * @return {StreamHelper} the current helper.
         */
        on: function on(evt, fn) {
          var self = this;

          if (evt === "data") {
            this._worker.on(evt, function (chunk) {
              fn.call(self, chunk.data, chunk.meta);
            });
          } else {
            this._worker.on(evt, function () {
              utils.delay(fn, arguments, self);
            });
          }

          return this;
        },

        /**
         * Resume the flow of chunks.
         * @return {StreamHelper} the current helper.
         */
        resume: function resume() {
          utils.delay(this._worker.resume, [], this._worker);
          return this;
        },

        /**
         * Pause the flow of chunks.
         * @return {StreamHelper} the current helper.
         */
        pause: function pause() {
          this._worker.pause();

          return this;
        },

        /**
         * Return a nodejs stream for this helper.
         * @param {Function} updateCb the update callback.
         * @return {NodejsStreamOutputAdapter} the nodejs stream.
         */
        toNodejsStream: function toNodejsStream(updateCb) {
          utils.checkSupport("nodestream");

          if (this._outputType !== "nodebuffer") {
            // an object stream containing blob/arraybuffer/uint8array/string
            // is strange and I don't know if it would be useful.
            // I you find this comment and have a good usecase, please open a
            // bug report !
            throw new Error(this._outputType + " is not supported by this method");
          }

          return new NodejsStreamOutputAdapter(this, {
            objectMode: this._outputType !== "nodebuffer"
          }, updateCb);
        }
      };
      module.exports = StreamHelper;
    }, {
      "../base64": 1,
      "../external": 6,
      "../nodejs/NodejsStreamOutputAdapter": 13,
      "../support": 30,
      "../utils": 32,
      "./ConvertWorker": 24,
      "./GenericWorker": 28
    }],
    30: [function (require, module, exports) {
      'use strict';

      exports.base64 = true;
      exports.array = true;
      exports.string = true;
      exports.arraybuffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined";
      exports.nodebuffer = typeof Buffer !== "undefined"; // contains true if JSZip can read/generate Uint8Array, false otherwise.

      exports.uint8array = typeof Uint8Array !== "undefined";

      if (typeof ArrayBuffer === "undefined") {
        exports.blob = false;
      } else {
        var buffer = new ArrayBuffer(0);

        try {
          exports.blob = new Blob([buffer], {
            type: "application/zip"
          }).size === 0;
        } catch (e) {
          try {
            var Builder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
            var builder = new Builder();
            builder.append(buffer);
            exports.blob = builder.getBlob('application/zip').size === 0;
          } catch (e) {
            exports.blob = false;
          }
        }
      }

      try {
        exports.nodestream = !!require('readable-stream').Readable;
      } catch (e) {
        exports.nodestream = false;
      }
    }, {
      "readable-stream": 16
    }],
    31: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');

      var support = require('./support');

      var nodejsUtils = require('./nodejsUtils');

      var GenericWorker = require('./stream/GenericWorker');
      /**
       * The following functions come from pako, from pako/lib/utils/strings
       * released under the MIT license, see pako https://github.com/nodeca/pako/
       */
      // Table with utf8 lengths (calculated by first byte of sequence)
      // Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
      // because max possible codepoint is 0x10ffff


      var _utf8len = new Array(256);

      for (var i = 0; i < 256; i++) {
        _utf8len[i] = i >= 252 ? 6 : i >= 248 ? 5 : i >= 240 ? 4 : i >= 224 ? 3 : i >= 192 ? 2 : 1;
      }

      _utf8len[254] = _utf8len[254] = 1; // Invalid sequence start
      // convert string to array (typed, when possible)

      var string2buf = function string2buf(str) {
        var buf,
            c,
            c2,
            m_pos,
            i,
            str_len = str.length,
            buf_len = 0; // count binary size

        for (m_pos = 0; m_pos < str_len; m_pos++) {
          c = str.charCodeAt(m_pos);

          if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
            c2 = str.charCodeAt(m_pos + 1);

            if ((c2 & 0xfc00) === 0xdc00) {
              c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
              m_pos++;
            }
          }

          buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
        } // allocate buffer


        if (support.uint8array) {
          buf = new Uint8Array(buf_len);
        } else {
          buf = new Array(buf_len);
        } // convert


        for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
          c = str.charCodeAt(m_pos);

          if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
            c2 = str.charCodeAt(m_pos + 1);

            if ((c2 & 0xfc00) === 0xdc00) {
              c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
              m_pos++;
            }
          }

          if (c < 0x80) {
            /* one byte */
            buf[i++] = c;
          } else if (c < 0x800) {
            /* two bytes */
            buf[i++] = 0xC0 | c >>> 6;
            buf[i++] = 0x80 | c & 0x3f;
          } else if (c < 0x10000) {
            /* three bytes */
            buf[i++] = 0xE0 | c >>> 12;
            buf[i++] = 0x80 | c >>> 6 & 0x3f;
            buf[i++] = 0x80 | c & 0x3f;
          } else {
            /* four bytes */
            buf[i++] = 0xf0 | c >>> 18;
            buf[i++] = 0x80 | c >>> 12 & 0x3f;
            buf[i++] = 0x80 | c >>> 6 & 0x3f;
            buf[i++] = 0x80 | c & 0x3f;
          }
        }

        return buf;
      }; // Calculate max possible position in utf8 buffer,
      // that will not break sequence. If that's not possible
      // - (very small limits) return max size as is.
      //
      // buf[] - utf8 bytes array
      // max   - length limit (mandatory);


      var utf8border = function utf8border(buf, max) {
        var pos;
        max = max || buf.length;

        if (max > buf.length) {
          max = buf.length;
        } // go back from last position, until start of sequence found


        pos = max - 1;

        while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) {
          pos--;
        } // Fuckup - very small and broken sequence,
        // return max, because we should return something anyway.


        if (pos < 0) {
          return max;
        } // If we came to start of buffer - that means vuffer is too small,
        // return max too.


        if (pos === 0) {
          return max;
        }

        return pos + _utf8len[buf[pos]] > max ? pos : max;
      }; // convert array to string


      var buf2string = function buf2string(buf) {
        var str, i, out, c, c_len;
        var len = buf.length; // Reserve max possible length (2 words per char)
        // NB: by unknown reasons, Array is significantly faster for
        //     String.fromCharCode.apply than Uint16Array.

        var utf16buf = new Array(len * 2);

        for (out = 0, i = 0; i < len;) {
          c = buf[i++]; // quick process ascii

          if (c < 0x80) {
            utf16buf[out++] = c;
            continue;
          }

          c_len = _utf8len[c]; // skip 5 & 6 byte codes

          if (c_len > 4) {
            utf16buf[out++] = 0xfffd;
            i += c_len - 1;
            continue;
          } // apply mask on first byte


          c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07; // join the rest

          while (c_len > 1 && i < len) {
            c = c << 6 | buf[i++] & 0x3f;
            c_len--;
          } // terminated by end of string?


          if (c_len > 1) {
            utf16buf[out++] = 0xfffd;
            continue;
          }

          if (c < 0x10000) {
            utf16buf[out++] = c;
          } else {
            c -= 0x10000;
            utf16buf[out++] = 0xd800 | c >> 10 & 0x3ff;
            utf16buf[out++] = 0xdc00 | c & 0x3ff;
          }
        } // shrinkBuf(utf16buf, out)


        if (utf16buf.length !== out) {
          if (utf16buf.subarray) {
            utf16buf = utf16buf.subarray(0, out);
          } else {
            utf16buf.length = out;
          }
        } // return String.fromCharCode.apply(null, utf16buf);


        return utils.applyFromCharCode(utf16buf);
      }; // That's all for the pako functions.

      /**
       * Transform a javascript string into an array (typed if possible) of bytes,
       * UTF-8 encoded.
       * @param {String} str the string to encode
       * @return {Array|Uint8Array|Buffer} the UTF-8 encoded string.
       */


      exports.utf8encode = function utf8encode(str) {
        if (support.nodebuffer) {
          return nodejsUtils.newBuffer(str, "utf-8");
        }

        return string2buf(str);
      };
      /**
       * Transform a bytes array (or a representation) representing an UTF-8 encoded
       * string into a javascript string.
       * @param {Array|Uint8Array|Buffer} buf the data de decode
       * @return {String} the decoded string.
       */


      exports.utf8decode = function utf8decode(buf) {
        if (support.nodebuffer) {
          return utils.transformTo("nodebuffer", buf).toString("utf-8");
        }

        buf = utils.transformTo(support.uint8array ? "uint8array" : "array", buf);
        return buf2string(buf);
      };
      /**
       * A worker to decode utf8 encoded binary chunks into string chunks.
       * @constructor
       */


      function Utf8DecodeWorker() {
        GenericWorker.call(this, "utf-8 decode"); // the last bytes if a chunk didn't end with a complete codepoint.

        this.leftOver = null;
      }

      utils.inherits(Utf8DecodeWorker, GenericWorker);
      /**
       * @see GenericWorker.processChunk
       */

      Utf8DecodeWorker.prototype.processChunk = function (chunk) {
        var data = utils.transformTo(support.uint8array ? "uint8array" : "array", chunk.data); // 1st step, re-use what's left of the previous chunk

        if (this.leftOver && this.leftOver.length) {
          if (support.uint8array) {
            var previousData = data;
            data = new Uint8Array(previousData.length + this.leftOver.length);
            data.set(this.leftOver, 0);
            data.set(previousData, this.leftOver.length);
          } else {
            data = this.leftOver.concat(data);
          }

          this.leftOver = null;
        }

        var nextBoundary = utf8border(data);
        var usableData = data;

        if (nextBoundary !== data.length) {
          if (support.uint8array) {
            usableData = data.subarray(0, nextBoundary);
            this.leftOver = data.subarray(nextBoundary, data.length);
          } else {
            usableData = data.slice(0, nextBoundary);
            this.leftOver = data.slice(nextBoundary, data.length);
          }
        }

        this.push({
          data: exports.utf8decode(usableData),
          meta: chunk.meta
        });
      };
      /**
       * @see GenericWorker.flush
       */


      Utf8DecodeWorker.prototype.flush = function () {
        if (this.leftOver && this.leftOver.length) {
          this.push({
            data: exports.utf8decode(this.leftOver),
            meta: {}
          });
          this.leftOver = null;
        }
      };

      exports.Utf8DecodeWorker = Utf8DecodeWorker;
      /**
       * A worker to endcode string chunks into utf8 encoded binary chunks.
       * @constructor
       */

      function Utf8EncodeWorker() {
        GenericWorker.call(this, "utf-8 encode");
      }

      utils.inherits(Utf8EncodeWorker, GenericWorker);
      /**
       * @see GenericWorker.processChunk
       */

      Utf8EncodeWorker.prototype.processChunk = function (chunk) {
        this.push({
          data: exports.utf8encode(chunk.data),
          meta: chunk.meta
        });
      };

      exports.Utf8EncodeWorker = Utf8EncodeWorker;
    }, {
      "./nodejsUtils": 14,
      "./stream/GenericWorker": 28,
      "./support": 30,
      "./utils": 32
    }],
    32: [function (require, module, exports) {
      'use strict';

      var support = require('./support');

      var base64 = require('./base64');

      var nodejsUtils = require('./nodejsUtils');

      var setImmediate = require('core-js/library/fn/set-immediate');

      var external = require("./external");
      /**
       * Convert a string that pass as a "binary string": it should represent a byte
       * array but may have > 255 char codes. Be sure to take only the first byte
       * and returns the byte array.
       * @param {String} str the string to transform.
       * @return {Array|Uint8Array} the string in a binary format.
       */


      function string2binary(str) {
        var result = null;

        if (support.uint8array) {
          result = new Uint8Array(str.length);
        } else {
          result = new Array(str.length);
        }

        return stringToArrayLike(str, result);
      }
      /**
       * Create a new blob with the given content and the given type.
       * @param {Array[String|ArrayBuffer]} parts the content to put in the blob. DO NOT use
       * an Uint8Array because the stock browser of android 4 won't accept it (it
       * will be silently converted to a string, "[object Uint8Array]").
       * @param {String} type the mime type of the blob.
       * @return {Blob} the created blob.
       */


      exports.newBlob = function (parts, type) {
        exports.checkSupport("blob");

        try {
          // Blob constructor
          return new Blob(parts, {
            type: type
          });
        } catch (e) {
          try {
            // deprecated, browser only, old way
            var Builder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
            var builder = new Builder();

            for (var i = 0; i < parts.length; i++) {
              builder.append(parts[i]);
            }

            return builder.getBlob(type);
          } catch (e) {
            // well, fuck ?!
            throw new Error("Bug : can't construct the Blob.");
          }
        }
      };
      /**
       * The identity function.
       * @param {Object} input the input.
       * @return {Object} the same input.
       */


      function identity(input) {
        return input;
      }
      /**
       * Fill in an array with a string.
       * @param {String} str the string to use.
       * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to fill in (will be mutated).
       * @return {Array|ArrayBuffer|Uint8Array|Buffer} the updated array.
       */


      function stringToArrayLike(str, array) {
        for (var i = 0; i < str.length; ++i) {
          array[i] = str.charCodeAt(i) & 0xFF;
        }

        return array;
      }
      /**
       * An helper for the function arrayLikeToString.
       * This contains static informations and functions that
       * can be optimized by the browser JIT compiler.
       */


      var arrayToStringHelper = {
        /**
         * Transform an array of int into a string, chunk by chunk.
         * See the performances notes on arrayLikeToString.
         * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.
         * @param {String} type the type of the array.
         * @param {Integer} chunk the chunk size.
         * @return {String} the resulting string.
         * @throws Error if the chunk is too big for the stack.
         */
        stringifyByChunk: function stringifyByChunk(array, type, chunk) {
          var result = [],
              k = 0,
              len = array.length; // shortcut

          if (len <= chunk) {
            return String.fromCharCode.apply(null, array);
          }

          while (k < len) {
            if (type === "array" || type === "nodebuffer") {
              result.push(String.fromCharCode.apply(null, array.slice(k, Math.min(k + chunk, len))));
            } else {
              result.push(String.fromCharCode.apply(null, array.subarray(k, Math.min(k + chunk, len))));
            }

            k += chunk;
          }

          return result.join("");
        },

        /**
         * Call String.fromCharCode on every item in the array.
         * This is the naive implementation, which generate A LOT of intermediate string.
         * This should be used when everything else fail.
         * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.
         * @return {String} the result.
         */
        stringifyByChar: function stringifyByChar(array) {
          var resultStr = "";

          for (var i = 0; i < array.length; i++) {
            resultStr += String.fromCharCode(array[i]);
          }

          return resultStr;
        },
        applyCanBeUsed: {
          /**
           * true if the browser accepts to use String.fromCharCode on Uint8Array
           */
          uint8array: function () {
            try {
              return support.uint8array && String.fromCharCode.apply(null, new Uint8Array(1)).length === 1;
            } catch (e) {
              return false;
            }
          }(),

          /**
           * true if the browser accepts to use String.fromCharCode on nodejs Buffer.
           */
          nodebuffer: function () {
            try {
              return support.nodebuffer && String.fromCharCode.apply(null, nodejsUtils.newBuffer(1)).length === 1;
            } catch (e) {
              return false;
            }
          }()
        }
      };
      /**
       * Transform an array-like object to a string.
       * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.
       * @return {String} the result.
       */

      function arrayLikeToString(array) {
        // Performances notes :
        // --------------------
        // String.fromCharCode.apply(null, array) is the fastest, see
        // see http://jsperf.com/converting-a-uint8array-to-a-string/2
        // but the stack is limited (and we can get huge arrays !).
        //
        // result += String.fromCharCode(array[i]); generate too many strings !
        //
        // This code is inspired by http://jsperf.com/arraybuffer-to-string-apply-performance/2
        // TODO : we now have workers that split the work. Do we still need that ?
        var chunk = 65536,
            type = exports.getTypeOf(array),
            canUseApply = true;

        if (type === "uint8array") {
          canUseApply = arrayToStringHelper.applyCanBeUsed.uint8array;
        } else if (type === "nodebuffer") {
          canUseApply = arrayToStringHelper.applyCanBeUsed.nodebuffer;
        }

        if (canUseApply) {
          while (chunk > 1) {
            try {
              return arrayToStringHelper.stringifyByChunk(array, type, chunk);
            } catch (e) {
              chunk = Math.floor(chunk / 2);
            }
          }
        } // no apply or chunk error : slow and painful algorithm
        // default browser on android 4.*


        return arrayToStringHelper.stringifyByChar(array);
      }

      exports.applyFromCharCode = arrayLikeToString;
      /**
       * Copy the data from an array-like to an other array-like.
       * @param {Array|ArrayBuffer|Uint8Array|Buffer} arrayFrom the origin array.
       * @param {Array|ArrayBuffer|Uint8Array|Buffer} arrayTo the destination array which will be mutated.
       * @return {Array|ArrayBuffer|Uint8Array|Buffer} the updated destination array.
       */

      function arrayLikeToArrayLike(arrayFrom, arrayTo) {
        for (var i = 0; i < arrayFrom.length; i++) {
          arrayTo[i] = arrayFrom[i];
        }

        return arrayTo;
      } // a matrix containing functions to transform everything into everything.


      var transform = {}; // string to ?

      transform["string"] = {
        "string": identity,
        "array": function array(input) {
          return stringToArrayLike(input, new Array(input.length));
        },
        "arraybuffer": function arraybuffer(input) {
          return transform["string"]["uint8array"](input).buffer;
        },
        "uint8array": function uint8array(input) {
          return stringToArrayLike(input, new Uint8Array(input.length));
        },
        "nodebuffer": function nodebuffer(input) {
          return stringToArrayLike(input, nodejsUtils.newBuffer(input.length));
        }
      }; // array to ?

      transform["array"] = {
        "string": arrayLikeToString,
        "array": identity,
        "arraybuffer": function arraybuffer(input) {
          return new Uint8Array(input).buffer;
        },
        "uint8array": function uint8array(input) {
          return new Uint8Array(input);
        },
        "nodebuffer": function nodebuffer(input) {
          return nodejsUtils.newBuffer(input);
        }
      }; // arraybuffer to ?

      transform["arraybuffer"] = {
        "string": function string(input) {
          return arrayLikeToString(new Uint8Array(input));
        },
        "array": function array(input) {
          return arrayLikeToArrayLike(new Uint8Array(input), new Array(input.byteLength));
        },
        "arraybuffer": identity,
        "uint8array": function uint8array(input) {
          return new Uint8Array(input);
        },
        "nodebuffer": function nodebuffer(input) {
          return nodejsUtils.newBuffer(new Uint8Array(input));
        }
      }; // uint8array to ?

      transform["uint8array"] = {
        "string": arrayLikeToString,
        "array": function array(input) {
          return arrayLikeToArrayLike(input, new Array(input.length));
        },
        "arraybuffer": function arraybuffer(input) {
          // copy the uint8array: DO NOT propagate the original ArrayBuffer, it
          // can be way larger (the whole zip file for example).
          var copy = new Uint8Array(input.length);

          if (input.length) {
            copy.set(input, 0);
          }

          return copy.buffer;
        },
        "uint8array": identity,
        "nodebuffer": function nodebuffer(input) {
          return nodejsUtils.newBuffer(input);
        }
      }; // nodebuffer to ?

      transform["nodebuffer"] = {
        "string": arrayLikeToString,
        "array": function array(input) {
          return arrayLikeToArrayLike(input, new Array(input.length));
        },
        "arraybuffer": function arraybuffer(input) {
          return transform["nodebuffer"]["uint8array"](input).buffer;
        },
        "uint8array": function uint8array(input) {
          return arrayLikeToArrayLike(input, new Uint8Array(input.length));
        },
        "nodebuffer": identity
      };
      /**
       * Transform an input into any type.
       * The supported output type are : string, array, uint8array, arraybuffer, nodebuffer.
       * If no output type is specified, the unmodified input will be returned.
       * @param {String} outputType the output type.
       * @param {String|Array|ArrayBuffer|Uint8Array|Buffer} input the input to convert.
       * @throws {Error} an Error if the browser doesn't support the requested output type.
       */

      exports.transformTo = function (outputType, input) {
        if (!input) {
          // undefined, null, etc
          // an empty string won't harm.
          input = "";
        }

        if (!outputType) {
          return input;
        }

        exports.checkSupport(outputType);
        var inputType = exports.getTypeOf(input);
        var result = transform[inputType][outputType](input);
        return result;
      };
      /**
       * Return the type of the input.
       * The type will be in a format valid for JSZip.utils.transformTo : string, array, uint8array, arraybuffer.
       * @param {Object} input the input to identify.
       * @return {String} the (lowercase) type of the input.
       */


      exports.getTypeOf = function (input) {
        if (typeof input === "string") {
          return "string";
        }

        if (Object.prototype.toString.call(input) === "[object Array]") {
          return "array";
        }

        if (support.nodebuffer && nodejsUtils.isBuffer(input)) {
          return "nodebuffer";
        }

        if (support.uint8array && input instanceof Uint8Array) {
          return "uint8array";
        }

        if (support.arraybuffer && input instanceof ArrayBuffer) {
          return "arraybuffer";
        }
      };
      /**
       * Throw an exception if the type is not supported.
       * @param {String} type the type to check.
       * @throws {Error} an Error if the browser doesn't support the requested type.
       */


      exports.checkSupport = function (type) {
        var supported = support[type.toLowerCase()];

        if (!supported) {
          throw new Error(type + " is not supported by this platform");
        }
      };

      exports.MAX_VALUE_16BITS = 65535;
      exports.MAX_VALUE_32BITS = -1; // well, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" is parsed as -1

      /**
       * Prettify a string read as binary.
       * @param {string} str the string to prettify.
       * @return {string} a pretty string.
       */

      exports.pretty = function (str) {
        var res = '',
            code,
            i;

        for (i = 0; i < (str || "").length; i++) {
          code = str.charCodeAt(i);
          res += '\\x' + (code < 16 ? "0" : "") + code.toString(16).toUpperCase();
        }

        return res;
      };
      /**
       * Defer the call of a function.
       * @param {Function} callback the function to call asynchronously.
       * @param {Array} args the arguments to give to the callback.
       */


      exports.delay = function (callback, args, self) {
        setImmediate(function () {
          callback.apply(self || null, args || []);
        });
      };
      /**
       * Extends a prototype with an other, without calling a constructor with
       * side effects. Inspired by nodejs' `utils.inherits`
       * @param {Function} ctor the constructor to augment
       * @param {Function} superCtor the parent constructor to use
       */


      exports.inherits = function (ctor, superCtor) {
        var Obj = function Obj() {};

        Obj.prototype = superCtor.prototype;
        ctor.prototype = new Obj();
      };
      /**
       * Merge the objects passed as parameters into a new one.
       * @private
       * @param {...Object} var_args All objects to merge.
       * @return {Object} a new object with the data of the others.
       */


      exports.extend = function () {
        var result = {},
            i,
            attr;

        for (i = 0; i < arguments.length; i++) {
          // arguments is not enumerable in some browsers
          for (attr in arguments[i]) {
            if (arguments[i].hasOwnProperty(attr) && typeof result[attr] === "undefined") {
              result[attr] = arguments[i][attr];
            }
          }
        }

        return result;
      };
      /**
       * Transform arbitrary content into a Promise.
       * @param {String} name a name for the content being processed.
       * @param {Object} inputData the content to process.
       * @param {Boolean} isBinary true if the content is not an unicode string
       * @param {Boolean} isOptimizedBinaryString true if the string content only has one byte per character.
       * @param {Boolean} isBase64 true if the string content is encoded with base64.
       * @return {Promise} a promise in a format usable by JSZip.
       */


      exports.prepareContent = function (name, inputData, isBinary, isOptimizedBinaryString, isBase64) {
        // if inputData is already a promise, this flatten it.
        var promise = external.Promise.resolve(inputData).then(function (data) {
          var isBlob = support.blob && (data instanceof Blob || ['[object File]', '[object Blob]'].indexOf(Object.prototype.toString.call(data)) !== -1);

          if (isBlob && typeof FileReader !== "undefined") {
            return new external.Promise(function (resolve, reject) {
              var reader = new FileReader();

              reader.onload = function (e) {
                resolve(e.target.result);
              };

              reader.onerror = function (e) {
                reject(e.target.error);
              };

              reader.readAsArrayBuffer(data);
            });
          } else {
            return data;
          }
        });
        return promise.then(function (data) {
          var dataType = exports.getTypeOf(data);

          if (!dataType) {
            return external.Promise.reject(new Error("The data of '" + name + "' is in an unsupported format !"));
          } // special case : it's way easier to work with Uint8Array than with ArrayBuffer


          if (dataType === "arraybuffer") {
            data = exports.transformTo("uint8array", data);
          } else if (dataType === "string") {
            if (isBase64) {
              data = base64.decode(data);
            } else if (isBinary) {
              // optimizedBinaryString === true means that the file has already been filtered with a 0xFF mask
              if (isOptimizedBinaryString !== true) {
                // this is a string, not in a base64 format.
                // Be sure that this is a correct "binary string"
                data = string2binary(data);
              }
            }
          }

          return data;
        });
      };
    }, {
      "./base64": 1,
      "./external": 6,
      "./nodejsUtils": 14,
      "./support": 30,
      "core-js/library/fn/set-immediate": 36
    }],
    33: [function (require, module, exports) {
      'use strict';

      var readerFor = require('./reader/readerFor');

      var utils = require('./utils');

      var sig = require('./signature');

      var ZipEntry = require('./zipEntry');

      var utf8 = require('./utf8');

      var support = require('./support'); //  class ZipEntries {{{

      /**
       * All the entries in the zip file.
       * @constructor
       * @param {Object} loadOptions Options for loading the stream.
       */


      function ZipEntries(loadOptions) {
        this.files = [];
        this.loadOptions = loadOptions;
      }

      ZipEntries.prototype = {
        /**
         * Check that the reader is on the speficied signature.
         * @param {string} expectedSignature the expected signature.
         * @throws {Error} if it is an other signature.
         */
        checkSignature: function checkSignature(expectedSignature) {
          if (!this.reader.readAndCheckSignature(expectedSignature)) {
            this.reader.index -= 4;
            var signature = this.reader.readString(4);
            throw new Error("Corrupted zip or bug : unexpected signature " + "(" + utils.pretty(signature) + ", expected " + utils.pretty(expectedSignature) + ")");
          }
        },

        /**
         * Check if the given signature is at the given index.
         * @param {number} askedIndex the index to check.
         * @param {string} expectedSignature the signature to expect.
         * @return {boolean} true if the signature is here, false otherwise.
         */
        isSignature: function isSignature(askedIndex, expectedSignature) {
          var currentIndex = this.reader.index;
          this.reader.setIndex(askedIndex);
          var signature = this.reader.readString(4);
          var result = signature === expectedSignature;
          this.reader.setIndex(currentIndex);
          return result;
        },

        /**
         * Read the end of the central directory.
         */
        readBlockEndOfCentral: function readBlockEndOfCentral() {
          this.diskNumber = this.reader.readInt(2);
          this.diskWithCentralDirStart = this.reader.readInt(2);
          this.centralDirRecordsOnThisDisk = this.reader.readInt(2);
          this.centralDirRecords = this.reader.readInt(2);
          this.centralDirSize = this.reader.readInt(4);
          this.centralDirOffset = this.reader.readInt(4);
          this.zipCommentLength = this.reader.readInt(2); // warning : the encoding depends of the system locale
          // On a linux machine with LANG=en_US.utf8, this field is utf8 encoded.
          // On a windows machine, this field is encoded with the localized windows code page.

          var zipComment = this.reader.readData(this.zipCommentLength);
          var decodeParamType = support.uint8array ? "uint8array" : "array"; // To get consistent behavior with the generation part, we will assume that
          // this is utf8 encoded unless specified otherwise.

          var decodeContent = utils.transformTo(decodeParamType, zipComment);
          this.zipComment = this.loadOptions.decodeFileName(decodeContent);
        },

        /**
         * Read the end of the Zip 64 central directory.
         * Not merged with the method readEndOfCentral :
         * The end of central can coexist with its Zip64 brother,
         * I don't want to read the wrong number of bytes !
         */
        readBlockZip64EndOfCentral: function readBlockZip64EndOfCentral() {
          this.zip64EndOfCentralSize = this.reader.readInt(8);
          this.reader.skip(4); // this.versionMadeBy = this.reader.readString(2);
          // this.versionNeeded = this.reader.readInt(2);

          this.diskNumber = this.reader.readInt(4);
          this.diskWithCentralDirStart = this.reader.readInt(4);
          this.centralDirRecordsOnThisDisk = this.reader.readInt(8);
          this.centralDirRecords = this.reader.readInt(8);
          this.centralDirSize = this.reader.readInt(8);
          this.centralDirOffset = this.reader.readInt(8);
          this.zip64ExtensibleData = {};
          var extraDataSize = this.zip64EndOfCentralSize - 44,
              index = 0,
              extraFieldId,
              extraFieldLength,
              extraFieldValue;

          while (index < extraDataSize) {
            extraFieldId = this.reader.readInt(2);
            extraFieldLength = this.reader.readInt(4);
            extraFieldValue = this.reader.readData(extraFieldLength);
            this.zip64ExtensibleData[extraFieldId] = {
              id: extraFieldId,
              length: extraFieldLength,
              value: extraFieldValue
            };
          }
        },

        /**
         * Read the end of the Zip 64 central directory locator.
         */
        readBlockZip64EndOfCentralLocator: function readBlockZip64EndOfCentralLocator() {
          this.diskWithZip64CentralDirStart = this.reader.readInt(4);
          this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8);
          this.disksCount = this.reader.readInt(4);

          if (this.disksCount > 1) {
            throw new Error("Multi-volumes zip are not supported");
          }
        },

        /**
         * Read the local files, based on the offset read in the central part.
         */
        readLocalFiles: function readLocalFiles() {
          var i, file;

          for (i = 0; i < this.files.length; i++) {
            file = this.files[i];
            this.reader.setIndex(file.localHeaderOffset);
            this.checkSignature(sig.LOCAL_FILE_HEADER);
            file.readLocalPart(this.reader);
            file.handleUTF8();
            file.processAttributes();
          }
        },

        /**
         * Read the central directory.
         */
        readCentralDir: function readCentralDir() {
          var file;
          this.reader.setIndex(this.centralDirOffset);

          while (this.reader.readAndCheckSignature(sig.CENTRAL_FILE_HEADER)) {
            file = new ZipEntry({
              zip64: this.zip64
            }, this.loadOptions);
            file.readCentralPart(this.reader);
            this.files.push(file);
          }

          if (this.centralDirRecords !== this.files.length) {
            if (this.centralDirRecords !== 0 && this.files.length === 0) {
              // We expected some records but couldn't find ANY.
              // This is really suspicious, as if something went wrong.
              throw new Error("Corrupted zip or bug: expected " + this.centralDirRecords + " records in central dir, got " + this.files.length);
            } else {// We found some records but not all.
              // Something is wrong but we got something for the user: no error here.
              // console.warn("expected", this.centralDirRecords, "records in central dir, got", this.files.length);
            }
          }
        },

        /**
         * Read the end of central directory.
         */
        readEndOfCentral: function readEndOfCentral() {
          var offset = this.reader.lastIndexOfSignature(sig.CENTRAL_DIRECTORY_END);

          if (offset < 0) {
            // Check if the content is a truncated zip or complete garbage.
            // A "LOCAL_FILE_HEADER" is not required at the beginning (auto
            // extractible zip for example) but it can give a good hint.
            // If an ajax request was used without responseType, we will also
            // get unreadable data.
            var isGarbage = !this.isSignature(0, sig.LOCAL_FILE_HEADER);

            if (isGarbage) {
              throw new Error("Can't find end of central directory : is this a zip file ? " + "If it is, see http://stuk.github.io/jszip/documentation/howto/read_zip.html");
            } else {
              throw new Error("Corrupted zip : can't find end of central directory");
            }
          }

          this.reader.setIndex(offset);
          var endOfCentralDirOffset = offset;
          this.checkSignature(sig.CENTRAL_DIRECTORY_END);
          this.readBlockEndOfCentral();
          /* extract from the zip spec :
          4)  If one of the fields in the end of central directory
          record is too small to hold required data, the field
          should be set to -1 (0xFFFF or 0xFFFFFFFF) and the
          ZIP64 format record should be created.
          5)  The end of central directory record and the
          Zip64 end of central directory locator record must
          reside on the same disk when splitting or spanning
          an archive.
          */

          if (this.diskNumber === utils.MAX_VALUE_16BITS || this.diskWithCentralDirStart === utils.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === utils.MAX_VALUE_16BITS || this.centralDirRecords === utils.MAX_VALUE_16BITS || this.centralDirSize === utils.MAX_VALUE_32BITS || this.centralDirOffset === utils.MAX_VALUE_32BITS) {
            this.zip64 = true;
            /*
            Warning : the zip64 extension is supported, but ONLY if the 64bits integer read from
            the zip file can fit into a 32bits integer. This cannot be solved : Javascript represents
            all numbers as 64-bit double precision IEEE 754 floating point numbers.
            So, we have 53bits for integers and bitwise operations treat everything as 32bits.
            see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Operators/Bitwise_Operators
            and http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf section 8.5
            */
            // should look for a zip64 EOCD locator

            offset = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);

            if (offset < 0) {
              throw new Error("Corrupted zip : can't find the ZIP64 end of central directory locator");
            }

            this.reader.setIndex(offset);
            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);
            this.readBlockZip64EndOfCentralLocator(); // now the zip64 EOCD record

            if (!this.isSignature(this.relativeOffsetEndOfZip64CentralDir, sig.ZIP64_CENTRAL_DIRECTORY_END)) {
              // console.warn("ZIP64 end of central directory not where expected.");
              this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);

              if (this.relativeOffsetEndOfZip64CentralDir < 0) {
                throw new Error("Corrupted zip : can't find the ZIP64 end of central directory");
              }
            }

            this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);
            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);
            this.readBlockZip64EndOfCentral();
          }

          var expectedEndOfCentralDirOffset = this.centralDirOffset + this.centralDirSize;

          if (this.zip64) {
            expectedEndOfCentralDirOffset += 20; // end of central dir 64 locator

            expectedEndOfCentralDirOffset += 12
            /* should not include the leading 12 bytes */
            + this.zip64EndOfCentralSize;
          }

          var extraBytes = endOfCentralDirOffset - expectedEndOfCentralDirOffset;

          if (extraBytes > 0) {
            // console.warn(extraBytes, "extra bytes at beginning or within zipfile");
            if (this.isSignature(endOfCentralDirOffset, sig.CENTRAL_FILE_HEADER)) {// The offsets seem wrong, but we have something at the specified offset.
              // So… we keep it.
            } else {
              // the offset is wrong, update the "zero" of the reader
              // this happens if data has been prepended (crx files for example)
              this.reader.zero = extraBytes;
            }
          } else if (extraBytes < 0) {
            throw new Error("Corrupted zip: missing " + Math.abs(extraBytes) + " bytes.");
          }
        },
        prepareReader: function prepareReader(data) {
          this.reader = readerFor(data);
        },

        /**
         * Read a zip file and create ZipEntries.
         * @param {String|ArrayBuffer|Uint8Array|Buffer} data the binary string representing a zip file.
         */
        load: function load(data) {
          this.prepareReader(data);
          this.readEndOfCentral();
          this.readCentralDir();
          this.readLocalFiles();
        }
      }; // }}} end of ZipEntries

      module.exports = ZipEntries;
    }, {
      "./reader/readerFor": 22,
      "./signature": 23,
      "./support": 30,
      "./utf8": 31,
      "./utils": 32,
      "./zipEntry": 34
    }],
    34: [function (require, module, exports) {
      'use strict';

      var readerFor = require('./reader/readerFor');

      var utils = require('./utils');

      var CompressedObject = require('./compressedObject');

      var crc32fn = require('./crc32');

      var utf8 = require('./utf8');

      var compressions = require('./compressions');

      var support = require('./support');

      var MADE_BY_DOS = 0x00;
      var MADE_BY_UNIX = 0x03;
      /**
       * Find a compression registered in JSZip.
       * @param {string} compressionMethod the method magic to find.
       * @return {Object|null} the JSZip compression object, null if none found.
       */

      var findCompression = function findCompression(compressionMethod) {
        for (var method in compressions) {
          if (!compressions.hasOwnProperty(method)) {
            continue;
          }

          if (compressions[method].magic === compressionMethod) {
            return compressions[method];
          }
        }

        return null;
      }; // class ZipEntry {{{

      /**
       * An entry in the zip file.
       * @constructor
       * @param {Object} options Options of the current file.
       * @param {Object} loadOptions Options for loading the stream.
       */


      function ZipEntry(options, loadOptions) {
        this.options = options;
        this.loadOptions = loadOptions;
      }

      ZipEntry.prototype = {
        /**
         * say if the file is encrypted.
         * @return {boolean} true if the file is encrypted, false otherwise.
         */
        isEncrypted: function isEncrypted() {
          // bit 1 is set
          return (this.bitFlag & 0x0001) === 0x0001;
        },

        /**
         * say if the file has utf-8 filename/comment.
         * @return {boolean} true if the filename/comment is in utf-8, false otherwise.
         */
        useUTF8: function useUTF8() {
          // bit 11 is set
          return (this.bitFlag & 0x0800) === 0x0800;
        },

        /**
         * Read the local part of a zip file and add the info in this object.
         * @param {DataReader} reader the reader to use.
         */
        readLocalPart: function readLocalPart(reader) {
          var compression, localExtraFieldsLength; // we already know everything from the central dir !
          // If the central dir data are false, we are doomed.
          // On the bright side, the local part is scary  : zip64, data descriptors, both, etc.
          // The less data we get here, the more reliable this should be.
          // Let's skip the whole header and dash to the data !

          reader.skip(22); // in some zip created on windows, the filename stored in the central dir contains \ instead of /.
          // Strangely, the filename here is OK.
          // I would love to treat these zip files as corrupted (see http://www.info-zip.org/FAQ.html#backslashes
          // or APPNOTE#4.4.17.1, "All slashes MUST be forward slashes '/'") but there are a lot of bad zip generators...
          // Search "unzip mismatching "local" filename continuing with "central" filename version" on
          // the internet.
          //
          // I think I see the logic here : the central directory is used to display
          // content and the local directory is used to extract the files. Mixing / and \
          // may be used to display \ to windows users and use / when extracting the files.
          // Unfortunately, this lead also to some issues : http://seclists.org/fulldisclosure/2009/Sep/394

          this.fileNameLength = reader.readInt(2);
          localExtraFieldsLength = reader.readInt(2); // can't be sure this will be the same as the central dir
          // the fileName is stored as binary data, the handleUTF8 method will take care of the encoding.

          this.fileName = reader.readData(this.fileNameLength);
          reader.skip(localExtraFieldsLength);

          if (this.compressedSize === -1 || this.uncompressedSize === -1) {
            throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory " + "(compressedSize === -1 || uncompressedSize === -1)");
          }

          compression = findCompression(this.compressionMethod);

          if (compression === null) {
            // no compression found
            throw new Error("Corrupted zip : compression " + utils.pretty(this.compressionMethod) + " unknown (inner file : " + utils.transformTo("string", this.fileName) + ")");
          }

          this.decompressed = new CompressedObject(this.compressedSize, this.uncompressedSize, this.crc32, compression, reader.readData(this.compressedSize));
        },

        /**
         * Read the central part of a zip file and add the info in this object.
         * @param {DataReader} reader the reader to use.
         */
        readCentralPart: function readCentralPart(reader) {
          this.versionMadeBy = reader.readInt(2);
          reader.skip(2); // this.versionNeeded = reader.readInt(2);

          this.bitFlag = reader.readInt(2);
          this.compressionMethod = reader.readString(2);
          this.date = reader.readDate();
          this.crc32 = reader.readInt(4);
          this.compressedSize = reader.readInt(4);
          this.uncompressedSize = reader.readInt(4);
          var fileNameLength = reader.readInt(2);
          this.extraFieldsLength = reader.readInt(2);
          this.fileCommentLength = reader.readInt(2);
          this.diskNumberStart = reader.readInt(2);
          this.internalFileAttributes = reader.readInt(2);
          this.externalFileAttributes = reader.readInt(4);
          this.localHeaderOffset = reader.readInt(4);

          if (this.isEncrypted()) {
            throw new Error("Encrypted zip are not supported");
          } // will be read in the local part, see the comments there


          reader.skip(fileNameLength);
          this.readExtraFields(reader);
          this.parseZIP64ExtraField(reader);
          this.fileComment = reader.readData(this.fileCommentLength);
        },

        /**
         * Parse the external file attributes and get the unix/dos permissions.
         */
        processAttributes: function processAttributes() {
          this.unixPermissions = null;
          this.dosPermissions = null;
          var madeBy = this.versionMadeBy >> 8; // Check if we have the DOS directory flag set.
          // We look for it in the DOS and UNIX permissions
          // but some unknown platform could set it as a compatibility flag.

          this.dir = this.externalFileAttributes & 0x0010 ? true : false;

          if (madeBy === MADE_BY_DOS) {
            // first 6 bits (0 to 5)
            this.dosPermissions = this.externalFileAttributes & 0x3F;
          }

          if (madeBy === MADE_BY_UNIX) {
            this.unixPermissions = this.externalFileAttributes >> 16 & 0xFFFF; // the octal permissions are in (this.unixPermissions & 0x01FF).toString(8);
          } // fail safe : if the name ends with a / it probably means a folder


          if (!this.dir && this.fileNameStr.slice(-1) === '/') {
            this.dir = true;
          }
        },

        /**
         * Parse the ZIP64 extra field and merge the info in the current ZipEntry.
         * @param {DataReader} reader the reader to use.
         */
        parseZIP64ExtraField: function parseZIP64ExtraField(reader) {
          if (!this.extraFields[0x0001]) {
            return;
          } // should be something, preparing the extra reader


          var extraReader = readerFor(this.extraFields[0x0001].value); // I really hope that these 64bits integer can fit in 32 bits integer, because js
          // won't let us have more.

          if (this.uncompressedSize === utils.MAX_VALUE_32BITS) {
            this.uncompressedSize = extraReader.readInt(8);
          }

          if (this.compressedSize === utils.MAX_VALUE_32BITS) {
            this.compressedSize = extraReader.readInt(8);
          }

          if (this.localHeaderOffset === utils.MAX_VALUE_32BITS) {
            this.localHeaderOffset = extraReader.readInt(8);
          }

          if (this.diskNumberStart === utils.MAX_VALUE_32BITS) {
            this.diskNumberStart = extraReader.readInt(4);
          }
        },

        /**
         * Read the central part of a zip file and add the info in this object.
         * @param {DataReader} reader the reader to use.
         */
        readExtraFields: function readExtraFields(reader) {
          var end = reader.index + this.extraFieldsLength,
              extraFieldId,
              extraFieldLength,
              extraFieldValue;

          if (!this.extraFields) {
            this.extraFields = {};
          }

          while (reader.index < end) {
            extraFieldId = reader.readInt(2);
            extraFieldLength = reader.readInt(2);
            extraFieldValue = reader.readData(extraFieldLength);
            this.extraFields[extraFieldId] = {
              id: extraFieldId,
              length: extraFieldLength,
              value: extraFieldValue
            };
          }
        },

        /**
         * Apply an UTF8 transformation if needed.
         */
        handleUTF8: function handleUTF8() {
          var decodeParamType = support.uint8array ? "uint8array" : "array";

          if (this.useUTF8()) {
            this.fileNameStr = utf8.utf8decode(this.fileName);
            this.fileCommentStr = utf8.utf8decode(this.fileComment);
          } else {
            var upath = this.findExtraFieldUnicodePath();

            if (upath !== null) {
              this.fileNameStr = upath;
            } else {
              // ASCII text or unsupported code page
              var fileNameByteArray = utils.transformTo(decodeParamType, this.fileName);
              this.fileNameStr = this.loadOptions.decodeFileName(fileNameByteArray);
            }

            var ucomment = this.findExtraFieldUnicodeComment();

            if (ucomment !== null) {
              this.fileCommentStr = ucomment;
            } else {
              // ASCII text or unsupported code page
              var commentByteArray = utils.transformTo(decodeParamType, this.fileComment);
              this.fileCommentStr = this.loadOptions.decodeFileName(commentByteArray);
            }
          }
        },

        /**
         * Find the unicode path declared in the extra field, if any.
         * @return {String} the unicode path, null otherwise.
         */
        findExtraFieldUnicodePath: function findExtraFieldUnicodePath() {
          var upathField = this.extraFields[0x7075];

          if (upathField) {
            var extraReader = readerFor(upathField.value); // wrong version

            if (extraReader.readInt(1) !== 1) {
              return null;
            } // the crc of the filename changed, this field is out of date.


            if (crc32fn(this.fileName) !== extraReader.readInt(4)) {
              return null;
            }

            return utf8.utf8decode(extraReader.readData(upathField.length - 5));
          }

          return null;
        },

        /**
         * Find the unicode comment declared in the extra field, if any.
         * @return {String} the unicode comment, null otherwise.
         */
        findExtraFieldUnicodeComment: function findExtraFieldUnicodeComment() {
          var ucommentField = this.extraFields[0x6375];

          if (ucommentField) {
            var extraReader = readerFor(ucommentField.value); // wrong version

            if (extraReader.readInt(1) !== 1) {
              return null;
            } // the crc of the comment changed, this field is out of date.


            if (crc32fn(this.fileComment) !== extraReader.readInt(4)) {
              return null;
            }

            return utf8.utf8decode(extraReader.readData(ucommentField.length - 5));
          }

          return null;
        }
      };
      module.exports = ZipEntry;
    }, {
      "./compressedObject": 2,
      "./compressions": 3,
      "./crc32": 4,
      "./reader/readerFor": 22,
      "./support": 30,
      "./utf8": 31,
      "./utils": 32
    }],
    35: [function (require, module, exports) {
      'use strict';

      var StreamHelper = require('./stream/StreamHelper');

      var DataWorker = require('./stream/DataWorker');

      var utf8 = require('./utf8');

      var CompressedObject = require('./compressedObject');

      var GenericWorker = require('./stream/GenericWorker');
      /**
       * A simple object representing a file in the zip file.
       * @constructor
       * @param {string} name the name of the file
       * @param {String|ArrayBuffer|Uint8Array|Buffer} data the data
       * @param {Object} options the options of the file
       */


      var ZipObject = function ZipObject(name, data, options) {
        this.name = name;
        this.dir = options.dir;
        this.date = options.date;
        this.comment = options.comment;
        this.unixPermissions = options.unixPermissions;
        this.dosPermissions = options.dosPermissions;
        this._data = data;
        this._dataBinary = options.binary; // keep only the compression

        this.options = {
          compression: options.compression,
          compressionOptions: options.compressionOptions
        };
      };

      ZipObject.prototype = {
        /**
         * Create an internal stream for the content of this object.
         * @param {String} type the type of each chunk.
         * @return StreamHelper the stream.
         */
        internalStream: function internalStream(type) {
          var outputType = type.toLowerCase();
          var askUnicodeString = outputType === "string" || outputType === "text";

          if (outputType === "binarystring" || outputType === "text") {
            outputType = "string";
          }

          var result = this._decompressWorker();

          var isUnicodeString = !this._dataBinary;

          if (isUnicodeString && !askUnicodeString) {
            result = result.pipe(new utf8.Utf8EncodeWorker());
          }

          if (!isUnicodeString && askUnicodeString) {
            result = result.pipe(new utf8.Utf8DecodeWorker());
          }

          return new StreamHelper(result, outputType, "");
        },

        /**
         * Prepare the content in the asked type.
         * @param {String} type the type of the result.
         * @param {Function} onUpdate a function to call on each internal update.
         * @return Promise the promise of the result.
         */
        async: function async(type, onUpdate) {
          return this.internalStream(type).accumulate(onUpdate);
        },

        /**
         * Prepare the content as a nodejs stream.
         * @param {String} type the type of each chunk.
         * @param {Function} onUpdate a function to call on each internal update.
         * @return Stream the stream.
         */
        nodeStream: function nodeStream(type, onUpdate) {
          return this.internalStream(type || "nodebuffer").toNodejsStream(onUpdate);
        },

        /**
         * Return a worker for the compressed content.
         * @private
         * @param {Object} compression the compression object to use.
         * @param {Object} compressionOptions the options to use when compressing.
         * @return Worker the worker.
         */
        _compressWorker: function _compressWorker(compression, compressionOptions) {
          if (this._data instanceof CompressedObject && this._data.compression.magic === compression.magic) {
            return this._data.getCompressedWorker();
          } else {
            var result = this._decompressWorker();

            if (!this._dataBinary) {
              result = result.pipe(new utf8.Utf8EncodeWorker());
            }

            return CompressedObject.createWorkerFrom(result, compression, compressionOptions);
          }
        },

        /**
         * Return a worker for the decompressed content.
         * @private
         * @return Worker the worker.
         */
        _decompressWorker: function _decompressWorker() {
          if (this._data instanceof CompressedObject) {
            return this._data.getContentWorker();
          } else if (this._data instanceof GenericWorker) {
            return this._data;
          } else {
            return new DataWorker(this._data);
          }
        }
      };
      var removedMethods = ["asText", "asBinary", "asNodeBuffer", "asUint8Array", "asArrayBuffer"];

      var removedFn = function removedFn() {
        throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
      };

      for (var i = 0; i < removedMethods.length; i++) {
        ZipObject.prototype[removedMethods[i]] = removedFn;
      }

      module.exports = ZipObject;
    }, {
      "./compressedObject": 2,
      "./stream/DataWorker": 27,
      "./stream/GenericWorker": 28,
      "./stream/StreamHelper": 29,
      "./utf8": 31
    }],
    36: [function (require, module, exports) {
      require('../modules/web.immediate');

      module.exports = require('../modules/_core').setImmediate;
    }, {
      "../modules/_core": 40,
      "../modules/web.immediate": 56
    }],
    37: [function (require, module, exports) {
      module.exports = function (it) {
        if (typeof it != 'function') throw TypeError(it + ' is not a function!');
        return it;
      };
    }, {}],
    38: [function (require, module, exports) {
      var isObject = require('./_is-object');

      module.exports = function (it) {
        if (!isObject(it)) throw TypeError(it + ' is not an object!');
        return it;
      };
    }, {
      "./_is-object": 51
    }],
    39: [function (require, module, exports) {
      var toString = {}.toString;

      module.exports = function (it) {
        return toString.call(it).slice(8, -1);
      };
    }, {}],
    40: [function (require, module, exports) {
      var core = module.exports = {
        version: '2.3.0'
      };
      if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef
    }, {}],
    41: [function (require, module, exports) {
      // optional / simple context binding
      var aFunction = require('./_a-function');

      module.exports = function (fn, that, length) {
        aFunction(fn);
        if (that === undefined) return fn;

        switch (length) {
          case 1:
            return function (a) {
              return fn.call(that, a);
            };

          case 2:
            return function (a, b) {
              return fn.call(that, a, b);
            };

          case 3:
            return function (a, b, c) {
              return fn.call(that, a, b, c);
            };
        }

        return function ()
        /* ...args */
        {
          return fn.apply(that, arguments);
        };
      };
    }, {
      "./_a-function": 37
    }],
    42: [function (require, module, exports) {
      // Thank's IE8 for his funny defineProperty
      module.exports = !require('./_fails')(function () {
        return Object.defineProperty({}, 'a', {
          get: function get() {
            return 7;
          }
        }).a != 7;
      });
    }, {
      "./_fails": 45
    }],
    43: [function (require, module, exports) {
      var isObject = require('./_is-object'),
          document = require('./_global').document // in old IE typeof document.createElement is 'object'
      ,
          is = isObject(document) && isObject(document.createElement);

      module.exports = function (it) {
        return is ? document.createElement(it) : {};
      };
    }, {
      "./_global": 46,
      "./_is-object": 51
    }],
    44: [function (require, module, exports) {
      var global = require('./_global'),
          core = require('./_core'),
          ctx = require('./_ctx'),
          hide = require('./_hide'),
          PROTOTYPE = 'prototype';

      var $export = function $export(type, name, source) {
        var IS_FORCED = type & $export.F,
            IS_GLOBAL = type & $export.G,
            IS_STATIC = type & $export.S,
            IS_PROTO = type & $export.P,
            IS_BIND = type & $export.B,
            IS_WRAP = type & $export.W,
            exports = IS_GLOBAL ? core : core[name] || (core[name] = {}),
            expProto = exports[PROTOTYPE],
            target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE],
            key,
            own,
            out;
        if (IS_GLOBAL) source = name;

        for (key in source) {
          // contains in native
          own = !IS_FORCED && target && target[key] !== undefined;
          if (own && key in exports) continue; // export native or passed

          out = own ? target[key] : source[key]; // prevent global pollution for namespaces

          exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key] // bind timers to global for call from export context
          : IS_BIND && own ? ctx(out, global) // wrap global constructors for prevent change them in library
          : IS_WRAP && target[key] == out ? function (C) {
            var F = function F(a, b, c) {
              if (this instanceof C) {
                switch (arguments.length) {
                  case 0:
                    return new C();

                  case 1:
                    return new C(a);

                  case 2:
                    return new C(a, b);
                }

                return new C(a, b, c);
              }

              return C.apply(this, arguments);
            };

            F[PROTOTYPE] = C[PROTOTYPE];
            return F; // make static versions for prototype methods
          }(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out; // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%

          if (IS_PROTO) {
            (exports.virtual || (exports.virtual = {}))[key] = out; // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%

            if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
          }
        }
      }; // type bitmap


      $export.F = 1; // forced

      $export.G = 2; // global

      $export.S = 4; // static

      $export.P = 8; // proto

      $export.B = 16; // bind

      $export.W = 32; // wrap

      $export.U = 64; // safe

      $export.R = 128; // real proto method for `library`

      module.exports = $export;
    }, {
      "./_core": 40,
      "./_ctx": 41,
      "./_global": 46,
      "./_hide": 47
    }],
    45: [function (require, module, exports) {
      module.exports = function (exec) {
        try {
          return !!exec();
        } catch (e) {
          return true;
        }
      };
    }, {}],
    46: [function (require, module, exports) {
      // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
      var global = module.exports = typeof window != 'undefined' && window.Math == Math ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();
      if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef
    }, {}],
    47: [function (require, module, exports) {
      var dP = require('./_object-dp'),
          createDesc = require('./_property-desc');

      module.exports = require('./_descriptors') ? function (object, key, value) {
        return dP.f(object, key, createDesc(1, value));
      } : function (object, key, value) {
        object[key] = value;
        return object;
      };
    }, {
      "./_descriptors": 42,
      "./_object-dp": 52,
      "./_property-desc": 53
    }],
    48: [function (require, module, exports) {
      module.exports = require('./_global').document && document.documentElement;
    }, {
      "./_global": 46
    }],
    49: [function (require, module, exports) {
      module.exports = !require('./_descriptors') && !require('./_fails')(function () {
        return Object.defineProperty(require('./_dom-create')('div'), 'a', {
          get: function get() {
            return 7;
          }
        }).a != 7;
      });
    }, {
      "./_descriptors": 42,
      "./_dom-create": 43,
      "./_fails": 45
    }],
    50: [function (require, module, exports) {
      // fast apply, http://jsperf.lnkit.com/fast-apply/5
      module.exports = function (fn, args, that) {
        var un = that === undefined;

        switch (args.length) {
          case 0:
            return un ? fn() : fn.call(that);

          case 1:
            return un ? fn(args[0]) : fn.call(that, args[0]);

          case 2:
            return un ? fn(args[0], args[1]) : fn.call(that, args[0], args[1]);

          case 3:
            return un ? fn(args[0], args[1], args[2]) : fn.call(that, args[0], args[1], args[2]);

          case 4:
            return un ? fn(args[0], args[1], args[2], args[3]) : fn.call(that, args[0], args[1], args[2], args[3]);
        }

        return fn.apply(that, args);
      };
    }, {}],
    51: [function (require, module, exports) {
      module.exports = function (it) {
        return _typeof(it) === 'object' ? it !== null : typeof it === 'function';
      };
    }, {}],
    52: [function (require, module, exports) {
      var anObject = require('./_an-object'),
          IE8_DOM_DEFINE = require('./_ie8-dom-define'),
          toPrimitive = require('./_to-primitive'),
          dP = Object.defineProperty;

      exports.f = require('./_descriptors') ? Object.defineProperty : function defineProperty(O, P, Attributes) {
        anObject(O);
        P = toPrimitive(P, true);
        anObject(Attributes);
        if (IE8_DOM_DEFINE) try {
          return dP(O, P, Attributes);
        } catch (e) {
          /* empty */
        }
        if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
        if ('value' in Attributes) O[P] = Attributes.value;
        return O;
      };
    }, {
      "./_an-object": 38,
      "./_descriptors": 42,
      "./_ie8-dom-define": 49,
      "./_to-primitive": 55
    }],
    53: [function (require, module, exports) {
      module.exports = function (bitmap, value) {
        return {
          enumerable: !(bitmap & 1),
          configurable: !(bitmap & 2),
          writable: !(bitmap & 4),
          value: value
        };
      };
    }, {}],
    54: [function (require, module, exports) {
      var ctx = require('./_ctx'),
          invoke = require('./_invoke'),
          html = require('./_html'),
          cel = require('./_dom-create'),
          global = require('./_global'),
          process = global.process,
          setTask = global.setImmediate,
          clearTask = global.clearImmediate,
          MessageChannel = global.MessageChannel,
          counter = 0,
          queue = {},
          ONREADYSTATECHANGE = 'onreadystatechange',
          defer,
          channel,
          port;

      var run = function run() {
        var id = +this;

        if (queue.hasOwnProperty(id)) {
          var fn = queue[id];
          delete queue[id];
          fn();
        }
      };

      var listener = function listener(event) {
        run.call(event.data);
      }; // Node.js 0.9+ & IE10+ has setImmediate, otherwise:


      if (!setTask || !clearTask) {
        setTask = function setImmediate(fn) {
          var args = [],
              i = 1;

          while (arguments.length > i) {
            args.push(arguments[i++]);
          }

          queue[++counter] = function () {
            invoke(typeof fn == 'function' ? fn : Function(fn), args);
          };

          defer(counter);
          return counter;
        };

        clearTask = function clearImmediate(id) {
          delete queue[id];
        }; // Node.js 0.8-


        if (require('./_cof')(process) == 'process') {
          defer = function defer(id) {
            process.nextTick(ctx(run, id, 1));
          }; // Browsers with MessageChannel, includes WebWorkers

        } else if (MessageChannel) {
          channel = new MessageChannel();
          port = channel.port2;
          channel.port1.onmessage = listener;
          defer = ctx(port.postMessage, port, 1); // Browsers with postMessage, skip WebWorkers
          // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
        } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts) {
          defer = function defer(id) {
            global.postMessage(id + '', '*');
          };

          global.addEventListener('message', listener, false); // IE8-
        } else if (ONREADYSTATECHANGE in cel('script')) {
          defer = function defer(id) {
            html.appendChild(cel('script'))[ONREADYSTATECHANGE] = function () {
              html.removeChild(this);
              run.call(id);
            };
          }; // Rest old browsers

        } else {
          defer = function defer(id) {
            setTimeout(ctx(run, id, 1), 0);
          };
        }
      }

      module.exports = {
        set: setTask,
        clear: clearTask
      };
    }, {
      "./_cof": 39,
      "./_ctx": 41,
      "./_dom-create": 43,
      "./_global": 46,
      "./_html": 48,
      "./_invoke": 50
    }],
    55: [function (require, module, exports) {
      // 7.1.1 ToPrimitive(input [, PreferredType])
      var isObject = require('./_is-object'); // instead of the ES6 spec version, we didn't implement @@toPrimitive case
      // and the second argument - flag - preferred type is a string


      module.exports = function (it, S) {
        if (!isObject(it)) return it;
        var fn, val;
        if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
        if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
        if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
        throw TypeError("Can't convert object to primitive value");
      };
    }, {
      "./_is-object": 51
    }],
    56: [function (require, module, exports) {
      var $export = require('./_export'),
          $task = require('./_task');

      $export($export.G + $export.B, {
        setImmediate: $task.set,
        clearImmediate: $task.clear
      });
    }, {
      "./_export": 44,
      "./_task": 54
    }],
    57: [function (require, module, exports) {
      (function (global) {
        'use strict';

        var Mutation = global.MutationObserver || global.WebKitMutationObserver;
        var scheduleDrain;
        {
          if (Mutation) {
            var called = 0;
            var observer = new Mutation(nextTick);
            var element = global.document.createTextNode('');
            observer.observe(element, {
              characterData: true
            });

            scheduleDrain = function scheduleDrain() {
              element.data = called = ++called % 2;
            };
          } else if (!global.setImmediate && typeof global.MessageChannel !== 'undefined') {
            var channel = new global.MessageChannel();
            channel.port1.onmessage = nextTick;

            scheduleDrain = function scheduleDrain() {
              channel.port2.postMessage(0);
            };
          } else if ('document' in global && 'onreadystatechange' in global.document.createElement('script')) {
            scheduleDrain = function scheduleDrain() {
              // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
              // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
              var scriptEl = global.document.createElement('script');

              scriptEl.onreadystatechange = function () {
                nextTick();
                scriptEl.onreadystatechange = null;
                scriptEl.parentNode.removeChild(scriptEl);
                scriptEl = null;
              };

              global.document.documentElement.appendChild(scriptEl);
            };
          } else {
            scheduleDrain = function scheduleDrain() {
              setTimeout(nextTick, 0);
            };
          }
        }
        var draining;
        var queue = []; //named nextTick for less confusing stack traces

        function nextTick() {
          draining = true;
          var i, oldQueue;
          var len = queue.length;

          while (len) {
            oldQueue = queue;
            queue = [];
            i = -1;

            while (++i < len) {
              oldQueue[i]();
            }

            len = queue.length;
          }

          draining = false;
        }

        module.exports = immediate;

        function immediate(task) {
          if (queue.push(task) === 1 && !draining) {
            scheduleDrain();
          }
        }
      }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
    }, {}],
    58: [function (require, module, exports) {
      'use strict';

      var immediate = require('immediate');
      /* istanbul ignore next */


      function INTERNAL() {}

      var handlers = {};
      var REJECTED = ['REJECTED'];
      var FULFILLED = ['FULFILLED'];
      var PENDING = ['PENDING'];
      module.exports = Promise;

      function Promise(resolver) {
        if (typeof resolver !== 'function') {
          throw new TypeError('resolver must be a function');
        }

        this.state = PENDING;
        this.queue = [];
        this.outcome = void 0;

        if (resolver !== INTERNAL) {
          safelyResolveThenable(this, resolver);
        }
      }

      Promise.prototype["catch"] = function (onRejected) {
        return this.then(null, onRejected);
      };

      Promise.prototype.then = function (onFulfilled, onRejected) {
        if (typeof onFulfilled !== 'function' && this.state === FULFILLED || typeof onRejected !== 'function' && this.state === REJECTED) {
          return this;
        }

        var promise = new this.constructor(INTERNAL);

        if (this.state !== PENDING) {
          var resolver = this.state === FULFILLED ? onFulfilled : onRejected;
          unwrap(promise, resolver, this.outcome);
        } else {
          this.queue.push(new QueueItem(promise, onFulfilled, onRejected));
        }

        return promise;
      };

      function QueueItem(promise, onFulfilled, onRejected) {
        this.promise = promise;

        if (typeof onFulfilled === 'function') {
          this.onFulfilled = onFulfilled;
          this.callFulfilled = this.otherCallFulfilled;
        }

        if (typeof onRejected === 'function') {
          this.onRejected = onRejected;
          this.callRejected = this.otherCallRejected;
        }
      }

      QueueItem.prototype.callFulfilled = function (value) {
        handlers.resolve(this.promise, value);
      };

      QueueItem.prototype.otherCallFulfilled = function (value) {
        unwrap(this.promise, this.onFulfilled, value);
      };

      QueueItem.prototype.callRejected = function (value) {
        handlers.reject(this.promise, value);
      };

      QueueItem.prototype.otherCallRejected = function (value) {
        unwrap(this.promise, this.onRejected, value);
      };

      function unwrap(promise, func, value) {
        immediate(function () {
          var returnValue;

          try {
            returnValue = func(value);
          } catch (e) {
            return handlers.reject(promise, e);
          }

          if (returnValue === promise) {
            handlers.reject(promise, new TypeError('Cannot resolve promise with itself'));
          } else {
            handlers.resolve(promise, returnValue);
          }
        });
      }

      handlers.resolve = function (self, value) {
        var result = tryCatch(getThen, value);

        if (result.status === 'error') {
          return handlers.reject(self, result.value);
        }

        var thenable = result.value;

        if (thenable) {
          safelyResolveThenable(self, thenable);
        } else {
          self.state = FULFILLED;
          self.outcome = value;
          var i = -1;
          var len = self.queue.length;

          while (++i < len) {
            self.queue[i].callFulfilled(value);
          }
        }

        return self;
      };

      handlers.reject = function (self, error) {
        self.state = REJECTED;
        self.outcome = error;
        var i = -1;
        var len = self.queue.length;

        while (++i < len) {
          self.queue[i].callRejected(error);
        }

        return self;
      };

      function getThen(obj) {
        // Make sure we only access the accessor once as required by the spec
        var then = obj && obj.then;

        if (obj && _typeof(obj) === 'object' && typeof then === 'function') {
          return function appyThen() {
            then.apply(obj, arguments);
          };
        }
      }

      function safelyResolveThenable(self, thenable) {
        // Either fulfill, reject or reject with error
        var called = false;

        function onError(value) {
          if (called) {
            return;
          }

          called = true;
          handlers.reject(self, value);
        }

        function onSuccess(value) {
          if (called) {
            return;
          }

          called = true;
          handlers.resolve(self, value);
        }

        function tryToUnwrap() {
          thenable(onSuccess, onError);
        }

        var result = tryCatch(tryToUnwrap);

        if (result.status === 'error') {
          onError(result.value);
        }
      }

      function tryCatch(func, value) {
        var out = {};

        try {
          out.value = func(value);
          out.status = 'success';
        } catch (e) {
          out.status = 'error';
          out.value = e;
        }

        return out;
      }

      Promise.resolve = resolve;

      function resolve(value) {
        if (value instanceof this) {
          return value;
        }

        return handlers.resolve(new this(INTERNAL), value);
      }

      Promise.reject = reject;

      function reject(reason) {
        var promise = new this(INTERNAL);
        return handlers.reject(promise, reason);
      }

      Promise.all = all;

      function all(iterable) {
        var self = this;

        if (Object.prototype.toString.call(iterable) !== '[object Array]') {
          return this.reject(new TypeError('must be an array'));
        }

        var len = iterable.length;
        var called = false;

        if (!len) {
          return this.resolve([]);
        }

        var values = new Array(len);
        var resolved = 0;
        var i = -1;
        var promise = new this(INTERNAL);

        while (++i < len) {
          allResolver(iterable[i], i);
        }

        return promise;

        function allResolver(value, i) {
          self.resolve(value).then(resolveFromAll, function (error) {
            if (!called) {
              called = true;
              handlers.reject(promise, error);
            }
          });

          function resolveFromAll(outValue) {
            values[i] = outValue;

            if (++resolved === len && !called) {
              called = true;
              handlers.resolve(promise, values);
            }
          }
        }
      }

      Promise.race = race;

      function race(iterable) {
        var self = this;

        if (Object.prototype.toString.call(iterable) !== '[object Array]') {
          return this.reject(new TypeError('must be an array'));
        }

        var len = iterable.length;
        var called = false;

        if (!len) {
          return this.resolve([]);
        }

        var i = -1;
        var promise = new this(INTERNAL);

        while (++i < len) {
          resolver(iterable[i]);
        }

        return promise;

        function resolver(value) {
          self.resolve(value).then(function (response) {
            if (!called) {
              called = true;
              handlers.resolve(promise, response);
            }
          }, function (error) {
            if (!called) {
              called = true;
              handlers.reject(promise, error);
            }
          });
        }
      }
    }, {
      "immediate": 57
    }],
    59: [function (require, module, exports) {
      // Top level file is just a mixin of submodules & constants
      'use strict';

      var assign = require('./lib/utils/common').assign;

      var deflate = require('./lib/deflate');

      var inflate = require('./lib/inflate');

      var constants = require('./lib/zlib/constants');

      var pako = {};
      assign(pako, deflate, inflate, constants);
      module.exports = pako;
    }, {
      "./lib/deflate": 60,
      "./lib/inflate": 61,
      "./lib/utils/common": 62,
      "./lib/zlib/constants": 65
    }],
    60: [function (require, module, exports) {
      'use strict';

      var zlib_deflate = require('./zlib/deflate');

      var utils = require('./utils/common');

      var strings = require('./utils/strings');

      var msg = require('./zlib/messages');

      var ZStream = require('./zlib/zstream');

      var toString = Object.prototype.toString;
      /* Public constants ==========================================================*/

      /* ===========================================================================*/

      var Z_NO_FLUSH = 0;
      var Z_FINISH = 4;
      var Z_OK = 0;
      var Z_STREAM_END = 1;
      var Z_SYNC_FLUSH = 2;
      var Z_DEFAULT_COMPRESSION = -1;
      var Z_DEFAULT_STRATEGY = 0;
      var Z_DEFLATED = 8;
      /* ===========================================================================*/

      /**
       * class Deflate
       *
       * Generic JS-style wrapper for zlib calls. If you don't need
       * streaming behaviour - use more simple functions: [[deflate]],
       * [[deflateRaw]] and [[gzip]].
       **/

      /* internal
      * Deflate.chunks -> Array
      *
      * Chunks of output data, if [[Deflate#onData]] not overriden.
      **/

      /**
       * Deflate.result -> Uint8Array|Array
       *
       * Compressed result, generated by default [[Deflate#onData]]
       * and [[Deflate#onEnd]] handlers. Filled after you push last chunk
       * (call [[Deflate#push]] with `Z_FINISH` / `true` param)  or if you
       * push a chunk with explicit flush (call [[Deflate#push]] with
       * `Z_SYNC_FLUSH` param).
       **/

      /**
       * Deflate.err -> Number
       *
       * Error code after deflate finished. 0 (Z_OK) on success.
       * You will not need it in real life, because deflate errors
       * are possible only on wrong options or bad `onData` / `onEnd`
       * custom handlers.
       **/

      /**
       * Deflate.msg -> String
       *
       * Error message, if [[Deflate.err]] != 0
       **/

      /**
       * new Deflate(options)
       * - options (Object): zlib deflate options.
       *
       * Creates new deflator instance with specified params. Throws exception
       * on bad params. Supported options:
       *
       * - `level`
       * - `windowBits`
       * - `memLevel`
       * - `strategy`
       * - `dictionary`
       *
       * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
       * for more information on these.
       *
       * Additional options, for internal needs:
       *
       * - `chunkSize` - size of generated data chunks (16K by default)
       * - `raw` (Boolean) - do raw deflate
       * - `gzip` (Boolean) - create gzip wrapper
       * - `to` (String) - if equal to 'string', then result will be "binary string"
       *    (each char code [0..255])
       * - `header` (Object) - custom header for gzip
       *   - `text` (Boolean) - true if compressed data believed to be text
       *   - `time` (Number) - modification time, unix timestamp
       *   - `os` (Number) - operation system code
       *   - `extra` (Array) - array of bytes with extra data (max 65536)
       *   - `name` (String) - file name (binary string)
       *   - `comment` (String) - comment (binary string)
       *   - `hcrc` (Boolean) - true if header crc should be added
       *
       * ##### Example:
       *
       * ```javascript
       * var pako = require('pako')
       *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])
       *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);
       *
       * var deflate = new pako.Deflate({ level: 3});
       *
       * deflate.push(chunk1, false);
       * deflate.push(chunk2, true);  // true -> last chunk
       *
       * if (deflate.err) { throw new Error(deflate.err); }
       *
       * console.log(deflate.result);
       * ```
       **/

      function Deflate(options) {
        if (!(this instanceof Deflate)) return new Deflate(options);
        this.options = utils.assign({
          level: Z_DEFAULT_COMPRESSION,
          method: Z_DEFLATED,
          chunkSize: 16384,
          windowBits: 15,
          memLevel: 8,
          strategy: Z_DEFAULT_STRATEGY,
          to: ''
        }, options || {});
        var opt = this.options;

        if (opt.raw && opt.windowBits > 0) {
          opt.windowBits = -opt.windowBits;
        } else if (opt.gzip && opt.windowBits > 0 && opt.windowBits < 16) {
          opt.windowBits += 16;
        }

        this.err = 0; // error code, if happens (0 = Z_OK)

        this.msg = ''; // error message

        this.ended = false; // used to avoid multiple onEnd() calls

        this.chunks = []; // chunks of compressed data

        this.strm = new ZStream();
        this.strm.avail_out = 0;
        var status = zlib_deflate.deflateInit2(this.strm, opt.level, opt.method, opt.windowBits, opt.memLevel, opt.strategy);

        if (status !== Z_OK) {
          throw new Error(msg[status]);
        }

        if (opt.header) {
          zlib_deflate.deflateSetHeader(this.strm, opt.header);
        }

        if (opt.dictionary) {
          var dict; // Convert data if needed

          if (typeof opt.dictionary === 'string') {
            // If we need to compress text, change encoding to utf8.
            dict = strings.string2buf(opt.dictionary);
          } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {
            dict = new Uint8Array(opt.dictionary);
          } else {
            dict = opt.dictionary;
          }

          status = zlib_deflate.deflateSetDictionary(this.strm, dict);

          if (status !== Z_OK) {
            throw new Error(msg[status]);
          }

          this._dict_set = true;
        }
      }
      /**
       * Deflate#push(data[, mode]) -> Boolean
       * - data (Uint8Array|Array|ArrayBuffer|String): input data. Strings will be
       *   converted to utf8 byte sequence.
       * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
       *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` meansh Z_FINISH.
       *
       * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with
       * new compressed chunks. Returns `true` on success. The last data block must have
       * mode Z_FINISH (or `true`). That will flush internal pending buffers and call
       * [[Deflate#onEnd]]. For interim explicit flushes (without ending the stream) you
       * can use mode Z_SYNC_FLUSH, keeping the compression context.
       *
       * On fail call [[Deflate#onEnd]] with error code and return false.
       *
       * We strongly recommend to use `Uint8Array` on input for best speed (output
       * array format is detected automatically). Also, don't skip last param and always
       * use the same type in your code (boolean or number). That will improve JS speed.
       *
       * For regular `Array`-s make sure all elements are [0..255].
       *
       * ##### Example
       *
       * ```javascript
       * push(chunk, false); // push one of data chunks
       * ...
       * push(chunk, true);  // push last chunk
       * ```
       **/


      Deflate.prototype.push = function (data, mode) {
        var strm = this.strm;
        var chunkSize = this.options.chunkSize;

        var status, _mode;

        if (this.ended) {
          return false;
        }

        _mode = mode === ~~mode ? mode : mode === true ? Z_FINISH : Z_NO_FLUSH; // Convert data if needed

        if (typeof data === 'string') {
          // If we need to compress text, change encoding to utf8.
          strm.input = strings.string2buf(data);
        } else if (toString.call(data) === '[object ArrayBuffer]') {
          strm.input = new Uint8Array(data);
        } else {
          strm.input = data;
        }

        strm.next_in = 0;
        strm.avail_in = strm.input.length;

        do {
          if (strm.avail_out === 0) {
            strm.output = new utils.Buf8(chunkSize);
            strm.next_out = 0;
            strm.avail_out = chunkSize;
          }

          status = zlib_deflate.deflate(strm, _mode);
          /* no bad return value */

          if (status !== Z_STREAM_END && status !== Z_OK) {
            this.onEnd(status);
            this.ended = true;
            return false;
          }

          if (strm.avail_out === 0 || strm.avail_in === 0 && (_mode === Z_FINISH || _mode === Z_SYNC_FLUSH)) {
            if (this.options.to === 'string') {
              this.onData(strings.buf2binstring(utils.shrinkBuf(strm.output, strm.next_out)));
            } else {
              this.onData(utils.shrinkBuf(strm.output, strm.next_out));
            }
          }
        } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== Z_STREAM_END); // Finalize on the last chunk.


        if (_mode === Z_FINISH) {
          status = zlib_deflate.deflateEnd(this.strm);
          this.onEnd(status);
          this.ended = true;
          return status === Z_OK;
        } // callback interim results if Z_SYNC_FLUSH.


        if (_mode === Z_SYNC_FLUSH) {
          this.onEnd(Z_OK);
          strm.avail_out = 0;
          return true;
        }

        return true;
      };
      /**
       * Deflate#onData(chunk) -> Void
       * - chunk (Uint8Array|Array|String): ouput data. Type of array depends
       *   on js engine support. When string output requested, each chunk
       *   will be string.
       *
       * By default, stores data blocks in `chunks[]` property and glue
       * those in `onEnd`. Override this handler, if you need another behaviour.
       **/


      Deflate.prototype.onData = function (chunk) {
        this.chunks.push(chunk);
      };
      /**
       * Deflate#onEnd(status) -> Void
       * - status (Number): deflate status. 0 (Z_OK) on success,
       *   other if not.
       *
       * Called once after you tell deflate that the input stream is
       * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)
       * or if an error happened. By default - join collected chunks,
       * free memory and fill `results` / `err` properties.
       **/


      Deflate.prototype.onEnd = function (status) {
        // On success - join
        if (status === Z_OK) {
          if (this.options.to === 'string') {
            this.result = this.chunks.join('');
          } else {
            this.result = utils.flattenChunks(this.chunks);
          }
        }

        this.chunks = [];
        this.err = status;
        this.msg = this.strm.msg;
      };
      /**
       * deflate(data[, options]) -> Uint8Array|Array|String
       * - data (Uint8Array|Array|String): input data to compress.
       * - options (Object): zlib deflate options.
       *
       * Compress `data` with deflate algorithm and `options`.
       *
       * Supported options are:
       *
       * - level
       * - windowBits
       * - memLevel
       * - strategy
       * - dictionary
       *
       * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
       * for more information on these.
       *
       * Sugar (options):
       *
       * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
       *   negative windowBits implicitly.
       * - `to` (String) - if equal to 'string', then result will be "binary string"
       *    (each char code [0..255])
       *
       * ##### Example:
       *
       * ```javascript
       * var pako = require('pako')
       *   , data = Uint8Array([1,2,3,4,5,6,7,8,9]);
       *
       * console.log(pako.deflate(data));
       * ```
       **/


      function deflate(input, options) {
        var deflator = new Deflate(options);
        deflator.push(input, true); // That will never happens, if you don't cheat with options :)

        if (deflator.err) {
          throw deflator.msg;
        }

        return deflator.result;
      }
      /**
       * deflateRaw(data[, options]) -> Uint8Array|Array|String
       * - data (Uint8Array|Array|String): input data to compress.
       * - options (Object): zlib deflate options.
       *
       * The same as [[deflate]], but creates raw data, without wrapper
       * (header and adler32 crc).
       **/


      function deflateRaw(input, options) {
        options = options || {};
        options.raw = true;
        return deflate(input, options);
      }
      /**
       * gzip(data[, options]) -> Uint8Array|Array|String
       * - data (Uint8Array|Array|String): input data to compress.
       * - options (Object): zlib deflate options.
       *
       * The same as [[deflate]], but create gzip wrapper instead of
       * deflate one.
       **/


      function gzip(input, options) {
        options = options || {};
        options.gzip = true;
        return deflate(input, options);
      }

      exports.Deflate = Deflate;
      exports.deflate = deflate;
      exports.deflateRaw = deflateRaw;
      exports.gzip = gzip;
    }, {
      "./utils/common": 62,
      "./utils/strings": 63,
      "./zlib/deflate": 67,
      "./zlib/messages": 72,
      "./zlib/zstream": 74
    }],
    61: [function (require, module, exports) {
      'use strict';

      var zlib_inflate = require('./zlib/inflate');

      var utils = require('./utils/common');

      var strings = require('./utils/strings');

      var c = require('./zlib/constants');

      var msg = require('./zlib/messages');

      var ZStream = require('./zlib/zstream');

      var GZheader = require('./zlib/gzheader');

      var toString = Object.prototype.toString;
      /**
       * class Inflate
       *
       * Generic JS-style wrapper for zlib calls. If you don't need
       * streaming behaviour - use more simple functions: [[inflate]]
       * and [[inflateRaw]].
       **/

      /* internal
      * inflate.chunks -> Array
      *
      * Chunks of output data, if [[Inflate#onData]] not overriden.
      **/

      /**
       * Inflate.result -> Uint8Array|Array|String
       *
       * Uncompressed result, generated by default [[Inflate#onData]]
       * and [[Inflate#onEnd]] handlers. Filled after you push last chunk
       * (call [[Inflate#push]] with `Z_FINISH` / `true` param) or if you
       * push a chunk with explicit flush (call [[Inflate#push]] with
       * `Z_SYNC_FLUSH` param).
       **/

      /**
       * Inflate.err -> Number
       *
       * Error code after inflate finished. 0 (Z_OK) on success.
       * Should be checked if broken data possible.
       **/

      /**
       * Inflate.msg -> String
       *
       * Error message, if [[Inflate.err]] != 0
       **/

      /**
       * new Inflate(options)
       * - options (Object): zlib inflate options.
       *
       * Creates new inflator instance with specified params. Throws exception
       * on bad params. Supported options:
       *
       * - `windowBits`
       * - `dictionary`
       *
       * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
       * for more information on these.
       *
       * Additional options, for internal needs:
       *
       * - `chunkSize` - size of generated data chunks (16K by default)
       * - `raw` (Boolean) - do raw inflate
       * - `to` (String) - if equal to 'string', then result will be converted
       *   from utf8 to utf16 (javascript) string. When string output requested,
       *   chunk length can differ from `chunkSize`, depending on content.
       *
       * By default, when no options set, autodetect deflate/gzip data format via
       * wrapper header.
       *
       * ##### Example:
       *
       * ```javascript
       * var pako = require('pako')
       *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])
       *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);
       *
       * var inflate = new pako.Inflate({ level: 3});
       *
       * inflate.push(chunk1, false);
       * inflate.push(chunk2, true);  // true -> last chunk
       *
       * if (inflate.err) { throw new Error(inflate.err); }
       *
       * console.log(inflate.result);
       * ```
       **/

      function Inflate(options) {
        if (!(this instanceof Inflate)) return new Inflate(options);
        this.options = utils.assign({
          chunkSize: 16384,
          windowBits: 0,
          to: ''
        }, options || {});
        var opt = this.options; // Force window size for `raw` data, if not set directly,
        // because we have no header for autodetect.

        if (opt.raw && opt.windowBits >= 0 && opt.windowBits < 16) {
          opt.windowBits = -opt.windowBits;

          if (opt.windowBits === 0) {
            opt.windowBits = -15;
          }
        } // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate


        if (opt.windowBits >= 0 && opt.windowBits < 16 && !(options && options.windowBits)) {
          opt.windowBits += 32;
        } // Gzip header has no info about windows size, we can do autodetect only
        // for deflate. So, if window size not set, force it to max when gzip possible


        if (opt.windowBits > 15 && opt.windowBits < 48) {
          // bit 3 (16) -> gzipped data
          // bit 4 (32) -> autodetect gzip/deflate
          if ((opt.windowBits & 15) === 0) {
            opt.windowBits |= 15;
          }
        }

        this.err = 0; // error code, if happens (0 = Z_OK)

        this.msg = ''; // error message

        this.ended = false; // used to avoid multiple onEnd() calls

        this.chunks = []; // chunks of compressed data

        this.strm = new ZStream();
        this.strm.avail_out = 0;
        var status = zlib_inflate.inflateInit2(this.strm, opt.windowBits);

        if (status !== c.Z_OK) {
          throw new Error(msg[status]);
        }

        this.header = new GZheader();
        zlib_inflate.inflateGetHeader(this.strm, this.header);
      }
      /**
       * Inflate#push(data[, mode]) -> Boolean
       * - data (Uint8Array|Array|ArrayBuffer|String): input data
       * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
       *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` meansh Z_FINISH.
       *
       * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with
       * new output chunks. Returns `true` on success. The last data block must have
       * mode Z_FINISH (or `true`). That will flush internal pending buffers and call
       * [[Inflate#onEnd]]. For interim explicit flushes (without ending the stream) you
       * can use mode Z_SYNC_FLUSH, keeping the decompression context.
       *
       * On fail call [[Inflate#onEnd]] with error code and return false.
       *
       * We strongly recommend to use `Uint8Array` on input for best speed (output
       * format is detected automatically). Also, don't skip last param and always
       * use the same type in your code (boolean or number). That will improve JS speed.
       *
       * For regular `Array`-s make sure all elements are [0..255].
       *
       * ##### Example
       *
       * ```javascript
       * push(chunk, false); // push one of data chunks
       * ...
       * push(chunk, true);  // push last chunk
       * ```
       **/


      Inflate.prototype.push = function (data, mode) {
        var strm = this.strm;
        var chunkSize = this.options.chunkSize;
        var dictionary = this.options.dictionary;

        var status, _mode;

        var next_out_utf8, tail, utf8str;
        var dict; // Flag to properly process Z_BUF_ERROR on testing inflate call
        // when we check that all output data was flushed.

        var allowBufError = false;

        if (this.ended) {
          return false;
        }

        _mode = mode === ~~mode ? mode : mode === true ? c.Z_FINISH : c.Z_NO_FLUSH; // Convert data if needed

        if (typeof data === 'string') {
          // Only binary strings can be decompressed on practice
          strm.input = strings.binstring2buf(data);
        } else if (toString.call(data) === '[object ArrayBuffer]') {
          strm.input = new Uint8Array(data);
        } else {
          strm.input = data;
        }

        strm.next_in = 0;
        strm.avail_in = strm.input.length;

        do {
          if (strm.avail_out === 0) {
            strm.output = new utils.Buf8(chunkSize);
            strm.next_out = 0;
            strm.avail_out = chunkSize;
          }

          status = zlib_inflate.inflate(strm, c.Z_NO_FLUSH);
          /* no bad return value */

          if (status === c.Z_NEED_DICT && dictionary) {
            // Convert data if needed
            if (typeof dictionary === 'string') {
              dict = strings.string2buf(dictionary);
            } else if (toString.call(dictionary) === '[object ArrayBuffer]') {
              dict = new Uint8Array(dictionary);
            } else {
              dict = dictionary;
            }

            status = zlib_inflate.inflateSetDictionary(this.strm, dict);
          }

          if (status === c.Z_BUF_ERROR && allowBufError === true) {
            status = c.Z_OK;
            allowBufError = false;
          }

          if (status !== c.Z_STREAM_END && status !== c.Z_OK) {
            this.onEnd(status);
            this.ended = true;
            return false;
          }

          if (strm.next_out) {
            if (strm.avail_out === 0 || status === c.Z_STREAM_END || strm.avail_in === 0 && (_mode === c.Z_FINISH || _mode === c.Z_SYNC_FLUSH)) {
              if (this.options.to === 'string') {
                next_out_utf8 = strings.utf8border(strm.output, strm.next_out);
                tail = strm.next_out - next_out_utf8;
                utf8str = strings.buf2string(strm.output, next_out_utf8); // move tail

                strm.next_out = tail;
                strm.avail_out = chunkSize - tail;

                if (tail) {
                  utils.arraySet(strm.output, strm.output, next_out_utf8, tail, 0);
                }

                this.onData(utf8str);
              } else {
                this.onData(utils.shrinkBuf(strm.output, strm.next_out));
              }
            }
          } // When no more input data, we should check that internal inflate buffers
          // are flushed. The only way to do it when avail_out = 0 - run one more
          // inflate pass. But if output data not exists, inflate return Z_BUF_ERROR.
          // Here we set flag to process this error properly.
          //
          // NOTE. Deflate does not return error in this case and does not needs such
          // logic.


          if (strm.avail_in === 0 && strm.avail_out === 0) {
            allowBufError = true;
          }
        } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== c.Z_STREAM_END);

        if (status === c.Z_STREAM_END) {
          _mode = c.Z_FINISH;
        } // Finalize on the last chunk.


        if (_mode === c.Z_FINISH) {
          status = zlib_inflate.inflateEnd(this.strm);
          this.onEnd(status);
          this.ended = true;
          return status === c.Z_OK;
        } // callback interim results if Z_SYNC_FLUSH.


        if (_mode === c.Z_SYNC_FLUSH) {
          this.onEnd(c.Z_OK);
          strm.avail_out = 0;
          return true;
        }

        return true;
      };
      /**
       * Inflate#onData(chunk) -> Void
       * - chunk (Uint8Array|Array|String): ouput data. Type of array depends
       *   on js engine support. When string output requested, each chunk
       *   will be string.
       *
       * By default, stores data blocks in `chunks[]` property and glue
       * those in `onEnd`. Override this handler, if you need another behaviour.
       **/


      Inflate.prototype.onData = function (chunk) {
        this.chunks.push(chunk);
      };
      /**
       * Inflate#onEnd(status) -> Void
       * - status (Number): inflate status. 0 (Z_OK) on success,
       *   other if not.
       *
       * Called either after you tell inflate that the input stream is
       * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)
       * or if an error happened. By default - join collected chunks,
       * free memory and fill `results` / `err` properties.
       **/


      Inflate.prototype.onEnd = function (status) {
        // On success - join
        if (status === c.Z_OK) {
          if (this.options.to === 'string') {
            // Glue & convert here, until we teach pako to send
            // utf8 alligned strings to onData
            this.result = this.chunks.join('');
          } else {
            this.result = utils.flattenChunks(this.chunks);
          }
        }

        this.chunks = [];
        this.err = status;
        this.msg = this.strm.msg;
      };
      /**
       * inflate(data[, options]) -> Uint8Array|Array|String
       * - data (Uint8Array|Array|String): input data to decompress.
       * - options (Object): zlib inflate options.
       *
       * Decompress `data` with inflate/ungzip and `options`. Autodetect
       * format via wrapper header by default. That's why we don't provide
       * separate `ungzip` method.
       *
       * Supported options are:
       *
       * - windowBits
       *
       * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
       * for more information.
       *
       * Sugar (options):
       *
       * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
       *   negative windowBits implicitly.
       * - `to` (String) - if equal to 'string', then result will be converted
       *   from utf8 to utf16 (javascript) string. When string output requested,
       *   chunk length can differ from `chunkSize`, depending on content.
       *
       *
       * ##### Example:
       *
       * ```javascript
       * var pako = require('pako')
       *   , input = pako.deflate([1,2,3,4,5,6,7,8,9])
       *   , output;
       *
       * try {
       *   output = pako.inflate(input);
       * } catch (err)
       *   console.log(err);
       * }
       * ```
       **/


      function inflate(input, options) {
        var inflator = new Inflate(options);
        inflator.push(input, true); // That will never happens, if you don't cheat with options :)

        if (inflator.err) {
          throw inflator.msg;
        }

        return inflator.result;
      }
      /**
       * inflateRaw(data[, options]) -> Uint8Array|Array|String
       * - data (Uint8Array|Array|String): input data to decompress.
       * - options (Object): zlib inflate options.
       *
       * The same as [[inflate]], but creates raw data, without wrapper
       * (header and adler32 crc).
       **/


      function inflateRaw(input, options) {
        options = options || {};
        options.raw = true;
        return inflate(input, options);
      }
      /**
       * ungzip(data[, options]) -> Uint8Array|Array|String
       * - data (Uint8Array|Array|String): input data to decompress.
       * - options (Object): zlib inflate options.
       *
       * Just shortcut to [[inflate]], because it autodetects format
       * by header.content. Done for convenience.
       **/


      exports.Inflate = Inflate;
      exports.inflate = inflate;
      exports.inflateRaw = inflateRaw;
      exports.ungzip = inflate;
    }, {
      "./utils/common": 62,
      "./utils/strings": 63,
      "./zlib/constants": 65,
      "./zlib/gzheader": 68,
      "./zlib/inflate": 70,
      "./zlib/messages": 72,
      "./zlib/zstream": 74
    }],
    62: [function (require, module, exports) {
      'use strict';

      var TYPED_OK = typeof Uint8Array !== 'undefined' && typeof Uint16Array !== 'undefined' && typeof Int32Array !== 'undefined';

      exports.assign = function (obj
      /*from1, from2, from3, ...*/
      ) {
        var sources = Array.prototype.slice.call(arguments, 1);

        while (sources.length) {
          var source = sources.shift();

          if (!source) {
            continue;
          }

          if (_typeof(source) !== 'object') {
            throw new TypeError(source + 'must be non-object');
          }

          for (var p in source) {
            if (source.hasOwnProperty(p)) {
              obj[p] = source[p];
            }
          }
        }

        return obj;
      }; // reduce buffer size, avoiding mem copy


      exports.shrinkBuf = function (buf, size) {
        if (buf.length === size) {
          return buf;
        }

        if (buf.subarray) {
          return buf.subarray(0, size);
        }

        buf.length = size;
        return buf;
      };

      var fnTyped = {
        arraySet: function arraySet(dest, src, src_offs, len, dest_offs) {
          if (src.subarray && dest.subarray) {
            dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
            return;
          } // Fallback to ordinary array


          for (var i = 0; i < len; i++) {
            dest[dest_offs + i] = src[src_offs + i];
          }
        },
        // Join array of chunks to single array.
        flattenChunks: function flattenChunks(chunks) {
          var i, l, len, pos, chunk, result; // calculate data length

          len = 0;

          for (i = 0, l = chunks.length; i < l; i++) {
            len += chunks[i].length;
          } // join chunks


          result = new Uint8Array(len);
          pos = 0;

          for (i = 0, l = chunks.length; i < l; i++) {
            chunk = chunks[i];
            result.set(chunk, pos);
            pos += chunk.length;
          }

          return result;
        }
      };
      var fnUntyped = {
        arraySet: function arraySet(dest, src, src_offs, len, dest_offs) {
          for (var i = 0; i < len; i++) {
            dest[dest_offs + i] = src[src_offs + i];
          }
        },
        // Join array of chunks to single array.
        flattenChunks: function flattenChunks(chunks) {
          return [].concat.apply([], chunks);
        }
      }; // Enable/Disable typed arrays use, for testing
      //

      exports.setTyped = function (on) {
        if (on) {
          exports.Buf8 = Uint8Array;
          exports.Buf16 = Uint16Array;
          exports.Buf32 = Int32Array;
          exports.assign(exports, fnTyped);
        } else {
          exports.Buf8 = Array;
          exports.Buf16 = Array;
          exports.Buf32 = Array;
          exports.assign(exports, fnUntyped);
        }
      };

      exports.setTyped(TYPED_OK);
    }, {}],
    63: [function (require, module, exports) {
      // String encode/decode helpers
      'use strict';

      var utils = require('./common'); // Quick check if we can use fast array to bin string conversion
      //
      // - apply(Array) can fail on Android 2.2
      // - apply(Uint8Array) can fail on iOS 5.1 Safary
      //


      var STR_APPLY_OK = true;
      var STR_APPLY_UIA_OK = true;

      try {
        String.fromCharCode.apply(null, [0]);
      } catch (__) {
        STR_APPLY_OK = false;
      }

      try {
        String.fromCharCode.apply(null, new Uint8Array(1));
      } catch (__) {
        STR_APPLY_UIA_OK = false;
      } // Table with utf8 lengths (calculated by first byte of sequence)
      // Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
      // because max possible codepoint is 0x10ffff


      var _utf8len = new utils.Buf8(256);

      for (var q = 0; q < 256; q++) {
        _utf8len[q] = q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1;
      }

      _utf8len[254] = _utf8len[254] = 1; // Invalid sequence start
      // convert string to array (typed, when possible)

      exports.string2buf = function (str) {
        var buf,
            c,
            c2,
            m_pos,
            i,
            str_len = str.length,
            buf_len = 0; // count binary size

        for (m_pos = 0; m_pos < str_len; m_pos++) {
          c = str.charCodeAt(m_pos);

          if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
            c2 = str.charCodeAt(m_pos + 1);

            if ((c2 & 0xfc00) === 0xdc00) {
              c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
              m_pos++;
            }
          }

          buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
        } // allocate buffer


        buf = new utils.Buf8(buf_len); // convert

        for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
          c = str.charCodeAt(m_pos);

          if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
            c2 = str.charCodeAt(m_pos + 1);

            if ((c2 & 0xfc00) === 0xdc00) {
              c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
              m_pos++;
            }
          }

          if (c < 0x80) {
            /* one byte */
            buf[i++] = c;
          } else if (c < 0x800) {
            /* two bytes */
            buf[i++] = 0xC0 | c >>> 6;
            buf[i++] = 0x80 | c & 0x3f;
          } else if (c < 0x10000) {
            /* three bytes */
            buf[i++] = 0xE0 | c >>> 12;
            buf[i++] = 0x80 | c >>> 6 & 0x3f;
            buf[i++] = 0x80 | c & 0x3f;
          } else {
            /* four bytes */
            buf[i++] = 0xf0 | c >>> 18;
            buf[i++] = 0x80 | c >>> 12 & 0x3f;
            buf[i++] = 0x80 | c >>> 6 & 0x3f;
            buf[i++] = 0x80 | c & 0x3f;
          }
        }

        return buf;
      }; // Helper (used in 2 places)


      function buf2binstring(buf, len) {
        // use fallback for big arrays to avoid stack overflow
        if (len < 65537) {
          if (buf.subarray && STR_APPLY_UIA_OK || !buf.subarray && STR_APPLY_OK) {
            return String.fromCharCode.apply(null, utils.shrinkBuf(buf, len));
          }
        }

        var result = '';

        for (var i = 0; i < len; i++) {
          result += String.fromCharCode(buf[i]);
        }

        return result;
      } // Convert byte array to binary string


      exports.buf2binstring = function (buf) {
        return buf2binstring(buf, buf.length);
      }; // Convert binary string (typed, when possible)


      exports.binstring2buf = function (str) {
        var buf = new utils.Buf8(str.length);

        for (var i = 0, len = buf.length; i < len; i++) {
          buf[i] = str.charCodeAt(i);
        }

        return buf;
      }; // convert array to string


      exports.buf2string = function (buf, max) {
        var i, out, c, c_len;
        var len = max || buf.length; // Reserve max possible length (2 words per char)
        // NB: by unknown reasons, Array is significantly faster for
        //     String.fromCharCode.apply than Uint16Array.

        var utf16buf = new Array(len * 2);

        for (out = 0, i = 0; i < len;) {
          c = buf[i++]; // quick process ascii

          if (c < 0x80) {
            utf16buf[out++] = c;
            continue;
          }

          c_len = _utf8len[c]; // skip 5 & 6 byte codes

          if (c_len > 4) {
            utf16buf[out++] = 0xfffd;
            i += c_len - 1;
            continue;
          } // apply mask on first byte


          c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07; // join the rest

          while (c_len > 1 && i < len) {
            c = c << 6 | buf[i++] & 0x3f;
            c_len--;
          } // terminated by end of string?


          if (c_len > 1) {
            utf16buf[out++] = 0xfffd;
            continue;
          }

          if (c < 0x10000) {
            utf16buf[out++] = c;
          } else {
            c -= 0x10000;
            utf16buf[out++] = 0xd800 | c >> 10 & 0x3ff;
            utf16buf[out++] = 0xdc00 | c & 0x3ff;
          }
        }

        return buf2binstring(utf16buf, out);
      }; // Calculate max possible position in utf8 buffer,
      // that will not break sequence. If that's not possible
      // - (very small limits) return max size as is.
      //
      // buf[] - utf8 bytes array
      // max   - length limit (mandatory);


      exports.utf8border = function (buf, max) {
        var pos;
        max = max || buf.length;

        if (max > buf.length) {
          max = buf.length;
        } // go back from last position, until start of sequence found


        pos = max - 1;

        while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) {
          pos--;
        } // Fuckup - very small and broken sequence,
        // return max, because we should return something anyway.


        if (pos < 0) {
          return max;
        } // If we came to start of buffer - that means vuffer is too small,
        // return max too.


        if (pos === 0) {
          return max;
        }

        return pos + _utf8len[buf[pos]] > max ? pos : max;
      };
    }, {
      "./common": 62
    }],
    64: [function (require, module, exports) {
      'use strict'; // Note: adler32 takes 12% for level 0 and 2% for level 6.
      // It doesn't worth to make additional optimizationa as in original.
      // Small size is preferable.

      function adler32(adler, buf, len, pos) {
        var s1 = adler & 0xffff | 0,
            s2 = adler >>> 16 & 0xffff | 0,
            n = 0;

        while (len !== 0) {
          // Set limit ~ twice less than 5552, to keep
          // s2 in 31-bits, because we force signed ints.
          // in other case %= will fail.
          n = len > 2000 ? 2000 : len;
          len -= n;

          do {
            s1 = s1 + buf[pos++] | 0;
            s2 = s2 + s1 | 0;
          } while (--n);

          s1 %= 65521;
          s2 %= 65521;
        }

        return s1 | s2 << 16 | 0;
      }

      module.exports = adler32;
    }, {}],
    65: [function (require, module, exports) {
      'use strict';

      module.exports = {
        /* Allowed flush values; see deflate() and inflate() below for details */
        Z_NO_FLUSH: 0,
        Z_PARTIAL_FLUSH: 1,
        Z_SYNC_FLUSH: 2,
        Z_FULL_FLUSH: 3,
        Z_FINISH: 4,
        Z_BLOCK: 5,
        Z_TREES: 6,

        /* Return codes for the compression/decompression functions. Negative values
        * are errors, positive values are used for special but normal events.
        */
        Z_OK: 0,
        Z_STREAM_END: 1,
        Z_NEED_DICT: 2,
        Z_ERRNO: -1,
        Z_STREAM_ERROR: -2,
        Z_DATA_ERROR: -3,
        //Z_MEM_ERROR:     -4,
        Z_BUF_ERROR: -5,
        //Z_VERSION_ERROR: -6,

        /* compression levels */
        Z_NO_COMPRESSION: 0,
        Z_BEST_SPEED: 1,
        Z_BEST_COMPRESSION: 9,
        Z_DEFAULT_COMPRESSION: -1,
        Z_FILTERED: 1,
        Z_HUFFMAN_ONLY: 2,
        Z_RLE: 3,
        Z_FIXED: 4,
        Z_DEFAULT_STRATEGY: 0,

        /* Possible values of the data_type field (though see inflate()) */
        Z_BINARY: 0,
        Z_TEXT: 1,
        //Z_ASCII:                1, // = Z_TEXT (deprecated)
        Z_UNKNOWN: 2,

        /* The deflate compression method */
        Z_DEFLATED: 8 //Z_NULL:                 null // Use -1 or null inline, depending on var type

      };
    }, {}],
    66: [function (require, module, exports) {
      'use strict'; // Note: we can't get significant speed boost here.
      // So write code to minimize size - no pregenerated tables
      // and array tools dependencies.
      // Use ordinary array, since untyped makes no boost here

      function makeTable() {
        var c,
            table = [];

        for (var n = 0; n < 256; n++) {
          c = n;

          for (var k = 0; k < 8; k++) {
            c = c & 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
          }

          table[n] = c;
        }

        return table;
      } // Create table on load. Just 255 signed longs. Not a problem.


      var crcTable = makeTable();

      function crc32(crc, buf, len, pos) {
        var t = crcTable,
            end = pos + len;
        crc ^= -1;

        for (var i = pos; i < end; i++) {
          crc = crc >>> 8 ^ t[(crc ^ buf[i]) & 0xFF];
        }

        return crc ^ -1; // >>> 0;
      }

      module.exports = crc32;
    }, {}],
    67: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils/common');

      var trees = require('./trees');

      var adler32 = require('./adler32');

      var crc32 = require('./crc32');

      var msg = require('./messages');
      /* Public constants ==========================================================*/

      /* ===========================================================================*/

      /* Allowed flush values; see deflate() and inflate() below for details */


      var Z_NO_FLUSH = 0;
      var Z_PARTIAL_FLUSH = 1; //var Z_SYNC_FLUSH    = 2;

      var Z_FULL_FLUSH = 3;
      var Z_FINISH = 4;
      var Z_BLOCK = 5; //var Z_TREES         = 6;

      /* Return codes for the compression/decompression functions. Negative values
      * are errors, positive values are used for special but normal events.
      */

      var Z_OK = 0;
      var Z_STREAM_END = 1; //var Z_NEED_DICT     = 2;
      //var Z_ERRNO         = -1;

      var Z_STREAM_ERROR = -2;
      var Z_DATA_ERROR = -3; //var Z_MEM_ERROR     = -4;

      var Z_BUF_ERROR = -5; //var Z_VERSION_ERROR = -6;

      /* compression levels */
      //var Z_NO_COMPRESSION      = 0;
      //var Z_BEST_SPEED          = 1;
      //var Z_BEST_COMPRESSION    = 9;

      var Z_DEFAULT_COMPRESSION = -1;
      var Z_FILTERED = 1;
      var Z_HUFFMAN_ONLY = 2;
      var Z_RLE = 3;
      var Z_FIXED = 4;
      var Z_DEFAULT_STRATEGY = 0;
      /* Possible values of the data_type field (though see inflate()) */
      //var Z_BINARY              = 0;
      //var Z_TEXT                = 1;
      //var Z_ASCII               = 1; // = Z_TEXT

      var Z_UNKNOWN = 2;
      /* The deflate compression method */

      var Z_DEFLATED = 8;
      /*============================================================================*/

      var MAX_MEM_LEVEL = 9;
      /* Maximum value for memLevel in deflateInit2 */

      var MAX_WBITS = 15;
      /* 32K LZ77 window */

      var DEF_MEM_LEVEL = 8;
      var LENGTH_CODES = 29;
      /* number of length codes, not counting the special END_BLOCK code */

      var LITERALS = 256;
      /* number of literal bytes 0..255 */

      var L_CODES = LITERALS + 1 + LENGTH_CODES;
      /* number of Literal or Length codes, including the END_BLOCK code */

      var D_CODES = 30;
      /* number of distance codes */

      var BL_CODES = 19;
      /* number of codes used to transfer the bit lengths */

      var HEAP_SIZE = 2 * L_CODES + 1;
      /* maximum heap size */

      var MAX_BITS = 15;
      /* All codes must not exceed MAX_BITS bits */

      var MIN_MATCH = 3;
      var MAX_MATCH = 258;
      var MIN_LOOKAHEAD = MAX_MATCH + MIN_MATCH + 1;
      var PRESET_DICT = 0x20;
      var INIT_STATE = 42;
      var EXTRA_STATE = 69;
      var NAME_STATE = 73;
      var COMMENT_STATE = 91;
      var HCRC_STATE = 103;
      var BUSY_STATE = 113;
      var FINISH_STATE = 666;
      var BS_NEED_MORE = 1;
      /* block not completed, need more input or more output */

      var BS_BLOCK_DONE = 2;
      /* block flush performed */

      var BS_FINISH_STARTED = 3;
      /* finish started, need only more output at next deflate */

      var BS_FINISH_DONE = 4;
      /* finish done, accept no more input or output */

      var OS_CODE = 0x03; // Unix :) . Don't detect, use this default.

      function err(strm, errorCode) {
        strm.msg = msg[errorCode];
        return errorCode;
      }

      function rank(f) {
        return (f << 1) - (f > 4 ? 9 : 0);
      }

      function zero(buf) {
        var len = buf.length;

        while (--len >= 0) {
          buf[len] = 0;
        }
      }
      /* =========================================================================
      * Flush as much pending output as possible. All deflate() output goes
      * through this function so some applications may wish to modify it
      * to avoid allocating a large strm->output buffer and copying into it.
      * (See also read_buf()).
      */


      function flush_pending(strm) {
        var s = strm.state; //_tr_flush_bits(s);

        var len = s.pending;

        if (len > strm.avail_out) {
          len = strm.avail_out;
        }

        if (len === 0) {
          return;
        }

        utils.arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);
        strm.next_out += len;
        s.pending_out += len;
        strm.total_out += len;
        strm.avail_out -= len;
        s.pending -= len;

        if (s.pending === 0) {
          s.pending_out = 0;
        }
      }

      function flush_block_only(s, last) {
        trees._tr_flush_block(s, s.block_start >= 0 ? s.block_start : -1, s.strstart - s.block_start, last);

        s.block_start = s.strstart;
        flush_pending(s.strm);
      }

      function put_byte(s, b) {
        s.pending_buf[s.pending++] = b;
      }
      /* =========================================================================
      * Put a short in the pending buffer. The 16-bit value is put in MSB order.
      * IN assertion: the stream state is correct and there is enough room in
      * pending_buf.
      */


      function putShortMSB(s, b) {
        //  put_byte(s, (Byte)(b >> 8));
        //  put_byte(s, (Byte)(b & 0xff));
        s.pending_buf[s.pending++] = b >>> 8 & 0xff;
        s.pending_buf[s.pending++] = b & 0xff;
      }
      /* ===========================================================================
      * Read a new buffer from the current input stream, update the adler32
      * and total number of bytes read.  All deflate() input goes through
      * this function so some applications may wish to modify it to avoid
      * allocating a large strm->input buffer and copying from it.
      * (See also flush_pending()).
      */


      function read_buf(strm, buf, start, size) {
        var len = strm.avail_in;

        if (len > size) {
          len = size;
        }

        if (len === 0) {
          return 0;
        }

        strm.avail_in -= len; // zmemcpy(buf, strm->next_in, len);

        utils.arraySet(buf, strm.input, strm.next_in, len, start);

        if (strm.state.wrap === 1) {
          strm.adler = adler32(strm.adler, buf, len, start);
        } else if (strm.state.wrap === 2) {
          strm.adler = crc32(strm.adler, buf, len, start);
        }

        strm.next_in += len;
        strm.total_in += len;
        return len;
      }
      /* ===========================================================================
      * Set match_start to the longest match starting at the given string and
      * return its length. Matches shorter or equal to prev_length are discarded,
      * in which case the result is equal to prev_length and match_start is
      * garbage.
      * IN assertions: cur_match is the head of the hash chain for the current
      *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
      * OUT assertion: the match length is not greater than s->lookahead.
      */


      function longest_match(s, cur_match) {
        var chain_length = s.max_chain_length;
        /* max hash chain length */

        var scan = s.strstart;
        /* current string */

        var match;
        /* matched string */

        var len;
        /* length of current match */

        var best_len = s.prev_length;
        /* best match length so far */

        var nice_match = s.nice_match;
        /* stop if match long enough */

        var limit = s.strstart > s.w_size - MIN_LOOKAHEAD ? s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0
        /*NIL*/
        ;
        var _win = s.window; // shortcut

        var wmask = s.w_mask;
        var prev = s.prev;
        /* Stop when cur_match becomes <= limit. To simplify the code,
        * we prevent matches with the string of window index 0.
        */

        var strend = s.strstart + MAX_MATCH;
        var scan_end1 = _win[scan + best_len - 1];
        var scan_end = _win[scan + best_len];
        /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
        * It is easy to get rid of this optimization if necessary.
        */
        // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");

        /* Do not waste too much time if we already have a good match: */

        if (s.prev_length >= s.good_match) {
          chain_length >>= 2;
        }
        /* Do not look for matches beyond the end of the input. This is necessary
        * to make deflate deterministic.
        */


        if (nice_match > s.lookahead) {
          nice_match = s.lookahead;
        } // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");


        do {
          // Assert(cur_match < s->strstart, "no future");
          match = cur_match;
          /* Skip to next match if the match length cannot increase
          * or if the match length is less than 2.  Note that the checks below
          * for insufficient lookahead only occur occasionally for performance
          * reasons.  Therefore uninitialized memory will be accessed, and
          * conditional jumps will be made that depend on those values.
          * However the length of the match is limited to the lookahead, so
          * the output of deflate is not affected by the uninitialized values.
          */

          if (_win[match + best_len] !== scan_end || _win[match + best_len - 1] !== scan_end1 || _win[match] !== _win[scan] || _win[++match] !== _win[scan + 1]) {
            continue;
          }
          /* The check at best_len-1 can be removed because it will be made
          * again later. (This heuristic is not always a win.)
          * It is not necessary to compare scan[2] and match[2] since they
          * are always equal when the other bytes match, given that
          * the hash keys are equal and that HASH_BITS >= 8.
          */


          scan += 2;
          match++; // Assert(*scan == *match, "match[2]?");

          /* We check for insufficient lookahead only every 8th comparison;
          * the 256th check will be made at strstart+258.
          */

          do {
            /*jshint noempty:false*/
          } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && scan < strend); // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");


          len = MAX_MATCH - (strend - scan);
          scan = strend - MAX_MATCH;

          if (len > best_len) {
            s.match_start = cur_match;
            best_len = len;

            if (len >= nice_match) {
              break;
            }

            scan_end1 = _win[scan + best_len - 1];
            scan_end = _win[scan + best_len];
          }
        } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);

        if (best_len <= s.lookahead) {
          return best_len;
        }

        return s.lookahead;
      }
      /* ===========================================================================
      * Fill the window when the lookahead becomes insufficient.
      * Updates strstart and lookahead.
      *
      * IN assertion: lookahead < MIN_LOOKAHEAD
      * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
      *    At least one byte has been read, or avail_in == 0; reads are
      *    performed for at least two bytes (required for the zip translate_eol
      *    option -- not supported here).
      */


      function fill_window(s) {
        var _w_size = s.w_size;
        var p, n, m, more, str; //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");

        do {
          more = s.window_size - s.lookahead - s.strstart; // JS ints have 32 bit, block below not needed

          /* Deal with !@#$% 64K limit: */
          //if (sizeof(int) <= 2) {
          //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
          //        more = wsize;
          //
          //  } else if (more == (unsigned)(-1)) {
          //        /* Very unlikely, but possible on 16 bit machine if
          //         * strstart == 0 && lookahead == 1 (input done a byte at time)
          //         */
          //        more--;
          //    }
          //}

          /* If the window is almost full and there is insufficient lookahead,
          * move the upper half to the lower one to make room in the upper half.
          */

          if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {
            utils.arraySet(s.window, s.window, _w_size, _w_size, 0);
            s.match_start -= _w_size;
            s.strstart -= _w_size;
            /* we now have strstart >= MAX_DIST */

            s.block_start -= _w_size;
            /* Slide the hash table (could be avoided with 32 bit values
            at the expense of memory usage). We slide even when level == 0
            to keep the hash table consistent if we switch back to level > 0
            later. (Using level 0 permanently is not an optimal usage of
            zlib, so we don't care about this pathological case.)
            */

            n = s.hash_size;
            p = n;

            do {
              m = s.head[--p];
              s.head[p] = m >= _w_size ? m - _w_size : 0;
            } while (--n);

            n = _w_size;
            p = n;

            do {
              m = s.prev[--p];
              s.prev[p] = m >= _w_size ? m - _w_size : 0;
              /* If n is not on any hash chain, prev[n] is garbage but
              * its value will never be used.
              */
            } while (--n);

            more += _w_size;
          }

          if (s.strm.avail_in === 0) {
            break;
          }
          /* If there was no sliding:
          *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
          *    more == window_size - lookahead - strstart
          * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
          * => more >= window_size - 2*WSIZE + 2
          * In the BIG_MEM or MMAP case (not yet supported),
          *   window_size == input_size + MIN_LOOKAHEAD  &&
          *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
          * Otherwise, window_size == 2*WSIZE so more >= 2.
          * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
          */
          //Assert(more >= 2, "more < 2");


          n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
          s.lookahead += n;
          /* Initialize the hash value now that we have some input: */

          if (s.lookahead + s.insert >= MIN_MATCH) {
            str = s.strstart - s.insert;
            s.ins_h = s.window[str];
            /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */

            s.ins_h = (s.ins_h << s.hash_shift ^ s.window[str + 1]) & s.hash_mask; //#if MIN_MATCH != 3
            //        Call update_hash() MIN_MATCH-3 more times
            //#endif

            while (s.insert) {
              /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
              s.ins_h = (s.ins_h << s.hash_shift ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;
              s.prev[str & s.w_mask] = s.head[s.ins_h];
              s.head[s.ins_h] = str;
              str++;
              s.insert--;

              if (s.lookahead + s.insert < MIN_MATCH) {
                break;
              }
            }
          }
          /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
          * but this is not important since only literal bytes will be emitted.
          */

        } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);
        /* If the WIN_INIT bytes after the end of the current data have never been
        * written, then zero those bytes in order to avoid memory check reports of
        * the use of uninitialized (or uninitialised as Julian writes) bytes by
        * the longest match routines.  Update the high water mark for the next
        * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
        * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
        */
        //  if (s.high_water < s.window_size) {
        //    var curr = s.strstart + s.lookahead;
        //    var init = 0;
        //
        //    if (s.high_water < curr) {
        //      /* Previous high water mark below current data -- zero WIN_INIT
        //       * bytes or up to end of window, whichever is less.
        //       */
        //      init = s.window_size - curr;
        //      if (init > WIN_INIT)
        //        init = WIN_INIT;
        //      zmemzero(s->window + curr, (unsigned)init);
        //      s->high_water = curr + init;
        //    }
        //    else if (s->high_water < (ulg)curr + WIN_INIT) {
        //      /* High water mark at or above current data, but below current data
        //       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
        //       * to end of window, whichever is less.
        //       */
        //      init = (ulg)curr + WIN_INIT - s->high_water;
        //      if (init > s->window_size - s->high_water)
        //        init = s->window_size - s->high_water;
        //      zmemzero(s->window + s->high_water, (unsigned)init);
        //      s->high_water += init;
        //    }
        //  }
        //
        //  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
        //    "not enough room for search");

      }
      /* ===========================================================================
      * Copy without compression as much as possible from the input stream, return
      * the current block state.
      * This function does not insert new strings in the dictionary since
      * uncompressible data is probably not useful. This function is used
      * only for the level=0 compression option.
      * NOTE: this function should be optimized to avoid extra copying from
      * window to pending_buf.
      */


      function deflate_stored(s, flush) {
        /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
        * to pending_buf_size, and each stored block has a 5 byte header:
        */
        var max_block_size = 0xffff;

        if (max_block_size > s.pending_buf_size - 5) {
          max_block_size = s.pending_buf_size - 5;
        }
        /* Copy as much as possible from input to output: */


        for (;;) {
          /* Fill the window as much as possible: */
          if (s.lookahead <= 1) {
            //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
            //  s->block_start >= (long)s->w_size, "slide too late");
            //      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
            //        s.block_start >= s.w_size)) {
            //        throw  new Error("slide too late");
            //      }
            fill_window(s);

            if (s.lookahead === 0 && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }

            if (s.lookahead === 0) {
              break;
            }
            /* flush the current block */

          } //Assert(s->block_start >= 0L, "block gone");
          //    if (s.block_start < 0) throw new Error("block gone");


          s.strstart += s.lookahead;
          s.lookahead = 0;
          /* Emit a stored block if pending_buf will be full: */

          var max_start = s.block_start + max_block_size;

          if (s.strstart === 0 || s.strstart >= max_start) {
            /* strstart == 0 is possible when wraparound on 16-bit machine */
            s.lookahead = s.strstart - max_start;
            s.strstart = max_start;
            /*** FLUSH_BLOCK(s, 0); ***/

            flush_block_only(s, false);

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/

          }
          /* Flush if we may have to slide, otherwise block_start may become
          * negative and the data will be gone:
          */


          if (s.strstart - s.block_start >= s.w_size - MIN_LOOKAHEAD) {
            /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/

          }
        }

        s.insert = 0;

        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/
          flush_block_only(s, true);

          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          }
          /***/


          return BS_FINISH_DONE;
        }

        if (s.strstart > s.block_start) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }

        return BS_NEED_MORE;
      }
      /* ===========================================================================
      * Compress as much as possible from the input stream, return the current
      * block state.
      * This function does not perform lazy evaluation of matches and inserts
      * new strings in the dictionary only for unmatched strings or for short
      * matches. It is used only for the fast compression options.
      */


      function deflate_fast(s, flush) {
        var hash_head;
        /* head of the hash chain */

        var bflush;
        /* set if current block must be flushed */

        for (;;) {
          /* Make sure that we always have enough lookahead, except
          * at the end of the input file. We need MAX_MATCH bytes
          * for the next match, plus MIN_MATCH bytes to insert the
          * string following the next match.
          */
          if (s.lookahead < MIN_LOOKAHEAD) {
            fill_window(s);

            if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }

            if (s.lookahead === 0) {
              break;
              /* flush the current block */
            }
          }
          /* Insert the string window[strstart .. strstart+2] in the
          * dictionary, and set hash_head to the head of the hash chain:
          */


          hash_head = 0
          /*NIL*/
          ;

          if (s.lookahead >= MIN_MATCH) {
            /*** INSERT_STRING(s, s.strstart, hash_head); ***/
            s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
            hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = s.strstart;
            /***/
          }
          /* Find the longest match, discarding those <= prev_length.
          * At this point we have always match_length < MIN_MATCH
          */


          if (hash_head !== 0
          /*NIL*/
          && s.strstart - hash_head <= s.w_size - MIN_LOOKAHEAD) {
            /* To simplify the code, we prevent matches with the string
            * of window index 0 (in particular we have to avoid a match
            * of the string with itself at the start of the input file).
            */
            s.match_length = longest_match(s, hash_head);
            /* longest_match() sets match_start */
          }

          if (s.match_length >= MIN_MATCH) {
            // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only

            /*** _tr_tally_dist(s, s.strstart - s.match_start,
             s.match_length - MIN_MATCH, bflush); ***/
            bflush = trees._tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH);
            s.lookahead -= s.match_length;
            /* Insert new strings in the hash table only if the match length
            * is not too large. This saves time but degrades compression.
            */

            if (s.match_length <= s.max_lazy_match
            /*max_insert_length*/
            && s.lookahead >= MIN_MATCH) {
              s.match_length--;
              /* string at strstart already in table */

              do {
                s.strstart++;
                /*** INSERT_STRING(s, s.strstart, hash_head); ***/

                s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
                hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
                s.head[s.ins_h] = s.strstart;
                /***/

                /* strstart never exceeds WSIZE-MAX_MATCH, so there are
                * always MIN_MATCH bytes ahead.
                */
              } while (--s.match_length !== 0);

              s.strstart++;
            } else {
              s.strstart += s.match_length;
              s.match_length = 0;
              s.ins_h = s.window[s.strstart];
              /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */

              s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + 1]) & s.hash_mask; //#if MIN_MATCH != 3
              //                Call UPDATE_HASH() MIN_MATCH-3 more times
              //#endif

              /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
              * matter since it will be recomputed at next deflate call.
              */
            }
          } else {
            /* No match, output a literal byte */
            //Tracevv((stderr,"%c", s.window[s.strstart]));

            /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
            bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
            s.lookahead--;
            s.strstart++;
          }

          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/

          }
        }

        s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;

        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/
          flush_block_only(s, true);

          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          }
          /***/


          return BS_FINISH_DONE;
        }

        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }

        return BS_BLOCK_DONE;
      }
      /* ===========================================================================
      * Same as above, but achieves better compression. We use a lazy
      * evaluation for matches: a match is finally adopted only if there is
      * no better match at the next window position.
      */


      function deflate_slow(s, flush) {
        var hash_head;
        /* head of hash chain */

        var bflush;
        /* set if current block must be flushed */

        var max_insert;
        /* Process the input block. */

        for (;;) {
          /* Make sure that we always have enough lookahead, except
          * at the end of the input file. We need MAX_MATCH bytes
          * for the next match, plus MIN_MATCH bytes to insert the
          * string following the next match.
          */
          if (s.lookahead < MIN_LOOKAHEAD) {
            fill_window(s);

            if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }

            if (s.lookahead === 0) {
              break;
            }
            /* flush the current block */

          }
          /* Insert the string window[strstart .. strstart+2] in the
          * dictionary, and set hash_head to the head of the hash chain:
          */


          hash_head = 0
          /*NIL*/
          ;

          if (s.lookahead >= MIN_MATCH) {
            /*** INSERT_STRING(s, s.strstart, hash_head); ***/
            s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
            hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = s.strstart;
            /***/
          }
          /* Find the longest match, discarding those <= prev_length.
          */


          s.prev_length = s.match_length;
          s.prev_match = s.match_start;
          s.match_length = MIN_MATCH - 1;

          if (hash_head !== 0
          /*NIL*/
          && s.prev_length < s.max_lazy_match && s.strstart - hash_head <= s.w_size - MIN_LOOKAHEAD
          /*MAX_DIST(s)*/
          ) {
              /* To simplify the code, we prevent matches with the string
              * of window index 0 (in particular we have to avoid a match
              * of the string with itself at the start of the input file).
              */
              s.match_length = longest_match(s, hash_head);
              /* longest_match() sets match_start */

              if (s.match_length <= 5 && (s.strategy === Z_FILTERED || s.match_length === MIN_MATCH && s.strstart - s.match_start > 4096
              /*TOO_FAR*/
              )) {
                /* If prev_match is also MIN_MATCH, match_start is garbage
                * but we will ignore the current match anyway.
                */
                s.match_length = MIN_MATCH - 1;
              }
            }
          /* If there was a match at the previous step and the current
          * match is not better, output the previous match:
          */


          if (s.prev_length >= MIN_MATCH && s.match_length <= s.prev_length) {
            max_insert = s.strstart + s.lookahead - MIN_MATCH;
            /* Do not insert strings in hash table beyond this. */
            //check_match(s, s.strstart-1, s.prev_match, s.prev_length);

            /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
             s.prev_length - MIN_MATCH, bflush);***/

            bflush = trees._tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH);
            /* Insert in hash table all strings up to the end of the match.
            * strstart-1 and strstart are already inserted. If there is not
            * enough lookahead, the last two strings are not inserted in
            * the hash table.
            */

            s.lookahead -= s.prev_length - 1;
            s.prev_length -= 2;

            do {
              if (++s.strstart <= max_insert) {
                /*** INSERT_STRING(s, s.strstart, hash_head); ***/
                s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
                hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
                s.head[s.ins_h] = s.strstart;
                /***/
              }
            } while (--s.prev_length !== 0);

            s.match_available = 0;
            s.match_length = MIN_MATCH - 1;
            s.strstart++;

            if (bflush) {
              /*** FLUSH_BLOCK(s, 0); ***/
              flush_block_only(s, false);

              if (s.strm.avail_out === 0) {
                return BS_NEED_MORE;
              }
              /***/

            }
          } else if (s.match_available) {
            /* If there was no match at the previous position, output a
            * single literal. If there was a match but the current match
            * is longer, truncate the previous match to a single literal.
            */
            //Tracevv((stderr,"%c", s->window[s->strstart-1]));

            /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
            bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

            if (bflush) {
              /*** FLUSH_BLOCK_ONLY(s, 0) ***/
              flush_block_only(s, false);
              /***/
            }

            s.strstart++;
            s.lookahead--;

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
          } else {
            /* There is no previous match to compare with, wait for
            * the next step to decide.
            */
            s.match_available = 1;
            s.strstart++;
            s.lookahead--;
          }
        } //Assert (flush != Z_NO_FLUSH, "no flush?");


        if (s.match_available) {
          //Tracevv((stderr,"%c", s->window[s->strstart-1]));

          /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
          bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);
          s.match_available = 0;
        }

        s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;

        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/
          flush_block_only(s, true);

          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          }
          /***/


          return BS_FINISH_DONE;
        }

        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }

        return BS_BLOCK_DONE;
      }
      /* ===========================================================================
      * For Z_RLE, simply look for runs of bytes, generate matches only of distance
      * one.  Do not maintain a hash table.  (It will be regenerated if this run of
      * deflate switches away from Z_RLE.)
      */


      function deflate_rle(s, flush) {
        var bflush;
        /* set if current block must be flushed */

        var prev;
        /* byte at distance one to match */

        var scan, strend;
        /* scan goes up to strend for length of run */

        var _win = s.window;

        for (;;) {
          /* Make sure that we always have enough lookahead, except
          * at the end of the input file. We need MAX_MATCH bytes
          * for the longest run, plus one for the unrolled loop.
          */
          if (s.lookahead <= MAX_MATCH) {
            fill_window(s);

            if (s.lookahead <= MAX_MATCH && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }

            if (s.lookahead === 0) {
              break;
            }
            /* flush the current block */

          }
          /* See how many times the previous byte repeats */


          s.match_length = 0;

          if (s.lookahead >= MIN_MATCH && s.strstart > 0) {
            scan = s.strstart - 1;
            prev = _win[scan];

            if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
              strend = s.strstart + MAX_MATCH;

              do {
                /*jshint noempty:false*/
              } while (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && scan < strend);

              s.match_length = MAX_MATCH - (strend - scan);

              if (s.match_length > s.lookahead) {
                s.match_length = s.lookahead;
              }
            } //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");

          }
          /* Emit match if have run of MIN_MATCH or longer, else emit literal */


          if (s.match_length >= MIN_MATCH) {
            //check_match(s, s.strstart, s.strstart - 1, s.match_length);

            /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
            bflush = trees._tr_tally(s, 1, s.match_length - MIN_MATCH);
            s.lookahead -= s.match_length;
            s.strstart += s.match_length;
            s.match_length = 0;
          } else {
            /* No match, output a literal byte */
            //Tracevv((stderr,"%c", s->window[s->strstart]));

            /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
            bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
            s.lookahead--;
            s.strstart++;
          }

          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/

          }
        }

        s.insert = 0;

        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/
          flush_block_only(s, true);

          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          }
          /***/


          return BS_FINISH_DONE;
        }

        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }

        return BS_BLOCK_DONE;
      }
      /* ===========================================================================
      * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
      * (It will be regenerated if this run of deflate switches away from Huffman.)
      */


      function deflate_huff(s, flush) {
        var bflush;
        /* set if current block must be flushed */

        for (;;) {
          /* Make sure that we have a literal to write. */
          if (s.lookahead === 0) {
            fill_window(s);

            if (s.lookahead === 0) {
              if (flush === Z_NO_FLUSH) {
                return BS_NEED_MORE;
              }

              break;
              /* flush the current block */
            }
          }
          /* Output a literal byte */


          s.match_length = 0; //Tracevv((stderr,"%c", s->window[s->strstart]));

          /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/

          bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
          s.lookahead--;
          s.strstart++;

          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);

            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/

          }
        }

        s.insert = 0;

        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/
          flush_block_only(s, true);

          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          }
          /***/


          return BS_FINISH_DONE;
        }

        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);

          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/

        }

        return BS_BLOCK_DONE;
      }
      /* Values for max_lazy_match, good_match and max_chain_length, depending on
      * the desired pack level (0..9). The values given below have been tuned to
      * exclude worst case performance for pathological files. Better values may be
      * found for specific files.
      */


      function Config(good_length, max_lazy, nice_length, max_chain, func) {
        this.good_length = good_length;
        this.max_lazy = max_lazy;
        this.nice_length = nice_length;
        this.max_chain = max_chain;
        this.func = func;
      }

      var configuration_table;
      configuration_table = [
      /*      good lazy nice chain */
      new Config(0, 0, 0, 0, deflate_stored),
      /* 0 store only */
      new Config(4, 4, 8, 4, deflate_fast),
      /* 1 max speed, no lazy matches */
      new Config(4, 5, 16, 8, deflate_fast),
      /* 2 */
      new Config(4, 6, 32, 32, deflate_fast),
      /* 3 */
      new Config(4, 4, 16, 16, deflate_slow),
      /* 4 lazy matches */
      new Config(8, 16, 32, 32, deflate_slow),
      /* 5 */
      new Config(8, 16, 128, 128, deflate_slow),
      /* 6 */
      new Config(8, 32, 128, 256, deflate_slow),
      /* 7 */
      new Config(32, 128, 258, 1024, deflate_slow),
      /* 8 */
      new Config(32, 258, 258, 4096, deflate_slow)
      /* 9 max compression */
      ];
      /* ===========================================================================
      * Initialize the "longest match" routines for a new zlib stream
      */

      function lm_init(s) {
        s.window_size = 2 * s.w_size;
        /*** CLEAR_HASH(s); ***/

        zero(s.head); // Fill with NIL (= 0);

        /* Set the default configuration parameters:
        */

        s.max_lazy_match = configuration_table[s.level].max_lazy;
        s.good_match = configuration_table[s.level].good_length;
        s.nice_match = configuration_table[s.level].nice_length;
        s.max_chain_length = configuration_table[s.level].max_chain;
        s.strstart = 0;
        s.block_start = 0;
        s.lookahead = 0;
        s.insert = 0;
        s.match_length = s.prev_length = MIN_MATCH - 1;
        s.match_available = 0;
        s.ins_h = 0;
      }

      function DeflateState() {
        this.strm = null;
        /* pointer back to this zlib stream */

        this.status = 0;
        /* as the name implies */

        this.pending_buf = null;
        /* output still pending */

        this.pending_buf_size = 0;
        /* size of pending_buf */

        this.pending_out = 0;
        /* next pending byte to output to the stream */

        this.pending = 0;
        /* nb of bytes in the pending buffer */

        this.wrap = 0;
        /* bit 0 true for zlib, bit 1 true for gzip */

        this.gzhead = null;
        /* gzip header information to write */

        this.gzindex = 0;
        /* where in extra, name, or comment */

        this.method = Z_DEFLATED;
        /* can only be DEFLATED */

        this.last_flush = -1;
        /* value of flush param for previous deflate call */

        this.w_size = 0;
        /* LZ77 window size (32K by default) */

        this.w_bits = 0;
        /* log2(w_size)  (8..16) */

        this.w_mask = 0;
        /* w_size - 1 */

        this.window = null;
        /* Sliding window. Input bytes are read into the second half of the window,
        * and move to the first half later to keep a dictionary of at least wSize
        * bytes. With this organization, matches are limited to a distance of
        * wSize-MAX_MATCH bytes, but this ensures that IO is always
        * performed with a length multiple of the block size.
        */

        this.window_size = 0;
        /* Actual size of window: 2*wSize, except when the user input buffer
        * is directly used as sliding window.
        */

        this.prev = null;
        /* Link to older string with same hash index. To limit the size of this
        * array to 64K, this link is maintained only for the last 32K strings.
        * An index in this array is thus a window index modulo 32K.
        */

        this.head = null;
        /* Heads of the hash chains or NIL. */

        this.ins_h = 0;
        /* hash index of string to be inserted */

        this.hash_size = 0;
        /* number of elements in hash table */

        this.hash_bits = 0;
        /* log2(hash_size) */

        this.hash_mask = 0;
        /* hash_size-1 */

        this.hash_shift = 0;
        /* Number of bits by which ins_h must be shifted at each input
        * step. It must be such that after MIN_MATCH steps, the oldest
        * byte no longer takes part in the hash key, that is:
        *   hash_shift * MIN_MATCH >= hash_bits
        */

        this.block_start = 0;
        /* Window position at the beginning of the current output block. Gets
        * negative when the window is moved backwards.
        */

        this.match_length = 0;
        /* length of best match */

        this.prev_match = 0;
        /* previous match */

        this.match_available = 0;
        /* set if previous match exists */

        this.strstart = 0;
        /* start of string to insert */

        this.match_start = 0;
        /* start of matching string */

        this.lookahead = 0;
        /* number of valid bytes ahead in window */

        this.prev_length = 0;
        /* Length of the best match at previous step. Matches not greater than this
        * are discarded. This is used in the lazy match evaluation.
        */

        this.max_chain_length = 0;
        /* To speed up deflation, hash chains are never searched beyond this
        * length.  A higher limit improves compression ratio but degrades the
        * speed.
        */

        this.max_lazy_match = 0;
        /* Attempt to find a better match only when the current match is strictly
        * smaller than this value. This mechanism is used only for compression
        * levels >= 4.
        */
        // That's alias to max_lazy_match, don't use directly
        //this.max_insert_length = 0;

        /* Insert new strings in the hash table only if the match length is not
        * greater than this length. This saves time but degrades compression.
        * max_insert_length is used only for compression levels <= 3.
        */

        this.level = 0;
        /* compression level (1..9) */

        this.strategy = 0;
        /* favor or force Huffman coding*/

        this.good_match = 0;
        /* Use a faster search when the previous match is longer than this */

        this.nice_match = 0;
        /* Stop searching when current match exceeds this */

        /* used by trees.c: */

        /* Didn't use ct_data typedef below to suppress compiler warning */
        // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
        // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
        // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */
        // Use flat array of DOUBLE size, with interleaved fata,
        // because JS does not support effective

        this.dyn_ltree = new utils.Buf16(HEAP_SIZE * 2);
        this.dyn_dtree = new utils.Buf16((2 * D_CODES + 1) * 2);
        this.bl_tree = new utils.Buf16((2 * BL_CODES + 1) * 2);
        zero(this.dyn_ltree);
        zero(this.dyn_dtree);
        zero(this.bl_tree);
        this.l_desc = null;
        /* desc. for literal tree */

        this.d_desc = null;
        /* desc. for distance tree */

        this.bl_desc = null;
        /* desc. for bit length tree */
        //ush bl_count[MAX_BITS+1];

        this.bl_count = new utils.Buf16(MAX_BITS + 1);
        /* number of codes at each bit length for an optimal tree */
        //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */

        this.heap = new utils.Buf16(2 * L_CODES + 1);
        /* heap used to build the Huffman trees */

        zero(this.heap);
        this.heap_len = 0;
        /* number of elements in the heap */

        this.heap_max = 0;
        /* element of largest frequency */

        /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
        * The same heap array is used to build all trees.
        */

        this.depth = new utils.Buf16(2 * L_CODES + 1); //uch depth[2*L_CODES+1];

        zero(this.depth);
        /* Depth of each subtree used as tie breaker for trees of equal frequency
        */

        this.l_buf = 0;
        /* buffer index for literals or lengths */

        this.lit_bufsize = 0;
        /* Size of match buffer for literals/lengths.  There are 4 reasons for
        * limiting lit_bufsize to 64K:
        *   - frequencies can be kept in 16 bit counters
        *   - if compression is not successful for the first block, all input
        *     data is still in the window so we can still emit a stored block even
        *     when input comes from standard input.  (This can also be done for
        *     all blocks if lit_bufsize is not greater than 32K.)
        *   - if compression is not successful for a file smaller than 64K, we can
        *     even emit a stored file instead of a stored block (saving 5 bytes).
        *     This is applicable only for zip (not gzip or zlib).
        *   - creating new Huffman trees less frequently may not provide fast
        *     adaptation to changes in the input data statistics. (Take for
        *     example a binary file with poorly compressible code followed by
        *     a highly compressible string table.) Smaller buffer sizes give
        *     fast adaptation but have of course the overhead of transmitting
        *     trees more frequently.
        *   - I can't count above 4
        */

        this.last_lit = 0;
        /* running index in l_buf */

        this.d_buf = 0;
        /* Buffer index for distances. To simplify the code, d_buf and l_buf have
        * the same number of elements. To use different lengths, an extra flag
        * array would be necessary.
        */

        this.opt_len = 0;
        /* bit length of current block with optimal trees */

        this.static_len = 0;
        /* bit length of current block with static trees */

        this.matches = 0;
        /* number of string matches in current block */

        this.insert = 0;
        /* bytes at end of window left to insert */

        this.bi_buf = 0;
        /* Output buffer. bits are inserted starting at the bottom (least
        * significant bits).
        */

        this.bi_valid = 0;
        /* Number of valid bits in bi_buf.  All bits above the last valid bit
        * are always zero.
        */
        // Used for window memory init. We safely ignore it for JS. That makes
        // sense only for pointers and memory check tools.
        //this.high_water = 0;

        /* High water mark offset in window for initialized bytes -- bytes above
        * this are set to zero in order to avoid memory check warnings when
        * longest match routines access bytes past the input.  This is then
        * updated to the new high water mark.
        */
      }

      function deflateResetKeep(strm) {
        var s;

        if (!strm || !strm.state) {
          return err(strm, Z_STREAM_ERROR);
        }

        strm.total_in = strm.total_out = 0;
        strm.data_type = Z_UNKNOWN;
        s = strm.state;
        s.pending = 0;
        s.pending_out = 0;

        if (s.wrap < 0) {
          s.wrap = -s.wrap;
          /* was made negative by deflate(..., Z_FINISH); */
        }

        s.status = s.wrap ? INIT_STATE : BUSY_STATE;
        strm.adler = s.wrap === 2 ? 0 // crc32(0, Z_NULL, 0)
        : 1; // adler32(0, Z_NULL, 0)

        s.last_flush = Z_NO_FLUSH;

        trees._tr_init(s);

        return Z_OK;
      }

      function deflateReset(strm) {
        var ret = deflateResetKeep(strm);

        if (ret === Z_OK) {
          lm_init(strm.state);
        }

        return ret;
      }

      function deflateSetHeader(strm, head) {
        if (!strm || !strm.state) {
          return Z_STREAM_ERROR;
        }

        if (strm.state.wrap !== 2) {
          return Z_STREAM_ERROR;
        }

        strm.state.gzhead = head;
        return Z_OK;
      }

      function deflateInit2(strm, level, method, windowBits, memLevel, strategy) {
        if (!strm) {
          // === Z_NULL
          return Z_STREAM_ERROR;
        }

        var wrap = 1;

        if (level === Z_DEFAULT_COMPRESSION) {
          level = 6;
        }

        if (windowBits < 0) {
          /* suppress zlib wrapper */
          wrap = 0;
          windowBits = -windowBits;
        } else if (windowBits > 15) {
          wrap = 2;
          /* write gzip wrapper instead */

          windowBits -= 16;
        }

        if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED || windowBits < 8 || windowBits > 15 || level < 0 || level > 9 || strategy < 0 || strategy > Z_FIXED) {
          return err(strm, Z_STREAM_ERROR);
        }

        if (windowBits === 8) {
          windowBits = 9;
        }
        /* until 256-byte window bug fixed */


        var s = new DeflateState();
        strm.state = s;
        s.strm = strm;
        s.wrap = wrap;
        s.gzhead = null;
        s.w_bits = windowBits;
        s.w_size = 1 << s.w_bits;
        s.w_mask = s.w_size - 1;
        s.hash_bits = memLevel + 7;
        s.hash_size = 1 << s.hash_bits;
        s.hash_mask = s.hash_size - 1;
        s.hash_shift = ~~((s.hash_bits + MIN_MATCH - 1) / MIN_MATCH);
        s.window = new utils.Buf8(s.w_size * 2);
        s.head = new utils.Buf16(s.hash_size);
        s.prev = new utils.Buf16(s.w_size); // Don't need mem init magic for JS.
        //s.high_water = 0;  /* nothing written to s->window yet */

        s.lit_bufsize = 1 << memLevel + 6;
        /* 16K elements by default */

        s.pending_buf_size = s.lit_bufsize * 4; //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
        //s->pending_buf = (uchf *) overlay;

        s.pending_buf = new utils.Buf8(s.pending_buf_size); // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
        //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);

        s.d_buf = 1 * s.lit_bufsize; //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;

        s.l_buf = (1 + 2) * s.lit_bufsize;
        s.level = level;
        s.strategy = strategy;
        s.method = method;
        return deflateReset(strm);
      }

      function deflateInit(strm, level) {
        return deflateInit2(strm, level, Z_DEFLATED, MAX_WBITS, DEF_MEM_LEVEL, Z_DEFAULT_STRATEGY);
      }

      function deflate(strm, flush) {
        var old_flush, s;
        var beg, val; // for gzip header write only

        if (!strm || !strm.state || flush > Z_BLOCK || flush < 0) {
          return strm ? err(strm, Z_STREAM_ERROR) : Z_STREAM_ERROR;
        }

        s = strm.state;

        if (!strm.output || !strm.input && strm.avail_in !== 0 || s.status === FINISH_STATE && flush !== Z_FINISH) {
          return err(strm, strm.avail_out === 0 ? Z_BUF_ERROR : Z_STREAM_ERROR);
        }

        s.strm = strm;
        /* just in case */

        old_flush = s.last_flush;
        s.last_flush = flush;
        /* Write the header */

        if (s.status === INIT_STATE) {
          if (s.wrap === 2) {
            // GZIP header
            strm.adler = 0; //crc32(0L, Z_NULL, 0);

            put_byte(s, 31);
            put_byte(s, 139);
            put_byte(s, 8);

            if (!s.gzhead) {
              // s->gzhead == Z_NULL
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, s.level === 9 ? 2 : s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ? 4 : 0);
              put_byte(s, OS_CODE);
              s.status = BUSY_STATE;
            } else {
              put_byte(s, (s.gzhead.text ? 1 : 0) + (s.gzhead.hcrc ? 2 : 0) + (!s.gzhead.extra ? 0 : 4) + (!s.gzhead.name ? 0 : 8) + (!s.gzhead.comment ? 0 : 16));
              put_byte(s, s.gzhead.time & 0xff);
              put_byte(s, s.gzhead.time >> 8 & 0xff);
              put_byte(s, s.gzhead.time >> 16 & 0xff);
              put_byte(s, s.gzhead.time >> 24 & 0xff);
              put_byte(s, s.level === 9 ? 2 : s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ? 4 : 0);
              put_byte(s, s.gzhead.os & 0xff);

              if (s.gzhead.extra && s.gzhead.extra.length) {
                put_byte(s, s.gzhead.extra.length & 0xff);
                put_byte(s, s.gzhead.extra.length >> 8 & 0xff);
              }

              if (s.gzhead.hcrc) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending, 0);
              }

              s.gzindex = 0;
              s.status = EXTRA_STATE;
            }
          } else // DEFLATE header
            {
              var header = Z_DEFLATED + (s.w_bits - 8 << 4) << 8;
              var level_flags = -1;

              if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
                level_flags = 0;
              } else if (s.level < 6) {
                level_flags = 1;
              } else if (s.level === 6) {
                level_flags = 2;
              } else {
                level_flags = 3;
              }

              header |= level_flags << 6;

              if (s.strstart !== 0) {
                header |= PRESET_DICT;
              }

              header += 31 - header % 31;
              s.status = BUSY_STATE;
              putShortMSB(s, header);
              /* Save the adler32 of the preset dictionary: */

              if (s.strstart !== 0) {
                putShortMSB(s, strm.adler >>> 16);
                putShortMSB(s, strm.adler & 0xffff);
              }

              strm.adler = 1; // adler32(0L, Z_NULL, 0);
            }
        } //#ifdef GZIP


        if (s.status === EXTRA_STATE) {
          if (s.gzhead.extra
          /* != Z_NULL*/
          ) {
              beg = s.pending;
              /* start of bytes to update crc */

              while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
                if (s.pending === s.pending_buf_size) {
                  if (s.gzhead.hcrc && s.pending > beg) {
                    strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
                  }

                  flush_pending(strm);
                  beg = s.pending;

                  if (s.pending === s.pending_buf_size) {
                    break;
                  }
                }

                put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
                s.gzindex++;
              }

              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
              }

              if (s.gzindex === s.gzhead.extra.length) {
                s.gzindex = 0;
                s.status = NAME_STATE;
              }
            } else {
            s.status = NAME_STATE;
          }
        }

        if (s.status === NAME_STATE) {
          if (s.gzhead.name
          /* != Z_NULL*/
          ) {
              beg = s.pending;
              /* start of bytes to update crc */
              //int val;

              do {
                if (s.pending === s.pending_buf_size) {
                  if (s.gzhead.hcrc && s.pending > beg) {
                    strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
                  }

                  flush_pending(strm);
                  beg = s.pending;

                  if (s.pending === s.pending_buf_size) {
                    val = 1;
                    break;
                  }
                } // JS specific: little magic to add zero terminator to end of string


                if (s.gzindex < s.gzhead.name.length) {
                  val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
                } else {
                  val = 0;
                }

                put_byte(s, val);
              } while (val !== 0);

              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
              }

              if (val === 0) {
                s.gzindex = 0;
                s.status = COMMENT_STATE;
              }
            } else {
            s.status = COMMENT_STATE;
          }
        }

        if (s.status === COMMENT_STATE) {
          if (s.gzhead.comment
          /* != Z_NULL*/
          ) {
              beg = s.pending;
              /* start of bytes to update crc */
              //int val;

              do {
                if (s.pending === s.pending_buf_size) {
                  if (s.gzhead.hcrc && s.pending > beg) {
                    strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
                  }

                  flush_pending(strm);
                  beg = s.pending;

                  if (s.pending === s.pending_buf_size) {
                    val = 1;
                    break;
                  }
                } // JS specific: little magic to add zero terminator to end of string


                if (s.gzindex < s.gzhead.comment.length) {
                  val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
                } else {
                  val = 0;
                }

                put_byte(s, val);
              } while (val !== 0);

              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
              }

              if (val === 0) {
                s.status = HCRC_STATE;
              }
            } else {
            s.status = HCRC_STATE;
          }
        }

        if (s.status === HCRC_STATE) {
          if (s.gzhead.hcrc) {
            if (s.pending + 2 > s.pending_buf_size) {
              flush_pending(strm);
            }

            if (s.pending + 2 <= s.pending_buf_size) {
              put_byte(s, strm.adler & 0xff);
              put_byte(s, strm.adler >> 8 & 0xff);
              strm.adler = 0; //crc32(0L, Z_NULL, 0);

              s.status = BUSY_STATE;
            }
          } else {
            s.status = BUSY_STATE;
          }
        } //#endif

        /* Flush as much pending output as possible */


        if (s.pending !== 0) {
          flush_pending(strm);

          if (strm.avail_out === 0) {
            /* Since avail_out is 0, deflate will be called again with
            * more output space, but possibly with both pending and
            * avail_in equal to zero. There won't be anything to do,
            * but this is not an error situation so make sure we
            * return OK instead of BUF_ERROR at next call of deflate:
            */
            s.last_flush = -1;
            return Z_OK;
          }
          /* Make sure there is something to do and avoid duplicate consecutive
          * flushes. For repeated and useless calls with Z_FINISH, we keep
          * returning Z_STREAM_END instead of Z_BUF_ERROR.
          */

        } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) && flush !== Z_FINISH) {
          return err(strm, Z_BUF_ERROR);
        }
        /* User must not provide more input after the first FINISH: */


        if (s.status === FINISH_STATE && strm.avail_in !== 0) {
          return err(strm, Z_BUF_ERROR);
        }
        /* Start a new block or continue the current one.
        */


        if (strm.avail_in !== 0 || s.lookahead !== 0 || flush !== Z_NO_FLUSH && s.status !== FINISH_STATE) {
          var bstate = s.strategy === Z_HUFFMAN_ONLY ? deflate_huff(s, flush) : s.strategy === Z_RLE ? deflate_rle(s, flush) : configuration_table[s.level].func(s, flush);

          if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
            s.status = FINISH_STATE;
          }

          if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
            if (strm.avail_out === 0) {
              s.last_flush = -1;
              /* avoid BUF_ERROR next call, see above */
            }

            return Z_OK;
            /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
            * of deflate should use the same flush parameter to make sure
            * that the flush is complete. So we don't have to output an
            * empty block here, this will be done at next call. This also
            * ensures that for a very small output buffer, we emit at most
            * one empty block.
            */
          }

          if (bstate === BS_BLOCK_DONE) {
            if (flush === Z_PARTIAL_FLUSH) {
              trees._tr_align(s);
            } else if (flush !== Z_BLOCK) {
              /* FULL_FLUSH or SYNC_FLUSH */
              trees._tr_stored_block(s, 0, 0, false);
              /* For a full flush, this empty block will be recognized
              * as a special marker by inflate_sync().
              */


              if (flush === Z_FULL_FLUSH) {
                /*** CLEAR_HASH(s); ***/

                /* forget history */
                zero(s.head); // Fill with NIL (= 0);

                if (s.lookahead === 0) {
                  s.strstart = 0;
                  s.block_start = 0;
                  s.insert = 0;
                }
              }
            }

            flush_pending(strm);

            if (strm.avail_out === 0) {
              s.last_flush = -1;
              /* avoid BUF_ERROR at next call, see above */

              return Z_OK;
            }
          }
        } //Assert(strm->avail_out > 0, "bug2");
        //if (strm.avail_out <= 0) { throw new Error("bug2");}


        if (flush !== Z_FINISH) {
          return Z_OK;
        }

        if (s.wrap <= 0) {
          return Z_STREAM_END;
        }
        /* Write the trailer */


        if (s.wrap === 2) {
          put_byte(s, strm.adler & 0xff);
          put_byte(s, strm.adler >> 8 & 0xff);
          put_byte(s, strm.adler >> 16 & 0xff);
          put_byte(s, strm.adler >> 24 & 0xff);
          put_byte(s, strm.total_in & 0xff);
          put_byte(s, strm.total_in >> 8 & 0xff);
          put_byte(s, strm.total_in >> 16 & 0xff);
          put_byte(s, strm.total_in >> 24 & 0xff);
        } else {
          putShortMSB(s, strm.adler >>> 16);
          putShortMSB(s, strm.adler & 0xffff);
        }

        flush_pending(strm);
        /* If avail_out is zero, the application will call deflate again
        * to flush the rest.
        */

        if (s.wrap > 0) {
          s.wrap = -s.wrap;
        }
        /* write the trailer only once! */


        return s.pending !== 0 ? Z_OK : Z_STREAM_END;
      }

      function deflateEnd(strm) {
        var status;

        if (!strm
        /*== Z_NULL*/
        || !strm.state
        /*== Z_NULL*/
        ) {
            return Z_STREAM_ERROR;
          }

        status = strm.state.status;

        if (status !== INIT_STATE && status !== EXTRA_STATE && status !== NAME_STATE && status !== COMMENT_STATE && status !== HCRC_STATE && status !== BUSY_STATE && status !== FINISH_STATE) {
          return err(strm, Z_STREAM_ERROR);
        }

        strm.state = null;
        return status === BUSY_STATE ? err(strm, Z_DATA_ERROR) : Z_OK;
      }
      /* =========================================================================
      * Initializes the compression dictionary from the given byte
      * sequence without producing any compressed output.
      */


      function deflateSetDictionary(strm, dictionary) {
        var dictLength = dictionary.length;
        var s;
        var str, n;
        var wrap;
        var avail;
        var next;
        var input;
        var tmpDict;

        if (!strm
        /*== Z_NULL*/
        || !strm.state
        /*== Z_NULL*/
        ) {
            return Z_STREAM_ERROR;
          }

        s = strm.state;
        wrap = s.wrap;

        if (wrap === 2 || wrap === 1 && s.status !== INIT_STATE || s.lookahead) {
          return Z_STREAM_ERROR;
        }
        /* when using zlib wrappers, compute Adler-32 for provided dictionary */


        if (wrap === 1) {
          /* adler32(strm->adler, dictionary, dictLength); */
          strm.adler = adler32(strm.adler, dictionary, dictLength, 0);
        }

        s.wrap = 0;
        /* avoid computing Adler-32 in read_buf */

        /* if dictionary would fill window, just replace the history */

        if (dictLength >= s.w_size) {
          if (wrap === 0) {
            /* already empty otherwise */

            /*** CLEAR_HASH(s); ***/
            zero(s.head); // Fill with NIL (= 0);

            s.strstart = 0;
            s.block_start = 0;
            s.insert = 0;
          }
          /* use the tail */
          // dictionary = dictionary.slice(dictLength - s.w_size);


          tmpDict = new utils.Buf8(s.w_size);
          utils.arraySet(tmpDict, dictionary, dictLength - s.w_size, s.w_size, 0);
          dictionary = tmpDict;
          dictLength = s.w_size;
        }
        /* insert dictionary into window and hash */


        avail = strm.avail_in;
        next = strm.next_in;
        input = strm.input;
        strm.avail_in = dictLength;
        strm.next_in = 0;
        strm.input = dictionary;
        fill_window(s);

        while (s.lookahead >= MIN_MATCH) {
          str = s.strstart;
          n = s.lookahead - (MIN_MATCH - 1);

          do {
            /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
            s.ins_h = (s.ins_h << s.hash_shift ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;
            s.prev[str & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = str;
            str++;
          } while (--n);

          s.strstart = str;
          s.lookahead = MIN_MATCH - 1;
          fill_window(s);
        }

        s.strstart += s.lookahead;
        s.block_start = s.strstart;
        s.insert = s.lookahead;
        s.lookahead = 0;
        s.match_length = s.prev_length = MIN_MATCH - 1;
        s.match_available = 0;
        strm.next_in = next;
        strm.input = input;
        strm.avail_in = avail;
        s.wrap = wrap;
        return Z_OK;
      }

      exports.deflateInit = deflateInit;
      exports.deflateInit2 = deflateInit2;
      exports.deflateReset = deflateReset;
      exports.deflateResetKeep = deflateResetKeep;
      exports.deflateSetHeader = deflateSetHeader;
      exports.deflate = deflate;
      exports.deflateEnd = deflateEnd;
      exports.deflateSetDictionary = deflateSetDictionary;
      exports.deflateInfo = 'pako deflate (from Nodeca project)';
      /* Not implemented
      exports.deflateBound = deflateBound;
      exports.deflateCopy = deflateCopy;
      exports.deflateParams = deflateParams;
      exports.deflatePending = deflatePending;
      exports.deflatePrime = deflatePrime;
      exports.deflateTune = deflateTune;
      */
    }, {
      "../utils/common": 62,
      "./adler32": 64,
      "./crc32": 66,
      "./messages": 72,
      "./trees": 73
    }],
    68: [function (require, module, exports) {
      'use strict';

      function GZheader() {
        /* true if compressed data believed to be text */
        this.text = 0;
        /* modification time */

        this.time = 0;
        /* extra flags (not used when writing a gzip file) */

        this.xflags = 0;
        /* operating system */

        this.os = 0;
        /* pointer to extra field or Z_NULL if none */

        this.extra = null;
        /* extra field length (valid if extra != Z_NULL) */

        this.extra_len = 0; // Actually, we don't need it in JS,
        // but leave for few code modifications
        //
        // Setup limits is not necessary because in js we should not preallocate memory
        // for inflate use constant limit in 65536 bytes
        //

        /* space at extra (only when reading header) */
        // this.extra_max  = 0;

        /* pointer to zero-terminated file name or Z_NULL */

        this.name = '';
        /* space at name (only when reading header) */
        // this.name_max   = 0;

        /* pointer to zero-terminated comment or Z_NULL */

        this.comment = '';
        /* space at comment (only when reading header) */
        // this.comm_max   = 0;

        /* true if there was or will be a header crc */

        this.hcrc = 0;
        /* true when done reading gzip header (not used when writing a gzip file) */

        this.done = false;
      }

      module.exports = GZheader;
    }, {}],
    69: [function (require, module, exports) {
      'use strict'; // See state defs from inflate.js

      var BAD = 30;
      /* got a data error -- remain here until reset */

      var TYPE = 12;
      /* i: waiting for type bits, including last-flag bit */

      /*
      Decode literal, length, and distance codes and write out the resulting
      literal and match bytes until either not enough input or output is
      available, an end-of-block is encountered, or a data error is encountered.
      When large enough input and output buffers are supplied to inflate(), for
      example, a 16K input buffer and a 64K output buffer, more than 95% of the
      inflate execution time is spent in this routine.
      Entry assumptions:
        state.mode === LEN
      strm.avail_in >= 6
      strm.avail_out >= 258
      start >= strm.avail_out
      state.bits < 8
      On return, state.mode is one of:
        LEN -- ran out of enough output space or enough available input
      TYPE -- reached end of block code, inflate() to interpret next block
      BAD -- error in block data
      Notes:
      - The maximum input bits used by a length/distance pair is 15 bits for the
      length code, 5 bits for the length extra, 15 bits for the distance code,
      and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
      Therefore if strm.avail_in >= 6, then there is enough input to avoid
      checking for available input while decoding.
      - The maximum bytes that a single length/distance pair can output is 258
      bytes, which is the maximum length that can be coded.  inflate_fast()
      requires strm.avail_out >= 258 for each loop to avoid checking for
      output space.
      */

      module.exports = function inflate_fast(strm, start) {
        var state;

        var _in;
        /* local strm.input */


        var last;
        /* have enough input while in < last */

        var _out;
        /* local strm.output */


        var beg;
        /* inflate()'s initial strm.output */

        var end;
        /* while out < end, enough space available */
        //#ifdef INFLATE_STRICT

        var dmax;
        /* maximum distance from zlib header */
        //#endif

        var wsize;
        /* window size or zero if not using window */

        var whave;
        /* valid bytes in the window */

        var wnext;
        /* window write index */
        // Use `s_window` instead `window`, avoid conflict with instrumentation tools

        var s_window;
        /* allocated sliding window, if wsize != 0 */

        var hold;
        /* local strm.hold */

        var bits;
        /* local strm.bits */

        var lcode;
        /* local strm.lencode */

        var dcode;
        /* local strm.distcode */

        var lmask;
        /* mask for first level of length codes */

        var dmask;
        /* mask for first level of distance codes */

        var here;
        /* retrieved table entry */

        var op;
        /* code bits, operation, extra bits, or */

        /*  window position, window bytes to copy */

        var len;
        /* match length, unused bytes */

        var dist;
        /* match distance */

        var from;
        /* where to copy match from */

        var from_source;
        var input, output; // JS specific, because we have no pointers

        /* copy state to local variables */

        state = strm.state; //here = state.here;

        _in = strm.next_in;
        input = strm.input;
        last = _in + (strm.avail_in - 5);
        _out = strm.next_out;
        output = strm.output;
        beg = _out - (start - strm.avail_out);
        end = _out + (strm.avail_out - 257); //#ifdef INFLATE_STRICT

        dmax = state.dmax; //#endif

        wsize = state.wsize;
        whave = state.whave;
        wnext = state.wnext;
        s_window = state.window;
        hold = state.hold;
        bits = state.bits;
        lcode = state.lencode;
        dcode = state.distcode;
        lmask = (1 << state.lenbits) - 1;
        dmask = (1 << state.distbits) - 1;
        /* decode literals and length/distances until end-of-block or not enough
        input data or output space */

        top: do {
          if (bits < 15) {
            hold += input[_in++] << bits;
            bits += 8;
            hold += input[_in++] << bits;
            bits += 8;
          }

          here = lcode[hold & lmask];

          dolen: for (;;) {
            // Goto emulation
            op = here >>> 24
            /*here.bits*/
            ;
            hold >>>= op;
            bits -= op;
            op = here >>> 16 & 0xff
            /*here.op*/
            ;

            if (op === 0) {
              /* literal */
              //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
              //        "inflate:         literal '%c'\n" :
              //        "inflate:         literal 0x%02x\n", here.val));
              output[_out++] = here & 0xffff
              /*here.val*/
              ;
            } else if (op & 16) {
              /* length base */
              len = here & 0xffff
              /*here.val*/
              ;
              op &= 15;
              /* number of extra bits */

              if (op) {
                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;
                }

                len += hold & (1 << op) - 1;
                hold >>>= op;
                bits -= op;
              } //Tracevv((stderr, "inflate:         length %u\n", len));


              if (bits < 15) {
                hold += input[_in++] << bits;
                bits += 8;
                hold += input[_in++] << bits;
                bits += 8;
              }

              here = dcode[hold & dmask];

              dodist: for (;;) {
                // goto emulation
                op = here >>> 24
                /*here.bits*/
                ;
                hold >>>= op;
                bits -= op;
                op = here >>> 16 & 0xff
                /*here.op*/
                ;

                if (op & 16) {
                  /* distance base */
                  dist = here & 0xffff
                  /*here.val*/
                  ;
                  op &= 15;
                  /* number of extra bits */

                  if (bits < op) {
                    hold += input[_in++] << bits;
                    bits += 8;

                    if (bits < op) {
                      hold += input[_in++] << bits;
                      bits += 8;
                    }
                  }

                  dist += hold & (1 << op) - 1; //#ifdef INFLATE_STRICT

                  if (dist > dmax) {
                    strm.msg = 'invalid distance too far back';
                    state.mode = BAD;
                    break top;
                  } //#endif


                  hold >>>= op;
                  bits -= op; //Tracevv((stderr, "inflate:         distance %u\n", dist));

                  op = _out - beg;
                  /* max distance in output */

                  if (dist > op) {
                    /* see if copy from window */
                    op = dist - op;
                    /* distance back in window */

                    if (op > whave) {
                      if (state.sane) {
                        strm.msg = 'invalid distance too far back';
                        state.mode = BAD;
                        break top;
                      } // (!) This block is disabled in zlib defailts,
                      // don't enable it for binary compatibility
                      //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                      //                if (len <= op - whave) {
                      //                  do {
                      //                    output[_out++] = 0;
                      //                  } while (--len);
                      //                  continue top;
                      //                }
                      //                len -= op - whave;
                      //                do {
                      //                  output[_out++] = 0;
                      //                } while (--op > whave);
                      //                if (op === 0) {
                      //                  from = _out - dist;
                      //                  do {
                      //                    output[_out++] = output[from++];
                      //                  } while (--len);
                      //                  continue top;
                      //                }
                      //#endif

                    }

                    from = 0; // window index

                    from_source = s_window;

                    if (wnext === 0) {
                      /* very common case */
                      from += wsize - op;

                      if (op < len) {
                        /* some from window */
                        len -= op;

                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);

                        from = _out - dist;
                        /* rest from output */

                        from_source = output;
                      }
                    } else if (wnext < op) {
                      /* wrap around window */
                      from += wsize + wnext - op;
                      op -= wnext;

                      if (op < len) {
                        /* some from end of window */
                        len -= op;

                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);

                        from = 0;

                        if (wnext < len) {
                          /* some from start of window */
                          op = wnext;
                          len -= op;

                          do {
                            output[_out++] = s_window[from++];
                          } while (--op);

                          from = _out - dist;
                          /* rest from output */

                          from_source = output;
                        }
                      }
                    } else {
                      /* contiguous in window */
                      from += wnext - op;

                      if (op < len) {
                        /* some from window */
                        len -= op;

                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);

                        from = _out - dist;
                        /* rest from output */

                        from_source = output;
                      }
                    }

                    while (len > 2) {
                      output[_out++] = from_source[from++];
                      output[_out++] = from_source[from++];
                      output[_out++] = from_source[from++];
                      len -= 3;
                    }

                    if (len) {
                      output[_out++] = from_source[from++];

                      if (len > 1) {
                        output[_out++] = from_source[from++];
                      }
                    }
                  } else {
                    from = _out - dist;
                    /* copy direct from output */

                    do {
                      /* minimum length is three */
                      output[_out++] = output[from++];
                      output[_out++] = output[from++];
                      output[_out++] = output[from++];
                      len -= 3;
                    } while (len > 2);

                    if (len) {
                      output[_out++] = output[from++];

                      if (len > 1) {
                        output[_out++] = output[from++];
                      }
                    }
                  }
                } else if ((op & 64) === 0) {
                  /* 2nd level distance code */
                  here = dcode[(here & 0xffff) + (
                  /*here.val*/
                  hold & (1 << op) - 1)];
                  continue dodist;
                } else {
                  strm.msg = 'invalid distance code';
                  state.mode = BAD;
                  break top;
                }

                break; // need to emulate goto via "continue"
              }
            } else if ((op & 64) === 0) {
              /* 2nd level length code */
              here = lcode[(here & 0xffff) + (
              /*here.val*/
              hold & (1 << op) - 1)];
              continue dolen;
            } else if (op & 32) {
              /* end-of-block */
              //Tracevv((stderr, "inflate:         end of block\n"));
              state.mode = TYPE;
              break top;
            } else {
              strm.msg = 'invalid literal/length code';
              state.mode = BAD;
              break top;
            }

            break; // need to emulate goto via "continue"
          }
        } while (_in < last && _out < end);
        /* return unused bytes (on entry, bits < 8, so in won't go too far back) */


        len = bits >> 3;
        _in -= len;
        bits -= len << 3;
        hold &= (1 << bits) - 1;
        /* update state and return */

        strm.next_in = _in;
        strm.next_out = _out;
        strm.avail_in = _in < last ? 5 + (last - _in) : 5 - (_in - last);
        strm.avail_out = _out < end ? 257 + (end - _out) : 257 - (_out - end);
        state.hold = hold;
        state.bits = bits;
        return;
      };
    }, {}],
    70: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils/common');

      var adler32 = require('./adler32');

      var crc32 = require('./crc32');

      var inflate_fast = require('./inffast');

      var inflate_table = require('./inftrees');

      var CODES = 0;
      var LENS = 1;
      var DISTS = 2;
      /* Public constants ==========================================================*/

      /* ===========================================================================*/

      /* Allowed flush values; see deflate() and inflate() below for details */
      //var Z_NO_FLUSH      = 0;
      //var Z_PARTIAL_FLUSH = 1;
      //var Z_SYNC_FLUSH    = 2;
      //var Z_FULL_FLUSH    = 3;

      var Z_FINISH = 4;
      var Z_BLOCK = 5;
      var Z_TREES = 6;
      /* Return codes for the compression/decompression functions. Negative values
      * are errors, positive values are used for special but normal events.
      */

      var Z_OK = 0;
      var Z_STREAM_END = 1;
      var Z_NEED_DICT = 2; //var Z_ERRNO         = -1;

      var Z_STREAM_ERROR = -2;
      var Z_DATA_ERROR = -3;
      var Z_MEM_ERROR = -4;
      var Z_BUF_ERROR = -5; //var Z_VERSION_ERROR = -6;

      /* The deflate compression method */

      var Z_DEFLATED = 8;
      /* STATES ====================================================================*/

      /* ===========================================================================*/

      var HEAD = 1;
      /* i: waiting for magic header */

      var FLAGS = 2;
      /* i: waiting for method and flags (gzip) */

      var TIME = 3;
      /* i: waiting for modification time (gzip) */

      var OS = 4;
      /* i: waiting for extra flags and operating system (gzip) */

      var EXLEN = 5;
      /* i: waiting for extra length (gzip) */

      var EXTRA = 6;
      /* i: waiting for extra bytes (gzip) */

      var NAME = 7;
      /* i: waiting for end of file name (gzip) */

      var COMMENT = 8;
      /* i: waiting for end of comment (gzip) */

      var HCRC = 9;
      /* i: waiting for header crc (gzip) */

      var DICTID = 10;
      /* i: waiting f