<?php
/**
 * Media Button
 *
 * @package    Tin Canny LearnDash Reporting
 * @subpackage Embed Articulate Storyline and Adobe Captivate
 * @author     Uncanny Owl
 * @since      1.0.0
 */

namespace TINCANNYSNC\Admin;

if ( !defined( "UO_ABS_PATH" ) ) {
	header( "Status: 403 Forbidden" );
	header( "HTTP/1.1 403 Forbidden" );
	exit();
}

class MediaButton {
	/**
	 * Constructor
	 *
	 * @access public
	 * @return void
	 * @since  1.0.0
	 */
	public function __construct() {
		add_action( 'media_buttons', array( $this, 'media_button' ),100 );
	}

	/**
	 * Print Media Button
	 *
	 * @trigger media_buttons action
	 * @access  public
	 * @return  void
	 * @since   1.0.0
	 */
	public function media_button(){
		/**
		 * We don't add any spaces before the <a> because .button makes the element inline,
		 * and that space adds two pixels between the buttons. We don't want that.
		 * Please keep the ?> and <a> without spaces in the middle
		 */
		?><a href="media-upload.php?type=snc&tab=upload&TB_iframe=true" class="button thickbox">
			<?php _e( 'Add Tin Canny Media', 'uncanny-learndash-reporting' ); ?>
		  </a> <?php
	}
}
