<?php

namespace uncanny_ceu;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class CeusColumnUoProTranscript
 * @package uncanny_ceu
 */
class CeusColumnUoProTranscript {

	/**
	 * class constructor
	 *
	 */
	function __construct() {
		add_filter( 'uo_pro_transcript', array( $this, 'uo_filter_transcript_table' ), 10, 3 );
		add_filter( 'uo_pro_transcript_cumulative_column', array(
			$this,
			'uo_pro_transcript_cumulative_column'
		), 10, 3 );
	}

	/**
	 * Add CEUs headling to UO Transcript
	 *
	 * @param $table
	 *
	 * @return mixed
	 */

	/**
	 * Add CEUs headling and row values to UO Transcript
	 *
	 * @param $transcript
	 * @param $current_user
	 * @param $learndash_transcript
	 *
	 * @return mixed
	 */
	public function uo_filter_transcript_table( $transcript, $current_user, $learndash_transcript ) {

		if ( 'on' !== $learndash_transcript::get_settings_value( 'uncanny-disable-ceus-col', $learndash_transcript ) ) {

			$credit_designation_label_plural = get_option( 'credit_designation_label_plural', __( 'CEUs', 'uncanny-ceu' ) );
			$transcript->table->heading->ceu = $credit_designation_label_plural;

			global $wpdb;

			$q           = "Select meta_key, meta_value FROM $wpdb->usermeta WHERE meta_key LIKE 'ceu_earned_%' AND user_id = $current_user->ID";
			$completions = $wpdb->get_results( $q, ARRAY_A );

			$ceu_complettions = array();
			foreach ( $completions as $completion ) {
				$course_id                      = explode( '_', $completion['meta_key'] );
				$course_id                      = $course_id[3];
				$ceu_complettions[ $course_id ] = $completion['meta_value'];
			}
			
			$credit_designation_label_plural = get_option( 'credit_designation_label_plural', __( 'CEUs', 'uncanny-ceu' ) );
			$table['headings'][]             = $credit_designation_label_plural;
			$total_ceus                      = 0;

			foreach ( $transcript->table->rows as $course_id => &$row ) {

				$ceus = __( '0', 'uncanny-ceu' );
				if ( isset( $ceu_complettions[ $course_id ] ) ) {
					$ceus = $ceu_complettions[ $course_id ];
				}
				$total_ceus += $ceus;
				$row->ceu = $ceus;
			}
			$transcript->final_ceus = $total_ceus;
		}
		
		return $transcript;
	}

	/**
	 * Add cumulative value for the CEU column
	 * @param $column
	 * @param $key
	 * @param $transcript
	 *
	 * @return array
	 */
	public function uo_pro_transcript_cumulative_column( $column, $key, $transcript ) {

		if ( 'ceu' === $key ) {
			$total_ceus = 0;
			foreach ( $transcript->table->rows as $course_id => $row ) {
				if ( isset( $row->ceu ) ) {
					$total_ceus += $row->ceu;
				}
			}

			$credit_designation_label_plural = get_option( 'credit_designation_label_plural', __( 'CEUs', 'uncanny-ceu' ) );

			$title = sprintf(
			// Translators: %1$s credit designation label plural
				__( 'Total %1$s Earned', 'uncanny-ceu' ),
				$credit_designation_label_plural
			);

			$column[ $key ]['title'] = $title;
			$column[ $key ]['value'] = $total_ceus;

			return $column;
		};

		return $column;
	}
}
