<?php

namespace uncanny_learndash_groups;

/**
 * Class GravtiyFormsCodeField
 * @package uncanny_learndash_groups
 */
class GravityFormsCodeField {
	public static $form_id;
	public static $code_details;

	/**
	 * GravityFormsCodeField constructor.
	 */
	public function __construct() {
		add_action( 'gform_loaded', array( $this, 'load' ), 5 );
		add_action( 'gform_loaded', array( $this, 'handle_gravity_forms' ), 20 );
	}

	/**
	 *
	 */
	public function load() {

		if ( ! method_exists( 'GFForms', 'include_addon_framework' ) ) {
			return;
		}

		require_once( Utilities::get_include( 'class-gf-code-field-add-on.php' ) );

		\GFAddOn::register( 'GFCodeFieldAddOn' );
	}

	public function handle_gravity_forms() {
		//Add Custom Validation for Code Redemption Field
		add_filter( 'gform_validation', array( $this, 'custom_validation' ) );
		//Registration completed
		add_action( 'user_register', array( $this, 'gf_user_register' ), 15 );
		add_action( 'gform_activate_user', array( $this, 'gf_user_register_activation' ), 15 , 3);
	}

	/**
	 * @param $validation_result
	 *
	 * @return mixed
	 */
	public function custom_validation( $validation_result ) {
		$form              = $validation_result['form'];
		$code_redeem_field = false;
		$field_id          = 0;

		if ( $form['fields'] ) {
			foreach ( $form['fields'] as $field ) {
				if ( 'uncanny_code' === $field->type ) {
					$field_id          = $field->id;
					$code_redeem_field = true;
					$code_redeem       = rgpost( 'input_' . $field->id );
					break;
				}
			}
		}
		if ( $code_redeem_field && ! empty( $code_redeem ) ) {
			$code_details = SharedFunctions::is_key_available( $code_redeem );
			if ( is_array( $code_details ) ) {
				if ( 'failed' === $code_details['result'] ) {
					$validation_result['is_valid'] = false;
					if ( 'invalid' === $code_details['error'] ) {
						//$this->ulgm_registration_errors()->add( 'code_invalid', Config::$invalid_code );
						foreach ( $form['fields'] as &$field ) {
							//NOTE: replace 1 with the field you would like to validate
							if ( $field_id === $field->id ) {
								$field->failed_validation  = true;
								$field->validation_message = Config::$invalid_code;
								break;
							}
						}
					} elseif ( 'existing' === $code_details['error'] ) {
						//$this->ulgm_registration_errors()->add( 'code_redeemed', Config::$already_redeemed );
						foreach ( $form['fields'] as &$field ) {
							//NOTE: replace 1 with the field you would like to validate
							if ( $field_id === $field->id ) {
								$field->failed_validation  = true;
								$field->validation_message = Config::$already_redeemed;
								break;
							}
						}
					}
				} elseif ( 'success' === $code_details['result'] ) {
					self::$code_details = $code_details;
				}
			} else {
				self::$code_details = null;
				//$this->ulgm_registration_errors()->add( 'code_invalid', Config::$invalid_code );
				foreach ( $form['fields'] as &$field ) {

					//NOTE: replace 1 with the field you would like to validate
					if ( $field_id === $field->id ) {
						$field->failed_validation  = true;
						$field->validation_message = Config::$invalid_code;
						break;
					}
				}
			}
		}
		//}
		$validation_result['form'] = $form;

		return $validation_result;

	}


	/**
	 * @param $user_id
	 */
	public function gf_user_register( $user_id ) {
		if ( ! class_exists( 'Database' ) ) {
			include_once Utilities::get_include( 'database.php' );
		}
		if ( is_array( self::$code_details ) && 'success' === self::$code_details['result'] ) {
			$code_registration = self::$code_details['key'];
			update_user_meta( $user_id, '_ulgm_code_used', $code_registration );
			$result = SharedFunctions::set_user_to_code( $user_id, $code_registration, 'Not Started' );
			if ( $result ) {
				SharedFunctions::set_user_to_group( $user_id, self::$code_details['ld_group_id'] );
			}
		}
	}
	
	/**
	 * @param $user_id
	 * @param $user_data
	 * @param $entry_meta
	 */
	public static function gf_user_register_activation( $user_id, $user_data, $entry_meta ) {
		$entry    = \GFAPI::get_entry( $entry_meta['entry_id'] );
		$form     = \GFAPI::get_form( $entry['form_id'] );
		$field_id = 0;
		if ( $form['fields'] ) {
			foreach ( $form['fields'] as $field ) {
				if ( 'uncanny_code' === $field->type ) {
					$field_id = $field->id;
					break;
				}
			}
		}
		$code_redemption = gform_get_meta( $entry_meta['entry_id'], $field_id );
		
		if ( false !== $code_redemption ) {
			$code_details = SharedFunctions::is_key_available( $code_redemption );
			if ( 'success' === $code_details['result'] ) {
				update_user_meta( $user_id, '_ulgm_code_used', $code_redemption );
				$result = SharedFunctions::set_user_to_code( $user_id, $code_redemption, 'Not Started' );
				if ( $result ) {
					SharedFunctions::set_user_to_group( $user_id, $code_details['ld_group_id'] );
				}
			}
		}
	}
}