<?php

namespace uncanny_automator;

/**
 * Class LD_MARKLESSONDONE
 * @package uncanny_automator
 */
class LD_MARKLESSONDONE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';

	private $action_code;
	private $action_meta;
	private $quiz_list;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'MARKLESSONDONE';
		$this->action_meta = 'LDLESSON';
		$this->define_action();

		add_action( 'wp_ajax_select_lesson_from_course_MARKLESSONDONE', array(
			$this,
			'select_lesson_from_course_func',
		) );

	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$args = [
			'post_type'      => 'sfwd-courses',
			'posts_per_page' => 999,
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		];

		$options = $uncanny_automator->options->wp_query( $args, false, 'course' );

		$action = array(
			'author'             => $uncanny_automator->get_author_name(),
			'support_link'       => $uncanny_automator->get_author_support_link(),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Lessons*/
			'sentence'           => sprintf( __( 'Mark {{a lesson:%1$s}} complete', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Mark {{a lesson}} complete', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => array( $this, 'mark_completes_a_lesson' ),
			'options_group'      => [
				$this->action_meta => [
					$uncanny_automator->options->select_field_ajax(
						'LDCOURSE',
						__( 'Select a Course', 'uncanny-automator' ),
						$options,
						'',
						'',
						false,
						true,
						[
							'target_field' => $this->action_meta,
							'endpoint'     => 'select_lesson_from_course_MARKLESSONDONE',
						]
					),
					$uncanny_automator->options->select_field( $this->action_meta, __( 'Select a Lesson', 'uncanny-automator' ), [ '' => __( 'Select a Course Above', 'uncanny-automator' ) ] ),
				],
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function mark_completes_a_lesson( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		$course_id = $action_data['meta']['LDCOURSE'];
		$lesson_id = $action_data['meta'][ $this->action_meta ];
		$this->mark_steps_done( $user_id, $lesson_id, $course_id );

		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}

	/**
	 * @param $user_id
	 * @param $lesson_id
	 */
	public function mark_steps_done( $user_id, $lesson_id, $course_id ) {

		$topic_list = learndash_get_topic_list( $lesson_id, $course_id );

		if ( $topic_list ) {
			foreach ( $topic_list as $topic ) {

				$topic_quiz_list = learndash_get_lesson_quiz_list( $topic->ID, $user_id, $course_id );
				if ( $topic_quiz_list ) {
					foreach ( $topic_quiz_list as $ql ) {
						$this->quiz_list[ $ql['post']->ID ] = 0;
					}
				}

				$this->mark_quiz_complete( $user_id, $course_id );

				learndash_process_mark_complete( $user_id, $topic->ID, false, $course_id );
			}
		}

		$lesson_quiz_list = learndash_get_lesson_quiz_list( $lesson_id, $user_id, $course_id );

		if ( $lesson_quiz_list ) {
			foreach ( $lesson_quiz_list as $ql ) {
				$this->quiz_list[ $ql['post']->ID ] = 0;
			}
		}

		$this->mark_quiz_complete( $user_id, $course_id );

		//Mark complete a lesson
		learndash_process_mark_complete( $user_id, $lesson_id, false, $course_id );
	}

	/**
	 * @param      $user_id
	 * @param null $course_id
	 */
	public function mark_quiz_complete( $user_id, $course_id = null ) {

		$quizz_progress = [];

		if ( ! empty( $this->quiz_list ) ) {

			$usermeta       = get_user_meta( $user_id, '_sfwd-quizzes', true );
			$quizz_progress = empty( $usermeta ) ? array() : $usermeta;

			foreach ( $this->quiz_list as $quiz_id => $quiz ) {

				$quiz_meta = get_post_meta( $quiz_id, '_sfwd-quiz', true );

				$quizdata = array(
					'quiz'             => $quiz_id,
					'score'            => 0,
					'count'            => 0,
					'pass'             => true,
					'rank'             => '-',
					'time'             => time(),
					'pro_quizid'       => $quiz_meta['sfwd-quiz_quiz_pro'],
					'course'           => $course_id,
					'points'           => 0,
					'total_points'     => 0,
					'percentage'       => 0,
					'timespent'        => 0,
					'has_graded'       => false,
					'statistic_ref_id' => 0,
					'm_edit_by'        => 9999999,  // Manual Edit By ID.
					'm_edit_time'      => time(),          // Manual Edit timestamp.
				);

				$quizz_progress[] = $quizdata;

				if ( $quizdata['pass'] == true ) {
					$quizdata_pass = true;
				} else {
					$quizdata_pass = false;
				}

				// Then we add the quiz entry to the activity database.
				learndash_update_user_activity(
					array(
						'course_id'          => $course_id,
						'user_id'            => $user_id,
						'post_id'            => $quiz_id,
						'activity_type'      => 'quiz',
						'activity_action'    => 'insert',
						'activity_status'    => $quizdata_pass,
						'activity_started'   => $quizdata['time'],
						'activity_completed' => $quizdata['time'],
						'activity_meta'      => $quizdata,
					)
				);
			}
		}

		if ( ! empty( $quizz_progress ) ) {
			update_user_meta( $user_id, '_sfwd-quizzes', $quizz_progress );
		}

		$this->quiz_list = [];
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_lesson_from_course_func() {

		global $uncanny_automator;

		// Nonce and post object validation
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {

			$args = [
				'post_type'      => 'sfwd-lessons',
				'meta_query'     => array(
					'relation' => 'OR',
					array(
						'key'     => 'course_id',
						'value'   => absint( $_POST['value'] ),
						'compare' => '=',
					),
					array(
						'key'     => 'ld_course_' . absint( $_POST['value'] ),
						'value'   => absint( $_POST['value'] ),
						'compare' => '=',
					),
				),
				'posts_per_page' => 999,
				'orderby'        => 'title',
				'order'          => 'ASC',
				'post_status'    => 'publish',
			];
		}

		$options = $uncanny_automator->options->wp_query( $args, false, 'lesson' );

		foreach ( $options as $lesson_id => $lesson_name ) {
			$fields[] = array(
				'value' => $lesson_id,
				'text'  => $lesson_name,
			);
		}

		echo wp_json_encode( $fields );
		die();
	}

}
