<?php

namespace uncanny_automator;

/**
 * Class GEN_ADDROLE
 * @package uncanny_automator
 */
class WP_ADDROLE {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $action_code;
	private $action_meta;

	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'ADDROLE';
		$this->action_meta = 'WPROLE';
		$this->define_action();
	}

	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {

		global $uncanny_automator;

		$action = array(
			'author'             => $uncanny_automator->get_author_name( $this->action_code ),
			'support_link'       => $uncanny_automator->get_author_support_link( $this->action_code ),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Roles*/
			'sentence'           => sprintf( __( 'Add {{another role:%1$s}} role to user', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Add {{role}} to user', 'uncanny-automator' ),
			'priority'           => 11,
			'accepted_args'      => 3,
			'execution_function' => array( $this, 'add_role' ),
			'options'            => [
				$uncanny_automator->options->wp_user_roles(),
			],
		);

		$uncanny_automator->register_action( $action );
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function add_role( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		$role = $action_data['meta'][ $this->action_meta ];

		$user_obj   = new \WP_User( (int) $user_id );
		$user_roles = $user_obj->roles;
		if ( ! in_array( 'administrator', $user_roles ) ) {
			$user_obj->add_role( $role );
			$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
		}
	}
}
