<?php

namespace uncanny_automator;

/**
 * Class WP_LOGIN
 * @package uncanny_automator
 */
class WP_LOGIN {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LOGIN';
		$this->trigger_meta = 'WPLOGIN';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Number of times*/
			'sentence'            => sprintf( __( 'User logs in {{a number of:%1$s}} times', 'uncanny-automator' ), 'NUMTIMES' ),
			'select_option_name'  => __( 'User {{logs in}} to site', 'uncanny-automator' ),
			'action'              => 'wp_login',
			'priority'            => 99,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'wp_login' ),
			// very last call in WP, we need to make sure they viewed the page and didn't skip before is was fully viewable
			'options'             => [
				$uncanny_automator->options->number_of_times(),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_login
	 * @param $user
	 */
	public function wp_login( $user_login, $user ) {

		global $uncanny_automator;

		$user_id = $user->ID;

		$args = [
			'code'           => $this->trigger_code,
			'meta'           => $this->trigger_meta,
			'user_id'        => $user_id,
			'ignore_post_id' => true,
			'is_signed_in'   => true,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}
}
