<?php
/**
 * @package GrassBlade 
 * @version 0.1.0
 */
/*
Plugin Name: GrassBlade - xAPI Companion (Free Version)
Plugin URI: http://www.nextsoftwaresolutions.com
Description: GrassBlade - xAPI Companion is a support tool for Experience API (xAPI) or Tin Can API. You can upload and launch Tin Can content published using Articulate, iSpring, DominKnow, Lectora and more. Can send tracking statements to the LRS on Page View. And, show statements in its Statement Viewer. Free Version has limited features.
Author: Next Software Solutions Pvt Ltd
Version: 0.1.0 Free
Author URI: https://www.nextsoftwaresolutions.com
*/
define("GRASSBLADE_ADDON_DIR", dirname(__FILE__)."/addons");
include(GRASSBLADE_ADDON_DIR."/grassblade_addons.php");
$GrassBladeAddons = new GrassBladeAddons();
define('GRASSBLADE_ICON15', get_bloginfo('wpurl')."/wp-content/plugins/grassblade/img/button-15.png");

function grassblade($attr) {
	
	 $shortcode_atts = shortcode_atts ( array(
			'version' => '0.95',
			'extra' => '',
			'target' => 'iframe',
			'width' => '940px',
			'height' => '640px',
			'endpoint' => '',
			'auth' => '',
			'user' => '',
			'pass' => '',
			'src' => '',
			'text' => 'Launch',
			'guest' => false,
			'activity_id' => '',
			), $attr);

	extract($shortcode_atts);
		
    	// Read in existing option value from database
	if(empty($endpoint))
    	$endpoint = get_option( 'grassblade_tincan_endpoint' );

	if(empty($user))
    	$user = get_option('grassblade_tincan_user');

	if(empty($pass))
    	$pass = get_option('grassblade_tincan_password');
	
	if($guest === false)
	$grassblade_tincan_track_guest = get_option('grassblade_tincan_track_guest');
	else
	$grassblade_tincan_track_guest = $guest;
	
	$actor = grassblade_getactor($grassblade_tincan_track_guest, $version);
	
	if(empty($actor))
	return "Please login.";
	
	$actor = "actor=".rawurlencode(json_encode($actor));
	
	
	if(!empty($auth))
	$auth = "auth=".rawurlencode($auth);
	else
	$auth = "auth=".rawurlencode("Basic ".base64_encode($user.":".$pass));

	$endpoint = 'endpoint='.rawurlencode($endpoint);
	
	$activity = 'activity_id='.$activity_id;
	if($version == "none")
	{
		//Don't change SRC. Supporting Non xAPI Content.
	}
	else if(strpos($src,"?") !== false)
		$src = $src."&".$actor."&".$auth."&".$endpoint."&".$activity;
	else
		$src = $src."?".$actor."&".$auth."&".$endpoint."&".$activity;

	if($target == 'iframe')
	return "<iframe frameBorder='0' src='$src' width='$width' height='$height'></iframe>";
	else if($target == '_blank')
	return "<a href='$src' target='_blank'>$text</a>";
	else //if($target == 'url')
	return $src;
}

function grassblade_getdomain()
{
	$domain = $_SERVER["HTTP_HOST"];
	
	if(empty($domain))
	$domain = $_SERVER["SERVER_NAME"];
	
	if(filter_var($domain, FILTER_VALIDATE_IP))
	return $domain.".com";
	else
	return $domain;
}
function grassblade_getactor($guest = false, $version = "0.95")
{
	$current_user = wp_get_current_user();

	if(empty($current_user->ID))
	{
		if(empty($guest))
			return false;
		else
		{
			$guest_mailto = "mailto:guest-".$_SERVER['REMOTE_ADDR'].'@'.grassblade_getdomain();
			$guest_name = "Guest ".$_SERVER['REMOTE_ADDR'];
			if($version == "0.90")
				$actor = array('mbox' => array($guest_mailto), 'name' => array($guest_name), "objectType" =>  "Agent");
			else
				$actor = array('mbox' => $guest_mailto, 'name' => $guest_name, "objectType" =>  "Agent");			
				
			return $actor;
		}
	}
	
	if(!empty($current_user->display_name))
	$name = $current_user->display_name;
	else
	if(!empty($current_user->user_firstname) || !empty($current_user->user_firstname))
	$name = $current_user->user_firstname." ".$current_user->user_lastname;
	else
	$name = $current_user->user_login;
	
	$mbox = "mailto:".$current_user->user_email;
	if($version == "0.90")
	$actor = array('mbox' => array($mbox), 'name' => array($name), "objectType" =>  "Agent");
	else
	$actor = array('mbox' => $mbox, 'name' => $name, "objectType" =>  "Agent");

	return $actor;
}
add_shortcode("grassblade", "grassblade");

add_action('admin_menu', 'grassblade_menu', 0);
function grassblade_menu() {
    add_menu_page("GrassBlade", "GrassBlade", "manage_options", "grassblade-lrs-settings", null, GRASSBLADE_ICON15, null);
    add_submenu_page("grassblade-lrs-settings", "GrassBlade Settings", "GrassBlade Settings",'manage_options','grassblade-lrs-settings', 'grassblade_menu_page');
	
}
function grassblade_menu_page() {
    //must check that the user has the required capability 
    if (!current_user_can('manage_options'))
    {
      wp_die( __('You do not have sufficient permissions to access this page.') );
    }

    // Read in existing option value from database
    $grassblade_tincan_endpoint = get_option( 'grassblade_tincan_endpoint' );
    if(empty($grassblade_tincan_endpoint)) 
    $grassblade_tincan_endpoint = "";
    $grassblade_tincan_user = get_option('grassblade_tincan_user');
    $grassblade_tincan_password = get_option('grassblade_tincan_password');
    $grassblade_tincan_version = get_option('grassblade_tincan_version');
    $grassblade_tincan_track_guest = get_option('grassblade_tincan_track_guest');
    $grassblade_tincan_width = get_option('grassblade_tincan_width');
    $grassblade_tincan_height = get_option('grassblade_tincan_height');

	$grassblade_tincan_width = empty($grassblade_tincan_width)? "940px":intVal($grassblade_tincan_width)."px";
	$grassblade_tincan_height = empty($grassblade_tincan_height)? "640px":intVal($grassblade_tincan_height)."px";
	
    // See if the user has posted us some information
    // If they did, this hidden field will be set to 'Y'
    if( isset($_POST[ "update_GrassBladeSettings" ]) ) {
        // Read their posted value
        $grassblade_tincan_endpoint = $_POST['grassblade_tincan_endpoint'];
        $grassblade_tincan_user = $_POST['grassblade_tincan_user'];
        $grassblade_tincan_password = $_POST['grassblade_tincan_password'];
        $grassblade_tincan_version = $_POST['grassblade_tincan_version'];
		$grassblade_tincan_track_guest = (isset($_POST['grassblade_tincan_track_guest']) && !empty($_POST['grassblade_tincan_track_guest']))? 1:0;
        $grassblade_tincan_width = intVal($_POST['grassblade_tincan_width'])."px";
        $grassblade_tincan_height = intVal($_POST['grassblade_tincan_height'])."px";

        // Save the posted value in the database
        update_option( 'grassblade_tincan_endpoint', $grassblade_tincan_endpoint);
        update_option( 'grassblade_tincan_user', $grassblade_tincan_user);
        update_option( 'grassblade_tincan_password', $grassblade_tincan_password);
        update_option( 'grassblade_tincan_track_guest', $grassblade_tincan_track_guest);
        update_option( 'grassblade_tincan_width', $grassblade_tincan_width);
        update_option( 'grassblade_tincan_height', $grassblade_tincan_height);
        update_option( 'grassblade_tincan_version', $grassblade_tincan_version);

        // Put an settings updated message on the screen

?>
<div class="updated"><p><strong><?php _e('settings saved.', 'GrassBladeSettings' ); ?></strong></p></div>
<?php

    }
?>
<div class=wrap>
<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
<h2><img style="top: 6px; position: relative;" src="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/grassblade/img/icon_30x30.png"; ?>"/>
GrassBlade Settings</h2>
<h3>Endpoint URL <small class="description"> (provided by your LRS, check FAQ below for details)</small> :</h3>
<input name="grassblade_tincan_endpoint" style="min-width:30%" value="<?php echo   _e(apply_filters('format_to_edit',$grassblade_tincan_endpoint), 'GrassBladeSettings') ?>" />

<h3>User <small class="description"> (provided by your LRS, check FAQ below for details)</small> :</h3>
<input name="grassblade_tincan_user" style="min-width:30%" value="<?php echo   _e(apply_filters('format_to_edit',$grassblade_tincan_user), 'GrassBladeSettings') ?>" />
<h3>Password <small class="description"> (provided by your LRS, check FAQ below for details)</small> :</h3>
<input name="grassblade_tincan_password" style="min-width:30%" value="<?php echo   _e(apply_filters('format_to_edit',$grassblade_tincan_password), 'GrassBladeSettings') ?>" />
<h3>Version <small class="description"> (Default xAPI (Tin Can) version of content)</small> :</h3>
<select name="grassblade_tincan_version" style="min-width:30%">
	<option value="0.95" <?php if($grassblade_tincan_version == "0.95") echo "SELECTED"; ?>>0.95</option>
	<option value="0.90" <?php if($grassblade_tincan_version == "0.90") echo "SELECTED"; ?>>0.90</option>
</select>
<h3>Track Guest Users <small class="description"> (Not Logged In users will be able to access content, and their page views will also be tracked)</small> :</h3>
<input name="grassblade_tincan_track_guest" style="min-width:5px" type="checkbox" <?php if($grassblade_tincan_track_guest) echo "CHECKED";?> /> Check  to track guest users (Tracked as <b>{"name":"Guest XXX.XXX.XXX.XXX", "actor":{"mbox": "mailto:guest-XXX.XXX.XXX.XXX@<?php echo grassblade_getdomain(); ?>"}</b>) where <i>XXX.XXX.XXX.XXX</i> is users IP.

<h3>Width<small class="description"> (Default width of iframe in which content is launched)</small> :</h3>
<input name="grassblade_tincan_width" style="min-width:30%" value="<?php echo   _e(apply_filters('format_to_edit',$grassblade_tincan_width), 'GrassBladeSettings') ?>" />
<h3>Height<small class="description"> (Default height of iframe in which content is launched)</small> :</h3>
<input name="grassblade_tincan_height" style="min-width:30%" value="<?php echo   _e(apply_filters('format_to_edit',$grassblade_tincan_height), 'GrassBladeSettings') ?>" />
<div class="submit">
<input type="submit" name="update_GrassBladeSettings" value="<?php _e('Update Settings', 'GrassBladeSettings') ?>" /></div>
</form>
Don't have an LRS? <a href='http://www.nextsoftwaresolutions.com/learning-record-store' target="_blank">Find an LRS</a>
<br><br>
<?php include(dirname(__FILE__)."/help.php"); ?>
</div>
<?php
}


// Add settings link on plugin page
function grassblade_plugin_settings_link($links) { 
  $settings_link = '<a href="options-general.php?page=grassblade-lrs-settings">Settings</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}
 
$plugin = plugin_basename(__FILE__); 
add_filter("plugin_action_links_$plugin", 'grassblade_plugin_settings_link' );


/*** WYSIWYG Button ***/
add_action('init', 'add_grassblade_button');  
function add_grassblade_button() {
   if ( current_user_can('edit_posts') &&  current_user_can('edit_pages') )  
   {  
     add_filter('mce_external_plugins', 'add_grassblade_plugin');  
     add_filter('mce_buttons', 'register_grassblade_button');  
   } 
}

function register_grassblade_button($buttons) {
   array_push($buttons, "grassblade");  
   return $buttons;
}

function add_grassblade_plugin($plugin_array) {  
   $plugin_array['grassblade'] = get_bloginfo('wpurl').'/wp-content/plugins/grassblade/js/grassblade_button.min.js';  
   return $plugin_array;  
}  
/*** WYSIWYG Button ***/
$GrassBladeAddons->IncludeFunctionFiles();
