<?php
/**
 * The Settings Tab for LearnDash Slack
 * This applies to only LearnDash installs above or equal to version 2.4
 *
 * @since		1.1.0
 *
 * @package LearnDash_Slack
 * @subpackage LearnDash_Slack/core/admin/settings-tabs
 */

defined( 'ABSPATH' ) || die();

final class LearnDash_Slack_Settings_Tabs {

	/**
	 * LearnDash_Slack_Settings_Tabs constructor.
	 * 
	 * @since		1.0.0
	 */
	function __construct() {
		
		// Add our Settings Tab to a "Tab Group" within a Settings Page
		add_action( 'learndash_admin_tabs_set', array( $this, 'admin_tabs' ) );
			
		// Fakes the Current Menu Item
		add_filter( 'parent_file', array( $this, 'fix_parent_file' ) );

		// Fakes the current Submenu Item
		add_filter( 'submenu_file', array( $this, 'fix_submenu_file' ), 10, 2 );
		
	}
	
	/**
	 * Adds the Admin Tab using LD v2.4's new method
	 * 
	 * @param		string $admin_menu_section Admin Menu Section
	 *                                               
	 * @access		public
	 * @since		1.1.0
	 * @return		void
	 */
	public function admin_tabs( $admin_menu_section = '' ) {

		if ( $admin_menu_section == 'admin.php?page=learndash_lms_settings' ) {
			
			learndash_add_admin_tab_item(
				'admin.php?page=learndash_lms_settings',
				array(
					'id' => 'settings_page_learndash_slack',
					'link' => add_query_arg( array( 'page' => 'learndash_slack' ), 'options-general.php' ),
					'name' => _x( 'Slack', 'Slack Tab Label', 'learndash-slack' ),
				),
				40
			);
			
		}
		
	}
	
	/**
	 * Fakes the Current Menu Item
	 * 
	 * @param		string $parent_file Parent Menu Item
	 *														
	 * @access		public
	 * @since		1.1.0
	 * @return		string Modified String
	 */
	public function fix_parent_file( $parent_file ) {
	
		global $current_screen;
		global $self;

		if ( $current_screen->base == 'settings_page_learndash_slack' ) {
				
			// Render this as the Active Page Menu
			$parent_file = 'admin.php?page=learndash_lms_settings';

			// Ensure the top-level "Settings" doesn't show as active
			$self = 'learndash-lms';

		}

		return $parent_file;

	}
	
	/**
	 * Fakes the current Submenu Item
	 * 
	 * @param		string $submenu_file Current Menu Item
	 * @param		string $parent_file  Parent Menu Item
	 *
	 * @access		public
	 * @since		1.1.0
	 * @return		string Modified String
	 */
	public function fix_submenu_file( $submenu_file, $parent_file ) {

		global $current_screen;

		if ( $current_screen->base == 'settings_page_learndash_slack' ) {
				
			$submenu_file = 'admin.php?page=learndash_lms_settings';

		}

		return $submenu_file;

	}
	
}

$instance = new LearnDash_Slack_Settings_Tabs();