<?php
/**
 * Adds the licensing settings..
 *
 * @since		1.0.0
 *
 * @package LearnDash_Slack
 * @subpackage LearnDash_Slack/licensing
 */

defined( 'ABSPATH' ) || die();

final class LearnDash_Slack_License_Field {

	/**
	 * LearnDash_Slack_License_Field constructor.
	 *
	 * @since		1.0.0
	 */
	function __construct() {
		
		// License Settings Section
		add_action( 'sfwd_lms-nss_license_footer', array( $this, 'licensing_settings_section' ) );
		
		// Enqueue some minimal styles
		add_action( 'admin_page_nss_plugin_license-sfwd_lms-settings', array( $this, 'enqueue_styles' ) );
		
	}

	/**
	 * The Licensing Settings Section in which we output our Settings Fields
	 *
	 * @access		public
	 * @since		1.0.0
	 * @return		void
	 */
	public function licensing_settings_section() {
		
		settings_errors( 'ld_slack_support' ); 

		?>

		<div class="learndash-slack-wrap wrap">

			<h2>
				<?php echo LEARNDASHSLACK()->plugin_data['Name']; ?>
			</h2>
			
			<div class="rbp-support-licensing-form">

				<form method="post">

					<?php LEARNDASHSLACK()->support->licensing_fields(); ?>
					<?php LEARNDASHSLACK()->support->beta_checkbox(); ?>

				</form>

			</div>

			<?php LEARNDASHSLACK()->support->support_form(); ?>
			
		</div>

		<?php
		
	}
	
	public function enqueue_styles() {
		
		LEARNDASHSLACK()->support->enqueue_all_scripts();
		
		wp_enqueue_style( 'learndash-slack-admin' );
		
	}
	
}