<?php

namespace uncanny_ceu;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class UncannyCeuCompletionStatus
 * @package uncanny_ceu
 */
class BackendCourseReport {

	static $user = 0;
	static $date = '';
	static $start_date = false;
	static $end_date = false;
	static $group = 0;
	static $users_ceus = array();

	/**
	 * UncannyCeuCompletionStatus constructor.
	 */
	public function __construct() {

		add_action( 'admin_menu', array( $this, 'completion_status_admin_menu' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_custom_wp_admin_style' ) );

	}

	/**
	 *
	 */
	public function completion_status_admin_menu() {

		$page_title  = __( 'Uncanny CEUs', 'uncanny-ceu' );
		$menu_title  = __( 'Course Report', 'uncanny-ceu' );
		$capability  = 'manage_options';
		$menu_slug   = 'uncanny-ceu-report';
		$parent_slug = 'uncanny-ceu-report';
		$function    = array( $this, 'options_menu_page_output' );

		// Menu Icon blends into sidebar when the default admin color scheme is used
		$icon_url = 'data:image/svg+xml;base64,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';

		$position = 82; // 81 - Above Settings Menu

		// Create the main page
		add_menu_page( $page_title, $page_title, $capability, $menu_slug, $function, $icon_url, $position );


		//add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function, '', 82);
		add_submenu_page( $parent_slug, $page_title, $menu_title, $capability, $menu_slug, $function, '', 82 );
	}

	/**
	 *
	 */
	public function load_custom_wp_admin_style( $hook ) {

		/*
		 * Only load styles if the page hook contains the pages slug
		 *
		 * Hook can be either the toplevel_page_{page_slug} if its a parent  page OR
		 * it can be {parent_slug}_pag_{page_slug} if it is a sub page.
		 * Lets just check if our page slug is in the hook.
		 */

		// Target Licensing page
		if ( strpos( $hook, 'uncanny-ceu-report' ) ) {
			// Date Picker
			wp_enqueue_script( 'jquery-ui-datepicker' );

			// Select2
			wp_enqueue_script( 'ucec-admin-select2', Utilities::get_vendor( 'select2/select2.min.js' ), [ 'jquery' ], Utilities::get_version(), true );
			wp_enqueue_style( 'ucec-admin-select2', Utilities::get_vendor( 'select2/select2.min.css' ), [], Utilities::get_version() );

			// DataTables
			wp_enqueue_script( 'ucec-admin-datatables', Utilities::get_vendor( 'datatables/datatables.min.js' ), [ 'jquery' ], Utilities::get_version(), true );
			wp_enqueue_style( 'ucec-admin-datatables', Utilities::get_vendor( 'datatables/datatables.min.css' ), [], Utilities::get_version() );

			// Global assets
			wp_enqueue_script( 'ucec-admin', Utilities::get_asset( 'backend', 'bundle.min.js' ), [
				'jquery',
				'ucec-admin-datatables',
				'ucec-admin-select2',
				'jquery-ui-datepicker'
			], Utilities::get_version(), true );
			wp_enqueue_style( 'ucec-admin', Utilities::get_asset( 'backend', 'bundle.min.css' ), [
				'ucec-admin-datatables',
				'ucec-admin-select2'
			], Utilities::get_version() );
		}

	}

	/**
	 *
	 */
	public function options_menu_page_output() {

		$get_data = false;

		if ( isset( $_GET['date'] ) ) {
			$date = sanitize_text_field( $_GET['date'] );
			if ( in_array( $date, [ 'week', 'month', 'year', 'all', 'custom' ] ) ) {
				self::$date = $date;
			}
			$get_data = true;
		} else {
			// Set default
			self::$date = $date = $_GET['date'] = 'month';
			$get_data   = true;
		}

		if ( isset( $_GET['user'] ) ) {
			self::$user = absint( $_GET['user'] );
			$get_data   = true;
		}

		if ( isset( $_GET['group'] ) ) {
			self::$group = absint( $_GET['group'] );
			$get_data    = true;
		}

		if ( isset( $_GET['start_date'] ) ) {
			$start_date       = sanitize_text_field( $_GET['start_date'] );
			$date             = \DateTime::createFromFormat( 'j M, y', $start_date );
			self::$start_date = $date;
			$get_data         = true;
		}

		if ( isset( $_GET['end_date'] ) ) {
			$end_date       = sanitize_text_field( $_GET['end_date'] );
			$date           = \DateTime::createFromFormat( 'j M, y', $end_date );
			self::$end_date = $date;
			$get_data       = true;
		}

		if ( $get_data ) {
			$this->get_user_course_data();
		}


		include Utilities::get_template( 'admin-course-report.php' );

	}

	/**
	 * Collect user data
	 */
	private function get_user_course_data() {

		global $wpdb;

		$query = "SELECT DISTINCT user.ID, user.user_email FROM $wpdb->usermeta meta JOIN $wpdb->users user ON user.ID = meta.user_id WHERE meta.meta_key LIKE 'ceu_date_%'";


		if ( 0 !== absint( self::$user ) ) {
			$user  = self::$user;
			$query .= " AND user.ID = $user";
		}

		if ( 0 !== absint( self::$group ) ) {

			$group       = self::$group;
			$group_users = learndash_get_groups_users( $group );

			$group_user_ids = [];
			foreach ( $group_users as $group_user ) {
				$group_user_ids[ $group_user->ID ] = $group_user->ID;
			}

			$group_courses = learndash_group_enrolled_courses( $group );

			$group_course_ids = [];
			foreach ( $group_courses as $group_course ) {
				$group_course_ids[ (int) $group_course ] = (int) $group_course;
			}
		}

		$start_date = 0;
		$end_date   = 0;

		if ( '' !== self::$date ) {

			$current_date = time();

			switch ( self::$date ) {

				case 'week':
					$end_date = new \DateTime();
					$end_date->setTimestamp( $current_date );

					$start_date = new \DateTime();
					$start_date->setTimestamp( $current_date );
					$start_date->modify( '-7 days' );

					break;
				case 'month':
					$end_date = new \DateTime();
					$end_date->setTimestamp( $current_date );

					$start_date = new \DateTime();
					$start_date->setTimestamp( $current_date );
					$start_date->modify( '-30 days' );
					break;
				case 'year':
					$end_date = new \DateTime();
					$end_date->setTimestamp( $current_date );

					$start_date = new \DateTime();
					$start_date->setTimestamp( $current_date );
					$start_date->modify( '-365 days' );
					break;
				case 'custom':
					$start_date = self::$start_date;
					$start_date->setTime( 0, 0 );
					$end_date = self::$end_date;
					$end_date->setTime( 23, 59, 59 );
					break;
			}

			if ( 0 !== $start_date && 0 !== $end_date ) {

				$unix_start_date = $start_date->format( 'U' );
				$unix_end_date   = $end_date->format( 'U' );
			}
		}

		$users = $wpdb->get_results( $query );

		$ceu_completions = array();

		foreach ( $users as $user ) {

			$user_meta = get_user_meta( $user->ID );

			// If the group filter is set then only collection user within the group
			if ( 0 !== absint( self::$group ) ) {
				if ( ! isset( $group_user_ids[ $user->ID ] ) ) {
					continue;
				}
			}

			$avatar     = get_avatar_url( $user->ID );
			$first_name = $user_meta['first_name'][0];
			$last_name  = $user_meta['last_name'][0];
			$email      = $user->user_email;
			$user_id    = $user->ID;

			$total_ceus = 0;

			foreach ( $user_meta as $meta_key => $meta_value ) {

				if ( false !== strpos( $meta_key, 'ceu_' ) ) {

					$key        = explode( '_', $meta_key );
					$collection = array( 'title', 'date', 'course', 'earned' );

					if ( ! in_array( $key[1], $collection ) ) {
						continue;
					}

					// If the group filter is set then only collection user within the group
					if ( 0 !== absint( self::$group ) ) {
						if ( ! isset( $group_course_ids[ (int) $key[3] ] ) ) {
							continue;
						}
					}

					$unique_key = $key[2] . '_' . $key[3] . '_' . $user_id; //unique identifier for ceu completion...  {timestamp}_{course ID}
					$value_key  = $key[0] . '_' . $key[1]; // name of data stored... ceu_title  ceu_date  ceu_course  ceu_earned

					if ( 'ceu_earned' === $value_key ) {
						$total_ceus += (float) $meta_value[0];
					}

					if ( 'date' === $key[1] ) {
						if ( 0 !== $start_date && 0 !== $end_date ) {
							if ( $meta_value[0] <= $unix_start_date || $meta_value[0] >= $unix_end_date ) {
								continue;
							}
						}
					}

					if ( ! isset( $ceu_completions[ $unique_key ] ) ) {
						$ceu_completions[ $unique_key ]               = array();
						$ceu_completions[ $unique_key ]['user_id']    = (int) $user_id;
						$ceu_completions[ $unique_key ]['course_id']  = $key[3];
						$ceu_completions[ $unique_key ]['avatar']     = $avatar;
						$ceu_completions[ $unique_key ]['first_name'] = $first_name;
						$ceu_completions[ $unique_key ]['last_name']  = $last_name;
						$ceu_completions[ $unique_key ]['email']      = $email;
						$ceu_completions[ $unique_key ]['total_ceus'] = 0;
					}

					$ceu_completions[ $unique_key ][ $value_key ] = $meta_value[0];

					if ( 'ceu_earned' === $value_key ) {
						$ceu_completions[ $unique_key ]['total_ceus'] += $total_ceus;
					}
				}
			}
		}

		foreach ( $ceu_completions as $key => $completion ) {
			if ( ! isset( $completion['ceu_date'] ) ) {
				unset( $ceu_completions[ $key ] );
			}
		}

		self::$users_ceus = $ceu_completions;
	}

	/**
	 * Get select options for the "dATE" dropdown
	 *
	 * @since 3.0
	 *
	 * @return String
	 */

	static function get_date_dropdown() {
		// Set options
		$options = [
			[
				'value' => 'week',
				'text'  => __( 'Last 7 days', 'uncanny-ceu' )
			],
			[
				'value' => 'month',
				'text'  => __( 'Last 30 days', 'uncanny-ceu' )
			],
			[
				'value' => 'year',
				'text'  => __( 'Last 365 days', 'uncanny-ceu' )
			],
			[
				'value' => 'all',
				'text'  => __( 'All time', 'uncanny-ceu' )
			],
			[
				'value' => 'custom',
				'text'  => __( 'Custom range', 'uncanny-ceu' )
			],
		];

		// Start HTML
		ob_start();

		// Iterate and create options
		foreach ( $options as $option ) {
			// Check if the option is selected
			$is_selected = self::$date == $option['value'];

			?>

			<option value="<?php echo $option['value']; ?>" <?php if ( $is_selected ) {
				echo 'selected="selected"';
			} ?>>
				<?php echo $option['text']; ?>
			</option>

			<?php
		}

		// Get HTML
		$options_html = ob_get_clean();

		// Return HTML
		return $options_html;
	}

	/**
	 * Get array with the list of all users from the site
	 * Each array element will have a "value" element, which will contain the user id,
	 * and also will have a "text" element, which will contain the text to be shown in the option
	 *
	 * @since  2.5
	 *
	 * @return Array
	 */

	static function get_users() {
		// Get list of all users
		$users = get_users();

		// Create array that will contain the optiosn
		$options = array();

		// Iterate users and create main array
		foreach ( $users as $user ) {
			// Get avatar
			$user->avatar = get_avatar_url( $user->ID );

			// Add option
			$options[] = array(
				'value' => $user->ID,
				'text'  => sprintf( '%s::%s::%s', $user->avatar, $user->display_name, $user->user_email )
			);
		}

		// Apply filters and return
		return apply_filters( 'ucec_course_report_users', $options );
	}

	/**
	 * Get select options for the "Users" dropdown
	 *
	 * @since 2.5
	 *
	 * @return String
	 */

	public static function get_users_dropdown() {

		if ( 0 === self::$user ) {
			if ( isset( $_GET['user'] ) ) {
				self::$user = absint( $_GET['user'] );
			}
		}

		// Get options
		$options = self::get_users();

		// Add "All users option"
		array_unshift( $options, array(
			'value' => 0,
			'text'  => __( 'All users', 'uncanny-ceu' ),
		) );

		// Start HTML
		ob_start();

		// Iterate and create options
		foreach ( $options as $option ) {

			$is_selected = false;

			// Check if the option is selected
			if ( self::$user === $option['value'] ) {
				$is_selected = true;
			}

			?>

			<option value="<?php echo $option['value']; ?>" <?php if ( $is_selected ) {
				echo 'selected="selected"';
			} ?>>
				<?php echo $option['text']; ?>
			</option>

			<?php
		}

		// Get HTML
		$options_html = ob_get_clean();

		// Return HTML
		return $options_html;
	}

	/**
	 * Get select options for the "Groups" dropdown
	 *
	 * @since 2.5
	 *
	 * @return String
	 */

	public static function get_groups_dropdown() {

		if ( 0 === self::$group ) {
			if ( isset( $_GET['group'] ) ) {
				self::$group = absint( $_GET['group'] );
			}
		}

		$args = array(
			'post_type'      => 'groups',
			'posts_per_page' => - 1,
			'orderby'        => 'title',
		);

		$the_query = new \WP_Query( $args );

		$drop_down = '<option value="0">' . __( 'All groups', 'uncanny-ceu' ) . '</option>';

		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {

				$selected = '';
				$the_query->the_post();

				if ( (int) self::$group === get_the_ID() ) {
					$selected = 'selected="selected"';
				}

				$drop_down .= '<option ' . $selected . ' value="' . get_the_ID() . '">' . get_the_title() . '</option>';
			}

			/* Restore original Post Data */
			wp_reset_postdata();
		}

		return $drop_down;
	}
}