(function ($) { // Self Executing function with $ alias for jQuery

    /**
     *  Initialization  similar to include once but since all js is loaded by the browser automatically the all
     *   we have to do is call our functions to initialize them, his is only run in the main configuration file
     */
    $(document).ready(function () {

        if ($('#uo-group-assignments-table').length > 0 ){
            window.ulgmGroupManagement.Assignments.constructor();

            jQuery('form#uo-groups-assignments-management-form').on('click', 'button.assignment_approve_single,a.assignment_approve_single,button#group-approve-assignments-button', function (e) {
                e.preventDefault();
                var assignment_id = jQuery(this).attr('id').replace('assignment_approve_', '');
                assignment_id = assignment_id.replace('a_', '');
                if ((typeof assignment_id !== 'undefined') && (assignment_id != '')) {
                    if (jQuery('form#uo-groups-assignments-management-form input#bulk-post-selector-top').length) {
                        jQuery('form#uo-groups-assignments-management-form input#bulk-post-selector-top').val(assignment_id);
                    }
                    if (jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').length) {
                        jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').val('approve_assignment');
                    }
                    var dataVars = $('form#uo-groups-assignments-management-form').serialize();
                    window.ulgmGroupManagement.Assignments.actionsAssignment(dataVars);
                }
            });
            jQuery('form#uo-groups-assignments-management-form').on('click','a.delete_assignment_single,button#group-trash-assignments-button',function(e) {
                e.preventDefault();
                var assignment_id = jQuery(this).attr('id').replace('a_assignment_trash_', '');

                if ( ( typeof assignment_id !== 'undefined' ) && ( assignment_id != '' ) ) {
                    if (jQuery('form#uo-groups-assignments-management-form input#bulk-post-selector-top').length) {
                        jQuery('form#uo-groups-assignments-management-form input#bulk-post-selector-top').val(assignment_id);
                    }
                    if (jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').length) {
                        jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').val('trash_assignment');
                    }
                    var dataVars = $('form#uo-groups-assignments-management-form').serialize();
                    window.ulgmGroupManagement.Assignments.actionsAssignment(dataVars);
                }
            });


            $('#uo-group-assignments-table').on('click','a.edit_assignment_single',function(){
                var post_id = $(this).data('assignment-id');
                window.ulgmGroupManagement.Assignments.editAssignmentsData(post_id);
            });
            $('body').on('click','button#uo-assignment-edit-button',function(){
                window.ulgmGroupManagement.Assignments.saveAssignmentsData();
            });
            $('body').on('click','#uo-assignment-update-button',function(){
                window.ulgmGroupManagement.Assignments.saveAssignmentsData();
            });

            var transitionTimeout;
            $( '#uo-group-assignments-table tbody' ).on({
                mouseenter: function() {
                    clearTimeout( transitionTimeout );
                    focusedRowActions = $( this ).find( '.row-actions' );
                    // transitionTimeout is necessary for Firefox, but Chrome won't remove the CSS class without a little help.
                    $( '.row-actions' ).not( this ).removeClass( 'visible' );
                    focusedRowActions.addClass( 'visible' );
                },
                mouseleave: function() {
                    // Tabbing between post title and .row-actions links needs a brief pause, otherwise
                    // the .row-actions div gets hidden in transit in some browsers (ahem, Firefox).
                    transitionTimeout = setTimeout( function() {
                        focusedRowActions.removeClass( 'visible' );
                    }, 30 );
                }
            }, 'tr' );
        }
    });


    window.ulgmGroupManagement.Assignments = {

        uoTable: null,

        uoTableHidden: null,

        lessonId: 0,

        groupId: 0,

        courseId: 0,

        elements: {
            select: {
                group: {
                    element: null,
                    options: null
                },
                course: {
                    element: null,
                    options: null,
                    no_element: null
                },
                lesson: {
                    element: null,
                    options: null,
                    no_element: null
                },
            }
        },

        constructor: function () {
            this.elements.select.group.element  = $('#uo-group-report-group');
            this.elements.select.course.element = $('#uo-group-report-courses');
            this.elements.select.lesson.element   = $('#uo-group-report-lessons');
            this.elements.select.course.no_element = $('#uo-group-report-nocourses');
            this.elements.select.lesson.no_element   = $('#uo-group-report-nolessons');

            this.elements.select.group.options  = $('#uo-group-report-group option');
            this.elements.select.course.options = $('#uo-group-report-courses option');
            this.elements.select.lesson.options   = $('#uo-group-report-lessons option');

            this.createTable();
            this.createTableHidden();
            this.addEvents();
            // Request data
            window.ulgmGroupManagement.Assignments.getAssignmentsData( 0, 0, window.ulgmGroupManagement.Assignments.groupId );
        },

        createTable: function (data) {

            var columns = [
                {title: 'select'},
                {title: groupAssignments.localized.title},
                {title: groupAssignments.localized.author},
                {title: groupAssignments.localized.status},
                {title: groupAssignments.localized.points},
                {title: groupAssignments.localized.assignedCourse},
                {title: groupAssignments.localized.assignedlesson},
                {title: groupAssignments.localized.comments},
                {title: groupAssignments.localized.date}
            ];

            var tableVars = {
                aLengthMenu: [
                    [15, 30, 60, -1],
                    [15, 30, 60, groupAssignments.localized.all]
                ],
                responsive: false,
                iDisplayLength: 30,
                columns: columns,
                columnDefs: [{
                    "targets": 0,
                    "orderable": false,
                    "searchable": false,
                    'render': function (data, type, full, meta){
                        return '<input type="checkbox" name="post[]" value="' + $('<div/>').text(data).html() + '">';
                    },
                    'checkboxes': {
                        'selectRow': true
                    }
                }],
                select: {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                stateSave: true,

            };

            if (null !== this.uoTable) {

                this.uoTable.destroy();

                tableVars.data = data;

                tableVars.columns = [
                    {title: '<input type="checkbox" name="select_all" value="1" id="uo-assignments-select-all">', data: 'id'},
                    {title: groupAssignments.localized.title, data: 'title', className:'has-row-actions'},
                    {title: groupAssignments.localized.author, data: 'author'},
                    {title: groupAssignments.localized.status, data: 'status',orderable: true,},
                    {title: groupAssignments.localized.points, data: 'points',orderable: false,},
                    {title: groupAssignments.localized.assignedCourse, data: 'assignedCourse',orderable: true,},
                    {title: groupAssignments.localized.assignedlesson, data: 'assignedlesson',orderable: true,},
                    {title: groupAssignments.localized.comments, data: 'comments'},
                    {title: groupAssignments.localized.date, data: 'date'},
                ];

            }
            tableVars.language = {
                "lengthMenu": groupAssignments.localized.lengthMenu,
                "zeroRecords": groupAssignments.localized.zeroRecords,
                "info": groupAssignments.localized.info,
                "infoEmpty": groupAssignments.localized.infoEmpty,
                "infoFiltered": groupAssignments.localized.infoFiltered,
                "loadingRecords": groupAssignments.localized.loadingRecords,
                "emptyTable": groupAssignments.localized.emptyTable,
                "sSearch": groupAssignments.localized.sSearch,
                "searchPlaceholder": groupAssignments.localized.searchPlaceholder
            };
            tableVars.rowCallback = function (row, data) {
              //  $(row).addClass('has-row-actions');
            }

            this.uoTable = jQuery('#uo-group-assignments-table');

            if ( jQuery('#uo-group-assignments-table').length > 0 ){
                this.uoTable = jQuery('#uo-group-assignments-table').DataTable(tableVars);
            }
        },

        createTableHidden: function (data) {

            var columns = [
                {title: groupAssignments.localized.title, data: 'title'},
                {title: groupAssignments.localized.author, data: 'author'},
                {title: groupAssignments.localized.status, data: 'status',orderable: true,},
                {title: groupAssignments.localized.points, data: 'points',orderable: false,},
                {title: groupAssignments.localized.assignedCourse, data: 'assignedCourse',orderable: true,},
                {title: groupAssignments.localized.assignedlesson, data: 'assignedlesson',orderable: true,},
                {title: groupAssignments.localized.comments, data: 'comments'},
                {title: groupAssignments.localized.date, data: 'date'},
            ];

            /*var language = [
                "lengthMenu": groupAssignments.localized.lengthMenu,
                "zeroRecords": groupAssignments.localized.zeroRecords,
                "info": groupAssignments.localized.info,
                "infoEmpty": groupAssignments.localized.infoEmpty,
                "infoFiltered": groupAssignments.localized.infoFiltered,
                "loadingRecords": groupAssignments.localized.loadingRecords,
                "emptyTable": groupAssignments.localized.emptyTable
            ];*/

            var tableVars = {
                iDisplayLength: -1,
                columns: columns,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'csv',
                        text: groupAssignments.localized.csvExport,
                        title: 'lesson-report'
                    }
                ],
                stateSave: true,
            };

            if ($.fn.DataTable.isDataTable( '#uo-lesson-report-table-hidden' )) {

                $( '#uo-lesson-report-table-hidden' ).DataTable().destroy();

                tableVars.data = data;

                tableVars.columns = [
                    {title: groupAssignments.localized.title, data: 'title'},
                    {title: groupAssignments.localized.author, data: 'author'},
                    {title: groupAssignments.localized.status, data: 'status',orderable: true,},
                    {title: groupAssignments.localized.points, data: 'points',orderable: false,},
                    {title: groupAssignments.localized.assignedCourse, data: 'assignedCourse',orderable: true,},
                    {title: groupAssignments.localized.assignedlesson, data: 'assignedlesson',orderable: true,},
                    {title: groupAssignments.localized.comments, data: 'comments'},
                    {title: groupAssignments.localized.date, data: 'date'},
                ];

            }

            tableVars.language = {
                "lengthMenu": groupAssignments.localized.lengthMenu,
                "zeroRecords": groupAssignments.localized.zeroRecords,
                "info": groupAssignments.localized.info,
                "infoEmpty": groupAssignments.localized.infoEmpty,
                "infoFiltered": groupAssignments.localized.infoFiltered,
                "loadingRecords": groupAssignments.localized.loadingRecords,
                "emptyTable": groupAssignments.localized.emptyTable
            };

            if ( jQuery('#uo-lesson-report-table-hidden').length > 0 ){
                jQuery('#uo-lesson-report-table-hidden').DataTable(tableVars);
            }

            $('.buttons-csv').show();

        },

        flattenArray: function (array, remove_stats) {

            var flatArray = [];

            jQuery.each(array, function (key, value) {

                var lesson_name = value;
                jQuery.each(value.question, function (key2, value2) {
                    flatArray.push({
                        "title": value.title,
                        "author": value.author,
                        "status": value.status,
                        "points": value.points,
                        "assignedCourse": value.assignedCourse,
                        "assignedlesson": value.assignedlesson,
                        "comments": value.comments,
                        "date": value.date,
                    })
                });

            });

            return flatArray;

        },

        create_options: function( source, ids ){
            /*
            * @param source string, values "group", "course", "lesson"
            * @param ids    array,  ids of options that have to be shown
            *
            * @return array of jQuery DOM elements with the option elements
            */

            let options = [];

            // Convert parameters to int
            ids = ids.map( Number );

            // Add empty option
            // if there are more then one option
            if( ids.length > 1 ){
                ids.push(0);
            }


            // Get options by ID
            this.elements.select[source].options.each(function(){
                let $this   = $(this),
                    id      = parseInt( $this.val() );
                $this.show();
                if ( ids.indexOf( id ) != -1 ){
                    options.push( $this );
                }
            });

            // Return options
            return options;
        },

        select_option: function( $select, value ){
            /*
            * @param select  dom element
            * @param value   string, value of the option that has to be selected
            */

            // Remove selected property
            $select.find( 'option' ).prop( 'selected', false );

            // Select option with value = @param value
            $select.find( 'option[value="' + value + '"]' ).prop( 'selected', true );
        },
        __select_option: function( $select, index ){
            /*
            * @param select  dom element
            * @param value   string, value of the option that has to be selected
            */

            // Remove selected property
            $select.find( 'option' ).prop( 'selected', false );

            // Select option with value = @param value
            $select.find( 'option[' + index + ']' ).prop( 'selected', true );
        },
        addEvents: function (){
            var _this = this;

            // Handle click on "Select all" control
            $('#uo-groups-assignments-management').on('click','#uo-assignments-select-all', function(){
                // Check/uncheck checkboxes for all rows in the table
                $('input[name="post[]"]').prop('checked', this.checked);
                if ($('input[name="post[]"]').is(':checked')) {
                    $('.group-assignments-buttons').show();
                } else {
                    $('.group-assignments-buttons').hide();
                    $('#uo-assignments-select-all').prop('checked', false);
                }
            });

            // Handle click on checkbox to set state of "Select all" control
            $('#uo-group-assignments-table tbody').on('change', 'input[name="post[]"]', function(){
                // If checkbox is not checked
                if(!this.checked){
                    var el = $('#uo-assignments-select-all').get(0);
                    // If "Select all" control is checked and has 'indeterminate' property
                    if(el && el.checked && ('indeterminate' in el)){
                        // Set visual state of "Select all" control
                        // as 'indeterminate'
                        el.indeterminate = true;
                    }
                }
                if ($('input[name="post[]"]').is(':checked')) {
                    $('.group-assignments-buttons').show();
                } else {
                    $('.group-assignments-buttons').hide();
                    $('#uo-assignments-select-all').prop('checked', false);
                }
            });

            $('#uo-groups-assignments-management').on('click','#group-approve-assignments-button',function(){
                if (jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').length) {
                    jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').val('approve_assignment');
                }
                //jQuery('form#uo-groups-assignments-management-form').submit();
            });

            $('#uo-groups-assignments-management').on('click','#group-trash-assignments-button',function(){
                if (jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').length) {
                    jQuery('form#uo-groups-assignments-management-form input#bulk-action-selector-top').val('trash_assignment');
                }
                //jQuery('form#uo-groups-assignments-management-form').submit();

            });

            this.elements.select.group.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Hide lesson select
                //_this.elements.select.lesson.element.hide();
                _this.elements.select.course.element.show();

                // Group ID
                let group_id = $this.val();
                // Return if course id is 0
                if( group_id == 0){
                    _this.elements.select.course.element.empty();
                    let options_course = _this.create_options( 'course', [0] );
                    _this.elements.select.course.element.html(options_course);
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    window.ulgmGroupManagement.Assignments.createTable([]);
                    window.ulgmGroupManagement.Assignments.createTableHidden([]);
                    return;
                }
                // Get relationships
                let courses_to_show = groupAssignments.courseGrouplessons[ group_id ];
                courses_to_show = courses_to_show === undefined ? [] : courses_to_show;

                // Create options
                let options = _this.create_options( 'course', courses_to_show );

                if ( options.length > 0 ){
                     // Show "Select course" dropdown
                    _this.elements.select.course.element.show();
                    _this.elements.select.course.element.html( options );
                    _this.elements.select.course.no_element.hide();
                    _this.elements.select.course.element.html(_this.elements.select.course.element.find('option').sort(function(x, y) {
                        // to change to descending order switch "<" for ">"
                        return $(x).text() > $(y).text() ? 1 : -1;
                    }));
                    // Select empty option

                    _this.__select_option( _this.elements.select.course.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.Assignments.groupId = group_id;
                    // trigger change after value set on load
                    _this.elements.select.course.element.trigger('change');
                }
                else {
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.course.element.empty();
                    let options_course = _this.create_options( 'course', [0] );
                    _this.elements.select.course.element.html(options_course);
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    window.ulgmGroupManagement.Assignments.createTable([]);
                    window.ulgmGroupManagement.Assignments.createTableHidden([]);
                    // Save data in main object
                    window.ulgmGroupManagement.Assignments.groupId = group_id;
                }
                // Request data
                window.ulgmGroupManagement.Assignments.getAssignmentsData( 0, 0, window.ulgmGroupManagement.Assignments.groupId );
            });

            this.elements.select.course.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Course ID
                let course_id = $this.val();
                // Return if course id is 0
                if( course_id == 0){
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    window.ulgmGroupManagement.Assignments.createTable([]);
                    window.ulgmGroupManagement.Assignments.createTableHidden([]);
                    return;
                }

                // Get relationships
                let lessons_to_show = groupAssignments.relationships[ window.ulgmGroupManagement.Assignments.groupId ][ course_id ];
                lessons_to_show = lessons_to_show === undefined ? [] : lessons_to_show;

                // Create options
                let options = _this.create_options( 'lesson', lessons_to_show );

                if ( options.length > 0 ) {
                    // Show "Select lesson" dropdown
                    _this.elements.select.lesson.element.show();
                    _this.elements.select.lesson.element.html(options);
                    jQuery('#uo-group-report-lessons option').show();
                    _this.elements.select.lesson.no_element.hide();

                    // Select empty option
                    _this.__select_option( _this.elements.select.lesson.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.Assignments.courseId = course_id;
                    // trigger change after value set on load
                    _this.elements.select.lesson.element.trigger('change');
                }else{
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.lesson.element.empty();
                    let options = _this.create_options( 'lesson', [0] );
                    _this.elements.select.lesson.element.html(options);
                    window.ulgmGroupManagement.Assignments.createTable([]);
                    window.ulgmGroupManagement.Assignments.createTableHidden([]);
                    // Save data in main object
                    window.ulgmGroupManagement.Assignments.courseId = course_id;
                    // Request data
                    window.ulgmGroupManagement.Assignments.getAssignmentsData( 0, window.ulgmGroupManagement.Assignments.courseId, window.ulgmGroupManagement.Assignments.groupId );
                }

            });

            this.elements.select.lesson.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // lesson ID
                let lesson_id = $this.val();
                // Save data in main object
                window.ulgmGroupManagement.Assignments.lessonId = lesson_id;

                // Request data
                window.ulgmGroupManagement.Assignments.getAssignmentsData( lesson_id, window.ulgmGroupManagement.Assignments.courseId, window.ulgmGroupManagement.Assignments.groupId );
            });

            // Add event listener for opening and closing details
            $('#uo-lesson-report-table').on('click', 'td.details-control', function () {

                var tr = $(this).closest('tr');
                var row = window.ulgmGroupManagement.Assignments.uoTable.row(tr);

                if (row.child.isShown()) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                }
                else {
                    // Open this row
                    row.child(window.ulgmGroupManagement.Assignments.format(row.data())).show();
                    tr.addClass('shown');
                }
            });

        },

        format: function (d) {

            var rows = '';
            $.each(d.answer, function (key, value) {
                rows +=
                    '<tr>' +
                    '<td>' + d.question[key] + '</td>' +
                    '<td>' + value + '</td>' +
                    '</tr>';
            });
            // `d` is the original data object for the row
            return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">' + rows + '</table>';
        },
        isNormalInteger: function (str) {
            var n = ~~Number(str);
            return String(n) === str && n > 0;
        },

        getAssignmentsData: function (lessonId, courseId, groupId) {
            var spinner = $('.uo-modal-spinner');
            spinner.show();
            var i = 0;

            var loading = setInterval(function () {
                i = ++i % 4;
                $("#uo-group-assignments-table tbody").html("<div id='group-loader'>" + groupAssignments.localized.loadingRecords + new Array(i + 1).join(".") + "</div>");
            }, 500);


            var dataVars = {
                groupId: groupId,
                lessonId: lessonId,
                courseId: courseId
            };

            $.ajax({

                method: "POST",
                data: dataVars,
                url: groupAssignments.root + 'get_assignments_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupAssignments.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    clearInterval(loading);
                    $('#group-loader').remove();

                    window.ulgmGroupManagement.Assignments.createTable(response);
                    window.ulgmGroupManagement.Assignments.createTableHidden(response);


                },
                fail: function (response) {
                    alert('Rest Call Failed');
                }

            });

        },
        editAssignmentsData: function (postId) {
            var spinner = $('.uo-modal-spinner');
            spinner.show();
            var dataVars = {
                assignment_id: postId,
                action: 'edit_assignments',
                post_type:'sfwd-assignment',
                security:groupAssignments.ajax_nonce
            };

            $.ajax({
                method: "POST",
                data: dataVars,
                url: groupAssignments.root + 'edit_assignments_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupAssignments.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    $(".modal").remove();
                    $(response.html).appendTo('body').modal();
                },
                fail: function (response) {
                    spinner.hide();
                    alert('Rest Call Failed');
                }
            });
        },
        saveAssignmentsData: function () {
            var dataVars = $('#edit_assignment_form').serialize();
            var spinner = $('.uo-modal-spinner');
            //$('#group-management-message').hide();
            $('.uo-groups-message-ok').hide();
            spinner.show();
            $.ajax({
                method: "POST",
                data: dataVars,
                url: groupAssignments.root + 'save_assignments_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupAssignments.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    window.ulgmGroupManagement.Assignments.elements.select.lesson.element.trigger('change');
                    //$('#group-management-message').html(response.message).show();
                    $('.uo-groups-message-ok').html(response.message).show();
                },
                fail: function (response) {
                    spinner.hide();
                    alert('Rest Call Failed');
                }
            });
        },
        actionsAssignment: function ( dataVars ) {
            var spinner = $('.uo-modal-spinner');
            spinner.show();
            $.ajax({
                method: "POST",
                data: dataVars,
                url: groupAssignments.root + 'save_assignments_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupAssignments.nonce);
                },
                success: function (response) {
                    spinner.hide();
                    window.ulgmGroupManagement.Assignments.elements.select.lesson.element.trigger('change');
                },
                fail: function (response) {
                    spinner.hide();
                    alert('Rest Call Failed');
                }
            });
        }
    };


})(jQuery);