(function ($) { // Self Executing function with $ alias for jQuery

    /**
     *  Initialization  similar to include once but since all js is loaded by the browser automatically the all
     *   we have to do is call our functions to initialize them, his is only run in the main configuration file
     */
    $(document).ready(function () {

        if ($('#group-report').length > 0 ) {
            window.ulgmGroupManagement.reportingTemplating.constructor();
        }

        if ($('#uo-quiz-report-table').length > 0 ) {
            window.ulgmGroupManagement.quizReport.constructor();
        }

        if( $('#uo-group-report-course') > 0 ) {
            $('#uo-group-report-course').select2();
        }

    });

    window.ulgmGroupManagement.reportingTemplating = {

        rowTemplate: '',
        itemTemplate: '',
        liTemplate: '',
        items: [],
        itemsEl: [],
        jpL: false,

        // initialize the code
        constructor: function () {
            if ( $('#group-report').length > 0 ){
                // Get Template
                this.itemTemplate = $('script[data-template="item"]').text().split(/\$\{(.+?)\}/g);

                // Start jpList
                this.jpL = $('#group-report').jplist({
                    itemsBox: '.uo-group-report-table'
                    , itemPath: '.uo-tbl-item'
                    , panelPath: '.jplist-panel'
                });
            }  
        },

        setItems: function (items) {

            var _this = this;

            //remove items from jPList collection
            this.jpL.jplist({
                command: 'del'
                , commandData: {
                    $items: this.itemsEl,  //select your items using jQuery
                }
            });

            // Reset Items
            this.itemsEl = [];

            // Create items from JSON
            items.map(function (item) {
                _this.itemsEl.push($('<div class="uo-tbl-item body-row">' + _this.itemTemplate.map(_this.render(item)).join('') + '</div>'));
                return '<div class="uo-tbl-item body-row">' + _this.itemTemplate.map(_this.render(item)).join('') + '</div>';
            });

            // Add items to jPList collection
            this.jpL.jplist({
                command: 'add'
                , commandData: {
                    $items: this.itemsEl,
                    index: 0 //if index is omitted -> the items are added to the end of the list
                }
            });

        },

        render: function (props) {
            return function (tok, i) {
                return (i % 2) ? props[tok] : tok;
            };
        }


    };

    window.ulgmGroupManagement.populateCoursesDropDown = function (data) {

        var courseDropDown = $('#uo-group-report-course');
        courseDropDown.empty();

        $('#course-group-id').val(data.group_id);

        if( data.group_courses.length > 1){
            courseDropDown.append(
                $('<option>', {
                    value: '0',
                    text: ulgmRestApiSetup.localized.selectCourse
                })
            );
        }
        /**/

        $.each(data.group_courses, function (i, course) {

            courseDropDown.append(
                $('<option>', {
                    value: course.ID,
                    text: course.post_title
                })
            );

        });

        courseDropDown.show().trigger('change');

    };

    window.ulgmGroupManagement.populateReportTable = function (data) {

        $('#test').text('');

        var items = window.ulgmGroupManagement.reportingTemplating.items = data.user_course_data;

        if (0 === items.length) {
            $('#test').html('<div class="uo-row uo-jplist-row uo-table-content uo-tbl-item body-row"><div class="uo-table-no-results">There are no records to display.</div></div>');
        }
        else {
            $('#test').closest('.uo-groups-rest-result').show();
            window.ulgmGroupManagement.reportingTemplating.setItems(items);
        }

    };

    window.ulgmGroupManagement.quizReport = {

        uoTable: null,

        uoTableHidden: null,

        quizId: 0,

        groupId: 0,

        courseId: 0,

        elements: {
            select: {
                group: {
                    element: null,
                    options: null
                },
                course: {
                    element: null,
                    options: null,
                    no_element: null
                },
                quiz: {
                    element: null,
                    options: null,
                    no_element: null
                },
            }
        },

        constructor: function () {
            this.elements.select.group.element  = $('#uo-group-report-group');
            this.elements.select.course.element = $('#uo-group-report-courses');
            this.elements.select.quiz.element   = $('#uo-group-report-quizzes');
            this.elements.select.course.no_element = $('#uo-group-report-nocourses');
            this.elements.select.quiz.no_element   = $('#uo-group-report-noquizzes');

            this.elements.select.group.options  = $('#uo-group-report-group option');
            this.elements.select.course.options = $('#uo-group-report-courses option');
            this.elements.select.quiz.options   = $('#uo-group-report-quizzes option');

            this.createTable();
            this.createTableHidden();
            this.addEvents();
        },

        createTable: function (data) {

            var columns = [
                {title: groupQuizReportSetup.localized.firstName},
                {title: groupQuizReportSetup.localized.lastName},
                {title: groupQuizReportSetup.localized.userEmail},
                {title: groupQuizReportSetup.localized.quizScore},
                {title: groupQuizReportSetup.localized.detailedReport},
                {title: groupQuizReportSetup.localized.date}
            ];

            var tableVars = {
                aLengthMenu: [
                    [15, 30, 60, -1],
                    [15, 30, 60, groupQuizReportSetup.localized.all]
                ],
                iDisplayLength: 30,
                columns: columns,
                columnDefs: [{
                    "targets": 2,
                    "orderable": false,
                    "searchable": false
                }]
            };

            if (null !== this.uoTable) {

                this.uoTable.destroy();

                tableVars.data = data;

                tableVars.columns = [
                    {title: groupQuizReportSetup.localized.firstName, data: 'first_name'},
                    {title: groupQuizReportSetup.localized.lastName, data: 'last_name'},
                    {title: groupQuizReportSetup.localized.userEmail, data: 'user_email'},
                    {title: groupQuizReportSetup.localized.quizScore, data: 'quiz_score'},
                    {
                        title: groupQuizReportSetup.localized.detailedReport,
                        orderable: false,
                        searchable: false,
                        data: 'quiz_modal',
                        defaultContent: ''
                    },
                    {title: groupQuizReportSetup.localized.date, data: 'quiz_date'}
                ];

            }
            tableVars.language = {
                "lengthMenu": groupQuizReportSetup.localized.lengthMenu,
                "zeroRecords": groupQuizReportSetup.localized.zeroRecords,
                "info": groupQuizReportSetup.localized.info,
                "infoEmpty": groupQuizReportSetup.localized.infoEmpty,
                "infoFiltered": groupQuizReportSetup.localized.infoFiltered,
                "loadingRecords": groupQuizReportSetup.localized.loadingRecords,
                "emptyTable": groupQuizReportSetup.localized.emptyTable,
                "sSearch": groupQuizReportSetup.localized.sSearch
            };

            this.uoTable = jQuery('#uo-quiz-report-table');

            if ( jQuery('#uo-quiz-report-table').length > 0 ){
                this.uoTable = jQuery('#uo-quiz-report-table').DataTable(tableVars);
            }


        },

        createTableHidden: function (data) {

            var columns = [
                {title: groupQuizReportSetup.localized.firstName, data: 'first_name'},
                {title: groupQuizReportSetup.localized.lastName, data: 'last_name'},
                {title: groupQuizReportSetup.localized.userEmail, data: 'user_email'},
                {title: groupQuizReportSetup.localized.quizScore, data: 'quiz_score'},
                {title: groupQuizReportSetup.localized.date, data: 'quiz_date'}
            ];

            /*var language = [
                "lengthMenu": groupQuizReportSetup.localized.lengthMenu,
                "zeroRecords": groupQuizReportSetup.localized.zeroRecords,
                "info": groupQuizReportSetup.localized.info,
                "infoEmpty": groupQuizReportSetup.localized.infoEmpty,
                "infoFiltered": groupQuizReportSetup.localized.infoFiltered,
                "loadingRecords": groupQuizReportSetup.localized.loadingRecords,
                "emptyTable": groupQuizReportSetup.localized.emptyTable
            ];*/

            var tableVars = {
                iDisplayLength: -1,
                columns: columns,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'csv',
                        text: groupQuizReportSetup.localized.csvExport,
                        title: 'quiz-report'
                    }
                ]
            };

            if ( $.fn.DataTable.isDataTable( '#uo-quiz-report-table-hidden' ) ) {

                $( '#uo-quiz-report-table-hidden' ).DataTable().destroy();

                tableVars.data = data;

                tableVars.columns = [
                    {title: groupQuizReportSetup.localized.firstName, data: 'first_name'},
                    {title: groupQuizReportSetup.localized.lastName, data: 'last_name'},
                    {title: groupQuizReportSetup.localized.userEmail, data: 'user_email'},
                    {title: groupQuizReportSetup.localized.quizScore, data: 'quiz_score'},
                    {title: groupQuizReportSetup.localized.date, data: 'quiz_date'}
                ];

            }

            tableVars.language = {
                "lengthMenu": groupQuizReportSetup.localized.lengthMenu,
                "zeroRecords": groupQuizReportSetup.localized.zeroRecords,
                "info": groupQuizReportSetup.localized.info,
                "infoEmpty": groupQuizReportSetup.localized.infoEmpty,
                "infoFiltered": groupQuizReportSetup.localized.infoFiltered,
                "loadingRecords": groupQuizReportSetup.localized.loadingRecords,
                "emptyTable": groupQuizReportSetup.localized.emptyTable
            };

            this.uoTableHidden = jQuery('#uo-quiz-report-table-hidden');

            if ( this.uoTableHidden.length > 0 ){
                this.uoTableHidden = jQuery('#uo-quiz-report-table-hidden').DataTable(tableVars);
            }

            $('.buttons-csv').show();

        },

        flattenArray: function (array, remove_stats) {

            var flatArray = [];

            jQuery.each(array, function (key, value) {

                var quiz_name = value;
                jQuery.each(value.question, function (key2, value2) {
                    flatArray.push({
                        "quiz_name": value.quiz_name,
                        "first_name": value.first_name,
                        "last_name": value.last_name,
                        "quiz_score": value.quiz_score,
                        "answer": value.answer[key2],
                        "question": value.question[key2]
                    })
                });

            });

            return flatArray;

        },

        create_options: function( source, ids ){
            /*
            * @param source string, values "group", "course", "quiz"
            * @param ids    array,  ids of options that have to be shown
            *
            * @return array of jQuery DOM elements with the option elements
            */

            let options = [];

            // Convert parameters to int
            ids = ids.map( Number );

            // Add empty option
            // if there are more then one option
            if( ids.length > 1 ){
                ids.push(0);
            }


            // Get options by ID
            this.elements.select[source].options.each(function(){
                let $this   = $(this),
                    id      = parseInt( $this.val() );
                $this.show();
                if ( ids.indexOf( id ) != -1 ){
                    options.push( $this );
                }
            });

            // Return options
            return options;
        },

        select_option: function( $select, value ){
            /*
            * @param select  dom element
            * @param value   string, value of the option that has to be selected
            */

            // Remove selected property
            $select.find( 'option' ).prop( 'selected', false );

            // Select option with value = @param value
            $select.find( 'option[value="' + value + '"]' ).prop( 'selected', true );
        },
        __select_option: function( $select, index ){
            /*
            * @param select  dom element
            * @param value   string, value of the option that has to be selected
            */

            // Remove selected property
            $select.find( 'option' ).prop( 'selected', false );

            // Select option with value = @param value
            $select.find( 'option[' + index + ']' ).prop( 'selected', true );
        },
        addEvents: function (){
            var _this = this;

            this.elements.select.group.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Hide Quiz select
                //_this.elements.select.quiz.element.hide();
                _this.elements.select.course.element.show();

                // Group ID
                let group_id = $this.val();
                // Return if course id is 0
                if( group_id == 0){
                    _this.elements.select.course.element.empty();
                    let options_course = _this.create_options( 'course', [0] );
                    _this.elements.select.course.element.html(options_course);
                    _this.elements.select.quiz.element.empty();
                    let options = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options);
                    window.ulgmGroupManagement.quizReport.createTable([]);
                    window.ulgmGroupManagement.quizReport.createTableHidden([]);
                    return;
                }
                // Get relationships
                let courses_to_show = groupQuizReportSetup.courseGroupQuizzes[ group_id ];
                courses_to_show = courses_to_show === undefined ? [] : courses_to_show;

                // Create options
                let options = _this.create_options( 'course', courses_to_show );

                if ( options.length > 0 ){
                     // Show "Select course" dropdown
                    _this.elements.select.course.element.show();
                    _this.elements.select.course.element.html( options );
                    _this.elements.select.course.no_element.hide();
                    _this.elements.select.course.element.html(_this.elements.select.course.element.find('option').sort(function(x, y) {
                        // to change to descending order switch "<" for ">"
                        return $(x).text() > $(y).text() ? 1 : -1;
                    }));
                    // Select empty option

                    _this.__select_option( _this.elements.select.course.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.reporting.groupId = group_id;
                    // trigger change after value set on load
                    _this.elements.select.course.element.trigger('change');
                }
                else {
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.course.element.empty();
                    let options_course = _this.create_options( 'course', [0] );
                    _this.elements.select.course.element.html(options_course);
                    _this.elements.select.quiz.element.empty();
                    let options = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options);
                    window.ulgmGroupManagement.quizReport.createTable([]);
                    window.ulgmGroupManagement.quizReport.createTableHidden([]);
                }
            });

            this.elements.select.course.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Course ID
                let course_id = $this.val();
                // Return if course id is 0
                if( course_id == 0){
                    _this.elements.select.quiz.element.empty();
                    let options = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options);
                    window.ulgmGroupManagement.quizReport.createTable([]);
                    window.ulgmGroupManagement.quizReport.createTableHidden([]);
                    return;
                }

                // Get relationships
                let quizzes_to_show = groupQuizReportSetup.relationships[ window.ulgmGroupManagement.reporting.groupId ][ course_id ];
                quizzes_to_show = quizzes_to_show === undefined ? [] : quizzes_to_show;

                // Create options
                let options = _this.create_options( 'quiz', quizzes_to_show );

                if ( options.length > 0 ) {
                    // Show "Select quiz" dropdown
                    _this.elements.select.quiz.element.show();
                    _this.elements.select.quiz.element.html(options);
                    jQuery('#uo-group-report-quizzes option').show();
                    _this.elements.select.quiz.no_element.hide();

                    // Select empty option
                    _this.__select_option( _this.elements.select.quiz.element, 0 );

                    // Save data in main object
                    window.ulgmGroupManagement.quizReport.courseId = course_id;
                    // trigger change after value set on load
                    _this.elements.select.quiz.element.trigger('change');
                }else{
                    // Hide "Select course" dropdown, the empty option was selected
                    _this.elements.select.quiz.element.empty();
                    let options = _this.create_options( 'quiz', [0] );
                    _this.elements.select.quiz.element.html(options);
                    window.ulgmGroupManagement.quizReport.createTable([]);
                    window.ulgmGroupManagement.quizReport.createTableHidden([]);
                }
            });

            this.elements.select.quiz.element.on('change', function(){
                // Save this DOM element
                let $this = $(this);

                // Quiz ID
                let quiz_id = $this.val();
                // Save data in main object
                window.ulgmGroupManagement.quizReport.quizId = quiz_id;

                // Request data
                window.ulgmGroupManagement.quizReport.getQuizData( quiz_id, window.ulgmGroupManagement.reporting.groupId );
            });

            // Add event listener for opening and closing details
            $('#uo-quiz-report-table').on('click', 'td.details-control', function () {

                var tr = $(this).closest('tr');
                var row = window.ulgmGroupManagement.quizReport.uoTable.row(tr);

                if (row.child.isShown()) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                }
                else {
                    // Open this row
                    row.child(window.ulgmGroupManagement.quizReport.format(row.data())).show();
                    tr.addClass('shown');
                }
            });

        },

        format: function (d) {

            var rows = '';
            $.each(d.answer, function (key, value) {
                rows +=
                    '<tr>' +
                    '<td>' + d.question[key] + '</td>' +
                    '<td>' + value + '</td>' +
                    '</tr>';
            });
            // `d` is the original data object for the row
            return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">' + rows + '</table>';
        },

        getQuizData: function (quizId, groupId) {


            if (!window.ulgmGroupManagement.reporting.isNormalInteger(quizId)) {
                $('#uo-group-report-course').addClass('missing');
                return false;
            }

            if (!window.ulgmGroupManagement.reporting.isNormalInteger(String(groupId))) {
                return false;
            }

            $('#uo-group-report-course').removeClass('missing');

            var i = 0;

            var loading = setInterval(function () {
                i = ++i % 4;
                $("#uo-quiz-report-table tbody").html("<div id='group-loader'>" + groupQuizReportSetup.localized.loadingRecords + new Array(i + 1).join(".") + "</div>");
            }, 500);


            var dataVars = {
                groupId: groupId,
                quizId: quizId
            };

            $.ajax({

                method: "POST",
                data: dataVars,
                url: groupQuizReportSetup.root + 'get_quiz_data/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupQuizReportSetup.nonce);
                },
                success: function (response) {

                    clearInterval(loading);
                    $('#group-loader').remove();

                    window.ulgmGroupManagement.quizReport.createTable(response);
                    window.ulgmGroupManagement.quizReport.createTableHidden(response);


                },
                fail: function (response) {
                    alert('Rest Call Failed');
                }

            });

        }

    };

    window.ulgmGroupManagement.reporting = {

        groupLeaderId: 0,

        groupId: 0,

        getGroupCourses: function (groupId) {

            var dataVars = {groupId: groupId};

            if (this.getQueryVariable('user_id')) {
                window.ulgmGroupManagement.reporting.groupLeaderId = this.getQueryVariable('user_id');
                dataVars.userId = window.ulgmGroupManagement.reporting.groupLeaderId;
            }

            $('#uo-group-report-course').hide();

            $.ajax({

                method: "POST",
                data: dataVars,
                url: groupQuizReportSetup.root + 'get_group_courses/',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('X-WP-Nonce', groupQuizReportSetup.nonce);
                },
                success: function (response) {
                    window.ulgmGroupManagement.reporting.createCourseDropDown(response.courses);

                    if ($('#uo-quiz-report-table').length) {
                        window.ulgmGroupManagement.reporting.createUserDropDown(response.users);
                    }


                },
                fail: function (response) {
                    alert('Rest Call Failed');
                }

            });

        },

        createCourseDropDown: function (posts) {
            var dropDown = $('#uo-group-report-course'),
                options = '<option value="0">' + ulgmRestApiSetup.localized.selectCourse + '</option>';

            if (0 === posts.post_count) {
                dropDown.html('<option value="0">' + ulgmRestApiSetup.localized.noCourse + '</option>');
                return true;
            }

            $.each(posts.posts, function (key, post) {
                options += '<option value="' + post.ID + '">' + post.post_title + '</option>';
            });

            dropDown.html(options);
            dropDown.show();

        },

        createUserDropDown: function (users) {

            var dropDown = $('#uo-group-report-user'),
                options = '<option value="0">' + groupQuizReportSetup.localized.selectUser + '</option>';

            if (0 === users.length) {
                dropDown.html('<option value="0">' + groupQuizReportSetup.localized.noUsers + '/option>');
                return true;
            }

            $.each(users, function (key, user) {
                options += '<option value="' + user.ID + '">' + user.data.display_name + '</option>';
            });

            dropDown.html(options);
            dropDown.show();

        },

        isNormalInteger: function (str) {
            var n = ~~Number(str);
            return String(n) === str && n > 0;
        },

        getQueryVariable: function (variable) {
            var query = window.location.search.substring(1);
            var vars = query.split("&");
            for (var i = 0; i < vars.length; i++) {
                var pair = vars[i].split("=");
                if (pair[0] == variable) {
                    return pair[1];
                }
            }
            return (false);
        }

    }


})(jQuery);