import $ from 'jquery';

/**
 * Performs a REST Call
 * 
 * @return null
 */

export function restCall( parameters ){
    // Define the valid endpoints
    let validEndpoints = [ 'change_user_progress' ];

    console.log( parameters );

    // Check if the endPoint parameter is a valid endpoint
    if ( validEndpoints.includes( parameters.endpoint ) ){
        // Do AJAX
        $.ajax({
            method: 'POST',
            url:    parameters.url + parameters.endpoint + '/',
            data:   $.param( parameters.data ) + '&' + $.param({ doing_rest: 1 }),

            // Attach Nonce the the header of the request
            beforeSend: function( xhr ){
                xhr.setRequestHeader( 'X-WP-Nonce', parameters.nonce );
            },

            success: function( response ){
                console.log( response );

                // Check if onDone is defined
                if ( isDefined( parameters.onDone ) ){
                    // Invoke callback
                    parameters.onDone( response );
                }

                // Check if onSuccess is defined
                if ( isDefined( parameters.onSuccess ) ){
                    // Invoke callback
                    parameters.onSuccess( response );
                }
            },

            statusCode: {
                403: function(){
                    location.reload();
                }
            },

            fail: function ( response ){
                // Check if onDone is defined
                if ( isDefined( parameters.onDone ) ){
                    // Invoke callback
                    parameters.onDone( response );
                }
                
                if ( isDefined( parameters.onFail ) ){
                    parameters.onFail( response );
                }
            },
        });
    }
    else {
        console.error( `The ${ parameters.endpoint } endPoint does not exists` );
    }
}

/**
 * Determine if a variable is set and is not NULL
 *
 * @param  {mixed}      variable - The variable being evaluated
 * @return {boolean}    TRUE if the variable is defined
 */

export const isDefined = ( variable ) => {
	// Returns true if the variable is undefined
    return typeof variable !== 'undefined' && variable !== null;
}

/**
 * Determine whether a variable is empty
 *
 * @param   {mixed}     variable - The variable being evaluated
 * @return  {boolean}   TRUE if the variable is empty
 */

export const isEmpty = ( variable ) => {
    let response = true;

    // Check if the variable is defined, otherwise is empty
    if ( isDefined( variable ) ){
        // Check if it's array
        if ( variable.isArray ){
            response = variable.length == 0;
        }
        else if ( isObject( variable ) ){
            response = Object.keys( variable ).length;
        }
        else {
            response = variable == '';
        }
    }

    return response;
}

/**
 * Determine whether a variable is an object
 *
 * @param   {mixed}     variable - The variable being evaluated
 * @return  {boolean}   TRUE if the variable is an object
 */

export const isObject = ( variable ) => {
    return typeof variable === 'object' && variable !== null;
}