<?php

namespace uncanny_learndash_groups;

/**
 * Class ManagementGroupMultiAddUsers
 * @package uncanny_learndash_groups
 */
class ManagementGroupMultiAddUsers {
	/**
	 * ProcessManualGroupAdminPage constructor.
	 */
	function __construct() {
		//add_action( 'wp_enqueue_scripts', array( $this, 'create_new_group_scripts' ), 30 );
		add_action( 'init', array( $this, 'bulk_add_users' ), 30 );
		//add_shortcode( 'uo_group_multi_add_users', array( $this, 'uo_group_multi_add_users_func' ) );
	}

	public function bulk_add_users() {
		if ( isset( $_GET['action'] ) && 'bulk-add-users' === $_GET['action'] && isset( $_GET['group-id'] ) ) {
			$group_id       = absint( $_GET['group-id'] );
			$first_names    = $_REQUEST['first_name'];
			$last_names     = $_REQUEST['last_name'];
			$emails         = $_REQUEST['email'];
			$error_results  = [];
			$insert_results = [];
			if ( $emails ) {
				$role = apply_filters( 'uo-groups-user-role', get_option( 'default_role', 'subscriber' ) );
				foreach ( $emails as $k => $email ) {
					if ( ! empty( $email ) ) {
						if ( is_email( $email ) ) {
							$first       = $first_names[ $k ];
							$last        = $last_names[ $k ];
							$email       = sanitize_email( $email );
							$is_existing = email_exists( $email );

							if ( is_numeric( $is_existing ) ) {
								$user_id     = $is_existing;
								$user_groups = learndash_get_users_group_ids( $user_id, true );
								if ( in_array( $group_id, $user_groups ) ) {
									$error_results[] = sprintf( __( 'Line #%d: %s is existing user of group.', 'uncanny-learndash-groups' ), $k + 1, $email );
									continue;
								}
								$user_data = array(
									'user_email' => $email,
									'user_id'    => $user_id,
									'first_name' => $first,
									'last_name'  => $last,
									'role'       => $role,
								);

								if ( isset( $user_data['first_name'] ) && ! $is_existing ) {
									update_user_meta( $user_id, 'first_name', $user_data['first_name'] );
								}

								if ( isset( $user_data['last_name'] ) && ! $is_existing ) {
									update_user_meta( $user_id, 'last_name', $user_data['last_name'] );
								}

								$restApi = new RestApiEndPoints();
								$restApi->add_existing_user( $user_data, false, $group_id, 0, 'not redeemed', false );

							} else {
								$user_data = array(
									'user_login' => $email,
									'user_email' => $email,
									'first_name' => $first,
									'last_name'  => $last,
									'role'       => $role,
									'group_id'   => $group_id,
								);
								$restApi   = new RestApiEndPoints();
								$restApi->add_invite_user( $user_data, false, false, false );
							}
							$insert_results[] = sprintf( __( '%s added & invited successfully.', 'uncanny-learndash-groups' ), $email );
						} else {
							$error_results[] = sprintf( __( 'Line #%d: Email (%s) not correct.', 'uncanny-learndash-groups' ), $k + 1, $email );
						}
					} else {
						if ( ! empty( $first_names[ $k ] ) || ! empty( $last_names[ $k ] ) ) {
							$error_results[] = sprintf( __( 'Line #%d: Email field is empty.', 'uncanny-learndash-groups' ), $k + 1 );
						}
					}
				}
			}
			$url = SharedFunctions::get_group_management_page_id( true );
			$url .= '?group-id=' . $group_id;
			$url .= '&bulk=1';
			if ( ! empty( $error_results ) ) {
				$url .= '&bulk-errors=' . urlencode( join( '<br /> ', $error_results ) );
			}
			if ( ! empty( $insert_results ) ) {
				$url .= '&success-invited=' . urlencode( join( '<br /> ', $insert_results ) );
			}
			wp_safe_redirect( $url );
			exit;
		}
	}

	public function create_new_group_scripts() {
		/*global $post;
		if ( has_shortcode( $post->post_content, 'uo_group_multi_add_users' ) ) {
			wp_enqueue_style( 'ulgm-datatables-styles', Utilities::get_vendor( 'datatables/css/jquery.dataTables.min.css' ), [], Utilities::get_version() );
			wp_enqueue_style( 'ulgm-datatables-responsive', Utilities::get_vendor( 'datatables/css/responsive.dataTables.min.css' ), [], Utilities::get_version() );
			wp_enqueue_style( 'ulgm-font-awesome', Utilities::get_vendor( 'fontawesome/css/font-awesome.min.css' ), array(), Utilities::get_version() );

			// Load styles
			wp_register_style( 'ulgm-frontend', Utilities::get_asset( 'frontend', 'bundle.min.css' ), array(), Utilities::get_version() );
			$user_colors = Utilities::user_colors();
			wp_add_inline_style( 'ulgm-frontend', $user_colors );
			wp_enqueue_style( 'ulgm-frontend', $user_colors );
		}*/
	}


	/**
	 * Create Theme Options page
	 *
	 * @since 1.0.0
	 */
	public function uo_group_multi_add_users_func() {
		if ( is_user_logged_in() ) {
			include Utilities::get_template( 'frontend-uo_groups/add-users.php' );
		}
	}

}