<?php

namespace uncanny_learndash_groups;

?>

<section id="group-management-users" class="users box jplist">
	<!-- Courses -->
	<div class="uo-row uo-groups-section uo-groups-group-courses">
		<?php
		$learn_dash_labels     = new \LearnDash_Custom_Label();
		$course_label_singular = $learn_dash_labels::get_label( 'course' );
		$course_label_plural   = $learn_dash_labels::get_label( 'courses' );

		$group_id          = self::$ulgm_current_managed_group_id;
		$courses           = get_posts( array(
			'post_type'     => 'sfwd-courses',
			'meta_key'      => 'learndash_group_enrolled_' . $group_id,
			'post_per_page' => - 1,
			'numberposts'   => - 1
		) );
		$number_of_courses = count( $courses );

		?>
		<div class="uo-row uo-header">
			<h2 class="group-courses-heading uo-looks-like-h3">
				<?php printf( _x( 'Group %s', '%s is the "courses" LearnDash label', 'uncanny-learndash-groups' ), $course_label_plural ); ?>
			</h2>
			<p class="uo-header-subtitle">
				<span>
					<?php

					if ( $number_of_courses == 1 ) {
						printf( _x( '1 %s', '%1$s is the "course" LearnDash label', 'uncanny-learndash-groups' ), $course_label_singular );
					} else {
						printf( _x( '%1$s %2$s', '%1$s is a number, %2$s is the "courses" LearnDash label', 'uncanny-learndash-groups' ), $number_of_courses, $course_label_plural );
					}

					?>
				</span>
			</p>
		</div>

		<?php

		if ( $add_courses_button ) {

			if ( 'yes' === get_post_meta( GroupManagementInterface::$ulgm_current_managed_group_id, '_uo_custom_group', true ) && Utilities::if_woocommerce_active() ) {

				?>

				<!-- Add Courses button -->
				<div class="uo-row uo-groups-actions">
					<button class="ulgm-link uo-btn uo-left"
							onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['buy_courses_link']; ?>'"
							type="button">
						<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['buy_courses']; ?>
					</button>
				</div>

				<?php

			}

		}

		?>

		<div class="uo-row uo-groups-group-courses-list">
			<div class="group-courses-list">
				<ul class="list-of-courses uo-list">
					<?php
					if ( $courses ) {
						foreach ( $courses as $course ) {
							?>
							<li><a href="<?php echo get_permalink( $course ); ?>"><?php echo $course->post_title; ?></a>
							</li>
						<?php }
					}
					?>
				</ul>
			</div>
		</div>
	</div>

	<!-- Enrolled Users -->
	<div class="uo-row uo-groups-section uo-groups-enrolled-users">
		<div class="uo-row uo-header">
			<h2 class="group-table-heading uo-looks-like-h3"><?php _e( 'Enrolled Users', 'uncanny-learndash-groups' ); ?></h2>
			<div class="uo-row uo-header-subtitle">
				<?php

				if ( $seats_quantity ) {

					?>

                    <p class="uo-header-subtitle">
						<div class="group-management-total uo-inline">
							<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['x_users_enrolled']; ?>
						</div>
					</p>
					<span class="uo-subtitle-of-h3">
						<div class="group-management-total uo-inline">
							<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['x_seats_remaining']; ?>
							/ <?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['x_total_seats']; ?>
						</div>
					</span>

					<?php

				}

				?>

				<?php

				if ( $add_seats_button ) {

					if ( Utilities::if_woocommerce_active() && empty( get_post_meta( GroupManagementInterface::$ulgm_current_managed_group_id, '_ulgm_is_upgraded', true ) ) && empty( get_post_meta( GroupManagementInterface::$ulgm_current_managed_group_id, '_ulgm_is_custom_group_created', true ) ) && empty( get_post_meta( GroupManagementInterface::$ulgm_current_managed_group_id, '_uo_subscription_group', true ) ) ) {

						?>
						<!-- Add Seats -->
						<button class="ulgm-link uo-btn uo-inline uo-btn--small"
								onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['add_seats_link']; ?>'"
								type="button">
							<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['add_seats']; ?>
						</button>

						<?php

					}

				}

				?>
			</div>
		</div>

		<!-- Actions & Search -->
		<div class="user-table-actions">
			<div class="uo-row uo-groups-actions">
				<div class="group-management-buttons">
					<div class="group-management-buttons__left">
						<!-- Add Users -->
						<?php

						if ( $add_user_button ) {

							?>

							<?php if ( absint( SharedFunctions::remaining_seats( GroupManagementInterface::$ulgm_current_managed_group_id ) ) ) { ?>
								<div class="uo-groups-list-of-btns uo-inline-block uo-left" id="uo_add_users_button"
									 data-id="add-users">
									<div class="uo-btn uo-groups-list-of-btns-main" data-direction="right"
										 data-id="add-users">
										<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['add_user']; ?>
									</div>
									<div class="uo-groups-list">
										<button class="ulgm-modal-link uo-btn uo-left"
												data-modal-id="#group-management-add-user" rel="modal:open">
											<?php _e( 'One user', 'uncanny-learndash-groups' ); ?>
										</button>

										<button class="ulgm-modal-link uo-btn uo-left" id="uo-open-bulk-add">
											<?php _e( 'Multiple users', 'uncanny-learndash-groups' ); ?>
										</button>
									</div>
								</div>

							<?php } ?>

							<!-- Add Users Modal box -->
							<div id="group-management-add-user" class="group-management-modal" style="display:none;">
								<div class="uo-groups">
									<div class="group-management-form">
										<div class="group-management-rest-message"></div>

										<div class="uo-row">
											<div>
												<label class="uo-radio">
													<input class="uo-radio-input" type="radio" name="action"
														   id="add_invite" value="add-invite">
													<span class="uo-radio-checkmark"></span>
												</label>

												<label for="add_invite"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['add_invite_user']; ?></label>
											</div>
											<div>
												<?php if ( $key_options ) { ?>

													<label class="uo-radio">
														<input class="uo-radio-input" type="radio" name="action"
															   id="send_enrollment" value="send-enrollment">
														<span class="uo-radio-checkmark"></span>
													</label>

													<label for="send_enrollment"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['send_enrollment_key']; ?></label>

												<?php } ?>
											</div>
										</div>

										<!--<div class="uo-row">
											<label class="uo-radio">
												<input class="uo-radio-input" type="radio" name="action" id="add_existing_user" value="add-existing-user">
												<span class="uo-radio-checkmark"></span>
											</label>

											<label for="add_existing_user"><?php /*echo GroupManagementInterface::$ulgm_management_shortcode['text']['add_existing_user']; */ ?></label>
										</div>-->

										<input type="hidden" name="group-id" id="group-id"
											   value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>">

										<div class="uo-row">
											<label for="first-name">
												<div class="uo-row__title">
													<?php _e( 'First Name*', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<input class="uo-input" type="text" name="first_name" id="first-name"
												   value="">
										</div>

										<div class="uo-row">
											<label for="last-name">
												<div class="uo-row__title">
													<?php _e( 'Last Name*', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<input class="uo-input" type="text" name="last_name" id="last-name"
												   value="">
										</div>

										<div class="uo-row">
											<label for="email">
												<div class="uo-row__title">
													<?php _e( 'Email*', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<input class="uo-input" type="text" name="email" id="email" value="">
										</div>

										<div class="uo-row-footer">
											<div style="margin-bottom: 15px" class="uo-modal-spinner"></div>

											<button class="uo-btn submit-group-management-form"
													data-end-point="add_user"><?php _e( 'Add User', 'uncanny-learndash-groups' ); ?></button>
										</div>
									</div>
								</div>
							</div>

							<?php

						}

						?>

						<?php

						if ( $remove_user_button ) {

							?>

							<!-- Remove Users -->
							<div class="group-user-management-buttons uo-hidden">
								<button class="ulgm-modal-link uo-btn uo-left"
										data-modal-id="#group-management-remove-user"
										rel="modal:open"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['remove_users']; ?></button>
							</div>

							<div id="group-management-remove-user" class="group-management-modal" style="display:none;">
								<div class="uo-groups">
									<div class="group-management-form">
										<div class="group-management-rest-message"></div>

										<input type="hidden" id="removing-users" name="removing-users" value="">

										<div class="uo-row">
											<?php echo sprintf(
												__( 'Are you sure you want to remove %s user(s)?', 'uncanny-learndash-groups' ),
												'<span class="amount-users"></span>'

											); ?>
										</div>

										<input type="hidden" name="action" id="remove-users" value="remove-users">
										<input type="hidden" name="group-id" id="group-id"
											   value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>">

										<div class="uo-row-footer">
											<div style="margin-bottom: 15px" class="uo-modal-spinner"></div>
											<button class="uo-btn submit-group-management-form"
													data-end-point="remove_users">
												<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['remove_users']; ?>
											</button>
										</div>
									</div>
								</div>
							</div>

							<?php

						}

						?>
					</div>

					<div class="group-management-buttons__right">

						<?php

						if ( $add_group_email_button ) {

							?>

							<button class="ulgm-modal-link uo-btn uo-right uo-btn--email-users"
									data-modal-id="#group-management-email-users"
									rel="modal:open"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['email_users']; ?></button>
							<!-- Upload Users Modal box -->
							<div id="group-management-email-users"
								 class="group-management-modal group-management-email-users" style="display:none;">
								<div class="uo-groups">
									<div class="group-management-form">
										<div class="group-management-rest-message"></div>

										<input id="group_email_group_id" type="hidden" name="group_email_group_id"
											   value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>"/>
										<input id="group_email_nonce" type="hidden" name="group_email_nonce"
											   value="<?php echo wp_create_nonce( 'group_email_nonce_' . GroupManagementInterface::$ulgm_current_managed_group_id . '_' . $user->ID ); ?>"/>

										<!-- Email Group feature below the Group Table (on the Group Leader page) -->
										<div class="uo-row">
											<label for="group_email_fromname">
												<div class="uo-row__title">
													<?php esc_html_e( 'From Name:', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<?php echo $user->display_name; ?>
										</div>
										<div class="uo-row">
											<label for="group_email_fromemail">
												<div class="uo-row__title">
													<?php esc_html_e( 'From Email:', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<?php echo ! empty( get_option( 'ulgm_email_from', '' ) ) ? get_option( 'ulgm_email_from', '' ) : $user->user_email; ?>
										</div>
										<div class="uo-row">
											<label for="group_email_replytoemail">
												<div class="uo-row__title">
													<?php esc_html_e( 'Reply-to Email:', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<?php echo $user->user_email; ?>
										</div>
										<div class="uo-row">
											<label for="group_email_replytoemail">
												<div class="uo-row__title">
													<?php esc_html_e( 'Email users with status:', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<label>
												<div class="uo-row-checkbox">
													<input type="checkbox" name="group_email_status[]" checked="checked" value="not-started">
													<span class="uo-row-checkbox__label"><?php _e( 'Not started', 'uncanny-learndash-groups' ); ?></span>
												</div>
											</label>
											<label>
												<div class="uo-row-checkbox">
													<input type="checkbox" name="group_email_status[]" checked="checked" value="in-progress">
													<span class="uo-row-checkbox__label"><?php _e( 'In progress', 'uncanny-learndash-groups' ); ?></span>
												</div>
											</label>
											<label>
												<div class="uo-row-checkbox">
													<input type="checkbox" name="group_email_status[]" checked="checked" value="completed">
													<span class="uo-row-checkbox__label"><?php _e( 'Completed', 'uncanny-learndash-groups' ); ?></span>
												</div>
											</label>
										</div>

										<div class="uo-row">
											<label for="group_email_sub">
												<div class="uo-row__title">
													<?php esc_html_e( 'Email Subject:', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<input id="group_email_sub" name="group_email_sub"
												   class="uo-input group_email_sub"/>
										</div>
										<div class="uo-row">
											<label for="text">
												<div class="uo-row__title">
													<?php esc_html_e( 'Email Message:', 'uncanny-learndash-groups' ); ?>
												</div>
											</label>
											<div class="group_email_text">
												<textarea name="group_email_text" id="group_email_text"></textarea>
											</div>
										</div>

										<div class="uo-row-footer">
											<div style="margin-bottom: 15px" class="uo-modal-spinner"></div>

											<button id="email_group" class="uo-btn submit-group-management-form"
													type="button"
													data-end-point="email_users"><?php esc_html_e( 'Send', 'uncanny-learndash-groups' ); ?></button>

										</div>
									</div>
								</div>
							</div>
							<?php
						}
						?>

						<?php

						if ( $upload_users_button ) {

							?>

							<!-- Upload Users -->
							<?php if ( absint( SharedFunctions::remaining_seats( GroupManagementInterface::$ulgm_current_managed_group_id ) ) ) { ?>
								<button class="ulgm-modal-link uo-btn uo-right uo-btn--upload-users"
										data-modal-id="#group-management-upload-users"
										rel="modal:open"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['upload_users']; ?></button>
							<?php } ?>
							<!-- Upload Users Modal box -->
							<div id="group-management-upload-users" class="group-management-modal"
								 style="display:none;">
								<div class="uo-groups">
									<div class="group-management-form">
										<div class="group-management-rest-message"></div>

										<div id="group-management-title">
											<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['modal_x_seats_remaining']; ?>
										</div>

										<div class="uo-row">
											<div>
												<label class="uo-radio">
													<input class="uo-radio-input" type="radio" name="action"
														   id="add-invite" value="add-invite">
													<span class="uo-radio-checkmark"></span>
												</label>

												<label for="add-invite"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['add_invite_users']; ?></label>
											</div>
											<div>
												<?php if ( $key_options ) { ?>

													<label class="uo-radio">
														<input class="uo-radio-input" type="radio" name="action"
															   id="send-enrollment" value="send-enrollment">
														<span class="uo-radio-checkmark"></span>
													</label>

													<label for="send-enrollment"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['send_enrollment_keys']; ?></label>

												<?php } ?>
											</div>
											<div>
												<?php if ( $key_options ) { ?>

													<label class="uo-checkbox">
														<input class="uo-checkbox-input" type="checkbox"
															   name="not-send-emails" id="not-send-emails"
															   value="not-send-emails">
														<span class="uo-checkbox-checkmark"></span>
													</label>

													<label for="not-send-emails"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['do_not_send_emails']; ?></label>

												<?php } ?>
											</div>
										</div>

										<input type="hidden" name="group-id" id="group-id"
											   value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>">

										<div class="uo-row">
											<label for="csv-file">
												<div class="uo-row__title">
													<?php _e( 'Upload CSV File', 'uncanny-learndash-groups' ); ?>
												</div>
												<div class="uo-row__description">
													<?php printf( __( 'Note: Empty values in the %s column will generate a random password for the user.', 'uncanny-learndash-groups' ), '<em>user_pass</em>' ); ?>
												</div>
											</label>
											<input type="file" name="csv-file" id="csv-file" style="border: 0"/>
											<input type="hidden" name="csv-text" id="csv-text" value=""/>
											<div>
												<a href="<?php echo Utilities::get_sample( 'group_management_user_upload.csv' ); ?>"><?php _e( 'Download a sample .csv file', 'uncanny-learndash-groups' ) ?></a>
											</div>
										</div>

										<div class="uo-row-footer">
											<div style="margin-bottom: 15px" class="uo-modal-spinner"></div>

											<button class="uo-btn submit-group-management-form"
													data-end-point="upload_users"><?php _e( 'Add Users', 'uncanny-learndash-groups' ); ?></button>
										</div>
									</div>
								</div>
							</div>

							<?php

						}

						?>

						<?php

						if ( $download_keys_button ) {

							?>

							<!-- Download Keys -->
							<div class="group-management-form uo-right uo-btn--download-keys">
								<input type="hidden" name="action" id="download" value="download">
								<input type="hidden" name="group-id" id="group-id"
									   value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>">
								<button class="submit-group-management-form uo-btn uo-right"
										data-end-point="download_keys_csv"><?php _e( 'Download Keys', 'uncanny-learndash-groups' ); ?></button>
							</div>

							<?php

						}

						?>

						<?php
						if ( $progress_management_report_button && ! empty( SharedFunctions::get_group_management_page_id( true ) ) ) {

							?>

							<button class="ulgm-link uo-btn uo-right uo-btn--progress-report"
									onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress_link']; ?>'"
									type="button">
								<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress']; ?>
							</button>

							<?php

						}


						?>

						<?php

						if ( $quiz_report_button && ! empty( SharedFunctions::$group_quiz_report_page_id ) ) {

							?>

							<!-- Quiz Report -->
							<button class="ulgm-link uo-btn uo-right uo-btn--quiz-report"
									onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_quiz_progress_link']; ?>'"
									type="button">
								<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_quiz_progress']; ?>
							</button>

							<?php

						}

						if ( ! empty( SharedFunctions::get_group_manage_progress_report_page_id( true ) ) ) {

							?>

							<!-- Manage Progress Report a-->
							<button class="ulgm-link uo-btn uo-right uo-btn--progress-report"
									onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress_management_link']; ?>'"
									type="button">
								<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress_management']; ?>
							</button>

							<?php

						}

						?>

						<?php

						if ( $assignment_button && ! empty( SharedFunctions::$group_assignment_report_page_id ) ) {

							?>

							<!-- Quiz Report -->
							<button class="ulgm-link uo-btn uo-right uo-btn--quiz-report"
									onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_assignment_link']; ?>'"
									type="button">
								<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_assignment_page']; ?>
							</button>

							<?php

						}

						?>

						<?php

						if ( $essay_button && ! empty( SharedFunctions::$group_essay_report_page_id ) ) {

							?>

							<!-- Quiz Report -->
							<button class="ulgm-link uo-btn uo-right uo-btn--quiz-report"
									onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_essay_link']; ?>'"
									type="button">
								<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_essay_page']; ?>
							</button>

							<?php

						}

						?>

						<!-- List of actions to show on small screens -->
						<div class="uo-groups-list-of-btns uo-inline-block show-in-mobile-only uo-right"
							 data-id="general-actions">
							<div class="uo-btn uo-right uo-groups-list-of-btns-main" id="uo-groups-action-users"
								 data-direction="left" data-id="general-actions">
								<?php _e( 'Actions', 'uncanny-learndash-groups' ); ?>
							</div>
							<div class="uo-groups-list">
								<?php

								if ( $add_group_email_button ) {

									?>

									<button class="ulgm-modal-link uo-btn uo-right"
											data-modal-id="#group-management-email-users"
											rel="modal:open"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['email_users']; ?></button>

									<?php

								}

								?>
								<?php

								if ( $upload_users_button ) {

									?>

									<?php if ( absint( SharedFunctions::remaining_seats( GroupManagementInterface::$ulgm_current_managed_group_id ) ) ) { ?>
										<button class="ulgm-modal-link uo-btn uo-right"
												data-modal-id="#group-management-upload-users"
												rel="modal:open"><?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['upload_users']; ?></button>
									<?php } ?>

									<?php

								}

								?>

								<?php

								if ( $download_keys_button ) {

									?>

									<div class="group-management-form uo-right">
										<input type="hidden" name="action" id="download" value="download">
										<input type="hidden" name="group-id" id="group-id"
											   value="<?php echo GroupManagementInterface::$ulgm_current_managed_group_id; ?>">
										<button class="submit-group-management-form uo-btn uo-right"
												data-end-point="download_keys_csv"><?php _e( 'Download Keys', 'uncanny-learndash-groups' ); ?></button>
									</div>

									<?php

								}

								?>

								<?php

								if ( $progress_report_button && ! empty( SharedFunctions::$group_report_page_id ) ) {

									?>

									<!-- Progress Report -->
									<button class="ulgm-link uo-btn"
											onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress_link']; ?>'"
											type="button">
										<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress']; ?>
									</button>

									<?php

								}

								?>

								<?php

								if ( $quiz_report_button && ! empty( SharedFunctions::$group_quiz_report_page_id ) ) {

									?>

									<button class="ulgm-link uo-btn uo-right"
											onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_quiz_progress_link']; ?>'"
											type="button">
										<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_quiz_progress']; ?>
									</button>

									<?php

								}

								if ( ! empty( SharedFunctions::get_group_manage_progress_report_page_id() ) ) {

									?>

									<!-- Manage Progress Report -->
									<button class="ulgm-link uo-btn uo-right"
											onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress_management_link']; ?>'"
											type="button">
										<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_progress_management']; ?>
									</button>

									<?php

								}

								?>

								<?php

								if ( $assignment_button && ! empty( SharedFunctions::$group_assignment_report_page_id ) ) {

									?>
									<button class="ulgm-link uo-btn uo-right"
											onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_assignment_link']; ?>'"
											type="button">
										<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_assignment_page']; ?>
									</button>

									<?php

								}

								?>

								<?php

								if ( $essay_button && ! empty( SharedFunctions::$group_essay_report_page_id ) ) {

									?>
									<button class="ulgm-link uo-btn uo-right"
											onclick="location.href='<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_essay_link']; ?>'"
											type="button">
										<?php echo GroupManagementInterface::$ulgm_management_shortcode['text']['group_essay_page']; ?>
									</button>

									<?php

								}

								?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="uo-row uo-groups-search">
				<div class="jplist-panel box panel-top">
					<div class="text-filter-box">
						<div class="uo-input-icon">
							<span class="uo-input-the-icon">
								<i class="fa fa-search"></i>
							</span>
							<input data-path=".first-name, .email, .last-name" type="text" value=""
								   placeholder="<?php _e( 'Search', 'uncanny-learndash-groups' ); ?>"
								   class="uo-input uo-input--big up-groups-search-input" data-control-type="textbox"
								   data-control-name="search-filter" data-control-action="filter">
						</div>
					</div>
				</div>
			</div>
		</div>