<?php

namespace uncanny_learndash_groups;

/**
 * [uo_groups_course_report]'s template
 */

?>

<div class="uo-groups uo-reports">
	<section id="group-report" class="box jplist">
		<?php

		// User is a group leader, get users groups
		$user_groups = learndash_get_administrators_group_ids( get_current_user_id(), true );

		if ( empty( $user_groups ) ) {
			?>

			<div class="uo-row">
				<div class="uo-groups-message uo-groups-message-info">
					<?php _e( 'You are not a leader of any groups.', 'uncanny-learndash-groups' ); ?>
				</div>
			</div>

			<?php

			return;
		}

		?>

		<?php

		$posts_in = array_map( 'intval', $user_groups );

		$args = array(
			'post_type'      => 'groups',
			'post__in'       => $posts_in,
			'posts_per_page' => 9999,
			'orderby'        => 'title',
			'order'          => 'ASC'
		);

		$the_query = new \WP_Query( $args );

		$group_label = \LearnDash_Custom_Label::get_label( 'group' );

		$drop_down        = '<option value="0">' . __( 'Select Group', 'uncanny-learndash-groups' ) . '</option>';
		$drop_down_course = '<option value="0">' . sprintf( __( 'Select %s', 'uncanny-learndash-groups' ), \LearnDash_Custom_Label::get_label( 'course' ) ) . '</option>';

		$group_names = array();

		if ( 1 === count( $posts_in ) ) {
			$single_drop_class = 'h3-select';
			$drop_down         .= '<option value="' . $the_query->posts[0]->ID . '">' . $the_query->posts[0]->post_title . '</option>';
			$group_names[]     = $the_query->posts[0]->post_title;

		} else {
			$single_drop_class = 'pre-select';

			if ( $the_query->have_posts() ) {
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					$group_users = learndash_get_groups_user_ids( get_the_ID() );

					if ( empty( $group_users ) ) {
						$drop_down .= '<option value="' . get_the_ID() . '">' . get_the_title() . __( '(no users)', 'uncanny-learndash-groups' ) . '</option>';
					} else {
						$drop_down     .= '<option value="' . get_the_ID() . '">' . get_the_title() . '</option>';
						$group_names[] = get_the_title();
					}

				}

				/* Restore original Post Data */
				wp_reset_postdata();

			} else {
				// no posts found
				$drop_down = '<option>' . __( 'No Groups', 'uncanny-learndash-groups' ) . '</option>';
			}
		}

		$cell = array(
			'first-name'       => array(
				'css-classes' => 'header-report-first-name',
				'cell-width'  => ( absint( self::$user_id ) ) ? '1_5' : '2',
				'show-sort'   => true
			),
			'last-name'        => array(
				'css-classes' => 'header-report-last-name',
				'cell-width'  => ( absint( self::$user_id ) ) ? '1_5' : '1_5',
				'show-sort'   => true
			),
			'email'            => array(
				'css-classes' => 'header-report-email',
				'cell-width'  => ( absint( self::$user_id ) ) ? '2' : '2_5',
				'show-sort'   => false
			),
			'percent-complete' => array(
				'css-classes' => 'header-report-complete',
				'cell-width'  => ( absint( self::$user_id ) ) ? '1_5' : '2',
				'show-sort'   => false
			),
			'date-completed'   => array(
				'css-classes' => 'header-report-date',
				'cell-width'  => ( absint( self::$user_id ) ) ? '1_5' : '2',
				'show-sort'   => false
			)
		);

		if ( absint( self::$user_id ) ) {
			$cell['course-name'] = array(
				'css-classes' => 'header-report-course',
				'cell-width'  => '2',
				'show-sort'   => false
			);
		}

		?>

		<style>
			.uo-groups .uo-select select.h3-select {
				background: none !important;
				border: none;
				-webkit-box-shadow: none;
				box-shadow: none;
				font-size: 18px;
				font-weight: bold;
				padding-left: 0;
				padding-top: 0;
				/*for firefox*/
				-moz-appearance: none;
				/*for chrome*/
				-webkit-appearance: none;
			}

			/*for IE10*/
			.uo-groups .uo-select select.h3-select::-ms-expand {
				display: none;
			}
		</style>

		<script>
            jQuery(document).ready(function () {

                let groupSelect = jQuery('#group-id')
                if (groupSelect.hasClass('h3-select')) {

                    let groupID = jQuery(groupSelect.find('option')[1]).val()
                    groupSelect.val(groupID).trigger('change')

                    let pseudoEvent = {}
                    pseudoEvent.currentTarget = groupSelect
                    window.ulgmGroupManagement.restForms.sendRestCall(pseudoEvent)
                    if (groupSelect.hasClass('h3-select')) {
                        groupSelect.prop('disabled', 'disabled')
                    }

                }

            })

            // The download function takes a CSV string, the filename and mimeType as parameters
            // Scroll/look down at the bottom of this snippet to see how download is called
            var uoDownloadCSV = function () {

                var content = uoGetCSVContent()

                var current_user = getAllUrlParams()

                var fileName = 'groups-report'

                if (typeof current_user.user_id === 'undefined') {
                    var course = jQuery('#uo-group-report-course option:selected').text()
                    fileName += '-' + course;
                } else {

                    var firstName = window.ulgmGroupManagement.reportingTemplating.items[Object.keys(window.ulgmGroupManagement.reportingTemplating.items)[0]].first_name;
                    var lastName = window.ulgmGroupManagement.reportingTemplating.items[Object.keys(window.ulgmGroupManagement.reportingTemplating.items)[0]].last_name;

                    if ('' !== firstName && '' !== lastName) {
                        fileName += '-for-user-' + firstName + '-' + lastName;
                    } else {
                        fileName += '-for-user-id-' + current_user.user_id
                    }
                }

                fileName += '.csv'

                var mimeType = 'application/octet-stream'

                var a = document.createElement('a')

                if (navigator.msSaveBlob) { // IE10
                    navigator.msSaveBlob(new Blob([content], {
                        type: mimeType
                    }), fileName)
                } else if (URL && 'download' in a) { //html5 A[download]
                    a.href = URL.createObjectURL(new Blob([content], {
                        type: mimeType
                    }))
                    a.setAttribute('download', fileName)
                    document.body.appendChild(a)
                    a.click()
                    document.body.removeChild(a)
                } else {
                    location.href = 'data:application/octet-stream,' + encodeURIComponent(content) // only this mime type is supported
                }
            }

            function uoGetCSVContent() {
                var items = window.ulgmGroupManagement.reportingTemplating.items

                var data = []

                var header = Object.keys(items[0])

                items = Object.values(items)

                var data = data.concat(items)

                // Building the CSV from the Data two-dimensional array
                // Each column is separated by ";" and new line "\n" for next row
                var csvContent = header.join(',') + '\n'

                data.forEach(function (infoArray, index) {
                    dataString = [
                        infoArray.user_id,
                        infoArray.first_name,
                        infoArray.last_name,
                        infoArray.user_email,
                        infoArray.date_completed.replace(/,/g, ''),
                        infoArray.percent_completed,
                        infoArray.course_name
                    ].join(',')

                    csvContent += index < data.length ? dataString + '\n' : dataString
                })

                console.log(csvContent)

                return csvContent
            }

            function getAllUrlParams(url) {

                // get query string from url (optional) or window
                var queryString = url ? url.split('?')[1] : window.location.search.slice(1)

                // we'll store the parameters here
                var obj = {}

                // if query string exists
                if (queryString) {

                    // stuff after # is not part of query string, so get rid of it
                    queryString = queryString.split('#')[0]

                    // split our query string into its component parts
                    var arr = queryString.split('&')

                    for (var i = 0; i < arr.length; i++) {
                        // separate the keys and the values
                        var a = arr[i].split('=')

                        // in case params look like: list[]=thing1&list[]=thing2
                        var paramNum = undefined
                        var paramName = a[0].replace(/\[\d*\]/, function (v) {
                            paramNum = v.slice(1, -1)
                            return ''
                        })

                        // set parameter value (use 'true' if empty)
                        var paramValue = typeof(a[1]) === 'undefined' ? true : a[1]

                        // (optional) keep case consistent
                        paramName = paramName.toLowerCase()
                        paramValue = paramValue.toLowerCase()

                        // if parameter name already exists
                        if (obj[paramName]) {
                            // convert value to array (if still string)
                            if (typeof obj[paramName] === 'string') {
                                obj[paramName] = [obj[paramName]]
                            }
                            // if no array index number specified...
                            if (typeof paramNum === 'undefined') {
                                // put the value on the end of the array
                                obj[paramName].push(paramValue)
                            }
                            // if array index number specified...
                            else {
                                // put the value at that index number
                                obj[paramName][paramNum] = paramValue
                            }
                        }
                        // if param name doesn't exist yet, set it
                        else {
                            obj[paramName] = paramValue
                        }
                    }
                }

                return obj
            }

		</script>
		<?php
		global $post;
		if ( ! empty( SharedFunctions::get_group_management_page_id() ) && $post->ID === SharedFunctions::get_group_report_page_id() ): ?>
			<div class="uo-row uo-groups-section uo-groups-report-go-back">
				<div class="uo-groups-actions">
					<div class="group-management-buttons">
						<button class="ulgm-link uo-btn uo-left uo-btn-arrow-left"
								onclick="location.href='<?php echo GroupReportsInterface::$ulgm_reporting_shortcode['text']['group_management_link']; ?>'"
								type="button">
							<?php echo GroupReportsInterface::$ulgm_reporting_shortcode['text']['group_management']; ?>
						</button>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<div class="uo-row uo-groups-section uo-groups-selection">

			<div class="uo-groups-select-filters">
				<div class="uo-row uo-groups-select-group" <?php if ( 0 !== self::$user_id ) {
					echo 'style="display:none"';
				} ?>>
					<?php

					if ( 0 !== self::$user_id ) {
						?>
						<div id="auto-run" class="group-management-form" data-end-point="get_user_course_data">

							<input type="hidden" id="action" name="action" value="get-user-data-courses">
							<input type="hidden" id="group-id" name="group-id" value="all">
							<input type="hidden" id="group-id" name="course-id" value="all">
							<input type="hidden" id="course-group-id" name="course-group-id" value="all">
							<input type="hidden" id="user-id" name="user-id" value="<?php echo self::$user_id; ?>">

							<div class="uo-modal-spinner"></div>
							<div class="group-management-rest-message"></div>
						</div>
						<script>
                            jQuery(document).ready(function () {
                                var auto = {
                                    currentTarget: document.getElementById('auto-run')
                                }
                                window.ulgmGroupManagement.restForms.sendRestCall(auto)
                            })

						</script>
					<?php

					} else {

					?>
						<div class="group-management-form">

							<input type="hidden" id="action" name="action" value="get-courses">
							<input type="hidden" id="course-order" name="course-order"
								   value="<?php echo self::$course_order; ?>">

							<div class="uo-select">
								<label><?php _e( 'Group', 'uncanny-learndash-groups' ); ?></label>
								<select class="change-group-management-form <?php echo $single_drop_class; ?>"
										id="group-id"
										name="group-id" data-end-point="get_group_courses">
									<?php echo $drop_down; ?>
								</select>
							</div>

							<div class="uo-modal-spinner"></div>
							<div class="group-management-rest-message"></div>
						</div>
						<?php
					}

					?>
				</div>


				<div class="uo-row uo-groups-select-list" <?php if ( 0 !== self::$user_id ) {
					echo 'style="display:none"';
				} ?>>
					<div class="group-management-form">

						<input type="hidden" id="action" name="action" value="get-user-data-courses">
						<input type="hidden" id="course-group-id" name="course-group-id" value="">


						<div class="uo-select">
							<label><?php _e( \LearnDash_Custom_Label::get_label( 'course' ), 'uncanny-learndash-groups' ); ?></label>
							<select class="change-group-management-form " id="uo-group-report-course"
									id="course-id" name="course-id" data-end-point="get_user_course_data">
								<?php echo $drop_down_course; ?>
							</select>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="uo-row uo-groups-rest-result" id="uo-group-progress-report">
			<div class="uo-row uo-groups-actions">
				<div class="user-table-actions">
					<div class="group-management-buttons">
						<button class="ulgm-link uo-btn uo-right" onclick="uoDownloadCSV()" type="button">
							Export CSV
						</button>
					</div>
				</div>
			</div>
			<div class="uo-row uo-groups-search">
				<div class="user-table-actions">
					<div class="group-management-buttons search">
						<!-- panel -->
						<div class="jplist-panel box panel-top">
							<!-- filter by everything -->
							<div class="text-filter-box">
								<!--[if lt IE 10]>
								<div class="jplist-label"><?php _e('User Search:', 'uncanny-learndash-groups'); ?></div>
								<![endif]-->

								<div class="uo-input-icon">
									<span class="uo-input-the-icon">
										<i class="fa fa-search"></i>
									</span>
									<input data-path=".first-name, .last-name, .email, .percent-complete, .date-completed, .course-name"
										   type="text" value=""
										   placeholder="<?php _e( 'Search', 'uncanny-learndash-groups' ); ?>"
										   data-control-type="textbox"
										   data-control-name="search-filter" data-control-action="filter"
										   class="uo-input uo-input--big up-groups-search-input">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="uo-row uo-groups-table">
				<div class="uo-table uo-jplist">
					<div class="box text-shadow">
						<div class="uo-group-report-table uo-pseudo-table">

							<!-- Header -->
							<div class="uo-row uo-table-row uo-table-header">
								<header class="jplist-panel pseudo-table-header">
									<div class="uo-row"
										 data-control-type="sort-buttons-group" data-control-name="header-sort-buttons"
										 data-control-action="sort" data-mode="single"
										 data-datetime-format="{month}/{day}/{year}">

										<?php
										foreach ( GroupReportsInterface::$ulgm_reporting_shortcode['table']['reporting']['headers'] as $header ) {
											if ( key_exists( $header['slug'], $cell ) ) {

												$css_classes = $cell[ $header['slug'] ]['css-classes'];
												$cell_width  = $cell[ $header['slug'] ]['cell-width'];
												$show_sort   = $cell[ $header['slug'] ]['show-sort'];

												?>

												<div class="header-column <?php echo $css_classes; ?> uo-table-cell uo-table-cell-<?php echo $cell_width; ?>">
													<span class="uog_header header"><?php echo $header['title']; ?></span>

													<?php

													if ( $show_sort ) {

														?>

														<span class="sort-btns">
														<i class="uo-table-sort-btn uo-hidden fa fa-angle-up"
														   data-path=".<?php echo $header['slug']; ?>" data-type="text"
														   data-order="asc"
														   title="Sort by <?php echo $header['title']; ?> Asc"></i>
														<i class="uo-table-sort-btn fa fa-angle-down"
														   data-path=".<?php echo $header['slug']; ?>" data-type="text"
														   data-order="desc"
														   title="Sort by <?php echo $header['title']; ?> Desc"></i>
													</span>

														<?php

													}

													?>
												</div>

											<?php } ?>
										<?php } ?>

									</div>
								</header>
							</div>

							<!-- data container -->
							<div id="test" class="pseudo-table-body">
								<div class="uo-row uo-jplist-row uo-table-content uo-tbl-item body-row">
									<div class="uo-table-no-results">
										<?php _e( 'There are no records to display.', 'uncanny-learndash-groups' ); ?>
									</div>
								</div>
							</div>

						</div>
					</div>
					<!-- end of data -->
				</div>
			</div>

			<div class="uo-row uo-groups-pagination">
				<!-- panel -->
				<div class="jplist-panel box panel-bottom">
					<div class="uo-left">
						<div class="uo-select-jplist">
							<div class="jplist-drop-down" data-control-type="items-per-page-drop-down"
								 data-control-name="paging"
								 data-control-action="paging">
								<ul class="uo-hidden">
									<span class="uo-select-arrow"></span>
									<span class="uo-select-dropdown">
										<li class="active"><span data-number="20"
																 data-default="true"> <?php _e( '20 per page', 'uncanny-learndash-groups' ); ?> </span></li>
										<li><span data-number="50"> <?php _e( '50 per page', 'uncanny-learndash-groups' ); ?> </span></li>
										<li><span data-number="100"> <?php _e( '100 per page', 'uncanny-learndash-groups' ); ?> </span></li>
										<li><span data-number="all"> <?php _e( 'View All', 'uncanny-learndash-groups' ); ?> </span></li>
									</span>
								</ul>
							</div>
						</div>
					</div>

					<div class="uo-center">
						<div class="jplist-pagination" data-control-type="pagination" data-control-name="paging"
							 data-control-action="paging" data-control-animate-to-top="true">
							<div class="jplist-pagingprev" data-type="pagingprev">
								<button type="button" class="jplist-first" data-number="0" data-type="first">«</button>
								<button type="button" class="jplist-prev" data-type="prev" data-number="0">‹</button>
							</div>
							<div class="jplist-pagingmid" data-type="pagingmid">
								<div class="jplist-pagesbox" data-type="pagesbox"></div>
							</div>
							<div class="jplist-pagingnext" data-type="pagingnext">
								<button type="button" class="jplist-next" data-type="next" data-number="1">›</button>
								<button type="button" class="jplist-last" data-type="last" data-number="3">»</button>
							</div>
						</div>
					</div>

					<div class="uo-right">
						<div class="jplist-label"
							 data-type="<?php _e( '{start} - {end} of {all}', 'uncanny-learndash-groups' ) ?>"
							 data-control-type="pagination-info"
							 data-control-name="paging" data-control-action="paging">
						</div>
					</div>

					<!--
					<div class="pagination-container"></div>
					-->
				</div>
			</div>
		</div>
	</section>

	<script type="text/template" data-template="item">
		<div class="uo-row uo-jplist-row uo-table-content uo-tbl-item body-row">

			<?php $headers = GroupReportsInterface::$ulgm_reporting_shortcode['table']['reporting']['headers']; ?>
			<input class="select-user" name="user-id[]" type="hidden" value="${user_id}"/>

			<div class="<?php echo $cell[ $headers[0] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[0] ['slug'] ] ['cell-width']; ?>">
				<span data-header="<?php echo $headers[0]['title']; ?>" class="header-column-inline"></span>
				<span class="<?php echo $headers[0]['slug']; ?>">${first_name}</span>
			</div>

			<div class="<?php echo $cell[ $headers[1] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[1] ['slug'] ] ['cell-width']; ?>">
				<span data-header="<?php echo $headers[1]['title']; ?>" class="header-column-inline"></span>
				<span class="<?php echo $headers[1]['slug']; ?>">${last_name}</span>
			</div>

			<div class="<?php echo $cell[ $headers[2] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[2] ['slug'] ] ['cell-width']; ?>">
				<span data-header="<?php echo $headers[2]['title']; ?>" class="header-column-inline"></span>
				<span class="<?php echo $headers[2]['slug']; ?>">${user_email}</span>
			</div>

			<div class="<?php echo $cell[ $headers[3] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[3] ['slug'] ] ['cell-width']; ?>">
				<span data-header="<?php echo $headers[3]['title']; ?>" class="header-column-inline"></span>
				<?php
				if ( isset( $_GET['user_id'] ) && ! empty( $_GET['user_id'] ) ) {
					?>
					<span class="<?php echo $headers[3]['slug']; ?>">${percent_completed}</span>
					<?php
				} else {
					?>
					<a href="<?php echo SharedFunctions::get_group_report_page_id( true ); ?>?user_id=${user_id}"
					   target="_blank">
						<span class="<?php echo $headers[3]['slug']; ?>">${percent_completed}</span>
					</a>
					<?php
				}
				?>

			</div>

			<div class="<?php echo $cell[ $headers[4] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[4] ['slug'] ] ['cell-width']; ?>">
				<span data-header="<?php echo $headers[4]['title']; ?>" class="header-column-inline"></span>
				<span class="<?php echo $headers[4]['slug']; ?>">${date_completed}</span>
			</div>

			<?php if ( '' !== GroupReportsInterface::$transcript_page_url ) { ?>

				<div class="<?php echo $cell[ $headers[4] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[4] ['slug'] ] ['cell-width']; ?>">
					<span data-header="<?php echo $headers[4]['title']; ?>" class="header-column-inline"></span>
					<span class="<?php echo $headers[4]['slug']; ?>">
						<a href="<?php echo GroupReportsInterface::$transcript_page_url; ?>?user-id=${user_id}"><?php _e( 'Details', 'uncanny-learndash-groups' ); ?></a>
					</span>
				</div>

			<?php } ?>

			<?php if ( absint( self::$user_id ) ) { ?>
				<div class="<?php echo $cell[ $headers[5] ['slug'] ] ['css-classes']; ?> uo-table-cell uo-table-cell-<?php echo $cell[ $headers[5] ['slug'] ] ['cell-width']; ?>">
					<span data-header="<?php echo $headers[5]['title']; ?>" class="header-column-inline"></span>
					<span class="<?php echo $headers[5]['slug']; ?>">${course_name}</span>
				</div>
			<?php } ?>

		</div>
	</script>
</div>