<?php

namespace Uncanny_Automator_Pro;

/**
 * Class Magic_Button
 *
 * @package Uncanny_Automator_Pro
 */
class Magic_Button {

	/**
	 * Constructor.
	 */

	public function __construct() {
		add_shortcode( 'automator_button', [ __CLASS__, 'automator_button' ] );
		add_action( 'init', [ __CLASS__, 'automator_action' ] );
	}

	/**
	 * Return the HTML template that is displayed by the shortcode
	 *
	 * @param array $atts The attributes passed in the the shortcode
	 * @param string $content The content contained by the shortcode
	 *
	 * @return string  The HTML template loaded
	 * @since 2.0
	 *
	 */
	public static function automator_button( $atts, $content = null ) {
		$atts = shortcode_atts( [
			'id'    => 0,
			'label' => __( 'Go', 'uncanny-automator' ),
		],
			$atts,
			'automator_button' );

		if ( empty( $atts['id'] ) || 0 === $atts['id'] ) {
			return;
		}
		$user_id = get_current_user_id();
		if ( 0 === $user_id ) {
			return;
		}

		$button_form = '<form method="post" class="automator_button_form" id="automator_button_form_' . $atts['id'] . '">';
		$button_form .= '<input type="hidden" name="automator_trigger_id" value="' . $atts['id'] . '" />';
		$button_form .= '<input type="hidden" name="automator_nonce" value="' . wp_create_nonce( Utilities::get_prefix() ) . '"/>';
		$button_form .= '<button type="submit" class="automator_button">' . $atts['label'] . '</button>';
		$button_form .= '</form>';

		return $button_form;
	}

	public static function automator_action() {
		if ( isset( $_POST['automator_nonce'] ) && wp_verify_nonce( $_POST['automator_nonce'], Utilities::get_prefix() ) ) {

			$user_id = get_current_user_id();
			if ( 0 === $user_id ) {
				return;
			}
			$automator_trigger_id = $_POST['automator_trigger_id'];
			do_action( 'automator_magic_button_action', $automator_trigger_id, $user_id );
		}
	}
}
