<?php

namespace uncanny_automator_pro;

/**
 * Class Pro_Filters
 * @package uncanny_automator_pro
 */
class Pro_Filters {

	/**
	 * Constructor.
	 */

	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'scripts' ) );
	}

	/**
	 * Enqueue scripts only on custom post type edit pages
	 *
	 * @param $hook
	 */
	public function scripts( $hook ) {
		if ( strpos( $hook, 'uncanny-activities' ) !== false ) {
			wp_enqueue_script( 'activity-log-pro-js', Utilities::get_js( 'admin/logs.js' ), array(), Utilities::get_version(), true );
			// Setup group management JS with localized WP Rest API variables @see rest-api-end-points.php
			wp_register_script( 'activity-log-pro-js', Utilities::get_js( 'admin/logs.js' ), array(), Utilities::get_version(), true );
			// API data
			$api_setup = array(
				'ajax_url'   => admin_url( 'admin-ajax.php' ),
				'ajax_nonce' => wp_create_nonce( 'load-recipes-ref' )
			);
			wp_localize_script( 'activity-log-pro-js', 'uapActivityLogApiSetup', $api_setup );
			// Vendors
			wp_enqueue_script( 'select2', Utilities::get_vendor_asset( 'select2/js/select2.min.js' ), array( 'jquery' ), false, true );
			wp_enqueue_style( 'select2', Utilities::get_vendor_asset( 'select2/css/select2.min.css' ), array(), Utilities::get_version() );
			wp_enqueue_script( 'moment', Utilities::get_vendor_asset( 'daterangepicker/js/moment.min.js' ), array( 'jquery' ), false, true );
			wp_enqueue_script( 'daterangepicker', Utilities::get_vendor_asset( 'daterangepicker/js/daterangepicker.js' ), array( 'jquery' ), false, true );
			wp_enqueue_style( 'daterangepicker', Utilities::get_vendor_asset( 'daterangepicker/css/daterangepicker.css' ), array(), Utilities::get_version() );
			wp_enqueue_style( 'uap-logs-pro', Utilities::get_css( 'admin/logs.css' ), array(), Utilities::get_version() );
		}
	}

	/**
	 * Creates the filters HTML
	 *
	 * @param String $tab The identificator of the log. ( "recipe", "trigger" or "action" )
	 *
	 * @return String      The HTML
	 */

	public static function activities_filters_html( $tab ) {

		global $wpdb;

		// Get Recipes Name
		$recipes = $wpdb->get_results( "select distinct(r.automator_recipe_id) as id,p.post_title as recipe_title from {$wpdb->prefix}uap_recipe_log r join {$wpdb->posts} p on p.ID = r.automator_recipe_id order by recipe_title asc", ARRAY_A );

		// Get Triggers Name
		if ( $tab == 'trigger-log' ) {
			$triggers = $wpdb->get_results( "select distinct(r.automator_trigger_id) as id,p.post_title as trigger_title from {$wpdb->prefix}uap_trigger_log r join {$wpdb->posts} p on p.ID = r.automator_trigger_id order by trigger_title asc", ARRAY_A );
		}

		// Get Actions Name
		if ( $tab == 'action-log' ) {
			$actions = $wpdb->get_results( "select distinct(r.automator_action_id) as id,p.post_title as action_title from {$wpdb->prefix}uap_action_log r join {$wpdb->posts} p on p.ID = r.automator_action_id order by action_title asc", ARRAY_A );
		}

		$users = $wpdb->get_results( "select distinct(u.ID) as id,u.display_name as title FROM {$wpdb->users} u join {$wpdb->prefix}uap_recipe_log r on u.ID = r.user_id order by title asc", ARRAY_A );

		include( Utilities::get_view( 'pro-filters-view.php' ) );

		$output = ob_get_clean();

		return $output;
	}

	/**
	 * Prepare query for recipe
	 *
	 * @return string query
	 */
	public static function get_recipe_query() {
		global $wpdb;
		$search_conditions = ' 1=1 AND r.completed != -1 ';
		if ( isset( $_GET['search_key'] ) && $_GET['search_key'] != '' ) {
			$search_key        = sanitize_text_field( $_GET['search_key'] );
			$search_conditions .= " AND ( (p.post_title LIKE '%{$search_key}%') OR (u.display_name  LIKE '%{$search_key}%' ) OR (u.user_email  LIKE '%{$search_key}%' ) ) ";
		}
		if ( isset( $_GET['recipe_id'] ) && $_GET['recipe_id'] != '' ) {
			$search_conditions .= " AND r.automator_recipe_id = '" . absint( $_GET["recipe_id"] ) . "' ";
		}
		if ( isset( $_GET['user_id'] ) && $_GET['user_id'] != '' ) {
			$search_conditions .= " AND r.user_id = '" . absint( $_GET["user_id"] ) . "' ";
		}
		if ( isset( $_GET['daterange'] ) && $_GET['daterange'] != '' ) {
			$date_range = explode( ' - ', $_GET['daterange'], 2 );
			if ( isset( $date_range[0] ) && isset( $date_range[1] ) ) {
				$date_range[0]     = date( "Y-m-d", strtotime( $date_range[0] ) );
				$date_range[1]     = date( "Y-m-d", strtotime( $date_range[1] ) );
				$search_conditions .= " AND (r.date_time BETWEEN '{$date_range[0]}' AND '{$date_range[1]}' )";
			}
		}

		$query = "SELECT u.ID as user_id, 
	                        u.user_email, 
	                        u.display_name, 
	                        p.post_title AS recipe_title, 
	                        r.date_time AS recipe_date_time, 
	                        r.completed AS recipe_completed, 
	                        r.run_number, 
	                        r.automator_recipe_id
                FROM {$wpdb->prefix}uap_recipe_log r
                LEFT JOIN {$wpdb->users} u
                ON u.ID = r.user_id
                LEFT JOIN {$wpdb->posts} p
                ON p.ID = r.automator_recipe_id 
                WHERE {$search_conditions}";

		return $query;
	}

	/**
	 * Prepare query for trigger
	 *
	 * @return string query
	 */
	public static function get_trigger_query() {
		global $wpdb;
		$search_conditions = ' 1=1 ';
		if ( isset( $_GET['search_key'] ) && $_GET['search_key'] != '' ) {
			$search_key        = sanitize_text_field( $_GET['search_key'] );
			$search_conditions .= " AND ( (pt.post_title LIKE '%{$search_key}%') OR (p.post_title LIKE '%{$search_key}%') OR (u.display_name  LIKE '%{$search_key}%' ) OR (u.user_email  LIKE '%{$search_key}%' ) ) ";
		}
		if ( isset( $_GET['recipe_id'] ) && $_GET['recipe_id'] != '' ) {
			$search_conditions .= " AND r.automator_recipe_id = '" . absint( $_GET["recipe_id"] ) . "' ";
		}
		if ( isset( $_GET['trigger_id'] ) && $_GET['trigger_id'] != '' ) {
			$search_conditions .= " AND t.automator_trigger_id = '" . absint( $_GET["trigger_id"] ) . "' ";
		}
		if ( isset( $_GET['user_id'] ) && $_GET['user_id'] != '' ) {
			$search_conditions .= " AND r.user_id = '" . absint( $_GET["user_id"] ) . "' ";
		}
		if ( isset( $_GET['daterange'] ) && $_GET['daterange'] != '' ) {
			$date_range = explode( ' - ', $_GET['daterange'], 2 );
			if ( isset( $date_range[0] ) && isset( $date_range[1] ) ) {
				$date_range[0]     = date( "Y-m-d", strtotime( $date_range[0] ) );
				$date_range[1]     = date( "Y-m-d", strtotime( $date_range[1] ) );
				$search_conditions .= " AND (r.date_time BETWEEN '{$date_range[0]}' AND '{$date_range[1]}' )";
			}
		}
		if ( isset( $_GET['trigger_daterange'] ) && $_GET['trigger_daterange'] != '' ) {
			$date_range = explode( ' - ', $_GET['trigger_daterange'], 2 );
			if ( isset( $date_range[0] ) && isset( $date_range[1] ) ) {
				$date_range[0]     = date( "Y-m-d", strtotime( $date_range[0] ) );
				$date_range[1]     = date( "Y-m-d", strtotime( $date_range[1] ) );
				$search_conditions .= " AND (t.date_time BETWEEN '{$date_range[0]}' AND '{$date_range[1]}' )";
			}
		}
		$query = "SELECT u.ID AS user_id, u.user_email, 
                            u.display_name, 
                            t.automator_trigger_id, 
                            t.date_time AS trigger_date, 
                            t.completed AS trigger_completed, 
                            t.automator_recipe_id, 
                            pt.post_title AS trigger_title, 
                            p.post_title AS recipe_title, 
                            r.date_time AS recipe_date_time, 
                            r.completed AS recipe_completed, 
                            r.run_number AS recipe_run_number
                        FROM {$wpdb->prefix}uap_trigger_log t
                        LEFT JOIN {$wpdb->users} u
                        ON u.ID = t.user_id
                        LEFT JOIN {$wpdb->posts} p
                        ON p.ID = t.automator_recipe_id
                        LEFT JOIN {$wpdb->posts} pt
                        ON pt.ID = t.automator_trigger_id
                        LEFT JOIN {$wpdb->prefix}uap_recipe_log r
                        ON t.automator_recipe_log_id = r.ID
                        WHERE ({$search_conditions}) ";

		return $query;
	}

	/**
	 * Prepare query for action
	 *
	 * @return string query
	 */
	public static function get_action_query() {
		global $wpdb;
		$search_conditions = ' 1=1 ';
		if ( isset( $_GET['search_key'] ) && $_GET['search_key'] != '' ) {
			$search_key        = sanitize_text_field( $_GET['search_key'] );
			$search_conditions .= " AND ( (pa.post_title LIKE '%{$search_key}%') OR (p.post_title LIKE '%{$search_key}%') OR (u.display_name LIKE '%{$search_key}%' ) OR (u.user_email LIKE '%{$search_key}%' ) OR (a.error_message LIKE '%{$search_key}%' ) ) ";
		}
		if ( isset( $_GET['recipe_id'] ) && $_GET['recipe_id'] != '' ) {
			$search_conditions .= " AND r.automator_recipe_id = '" . absint( $_GET["recipe_id"] ) . "' ";
		}
		if ( isset( $_GET['action_id'] ) && $_GET['action_id'] != '' ) {
			$search_conditions .= " AND a.automator_action_id = '" . absint( $_GET["action_id"] ) . "' ";
		}
		if ( isset( $_GET['user_id'] ) && $_GET['user_id'] != '' ) {
			$search_conditions .= " AND r.user_id = '" . absint( $_GET["user_id"] ) . "' ";
		}
		if ( isset( $_GET['daterange'] ) && $_GET['daterange'] != '' ) {
			$date_range = explode( ' - ', $_GET['daterange'], 2 );
			if ( isset( $date_range[0] ) && isset( $date_range[1] ) ) {
				$date_range[0]     = date( "Y-m-d", strtotime( $date_range[0] ) );
				$date_range[1]     = date( "Y-m-d", strtotime( $date_range[1] ) );
				$search_conditions .= " AND (r.date_time BETWEEN '{$date_range[0]}' AND '{$date_range[1]}' )";
			}
		}
		if ( isset( $_GET['action_daterange'] ) && $_GET['action_daterange'] != '' ) {
			$date_range = explode( ' - ', $_GET['action_daterange'], 2 );
			if ( isset( $date_range[0] ) && isset( $date_range[1] ) ) {
				$date_range[0]     = date( "Y-m-d", strtotime( $date_range[0] ) );
				$date_range[1]     = date( "Y-m-d", strtotime( $date_range[1] ) );
				$search_conditions .= " AND (a.date_time BETWEEN '{$date_range[0]}' AND '{$date_range[1]}' )";
			}
		}
		$query = "SELECT a.automator_action_id,
	                        a.date_time AS action_date, 
	                        a.completed AS action_completed, 
	                        a.error_message, 
	                        a.automator_recipe_id, 
							u.ID AS user_id, 
	                        u.user_email, 
	                        u.display_name, 
	                        pa.post_title AS action_title, 
	                        p.post_title AS recipe_title, 
	                        r.date_time AS recipe_date_time, 
	                        r.completed AS recipe_completed, 
	                        r.run_number AS recipe_run_number
                    FROM {$wpdb->prefix}uap_action_log a
                    LEFT JOIN {$wpdb->users} u
                    ON u.ID = a.user_id
                    LEFT JOIN {$wpdb->posts} p
                    ON p.ID = a.automator_recipe_id
                    LEFT JOIN {$wpdb->posts} pa
                    ON pa.ID = a.automator_action_id
                    LEFT JOIN {$wpdb->prefix}uap_recipe_log r
                    ON a.automator_recipe_log_id = r.ID
                    WHERE ({$search_conditions}) ";

		return $query;
	}
}