<?php

namespace Uncanny_Automator_Pro;

/**
 * Class Cf7_Tokens
 * @package uncanny_automator
 */
class Cf7_Tokens {


	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'CF7';

	public function __construct() {
		
		add_filter( 'automator_maybe_trigger_cf7_cf7forms_tokens', [ $this, 'cf7_possible_tokens' ], 20, 2 );
		add_filter( 'automator_maybe_trigger_cf7_cf7fields_tokens', [ $this, 'cf7_possible_tokens' ], 20, 2 );
		add_filter( 'automator_maybe_trigger_cf7_anoncf7forms_tokens', [ $this, 'cf7_possible_tokens' ], 20, 2 );
		add_filter( 'automator_maybe_parse_token', [ $this, 'parse_cf7_token' ], 20, 5 );
		add_filter( 'automator_maybe_parse_token', [ $this, 'parse_cf7_anon_token' ], 21, 5 );

		//save submission to user meta
		add_action( 'automator_save_cf7_form', [ $this, 'automator_save_cf7_form_func' ], 20, 2 );
		add_action( 'automator_save_anon_cf7_form', [ $this, 'automator_save_anon_cf7_form_func' ], 20, 2 );
	}

	/**
	 * Only load this integration and its triggers and actions if the related plugin is active
	 *
	 * @param $status
	 * @param $code
	 *
	 * @return bool
	 */
	public function plugin_active( $status, $code ) {

		if ( self::$integration === $code ) {
			if ( class_exists( 'WPCF7' ) ) {
				$status = true;
			} else {
				$status = false;
			}
		}

		return $status;
	}

	/**
	 * @param \WPCF7_ContactForm $contact_form
	 * @param $recipes
	 */
	public function automator_save_cf7_form_func( \WPCF7_ContactForm $contact_form, $recipes ) {
		global $uncanny_automator;
		if ( $recipes ) {
			foreach ( $recipes as $recipe ) {
				$triggers = $recipe['triggers'];
				if ( $triggers ) {
					foreach ( $triggers as $trigger ) {
						$trigger_id = $trigger['ID'];
						if ( ! key_exists( 'CF7FORMS', $trigger['meta'] ) ) {
							continue;
						} else {
							$form_id        = (int) $trigger['meta']['CF7FORMS'];
							$data           = $this->get_data_from_contact_form( $contact_form );
							$user_id        = wp_get_current_user()->ID;
							$recipe_log_id  = $uncanny_automator->maybe_create_recipe_log_entry( $recipe['ID'], $user_id );
							$trigger_log_id = $uncanny_automator->maybe_get_trigger_id( $user_id, $trigger_id, $recipe['ID'], $recipe_log_id );
							$trigger_log_id = $trigger_log_id['get_trigger_id'];
							$run_number     = $uncanny_automator->get->trigger_run_number( $trigger_id, $trigger_log_id, $user_id );

							$args = [
								'user_id'        => $user_id,
								'trigger_id'     => $trigger_id,
								'meta_key'       => 'CF7FORMS_' . $form_id,
								'meta_value'     => serialize( $data ),
								'run_number'     => $run_number, //get run number
								'trigger_log_id' => $trigger_log_id,
							];

							$uncanny_automator->insert_trigger_meta( $args );
						}
					}
				}
			}
		}
	}

	/**
	 * @param \WPCF7_ContactForm $contact_form
	 * @param $recipes
	 */
	public function automator_save_anon_cf7_form_func( \WPCF7_ContactForm $contact_form, $recipes ) {
		global $uncanny_automator, $wpdb;
		if ( $recipes ) {
			foreach ( $recipes as $recipe ) {
				$triggers = $recipe['triggers'];
				if ( $triggers ) {
					foreach ( $triggers as $trigger ) {
						$trigger_id = $trigger['ID'];
						if ( ! key_exists( 'ANONCF7FORMS', $trigger['meta'] ) ) {
							continue;
						} else {
							$form_id        = (int) $trigger['meta']['ANONCF7FORMS'];
							$data           = $this->get_data_from_contact_form( $contact_form );
							$user_id        = wp_get_current_user()->ID;
							$recipe_log_id  = $wpdb->get_var( $wpdb->prepare( "SELECT ID FROM {$wpdb->prefix}uap_recipe_log WHERE completed != %d  AND automator_recipe_id = %d AND user_id = %d", 1, $recipe['ID'], $user_id ) );
							$trigger_log_id = $uncanny_automator->maybe_get_trigger_id( $user_id, $trigger_id, $recipe['ID'], $recipe_log_id );
							$trigger_log_id = $trigger_log_id['get_trigger_id'];
							$run_number     = $uncanny_automator->get->trigger_run_number( $trigger_id, $trigger_log_id, $user_id );

							$args = [
								'user_id'        => $user_id,
								'trigger_id'     => $trigger_id,
								'meta_key'       => 'ANONCF7FORMS_' . $form_id,
								'meta_value'     => serialize( $data ),
								'run_number'     => $run_number, //get run number
								'trigger_log_id' => $trigger_log_id,
							];

							$uncanny_automator->insert_trigger_meta( $args );
						}
					}
				}
			}
		}
	}

	/**
	 *
	 * On mail submission. Remove it if it's not required anymore
	 *
	 * @param \WPCF7_ContactForm $contact_form
	 */
	public function wpcf7_mail_sent( \WPCF7_ContactForm $contact_form ) {
		$data = $this->get_data_from_contact_form( $contact_form );
		if ( is_user_logged_in() && $data ) {
			add_user_meta( wp_get_current_user()->ID, 'cf7_' . $contact_form->id() . '_submission', $data );
		}
	}

	/**
	 * @param \WPCF7_ContactForm $contact_form
	 *
	 * @return array
	 */
	public function get_data_from_contact_form( \WPCF7_ContactForm $contact_form ) {
		$data = [];

		$tags = $contact_form->scan_form_tags();

		foreach ( $tags as $tag ) {
			if ( empty( $tag->name ) ) {
				continue;
			}

			$pipes = $tag->pipes;

			$value = ( ! empty( $_POST[ $tag->name ] ) ) ? $_POST[ $tag->name ] : '';
			if ( WPCF7_USE_PIPE && $pipes instanceof \WPCF7_Pipes && ! $pipes->zero() ) {
				if ( is_array( $value ) ) {
					$new_value = [];

					foreach ( $value as $v ) {
						$new_value[] = $pipes->do_pipe( wp_unslash( $v ) );
					}

					$value = $new_value;
				} else {
					$value = $pipes->do_pipe( wp_unslash( $value ) );
				}
			}

			$data[ $tag->name ] = $value;
		}

		return $data;
	}

	/**
	 * @param array $tokens
	 * @param array $args
	 *
	 * @return mixed
	 */
	public function cf7_general_tokens( $tokens = [], $args = [] ) {

		return $tokens;
	}

	/**
	 * @param array $tokens
	 * @param array $args
	 *
	 * @return array
	 */
	public function cf7_possible_tokens( $tokens = [], $args = [] ) {
		$form_id             = $args['value'];
		$trigger_integration = $args['integration'];
		$trigger_meta        = $args['meta'];
		
		if ( empty( $form_id ) || 'ANONCF7FORMS' === $form_id ) {
			return $tokens;
		}
		$contact_form7 = \WPCF7_ContactForm::get_instance( $form_id );

		$cf7_tags      = $contact_form7->scan_form_tags();
		if ( $cf7_tags ) {
			$fields = [];
			foreach ( $cf7_tags as $tag ) {
				if ( empty( $tag->name ) ) {
					continue;
				}
				$input_id = $tag->name;
				//convert your-name to Your Name, your-email to Your Email
				$input_title = ucwords( str_replace( [ '-', '_' ], ' ', $tag->name ) );
				$token_id    = "$form_id|$input_id";
				$token_type  = 'text';
				if ( strpos( $tag->type, 'email' ) || 'email*' === $tag->type || 'email' === $tag->type ) {
					$token_type = 'email';
				}

				$fields[] = [
					'tokenId'         => $token_id,
					'tokenName'       => $input_title,
					'tokenType'       => $token_type,
					'tokenIdentifier' => $trigger_meta,
				];
			}
			$tokens = array_merge( $tokens, $fields );
		}

		return $tokens;
	}

	/**
	 * @param $value
	 * @param $pieces
	 * @param $recipe_id
	 * @param $trigger_data
	 *
	 * @return mixed
	 */
	public function parse_cf7_token( $value, $pieces, $recipe_id, $trigger_data, $user_id ) {
		$piece = 'CF7FORMS';
		if ( $pieces ) {
			if ( in_array( $piece, $pieces ) ) {
				global $uncanny_automator;
				$user_id       = wp_get_current_user()->ID;
				$recipe_log_id = $uncanny_automator->maybe_create_recipe_log_entry( $recipe_id, $user_id );
				if ( $trigger_data ) {
					foreach ( $trigger_data as $trigger ) {
						if ( key_exists( $piece, $trigger['meta'] ) ) {
							$trigger_id     = $trigger['ID'];
							$trigger_log_id = $uncanny_automator->maybe_get_trigger_id( $user_id, $trigger_id, $recipe_id, $recipe_log_id );
							$trigger_log_id = $trigger_log_id['get_trigger_id'];
							$token_info     = explode( '|', $pieces[2] );
							$form_id        = $token_info[0];
							$meta_key       = $token_info[1];
							$meta_field     = $piece . '_' . $form_id;
							$user_meta      = $this->get_form_data_from_trigger_meta( $user_id, $meta_field, $trigger_id, $trigger_log_id );
							if ( key_exists( trim( $meta_key ), $user_meta ) ) {
								if ( is_array( $user_meta[ $meta_key ] ) ) {
									$value = join( ', ', $user_meta[ $meta_key ] );
								} else {
									$value = $user_meta[ $meta_key ];
								}
							}
						}
					}
				}
			}
		}

		return $value;
	}

	/**
	 * @param $user_id
	 * @param $meta_key
	 * @param $trigger_id
	 * @param $trigger_log_id
	 *
	 * @return mixed|string
	 */
	public function get_form_data_from_trigger_meta( $user_id, $meta_key, $trigger_id, $trigger_log_id ) {
		global $wpdb;
		if ( empty( $user_id ) || empty( $meta_key ) || empty( $trigger_id ) || empty( $trigger_log_id ) ) {
			return '';
		}

		$meta_value = $wpdb->get_var( $wpdb->prepare( "SELECT meta_value FROM {$wpdb->prefix}uap_trigger_log_meta WHERE user_id = %d AND meta_key = %s AND automator_trigger_id = %d AND automator_trigger_log_id = %d ORDER BY ID DESC LIMIT 0,1", $user_id, $meta_key, $trigger_id, $trigger_log_id ) );
		if ( ! empty( $meta_value ) ) {
			return maybe_unserialize( $meta_value );
		}

		return '';
	}
	
	/**
	 * @param $value
	 * @param $pieces
	 * @param $recipe_id
	 * @param $trigger_data
	 *
	 * @return mixed
	 */
	public function parse_cf7_anon_token( $value, $pieces, $recipe_id, $trigger_data, $user_id ) {
		$piece = 'ANONCF7FORMS';
		if ( $pieces ) {
			if ( in_array( $piece, $pieces ) ) {
				global $uncanny_automator, $wpdb;
				$user_id       = wp_get_current_user()->ID;
				$recipe_log_id = $wpdb->get_var( $wpdb->prepare( "SELECT ID FROM {$wpdb->prefix}uap_recipe_log WHERE completed != %d  AND automator_recipe_id = %d AND user_id = %d", 1, $recipe_id, $user_id ) );
				if ( $trigger_data ) {
					$trigger_id     = $trigger_data['trigger_id'];
					$trigger_log_id = $uncanny_automator->maybe_get_trigger_id( $user_id, $trigger_id, $recipe_id, $recipe_log_id );
					$trigger_log_id = $trigger_log_id['get_trigger_id'];
					$token_info     = explode( '|', $pieces[2] );
					$form_id        = $token_info[0];
					$meta_key       = $token_info[1];
					$meta_field     = $piece . '_' . $form_id;
					$user_meta      = $this->get_form_data_from_anon_trigger_meta( $user_id, $meta_field, $trigger_id, $trigger_log_id );
					if ( key_exists( trim( $meta_key ), $user_meta ) ) {
						if ( is_array( $user_meta[ $meta_key ] ) ) {
							$value = join( ', ', $user_meta[ $meta_key ] );
						} else {
							$value = $user_meta[ $meta_key ];
						}
					}
				}
			}
		}

		return $value;
	}

	/**
	 * @param $user_id
	 * @param $meta_key
	 * @param $trigger_id
	 * @param $trigger_log_id
	 *
	 * @return mixed|string
	 */
	public function get_form_data_from_anon_trigger_meta( $user_id, $meta_key, $trigger_id, $trigger_log_id ) {
		global $wpdb;
		if ( empty( $meta_key ) || empty( $trigger_id ) || empty( $trigger_log_id ) ) {
			return '';
		}

		$meta_value = $wpdb->get_var( $wpdb->prepare( "SELECT meta_value FROM {$wpdb->prefix}uap_trigger_log_meta WHERE user_id = %d AND meta_key = %s AND automator_trigger_id = %d AND automator_trigger_log_id = %d ORDER BY ID DESC LIMIT 0,1", $user_id, $meta_key, $trigger_id, $trigger_log_id ) );
		if ( ! empty( $meta_value ) ) {
			return maybe_unserialize( $meta_value );
		}

		return '';
	}
}