<?php

namespace Uncanny_Automator_Pro;

/**
 * Class ANON_WPF_SUBMITFIELD
 * @package Uncanny_Automator_Pro
 */
class ANON_WPF_SUBMITFIELD {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WPF';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'ANONWPFSUBMITFIELD';
		$this->trigger_meta = 'ANONWPFFORMS';
		$this->define_trigger();

		add_action( 'wp_ajax_select_form_fields_ANONWPFFORMS', array( $this, 'select_form_fields_func' ) );
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name(),
			'support_link'        => $uncanny_automator->get_author_support_link(),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'meta'                => $this->trigger_meta,
			/* Translators: 1:MemberPress Products */
			//User submits a form that contains a specific value in a specific field
			'sentence'            => sprintf( __( 'A {{WP Form:%1$s}} is submitted with {{a specific value:%2$s}} in {{a specific field:%3$s}}', 'uncanny-automator' ), $this->trigger_meta, 'SUBVALUE', $this->trigger_code ),
			'select_option_name'  => __( 'A {{WP Form}} is submitted with {{a specific value}} in {{a specific field}}', 'uncanny-automator' ),
			'action'              => 'wpforms_process_complete',
			'type'                => 'anonymous',
			'priority'            => 10,
			'accepted_args'       => 4,
			'validation_function' => array( $this, 'wpform_submit' ),
			'options'             => [],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_wp_forms( null, $this->trigger_meta, [
						'token'        => false,
						'is_ajax'      => true,
						'target_field' => $this->trigger_code,
						'endpoint'     => 'select_form_fields_ANONWPFFORMS',
					] ),
					$uncanny_automator->options->select_field( $this->trigger_code, __( 'Select a field', 'uncanny-automator' ) ),
					$uncanny_automator->options->text_field( 'SUBVALUE' ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );
		
		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param array $fields fields array.
	 * @param array $entry errors array.
	 * @param array $form_data form object.
	 * @param string $entry_id other settings.
	 */
	public function wpform_submit( $fields, $entry, $form_data, $entry_id ) {

		global $uncanny_automator;
		$recipes = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );
		$entry['form_id'] = $form_data['id'];
		$entry['fields'] = $fields;

		$user_id = get_current_user_id();
		if ( empty( $user_id ) ) {
			//return;
		}

		if ( empty( $entry ) ) {
			return;
		}

		$conditions = $this->match_condition( $entry, $recipes, $this->trigger_meta, $this->trigger_code, 'SUBVALUE' );

		if ( ! $conditions ) {
			return;
		}

		$user_id  = get_current_user_id();
		$triggers = [];
		if ( ! empty( $conditions ) ) {
			foreach ( $conditions['recipe_ids'] as $recipe_id ) {
				if ( ! $uncanny_automator->is_recipe_completed( $recipe_id, $user_id ) ) {
					$args = [
						'code'            => $this->trigger_code,
						'meta'            => $this->trigger_meta,
						'recipe_to_match' => $recipe_id,
						'ignore_post_id'  => true,
						'user_id'         => $user_id,
					];

					$triggers[] = $uncanny_automator->maybe_add_trigger_entry( $args, false );
				}
			}
		}

		do_action( 'automator_save_anon_wp_form', $fields, $form_data, $recipes );

		if ( ! empty( $triggers ) ) {
			foreach ( $triggers as $args ) {
				if ( $args ) {
					foreach ( $args as $result ) {
						if ( true === $result['result'] ) {
							$uncanny_automator->maybe_trigger_complete( $result['args'] );
						}
					}
				}
			}
		}

	}

	/**
	 * Match condition for form field and value.
	 *
	 * @param array       $entry .
	 * @param null|array  $recipes .
	 * @param null|string $trigger_meta .
	 * @param null|string $trigger_code .
	 * @param null|string $trigger_second_code .
	 *
	 * @return array|bool
	 */
	public function match_condition( $entry, $recipes = null, $trigger_meta = null, $trigger_code = null, $trigger_second_code = null ) {
		if ( null === $recipes ) {
			return false;
		}
		
		$matches        = [];
		$recipe_ids     = [];
		$entry_to_match = $entry['form_id'];
		foreach ( $recipes as $recipe ) {
			foreach ( $recipe['triggers'] as $trigger ) {
				if ( key_exists( $trigger_meta, $trigger['meta'] ) && $trigger['meta'][ $trigger_meta ] === $entry_to_match ) {
					$matches[ $recipe['ID'] ]    = [
						'field' => $trigger['meta'][ $trigger_code ],
						'value' => $trigger['meta'][ $trigger_second_code ],
					];
					$recipe_ids[ $recipe['ID'] ] = $recipe['ID'];
					break;
				}
			}
		}

		if ( ! empty( $matches ) ) {
			foreach ( $matches as $recipe_id => $match ) {
				if ( $entry['fields'][ $match['field'] ]['value'] != $match['value'] ) {
					unset( $recipe_ids[ $recipe_id ] );
				}
			}
		}

		if ( ! empty( $recipe_ids ) ) {
			return [ 'recipe_ids' => $recipe_ids, 'result' => TRUE ];
		}

		return false;
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_form_fields_func() {

		global $uncanny_automator;

		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {
			$form_id     = $_POST['value'];
			$integration = $_POST['integration'];
			$wpforms  = new \WPForms_Form_Handler();
			$form = $wpforms->get( $form_id );
			$meta   = wpforms_decode( $form->post_content );
			if ( is_array( $meta['fields'] ) ) {
				foreach ( $meta['fields'] as $field ) {
					$input_id    = $field['id'];
					$input_title = $field['label'];
					$fields[] = [
						'value' => $input_id,
						'text'  => $input_title,
					];
				}
			}
		}
		echo wp_json_encode( $fields );
		die();
	}
}
