<?php defined( 'LS_ROOT_FILE' ) || exit; ?>
<div class="wrap ls-about-page">

	<!-- LayerSlider Logo & continue button -->
	<div class="ls-loader-container">
		<div class="ls-loader-logo">
			<div class="ls-loader-element-3"></div>
			<div class="ls-loader-element-2"></div>
			<div class="ls-loader-element-1"></div>
		</div>
	</div>

	<!-- Main title -->
	<h1 class="about-heading"><?php _e( 'Welcome to LayerSlider WP 6', 'LayerSlider' ); ?></h1>
	<div class="about-text"><?php _e( 'Thank you for installing LayerSlider WP! Version 6 is our biggest update yet.', 'LayerSlider' ); ?></div>

	<div class="ls-start-button-wrapper">
		<a href="<?php echo admin_url('admin.php?page=layerslider') ?>" class="button button-primary button-hero ls-start-button">
			<?php _e('Let’s Get Started', 'LayerSlider') ?>
		</a>
	</div>

	<!-- Tabs -->
	<div class="km-tabs">
		<a href="#" class="active"><?php _e('First steps', 'LayerSlider'); ?></a>
		<a href="#"><?php _e('Resources', 'LayerSlider'); ?></a>
		<a href="#"><?php _e('Privacy', 'LayerSlider') ?></a>
	</div>
	<div class="km-tabs-content">


		<!-- First Steps -->
		<div class="active">
			<figure><?php _e('Tips to get started using LayerSlider', 'LayerSlider') ?></figure>
			<div class="km-tabs-inner">
				<ul>
					<li class="gap">
						<a href="https://layerslider.kreaturamedia.com/documentation/#activation" target="_blank">
							<?php _e('Active the plugin to receive auto updates and premium benefits', 'LayerSlider') ?>
						</a>
						<p><?php _e('Perform license activation, so we can provide you hands on support, automatic updates, premium features, slider templates and other exclusive content & services.', 'LayerSlider') ?></p>
					</li>
					<li class="gap">
						<a href="https://layerslider.kreaturamedia.com/documentation/#demo-sliders" target="_blank">
							<?php _e('Check out the Template Store', 'LayerSlider') ?>
						</a>
						<p><?php _e('The Template Store provides quality hand-crafted slider samples, which can be a staring point for your new projects. Templates can also teach a lot of techniques and you can find from really simple ones to the most complex and extreme sliders.', 'LayerSlider') ?></p>
					</li>
					<li class="gap">
						<a href="https://layerslider.kreaturamedia.com/documentation/#overview" target="_blank">
							<?php _e('Read online resouces to get help', 'LayerSlider') ?>
						</a>
						<p><?php _e('We have online resouces where you can find help whether if you get stuck, experience an issue or just have a question about the item.', 'LayerSlider') ?></p>
						<ul>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/" target="_blank">
								<?php _e('End-User documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/developers/" target="_blank">
								<?php _e('Developer documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/help/" target="_blank">
									<?php _e('Support & FAQs', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</li>
				</ul>
			</div>
		</div>


		<!-- Resources -->
		<div>
			<figure><?php _e('Frequently asked questions and online resources', 'LayerSlider') ?></figure>
			<div class="km-tabs-inner">
				<div class="five-col clearfix">
					<div class="col">
						<h3><?php _e('Preface', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/" target="_blank">
									<?php _e('Introduction', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/#support" target="_blank">
									<?php _e('Support', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/support-policy/" target="_blank">
									<?php _e('Support Policies', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/release-log/" target="_blank">
									<?php _e('Release Notes', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Licensing', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://layerslider.kreaturamedia.com/licensing/" target="_blank">
									<?php _e('Licensing', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/licensing/#in-stock" target="_blank">
									<?php _e('In-Stock Usage', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/terms-of-use/" target="_blank">
									<?php _e('Terms of Use', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/legal/" target="_blank">
									<?php _e('Legal', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Getting Started', 'LayerSlider') ?></h3>
						<ul>

							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/#updating" target="_blank">
									<?php _e('Plugin updates', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/#demo-sliders" target="_blank">
									<?php _e('Import demo content', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/" target="_blank">
									<?php _e('Online Documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/#troubleshooting" target="_blank">
									<?php _e('Troubleshooting', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Resources', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://layerslider.kreaturamedia.com/documentation/" target="_blank">
									<?php _e('End-User Documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/developers/" target="_blank">
									<?php _e('Developer Documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/faq/" target="_blank">
									<?php _e('Frequently Asked Questions', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://layerslider.kreaturamedia.com/help/" target="_blank">
									<?php _e('Help', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Stay Updated', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://www.facebook.com/kreaturamedia/" target="_blank">
								<?php _e('Follow us on Facebook', 'LayerSlider') ?></a>
							</li>
							<li>
								<a href="https://twitter.com/kreaturamedia" target="_blank">
								<?php _e('Follow us on Twitter', 'LayerSlider') ?></a>
							</li>
							<li>
								<a href="https://www.youtube.com/user/kreaturamedia" target="_blank">
								<?php _e('Watch our YouTube channel', 'LayerSlider') ?></a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>


		<!-- Privacy -->
		<div>
			<figure><?php _e('Data protection and handling', 'LayerSlider') ?></figure>
			<form class="km-tabs-inner ls-about-privacy">
				<input type="hidden" name="action" value="ls_save_gdpr_settings">
				<?php wp_nonce_field('ls-save-gdpr-settings'); ?>
				<p>
					<?php echo sprintf(__('Thank you for your support and trust in Kreatura when using our products and services. To keep pace with the new data protection laws taking effect on May 25, 2018 in the European Union, we are updating our privacy policies. Please, do visit our %sGeneral Data Protection Regulation%s page for more information.', 'LayerSlider'), '<a href="https://layerslider.kreaturamedia.com/gdpr/" target="_blank">', '</a>'); ?>
				</p>
				<p>
					<?php _e('We encourage you to review the new changes to our policies. We appreciate your kind understanding as we offer our users to make the best decisions about the information they share with us.', 'LayerSlider'); ?> <?php _e('By using our products and services you will be agreeing to these terms.', 'LayerSlider') ?>
				</p>

				<hr>

				<h2><?php _e('Google Fonts: Hundreds of beautiful fonts for the web', 'LayerSlider') ?></h2>
				<p>
					<?php echo sprintf( __('%sWhat is it:%s Google Fonts offers hundreds of custom fonts and is one of the most popular web services to customize website appearance with beautiful typography.', 'LayerSlider'), '<strong>', '</strong>') ?>
				</p>
				<p>
					<?php echo sprintf( __('%sWhy is it important:%s Many of our importable content in the Template Store use and rely on Google Fonts. If you disable this feature, you may not be able to add custom fonts and it might compromise the appearance of textual content in sliders. Third parties can offer the same functionality, but they are also subjected to Google’s data processing.', 'LayerSlider') , '<strong>', '</strong>') ?>
				</p>
				<p>
					<?php echo sprintf( __('%sWhy should I care:%s Google might be able to track your activity when using their services. Please review Google’s %sPrivacy Policy%s and %sGDPR Compliance%s. As an external service, you can choose to disable Google Fonts if you disagree with Google’s data processing methods.', 'LayerSlider'), '<strong>', '</strong>', '<a href="https://privacy.google.com/" target="_blank">', '</a>', '<a href="https://privacy.google.com/businesses/compliance" target="_blank">', '</a>') ?>
				</p>
				<p>
					<input type="checkbox" name="ls_gdpr_goole_fonts" class="larger" checked>
					<label><?php _e('Enable Google Fonts', 'LayerSlider') ?></label>
				</p>
			</div>
		</div>

	</div>

</div>