<?php
function extended_products_grid_more_callback() {
	$settings = isset($_POST['data']) ? json_decode(stripslashes($_POST['data']), true) : array();
	ob_start();
	$response = array('status' => 'success');
	$page = isset($settings['more_page']) ? intval($settings['more_page']) : 1;
	if ($page == 0)
		$page = 1;
	$featured_only = $settings['featured_only'] == 'yes' ? true : false;
	$sale_only = $settings['sale_only'] == 'yes' ? true : false;
	if (in_array('category', $settings['source']) || isset($settings['content_products_cat_filter'])) {
		$categories = $settings['content_products_cat'];
	} else {
		$categories = ['0'];
	}
	$attributes = [];
	if (in_array('attribute', $settings['source']) || isset($settings['content_products_attr_filter'])) {
		$attrs = $settings['content_products_attr'];
		foreach ($attrs as $attr) {
			$values = $settings['content_products_attr_val_' . $attr];
			if (in_array('0', $values) || empty($values)) {
				$values = get_terms('pa_' . $attr, array('fields' => 'slugs'));
			}
			$attributes[$attr] = $values;
		}
	}

	$stock_only = false;
	if (isset($settings['content_products_status_filter'])) {
		if (in_array('sale', $settings['content_products_status_filter'])) {
			$sale_only = true;
		}
		if (in_array('stock', $settings['content_products_status_filter'])) {
			$stock_only = true;
		}
	}
	$price = null;
	if (isset($settings['content_products_price_filter'])) {
		$price = $settings['content_products_price_filter'];
	}
	$search = null;
	if (isset($settings['content_products_search_filter']) && $settings['content_products_search_filter'] != '') {
		$search = $settings['content_products_search_filter'];
	}

	$products_grid_loop = thegem_get_extended_product_posts($page, $settings['items_per_page'], $settings['orderby'], $settings['order'], $featured_only, $sale_only, $stock_only, $categories, $attributes, $price, $search);
	if ($products_grid_loop->max_num_pages > $page)
		$next_page = $page + 1;
	else
		$next_page = 0;

	if ($products_grid_loop->have_posts()): ?>
		<div data-page="<?php echo $page; ?>" data-next-page="<?php echo $next_page; ?>"
			 data-pages-count="<?php echo $products_grid_loop->max_num_pages; ?>">
			<?php while ($products_grid_loop->have_posts()) : $products_grid_loop->the_post(); ?>
				<?php echo thegem_extended_product_render_item($settings, get_the_ID()); ?>
			<?php endwhile; ?>
		</div>
	<?php else: ?>
		<div data-page="1" data-next-page="0" data-pages-count="1">
			<div class="portfolio-item not-found">
				<div class="wrap clearfix">
					<div class="image-inner"></div>
					<?php echo $settings['not_found_text']; ?>
				</div>
			</div>
		</div>
	<?php endif; ?>

	<?php $response['html'] = trim(preg_replace('/\s\s+/', '', ob_get_clean()));
	$response = json_encode($response);
	header("Content-Type: application/json");
	echo $response;
	exit;
}

add_action('wp_ajax_extended_products_grid_load_more', 'extended_products_grid_more_callback');
add_action('wp_ajax_nopriv_extended_products_grid_load_more', 'extended_products_grid_more_callback');

function thegem_get_extended_product_posts($page = 1, $ppp = -1, $orderby = 'menu_order ID', $order = 'ASC', $featured_only = false, $sale_only = false, $stock_only = false, $products_cat = null, $attributes = null, $price = null, $search = null) {
	if (!$products_cat && !$attributes) {
		return null;
	}

	$tax_query = [];

	if ($products_cat && !in_array('0', $products_cat, true)) {
		$tax_query[] = array(
			'taxonomy' => 'product_cat',
			'field' => 'slug',
			'terms' => $products_cat
		);
	}

	if ($attributes) {
		foreach ($attributes as $attr => $attr_arr) {
			if (!in_array('0', $attr_arr, true) && !empty($attr_arr)) {
				$tax_query[] = array(
					'taxonomy' => 'pa_' . $attr,
					'field' => 'slug',
					'terms' => $attr_arr
				);
			}
		}
	}

	if ($featured_only) {
		$tax_query[] = array(
			'taxonomy' => 'product_visibility',
			'field' => 'name',
			'terms' => 'featured',
		);
	}

	if ($stock_only) {
		$tax_query[] = array(
			'taxonomy' => 'product_visibility',
			'field' => 'name',
			'terms' => array('outofstock'),
			'operator' => 'NOT IN'
		);
	}

	$args = array(
		'post_type' => 'product',
		'post_status' => 'publish',
		'orderby' => $orderby,
		'order' => $order,
		'paged' => $page,
		'posts_per_page' => $ppp,
		'tax_query' => $tax_query,
	);

	if ($orderby == 'popularity') {
		$args['meta_key'] = 'total_sales';
		$args['orderby'] = array('meta_value_num' => 'DESC', 'ID' => 'DESC');
	}

	if ($orderby == 'price') {
		$args['meta_key'] = '_price';
		$args['orderby'] = 'meta_value_num';
	}

	if ($orderby == 'rating') {
		$args['orderby'] = 'meta_value_num';
		$args['meta_key'] = '_wc_average_rating';
	}

	if ($sale_only) {
		$args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
	}

	if ($price) {
		$args['meta_query'] = array(
			array(
				'key' => '_price',
				'value' => $price,
				'compare' => 'BETWEEN',
				'type' => 'NUMERIC'
			),
		);
	}

	if ($search) {
		$args['s'] = $search;
	}

	$portfolio_loop = new WP_Query($args);

	return $portfolio_loop;
}

function thegem_extended_product_render_item($settings, $post_id = false) {
	global $post, $product, $woocommerce_loop;

	if ($post_id) {
		$slugs = wp_get_object_terms($post_id, 'product_cat', array('fields' => 'slugs'));

		//$thegem_product_featured_data = get_post_meta($post_id, 'thegem_product_featured_data', 1);
		$thegem_product_featured_data = thegem_get_sanitize_product_featured_data(get_the_ID());

		//if ($settings['ignore_highlights'] != 'yes' && !empty($thegem_product_featured_data['highlight_type'])) {
		if ($settings['ignore_highlights'] != 'yes' && !empty($thegem_product_featured_data['highlight'])) {
			$thegem_highlight_type = $thegem_product_featured_data['highlight_type'];
		} else {
			$thegem_highlight_type = 'disabled';
		}
	} else {
		$slugs = array();
		$product_grid_item_size = true;
		$thegem_highlight_type = 'disabled';
	}

	$thegem_classes = array('portfolio-item', 'inline-column', 'product');
	$thegem_classes = array_merge($thegem_classes, $slugs);

	$thegem_image_classes = array('image');
	$thegem_caption_classes = array('caption');

	if ($settings['layout'] != 'metro') {

		if ($settings['columns_mobile'] == '1x') {
			$thegem_classes = array_merge($thegem_classes, array('col-xs-12'));
		} else if ($settings['columns_mobile'] == '2x') {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-xs-12'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-xs-6'));
		}

		if ($settings['columns_tablet'] == '2x') {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-sm-12'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-sm-6'));
		} else if ($settings['columns_tablet'] == '3x') {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-sm-8'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-sm-4'));
		} else if ($settings['columns_tablet'] == '4x') {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-sm-6'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-sm-3'));
		}

		if ($settings['columns_desktop'] == '2x') {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-md-12'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-md-6'));
			if ($settings['caption_position'] == 'hover')
				$thegem_classes = array_merge($thegem_classes, array('bigger'));
		} else if ($settings['columns_desktop'] == '3x') {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-md-8'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-md-4'));
		} else if ($settings['columns_desktop'] == '4x' || ($settings['columns_desktop'] == '100%' && $settings['columns_100'] == '4')) {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-md-6'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-md-3'));
		} else if ($settings['columns_desktop'] == '5x' || ($settings['columns_desktop'] == '100%' && $settings['columns_100'] == '5')) {
			$thegem_classes = array_merge($thegem_classes, array('columns-desktop-5'));
		} else if ($settings['columns_desktop'] == '6x' || ($settings['columns_desktop'] == '100%' && $settings['columns_100'] == '6')) {
			if ($thegem_highlight_type != 'disabled' && $thegem_highlight_type != 'vertical')
				$thegem_classes = array_merge($thegem_classes, array('col-md-4'));
			else
				$thegem_classes = array_merge($thegem_classes, array('col-md-2'));
		}

	}

	if ($thegem_highlight_type != 'disabled') {
		$thegem_classes[] = 'double-item';
	}

	if ($thegem_highlight_type != 'disabled') {
		$thegem_classes[] = 'double-item-' . $thegem_highlight_type;
	}


	$thegem_sizes = thegem_image_sizes();

	if ($settings['columns_desktop'] == '5x' || $settings['columns_desktop'] == '6x') {
		$columns_desktop = '4x';
	} else {
		$columns_desktop = $settings['columns_desktop'];
	}

	$thegem_sources = array();

	if ($settings['layout'] == 'masonry') {
		$thegem_size = 'thegem-portfolio-masonry';
		$base_size = $thegem_size;
		if ($thegem_highlight_type != 'disabled') {
			$thegem_size .= '-double';

			if ($thegem_highlight_type != 'squared') {
				$thegem_size .= '-' . $thegem_highlight_type;
			}
		}

		if ($thegem_highlight_type == 'disabled' || $thegem_highlight_type == 'vertical') {

			$retina_size = $settings['layout'] == 'justified' ? $thegem_size : 'thegem-portfolio-masonry-double';

			if ($settings['columns_desktop'] == '100%') {
				if ($settings['layout'] == 'justified' || $settings['layout'] == 'masonry') {
					if ($settings['columns_100'] == '6') {
						$columns100 = '5x';
					} else {
						$columns100 = $settings['columns_100'] . 'x';
					}

					$thegem_sources = array(
						array('media' => '(max-width: 550px)', 'srcset' => array('1x' => $base_size . '-' . $settings['columns_mobile'] . '-500', '2x' => $retina_size)),
						array('media' => '(min-width: 1280px) and (max-width: 1495px)', 'srcset' => array('1x' => $base_size . '-fullwidth-' . $settings['columns_tablet'], '2x' => $retina_size)),
						array('media' => '(max-width: 1920px)', 'srcset' => array('1x' => $base_size . '-fullwidth-' . $columns100, '2x' => $retina_size))
					);
				}
			} else {
				if ($settings['layout'] == 'justified' || $settings['layout'] == 'masonry') {
					$thegem_sources = array(
						array('media' => '(max-width: 550px)', 'srcset' => array('1x' => $base_size . '-' . $settings['columns_mobile'] . '-500', '2x' => $retina_size)),
						array('media' => '(max-width: 1100px)', 'srcset' => array('1x' => $base_size . '-' . $settings['columns_tablet'], '2x' => $retina_size)),
						array('media' => '(max-width: 1920px)', 'srcset' => array('1x' => $base_size . '-' . $columns_desktop, '2x' => $retina_size))
					);
				}
			}
		}

		if ($thegem_highlight_type == 'horizontal') {
			$thegem_sources = array(
				array('media' => '(max-width: 550px)', 'srcset' => array('1x' => $base_size . '-2x-500', '2x' => $base_size))
			);
		}
	} elseif ($settings['layout'] == 'metro') {
		$thegem_size = 'thegem-portfolio-metro';
		$retina_size = 'thegem-portfolio-metro-retina';
		$base_size = $thegem_size;

		if ($settings['columns_desktop'] == '2x') {
			$thegem_size = 'thegem-portfolio-metro-large';
		}

		if ($settings['columns_tablet'] == '4x') {
			$image_size_tablet = 'thegem-portfolio-metro-medium';
		} else {
			$image_size_tablet = 'thegem-portfolio-metro';
		}

		if ($settings['columns_mobile'] == '2x') {
			$image_size_mobile = 'thegem-portfolio-metro';
		} else {
			$image_size_mobile = 'thegem-portfolio-metro-large';
		}

		$thegem_sources = array(
			array('media' => '(max-width: 767px)', 'srcset' => array('1x' => $image_size_mobile, '2x' => $retina_size)),
			array('media' => '(max-width: 992px)', 'srcset' => array('1x' => $image_size_tablet, '2x' => $retina_size)),
			array('srcset' => array('1x' => $thegem_size, '2x' => $retina_size)),

			array('media' => '(min-width: 550px) and (max-width: 1100px)', 'srcset' => array('1x' => 'thegem-portfolio-metro-medium', '2x' => 'thegem-portfolio-metro-retina'))
		);
	} else {

		if ($settings['columns_desktop'] == '6x' || $settings['columns_desktop'] == '5x' || ($settings['columns_desktop'] == '100%' && ($settings['columns_100'] == '5' || $settings['columns_100'] == '6'))) {
			$image_size = 'm';
		} else if ($settings['columns_desktop'] == '4x' || ($settings['columns_desktop'] == '100%' && $settings['columns_100'] == '4')) {
			$image_size = 'l';
		} else {
			$image_size = 'xl';
		}

		if ( $settings['fullwidth_section_images'] == 'yes') {
			if ($settings['columns_desktop'] == '6x' || $settings['columns_desktop'] == '5x' || ($settings['columns_desktop'] == '100%' && ($settings['columns_100'] == '5' || $settings['columns_100'] == '6'))) {
				$image_size = 'm';
			} else if ($settings['columns_desktop'] == '4x' || ($settings['columns_desktop'] == '100%' && $settings['columns_100'] == '4')) {
				$image_size = 'l';
			} else {
				$image_size = 'xl';
			}
		} else {
			if ($settings['columns_desktop'] == '6x') {
				$image_size = 'xs';
			} else if ($settings['columns_desktop'] == '4x' || $settings['columns_desktop'] == '5x') {
				$image_size = 's';
			} else if ($settings['columns_desktop'] == '3x' || ($settings['columns_desktop'] == '100%' && ($settings['columns_100'] == '5' || $settings['columns_100'] == '6'))) {
				$image_size = 'm';
			} else if ($settings['columns_desktop'] == '100%' && $settings['columns_100'] == '4') {
				$image_size = 'l';
			} else {
				$image_size = 'xl';
			}
		}

		if ($settings['columns_tablet'] == '4x') {
			$image_size_tablet = 's';
		} else if ($settings['columns_tablet'] == '3x') {
			$image_size_tablet = 'm';
		} else {
			$image_size_tablet = 'l';
		}

		if ($settings['columns_mobile'] == '2x') {
			$image_size_mobile = 'm';
		} else {
			$image_size_mobile = '';
		}

		$thegem_size = 'thegem-product-justified-' . $settings['image_aspect_ratio'];

		$base_size = $thegem_size;
		if ($thegem_highlight_type != 'disabled') {

			$thegem_size .= '-double';

			if ($settings['caption_position'] == 'page' && $thegem_highlight_type != 'horizontal') {
				$thegem_size .= '-page';
			}

			if ($thegem_highlight_type != 'squared') {
				$thegem_size .= '-' . $thegem_highlight_type;
			}
			$retina_size = $thegem_size;
		} else {
			$retina_size = $thegem_size . '-double';
		}
		if ($settings['columns_mobile'] == '1x') {
			$thegem_size_mobile = $base_size;
		} else {
			$thegem_size_mobile = $thegem_size . '-' . $image_size_mobile;
		}
		$thegem_size_tablet = $thegem_size . '-' . $image_size_tablet;
		$thegem_size .= '-' . $image_size;

		$thegem_sources = array(
			array('media' => '(max-width: 767px)', 'srcset' => array('1x' => $thegem_size_mobile, '2x' => $retina_size)),
			array('media' => '(max-width: 992px)', 'srcset' => array('1x' => $thegem_size_tablet, '2x' => $retina_size)),
			array('srcset' => array('1x' => $thegem_size, '2x' => $retina_size)),
		);

	}

	$thegem_classes[] = 'item-animations-not-inited';

	$thegem_size = apply_filters('portfolio_size_filter', $thegem_size);


	if ($settings['caption_position'] == 'image') {
		$hover_effect = $settings['image_hover_effect_image'];
	} else if ($settings['caption_position'] == 'page') {
		$hover_effect = $settings['image_hover_effect_page'];
	} else {
		$hover_effect = $settings['image_hover_effect_hover'];
	}

	if (!isset($product_grid_item_size)) {
		$product_hover_image_id = 0;
		if ($settings['caption_position'] == 'page' || ($hover_effect == 'slide' || $hover_effect == 'fade')) {
			$gallery = $product->get_gallery_image_ids();
			$has_product_hover = get_post_meta($post_id, 'thegem_product_disable_hover', true);
			if (isset($gallery[0]) && !$has_product_hover) {
				$product_hover_image_id = $gallery[0];
				$thegem_classes[] = 'image-hover';
			}
		}

		$rating_count = $product->get_rating_count();
		if ($rating_count > 0) {
			$thegem_classes[] = 'has-rating';
		}

		$product_short_description = $product->get_short_description();
		$product_short_description = strip_shortcodes($product_short_description);
		$product_short_description = wp_strip_all_tags($product_short_description);
		$product_short_description_length = apply_filters('excerpt_length', 20);
		$product_short_description_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');
		$product_short_description = wp_trim_words($product_short_description, $product_short_description_length, $product_short_description_more);
	}

	$add_to_cart_class = '';

	if ($settings['product_show_add_to_cart_mobiles'] != 'yes') {
		$add_to_cart_class = 'hide-tablet hide-mobile';
	}

	if ($settings['cart_button_show_icon'] != 'yes') {
		$add_to_cart_class .= ' center';
	}

	$preset_path = __DIR__ . '/templates/content-product-grid-item.php';
	$preset_path_filtered = apply_filters('thegem_extended_products_grid_item_preset', $preset_path);
	$preset_path_theme = get_stylesheet_directory() . '/templates/products-grid/content-product-grid-item.php';

	if (!empty($preset_path_theme) && file_exists($preset_path_theme)) {
		include($preset_path_theme);
	} else if (!empty($preset_path_filtered) && file_exists($preset_path_filtered)) {
		include($preset_path_filtered);
	}

}

function thegem_get_extended_product_price_range($featured_only = false, $sale_only = false, $products_cat = null, $attributes = null) {
	if (!$products_cat && !$attributes) {
		return null;
	}

	$tax_query = [];

	if ($products_cat && !in_array('0', $products_cat, true)) {
		$tax_query[] = array(
			'taxonomy' => 'product_cat',
			'field' => 'slug',
			'terms' => $products_cat
		);
	}

	if ($attributes) {
		foreach ($attributes as $attr => $attr_arr) {
			if (!empty($attr_arr)) {
				$tax_query[] = array(
					'taxonomy' => 'pa_' . $attr,
					'field' => 'slug',
					'terms' => $attr_arr
				);
			}
		}
	}

	if ($featured_only) {
		$tax_query[] = array(
			'taxonomy' => 'product_visibility',
			'field' => 'name',
			'terms' => 'featured',
		);
	}


	$args = array(
		'post_type' => 'product',
		'post_status' => 'publish',
		'posts_per_page' => -1,
		'tax_query' => $tax_query,
	);

	if ($sale_only) {
		$args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
	}

	$portfolio_loop = new WP_Query($args);

	$price['min'] = 1000000;
	$price['max'] = 0;

	while ($portfolio_loop->have_posts()) : $portfolio_loop->the_post();
		global $product;
		if ($product->get_price() && $product->get_price() > $price['max']) {
			$price['max'] = $product->get_price();
		}
		if ($product->get_price() && $product->get_price() < $price['min']) {
			$price['min'] = $product->get_price();
		}
	endwhile;

	return $price;
}