<?php use Elementor\Icons_Manager;

remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_after_shop_loop_item', 'thegem_woocommerce_after_shop_loop_item_link', 15);
remove_action('woocommerce_after_shop_loop_item', 'thegem_woocommerce_after_shop_loop_item_wishlist', 20);

if (!isset($product_grid_item_size)): ?>
	<div <?php post_class($thegem_classes, $post_id); ?>
			style="padding: calc(<?= $settings['image_gaps']['size'] . $settings['image_gaps']['unit'] ?>/2)">
		<div class="item-separator-box"></div>
		<div class="actions woocommerce_before_shop_loop_item">
			<?php do_action('woocommerce_before_shop_loop_item'); ?>
		</div>
		<div class="wrap clearfix">
			<div <?php post_class($thegem_image_classes, $post_id); ?>>
				<div class="image-inner <?php if (!$product_hover_image_id) {
					echo 'fallback-' . $settings['image_hover_effect_fallback'];
				} ?>">
					<?php if (has_post_thumbnail($post_id)): ?>
						<?php
						$picture_info = thegem_generate_picture(get_post_thumbnail_id($post_id), $thegem_size, $thegem_sources, array('alt' => get_the_title($post_id), /*'style' => 'max-width: 110%'*/), true);
						if ($picture_info && !empty($picture_info['default']) && !empty($picture_info['default'][0]) && $product_hover_image_id) {
							$thegem_hover_size = $thegem_size;
							if ($settings['layout'] == 'masonry') {
								$thegem_hover_size = $thegem_size . '-' . $picture_info['default'][1] . '-' . $picture_info['default'][2];
								global $thegem_size_template_global, $picture_info_template_global, $thegem_hover_size_template_global;
								$thegem_size_template_global = $thegem_size;
								$picture_info_template_global = $picture_info;
								$thegem_hover_size_template_global = $thegem_hover_size;
								add_filter('thegem_image_sizes', function ($sizes) {
									global $thegem_size_template_global, $picture_info_template_global, $thegem_hover_size_template_global;
									$size = $sizes[$thegem_size_template_global];
									$size[1] = $picture_info_template_global['default'][2];
									$size[2] = true;
									$sizes[$thegem_hover_size_template_global] = $size;
									return $sizes;
								});
								$thegem_sources = array();
							}
							if ($settings['layout'] == 'metro') {
								$thegem_hover_size = $thegem_size . '-' . $picture_info['default'][1] . '-' . $picture_info['default'][2];
								global $thegem_size_template_global, $picture_info_template_global, $thegem_hover_size_template_global;
								$thegem_size_template_global = $thegem_size;
								$picture_info_template_global = $picture_info;
								$thegem_hover_size_template_global = $thegem_hover_size;
								add_filter('thegem_image_sizes', function ($sizes) {
									global $thegem_size_template_global, $picture_info_template_global, $thegem_hover_size_template_global;
									$size = $sizes[$thegem_size_template_global];
									$size[0] = $picture_info_template_global['default'][1];
									$size[2] = true;
									$sizes[$thegem_hover_size_template_global] = $size;
									return $sizes;
								});
								$thegem_sources = array();
							}
							thegem_generate_picture($product_hover_image_id, $thegem_hover_size, $thegem_sources, array(
								'alt' => get_the_title(),
								'class' => 'image-hover hover-' . $hover_effect,
//								'style' => 'max-width: 110%'
							));
						}
						?>
					<?php endif; ?>
				</div>
				<div class="overlay">
					<div class="overlay-circle"></div>
					<?php if ($settings['caption_position'] != 'page') { ?>
						<div class="links-wrapper">
							<div class="links">
								<div class="portfolio-icons product-bottom">
									<div class="portfolio-icons-inner clearfix">
										<?php if ($settings['quick_view'] == 'yes') {
											echo '<a class="icon quick-view-button" data-product-id="' . $post->ID . '"><i class="default"></i></a>';
										} ?>
										<?php if ($settings['add_to_cart_type'] == 'icon') { ?>
											<!-- Add to cart -->
											<?php if ($product->is_in_stock()): ?>
												<?php if ($product->get_type() === 'variable') { ?>
													<a href="<?php echo $product->add_to_cart_url() ?>"
													   data-quantity="1"
													   class="icon cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button <?php echo $add_to_cart_class; ?>"
													   rel="nofollow">
														<?php
														if (!empty($settings['select_options_icon']['value'])) {
															Icons_Manager::render_icon($settings['select_options_icon'], ['aria-hidden' => 'true']);
														} else { ?>
															<i class="default"></i>
														<?php } ?>
														<?php echo esc_html($product->add_to_cart_text()) ?>
													</a>
												<?php } else if ($product->get_type() === 'simple') { ?>
													<a href="<?php echo $product->add_to_cart_url() ?>"
													   data-quantity="1"
													   class="icon cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button ajax_add_to_cart <?php echo $add_to_cart_class; ?>"
													   data-product_id="<?php echo $product->get_id(); ?>"
													   data-product_sku="<?php echo $product->get_sku(); ?>"
													   aria-label="<?php echo 'Add ' . $product->get_name() . ' to your cart'; ?>"
													   rel="nofollow">
														<?php
														if (!empty($settings['cart_icon']['value'])) {
															Icons_Manager::render_icon($settings['cart_icon'], ['aria-hidden' => 'true']);
														} else { ?>
															<i class="default"></i>
														<?php } ?>
														<?php echo esc_html($product->add_to_cart_text()) ?>
													</a>
												<?php } ?>
											<?php endif; ?>
										<?php } ?>

										<!-- YITH -->
										<?php if (defined('YITH_WCWL') && $settings['product_show_wishlist'] == 'yes'): ?>
											<span class="icon yith-icon">
												<?php if (!empty($settings['add_wishlist_icon']['value'])) {
													Icons_Manager::render_icon($settings['add_wishlist_icon'], ['aria-hidden' => 'true', 'class' => 'add-wishlist-icon']);
												} else { ?>
													<i class="add-wishlist-icon default"></i>
												<?php } ?>
												<?php if (!empty($settings['added_wishlist_icon']['value'])) {
													Icons_Manager::render_icon($settings['added_wishlist_icon'], ['aria-hidden' => 'true', 'class' => 'added-wishlist-icon']);
												} else { ?>
													<i class="added-wishlist-icon default"></i>
												<?php } ?>
												<?php echo do_shortcode("[yith_wcwl_add_to_wishlist icon='']"); ?>
											</span>
										<?php endif; ?>

										<?php if ($settings['social_sharing'] == 'yes'): ?>

											<a href="javascript: void(0);" class="icon share">
												<?php if (!empty($settings['sharing_icon']['value'])) {
													Icons_Manager::render_icon($settings['sharing_icon'], ['aria-hidden' => 'true']);
												} else { ?>
													<i class="default"></i>
												<?php } ?>
											</a>
										<?php endif; ?>
									</div>
									<div class="overlay-line"></div>
									<?php if ($settings['social_sharing'] == 'yes'): ?>
										<div class="portfolio-sharing-pane">
											<?php include 'socials-sharing.php'; ?>
											<?php if (($settings['caption_position'] == 'image' && ($settings['image_hover_effect_image'] == 'slide' || $settings['image_hover_effect_image'] == 'fade')) ||
												($settings['caption_position'] == 'hover' && ($settings['image_hover_effect_hover'] == 'slide' || $settings['image_hover_effect_hover'] == 'fade'))) { ?>
											<?php } ?>
										</div>
									<?php endif; ?>
								</div>

								<div class="caption">
									<?php if (($settings['product_show_categories'] == 'yes' || $settings['product_show_categories_tablet'] == 'yes' || $settings['product_show_categories_mobile'] == 'yes') && (
											($settings['caption_position'] == 'image' && ($settings['image_hover_effect_image'] == 'slide' || $settings['image_hover_effect_image'] == 'fade')) ||
											($settings['caption_position'] == 'hover' && ($settings['image_hover_effect_hover'] == 'slide' || $settings['image_hover_effect_hover'] == 'fade')))) {
										$terms = get_the_terms($product->get_id(), 'product_cat');
										foreach ($terms as $term) {
											$term_links[] = '<a href="#" data-filter-type="category" data-filter="' . $term->slug . '">' . $term->name . '</a>';
										}
										echo '<div class="categories">' . implode(', ', $term_links) . '</div>';
									} ?>
									<div class="actions woocommerce_before_shop_loop_item_title">
										<?php do_action('woocommerce_before_shop_loop_item_title'); ?>
									</div>
									<?php if ($settings['product_show_title'] == 'yes') { ?>
										<div class="title title-h4">
											<?php the_title(); ?>
										</div>
									<?php } ?>

									<div class="product-info clearfix <?php if ($settings['add_to_cart_type'] == 'button') {
										echo 'with-button';
									} ?>">
										<?php if ($settings['caption_position'] == 'hover' && $settings['product_show_description'] == 'yes') { ?>
											<div class="description">
												<?php if ($product_short_description) : ?>
													<div class="subtitle"><?php echo $product_short_description; ?></div>
												<?php endif; ?>
											</div>
										<?php } ?>
										<div class="actions woocommerce_shop_loop_item_title">
											<?php do_action('woocommerce_shop_loop_item_title'); ?>
										</div>
										<?php if ($settings['product_show_price'] == 'yes') { ?>
											<?php woocommerce_template_loop_price(); ?>
										<?php } ?>
										<div class="actions woocommerce_after_shop_loop_item_title">
											<?php do_action('woocommerce_after_shop_loop_item_title'); ?>
										</div>
										<?php if (($settings['product_show_categories'] == 'yes' || $settings['product_show_categories_tablet'] == 'yes' || $settings['product_show_categories_mobile'] == 'yes') && (
												($settings['caption_position'] == 'hover' && $settings['image_hover_effect_hover'] != 'slide' && $settings['image_hover_effect_hover'] != 'fade') ||
												($settings['caption_position'] == 'image' && $settings['image_hover_effect_image'] != 'slide' && $settings['image_hover_effect_image'] != 'fade'))) {
											$terms = get_the_terms($product->get_id(), 'product_cat');
											foreach ($terms as $term) {
												$term_links[] = '<a href="#" data-filter-type="category" data-filter="' . $term->slug . '">' . $term->name . '</a>';
											}
											echo '<div class="categories">' . implode(', ', $term_links) . '</div>';
										} ?>
										<?php if ($settings['product_show_add_to_cart'] == 'yes' && $settings['add_to_cart_type'] == 'button') { ?>
											<!-- Add to cart -->
											<?php if ($product->is_in_stock()): ?>
												<?php if ($product->get_type() === 'variable') { ?>
													<a href="<?php echo $product->add_to_cart_url() ?>"
													   data-quantity="1"
													   class="cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button type_button <?php echo $add_to_cart_class; ?>"
													   rel="nofollow">
														<?php
														if ($settings['cart_button_show_icon'] == 'yes') {
															if (!empty($settings['select_options_icon']['value'])) {
																Icons_Manager::render_icon($settings['select_options_icon'], ['aria-hidden' => 'true']);
																echo '<span class="space"></span>';
															} else { ?>
																<i class="default"></i>
															<?php }
														} ?>
														<span><?php echo $settings['select_options_button_text']; ?></span>
													</a>
												<?php } else if ($product->get_type() === 'simple') { ?>
													<a href="<?php echo $product->add_to_cart_url() ?>"
													   data-quantity="1"
													   class="cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button ajax_add_to_cart type_button <?php echo $add_to_cart_class; ?>"
													   data-product_id="<?php echo $product->get_id(); ?>"
													   data-product_sku="<?php echo $product->get_sku(); ?>"
													   aria-label="<?php echo 'Add ' . $product->get_name() . ' to your cart'; ?>"
													   rel="nofollow">
														<?php
														if ($settings['cart_button_show_icon'] == 'yes') {
															if (!empty($settings['cart_icon']['value'])) {
																Icons_Manager::render_icon($settings['cart_icon'], ['aria-hidden' => 'true']);
																echo '<span class="space"></span>';
															} else { ?>
																<i class="default"></i>
															<?php }
														} ?>
														<span><?php echo $settings['cart_button_text']; ?></span>
													</a>
												<?php } ?>
											<?php endif; ?>
										<?php } ?>
										<?php if ($settings['product_show_reviews'] == 'yes' || $settings['product_show_reviews_tablet'] == 'yes' || $settings['product_show_reviews_mobile'] == 'yes') { ?>
											<div class="reviews"><?php woocommerce_template_loop_rating(); ?></div>
										<?php } ?>
										<div class="actions woocommerce_after_shop_loop_item">
											<?php do_action('woocommerce_after_shop_loop_item'); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>

					<a class="product-link" href="<?php echo get_permalink(); ?>"></a>
					<?php if ($settings['quick_view'] == 'yes' && $settings['caption_position'] == 'page') {
						echo '<span class="quick-view-button title-h6" data-product-id="' . $post->ID . '">' . $settings["quick_view_text"] . '</span>';
					} ?>
				</div>


			</div>

			<div class="labels-outer <?php echo ($settings['caption_position'] == 'page' && $settings['labels_design'] == '2') ? 'relative' : ''; ?>">
				<div class="product-labels style-<?php echo $settings['labels_design'] ?>">
					<?php if ($settings['product_show_out'] == 'yes' && !$product->is_in_stock()) : ?>
						<?php echo apply_filters('woocommerce_out_of_stock_flash', '<span class="label out-of-stock-label title-h6"><span class="rotate-back"><span class="text">' . $settings['out_label_text'] . '</span></span></span>', $post, $product); ?>
					<?php endif; ?>
					<?php if ($settings['product_show_sale'] == 'yes' && $product->is_on_sale()) : ?>
						<?php if ($settings['sale_label_type'] == 'percentage') {
							$percentage = '';
							if ($product->get_type() === 'variable') {
								$children = array_filter(array_map('wc_get_product', $product->get_children()), 'wc_products_array_filter_visible_grouped');
								foreach ($children as $child) {
									$regular_price = (float)$child->get_regular_price();
									$sale_price = (float)$child->get_sale_price();
									if (!empty($sale_price)) {
										$percentage = round(100 - ($sale_price / $regular_price * 100));
										continue;
									}
								}
							} else {
								$regular_price = (float)$product->get_regular_price();
								$sale_price = (float)$product->get_sale_price();
								if (!empty($sale_price) && $sale_price != 0) {
									$percentage = round(100 - ($sale_price / $regular_price * 100));
								}

							}
							$sale_text = $settings['sale_label_prefix'] . $percentage . $settings['sale_label_suffix'];
						} else {
							$sale_text = $settings['sale_label_text'];
						} ?>
						<?php echo apply_filters('woocommerce_sale_flash', '<span class="label onsale title-h6"><span class="rotate-back"><span class="text">' . $sale_text . '</span></span></span>', $post, $product); ?>
					<?php endif; ?>
					<?php if ($settings['product_show_new'] == 'yes' && $product->is_featured()) : ?>
						<?php echo apply_filters('woocommerce_featured_flash', '<span class="label new-label title-h6"><span class="rotate-back"><span class="text">' . $settings['new_label_text'] . '</span></span></span>', $post, $product); ?>
					<?php endif; ?>
				</div>
			</div>

			<?php if (($settings['caption_position'] == 'page')): ?>
				<div <?php post_class($thegem_caption_classes); ?>>
					<div class="product-info clearfix">
						<div class="actions woocommerce_before_shop_loop_item_title">
							<?php do_action('woocommerce_before_shop_loop_item_title'); ?>
						</div>
						<?php if ($settings['product_show_reviews'] == 'yes' || $settings['product_show_reviews_tablet'] == 'yes' || $settings['product_show_reviews_mobile'] == 'yes') { ?>
							<div class="reviews"><?php woocommerce_template_loop_rating(); ?></div>
						<?php } ?>
						<?php if ($settings['product_show_categories'] == 'yes' || $settings['product_show_categories_tablet'] == 'yes' || $settings['product_show_categories_mobile'] == 'yes') {
							$terms = get_the_terms($product->get_id(), 'product_cat');
							foreach ($terms as $term) {
								$term_links[] = '<a href="#" data-filter-type="category" data-filter="' . $term->slug . '">' . $term->name . '</a>';
							}
							echo '<div class="categories">' . implode(', ', $term_links) . '</div>';
						} ?>
						<?php if ($settings['product_show_title'] == 'yes') { ?>
							<div class="title"><a href="<?php echo get_permalink(); ?>"><?php the_title(); ?></a></div>
						<?php } ?>
						<div class="actions woocommerce_shop_loop_item_title">
							<?php do_action('woocommerce_shop_loop_item_title'); ?>
						</div>
						<?php if ($settings['product_show_price'] == 'yes') {
							woocommerce_template_loop_price();
						} ?>
						<div class="actions woocommerce_after_shop_loop_item_title">
							<?php do_action('woocommerce_after_shop_loop_item_title'); ?>
						</div>
					</div>
					<div class="portfolio-icons product-bottom clearfix <?php echo $settings['product_show_add_to_cart'] != 'yes' ? 'empty' : ''; ?>">
						<?php
						if ($settings['product_show_add_to_cart'] == 'yes') {
							if ($settings['add_to_cart_type'] == 'icon') { ?>
								<!-- Add to cart -->
								<?php if ($product->is_in_stock()): ?>
									<?php if ($product->get_type() === 'variable') { ?>
										<a href="<?php echo $product->add_to_cart_url() ?>"
										   data-quantity="1"
										   class="icon cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button <?php echo $add_to_cart_class; ?>"
										   rel="nofollow">
											<?php
											if (!empty($settings['select_options_icon']['value'])) {
												Icons_Manager::render_icon($settings['select_options_icon'], ['aria-hidden' => 'true']);
											} else { ?>
												<i class="default"></i>
											<?php } ?>
											<?php echo esc_html($product->add_to_cart_text()) ?>
										</a>
									<?php } else if ($product->get_type() === 'simple') { ?>
										<a href="<?php echo $product->add_to_cart_url() ?>"
										   data-quantity="1"
										   class="icon cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button ajax_add_to_cart <?php echo $add_to_cart_class; ?>"
										   data-product_id="<?php echo $product->get_id(); ?>"
										   data-product_sku="<?php echo $product->get_sku(); ?>"
										   aria-label="<?php echo 'Add ' . $product->get_name() . ' to your cart'; ?>"
										   rel="nofollow">
											<?php
											if (!empty($settings['cart_icon']['value'])) {
												Icons_Manager::render_icon($settings['cart_icon'], ['aria-hidden' => 'true']);
											} else { ?>
												<i class="default"></i>
											<?php } ?>
											<?php echo esc_html($product->add_to_cart_text()) ?>
										</a>
									<?php } ?>
								<?php endif; ?>
							<?php } else if ($settings['add_to_cart_type'] == 'button') { ?>

								<!-- Add to cart -->
								<?php if ($product->is_in_stock()): ?>
									<?php if ($product->get_type() === 'variable') { ?>
										<a href="<?php echo $product->add_to_cart_url() ?>"
										   data-quantity="1"
										   class="cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button type_button <?php echo $add_to_cart_class; ?>"
										   rel="nofollow">
											<?php
											if ($settings['cart_button_show_icon'] == 'yes') {
												if (!empty($settings['select_options_icon']['value'])) {
													Icons_Manager::render_icon($settings['select_options_icon'], ['aria-hidden' => 'true']);
													echo '<span class="space"></span>';
												} else { ?>
													<i class="default"></i>
												<?php }
											} ?>
											<span><?php echo $settings['select_options_button_text']; ?></span>
										</a>
									<?php } else if ($product->get_type() === 'simple') { ?>
										<a href="<?php echo $product->add_to_cart_url() ?>"
										   data-quantity="1"
										   class="cart button product_type_<?php echo $product->get_type(); ?> add_to_cart_button ajax_add_to_cart type_button <?php echo $add_to_cart_class; ?>"
										   data-product_id="<?php echo $product->get_id(); ?>"
										   data-product_sku="<?php echo $product->get_sku(); ?>"
										   aria-label="<?php echo 'Add ' . $product->get_name() . ' to your cart'; ?>"
										   rel="nofollow">
											<?php
											if ($settings['cart_button_show_icon'] == 'yes') {
												if (!empty($settings['cart_icon']['value'])) {
													Icons_Manager::render_icon($settings['cart_icon'], ['aria-hidden' => 'true']);
													echo '<span class="space"></span>';
												} else { ?>
													<i class="default"></i>
												<?php }
											} ?>
											<span><?php echo $settings['cart_button_text']; ?></span>
										</a>
									<?php } ?>
								<?php endif;
							}
						}


						if ($settings['product_show_add_to_cart'] != 'yes' || $settings['add_to_cart_type'] == 'button') { ?>
						<div class="icons-top">
							<?php } ?>

							<!-- YITH -->
							<?php if (defined('YITH_WCWL') && $settings['product_show_wishlist'] == 'yes'): ?>
								<span class="yith-icon">
									<?php if (!empty($settings['add_wishlist_icon']['value'])) {
										Icons_Manager::render_icon($settings['add_wishlist_icon'], ['aria-hidden' => 'true', 'class' => 'add-wishlist-icon']);
									} else { ?>
										<i class="add-wishlist-icon default"></i>
									<?php } ?>
									<?php if (!empty($settings['added_wishlist_icon']['value'])) {
										Icons_Manager::render_icon($settings['added_wishlist_icon'], ['aria-hidden' => 'true', 'class' => 'added-wishlist-icon']);
									} else { ?>
										<i class="added-wishlist-icon default"></i>
									<?php } ?>
									<?php echo do_shortcode("[yith_wcwl_add_to_wishlist icon='']"); ?>
<!--									--><?php //echo do_shortcode("[yith_wcwl_add_to_wishlist icon='' link_classes='wishlist add_to_wishlist icon' loop_position='before_image' browse_wishlist_text='' product_added_text='" . $settings['added_wishlist_text'] . "']"); ?>
								</span>
							<?php endif; ?>

							<!-- Sharing -->
							<?php if ($settings['social_sharing'] == 'yes'): ?>
								<div class="post-footer-sharing">
									<a href="javascript: void(0);" class="icon share">
										<?php if (!empty($settings['sharing_icon']['value'])) {
											Icons_Manager::render_icon($settings['sharing_icon'], ['aria-hidden' => 'true']);
										} else { ?>
											<i class="default"></i>
										<?php } ?>
									</a>
									<div class="sharing-popup"><?php include 'socials-sharing.php'; ?>
										<svg class="sharing-styled-arrow">
											<use xlink:href="<?php echo esc_url(get_template_directory_uri() . '/css/post-arrow.svg'); ?>#dec-post-arrow"></use>
										</svg>
									</div>
								</div>
							<?php endif; ?>

							<?php if ($settings['product_show_add_to_cart'] != 'yes' || $settings['add_to_cart_type'] == 'button') { ?>
						</div>
					<?php } ?>

					</div>
					<div class="actions woocommerce_after_shop_loop_item">
						<?php do_action('woocommerce_after_shop_loop_item'); ?>
					</div>
					<?php if ($settings['product_show_price'] == 'yes' && !$product->get_price_html()) { ?>
						<!--						<span class="price empty-price">OUT</span>-->
					<?php } ?>
				</div>
			<?php endif; ?>

		</div>
	</div>
<?php else:
	array_push($thegem_classes, 'size-item'); ?>
	<div <?php post_class($thegem_classes); ?>>
	</div>
<?php endif; ?>
