<?php
/*
	Controller for vodafone
*/

Class Vodafone extends CI_Controller
{
	
	public $arrayEditionDetails = [] ;
	
	function __construct()
	{
		parent::__construct();
		$this->load->model('users');

		if ( $this->session->userdata('type') != "superadmin") {
				redirect('/', 'refresh');
				exit;
		}
		
		
		$getProductEditions  = $this->users->getProductEditions() ;
		
		if ( $getProductEditions ) {
		
			foreach( $getProductEditions as $data ) {
				$this->arrayEditionDetails[$data['edition_code']] = $data['edition_name'] ;	
			}
		
		
		}
	}


	function vodafoneorder()
	{
		$this->load->view('order/vodafoneorder');
	}
	
	public function getSubscriptions()
	{
		$orderType = $this->input->post('type') ;
		
		if ( $orderType ) {
			
			if ( $orderType == "getOrder" ) { // For Order Tab
				$getSubscriptions = $this->users->getSubscriptions();
			} elseif ( $orderType == "getOrderModifications" ) {  // For Order Modifications Tab
				$getSubscriptions = $this->users->getOrderModifications();
			} elseif ( $orderType == "getOrderCancellations" ) {
				$getSubscriptions = $this->users->getOrderCancellations();
			} elseif ( $orderType == "getOrderNotices" ) {
				$getSubscriptions = $this->users->getOrderNotices();
			} else{
				echo json_encode([ 'error' => 1, 'data' => '' ]);
				exit ;
			}
			
			if ( $getSubscriptions ) {
				
				for( $i=0; $i<count($getSubscriptions);$i++ ){
					
					$getSubscriptions[$i]['created_at'] = date('d F Y H:i:s', strtotime($getSubscriptions[$i]['created_at']));
					
					$getSubscriptions[$i]['payload_company_name'] = ( isset($getSubscriptions[$i]['payload_company_name']) && $getSubscriptions[$i]['payload_company_name'] ? $getSubscriptions[$i]['payload_company_name'] : '-' ) ;
					
					$getSubscriptions[$i]['creator_email'] = ( isset($getSubscriptions[$i]['creator_email']) && $getSubscriptions[$i]['creator_email'] ? $getSubscriptions[$i]['creator_email'] : '-' ) ;
					
					$getSubscriptions[$i]['creator_firstName'] = ( isset($getSubscriptions[$i]['creator_firstName']) && $getSubscriptions[$i]['creator_firstName'] ? $getSubscriptions[$i]['creator_firstName'] : '-' ) ;
					
					
					$getSubscriptions[$i]['creator_lastName'] = ( isset($getSubscriptions[$i]['creator_lastName']) && $getSubscriptions[$i]['creator_lastName'] ? $getSubscriptions[$i]['creator_lastName'] : '-' ) ;
					
					$getSubscriptions[$i]['order_editionCode']  = ( isset( $this->arrayEditionDetails[$getSubscriptions[$i]['order_editionCode']] ) ? $this->arrayEditionDetails[$getSubscriptions[$i]['order_editionCode']] :  ( $getSubscriptions[$i]['order_editionCode'] ? $getSubscriptions[$i]['order_editionCode'] : '-')   ) ;
					
					$order_pricingDuration = ( isset($getSubscriptions[$i]['order_pricingDuration']) && $getSubscriptions[$i]['order_pricingDuration'] ? $getSubscriptions[$i]['order_pricingDuration'] : '-' ) ;
					
					$orderUnits		= json_decode($getSubscriptions[$i]['payload_order_item'], true) ;
					
					if ($orderUnits) {
						
						if ( isset( $orderUnits[0]['quantity']  ) ) {
							$lisenceQuantity = $orderUnits[0]['quantity'] ;
						} elseif( isset( $orderUnits['quantity'] ) ) {
							$lisenceQuantity = $orderUnits['quantity'] ;
						} else {
							$lisenceQuantity = "-" ;
						}
						
					} else {
						$lisenceQuantity = "-" ;
					}
					
					$getSubscriptions[$i]['order_pricingDuration'] = $lisenceQuantity . "/" . $order_pricingDuration ;
					
					
					$getSubscriptions[$i]['billing_address_line1']  = ( $getSubscriptions[$i]['billing_address_line1'] ? $getSubscriptions[$i]['billing_address_line1'] : '-' ) ;
					$getSubscriptions[$i]['billing_address_line2']  = ( $getSubscriptions[$i]['billing_address_line2'] ? $getSubscriptions[$i]['billing_address_line2'] : '-' ) ;
					$getSubscriptions[$i]['billing_address_line3']  = ( $getSubscriptions[$i]['billing_address_line3'] ? $getSubscriptions[$i]['billing_address_line3'] : '-' ) ;
					$getSubscriptions[$i]['billing_city']  			= ( $getSubscriptions[$i]['billing_city'] ? $getSubscriptions[$i]['billing_city'] : '-' ) ;
					$getSubscriptions[$i]['billing_phone_number']   = ( $getSubscriptions[$i]['billing_phone_number'] ? $getSubscriptions[$i]['billing_phone_number'] : '-' ) ;
					$getSubscriptions[$i]['billing_postCode']       = ( $getSubscriptions[$i]['billing_postCode'] ? $getSubscriptions[$i]['billing_postCode'] : '-' ) ;
					$getSubscriptions[$i]['billing_state']          = ( $getSubscriptions[$i]['billing_state'] ? $getSubscriptions[$i]['billing_state'] : '-' ) ;
					
					
				}

				echo json_encode([ 'error' => 0, 'data' => $getSubscriptions ]);
			
			} else {
				echo json_encode([ 'error' => 1, 'data' => '' ]);
			}
		} else {
				echo json_encode([ 'error' => 1, 'data' => '' ]);
		}
		
	}
	
	
	public function getModalData() {
	
	
		$type 					 	= $this->input->post('type') ;
		$accountIdentifier  		= $this->input->post('accountIdentifier') ;
		$vodafone_market_place_id  	= $this->input->post('vodafone_market_place_id') ;
	
		if ( $type && $accountIdentifier && $vodafone_market_place_id ) {
		
			if ( $type == "getSingleOrderModifications" ) {
				
				$getSubscriptions = $this->users->getSingleOrderModifications($vodafone_market_place_id, $accountIdentifier);
				
			} elseif( $type == "getSingleOrderNotices" ) {
						
				$getSubscriptions = $this->users->getSingleOrderNotices($vodafone_market_place_id, $accountIdentifier);
				
			
			} else {
				echo json_encode([ 'error' => 1, 'data' => '' ]);
				exit ;
			}
			
			
			if ( $getSubscriptions ) {
				
				for( $i=0; $i<count($getSubscriptions);$i++ ){
					
					$getSubscriptions[$i]['created_at'] = date('d F Y H:i:s', strtotime($getSubscriptions[$i]['created_at']));
					
					$getSubscriptions[$i]['payload_company_name'] = ( isset($getSubscriptions[$i]['payload_company_name']) && $getSubscriptions[$i]['payload_company_name'] ? $getSubscriptions[$i]['payload_company_name'] : '-' ) ;
					
					$getSubscriptions[$i]['creator_email'] = ( isset($getSubscriptions[$i]['creator_email']) && $getSubscriptions[$i]['creator_email'] ? $getSubscriptions[$i]['creator_email'] : '-' ) ;
					
					$getSubscriptions[$i]['creator_firstName'] = ( isset($getSubscriptions[$i]['creator_firstName']) && $getSubscriptions[$i]['creator_firstName'] ? $getSubscriptions[$i]['creator_firstName'] : '-' ) ;
					
					
					$getSubscriptions[$i]['creator_lastName'] = ( isset($getSubscriptions[$i]['creator_lastName']) && $getSubscriptions[$i]['creator_lastName'] ? $getSubscriptions[$i]['creator_lastName'] : '-' ) ;
					
					$getSubscriptions[$i]['order_editionCode']  = ( isset( $this->arrayEditionDetails[$getSubscriptions[$i]['order_editionCode']] ) ? $this->arrayEditionDetails[$getSubscriptions[$i]['order_editionCode']] :  ( $getSubscriptions[$i]['order_editionCode'] ? $getSubscriptions[$i]['order_editionCode'] : '-')   ) ;
					
					$order_pricingDuration = ( isset($getSubscriptions[$i]['order_pricingDuration']) && $getSubscriptions[$i]['order_pricingDuration'] ? $getSubscriptions[$i]['order_pricingDuration'] : '-' ) ;
					
					$orderUnits		= json_decode($getSubscriptions[$i]['payload_order_item'], true) ;
					
					if ($orderUnits) {
						
						if ( isset( $orderUnits[0]['quantity']  ) ) {
							$lisenceQuantity = $orderUnits[0]['quantity'] ;
						} elseif( isset( $orderUnits['quantity'] ) ) {
							$lisenceQuantity = $orderUnits['quantity'] ;
						} else {
							$lisenceQuantity = "-" ;
						}
						
					} else {
						$lisenceQuantity = "-" ;
					}
					
					$getSubscriptions[$i]['order_pricingDuration'] = $lisenceQuantity . "/" . $order_pricingDuration ;
					
					
					$getSubscriptions[$i]['billing_address_line1']  = ( $getSubscriptions[$i]['billing_address_line1'] ? $getSubscriptions[$i]['billing_address_line1'] : '-' ) ;
					$getSubscriptions[$i]['billing_address_line2']  = ( $getSubscriptions[$i]['billing_address_line2'] ? $getSubscriptions[$i]['billing_address_line2'] : '-' ) ;
					$getSubscriptions[$i]['billing_address_line3']  = ( $getSubscriptions[$i]['billing_address_line3'] ? $getSubscriptions[$i]['billing_address_line3'] : '-' ) ;
					$getSubscriptions[$i]['billing_city']  			= ( $getSubscriptions[$i]['billing_city'] ? $getSubscriptions[$i]['billing_city'] : '-' ) ;
					$getSubscriptions[$i]['billing_phone_number']   = ( $getSubscriptions[$i]['billing_phone_number'] ? $getSubscriptions[$i]['billing_phone_number'] : '-' ) ;
					$getSubscriptions[$i]['billing_postCode']       = ( $getSubscriptions[$i]['billing_postCode'] ? $getSubscriptions[$i]['billing_postCode'] : '-' ) ;
					$getSubscriptions[$i]['billing_state']          = ( $getSubscriptions[$i]['billing_state'] ? $getSubscriptions[$i]['billing_state'] : '-' ) ;
					
					
				
				}

				echo json_encode([ 'error' => 0, 'data' => $getSubscriptions ]);
			
			} else {
				echo json_encode([ 'error' => 1, 'data' => '' ]);
			}
			
		
		}  else {
				echo json_encode([ 'error' => 1, 'data' => '' ]);
		}
	
	}
	
	
	public function getCurrentOrders() {
	
		$getSubscriptions = $this->users->getSubscriptions();
	
		if ( $getSubscriptions ) {
			
			$newData 	= [] ;
			$counterNew = 0  ; 
			
			
			for( $i=0; $i<count($getSubscriptions);$i++ ){
				
				$checkIsOrderCancelled = $this->users->checkIsOrderCancelled($getSubscriptions[$i]['id'], $getSubscriptions[$i]['account_identifier']) ;
				
				if ($checkIsOrderCancelled) { // if order is cancelled
					
					// Do nothing
					
				} else { // if order is not cancelled
					
					$getCurrentOrderModifications = $this->users->getCurrentOrderModifications($getSubscriptions[$i]['id'], $getSubscriptions[$i]['account_identifier']) ;
					
					
					if ( $getCurrentOrderModifications ) { // If the order is modified.
						
						$newData[$counterNew]['payload_company_name'] 		 = ( isset($getCurrentOrderModifications['payload_company_name']) && $getCurrentOrderModifications['payload_company_name'] ? $getCurrentOrderModifications['payload_company_name'] : '-' ) ;
						
						
						
						$newData[$counterNew]['creator_email'] 		 = ( isset($getCurrentOrderModifications['creator_email']) && $getCurrentOrderModifications['creator_email'] ? $getCurrentOrderModifications['creator_email'] : '-' ) ;
						
						
						$newData[$counterNew]['creator_firstName'] 		 = ( isset($getCurrentOrderModifications['creator_firstName']) && $getCurrentOrderModifications['creator_firstName'] ? $getCurrentOrderModifications['creator_firstName'] : '-' ) ;
						
						$newData[$counterNew]['creator_lastName'] 		 = ( isset($getCurrentOrderModifications['creator_lastName']) && $getCurrentOrderModifications['creator_lastName'] ? $getCurrentOrderModifications['creator_lastName'] : '-' ) ;
						
						
						$newData[$counterNew]['order_editionCode']  = ( isset( $this->arrayEditionDetails[$getCurrentOrderModifications['order_editionCode']] ) ? $this->arrayEditionDetails[$getCurrentOrderModifications['order_editionCode']] :  ( $getCurrentOrderModifications['order_editionCode'] ? $getCurrentOrderModifications['order_editionCode'] : '-')   ) ;
						
						
						$order_pricingDuration 		 = ( isset($getCurrentOrderModifications['order_pricingDuration']) && $getCurrentOrderModifications['order_pricingDuration'] ? $getCurrentOrderModifications['order_pricingDuration'] : '-' ) ;
						
						
						$orderUnits		= json_decode($getCurrentOrderModifications['payload_order_item'], true) ;
					
						if ($orderUnits) {
							
							if ( isset( $orderUnits[0]['quantity']  ) ) {
								$lisenceQuantity = $orderUnits[0]['quantity'] ;
							} elseif( isset( $orderUnits['quantity'] ) ) {
								$lisenceQuantity = $orderUnits['quantity'] ;
							} else {
								$lisenceQuantity = "-" ;
							}
							
						} else {
							$lisenceQuantity = "-" ;
						}
						
						$newData[$counterNew]['order_pricingDuration'] = $lisenceQuantity . "/" . $order_pricingDuration ;
						
						
						$newData[$counterNew]['created_at']		 		 = date('d F Y H:i:s', strtotime($getCurrentOrderModifications['created_at']));
						
						
						$newData[$counterNew]['order_id'] 		 = ( isset($getCurrentOrderModifications['id']) && $getCurrentOrderModifications['id'] ? $getCurrentOrderModifications['id'] : '' ) ;
						
						
						$newData[$counterNew]['order_table'] 		 = "vodafone_market_place_modifications";
						
						
						/***Billing Address info***/
						
						$newData[$counterNew]['billing_address_line1']  = ( $getCurrentOrderModifications['billing_address_line1'] ? $getCurrentOrderModifications['billing_address_line1'] : '-' ) ;
						
						$newData[$counterNew]['billing_address_line2']  = ( $getCurrentOrderModifications['billing_address_line2'] ? $getCurrentOrderModifications['billing_address_line2'] : '-' ) ;
						
						$newData[$counterNew]['billing_address_line3']  = ( $getCurrentOrderModifications['billing_address_line3'] ? $getCurrentOrderModifications['billing_address_line3'] : '-' ) ;
						
						$newData[$counterNew]['billing_city']  			= ( $getCurrentOrderModifications['billing_city'] ? $getCurrentOrderModifications['billing_city'] : '-' ) ;
						
						$newData[$counterNew]['billing_phone_number']   = ( $getCurrentOrderModifications['billing_phone_number'] ? $getCurrentOrderModifications['billing_phone_number'] : '-' ) ;
						
						$newData[$counterNew]['billing_postCode']       = ( $getCurrentOrderModifications['billing_postCode'] ? $getCurrentOrderModifications['billing_postCode'] : '-' ) ;
						
						$newData[$counterNew]['billing_state']          = ( $getCurrentOrderModifications['billing_state'] ? $getCurrentOrderModifications['billing_state'] : '-' ) ;
						
						
						/***Billing Address info***/
						
					
					} else {
					
						$newData[$counterNew]['payload_company_name'] 		 = ( isset($getSubscriptions[$i]['payload_company_name']) && $getSubscriptions[$i]['payload_company_name'] ? $getSubscriptions[$i]['payload_company_name'] : '-' )  ;
						
						
						$newData[$counterNew]['creator_email'] 		 = ( isset($getSubscriptions[$i]['creator_email']) && $getSubscriptions[$i]['creator_email'] ? $getSubscriptions[$i]['creator_email'] : '-' )  ;
						
						
						$newData[$counterNew]['creator_firstName'] 		 = ( isset($getSubscriptions[$i]['creator_firstName']) && $getSubscriptions[$i]['creator_firstName'] ? $getSubscriptions[$i]['creator_firstName'] : '-' )  ;
						
						$newData[$counterNew]['creator_lastName'] 		 = ( isset($getSubscriptions[$i]['creator_lastName']) && $getSubscriptions[$i]['creator_lastName'] ? $getSubscriptions[$i]['creator_lastName'] : '-' )  ;
						
						$newData[$counterNew]['order_editionCode']  = ( isset( $this->arrayEditionDetails[$getSubscriptions[$i]['order_editionCode']] ) ? $this->arrayEditionDetails[$getSubscriptions[$i]['order_editionCode']] :  ( $getSubscriptions[$i]['order_editionCode'] ? $getSubscriptions[$i]['order_editionCode'] : '-')   ) ;
						
						
						$order_pricingDuration 		 = ( isset($getSubscriptions[$i]['order_pricingDuration']) && $getSubscriptions[$i]['order_pricingDuration'] ? $getSubscriptions[$i]['order_pricingDuration'] : '-' )  ;
						
						
						$orderUnits		= json_decode($getSubscriptions[$i]['payload_order_item'], true) ;
					
						if ($orderUnits) {
							
							if ( isset( $orderUnits[0]['quantity']  ) ) {
								$lisenceQuantity = $orderUnits[0]['quantity'] ;
							} elseif( isset( $orderUnits['quantity'] ) ) {
								$lisenceQuantity = $orderUnits['quantity'] ;
							} else {
								$lisenceQuantity = "-" ;
							}
							
						} else {
							$lisenceQuantity = "-" ;
						}
						
						$newData[$counterNew]['order_pricingDuration'] = $lisenceQuantity . "/" . $order_pricingDuration ;
						
						$newData[$counterNew]['created_at']		 		 = date('d F Y H:i:s', strtotime($getSubscriptions[$i]['created_at']));
						
						$newData[$counterNew]['order_id'] 		 = ( isset($getSubscriptions[$i]['id']) && $getSubscriptions[$i]['id'] ? $getSubscriptions[$i]['id'] : '' )  ; 
						
						
						$newData[$counterNew]['order_table'] 		 = "vodafone_market_place";
						
						/***Billing Address info***/
						
						$newData[$counterNew]['billing_address_line1']  = ( $getSubscriptions[$i]['billing_address_line1'] ? $getSubscriptions[$i]['billing_address_line1'] : '-' ) ;
						
						$newData[$counterNew]['billing_address_line2']  = ( $getSubscriptions[$i]['billing_address_line2'] ? $getSubscriptions[$i]['billing_address_line2'] : '-' ) ;
						
						$newData[$counterNew]['billing_address_line3']  = ( $getSubscriptions[$i]['billing_address_line3'] ? $getSubscriptions[$i]['billing_address_line3'] : '-' ) ;
						
						$newData[$counterNew]['billing_city']  			= ( $getSubscriptions[$i]['billing_city'] ? $getSubscriptions[$i]['billing_city'] : '-' ) ;
						
						$newData[$counterNew]['billing_phone_number']   = ( $getSubscriptions[$i]['billing_phone_number'] ? $getSubscriptions[$i]['billing_phone_number'] : '-' ) ;
						
						$newData[$counterNew]['billing_postCode']       = ( $getSubscriptions[$i]['billing_postCode'] ? $getSubscriptions[$i]['billing_postCode'] : '-' ) ;
						
						$newData[$counterNew]['billing_state']          = ( $getSubscriptions[$i]['billing_state'] ? $getSubscriptions[$i]['billing_state'] : '-' ) ;
						
						
						/***Billing Address info***/
					}
					
					$counterNew++ ;
				}
				
				
			}
			
			if ( $newData ) {
				
				echo json_encode([ 'error' => 0, 'data' => $newData ]);
				
			} else {
				echo json_encode([ 'error' => 1, 'data' => '' ]);
			}
		} else {
			echo json_encode([ 'error' => 1, 'data' => '' ]);
		}
		
	}
	
	function downloadVodafoneOrdersAdmin(){
		
		$this->load->model('users');
		$this->load->library('excel');
		
		$userDetailFolderPath  = $this->config->item('directoryPath') . 'userdetailsadmin/' ;
		$getUserActivityReport = $this->users->getSubscriptions();
		
		//remove previous file
		if( file_exists($userDetailFolderPath.'/vodafone_orders.xlsx') )
		{
			unlink($userDetailFolderPath.'/vodafone_orders.xlsx');
		}


		$fileName = 'vodafone_orders.xlsx';
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Company External Id');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Company Name');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Company UUID');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Editition Code');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Pricing Duration');
		$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Free trial');
		$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Created At');
		$objPHPExcel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A1:G1')->getFont()->setSize(12);
		$objPHPExcel->getActiveSheet()->getStyle('A1:G1')->applyFromArray(
							array(
							'fill' => array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => 'fbf128')
							)
						)
					);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(false);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
		
		$objPHPExcel->getActiveSheet()->freezePane('H2');
		
		$rowCount = 2;
		
		foreach ($getUserActivityReport as $element) {
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $element['payload_company_externalId']);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $element['payload_company_name']);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $element['payload_company_uuid']);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $element['order_editionCode']);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $element['order_pricingDuration']);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $element['order_freeTrial_active']);
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, date('d F Y H:i:s', strtotime($element['created_at'])));
			$rowCount++;
		}
		$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
		if(!is_dir($userDetailFolderPath))
		{
			mkdir($userDetailFolderPath);	
		}
		chmod($userDetailFolderPath, 0777);
		$objWriter->save($userDetailFolderPath.$fileName);
		header("Content-Type: application/vnd.ms-excel");
		redirect(base_url().'assets/userdetailsadmin/'.$fileName);
	}
	
	
	public function getFullDetailWithBillingAddress() {
	
	
		$orderId 			= $this->input->post('orderId') ;
		$orderTable  		= $this->input->post('orderTable') ;
	
		if ( $orderId && $orderTable ) {
			
			$modalData =  $this->users->getFullDetailWithBillingAddress($orderId, $orderTable) ;
			
			//debug($getFullDetailWithBillingAddress, 1) ;  
			
			
			if ( $modalData ) {
				
				$data['business']  = ( $modalData['payload_company_name'] ? $modalData['payload_company_name'] : '-' ) ;
				$data['email']	   = ( $modalData['creator_email'] ? $modalData['creator_email'] : '-' ) ;
				$data['firstName'] = ( $modalData['creator_firstName'] ? $modalData['creator_firstName'] : '-' ) ;
				$data['lastName']  = ( $modalData['creator_lastName'] ? $modalData['creator_lastName'] : '-') ;
				
				$data['editionCode']  = ( isset( $this->arrayEditionDetails[$modalData['order_editionCode']] ) ? $this->arrayEditionDetails[$modalData['order_editionCode']] :  ( $modalData['order_editionCode'] ? $modalData['order_editionCode'] : '-')   ) ;
				
				
				$order_pricingDuration = ( $modalData['order_pricingDuration'] ? $modalData['order_pricingDuration'] : '-' )  ;
					
				$orderUnits		= json_decode($modalData['payload_order_item'], true) ;
					
					if ($orderUnits) {
						
						if ( isset( $orderUnits[0]['quantity']  ) ) {
							$lisenceQuantity = $orderUnits[0]['quantity'] ;
						} elseif( isset( $orderUnits['quantity'] ) ) {
							$lisenceQuantity = $orderUnits['quantity'] ;
						} else {
							$lisenceQuantity = "-" ;
						}
						
					} else {
						$lisenceQuantity = "-" ;
					}
					
					$data['unitsDuration'] = $lisenceQuantity . "/" . $order_pricingDuration ;
				
				
				$data['createdAt'] = date('d F Y H:i:s', strtotime($modalData['created_at']));
				
				
				$data['billing_address_line1']  = ( $modalData['billing_address_line1'] ? $modalData['billing_address_line1'] : '-' ) ;
				$data['billing_address_line2']  = ( $modalData['billing_address_line2'] ? $modalData['billing_address_line2'] : '-' ) ;
				$data['billing_address_line3']  = ( $modalData['billing_address_line3'] ? $modalData['billing_address_line3'] : '-' ) ;
				$data['billing_city']  			= ( $modalData['billing_city'] ? $modalData['billing_city'] : '-' ) ;
				$data['billing_phone_number']   = ( $modalData['billing_phone_number'] ? $modalData['billing_phone_number'] : '-' ) ;
				$data['billing_postCode']       = ( $modalData['billing_postCode'] ? $modalData['billing_postCode'] : '-' ) ;
				$data['billing_state']          = ( $modalData['billing_state'] ? $modalData['billing_state'] : '-' ) ;
				
				
				echo json_encode([ 'error' => 0, 'data' => $data, 'msg' => 'Data found' ]);
				
				
				
				
				
			} else {
				
				echo json_encode([ 'error' => 1, 'data' => '', 'msg' => 'Data not found' ]);
			}
			
			
			
	
		} else {
			echo json_encode([ 'error' => 1, 'data' => '', 'msg' => 'Missing required fields' ]);
		}
		
	}
	
}
