$(document).ready(function () {
	
	getDataForPage(costCentreID) ;
	
	/***To list the data of currently selected folder***/
	 $(document).on("click", ".jstree-anchor", function() {
		 
		var currentAnchorId = $(this).attr('id') ;
		if ( currentAnchorId == "node_1_anchor") {
			return false;
		}

		if ( $(this).hasClass("currentAnchorSelected") ) {
			//alert('Do not hit AJAX') ;
		} else {
			
			$("a.jstree-anchor").removeClass("currentAnchorSelected") ;
			$(this).addClass("currentAnchorSelected") ;
			
			var prefix = $(this).parent().data('delimeter') ;
			
			getDataForPrefixes(prefix, costCentreID) ;
			
		}

	 });
	 /***To list the data of currently selected folder***/

	/***On click of download button***/
	
	$(document).on('click', '.__downloadObjectFile', function() {
		
		var objectKey 	   = $(this).closest('tr').data('uniquekey');
		var objectUrl	   = $(this).closest('tr').data('url');
		var selectedFolder = $("a.currentAnchorSelected").closest('li').data('delimeter') ;
		var costCenter	   = costCentreID;  // defined at view page
		
		$.ajax({
			  url: base_url + 'upload/checkCurrentDownloadedObject' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'objectKey': objectKey, 'selectedFolder':  selectedFolder, 'costCenter':  costCenter} ,
			  beforeSend : function()
			  {
				  $("#__rightBoxTable").hide() ;
				  $("#__skeltonLoaderLeftSide").show();
			  },
			  success:function(response){
				  if (response.error == 0) {
					  $("#__hiddenDownloadButton").attr('href', objectUrl) ;
					  $("#__hiddenDownloadButton")[0].click() ;
					  $("#__skeltonLoaderLeftSide").hide();
					  $("#__rightBoxTable").show() ;
				  } else {
						toastr.error(response.message,"Error",{closeButton:!0});
						$("#__skeltonLoaderLeftSide").hide();
						$("#__rightBoxTable").show() ;
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{closeButton:!0});
					$("#__skeltonLoaderLeftSide").hide();
					$("#__rightBoxTable").show() ;
			  }
		});
	
	});
	
	
	
	/***On click of download button***/
	
}) // end of document ready


function getDataForPage(costCentreID) {
	
	$.ajax({
		  url: base_url + 'upload/listBucketObjectsAjax_Users' ,
		  type: 'post',
		  data: {'costCentreID': costCentreID},
		  dataType: 'json',
		   beforeSend : function()
		  {
				$("#__skeltonLoaderMain").show();
		  },
		  success:function(response){
			   if (response.error == 0) {
				  if (response.rightSideContent != "") {
					$("#__tableBodyData").html(response.rightSideContent) ;
				  } else {
					$("#__tableBodyData").html("<tr class='__noResultsFound'><td colspan='4' class='text-center'>No files found</td></tr>");
				  }
				  $("#__treeStructureData").html(response.treeStructureContent) ;
				  $("#__skeltonLoaderMain").hide();
				  
				  $("._noFolderSharedYet").hide() ;
				  $(".jstree-container-ul").show() ;
				  
				  $("#__topBox, #__rightBox, #__leftBox").show() ;
			  } else {
					
					$("#__skeltonLoaderMain").hide();
					if (response.error == 1 && response.message == "nothing_shared_yet") {
						
						$(".jstree-container-ul").hide() ;
						$("._noFolderSharedYet").show() ;
						
						$("#__topBox, #__rightBox, #__leftBox").show() ;
						$("#__tableBodyData").html("<tr class='__noResultsFound'><td colspan='4' class='text-center'>No content to show</td></tr>");
						
					} else{
						toastr.error(response.message,"Error",{closeButton:!0});
					}
			  }
		  }, error: function (jqXHR, exception) {
			    toastr.error("Network error, please try again later.","Error",{closeButton:!0});
				$("#__skeltonLoaderMain").hide();
		  }
	 });
}


// Get files for folders
function getDataForPrefixes(prefix, costCentreID) {

	$.ajax({
		  url: base_url + 'upload/listBucketObjectsAjaxPrefixes_Users' ,
		  type: 'post',
		  dataType: 'json',
		  data: { 'prefix': prefix, 'costCentreID': costCentreID } ,
		  beforeSend : function()
		  {
			$("#__rightBoxTable").hide() ;
			$("#__skeltonLoaderLeftSide").show();
		  },
		  success:function(response){
			  if (response.error == 0) {
				  if (response.rightSideContent != "") {
					$("#__tableBodyData").html(response.rightSideContent) ;
				  } else {
					$("#__tableBodyData").html("<tr class='__noResultsFound'><td colspan='4' class='text-center'>No files found</td></tr>");
				  }
				   $("#__skeltonLoaderLeftSide").hide();
				   $("#__rightBoxTable").show() ;
			  } else {
					toastr.error(response.message,"Error",{closeButton:!0});
			  }
		  }, error: function (jqXHR, exception) {
				toastr.error("Network error, please try again later.","Error",{closeButton:!0});
				$("#__skeltonLoaderLeftSide").hide();
				$("#__rightBoxTable").show() ;
		  }
	 });
}


