<?php

Class Loneworkerleaves extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users');
	}

	function bookLoneWorkerLeavesSingle(){
		
		if( $this->session->has_userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => "1", 'message' => "Unauthorized access"]) ;
			exit ;
		}
		
		
		
		$loneWorkersData   = json_decode($this->input->post('loneWorkersData'), true);
		$dateUnformatted   = $this->input->post('dateUnformatted') ;
		$explodeDate	   = explode("_", $dateUnformatted) ;
		$explodeDate	   = $explodeDate[0].$explodeDate[1].$explodeDate[2] ;
		$dateFormatted	   = date("Y-m-d", strtotime($explodeDate)) ;
		
		if ( !$loneWorkersData || !$dateUnformatted ) {
			echo json_encode([ 'error' => "1", 'message' => "Missing required parameters"]) ;
			exit ;
		}
		
		
		foreach($loneWorkersData as $loneData) {
			$insertSingleLeave = $this->users->insertSingleLeave($loneData, $dateUnformatted, $dateFormatted);
		}
		
		
		echo json_encode([ 'error' => "0", 'message' => "Data inserted successfully" ]) ;
		
	}
	
	public function getYearlySingleUserLeaveTaken(){
	
		$serialNumber   	= $this->input->post('serialNumber') ;
		$year    		    = $this->input->post('year') ;
		
		if ( !$serialNumber || !$year ) {
			echo json_encode([ 'error' => "1", 'message' => "Missing required parameters"]) ;
			exit ;
		}
		
		$leaveTaken	= $this->users->getYearlySingleUserLeaveTaken($serialNumber,$year) ;
		
		echo json_encode([ 'error' => "0", 'message' => "", 'data' => $leaveTaken]) ;
	}
	
	
	function cancelLoneWorkerLeavesSingle(){
		
		if( $this->session->has_userdata('login_id') != 1 )
		{
			echo json_encode([ 'error' => "1", 'message' => "Unauthorized access"]) ;
			exit ;
		}
		
		
		
		$loneWorkersData   = json_decode($this->input->post('loneWorkersData'), true);
		$dateUnformatted   = $this->input->post('dateUnformatted') ;
		
		if ( !$loneWorkersData || !$dateUnformatted ) {
			echo json_encode([ 'error' => "1", 'message' => "Missing required parameters"]) ;
			exit ;
		}
		
		foreach($loneWorkersData as $loneData) {
			$deleteSingleLeave = $this->users->deleteSingleLeave($loneData, $dateUnformatted);
		}
		
		
		echo json_encode([ 'error' => "0", 'message' => "Data inserted successfully" ]) ;
		
	}
	
	
	

}
