<?php

Class Elearningmoodle extends CI_Model
{
	public function __construct()
	{
		parent::__construct();

		$this->load->database();
	}

	function addElearningCourseToCostCentre($selectedCCId, $mainCourseId, $selectedCCName)
	{
		$data['costcenterID']    = $selectedCCId;
		$data['course_id']   	 = $mainCourseId;
		$data['costcentrename']  = $selectedCCName;

		$query 	   = $this->db->insert('elearning_courses_costcentre', $data);
		return $query ;
	}



	function checkCourseAlreadyAssigned($selectedCCId, $mainCourseId)
	{
		return  $this->db->select('*')->from('elearning_courses_costcentre')->where(['costcenterID' => $selectedCCId, 'course_id' => $mainCourseId])->get()->result_array();

	}

	public function getAssignedCoursesToCostCentre($requestData) {

		$mainCourseId  = $requestData['mainCourseId'];

		$totalData = $this->db->from('elearning_courses_costcentre')->where('course_id', $mainCourseId)->count_all_results();

		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.

		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = $requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "costcentrename" ;
			$orderBy	= "ASC" ;
		}

		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter
			$sql = "SELECT * ";
			$sql.=" FROM elearning_courses_costcentre";
			$sql.=" WHERE (costcentrename LIKE '%".$requestData['search']['value']."%' AND course_id = '".$mainCourseId."') ";

			$sql.=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->db->query($sql)->result_array();


			$totalFilteredSearch = "" ;
			$totalFilteredSearch = "SELECT * ";
			$totalFilteredSearch.=" FROM elearning_courses_costcentre";
			$totalFilteredSearch.=" WHERE (costcentrename LIKE '%".$requestData['search']['value']."%' AND course_id = '".$mainCourseId."') ";

			$querySearch = $this->db->query($totalFilteredSearch)->result_array();
			$totalFiltered = count($querySearch);




		} else {
			$query = $this->db->select('*')
				->from('elearning_courses_costcentre')
				->order_by($columnName, $orderBy)
				->limit($requestData['length'], $requestData['start'])
				->where('course_id', $mainCourseId)
				->get()
				->result_array();

		}

	  $data = [] ;
	  $counter = 0 ;

	  $tableName = $requestData['tableName'];

	  if ($tableName == "tableCCListPage") {

		  foreach ($query as $row) {

			$explode  = explode(" ", $row["costcentrename"]) ;
			$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;

			if (!$initials) {
				$initials = "-" ;
			}


			$data[$counter][] 	= '<figure><span class="userShortname">'.$initials.'</span></figure><span class = "nameListing">'.$row["costcentrename"].'</span><div class="__actionbtnlist"><span class="user-active-time deletetraineeUser __deleteCourseForCostCentre" data-courseid = "'.$row["course_id"].'" data-costcentreid = "'.$row["costcenterID"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="Remove"><i class="fa fa-trash" aria-hidden="true"></i></span></div>' ;
			$counter++ ;
		  }
	  } else {

		  foreach ($query as $row) {

				$explode  = explode(" ", $row["costcentrename"]) ;
				$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;

				if (!$initials) {
					$initials = "-" ;
				}
				$data[$counter][] 	= '<span class="userShortname">'.$initials.'</span>'.$row["costcentrename"].'' ;
				$data[$counter][] 	= '<div class="__actionbtnlist"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="Remove"  class= "__deleteCourseForCostCentre" data-courseid = "'.$row["course_id"].'" data-costcentreid = "'.$row["costcenterID"].'"><i class="fa fa-trash" aria-hidden="true"></i></span></div>' ;
				$counter++ ;
		 }
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}

	function getCourseCostCentres($courseId) {

		$getData = $this->db->select('*')->from('elearning_courses_costcentre')->where(['course_id' => $courseId])->get()->result_array();
		$data = "" ;


		if ($getData) {
			$counter = 1 ;
			foreach($getData as $value){

				$explode  = explode(" ", $value["costcentrename"]) ;
				$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;

				if (!$initials) {
					$initials = "-" ;
				}

				$data .= '<li><span class="userShortname">'.$initials.'</span>' ;


				if ( $counter == '3' ) {
					$moreUsersCount  =  ( count($getData) - 3 ) ;
					if ($moreUsersCount != '0') {
						$data .= '<li class="last-member"><span class="userShortname">+'.$moreUsersCount.'</span></li>' ;
					}
					break ;

				}

				$counter++ ;
			}

		}

		return $data ;

	}


	function getTraineeInitialsListingManager($courseId, $userLinkAccountid, $dbColumnName) {

		$getData = $this->db->select('t1.id ,t1.course_id, t2.first_name,t2.last_name, t2.id as traineeId,t2.cost_centre_id')
         ->from('elearning_user_courses as t1')
         ->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
         ->where(['t1.course_id' => $courseId, 't2.'.$dbColumnName => $userLinkAccountid])
         ->get()
		 ->result_array();

		$data = "" ;


		if ($getData) {
			$counter = 1 ;
			foreach($getData as $value){

				$initials = $value["first_name"][0] . $value["last_name"][0] ; ;

				if (!$initials) {
					$initials = "-" ;
				}

				$data .= '<li><span class="userShortname">'.$initials.'</span>' ;


				if ( $counter == '3' ) {
					$moreUsersCount  =  ( count($getData) - 3 ) ;
					if ($moreUsersCount != '0') {
						$data .= '<li class="last-member"><span class="userShortname">+'.$moreUsersCount.'</span></li>' ;
					}
					break ;

				}

				$counter++ ;
			}

		}

		return $data ;

	}




	function addtraineeUser($postData, $username) {

	     $data['username'] 			 	 = $username ;
	     $data['first_name'] 			 = $postData['firstName'] ;
	     $data['last_name'] 		 	 = $postData['lastName'] ;
	     $data['email'] 			 	 = $postData['email'] ;
	     $data['password'] 			 	 = encrypt_string($postData['password']) ;
	     $data['mobile'] 			 	 = $postData['contactNumber'] ;
	     $data['created_by'] 		 	 = ( $this->session->userdata('type') == "superadmin" ? '1':'2') ;
	     $data['created_by_user_id'] 	 = $this->session->userdata('user_id') ;
	     $data['created_by_user_name'] 	 = $this->session->userdata('username') ;
	     $data['cost_centre_id'] 		 = $postData['costCentreIdForDB'] ;
	     $data['contract_area_id'] 		 = $postData['contractAreaIdForDB'] ;
	     $data['office_id'] 		 	 = $postData['officeIdForDB'] ;
	     $data['cost_centre_name'] 		 = $postData['costCentreName'] ;
	     $data['contract_area_name'] 	 = $postData['contractAreaName'] ;
	     $data['office_name'] 		     = $postData['officeName'] ;

		  $this->db->insert('elearning_trainee_users', $data);
		  $insert_id = $this->db->insert_id();

		  return  $insert_id;
	}


	function deleteTraineeUser($userId) {
		return $this->db->where('id',$userId)->delete('elearning_trainee_users');
	}

	function updateTraineeUserMoodleIdEmailStatus($data, $userId) {
		return $this->db->where('id', $userId)->update('elearning_trainee_users',$data);
	}

	function insertCourseData($postData) {
		 return  $this->db->insert('elearning_user_courses', $postData);
	}

	function getCourseUsers($courseId) {

	   $totalData = $this->db->from('elearning_user_courses')->where('course_id', $courseId)->count_all_results();

		$result  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable')
         ->from('elearning_user_courses as t1')
         ->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
         ->where('t1.course_id', $courseId)
         ->get()
		 ->result_array();

		echo $totalData ;

		debug($result, 1) ;

		echo "<br />Second Part<br />" ;


		$sql = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable";
		$sql.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
		$sql.=" WHERE (t2.first_name LIKE '%with%' OR t2.last_name LIKE '%with%') AND t1.course_id = '".$courseId."' ";

		$query = $this->db->query($sql)->result_array();

		echo count($query) ;

		debug($query) ;


		echo "second query" ;



		//$totalData = $this->db->from('elearning_user_courses')->where('course_id', $courseId)->count_all_results();

		$result  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable')
         ->from('elearning_trainee_users as t2')
         ->join('elearning_user_courses as t1', 't2.id= t1.sentry_trainee_user_id', 'right')
         ->where('t1.course_id !=', $courseId)
         ->get()
		 ->result_array();
		echo $this->db->last_query() ;
		//echo $totalData ;

		debug($result) ;


	}



	public function getAssignedTraineeToCourse($requestData) {

		$mainCourseId  = $requestData['mainCourseId'];

		$totalData = $this->db->from('elearning_user_courses')->where('course_id', $mainCourseId)->count_all_results();

		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.

		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = "t2.".$requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "t2.first_name" ;
			$orderBy	= "ASC" ;
		}

		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter

			$sql = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name";
			$sql.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
			$sql.=" WHERE (t2.first_name LIKE '%".$requestData['search']['value']."%' OR t2.last_name LIKE '%".$requestData['search']['value']."%') AND t1.course_id = '".$mainCourseId."' ";



			$sql.=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->db->query($sql)->result_array();


			$totalFilteredSearch = "" ;
			$totalFilteredSearch = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username";
			$totalFilteredSearch.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
			$totalFilteredSearch.=" WHERE (t2.first_name LIKE '%".$requestData['search']['value']."%' OR t2.last_name LIKE '%".$requestData['search']['value']."%') AND t1.course_id = '".$mainCourseId."' ";

			$querySearch = $this->db->query($totalFilteredSearch)->result_array();
			$totalFiltered = count($querySearch);




		} else {

			$query  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name')
			->from('elearning_user_courses as t1')
			->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
			->where('t1.course_id', $mainCourseId)
			->order_by($columnName, $orderBy)
			->limit($requestData['length'], $requestData['start'])
			->get()
			->result_array();

		}

	  $data = [] ;
	  $counter = 0 ;

	  $tableName = $requestData['tableName'];

	  if ($tableName == "tableAssignedTraineeToCoursePage") {

		  foreach ($query as $row) {


			$initials =  $row["first_name"][0] . $row["last_name"][0] ;

			$data[$counter][] 	= '<figure><span class="userShortname">'.$initials.'</span></figure><span class = "nameListing __updateTraineeUserInfoMoodelLocal" data-courseid = "'.$row["course_id"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'">'.$row["first_name"] .' '. $row["last_name"].'<br><span class="usernameListing">'.$row["username"].'</span></span><div class="__actionbtnlist"><span class="user-active-time deletetraineeUser __deleteCourseForTraineeUser" data-courseid = "'.$row["course_id"].'" data-coursetableid = "'.$row["courseTableId"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="Remove" ><i class="fa fa-trash" aria-hidden="true"></i> </span></span><span class="user-active-time field-icon __updateTraineeUserInfoMoodelLocal" data-courseid = "'.$row["course_id"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="View"><i class="fa fa-fw fa-eye" aria-hidden="true"></i> </span></span></div>' ;
			$counter++ ;
		  }
	  } else {

		  /*foreach ($query as $row) {

				$explode  = explode(" ", $row["costcentrename"]) ;
				$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;

				if (!$initials) {
					$initials = "-" ;
				}
				$data[$counter][] 	= '<span class="userShortname">'.$initials.'</span>'.$row["costcentrename"].'' ;
				$data[$counter][] 	= '<a href="javascript:void(0);" class= "__deleteCourseForCostCentre" data-courseid = "'.$row["course_id"].'" data-costcentreid = "'.$row["costcenterID"].'"><i class="fa fa-trash" aria-hidden="true"></i> Remove</a>' ;
				$counter++ ;
		 }*/
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}


	function updateTrainee($dataToUpdateLocalDb, $moodleTeaineeId) {
		return $this->db->where('moodle_user_id', $moodleTeaineeId)->update('elearning_trainee_users',$dataToUpdateLocalDb);
	}



	function checkCourseAssignedToCCTrainee($selectedCCId, $mainCourseId)
	{
		return  $this->db->select('*')->from('elearning_user_courses')->where(['cost_centre_id' => $selectedCCId, 'course_id' => $mainCourseId])->get()->result_array();

	}


	function removeCostCentreAssignedtoCourse($selectedCCId, $mainCourseId) {
		return $this->db->where(['costcenterID' => $selectedCCId, 'course_id' => $mainCourseId])->delete('elearning_courses_costcentre');
	}

	function removeTraineeFromCourse($courseTableId) {
		return $this->db->where(['id' => $courseTableId])->delete('elearning_user_courses');
	}


	public function getNonAssignedTraineeToCourse($requestData) {

		$mainCourseId  = $requestData['mainCourseId'];

		$sqlTotalData = "Select * from  elearning_trainee_users  where id not in ( SELECT `sentry_trainee_user_id` FROM `elearning_user_courses` WHERE `course_id` = '".$mainCourseId."' ) ";

		$query = $this->db->query($sqlTotalData)->result_array();

	    $totalData 	  = count($query)  ;

		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.

		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = $requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "first_name" ;
			$orderBy	= "ASC" ;
		}


	    $mainQuery = "" ;

	    $mainQuery .= "Select * from  elearning_trainee_users  where id not in ( SELECT `sentry_trainee_user_id` FROM `elearning_user_courses` WHERE `course_id` = '".$mainCourseId."' ) ";


		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter

			$mainQuery .= " AND ( `first_name` LIKE '%".$requestData['search']['value']."%' OR `last_name` LIKE '%".$requestData['search']['value']."%')" ;

			$totalFilteredSearch = $this->db->query($mainQuery)->result_array();
			$totalFiltered 	     = count($totalFilteredSearch);

		}

		$mainQuery .=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";


		$query = $this->db->query($mainQuery)->result_array();


	   $data = [] ;
	   $counter = 0 ;

	   foreach ($query as $row) {

			$initials =  $row["first_name"][0]. $row["last_name"][0] ;

			if (!$initials) {
				$initials = "-" ;
			}
			$data[$counter][] 	= '<span class="userShortname">'.$initials.'</span><span class="__updateTraineeUserInfoMoodelLocal" data-courseid = "" data-moodleidtrainee = "'.$row["moodle_user_id"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'">'.$row["first_name"] .' '. $row["last_name"].'<br><span class="usernameListing">'.$row["username"].'</span></span>' ;
			$data[$counter][] 	= '<div class="__actionbtnlist"><span class="linksAnhor __assignCourseToTraineeUser" data-toggle="tooltip" data-placement="top" title="Assign course"  data-sentryuserid = "'.$row["id"].'" data-moodleuserid = "'.$row["moodle_user_id"].'"><i class="fa fa-plus" aria-hidden="true"></i> </span><span class="field-icon __updateTraineeUserInfoMoodelLocal" data-courseid = "" data-moodleidtrainee = "'.$row["moodle_user_id"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="View"><i class="fa fa-fw fa-eye" aria-hidden="true"></i> </span></span></div>' ;
			$counter++ ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}



	function getAllCoursesManager($loneWorkerCCId)
	{
		return  $this->db->select('*')->from('elearning_courses_costcentre')->where(['costcenterID' => $loneWorkerCCId])->get()->result_array();

	}


	public function getAssignedTraineeToCourseForManager($requestData) {

		$mainCourseId  	    = $requestData['mainCourseId'];
		$userLinkAccountid  = $requestData['userLinkAccountid'];
		$dbColumnName  	    = $requestData['dbColumnName'];

		$totalData  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name')
		->from('elearning_user_courses as t1')
		->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
		->where(['t1.course_id' => $mainCourseId, 't2.'.$dbColumnName => $userLinkAccountid])
		->count_all_results();

		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.

		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = "t2.".$requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "t2.first_name" ;
			$orderBy	= "ASC" ;
		}

		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter

			$sql = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name";
			$sql.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
			$sql.=" WHERE (t2.first_name LIKE '%".$requestData['search']['value']."%' OR t2.last_name LIKE '%".$requestData['search']['value']."%') AND t1.course_id = '".$mainCourseId."' AND t2.".$dbColumnName." = '".$userLinkAccountid."' ";



			$sql.=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->db->query($sql)->result_array();


			$totalFilteredSearch = "" ;
			$totalFilteredSearch = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username";
			$totalFilteredSearch.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
			$totalFilteredSearch.=" WHERE (t2.first_name LIKE '%".$requestData['search']['value']."%' OR t2.last_name LIKE '%".$requestData['search']['value']."%') AND t1.course_id = '".$mainCourseId."' AND t2.".$dbColumnName." = '".$userLinkAccountid."' ";

			$querySearch = $this->db->query($totalFilteredSearch)->result_array();
			$totalFiltered = count($querySearch);




		} else {

			$query  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name')
			->from('elearning_user_courses as t1')
			->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
			->where(['t1.course_id' => $mainCourseId, 't2.'.$dbColumnName => $userLinkAccountid])
			->order_by($columnName, $orderBy)
			->limit($requestData['length'], $requestData['start'])
			->get()
			->result_array();

		}

	  $data = [] ;
	  $counter = 0 ;

	  $tableName = $requestData['tableName'];

	  foreach ($query as $row) {


			$initials =  $row["first_name"][0] . $row["last_name"][0] ;

			$data[$counter][] 	= '<figure><span class="userShortname">'.$initials.'</span></figure><span class = "nameListing __updateTraineeUserInfoMoodelLocal" data-courseid = "'.$row["course_id"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'">'.$row["first_name"] .' '. $row["last_name"].'<br><span class="usernameListing">'.$row["username"].'</span></span><div class="__actionbtnlist"><span class="user-active-time deletetraineeUser __deleteCourseForTraineeUser" data-courseid = "'.$row["course_id"].'" data-coursetableid = "'.$row["courseTableId"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="Remove" ><i class="fa fa-trash" aria-hidden="true"></i> </span></span><span class="user-active-time field-icon __updateTraineeUserInfoMoodelLocal" data-courseid = "'.$row["course_id"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="View"><i class="fa fa-fw fa-eye" aria-hidden="true"></i> </span></span></div>' ;
			$counter++ ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}


	public function getNonAssignedTraineeToCourseForManager($requestData) {

		$mainCourseId  		= $requestData['mainCourseId'];
		$userLinkAccountid  = $requestData['userLinkAccountid'];
		$dbColumnName  	    = $requestData['dbColumnName'];

		$sqlTotalData = "Select * from  elearning_trainee_users  where id not in ( SELECT `sentry_trainee_user_id` FROM `elearning_user_courses` WHERE `course_id` = '".$mainCourseId."' ) AND ".$dbColumnName." = '".$userLinkAccountid."' ";

		$query = $this->db->query($sqlTotalData)->result_array();

	    $totalData 	  = count($query)  ;

		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.

		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = $requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "first_name" ;
			$orderBy	= "ASC" ;
		}


	    $mainQuery = "" ;

	    $mainQuery .= "Select * from  elearning_trainee_users  where id not in ( SELECT `sentry_trainee_user_id` FROM `elearning_user_courses` WHERE `course_id` = '".$mainCourseId."' ) AND ".$dbColumnName." = '".$userLinkAccountid."' ";


		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter

			$mainQuery .= " AND ( `first_name` LIKE '%".$requestData['search']['value']."%' OR `last_name` LIKE '%".$requestData['search']['value']."%')" ;

			$totalFilteredSearch = $this->db->query($mainQuery)->result_array();
			$totalFiltered 	     = count($totalFilteredSearch);

		}

		$mainQuery .=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";


		$query = $this->db->query($mainQuery)->result_array();


	   $data = [] ;
	   $counter = 0 ;

	   foreach ($query as $row) {

			$initials =  $row["first_name"][0]. $row["last_name"][0] ;

			if (!$initials) {
				$initials = "-" ;
			}
			$data[$counter][] 	= '<span class="userShortname">'.$initials.'</span><span class="__updateTraineeUserInfoMoodelLocal" data-courseid = "" data-moodleidtrainee = "'.$row["moodle_user_id"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'">'.$row["first_name"] .' '. $row["last_name"].'<br><span class="usernameListing">'.$row["username"].'</span></span>' ;
			$data[$counter][] 	= '<div class="__actionbtnlist"><span class="linksAnhor __assignCourseToTraineeUser" data-toggle="tooltip" data-placement="top" title="Assign course"   data-sentryuserid = "'.$row["id"].'" data-moodleuserid = "'.$row["moodle_user_id"].'"><i class="fa fa-plus" aria-hidden="true"></i> </span><span class="field-icon __updateTraineeUserInfoMoodelLocal" data-courseid = "" data-moodleidtrainee = "'.$row["moodle_user_id"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'" data-username = "'.$row["username"].'" data-costcentreid = "'.$row["cost_centre_id"].'" data-costcentrename = "'.$row["cost_centre_name"].'" data-contractareaid = "'.$row["contract_area_id"].'" data-contractareaname = "'.$row["contract_area_name"].'" data-officeid = "'.$row["office_id"].'" data-officename = "'.$row["office_name"].'"><span class="linksAnhor" data-toggle="tooltip" data-placement="top" title="View" ><i class="fa fa-fw fa-eye" aria-hidden="true"></i> </span></span></div>' ;
			$counter++ ;
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}
	
	
	public function courseCompletionReportAdmin($mainCourseId) {
	
			$query  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name')
			->from('elearning_user_courses as t1')
			->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
			->where('t1.course_id', $mainCourseId)
			->order_by('t2.first_name', 'ASC')
			->get()
			->result_array();
			
			return $query ;
			
			
	}
	
	public function courseCompletionReportManager($mainCourseId, $dbColumnName, $userLinkAccountid) {
		
		$query  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable,t2.username,t2.cost_centre_id,t2.contract_area_id,t2.office_id,t2.cost_centre_name,t2.contract_area_name,t2.office_name')
		->from('elearning_user_courses as t1')
		->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
		->where(['t1.course_id' => $mainCourseId, 't2.'.$dbColumnName => $userLinkAccountid])
		->order_by('t2.first_name', 'ASC')
		->get()
		->result_array();
		
		return $query ;
		
		
		
	}

}
