var polygonInfo = "firstTime" ;
var pinInfo = "firstTime" ;
var infoboxTemplateInfo = '<span class="homeSafeTitle">HomeSafe location details <a href="javascript:closeInfoboxInfo()" class="customInfoboxCloseButton"><img alt="cancel_map" class="close_map_popup" src="'+base_url+'img/cancel_map.png"></a></span><div class="customInfobox" style="padding: 14px 11px 10px"><label class="homesafeLabel">HomeSafe Name</label><input type="text" name="homesafenameuser" id="homesafenameuser" placeholder="HomeSafe Name" readonly value="{homesafename}" /><label class="homesafeLabel">Radius</label><input type="text" name="radiususer" id="radiususer" placeholder="Radius" readonly value="{radius}" /></div>';


$(document).ready(function() {


	$(document).on('click','#__getHomesafeUsersGeofenceData', function(){
		setPinsCircleGetMultipleHomesafeDetails() ;
	}) ;
	
	
	$(document).on('click','.tableRowClass', function(){
		var latRow = $(this).data('latitude') ;
		var longRow = $(this).data('longitude') ;
		
		
		if ( latRow && longRow ) {
			
			closeInfoboxInfo() ;
			$(".tableRowClass").removeClass('__active-card');
			$(this).addClass('__active-card');
			
			mapInfo.setView({
					center: new Microsoft.Maps.Location(latRow, longRow),
					zoom: 15
				});	
		}
		
	}) ;

}); //document ready ends



function setPinsCircleGetMultipleHomesafeDetails(){
	 
	 
	 
	 var serialNumberArray  = [] ;
	 
	 $('input[type=checkbox][class=__checkBoxTemplateListing]:checked', allPagesDataTable).each(function (index) { 
			
			var serial_number  	 	= $(this).closest("tr").data('serialnumber');
			serialNumberArray.push(serial_number) ;
	 });
	 
	 if( serialNumberArray.length  == 0 ) {
		 swal({
			title: "Warning",
			text: "Please select lone worker.",
			icon: "warning",
			button: "CONTINUE"
		 }) ;
		 
		 return false;
	 }
	  
	 $.ajax({
		  url: base_url + 'geofencing/getHomesafeUsersGeofenceData' ,
		  type: 'post',
		  dataType: 'json',
		  data: { serialNumber: JSON.stringify(serialNumberArray) } ,
		  beforeSend: function(){
             $("#__homeSafeLoaderInfo").show() ;
             $('#geofencecardmodal').modal('show');
          },
		  success:function(response){
			 if ( response.error == 0 ) {
				
				var tableData = "" ;
				
				
				mapInfo.setView({
					center: new Microsoft.Maps.Location(response.data[0].latitude, response.data[0].longitude),
					zoom: 15
				});	
				
				mapInfo.entities.clear();
				
				closeInfoboxInfo() ;
				
				for( var i=0; i<response.data.length; i++ )
				{
				
				
						var locationNewInfo = new Microsoft.Maps.Location(response.data[i].latitude, response.data[i].longitude);

						if ( response.data[i].created_from  == "app" ) {

							pinInfo = new Microsoft.Maps.Pushpin(locationNewInfo, {
								'draggable': false,
								 icon: base_url + 'img/mobile_location-placeholder.png',
								 text: response.data[i].name.charAt(0).toUpperCase()
							});

						} else {
							pinInfo = new Microsoft.Maps.Pushpin(locationNewInfo, {
								'draggable': false,
								 icon: base_url + 'img/green_location-placeholder.png',
								 text: response.data[i].name.charAt(0).toUpperCase()
							});
						}
						
						 pinInfo.metadata = {
							title: response.data[i].homesafe_name,
							description: response.data[i].radius,
							customtext: "pinposition" + i
						 };
						
						
						//Add a click event handler to the pushpin.
						Microsoft.Maps.Events.addHandler(pinInfo, 'click', pushpinClickedInfo);
						
						mapInfo.entities.push(pinInfo);

						/*New functionality to show the circle*/


							var MM = Microsoft.Maps;
							var R = 6371; // earth's mean radius in km

							var radius = response.data[i].radius / 1000;      //radius of the circle
							var latitude = response.data[i].latitude;    //latitude of the circle center
							var longitude = response.data[i].longitude;   //longitude of the circle center

							var backgroundColor = new Microsoft.Maps.Color(10, 100, 0, 0);
							var borderColor = new Microsoft.Maps.Color(150, 200, 0, 0);

							var lat = (latitude * Math.PI) / 180;
							var lon = (longitude * Math.PI) / 180;
							var d = parseFloat(radius) / R;
							var circlePoints = new Array();

							for (x = 0; x <= 360; x += 5) {
								var p2 = new MM.Location(0, 0);
								brng = x * Math.PI / 180;
								p2.latitude = Math.asin(Math.sin(lat) * Math.cos(d) + Math.cos(lat) * Math.sin(d) * Math.cos(brng));

								p2.longitude = ((lon + Math.atan2(Math.sin(brng) * Math.sin(d) * Math.cos(lat),
												 Math.cos(d) - Math.sin(lat) * Math.sin(p2.latitude))) * 180) / Math.PI;
										p2.latitude = (p2.latitude * 180) / Math.PI;
										circlePoints.push(p2);
							}

							//polygon = new MM.Polygon(circlePoints, { fillColor: backgroundColor, strokeColor: borderColor, strokeThickness: 1 });

							if ( response.data[i].created_from  == "app" ) {

								polygonInfo = new MM.Polygon(circlePoints, {
									fillColor: 'rgba(11, 139, 11, 0.3)',
									strokeColor: 'green',
									strokeThickness: 1
								});

							} else  {

								polygonInfo = new MM.Polygon(circlePoints, {
									fillColor: 'rgba(255, 0, 0, 0.3)',
									strokeColor: 'red',
									strokeThickness: 1
								});

							}


							mapInfo.entities.push(polygonInfo);
							
					   /*New functionality to show the circle*/
					   
					   
					   /*Table HTML Data*/
					   
					   var deviceType = response.data[i].device_type ;
					   
					   if (deviceType == "ios") {
							deviceType = "iOS" ;
					   } else if (deviceType == "android") {
							deviceType = "ANDROID" ;
					   } else {
							deviceType = "-" ;
					   }
					   
					   var tableRowClass = "tableRowClass " ;
					   
					   if ( i == "0" ) {
						   tableRowClass += " __active-card" ;
					   }
					    
					   
					   
					   tableData += '<tr id="pinposition'+i+'" class="'+tableRowClass+'" data-latitude = "'+response.data[i].latitude +'" data-longitude = "'+response.data[i].longitude +'"><td><div class="__innerGridBox"><ul class="AddIConLLIveLIst"> <li><span class="loan-d-f"><span class="MemberDeviceIconuser"></span>Name:</span> <span style="width: 145px;" data-toggle="tooltip" data-placement="top" title="'+response.data[i].name +'" class="loan-d-d LoneWorkerNameFull"> '+response.data[i].name +'</span></li><!--li><span class="loan-d-f" id="contract-no-0"><span class="MemberDeviceIconphone"></span>Contract Number:</span><span class="loan-d-d">ORBIS</span></li--><li><span class="loan-d-f"><span class="MemberDeviceIconcard"></span>Serial Number:</span><span class="loan-d-d">'+response.data[i].serial_number +'</span></li> <li><span class="loan-d-f"><span class="MemberDeviceIcontelephone"></span>Telephone Number:</span><span class="loan-d-d">'+response.data[i].phone +'</span></li> <li><span class="loan-d-f"><span class="MemberDeviceIconmobile"></span>Device Type:</span><span class="loan-d-d">'+deviceType+'</span> </li>  <li><span class="loan-d-f"><span class="MemberDeviceIconcalendar"></span>Coordinates:</span><span class="loan-d-d " style="width: 145px;">'+response.data[i].latitude +', '+response.data[i].longitude+'</span></li> <li><span class="loan-d-f"><span class="MemberDeviceIconsignal"></span>Homesafe Name:</span><span class="loan-d-d LoneWorkerNameFull">'+response.data[i].homesafe_name +'</span></li><li><span class="loan-d-f"><span class="MemberDeviceIconsignal"></span>Radius:</span><span class="loan-d-d LoneWorkerNameFull">'+response.data[i].radius +'</span></li></ul></div></td> </tr>' ;
					   
					   
					   
					   
					   /*Table HTML Data*/
					   
							
					} // end for loop

					
					$("#event-table-cardbox #myDIV").html(tableData) ;
				 

				    $("#__homeSafeLoaderInfo").hide() ;

			 }
			 
			 
			 if ( response.error == 1 ) {
				 $('#geofencecardmodal').modal('hide'); 	
				 swal({
				//	title: "Warning",
					text: response.message,
					icon: "warning",
					button: "CONTINUE"
				 }) ;
			 
			 }
			 

		  }, error: function (jqXHR, exception) {
			  
			     $('#geofencecardmodal').modal('hide'); 
				 swal({
						  text: "Network error, please try again later.",
						  icon: "warning",
						  button: "CONTINUE"
					}) ;
		  }
	});


	

}


function pushpinClickedInfo(e) {
		var dataInfoBox = "" ;
       //Make sure the infobox has metadata to display.
            if("undefined" === typeof e.target){
				dataInfoBox = infoboxTemplateInfo.replace('{homesafename}', e.metadata.title,) ;
				dataInfoBox = dataInfoBox.replace('{radius}', 		e.metadata.description) ;
				
                infoboxInfo.setOptions({
                    location: e.getLocation(),
                    title: e.metadata.title,
                    description: e.metadata.description,
                    visible: true,
                    htmlContent: dataInfoBox
                });
            }else if (e.target.metadata) {
                //Set the infobox options with the metadata of the pushpin.
                
                dataInfoBox = infoboxTemplateInfo.replace('{homesafename}', e.target.metadata.title) ;
				dataInfoBox = dataInfoBox.replace('{radius}', 		e.target.metadata.description) ;
                
                infoboxInfo.setOptions({
                    location: e.target.getLocation(),
                    title: e.target.metadata.title,
                    description: e.target.metadata.description,
                    visible: true,
                    htmlContent: dataInfoBox
                });
                
                
				 var myElement = document.getElementById( e.target.metadata.customtext);
				 var topPos = myElement.offsetTop;

				$('#myDIV').animate({
				 scrollTop: topPos
				}, 500);

				$("#myDIV").find('.__active-card').removeClass("__active-card");
				$("#" + e.target.metadata.customtext).addClass('__active-card');
                
            }
}


function closeInfoboxInfo() {
   infoboxInfo.setOptions({ visible: false });
}
