<?php

Class Users extends CI_Model
{
	public function __construct()
	{
		parent::__construct();

	}

	function count_cost_center()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->count_all('newcostcentres');
	}

	function count_contract_area()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->count_all('newcontractareas');
	}

	function count_office()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->count_all('newoffices');
	}

	function count_lwd()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_office_lwd()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('operators')->where(['office' => '23'])->get()->result_array();
	}

	function get_system_users_list_admin()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_system_users_list($id,$type,$session_id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('user_id,username,first_name,sur_name,email,telephone,agency_type,user_status,user_block')->from('user')->where([ $type => $id, 'user_id !=' => $session_id  ])->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_user_data($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->where('user_id' , $id)->get()->first_row('array');
	}

	function add_system_user($data,$parent_id = null)
	{
		$this->mysql = $this->load->database('mysql', true);

		unset($data['portalUserToken']);
		unset($data['costcentre_list']);
		unset($data['contractarea_id']);
		unset($data['office_list']);
		//debug($data,1);
		// event_log
		$row['log_name'] = "add new user";
		$row['user_type'] = "1";
		//$this->mysql->insert('logs',$row);

		if($data['password']){
			$data['password'] =  encrypt_string($data['password']);
		}
		if($data['sentinel_username']){
			$data['sentinel_username'] =  encrypt_string($data['sentinel_username']);
		}
		if($data['sentinel_password']){
			$data['sentinel_password'] =  encrypt_string($data['sentinel_password']);
		}

		if($data['sentinel_passcode']){
			$data['sentinel_passcode'] =  encrypt_string($data['sentinel_passcode']);
		}

		// add user
		unset($data['edit_user_id']);
		unset($data['confirm_password']);
		if(!empty($data['user_id']))
		{
			$data['parent_id'] = $data['user_id'];
			unset($data['user_id']);
		}

		if(  empty($data['user_status']) )
		{
			$data['user_status'] = '0';
		}

		if(  empty($data['service_status']) )
		{
			$data['service_status'] = '0';
		}

		if(  empty($data['user_block']) && $data['user_block'] != '0' )
		{
			$data['user_block'] = '1';
		}

		if(  empty($data['lone_read']) )
		{
			$data['lone_read'] = '0';
		}
		if( !isset($data['lone_write']) )
		{
			$data['lone_write'] = '0';
		}

		if( !isset($data['manage_lone_write']) )
		{
			$data['manage_lone_write'] = '0';
		}
		if( empty($data['manage_lone_read']) )
		{
			$data['manage_lone_read'] = '0';
		}

		if( empty($data['decommission_read']) )
		{
			$data['decommission_read'] = '0';
		}
		if( !isset($data['decommission_write']) )
		{
			$data['decommission_write'] = '0';
		}

		if( empty($data['user_read']) )
		{
			$data['user_read'] = '0';
		}
		if( !isset($data['user_write']) )
		{
			$data['user_write'] = '0';
		}

		if( !isset($data['user_activity_read']) )
		{
			$data['user_activity_read'] = '0';
		}

		if( !isset($data['event_detail_read']) )
		{
			$data['event_detail_read'] = '0';
		}

		if( !isset($data['alarm_activation_read']) )
		{
			$data['alarm_activation_read'] = '0';
		}

		if( !isset($data['user_escalation_read']) )
		{
			$data['user_escalation_read'] = '0';
		}

		if( !isset($data['system_schedule_read']) )
		{
			$data['system_schedule_read'] = '0';
		}
		//debug($data,1);
		$this->mysql->insert('user',$data);
		//echo $this->mysql->last_query();exit;
		return $this->mysql->insert_id();
	}

	function edit_system_user($data,$id)
	{
		$this->mysql = $this->load->database('mysql', true);

		unset($data['edit_user_id']);
		unset($data['user_id']);
		unset($data['confirm_password']);
		unset($data['portalUserToken']);

		unset($data['costcentre_list']);
		unset($data['contractarea_id']);
		unset($data['office_list']);

		if($data['sentinel_username']){
			$data['sentinel_username'] =  encrypt_string($data['sentinel_username']);
		}
		if($data['sentinel_password']){
			$data['sentinel_password'] =  encrypt_string($data['sentinel_password']);
		}

		if(  empty($data['user_status']) )
		{
			$data['user_status'] = '0';
		}
		
		if(  empty($data['service_status']) )
		{
			$data['service_status'] = '0';
		}
		
		if( $data['user_status'] == 1 )
		{
			$query = $this->mysql->select('*')->from('login_attempt')->where([ 'ip' => $_SERVER['REMOTE_ADDR'], 'username' => $data['username']  ])->get()->first_row('array');
			if( !empty($query))
			{
				$row['username'] = '';
				$row['attempt'] = 0;
				$this->mysql->where('id',$query['id'])->update('login_attempt',$row);
			}
		}

		if(  empty($data['user_block']) && $data['user_block'] != '0' )
		{
			$data['user_block'] = '1';
		}

		if(  empty($data['lone_read']) )
		{
			$data['lone_read'] = '0';
		}
		if( !isset($data['lone_write']) )
		{
			$data['lone_write'] = '0';
		}

		if( !isset($data['manage_lone_write']) )
		{
			$data['manage_lone_write'] = '0';
		}
		if( empty($data['manage_lone_read']) )
		{
			$data['manage_lone_read'] = '0';
		}

		if( empty($data['decommission_read']) )
		{
			$data['decommission_read'] = '0';
		}
		if( !isset($data['decommission_write']) )
		{
			$data['decommission_write'] = '0';
		}

		if( empty($data['user_read']) )
		{
			$data['user_read'] = '0';
		}
		if( !isset($data['user_write']) )
		{
			$data['user_write'] = '0';
		}

		if( !isset($data['user_activity_read']) )
		{
			$data['user_activity_read'] = '0';
		}

		if( !isset($data['event_detail_read']) )
		{
			$data['event_detail_read'] = '0';
		}

		if( !isset($data['alarm_activation_read']) )
		{
			$data['alarm_activation_read'] = '0';
		}

		if( !isset($data['user_escalation_read']) )
		{
			$data['user_escalation_read'] = '0';
		}

		if( !isset($data['system_schedule_read']) )
		{
			$data['system_schedule_read'] = '0';
		}
		return $this->mysql->where('user_id', $id)->update('user',$data);

	}

	// get geofence
	function get_location_geofence($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('area,zoomLevel')->from('officeArea')->where('officeId',$id)->get()->first_row('array');
	}

	//geofence first time
	function get_data_first_time()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('area,zoomLevel')->from('officeArea')->order_by('create_at','desc')->get()->first_row('array');
	}

	function count_geo()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('geofence')->where('agency_type','1')->get()->result_array();
	}

	// add geofence Model
	function geofence_add($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert('geofence',$data);
	}

	//update geofence
	function update_geofence($data,$id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where( 'geofence_id', $id )->update( 'geofence', $data );
	}

	function delete_geofence($id)
	{
		$this->mysql->where('officeID', $id)->delete('officeArea');
		return $this->mysql->where('geofence_id',$id)->delete('geofence');
	}

	function geofencelist()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('geofence')->order_by('create_at', 'desc')->get()->result_array();
	}
	function get_all_lwd(){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('operators')->get()->result_array();
	}

	function generate_token($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('token',$data);
		return $this->mysql->insert_id();
	}

	function getTokenID($id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('token')->where('id',$id)->get()->first_row('array');
	}

	function getToken($token,$id)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('token')->where(['token' => $token, 'user_id' => $id])->order_by('create_at','desc')->get()->first_row('array');
	}

	function get_user_detail($email)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->where('email',$email)->get()->first_row('array');
	}

	function ResetPassword($password,$id)
	{
		$this->load->helpers('encrypt');
		$this->mysql = $this->load->database('mysql', true);
		$data['password'] = encrypt_string($password);
		return $this->mysql->where('user_id', $id)->update('user',$data);
	}

	function insert_report($data){
		$this->mysql = $this->load->database('mysql', true);
		if( !empty($data) ) {

			$this->mysql->query('truncate reporting');

			for ($i=0; $i <count($data) ; $i++) {
				$row[$i]['serialnumber'] = $data[$i]['SerialNumber'];
				$row[$i]['logheaderidentifier'] = $data[$i]['LogHeaderIdentifier'];
				$row[$i]['logdatetime'] = $data[$i]['LogDateTimeNew'];
				$row[$i]['identifier'] = $data[$i]['Identifier'];
				$row[$i]['eventdescription'] = $data[$i]['EventDescription'];
				$row[$i]['description'] = $data[$i]['Description'];
				$row[$i]['containsmedia'] = $data[$i]['ContainsMedia'];
				$row[$i]['longitude'] = $data[$i]['Longitude'];
				$row[$i]['latitude'] = $data[$i]['Latitude'];
				$row[$i]['userinitials'] = $data[$i]['UserInitials'];

				$row[$i]['datetime'] = $data[$i]['datetime'];
				$row[$i]['username'] = $data[$i]['username'];
				$row[$i]['signaltype'] = $data[$i]['signaltype'];
				$row[$i]['serialno'] = $data[$i]['serialno'];

				$this->mysql->insert('reporting',$row[$i]);
			}
		}
	}

	function get_report_data(){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('reporting')->get()->result_array();
	}


	function insert_escalation_summary($data){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate escalation_summary');
		$this->mysql->delete('escalation_summary', array('user_id' => $userId));
		$row = array();
		for ($i=0; $i <count($data) ; $i++) {
			$row[$i]['main_name'] = $data[$i]['main_name'];
			$row[$i]['child_data'] = $data[$i]['child_data'];
			$row[$i]['user_id'] = $userId;
			$this->mysql->insert('escalation_summary',$row[$i]);
		}
	}

	function global_escalation_summary($data)
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
			//$this->mysql->query('truncate global_escalation_summary');
			$this->mysql->delete('global_escalation_summary', array('user_id' => $userId));
			$row = array();
			for ($i=0; $i <count($data) ; $i++) {
				$row[$i]['NAME'] = $data[$i]['NAME'];
				$row[$i]['PRIORITY'] = $data[$i]['PRIORITY'];
				$row[$i]['MOBILE'] = $data[$i]['MOBILE'];
				$row[$i]['WORK1'] = $data[$i]['WORK1'];
				$row[$i]['PHONE'] = $data[$i]['PHONE'];
				$row[$i]['PAGER'] = $data[$i]['PAGER'];
				$row[$i]['EMAIL'] = $data[$i]['EMAIL'];
				$row[$i]['user_id'] = $userId;
				$this->mysql->insert('global_escalation_summary',$row[$i]);
			}
	}


	function empty_escalation_summary()
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate escalation_summary');
		$this->mysql->delete('escalation_summary', array('user_id' => $userId));
	}

	function empty_global_escalation_summary()
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate global_escalation_summary');
		$this->mysql->delete('global_escalation_summary', array('user_id' => $userId));
	}

	function get_escalation_summary_data(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('*')->from('escalation_summary')->get()->result_array();
		return $this->mysql->select('*')->from('escalation_summary')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function get_global_escalation_summary_data(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('*')->from('global_escalation_summary')->get()->result_array();
		return $this->mysql->select('*')->from('global_escalation_summary')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function get_escalation_summary_data_excel(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('child_data')->from('escalation_summary')->get()->result_array();
		return $this->mysql->select('child_data')->from('escalation_summary')->where([ 'user_id' => $userId ])->get()->result_array();
	}

	function signalHistoryData($data)
	{

		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate signal_history');
		$this->mysql->delete('signal_history', array('user_id' => $userId));
		for( $m=0; $m<count($data); $m++ )
		{
			$row[$m]['EVTIME'] = $data[$m]['LSEQNO_data']['EVTIME'];
			$row[$m]['SERIALNO'] = $data[$m]['LSEQNO_data']['SERIALNO'];
			$row[$m]['NAME'] = $data[$m]['LSEQNO_data']['USERNAME'];
			$row[$m]['DESCR'] = $data[$m]['LSEQNO_data']['DESCR'];
			$row[$m]['LATITUDE'] = $data[$m]['LSEQNO_data']['LATITUDE'];
			$row[$m]['LONGITUDE'] = $data[$m]['LSEQNO_data']['LONGITUDE'];
			$row[$m]['address'] = $data[$m]['LSEQNO_data']['address'];
			$row[$m]['user_id'] = $userId;

			$this->mysql->insert('signal_history',$row[$m]);
		}
	}


	function getSignalHistoryExport(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//return $this->mysql->select('*')->from('signal_history')->get()->result_array();
		return $this->mysql->select('*')->from('signal_history')->where([ 'user_id' => $userId ])->get()->result_array();
	}
	
	function deleteSignalHistoryReport(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->delete('signal_history', array('user_id' => $userId));
	}
	
	function userActivityReport($data)
	{
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		//debug($data, 1) ;
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		//$this->mysql->query('truncate userActivityReport');
		$this->mysql->delete('userActivityReport', array('user_id' => $userId)); 
		
		//debug($data,1);

		for ($m=0; $m < count($data) ; $m++) {
			
			$row[$m]['CONTRACT'] 					= $data[$m]['CONTRACT'];
			$row[$m]['OFFICE']						= $data[$m]['OFFICE'];
			$row[$m]['USERNAME'] 					= $data[$m]['NAME'];
			$row[$m]['serialno'] 					= $data[$m]['SERIALNO'];
			$row[$m]['Transmitter_Type'] 			= $data[$m]['TRANSMITTERNAME'];
			
			$row[$m]['IMEI_Number'] 				= $data[$m]['PROPERTYVALUE'];
			$row[$m]['Mobile_Number'] 				= $data[$m]['NETADDR'];
			$row[$m]['Date_Time_Of_Last_Signal'] 	= $data[$m]['LASTSIGNAL'];
			
			$row[$m]['Amber_Alerts_Data'] 	  		 = ( $data[$m]['transmittertypeother']['Amber_Alert'] +  $data[$m]['transmittertypeother']['Amber_Alert_Start'] );
			$row[$m]['Amber_Alerts_Voice'] 	         = ( $data[$m]['transmittertypeaudio']['Amber_Alert_Audio'] +  $data[$m]['transmittertypeaudio']['Amber_Alert'] + $data[$m]['transmittertypeaudio']['Amber_Alert_Start'] );
			
			$row[$m]['Red_Alerts_Data'] 			 = $data[$m]['transmittertypeother']['Red_Alert'];
			
			$row[$m]['Red_Alerts_Voice'] 			 = ( $data[$m]['transmittertypeaudio']['Amber_Cancel_O_Due__OrbisApp_'] + $data[$m]['transmittertypeaudio']['Fall'] + $data[$m]['transmittertypeaudio']['Amber_Cancel_Overdue'] + $data[$m]['transmittertypeaudio']['Man_Down'] + $data[$m]['transmittertypeaudio']['Red_Alert_Audio'] );
			
			
			$row[$m]['Man_Down_Alert'] 				 = $data[$m]['transmittertypeother']['Man_Down'];
			$row[$m]['Fall_Alert']						 = $data[$m]['transmittertypeother']['Fall'];
			$row[$m]['Amber_Exceed']			 	 = ( $data[$m]['transmittertypeother']['Amber_Cancel_Overdue'] + $data[$m]['transmittertypeother']['Amber_Cancel_O_Due__OrbisApp_'] );
			
			$row[$m]['user_id'] = $userId;


			$this->mysql->insert('userActivityReport',$row[$m]);
		}
	}

	function getUserActivityReport($explodeSearch)
	{
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select($explodeSearch)->from('userActivityReport')->where([ 'user_id' => $userId ])->get()->result_array();
					
	}
	
	function deleteUserActivityReport(){
		$userId 	 =  $this->session->userdata('user_id') ;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->delete('userActivityReport', array('user_id' => $userId));
	}
	
	function updateMyAccount($data,$id){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->where('user_id', $id)->update('user',$data);
	}



	function updateUserEmail($data,$id){
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('user_id', $id)->update('user',$data);
		return $this->mysql->affected_rows();
	}

	function blockUser($status,$ID)
	{
		$this->mysql = $this->load->database('mysql', true);
		$data['user_block'] = $status;
		return $this->mysql->where('user_id', $ID)->update('user',$data);
	}

	function checkUserNameDb($type,$value){
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('user')->where($type,$value)->get()->first_row('array');
	}

	function ipCount()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('login_attempt')->where('ip', $_SERVER['REMOTE_ADDR'])->get()->first_row('array');
	}

	function failedLogin($username){
		$this->mysql = $this->load->database('mysql', true);
				$query = $this->mysql->select('*')->from('login_attempt')->where([ 'ip' => $_SERVER['REMOTE_ADDR'], 'username' => $username  ])->get()->first_row('array');
				if( empty($query) )
				{
					$data['attempt'] = 1;
					$data['username'] = $username;
					$data['ip'] = $_SERVER['REMOTE_ADDR'];
					$data['created_date'] = date( 'Y-m-d H:i:s' );
					$this->session->set_userdata('attempt', $data['attempt']);
					$this->mysql->insert('login_attempt',$data);
				}
				if( !empty($query) )
				{
					$data['attempt'] = ++$query['attempt'];
					$data['username'] = $username;
					$data['updated_date'] = date( 'Y-m-d H:i:s' );

					if( $data['attempt'] >= 5 ){
						$getData = $this->mysql->select('user_id')->from('user')->where('username',$username)->get()->first_row();
						if( !empty($getData) ){						
							$row['user_status'] = '0';
							$this->mysql->where('user_id',$getData->user_id)->update('user',$row);
						}
					}

					$this->session->set_userdata('attempt', $data['attempt']);
					$this->mysql->where('id',$query['id'])->update('login_attempt',$data);
				}
			return $data['attempt'];

	}

	function successLogin($username){
		$this->mysql = $this->load->database('mysql', true);
		$getData = $this->mysql->select('user_id,login_attempt')->from('user')->where('username',$username)->get()->first_row();
		$data['user_id'] = $getData->user_id;
		$data['login_attempt'] = 0;
		$this->mysql->where('user_id',$getData->user_id)->update('user',$data);
	}

	function insertToken($id,$token){
		$this->mysql = $this->load->database('mysql', true);
		$data['token'] = $token;
		return $this->mysql->where('user_id',$id)->update('user',$data);
	}

	function checkLoggedInToken($id,$token)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('user_id,email,username')->from('user')->where([ 'user_id' => $id, 'token' => $token ])->get()->first_row('array');
	}

	function removeToken($id,$token)
	{
		$this->mysql = $this->load->database('mysql',true);
		$data['token'] = '';
		return $this->mysql->where('user_id',$id)->update('user',$data);
	}

	function checkCurrentPassword($password,$id){
		$this->mysql = $this->load->database('mysql',true);
		return $this->mysql->select('user_id')->from('user')->where([ 'password' => encrypt_string($password), 'user_id' => $id ])->get()->first_row('array');
		//echo $this->mysql->last_query();
	}

	//ravi created code starts here

	function getLiveLoneUserDataCount($userId){
		$this->mysql = $this->load->database('mysql',true);
		$query = $this->mysql->select('*')->from('live_lone_workers')->where([ 'user_id' => $userId ])->get();
		return $query->num_rows();
		//echo $this->mysql->last_query();
	}

	function insertLiveLoneUserData($data)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->insert_batch('live_lone_workers',$data);
	}

	function deleteLiveLoneUserData($userId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->delete('live_lone_workers', array('user_id' => $userId)); 
	}

	function getLiveLoneUserData($userId, $searchLastSignal, $searchtypeSignal, $searchSortBy){
		$this->mysql = $this->load->database('mysql',true);
		if ( $searchLastSignal && $searchtypeSignal ) {
			$searchLastSignal = "'". implode("', '", $searchLastSignal) ."'";
			$searchtypeSignal = "'". implode("', '", $searchtypeSignal) ."'";
			/*return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->where_in('DESCR', $searchLastSignal)
					->or_where_in('TYPE',$searchtypeSignal)
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();*/
			$SQL = "Select * from live_lone_workers where user_id = '" . $userId . "' AND (DESCR IN($searchLastSignal) AND TYPE IN($searchtypeSignal))" ;
			$query = $this->mysql->query($SQL);
			return $query->result_array();
		} elseif ($searchLastSignal) {
			return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->where_in('DESCR', $searchLastSignal)
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();
		} elseif ($searchtypeSignal) {
			return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->where_in('TYPE', $searchtypeSignal)
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();
		} else {
			return $this->mysql->select('*')
					->from('live_lone_workers')
					->where([ 'user_id' => $userId ])
					->order_by($searchSortBy[0], $searchSortBy[1])
					->get()
					->result_array();
		}
	}
	
	function get_user_billing_refrence()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('get_current_user_billing_refrence_number')->where(['id' => '1'])->get()->result_array();
	}
	
	function update_user_billing_refrence($setValue)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('id', '1');
		$this->mysql->set('current_number', $setValue);
		$this->mysql->update('get_current_user_billing_refrence_number');
	}
	
	function deleteLoginAttempts($userName)
	{
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->where('username', $userName);
		$this->mysql->delete('login_attempt');
	}	
	
	function getUserDetailsReport()
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('username, first_name, sur_name, costcentrename, contractareaname, 	officename')->from('user')->get()->result_array();
	}
	
	function insertAddedLoneWorkersData($data, $apiResponseMessage, $errorType) {
		$dataNew = [];
		$dataNew['name']  					= $data['name1'];
		$dataNew['phone'] 					= $data['number1'];
		$dataNew['unique_id'] 				= $data['uniqueId'];
		$dataNew['api_response_message']	= $apiResponseMessage;
		$dataNew['error_type']			    = $errorType;
		$this->mysql = $this->load->database('mysql', true);
		$this->mysql->insert('add_lone_worker_data',$dataNew);
	}
	
	function getAddedLoneWorkers($uniqueId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('add_lone_worker_data')->where(['unique_id' => $uniqueId])->get()->result_array();
	}
	
	function addedLoneWorkersErrorType($uniqueId)
	{
		$this->mysql = $this->load->database('mysql', true);
		return $this->mysql->select('*')->from('add_lone_worker_data')->where(['unique_id' => $uniqueId, 'error_type' => '1'])->get()->result_array();
	}
	
}
